//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SolutionSelfHelpClient contains the methods for the SolutionSelfHelp group.
// Don't use this type directly, use NewSolutionSelfHelpClient() instead.
type SolutionSelfHelpClient struct {
	internal *arm.Client
}

// NewSolutionSelfHelpClient creates a new instance of SolutionSelfHelpClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSolutionSelfHelpClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SolutionSelfHelpClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SolutionSelfHelpClient{
		internal: cl,
	}
	return client, nil
}

// Get - Gets Self Help Solutions for a given solutionId. Self Help Solutions consist of rich instructional video tutorials,
// links and guides to public documentation related to a specific problem that enables
// users to troubleshoot Azure issues.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - solutionID - SolutionId is a unique id to identify a solution. You can retrieve the solution id using the Discovery api
//     -
//     https://learn.microsoft.com/en-us/rest/api/help/discovery-solution/list?view=rest-help-2023-09-01-preview&tabs=HTTP
//   - options - SolutionSelfHelpClientGetOptions contains the optional parameters for the SolutionSelfHelpClient.Get method.
func (client *SolutionSelfHelpClient) Get(ctx context.Context, solutionID string, options *SolutionSelfHelpClientGetOptions) (SolutionSelfHelpClientGetResponse, error) {
	var err error
	const operationName = "SolutionSelfHelpClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, solutionID, options)
	if err != nil {
		return SolutionSelfHelpClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SolutionSelfHelpClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SolutionSelfHelpClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SolutionSelfHelpClient) getCreateRequest(ctx context.Context, solutionID string, options *SolutionSelfHelpClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Help/selfHelp/{solutionId}"
	if solutionID == "" {
		return nil, errors.New("parameter solutionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionId}", url.PathEscape(solutionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SolutionSelfHelpClient) getHandleResponse(resp *http.Response) (SolutionSelfHelpClientGetResponse, error) {
	result := SolutionSelfHelpClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SolutionResourceSelfHelp); err != nil {
		return SolutionSelfHelpClientGetResponse{}, err
	}
	return result, nil
}
