//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SolutionClient contains the methods for the Solution group.
// Don't use this type directly, use NewSolutionClient() instead.
type SolutionClient struct {
	internal *arm.Client
}

// NewSolutionClient creates a new instance of SolutionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSolutionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SolutionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SolutionClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreate - Creates a solution for the specific Azure resource or subscription using the inputs ‘solutionId and requiredInputs’
// from discovery solutions. Azure solutions comprise a comprehensive library of
// self-help resources that have been thoughtfully curated by Azure engineers to aid customers in resolving typical troubleshooting
// issues. These solutions encompass: (1.) Dynamic and context-aware
// diagnostics, guided troubleshooting wizards, and data visualizations. (2.) Rich instructional video tutorials and illustrative
// diagrams and images. (3.) Thoughtfully assembled textual troubleshooting
// instructions. All these components are seamlessly converged into unified solutions tailored to address a specific support
// problem area.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - solutionResourceName - Solution resource Name.
//   - solutionRequestBody - The required request body for this solution resource creation.
//   - options - SolutionClientBeginCreateOptions contains the optional parameters for the SolutionClient.BeginCreate method.
func (client *SolutionClient) BeginCreate(ctx context.Context, scope string, solutionResourceName string, solutionRequestBody SolutionResource, options *SolutionClientBeginCreateOptions) (*runtime.Poller[SolutionClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, scope, solutionResourceName, solutionRequestBody, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SolutionClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SolutionClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Creates a solution for the specific Azure resource or subscription using the inputs ‘solutionId and requiredInputs’
// from discovery solutions. Azure solutions comprise a comprehensive library of
// self-help resources that have been thoughtfully curated by Azure engineers to aid customers in resolving typical troubleshooting
// issues. These solutions encompass: (1.) Dynamic and context-aware
// diagnostics, guided troubleshooting wizards, and data visualizations. (2.) Rich instructional video tutorials and illustrative
// diagrams and images. (3.) Thoughtfully assembled textual troubleshooting
// instructions. All these components are seamlessly converged into unified solutions tailored to address a specific support
// problem area.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
func (client *SolutionClient) create(ctx context.Context, scope string, solutionResourceName string, solutionRequestBody SolutionResource, options *SolutionClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "SolutionClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, scope, solutionResourceName, solutionRequestBody, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *SolutionClient) createCreateRequest(ctx context.Context, scope string, solutionResourceName string, solutionRequestBody SolutionResource, options *SolutionClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if solutionResourceName == "" {
		return nil, errors.New("parameter solutionResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionResourceName}", url.PathEscape(solutionResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, solutionRequestBody); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Get the solution using the applicable solutionResourceName while creating the solution.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - solutionResourceName - Solution resource Name.
//   - options - SolutionClientGetOptions contains the optional parameters for the SolutionClient.Get method.
func (client *SolutionClient) Get(ctx context.Context, scope string, solutionResourceName string, options *SolutionClientGetOptions) (SolutionClientGetResponse, error) {
	var err error
	const operationName = "SolutionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, solutionResourceName, options)
	if err != nil {
		return SolutionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SolutionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SolutionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SolutionClient) getCreateRequest(ctx context.Context, scope string, solutionResourceName string, options *SolutionClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if solutionResourceName == "" {
		return nil, errors.New("parameter solutionResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionResourceName}", url.PathEscape(solutionResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SolutionClient) getHandleResponse(resp *http.Response) (SolutionClientGetResponse, error) {
	result := SolutionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SolutionResource); err != nil {
		return SolutionClientGetResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update the requiredInputs or additional information needed to execute the solution
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - solutionResourceName - Solution resource Name.
//   - solutionPatchRequestBody - The required request body for updating a solution resource.
//   - options - SolutionClientBeginUpdateOptions contains the optional parameters for the SolutionClient.BeginUpdate method.
func (client *SolutionClient) BeginUpdate(ctx context.Context, scope string, solutionResourceName string, solutionPatchRequestBody SolutionPatchRequestBody, options *SolutionClientBeginUpdateOptions) (*runtime.Poller[SolutionClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, scope, solutionResourceName, solutionPatchRequestBody, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SolutionClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SolutionClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update the requiredInputs or additional information needed to execute the solution
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
func (client *SolutionClient) update(ctx context.Context, scope string, solutionResourceName string, solutionPatchRequestBody SolutionPatchRequestBody, options *SolutionClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "SolutionClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, scope, solutionResourceName, solutionPatchRequestBody, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *SolutionClient) updateCreateRequest(ctx context.Context, scope string, solutionResourceName string, solutionPatchRequestBody SolutionPatchRequestBody, options *SolutionClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if solutionResourceName == "" {
		return nil, errors.New("parameter solutionResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionResourceName}", url.PathEscape(solutionResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, solutionPatchRequestBody); err != nil {
		return nil, err
	}
	return req, nil
}

// WarmUp - Warm up the solution resource by preloading asynchronous diagnostics results into cache
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - solutionResourceName - Solution resource Name.
//   - options - SolutionClientWarmUpOptions contains the optional parameters for the SolutionClient.WarmUp method.
func (client *SolutionClient) WarmUp(ctx context.Context, scope string, solutionResourceName string, options *SolutionClientWarmUpOptions) (SolutionClientWarmUpResponse, error) {
	var err error
	const operationName = "SolutionClient.WarmUp"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.warmUpCreateRequest(ctx, scope, solutionResourceName, options)
	if err != nil {
		return SolutionClientWarmUpResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SolutionClientWarmUpResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SolutionClientWarmUpResponse{}, err
	}
	return SolutionClientWarmUpResponse{}, nil
}

// warmUpCreateRequest creates the WarmUp request.
func (client *SolutionClient) warmUpCreateRequest(ctx context.Context, scope string, solutionResourceName string, options *SolutionClientWarmUpOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/solutions/{solutionResourceName}/warmup"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if solutionResourceName == "" {
		return nil, errors.New("parameter solutionResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionResourceName}", url.PathEscape(solutionResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.SolutionWarmUpRequestBody != nil {
		if err := runtime.MarshalAsJSON(req, *options.SolutionWarmUpRequestBody); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}
