//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/ListSecureScoreControlsForName_builtin_example.json
func ExampleSecureScoreControlsClient_NewListBySecureScorePager_getSecurityControlsAndTheirCurrentScoreForTheSpecifiedInitiative() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSecureScoreControlsClient().NewListBySecureScorePager("ascScore", &armsecurity.SecureScoreControlsClientListBySecureScoreOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SecureScoreControlList = armsecurity.SecureScoreControlList{
		// 	Value: []*armsecurity.SecureScoreControlDetails{
		// 		{
		// 			Name: to.Ptr("a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Protect applications against DDoS attacks"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable MFA"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](10),
		// 					Max: to.Ptr[int32](10),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Implement security best practices"),
		// 				HealthyResourceCount: to.Ptr[int32](7),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](7),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable Advanced Threat Protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable auditing and logging"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0.2),
		// 					Max: to.Ptr[int32](1),
		// 					Percentage: to.Ptr[float64](0.2),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](4),
		// 				Weight: to.Ptr[int64](5),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Manage access and permissions"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](2),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.5),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](2),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Remediate security configurations"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable endpoint protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](2),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Apply system updates"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](6),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0e55495e-034f-4abc-8293-767229250176"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/0e55495e-034f-4abc-8293-767229250176"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Encrypt data in transit"),
		// 				HealthyResourceCount: to.Ptr[int32](5),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](3.33),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.8325),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](6),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Restrict unauthorized network access"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable encryption at rest"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/ListSecureScoreControlsForNameWithExpand_builtin_example.json
func ExampleSecureScoreControlsClient_NewListBySecureScorePager_getSecurityControlsAndTheirCurrentScoreForTheSpecifiedInitiativeWithTheExpandParameter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSecureScoreControlsClient().NewListBySecureScorePager("ascScore", &armsecurity.SecureScoreControlsClientListBySecureScoreOptions{Expand: to.Ptr(armsecurity.ExpandControlsEnumDefinition)})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SecureScoreControlList = armsecurity.SecureScoreControlList{
		// 	Value: []*armsecurity.SecureScoreControlDetails{
		// 		{
		// 			Name: to.Ptr("a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("a9909064-42b4-4d34-8143-275477afe18b"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/a9909064-42b4-4d34-8143-275477afe18b"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e3de1cc0-f4dd-3b34-e496-8b5381ba2d70"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/08e628db-e2ed-4793-bc91-d13e684401c3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/405c9ae6-49f9-46c4-8873-a86690f27818"),
		// 						}},
		// 						DisplayName: to.Ptr("Protect applications against DDoS attacks"),
		// 						MaxScore: to.Ptr[int32](2),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Protect applications against DDoS attacks"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/94290b00-4d0c-d7b4-7cea-064a9554e681"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/57e98606-6b1e-6193-0e3d-fe621387c16b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1f24d55a-df0f-4772-9090-4629c2d6bfff"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8e3d9ac0-a248-4276-a437-304c6cd1443b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8d7a6128-c8f2-43df-b422-7877346f9ddb"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dbfc99e3-e648-4c3b-bd32-995e6268430d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/4a946e22-47e8-443d-8761-b25620b4a1e1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a7c8fa46-526d-4bf6-b8b3-17fa01310fd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/20f6c761-4dd7-4f27-9e37-6db8471486ef"),
		// 						}},
		// 						DisplayName: to.Ptr("Enable MFA"),
		// 						MaxScore: to.Ptr[int32](10),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Enable MFA"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](10),
		// 					Max: to.Ptr[int32](10),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("76763537-9feb-42d3-b4f4-78c01117be80"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/76763537-9feb-42d3-b4f4-78c01117be80"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/151e82c5-5341-a74b-1eb0-bc38d2c84bb5"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a8c6a4ad-d51e-88fe-2979-d3ee3c864f8b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/6f90a6d6-d4d6-0794-0ec1-98fa77878c2e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a9341235-9389-42f0-a0bf-9bfb57960d44"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/45d313c3-3fca-5040-035f-d61928366d31"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f0553104-cfdb-65e6-759c-002812e38500"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/47bb383c-8e25-95f0-c2aa-437add1d87d3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/12018f4f-3d10-999b-e4c4-86ec25be08a1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/eade5b56-eefd-444f-95c8-23f29e5d93cb"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ebe970fe-9c27-4dd7-a165-1e943d565e10"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f7010359-8d21-4598-a9f2-c3e81a17141e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/24d8af06-d441-40b4-a49c-311421aa9f58"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8c3e93d3-0276-4d06-b20a-9a9f3012742c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9172da4e-9571-6e33-2b5b-d742847f3be7"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/093c685b-56dd-13a3-8ed5-887a001837a2"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/64b8637e-4e1d-76a9-0fc9-c1e487a97ed8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/fe02b3b7-a722-d4d6-6731-6493776203a6"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/57f36d21-69e3-4b0f-a66c-18629d1b736d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/6c99f570-2ce7-46bc-8175-cde013df43bc"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/22489c48-27d1-4e40-9420-4303ad9cffef"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/fc84abc0-eee6-4758-8372-a7681965ca44"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/726cde3e-02f8-4041-8935-727f2be19ba7"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a2bb3a1b-4a09-4cf7-9e79-c438687e2c2f"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/664c6a0b-5cd2-4140-aaff-a94241c07afd"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3af5de46-fda8-4b6e-90f1-6565187d7c48"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a9a59ebb-5d6f-42f5-92a1-036fd0fd1879"),
		// 						}},
		// 						DisplayName: to.Ptr("Implement security best practices"),
		// 						MaxScore: to.Ptr[int32](0),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Implement security best practices"),
		// 				HealthyResourceCount: to.Ptr[int32](7),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](7),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/56a6e81f-7413-4f72-9a1b-aaeeaa87c872"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0876ef51-fee7-449d-ba1e-f2662c7e43c6"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/58d72d9d-0310-4792-9a3b-6dd111093cdb"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/6ac66a74-761f-4a59-928a-d373eea3f028"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1be22853-8ed1-4005-9907-ddad64cb1417"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/86ea1a79-29d3-4eac-a9f4-3541ace4e718"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/53572822-d3fc-4363-bfb9-248645841612"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b1af52e4-e968-4e2b-b6d0-6736c9651f0a"),
		// 						}},
		// 						DisplayName: to.Ptr("Enable Advanced Threat Protection"),
		// 						MaxScore: to.Ptr[int32](0),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Enable Advanced Threat Protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/94208a8b-16e8-4e5b-abbd-4e81c9d02bee"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c6dad669-efd7-cd72-61c5-289935607791"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/77785808-ce86-4e40-b45f-19110a547397"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/32771b45-220c-1a8b-584e-fdd5a2584a66"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f11b27f2-8c49-5bb4-eff5-e1e5384bf95e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f19ab7d9-5ff2-f8fd-ab3b-0bf95dcb6889"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ad5bbaeb-7632-5edf-f1c2-752075831ce8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dea5192e-1bb3-101b-b70c-4646546f5e1e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1597605a-0faf-5860-eb74-462ae2e9fc21"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/91387f44-7e43-4ecc-55f0-46f5adee3dd5"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/961eb649-3ea9-f8c2-6595-88e9a3aeedeb"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/88bbc99c-e5af-ddd7-6105-6150b2bfa519"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/22438e3c-73c8-40af-a083-10c980c63aa2"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5720f1a6-6061-4768-9c0d-2000a6041744"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dbfc99e3-e648-4c3b-bd32-995e6268430d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/30c69b23-a9a2-4729-aca6-f21adacfff66"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a9ac48d8-8dd7-42b9-9752-b1fa70ea5dd9"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/00261067-76a8-4ebb-b5fc-becc81067bee"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/83ca4867-58c1-45d6-b6b6-dbf226512891"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a269cbdb-86e8-431c-9ff2-f0ea491174d8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5ea59e47-093b-446f-9765-5b0ec4c9da61"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/011397ca-1366-4bcc-b85a-7a5e3df2e80b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c62371bc-f6a7-4915-b5b5-14288682cf79"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/293ba336-7312-42fc-a59d-836e4e678b17"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0b547a38-2c0d-47e1-b9a2-a59fccc140db"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/7d0ad86f-f43b-4889-b2f7-09d91bd1407b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b20558b6-de31-480c-8aa0-e920d62b9764"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/022efc2d-5119-480b-a203-e151b6b2645c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3ee7608e-f0e7-4c26-8921-5ae46c4e99df"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/33765629-073d-49eb-bab4-64bdf8ac90da"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9c054f50-823f-45ab-839e-9df4eb7c2f11"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f61e15f3-4bcf-4d2e-8f06-32237cabe0a0"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/cdb3af55-2abf-476b-aac7-5cfec366a4dd"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bc26b0d4-a1d7-4665-9d44-efc205ae73f0"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3812e247-34f2-4f06-a312-89a8fe51fa37"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f0f8405a-5ecc-4314-808e-083e030d6163"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c23e0eec-eee4-4632-b1c2-6c884c3c963b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/7ce5a01f-e94b-438a-8b72-fa02c076f11a"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/46e4e0ed-106d-405e-b1a9-ca34c8f7d31f"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b1294b0d-9b2e-4e1b-9f67-77a75fb10a65"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0b86a67f-bde5-4c91-b10c-4102033b8692"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3d55e4b1-ecdb-4eaf-9e3f-b00a764182bd"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a7c8fa46-526d-4bf6-b8b3-17fa01310fd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/20f6c761-4dd7-4f27-9e37-6db8471486ef"),
		// 						}},
		// 						DisplayName: to.Ptr("Enable auditing and logging"),
		// 						MaxScore: to.Ptr[int32](1),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Enable auditing and logging"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0.2),
		// 					Max: to.Ptr[int32](1),
		// 					Percentage: to.Ptr[float64](0.2),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](4),
		// 				Weight: to.Ptr[int64](5),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c3b6ae71-f1f0-31b4-e6c1-d5951285d03d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/04e7147b-0deb-9796-2e5c-0336343ceb3d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e52064aa-6853-e252-a11e-dffc675689c2"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/00c6d40b-e990-6acf-d4f3-471e747a27c4"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/2c79b4af-f830-b61e-92b9-63dfa30f16e4"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b0fdc63a-38e7-4bab-a7c4-2c2665abbaa9"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/03afeb6f-7634-adb3-0a01-803b0b9cb611"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9d07b7e6-2986-4964-a76c-b2689604e212"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/08e628db-e2ed-4793-bc91-d13e684401c3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5d90913f-a1c5-4429-ad54-2c6c17fb3c73"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/582c14e9-48c1-4b25-ab93-91bdeaf9120c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8a10942a-02ca-483f-81ae-2260ea7808cc"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9b8eac17-6b11-4b94-9bb4-18c81aee7123"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/554ba13c-d7d4-4530-88ce-94cf11a670ce"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/66a1d478-4d24-42d4-8eca-dcdab6532a18"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b396f112-a462-4813-a93f-80bc90041e4d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5425052d-cc0d-4424-af71-050311f99634"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/09cb7d54-db05-4d31-97f3-9bbfe1dff610"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/01fb1ad4-303b-4789-abf2-c024c4a76523"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0de072b9-6515-4985-842e-0318047bb85b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8c3f474a-234e-442f-92b3-2a45e37f7eee"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c55461af-4923-4fbb-b270-40d5e5f4c0ff"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bbdc4999-1462-4d46-853b-2f8c6ca1c682"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9e1f12d0-cb3d-4e1c-a468-6bc3d934c99d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/fd5d38f6-340e-4bd2-88f2-e1314c3c07a9"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0384d5b7-5def-4130-b7b5-db7da7e63276"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dbfc99e3-e648-4c3b-bd32-995e6268430d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0ad39832-f031-4fdd-885e-c6cce85ac77c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/90191798-da1b-40dd-aa9c-1c0eafb1ba87"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ddced3c8-a5e2-4dc4-b0fe-1331c77fc9c4"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/52f83ea2-6871-45c3-8b26-13566e966638"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/79b4eb34-c06e-49bf-883d-5352a21a962f"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5723400d-5b2a-45f1-99ee-837986866318"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/76e8881d-f18e-4e1b-b01d-376d0260e066"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0eaf40a8-5673-4b33-8457-a31d85882233"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5a235918-41a2-4bd0-8ab0-00a596e9d6a8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3ff38dcd-92e2-4b67-8765-35bb0174a4c7"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1ff4501b-2109-4ef6-ba9d-e824a96d63d0"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f493084a-d3c4-4886-8cf2-3c815aeef901"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a7c8fa46-526d-4bf6-b8b3-17fa01310fd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/20f6c761-4dd7-4f27-9e37-6db8471486ef"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/11c95609-3553-430d-b788-fd41cde8b2db"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/27d6f0e9-b4d5-468b-ae7e-03d5473fd864"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f0debc84-981c-4a0d-924d-aa4bd7d55fef"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9b795646-9130-41a4-90b7-df9eae2437c8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/802c0637-5a8c-4c98-abd7-7c96d89d6010"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/43dc2a2e-ce69-4d42-923e-ab7d136f2cfe"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/2acd365d-e8b5-4094-bce4-244b7c51d67c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/51fd8bb1-0db4-bbf1-7e2b-cfcba7eb66a6"),
		// 						}},
		// 						DisplayName: to.Ptr("Manage access and permissions"),
		// 						MaxScore: to.Ptr[int32](4),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Manage access and permissions"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](2),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.5),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](2),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d1db3318-01ff-16de-29eb-28b344515626"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e7ee30c4-bac9-2966-54bd-2023a4282872"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/27ac71b1-75c5-41c2-adc2-858f5db45b08"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/720a3e77-0b9a-4fa9-98b6-ddf0fd7e32c1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8e2b96ff-3de2-289b-b5c1-3b9921a3441e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/181ac480-f7c4-544b-9865-11b8ffe87f47"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8c3d9ad0-3639-4686-9cd2-2b2ab2609bda"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0677209d-e675-2c6f-e91a-54cef2878663"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a3eee263-aa01-4b52-a7c0-0094578ef48f"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/45cfe080-ceb1-a91e-9743-71551ed24e94"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8941d121-f740-35f6-952c-6561d2b38d36"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0396b18c-41aa-489c-affd-4ee5d1714a59"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/fa924a53-0837-4296-9bf7-18ce7dd68593"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9e1789cd-7b61-42db-ba12-7268283ba466"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/233da9cd-11bf-463a-8aa7-4c81b9e788d1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c4131c22-1ecc-4beb-9961-d90108bd975f"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d74d2738-2485-4103-9919-69c7e63776ec"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5f65e47f-7a00-4bf3-acae-90ee441ee876"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bc85a7ee-7f43-47ab-8736-4faaec9346b5"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/08e628db-e2ed-4793-bc91-d13e684401c3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/86f91051-9d6a-47c3-a07f-bd14cb214b45"),
		// 						}},
		// 						DisplayName: to.Ptr("Remediate security configurations"),
		// 						MaxScore: to.Ptr[int32](4),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Remediate security configurations"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d1db3318-01ff-16de-29eb-28b344515626"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e7ee30c4-bac9-2966-54bd-2023a4282872"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/27ac71b1-75c5-41c2-adc2-858f5db45b08"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/720a3e77-0b9a-4fa9-98b6-ddf0fd7e32c1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8e2b96ff-3de2-289b-b5c1-3b9921a3441e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/83f577bd-a1b6-b7e1-0891-12ca19d1e6df"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/4fb67663-9ab9-475d-b026-8c544cced439"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/383cf3bc-fdf9-4a02-120a-3e7e36c6bfee"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3bcd234d-c9c7-c2a2-89e0-c01f419c1a8a"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/37a3689a-818e-4a0e-82ac-b1392b9bb000"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/45cfe080-ceb1-a91e-9743-71551ed24e94"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/21300918-b2e3-0346-785f-c77ff57d243b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e71020c2-860c-3235-cd39-04f3f8c936d2"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bc85a7ee-7f43-47ab-8736-4faaec9346b5"),
		// 						}},
		// 						DisplayName: to.Ptr("Enable endpoint protection"),
		// 						MaxScore: to.Ptr[int32](2),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Enable endpoint protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](2),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d1db3318-01ff-16de-29eb-28b344515626"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e7ee30c4-bac9-2966-54bd-2023a4282872"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/27ac71b1-75c5-41c2-adc2-858f5db45b08"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/720a3e77-0b9a-4fa9-98b6-ddf0fd7e32c1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8e2b96ff-3de2-289b-b5c1-3b9921a3441e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/4ab6e3c5-74dd-8b35-9ab9-f61b30875b27"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f2805ebc-abc2-4aac-a8d6-35664c479971"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c0f5316d-5ac5-9218-b77a-b96e16ccfd66"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/45cfe080-ceb1-a91e-9743-71551ed24e94"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bd20bd91-aaf1-7f14-b6e4-866de2f43146"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/8bc390da-9eb6-938d-25ed-44a35d9bcc9d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/22e18b64-4576-41e6-8972-0eb28c9af0c8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bc85a7ee-7f43-47ab-8736-4faaec9346b5"),
		// 						}},
		// 						DisplayName: to.Ptr("Apply system updates"),
		// 						MaxScore: to.Ptr[int32](6),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Apply system updates"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](6),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0e55495e-034f-4abc-8293-767229250176"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/0e55495e-034f-4abc-8293-767229250176"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("0e55495e-034f-4abc-8293-767229250176"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/0e55495e-034f-4abc-8293-767229250176"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1b351b29-41ca-6df5-946c-c190a56be5fe"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/cb0acdc6-0846-fd48-debe-9905af151b6d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/bf82a334-13b6-ca57-ea75-096fc2ffce50"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/35b25be2-d08a-e340-45ed-f08a95d804fc"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1c5de8e1-f68d-6a17-e0d2-ec259c42768c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a3ebc80a-847b-46d5-a37d-8dca5e6947df"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c28a89d9-7cf4-439b-a8c4-ad4e769f68ee"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/2acc27c6-5fdb-405e-9080-cb66b850c8f5"),
		// 						}},
		// 						DisplayName: to.Ptr("Encrypt data in transit"),
		// 						MaxScore: to.Ptr[int32](4),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Encrypt data in transit"),
		// 				HealthyResourceCount: to.Ptr[int32](5),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](3.33),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.8325),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](6),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/483f12ed-ae23-447e-a2de-a67a10db4353"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3b20e985-f71f-483b-b078-f30d73936d43"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f9f0eed0-f143-47bf-b856-671ea2eeed62"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1a2b5b4c-f80d-46e7-ac81-b51a9fb363de"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c3b51c94-588b-426b-a892-24696f9e54cc"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e40df93c-7a7c-1b0a-c787-9987ceb98e54"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/7b3d4796-9400-2904-692b-4a5ede7f0a1e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/df4d1739-47f0-60c7-1706-3731fea6ab03"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1a36f14a-8bd8-45f5-abe5-eef88d76ab5b"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/beb62be3-5e78-49bd-ac5f-099250ef3c7c"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ba975338-f956-41e7-a9f2-7614832d382d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d5a8d84a-9ad0-42e2-80e0-d38e3d46028a"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5a3d6cdd-8eb3-46d2-ba11-d24a0d47fe65"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d8326952-60bb-40fb-b33f-51e662708a88"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/08e628db-e2ed-4793-bc91-d13e684401c3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/5f88450f-9546-4b78-a181-a2d9162bb441"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/add45209-73f6-4fa5-a5a5-74a451b07fbe"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dbfc99e3-e648-4c3b-bd32-995e6268430d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b3473ed6-78c0-40d5-b5f0-674e98924952"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/9dd55566-33b9-4c07-a959-14794ce02355"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ad0b04b9-eaf9-49f8-b85e-724f9520e760"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ece6ec5d-a862-4e22-a8db-271661216018"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/e40b679a-f44e-4366-87dd-7693e16a2128"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0bdcd23c-4ff2-4077-aa14-eb6950bfbdd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/1f386f4e-449e-41e8-b829-a2fe01086ae1"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/2f6c8a5a-9407-467c-8082-0ad4ab915d77"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3b1713ec-feb3-4b32-b5b0-251acff0a84a"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/049f1551-438b-444e-8904-a3c3afbcb43e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/684307e9-62a8-4f2a-887a-4b90de5e4b98"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/0327f9da-f758-4d69-8903-55448b8cf70e"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/cc637123-c11e-40ee-adf8-93c0876481f4"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a7c8fa46-526d-4bf6-b8b3-17fa01310fd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/20f6c761-4dd7-4f27-9e37-6db8471486ef"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/ebc68898-5c0f-4353-a426-4a5f1e737b12"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/f67fb4ed-d481-44d7-91e5-efadf504f74a"),
		// 						}},
		// 						DisplayName: to.Ptr("Restrict unauthorized network access"),
		// 						MaxScore: to.Ptr[int32](4),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Restrict unauthorized network access"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				Definition: &armsecurity.SecureScoreControlDefinitionItem{
		// 					Name: to.Ptr("8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 					Type: to.Ptr("Microsoft.Security/secureScoreControlDefinitions"),
		// 					ID: to.Ptr("/providers/Microsoft.Security/secureScoreControlDefinitions/8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 					Properties: &armsecurity.SecureScoreControlDefinitionItemProperties{
		// 						AssessmentDefinitions: []*armsecurity.AzureResourceLink{
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/d57a4221-a804-52ca-3dea-768284f06bb7"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/651967bf-044e-4bde-8376-3e08e0600105"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/b12bc79e-4f12-44db-acda-571820191ddc"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/7f04fc0c-4a3d-5c7e-ce19-666cb871b510"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/dbfc99e3-e648-4c3b-bd32-995e6268430d"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/c01fab9f-bde1-4ba5-9d35-7de51f31c2d3"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/23b514bd-2afc-4a3e-8d3d-f4327118eee9"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/3053474d-4fab-4603-8d18-2a6dfd09f782"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/6be98232-0100-474a-b33d-ba9c1a747f70"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/a7c8fa46-526d-4bf6-b8b3-17fa01310fd8"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/providers/Microsoft.Security/assessmentMetadata/20f6c761-4dd7-4f27-9e37-6db8471486ef"),
		// 						}},
		// 						DisplayName: to.Ptr("Enable encryption at rest"),
		// 						MaxScore: to.Ptr[int32](4),
		// 						Source: &armsecurity.SecureScoreControlDefinitionSource{
		// 							SourceType: to.Ptr(armsecurity.ControlTypeBuiltIn),
		// 						},
		// 					},
		// 				},
		// 				DisplayName: to.Ptr("Enable encryption at rest"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/ListSecureScoreControls_example.json
func ExampleSecureScoreControlsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSecureScoreControlsClient().NewListPager(&armsecurity.SecureScoreControlsClientListOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SecureScoreControlList = armsecurity.SecureScoreControlList{
		// 	Value: []*armsecurity.SecureScoreControlDetails{
		// 		{
		// 			Name: to.Ptr("a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/a9909064-42b4-4d34-8143-275477afe18b"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Protect applications against DDoS attacks"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/34a42fb3-e6db-409c-b56b-7b1db6b8aee0"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable MFA"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](10),
		// 					Max: to.Ptr[int32](10),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/76763537-9feb-42d3-b4f4-78c01117be80"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Implement security best practices"),
		// 				HealthyResourceCount: to.Ptr[int32](7),
		// 				NotApplicableResourceCount: to.Ptr[int32](1),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](7),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/4db8d6cf-075b-4149-a813-da09ca2ae120"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable Advanced Threat Protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](0),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/27b24961-75ba-4fe4-8909-97286d5dd5ee"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable auditing and logging"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0.2),
		// 					Max: to.Ptr[int32](1),
		// 					Percentage: to.Ptr[float64](0.2),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](4),
		// 				Weight: to.Ptr[int64](5),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/2d85f639-0bea-4a4a-b6c6-608952a1414a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Manage access and permissions"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](2),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.5),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](2),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/99fc8df2-e0f5-40f8-9415-a7f7ca948b5a"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Remediate security configurations"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/12136bd9-dc24-44f2-9587-7be3af6aac14"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable endpoint protection"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](2),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/61702b76-1fab-41f2-bcbc-50b7870dcf38"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Apply system updates"),
		// 				HealthyResourceCount: to.Ptr[int32](0),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](0),
		// 					Max: to.Ptr[int32](6),
		// 					Percentage: to.Ptr[float64](0),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0e55495e-034f-4abc-8293-767229250176"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/0e55495e-034f-4abc-8293-767229250176"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Encrypt data in transit"),
		// 				HealthyResourceCount: to.Ptr[int32](5),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](3.33),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](0.8325),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](1),
		// 				Weight: to.Ptr[int64](6),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/f9d5432b-8f7b-45e9-b90c-e214a30f6a02"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Restrict unauthorized network access"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Type: to.Ptr("Microsoft.Security/secureScores/secureScoreControls"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/secureScores/ascScore/secureScoreControls/8fd574ec-43cf-426e-a439-a67cbaf2d564"),
		// 			Properties: &armsecurity.SecureScoreControlScoreDetails{
		// 				DisplayName: to.Ptr("Enable encryption at rest"),
		// 				HealthyResourceCount: to.Ptr[int32](1),
		// 				NotApplicableResourceCount: to.Ptr[int32](0),
		// 				Score: &armsecurity.ScoreDetails{
		// 					Current: to.Ptr[float64](4),
		// 					Max: to.Ptr[int32](4),
		// 					Percentage: to.Ptr[float64](1),
		// 				},
		// 				UnhealthyResourceCount: to.Ptr[int32](0),
		// 				Weight: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}
