//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// ServerVulnerabilityAssessmentsSettingsServer is a fake server for instances of the armsecurity.ServerVulnerabilityAssessmentsSettingsClient type.
type ServerVulnerabilityAssessmentsSettingsServer struct {
	// CreateOrUpdate is the fake for method ServerVulnerabilityAssessmentsSettingsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, settingKind armsecurity.ServerVulnerabilityAssessmentsSettingKindName, serverVulnerabilityAssessmentsSetting armsecurity.ServerVulnerabilityAssessmentsSettingClassification, options *armsecurity.ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ServerVulnerabilityAssessmentsSettingsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, settingKind armsecurity.ServerVulnerabilityAssessmentsSettingKindName, options *armsecurity.ServerVulnerabilityAssessmentsSettingsClientDeleteOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerVulnerabilityAssessmentsSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, settingKind armsecurity.ServerVulnerabilityAssessmentsSettingKindName, options *armsecurity.ServerVulnerabilityAssessmentsSettingsClientGetOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySubscriptionPager is the fake for method ServerVulnerabilityAssessmentsSettingsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armsecurity.ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse])
}

// NewServerVulnerabilityAssessmentsSettingsServerTransport creates a new instance of ServerVulnerabilityAssessmentsSettingsServerTransport with the provided implementation.
// The returned ServerVulnerabilityAssessmentsSettingsServerTransport instance is connected to an instance of armsecurity.ServerVulnerabilityAssessmentsSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerVulnerabilityAssessmentsSettingsServerTransport(srv *ServerVulnerabilityAssessmentsSettingsServer) *ServerVulnerabilityAssessmentsSettingsServerTransport {
	return &ServerVulnerabilityAssessmentsSettingsServerTransport{
		srv:                        srv,
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse]](),
	}
}

// ServerVulnerabilityAssessmentsSettingsServerTransport connects instances of armsecurity.ServerVulnerabilityAssessmentsSettingsClient to instances of ServerVulnerabilityAssessmentsSettingsServer.
// Don't use this type directly, use NewServerVulnerabilityAssessmentsSettingsServerTransport instead.
type ServerVulnerabilityAssessmentsSettingsServerTransport struct {
	srv                        *ServerVulnerabilityAssessmentsSettingsServer
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armsecurity.ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ServerVulnerabilityAssessmentsSettingsServerTransport.
func (s *ServerVulnerabilityAssessmentsSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerVulnerabilityAssessmentsSettingsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "ServerVulnerabilityAssessmentsSettingsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ServerVulnerabilityAssessmentsSettingsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerVulnerabilityAssessmentsSettingsClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsSettingsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessmentsSettings/(?P<settingKind>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalServerVulnerabilityAssessmentsSettingClassification(raw)
	if err != nil {
		return nil, err
	}
	settingKindParam, err := parseWithCast(matches[regex.SubexpIndex("settingKind")], func(v string) (armsecurity.ServerVulnerabilityAssessmentsSettingKindName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.ServerVulnerabilityAssessmentsSettingKindName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), settingKindParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessmentsSettingClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsSettingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessmentsSettings/(?P<settingKind>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	settingKindParam, err := parseWithCast(matches[regex.SubexpIndex("settingKind")], func(v string) (armsecurity.ServerVulnerabilityAssessmentsSettingKindName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.ServerVulnerabilityAssessmentsSettingKindName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), settingKindParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessmentsSettings/(?P<settingKind>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	settingKindParam, err := parseWithCast(matches[regex.SubexpIndex("settingKind")], func(v string) (armsecurity.ServerVulnerabilityAssessmentsSettingKindName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.ServerVulnerabilityAssessmentsSettingKindName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), settingKindParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessmentsSettingClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentsSettingsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessmentsSettings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armsecurity.ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
