//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicessiterecovery

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type A2AAddDisksInput.
func (a A2AAddDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AAddDisksInput.
func (a *A2AAddDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AApplyRecoveryPointInput.
func (a A2AApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AApplyRecoveryPointInput.
func (a *A2AApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AContainerCreationInput.
func (a A2AContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AContainerCreationInput.
func (a *A2AContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AContainerMappingInput.
func (a A2AContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AContainerMappingInput.
func (a *A2AContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACreateProtectionIntentInput.
func (a A2ACreateProtectionIntentInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "autoProtectionOfDataDisk", a.AutoProtectionOfDataDisk)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "primaryLocation", a.PrimaryLocation)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "protectionProfileCustomInput", a.ProtectionProfileCustomInput)
	populate(objectMap, "recoveryAvailabilitySetCustomInput", a.RecoveryAvailabilitySetCustomInput)
	populate(objectMap, "recoveryAvailabilityType", a.RecoveryAvailabilityType)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryBootDiagStorageAccount", a.RecoveryBootDiagStorageAccount)
	populate(objectMap, "recoveryLocation", a.RecoveryLocation)
	populate(objectMap, "recoveryProximityPlacementGroupCustomInput", a.RecoveryProximityPlacementGroupCustomInput)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoverySubscriptionId", a.RecoverySubscriptionID)
	populate(objectMap, "recoveryVirtualNetworkCustomInput", a.RecoveryVirtualNetworkCustomInput)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACreateProtectionIntentInput.
func (a *A2ACreateProtectionIntentInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "primaryLocation":
			err = unpopulate(val, "PrimaryLocation", &a.PrimaryLocation)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "protectionProfileCustomInput":
			a.ProtectionProfileCustomInput, err = unmarshalProtectionProfileCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetCustomInput":
			a.RecoveryAvailabilitySetCustomInput, err = unmarshalRecoveryAvailabilitySetCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilityType":
			err = unpopulate(val, "RecoveryAvailabilityType", &a.RecoveryAvailabilityType)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccount":
			a.RecoveryBootDiagStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryLocation":
			err = unpopulate(val, "RecoveryLocation", &a.RecoveryLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupCustomInput":
			a.RecoveryProximityPlacementGroupCustomInput, err = unmarshalRecoveryProximityPlacementGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubscriptionId":
			err = unpopulate(val, "RecoverySubscriptionID", &a.RecoverySubscriptionID)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkCustomInput":
			a.RecoveryVirtualNetworkCustomInput, err = unmarshalRecoveryVirtualNetworkCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a A2ACrossClusterMigrationApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a *A2ACrossClusterMigrationApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a A2ACrossClusterMigrationContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a *A2ACrossClusterMigrationContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationEnableProtectionInput.
func (a A2ACrossClusterMigrationEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationEnableProtectionInput.
func (a *A2ACrossClusterMigrationEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a A2ACrossClusterMigrationPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a *A2ACrossClusterMigrationPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationReplicationDetails.
func (a A2ACrossClusterMigrationReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	populate(objectMap, "lifecycleId", a.LifecycleID)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "primaryFabricLocation", a.PrimaryFabricLocation)
	populate(objectMap, "vmProtectionState", a.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", a.VMProtectionStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationReplicationDetails.
func (a *A2ACrossClusterMigrationReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "lifecycleId":
			err = unpopulate(val, "LifecycleID", &a.LifecycleID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &a.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &a.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AEnableProtectionInput.
func (a A2AEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoProtectionOfDataDisk", a.AutoProtectionOfDataDisk)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryAzureNetworkId", a.RecoveryAzureNetworkID)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryExtendedLocation", a.RecoveryExtendedLocation)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoverySubnetName", a.RecoverySubnetName)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AEnableProtectionInput.
func (a *A2AEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryAzureNetworkId":
			err = unpopulate(val, "RecoveryAzureNetworkID", &a.RecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &a.RecoverySubnetName)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AEventDetails.
func (a A2AEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricLocation", a.FabricLocation)
	populate(objectMap, "fabricName", a.FabricName)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "protectedItemName", a.ProtectedItemName)
	populate(objectMap, "remoteFabricLocation", a.RemoteFabricLocation)
	populate(objectMap, "remoteFabricName", a.RemoteFabricName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AEventDetails.
func (a *A2AEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &a.FabricLocation)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &a.FabricName)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &a.ProtectedItemName)
			delete(rawMsg, key)
		case "remoteFabricLocation":
			err = unpopulate(val, "RemoteFabricLocation", &a.RemoteFabricLocation)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &a.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AExtendedLocationDetails.
func (a A2AExtendedLocationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryExtendedLocation", a.PrimaryExtendedLocation)
	populate(objectMap, "recoveryExtendedLocation", a.RecoveryExtendedLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AExtendedLocationDetails.
func (a *A2AExtendedLocationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &a.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AFabricSpecificLocationDetails.
func (a A2AFabricSpecificLocationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialPrimaryExtendedLocation", a.InitialPrimaryExtendedLocation)
	populate(objectMap, "initialPrimaryFabricLocation", a.InitialPrimaryFabricLocation)
	populate(objectMap, "initialPrimaryZone", a.InitialPrimaryZone)
	populate(objectMap, "initialRecoveryExtendedLocation", a.InitialRecoveryExtendedLocation)
	populate(objectMap, "initialRecoveryFabricLocation", a.InitialRecoveryFabricLocation)
	populate(objectMap, "initialRecoveryZone", a.InitialRecoveryZone)
	populate(objectMap, "primaryExtendedLocation", a.PrimaryExtendedLocation)
	populate(objectMap, "primaryFabricLocation", a.PrimaryFabricLocation)
	populate(objectMap, "primaryZone", a.PrimaryZone)
	populate(objectMap, "recoveryExtendedLocation", a.RecoveryExtendedLocation)
	populate(objectMap, "recoveryFabricLocation", a.RecoveryFabricLocation)
	populate(objectMap, "recoveryZone", a.RecoveryZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AFabricSpecificLocationDetails.
func (a *A2AFabricSpecificLocationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialPrimaryExtendedLocation":
			err = unpopulate(val, "InitialPrimaryExtendedLocation", &a.InitialPrimaryExtendedLocation)
			delete(rawMsg, key)
		case "initialPrimaryFabricLocation":
			err = unpopulate(val, "InitialPrimaryFabricLocation", &a.InitialPrimaryFabricLocation)
			delete(rawMsg, key)
		case "initialPrimaryZone":
			err = unpopulate(val, "InitialPrimaryZone", &a.InitialPrimaryZone)
			delete(rawMsg, key)
		case "initialRecoveryExtendedLocation":
			err = unpopulate(val, "InitialRecoveryExtendedLocation", &a.InitialRecoveryExtendedLocation)
			delete(rawMsg, key)
		case "initialRecoveryFabricLocation":
			err = unpopulate(val, "InitialRecoveryFabricLocation", &a.InitialRecoveryFabricLocation)
			delete(rawMsg, key)
		case "initialRecoveryZone":
			err = unpopulate(val, "InitialRecoveryZone", &a.InitialRecoveryZone)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &a.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "primaryZone":
			err = unpopulate(val, "PrimaryZone", &a.PrimaryZone)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryFabricLocation":
			err = unpopulate(val, "RecoveryFabricLocation", &a.RecoveryFabricLocation)
			delete(rawMsg, key)
		case "recoveryZone":
			err = unpopulate(val, "RecoveryZone", &a.RecoveryZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2APolicyCreationInput.
func (a A2APolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", a.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", a.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmSyncStatus", a.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", a.RecoveryPointHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2APolicyCreationInput.
func (a *A2APolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &a.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &a.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &a.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &a.RecoveryPointHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2APolicyDetails.
func (a A2APolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", a.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", a.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmSyncStatus", a.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", a.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", a.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2APolicyDetails.
func (a *A2APolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &a.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &a.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &a.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &a.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &a.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectedDiskDetails.
func (a A2AProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedDiskLevelOperation", a.AllowedDiskLevelOperation)
	populate(objectMap, "dataPendingAtSourceAgentInMB", a.DataPendingAtSourceAgentInMB)
	populate(objectMap, "dataPendingInStagingStorageAccountInMB", a.DataPendingInStagingStorageAccountInMB)
	populate(objectMap, "dekKeyVaultArmId", a.DekKeyVaultArmID)
	populate(objectMap, "diskCapacityInBytes", a.DiskCapacityInBytes)
	populate(objectMap, "diskName", a.DiskName)
	populate(objectMap, "diskState", a.DiskState)
	populate(objectMap, "diskType", a.DiskType)
	populate(objectMap, "diskUri", a.DiskURI)
	populate(objectMap, "failoverDiskName", a.FailoverDiskName)
	populate(objectMap, "isDiskEncrypted", a.IsDiskEncrypted)
	populate(objectMap, "isDiskKeyEncrypted", a.IsDiskKeyEncrypted)
	populate(objectMap, "kekKeyVaultArmId", a.KekKeyVaultArmID)
	populate(objectMap, "keyIdentifier", a.KeyIdentifier)
	populate(objectMap, "monitoringJobType", a.MonitoringJobType)
	populate(objectMap, "monitoringPercentageCompletion", a.MonitoringPercentageCompletion)
	populate(objectMap, "primaryDiskAzureStorageAccountId", a.PrimaryDiskAzureStorageAccountID)
	populate(objectMap, "primaryStagingAzureStorageAccountId", a.PrimaryStagingAzureStorageAccountID)
	populate(objectMap, "recoveryAzureStorageAccountId", a.RecoveryAzureStorageAccountID)
	populate(objectMap, "recoveryDiskUri", a.RecoveryDiskURI)
	populate(objectMap, "resyncRequired", a.ResyncRequired)
	populate(objectMap, "secretIdentifier", a.SecretIdentifier)
	populate(objectMap, "tfoDiskName", a.TfoDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectedDiskDetails.
func (a *A2AProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedDiskLevelOperation":
			err = unpopulate(val, "AllowedDiskLevelOperation", &a.AllowedDiskLevelOperation)
			delete(rawMsg, key)
		case "dataPendingAtSourceAgentInMB":
			err = unpopulate(val, "DataPendingAtSourceAgentInMB", &a.DataPendingAtSourceAgentInMB)
			delete(rawMsg, key)
		case "dataPendingInStagingStorageAccountInMB":
			err = unpopulate(val, "DataPendingInStagingStorageAccountInMB", &a.DataPendingInStagingStorageAccountInMB)
			delete(rawMsg, key)
		case "dekKeyVaultArmId":
			err = unpopulate(val, "DekKeyVaultArmID", &a.DekKeyVaultArmID)
			delete(rawMsg, key)
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &a.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &a.DiskName)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &a.DiskState)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &a.DiskType)
			delete(rawMsg, key)
		case "diskUri":
			err = unpopulate(val, "DiskURI", &a.DiskURI)
			delete(rawMsg, key)
		case "failoverDiskName":
			err = unpopulate(val, "FailoverDiskName", &a.FailoverDiskName)
			delete(rawMsg, key)
		case "isDiskEncrypted":
			err = unpopulate(val, "IsDiskEncrypted", &a.IsDiskEncrypted)
			delete(rawMsg, key)
		case "isDiskKeyEncrypted":
			err = unpopulate(val, "IsDiskKeyEncrypted", &a.IsDiskKeyEncrypted)
			delete(rawMsg, key)
		case "kekKeyVaultArmId":
			err = unpopulate(val, "KekKeyVaultArmID", &a.KekKeyVaultArmID)
			delete(rawMsg, key)
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &a.KeyIdentifier)
			delete(rawMsg, key)
		case "monitoringJobType":
			err = unpopulate(val, "MonitoringJobType", &a.MonitoringJobType)
			delete(rawMsg, key)
		case "monitoringPercentageCompletion":
			err = unpopulate(val, "MonitoringPercentageCompletion", &a.MonitoringPercentageCompletion)
			delete(rawMsg, key)
		case "primaryDiskAzureStorageAccountId":
			err = unpopulate(val, "PrimaryDiskAzureStorageAccountID", &a.PrimaryDiskAzureStorageAccountID)
			delete(rawMsg, key)
		case "primaryStagingAzureStorageAccountId":
			err = unpopulate(val, "PrimaryStagingAzureStorageAccountID", &a.PrimaryStagingAzureStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccountId":
			err = unpopulate(val, "RecoveryAzureStorageAccountID", &a.RecoveryAzureStorageAccountID)
			delete(rawMsg, key)
		case "recoveryDiskUri":
			err = unpopulate(val, "RecoveryDiskURI", &a.RecoveryDiskURI)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &a.ResyncRequired)
			delete(rawMsg, key)
		case "secretIdentifier":
			err = unpopulate(val, "SecretIdentifier", &a.SecretIdentifier)
			delete(rawMsg, key)
		case "tfoDiskName":
			err = unpopulate(val, "TfoDiskName", &a.TfoDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectedManagedDiskDetails.
func (a A2AProtectedManagedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedDiskLevelOperation", a.AllowedDiskLevelOperation)
	populate(objectMap, "dataPendingAtSourceAgentInMB", a.DataPendingAtSourceAgentInMB)
	populate(objectMap, "dataPendingInStagingStorageAccountInMB", a.DataPendingInStagingStorageAccountInMB)
	populate(objectMap, "dekKeyVaultArmId", a.DekKeyVaultArmID)
	populate(objectMap, "diskCapacityInBytes", a.DiskCapacityInBytes)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "diskName", a.DiskName)
	populate(objectMap, "diskState", a.DiskState)
	populate(objectMap, "diskType", a.DiskType)
	populate(objectMap, "failoverDiskName", a.FailoverDiskName)
	populate(objectMap, "isDiskEncrypted", a.IsDiskEncrypted)
	populate(objectMap, "isDiskKeyEncrypted", a.IsDiskKeyEncrypted)
	populate(objectMap, "kekKeyVaultArmId", a.KekKeyVaultArmID)
	populate(objectMap, "keyIdentifier", a.KeyIdentifier)
	populate(objectMap, "monitoringJobType", a.MonitoringJobType)
	populate(objectMap, "monitoringPercentageCompletion", a.MonitoringPercentageCompletion)
	populate(objectMap, "primaryDiskEncryptionSetId", a.PrimaryDiskEncryptionSetID)
	populate(objectMap, "primaryStagingAzureStorageAccountId", a.PrimaryStagingAzureStorageAccountID)
	populate(objectMap, "recoveryDiskEncryptionSetId", a.RecoveryDiskEncryptionSetID)
	populate(objectMap, "recoveryOrignalTargetDiskId", a.RecoveryOrignalTargetDiskID)
	populate(objectMap, "recoveryReplicaDiskAccountType", a.RecoveryReplicaDiskAccountType)
	populate(objectMap, "recoveryReplicaDiskId", a.RecoveryReplicaDiskID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryTargetDiskAccountType", a.RecoveryTargetDiskAccountType)
	populate(objectMap, "recoveryTargetDiskId", a.RecoveryTargetDiskID)
	populate(objectMap, "resyncRequired", a.ResyncRequired)
	populate(objectMap, "secretIdentifier", a.SecretIdentifier)
	populate(objectMap, "tfoDiskName", a.TfoDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectedManagedDiskDetails.
func (a *A2AProtectedManagedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedDiskLevelOperation":
			err = unpopulate(val, "AllowedDiskLevelOperation", &a.AllowedDiskLevelOperation)
			delete(rawMsg, key)
		case "dataPendingAtSourceAgentInMB":
			err = unpopulate(val, "DataPendingAtSourceAgentInMB", &a.DataPendingAtSourceAgentInMB)
			delete(rawMsg, key)
		case "dataPendingInStagingStorageAccountInMB":
			err = unpopulate(val, "DataPendingInStagingStorageAccountInMB", &a.DataPendingInStagingStorageAccountInMB)
			delete(rawMsg, key)
		case "dekKeyVaultArmId":
			err = unpopulate(val, "DekKeyVaultArmID", &a.DekKeyVaultArmID)
			delete(rawMsg, key)
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &a.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &a.DiskName)
			delete(rawMsg, key)
		case "diskState":
			err = unpopulate(val, "DiskState", &a.DiskState)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &a.DiskType)
			delete(rawMsg, key)
		case "failoverDiskName":
			err = unpopulate(val, "FailoverDiskName", &a.FailoverDiskName)
			delete(rawMsg, key)
		case "isDiskEncrypted":
			err = unpopulate(val, "IsDiskEncrypted", &a.IsDiskEncrypted)
			delete(rawMsg, key)
		case "isDiskKeyEncrypted":
			err = unpopulate(val, "IsDiskKeyEncrypted", &a.IsDiskKeyEncrypted)
			delete(rawMsg, key)
		case "kekKeyVaultArmId":
			err = unpopulate(val, "KekKeyVaultArmID", &a.KekKeyVaultArmID)
			delete(rawMsg, key)
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &a.KeyIdentifier)
			delete(rawMsg, key)
		case "monitoringJobType":
			err = unpopulate(val, "MonitoringJobType", &a.MonitoringJobType)
			delete(rawMsg, key)
		case "monitoringPercentageCompletion":
			err = unpopulate(val, "MonitoringPercentageCompletion", &a.MonitoringPercentageCompletion)
			delete(rawMsg, key)
		case "primaryDiskEncryptionSetId":
			err = unpopulate(val, "PrimaryDiskEncryptionSetID", &a.PrimaryDiskEncryptionSetID)
			delete(rawMsg, key)
		case "primaryStagingAzureStorageAccountId":
			err = unpopulate(val, "PrimaryStagingAzureStorageAccountID", &a.PrimaryStagingAzureStorageAccountID)
			delete(rawMsg, key)
		case "recoveryDiskEncryptionSetId":
			err = unpopulate(val, "RecoveryDiskEncryptionSetID", &a.RecoveryDiskEncryptionSetID)
			delete(rawMsg, key)
		case "recoveryOrignalTargetDiskId":
			err = unpopulate(val, "RecoveryOrignalTargetDiskID", &a.RecoveryOrignalTargetDiskID)
			delete(rawMsg, key)
		case "recoveryReplicaDiskAccountType":
			err = unpopulate(val, "RecoveryReplicaDiskAccountType", &a.RecoveryReplicaDiskAccountType)
			delete(rawMsg, key)
		case "recoveryReplicaDiskId":
			err = unpopulate(val, "RecoveryReplicaDiskID", &a.RecoveryReplicaDiskID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryTargetDiskAccountType":
			err = unpopulate(val, "RecoveryTargetDiskAccountType", &a.RecoveryTargetDiskAccountType)
			delete(rawMsg, key)
		case "recoveryTargetDiskId":
			err = unpopulate(val, "RecoveryTargetDiskID", &a.RecoveryTargetDiskID)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &a.ResyncRequired)
			delete(rawMsg, key)
		case "secretIdentifier":
			err = unpopulate(val, "SecretIdentifier", &a.SecretIdentifier)
			delete(rawMsg, key)
		case "tfoDiskName":
			err = unpopulate(val, "TfoDiskName", &a.TfoDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectionContainerMappingDetails.
func (a A2AProtectionContainerMappingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "jobScheduleName", a.JobScheduleName)
	populate(objectMap, "scheduleName", a.ScheduleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionContainerMappingDetails.
func (a *A2AProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "jobScheduleName":
			err = unpopulate(val, "JobScheduleName", &a.JobScheduleName)
			delete(rawMsg, key)
		case "scheduleName":
			err = unpopulate(val, "ScheduleName", &a.ScheduleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectionIntentDiskInputDetails.
func (a A2AProtectionIntentDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskUri", a.DiskURI)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "recoveryAzureStorageAccountCustomInput", a.RecoveryAzureStorageAccountCustomInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionIntentDiskInputDetails.
func (a *A2AProtectionIntentDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskUri":
			err = unpopulate(val, "DiskURI", &a.DiskURI)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccountCustomInput":
			a.RecoveryAzureStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectionIntentManagedDiskInputDetails.
func (a A2AProtectionIntentManagedDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "recoveryDiskEncryptionSetId", a.RecoveryDiskEncryptionSetID)
	populate(objectMap, "recoveryReplicaDiskAccountType", a.RecoveryReplicaDiskAccountType)
	populate(objectMap, "recoveryResourceGroupCustomInput", a.RecoveryResourceGroupCustomInput)
	populate(objectMap, "recoveryTargetDiskAccountType", a.RecoveryTargetDiskAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionIntentManagedDiskInputDetails.
func (a *A2AProtectionIntentManagedDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryDiskEncryptionSetId":
			err = unpopulate(val, "RecoveryDiskEncryptionSetID", &a.RecoveryDiskEncryptionSetID)
			delete(rawMsg, key)
		case "recoveryReplicaDiskAccountType":
			err = unpopulate(val, "RecoveryReplicaDiskAccountType", &a.RecoveryReplicaDiskAccountType)
			delete(rawMsg, key)
		case "recoveryResourceGroupCustomInput":
			a.RecoveryResourceGroupCustomInput, err = unmarshalRecoveryResourceGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryTargetDiskAccountType":
			err = unpopulate(val, "RecoveryTargetDiskAccountType", &a.RecoveryTargetDiskAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ARecoveryPointDetails.
func (a A2ARecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disks", a.Disks)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "recoveryPointSyncType", a.RecoveryPointSyncType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ARecoveryPointDetails.
func (a *A2ARecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &a.Disks)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointSyncType":
			err = unpopulate(val, "RecoveryPointSyncType", &a.RecoveryPointSyncType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ARemoveDisksInput.
func (a A2ARemoveDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "vmDisksUris", a.VMDisksUris)
	populate(objectMap, "vmManagedDisksIds", a.VMManagedDisksIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ARemoveDisksInput.
func (a *A2ARemoveDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "vmDisksUris":
			err = unpopulate(val, "VMDisksUris", &a.VMDisksUris)
			delete(rawMsg, key)
		case "vmManagedDisksIds":
			err = unpopulate(val, "VMManagedDisksIDs", &a.VMManagedDisksIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AReplicationDetails.
func (a A2AReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentCertificateExpiryDate", a.AgentCertificateExpiryDate)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", a.AgentExpiryDate)
	populate(objectMap, "agentVersion", a.AgentVersion)
	populate(objectMap, "autoProtectionOfDataDisk", a.AutoProtectionOfDataDisk)
	populate(objectMap, "churnOptionSelected", a.ChurnOptionSelected)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	populate(objectMap, "initialPrimaryExtendedLocation", a.InitialPrimaryExtendedLocation)
	populate(objectMap, "initialPrimaryFabricLocation", a.InitialPrimaryFabricLocation)
	populate(objectMap, "initialPrimaryZone", a.InitialPrimaryZone)
	populate(objectMap, "initialRecoveryExtendedLocation", a.InitialRecoveryExtendedLocation)
	populate(objectMap, "initialRecoveryFabricLocation", a.InitialRecoveryFabricLocation)
	populate(objectMap, "initialRecoveryZone", a.InitialRecoveryZone)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "isReplicationAgentCertificateUpdateRequired", a.IsReplicationAgentCertificateUpdateRequired)
	populate(objectMap, "isReplicationAgentUpdateRequired", a.IsReplicationAgentUpdateRequired)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", a.LastHeartbeat)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", a.LastRpoCalculatedTime)
	populate(objectMap, "lifecycleId", a.LifecycleID)
	populate(objectMap, "managementId", a.ManagementID)
	populate(objectMap, "monitoringJobType", a.MonitoringJobType)
	populate(objectMap, "monitoringPercentageCompletion", a.MonitoringPercentageCompletion)
	populate(objectMap, "multiVmGroupCreateOption", a.MultiVMGroupCreateOption)
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "primaryAvailabilityZone", a.PrimaryAvailabilityZone)
	populate(objectMap, "primaryExtendedLocation", a.PrimaryExtendedLocation)
	populate(objectMap, "primaryFabricLocation", a.PrimaryFabricLocation)
	populate(objectMap, "protectedDisks", a.ProtectedDisks)
	populate(objectMap, "protectedManagedDisks", a.ProtectedManagedDisks)
	populate(objectMap, "recoveryAvailabilitySet", a.RecoveryAvailabilitySet)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryAzureGeneration", a.RecoveryAzureGeneration)
	populate(objectMap, "recoveryAzureResourceGroupId", a.RecoveryAzureResourceGroupID)
	populate(objectMap, "recoveryAzureVMName", a.RecoveryAzureVMName)
	populate(objectMap, "recoveryAzureVMSize", a.RecoveryAzureVMSize)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudService", a.RecoveryCloudService)
	populate(objectMap, "recoveryExtendedLocation", a.RecoveryExtendedLocation)
	populate(objectMap, "recoveryFabricLocation", a.RecoveryFabricLocation)
	populate(objectMap, "recoveryFabricObjectId", a.RecoveryFabricObjectID)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "rpoInSeconds", a.RpoInSeconds)
	populate(objectMap, "selectedRecoveryAzureNetworkId", a.SelectedRecoveryAzureNetworkID)
	populate(objectMap, "selectedTfoAzureNetworkId", a.SelectedTfoAzureNetworkID)
	populate(objectMap, "testFailoverRecoveryFabricObjectId", a.TestFailoverRecoveryFabricObjectID)
	populate(objectMap, "tfoAzureVMName", a.TfoAzureVMName)
	populate(objectMap, "unprotectedDisks", a.UnprotectedDisks)
	populate(objectMap, "vmEncryptionType", a.VMEncryptionType)
	populate(objectMap, "vmNics", a.VMNics)
	populate(objectMap, "vmProtectionState", a.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", a.VMProtectionStateDescription)
	populate(objectMap, "vmSyncedConfigDetails", a.VMSyncedConfigDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReplicationDetails.
func (a *A2AReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentCertificateExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentCertificateExpiryDate", &a.AgentCertificateExpiryDate)
			delete(rawMsg, key)
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &a.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &a.AgentVersion)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "churnOptionSelected":
			err = unpopulate(val, "ChurnOptionSelected", &a.ChurnOptionSelected)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "initialPrimaryExtendedLocation":
			err = unpopulate(val, "InitialPrimaryExtendedLocation", &a.InitialPrimaryExtendedLocation)
			delete(rawMsg, key)
		case "initialPrimaryFabricLocation":
			err = unpopulate(val, "InitialPrimaryFabricLocation", &a.InitialPrimaryFabricLocation)
			delete(rawMsg, key)
		case "initialPrimaryZone":
			err = unpopulate(val, "InitialPrimaryZone", &a.InitialPrimaryZone)
			delete(rawMsg, key)
		case "initialRecoveryExtendedLocation":
			err = unpopulate(val, "InitialRecoveryExtendedLocation", &a.InitialRecoveryExtendedLocation)
			delete(rawMsg, key)
		case "initialRecoveryFabricLocation":
			err = unpopulate(val, "InitialRecoveryFabricLocation", &a.InitialRecoveryFabricLocation)
			delete(rawMsg, key)
		case "initialRecoveryZone":
			err = unpopulate(val, "InitialRecoveryZone", &a.InitialRecoveryZone)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "isReplicationAgentCertificateUpdateRequired":
			err = unpopulate(val, "IsReplicationAgentCertificateUpdateRequired", &a.IsReplicationAgentCertificateUpdateRequired)
			delete(rawMsg, key)
		case "isReplicationAgentUpdateRequired":
			err = unpopulate(val, "IsReplicationAgentUpdateRequired", &a.IsReplicationAgentUpdateRequired)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &a.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &a.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lifecycleId":
			err = unpopulate(val, "LifecycleID", &a.LifecycleID)
			delete(rawMsg, key)
		case "managementId":
			err = unpopulate(val, "ManagementID", &a.ManagementID)
			delete(rawMsg, key)
		case "monitoringJobType":
			err = unpopulate(val, "MonitoringJobType", &a.MonitoringJobType)
			delete(rawMsg, key)
		case "monitoringPercentageCompletion":
			err = unpopulate(val, "MonitoringPercentageCompletion", &a.MonitoringPercentageCompletion)
			delete(rawMsg, key)
		case "multiVmGroupCreateOption":
			err = unpopulate(val, "MultiVMGroupCreateOption", &a.MultiVMGroupCreateOption)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "primaryAvailabilityZone":
			err = unpopulate(val, "PrimaryAvailabilityZone", &a.PrimaryAvailabilityZone)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &a.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &a.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &a.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "recoveryAvailabilitySet":
			err = unpopulate(val, "RecoveryAvailabilitySet", &a.RecoveryAvailabilitySet)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryAzureGeneration":
			err = unpopulate(val, "RecoveryAzureGeneration", &a.RecoveryAzureGeneration)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &a.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &a.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &a.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudService":
			err = unpopulate(val, "RecoveryCloudService", &a.RecoveryCloudService)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryFabricLocation":
			err = unpopulate(val, "RecoveryFabricLocation", &a.RecoveryFabricLocation)
			delete(rawMsg, key)
		case "recoveryFabricObjectId":
			err = unpopulate(val, "RecoveryFabricObjectID", &a.RecoveryFabricObjectID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &a.RpoInSeconds)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &a.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &a.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "testFailoverRecoveryFabricObjectId":
			err = unpopulate(val, "TestFailoverRecoveryFabricObjectID", &a.TestFailoverRecoveryFabricObjectID)
			delete(rawMsg, key)
		case "tfoAzureVMName":
			err = unpopulate(val, "TfoAzureVMName", &a.TfoAzureVMName)
			delete(rawMsg, key)
		case "unprotectedDisks":
			err = unpopulate(val, "UnprotectedDisks", &a.UnprotectedDisks)
			delete(rawMsg, key)
		case "vmEncryptionType":
			err = unpopulate(val, "VMEncryptionType", &a.VMEncryptionType)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &a.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &a.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &a.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "vmSyncedConfigDetails":
			err = unpopulate(val, "VMSyncedConfigDetails", &a.VMSyncedConfigDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AReplicationIntentDetails.
func (a A2AReplicationIntentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "autoProtectionOfDataDisk", a.AutoProtectionOfDataDisk)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "primaryLocation", a.PrimaryLocation)
	populate(objectMap, "primaryStagingStorageAccount", a.PrimaryStagingStorageAccount)
	populate(objectMap, "protectionProfile", a.ProtectionProfile)
	populate(objectMap, "recoveryAvailabilitySet", a.RecoveryAvailabilitySet)
	populate(objectMap, "recoveryAvailabilityType", a.RecoveryAvailabilityType)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryBootDiagStorageAccount", a.RecoveryBootDiagStorageAccount)
	populate(objectMap, "recoveryLocation", a.RecoveryLocation)
	populate(objectMap, "recoveryProximityPlacementGroup", a.RecoveryProximityPlacementGroup)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoverySubscriptionId", a.RecoverySubscriptionID)
	populate(objectMap, "recoveryVirtualNetwork", a.RecoveryVirtualNetwork)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReplicationIntentDetails.
func (a *A2AReplicationIntentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "primaryLocation":
			err = unpopulate(val, "PrimaryLocation", &a.PrimaryLocation)
			delete(rawMsg, key)
		case "primaryStagingStorageAccount":
			a.PrimaryStagingStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "protectionProfile":
			a.ProtectionProfile, err = unmarshalProtectionProfileCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySet":
			a.RecoveryAvailabilitySet, err = unmarshalRecoveryAvailabilitySetCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilityType":
			err = unpopulate(val, "RecoveryAvailabilityType", &a.RecoveryAvailabilityType)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccount":
			a.RecoveryBootDiagStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryLocation":
			err = unpopulate(val, "RecoveryLocation", &a.RecoveryLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroup":
			a.RecoveryProximityPlacementGroup, err = unmarshalRecoveryProximityPlacementGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubscriptionId":
			err = unpopulate(val, "RecoverySubscriptionID", &a.RecoverySubscriptionID)
			delete(rawMsg, key)
		case "recoveryVirtualNetwork":
			a.RecoveryVirtualNetwork, err = unmarshalRecoveryVirtualNetworkCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AReprotectInput.
func (a A2AReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "vmDisks", a.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReprotectInput.
func (a *A2AReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ASwitchProtectionInput.
func (a A2ASwitchProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ASwitchProtectionInput.
func (a *A2ASwitchProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ATestFailoverInput.
func (a A2ATestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudServiceCreationOption", a.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ATestFailoverInput.
func (a *A2ATestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &a.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUnplannedFailoverInput.
func (a A2AUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudServiceCreationOption", a.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUnplannedFailoverInput.
func (a *A2AUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &a.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUnprotectedDiskDetails.
func (a A2AUnprotectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskAutoProtectionStatus", a.DiskAutoProtectionStatus)
	populate(objectMap, "diskLunId", a.DiskLunID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUnprotectedDiskDetails.
func (a *A2AUnprotectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskAutoProtectionStatus":
			err = unpopulate(val, "DiskAutoProtectionStatus", &a.DiskAutoProtectionStatus)
			delete(rawMsg, key)
		case "diskLunId":
			err = unpopulate(val, "DiskLunID", &a.DiskLunID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUpdateContainerMappingInput.
func (a A2AUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUpdateContainerMappingInput.
func (a *A2AUpdateContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUpdateReplicationProtectedItemInput.
func (a A2AUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "managedDiskUpdateDetails", a.ManagedDiskUpdateDetails)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "tfoAzureVMName", a.TfoAzureVMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUpdateReplicationProtectedItemInput.
func (a *A2AUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "managedDiskUpdateDetails":
			err = unpopulate(val, "ManagedDiskUpdateDetails", &a.ManagedDiskUpdateDetails)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "tfoAzureVMName":
			err = unpopulate(val, "TfoAzureVMName", &a.TfoAzureVMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AVMDiskInputDetails.
func (a A2AVMDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskUri", a.DiskURI)
	populate(objectMap, "primaryStagingAzureStorageAccountId", a.PrimaryStagingAzureStorageAccountID)
	populate(objectMap, "recoveryAzureStorageAccountId", a.RecoveryAzureStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AVMDiskInputDetails.
func (a *A2AVMDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskUri":
			err = unpopulate(val, "DiskURI", &a.DiskURI)
			delete(rawMsg, key)
		case "primaryStagingAzureStorageAccountId":
			err = unpopulate(val, "PrimaryStagingAzureStorageAccountID", &a.PrimaryStagingAzureStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccountId":
			err = unpopulate(val, "RecoveryAzureStorageAccountID", &a.RecoveryAzureStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AVMManagedDiskInputDetails.
func (a A2AVMManagedDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "primaryStagingAzureStorageAccountId", a.PrimaryStagingAzureStorageAccountID)
	populate(objectMap, "recoveryDiskEncryptionSetId", a.RecoveryDiskEncryptionSetID)
	populate(objectMap, "recoveryReplicaDiskAccountType", a.RecoveryReplicaDiskAccountType)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryTargetDiskAccountType", a.RecoveryTargetDiskAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AVMManagedDiskInputDetails.
func (a *A2AVMManagedDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "primaryStagingAzureStorageAccountId":
			err = unpopulate(val, "PrimaryStagingAzureStorageAccountID", &a.PrimaryStagingAzureStorageAccountID)
			delete(rawMsg, key)
		case "recoveryDiskEncryptionSetId":
			err = unpopulate(val, "RecoveryDiskEncryptionSetID", &a.RecoveryDiskEncryptionSetID)
			delete(rawMsg, key)
		case "recoveryReplicaDiskAccountType":
			err = unpopulate(val, "RecoveryReplicaDiskAccountType", &a.RecoveryReplicaDiskAccountType)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryTargetDiskAccountType":
			err = unpopulate(val, "RecoveryTargetDiskAccountType", &a.RecoveryTargetDiskAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AVMManagedDiskUpdateDetails.
func (a A2AVMManagedDiskUpdateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "failoverDiskName", a.FailoverDiskName)
	populate(objectMap, "recoveryReplicaDiskAccountType", a.RecoveryReplicaDiskAccountType)
	populate(objectMap, "recoveryTargetDiskAccountType", a.RecoveryTargetDiskAccountType)
	populate(objectMap, "tfoDiskName", a.TfoDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AVMManagedDiskUpdateDetails.
func (a *A2AVMManagedDiskUpdateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "failoverDiskName":
			err = unpopulate(val, "FailoverDiskName", &a.FailoverDiskName)
			delete(rawMsg, key)
		case "recoveryReplicaDiskAccountType":
			err = unpopulate(val, "RecoveryReplicaDiskAccountType", &a.RecoveryReplicaDiskAccountType)
			delete(rawMsg, key)
		case "recoveryTargetDiskAccountType":
			err = unpopulate(val, "RecoveryTargetDiskAccountType", &a.RecoveryTargetDiskAccountType)
			delete(rawMsg, key)
		case "tfoDiskName":
			err = unpopulate(val, "TfoDiskName", &a.TfoDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AZoneDetails.
func (a A2AZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AZoneDetails.
func (a *A2AZoneDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ASRTask.
func (a ASRTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedActions", a.AllowedActions)
	populate(objectMap, "customDetails", a.CustomDetails)
	populateDateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "errors", a.Errors)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "groupTaskCustomDetails", a.GroupTaskCustomDetails)
	populate(objectMap, "name", a.Name)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "state", a.State)
	populate(objectMap, "stateDescription", a.StateDescription)
	populate(objectMap, "taskId", a.TaskID)
	populate(objectMap, "taskType", a.TaskType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ASRTask.
func (a *ASRTask) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &a.AllowedActions)
			delete(rawMsg, key)
		case "customDetails":
			a.CustomDetails, err = unmarshalTaskTypeDetailsClassification(val)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "groupTaskCustomDetails":
			a.GroupTaskCustomDetails, err = unmarshalGroupTaskDetailsClassification(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "stateDescription":
			err = unpopulate(val, "StateDescription", &a.StateDescription)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &a.TaskID)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &a.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddDisksInput.
func (a AddDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddDisksInput.
func (a *AddDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddDisksInputProperties.
func (a AddDisksInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", a.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddDisksInputProperties.
func (a *AddDisksInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			a.ProviderSpecificDetails, err = unmarshalAddDisksProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddDisksProviderSpecificInput.
func (a AddDisksProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = a.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddDisksProviderSpecificInput.
func (a *AddDisksProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddRecoveryServicesProviderInput.
func (a AddRecoveryServicesProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddRecoveryServicesProviderInput.
func (a *AddRecoveryServicesProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddRecoveryServicesProviderInputProperties.
func (a AddRecoveryServicesProviderInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationIdentityInput", a.AuthenticationIdentityInput)
	populate(objectMap, "biosId", a.BiosID)
	populate(objectMap, "dataPlaneAuthenticationIdentityInput", a.DataPlaneAuthenticationIdentityInput)
	populate(objectMap, "machineId", a.MachineID)
	populate(objectMap, "machineName", a.MachineName)
	populate(objectMap, "resourceAccessIdentityInput", a.ResourceAccessIdentityInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddRecoveryServicesProviderInputProperties.
func (a *AddRecoveryServicesProviderInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationIdentityInput":
			err = unpopulate(val, "AuthenticationIdentityInput", &a.AuthenticationIdentityInput)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &a.BiosID)
			delete(rawMsg, key)
		case "dataPlaneAuthenticationIdentityInput":
			err = unpopulate(val, "DataPlaneAuthenticationIdentityInput", &a.DataPlaneAuthenticationIdentityInput)
			delete(rawMsg, key)
		case "machineId":
			err = unpopulate(val, "MachineID", &a.MachineID)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &a.MachineName)
			delete(rawMsg, key)
		case "resourceAccessIdentityInput":
			err = unpopulate(val, "ResourceAccessIdentityInput", &a.ResourceAccessIdentityInput)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddVCenterRequest.
func (a AddVCenterRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddVCenterRequest.
func (a *AddVCenterRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddVCenterRequestProperties.
func (a AddVCenterRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "ipAddress", a.IPAddress)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "processServerId", a.ProcessServerID)
	populate(objectMap, "runAsAccountId", a.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddVCenterRequestProperties.
func (a *AddVCenterRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &a.IPAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &a.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &a.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentDetails.
func (a AgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentId", a.AgentID)
	populate(objectMap, "biosId", a.BiosID)
	populate(objectMap, "disks", a.Disks)
	populate(objectMap, "fqdn", a.Fqdn)
	populate(objectMap, "machineId", a.MachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentDetails.
func (a *AgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentId":
			err = unpopulate(val, "AgentID", &a.AgentID)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &a.BiosID)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &a.Disks)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &a.Fqdn)
			delete(rawMsg, key)
		case "machineId":
			err = unpopulate(val, "MachineID", &a.MachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentDiskDetails.
func (a AgentDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", a.CapacityInBytes)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "diskName", a.DiskName)
	populate(objectMap, "isOSDisk", a.IsOSDisk)
	populate(objectMap, "lunId", a.LunID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentDiskDetails.
func (a *AgentDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &a.CapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &a.DiskName)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &a.IsOSDisk)
			delete(rawMsg, key)
		case "lunId":
			err = unpopulate(val, "LunID", &a.LunID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Alert.
func (a *Alert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertCollection.
func (a AlertCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertCollection.
func (a *AlertCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customEmailAddresses", a.CustomEmailAddresses)
	populate(objectMap, "locale", a.Locale)
	populate(objectMap, "sendToOwners", a.SendToOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customEmailAddresses":
			err = unpopulate(val, "CustomEmailAddresses", &a.CustomEmailAddresses)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &a.Locale)
			delete(rawMsg, key)
		case "sendToOwners":
			err = unpopulate(val, "SendToOwners", &a.SendToOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceCollection.
func (a ApplianceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceCollection.
func (a *ApplianceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceMonitoringDetails.
func (a ApplianceMonitoringDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuDetails", a.CPUDetails)
	populate(objectMap, "datastoreSnapshot", a.DatastoreSnapshot)
	populate(objectMap, "disksReplicationDetails", a.DisksReplicationDetails)
	populate(objectMap, "esxiNfcBuffer", a.EsxiNfcBuffer)
	populate(objectMap, "networkBandwidth", a.NetworkBandwidth)
	populate(objectMap, "ramDetails", a.RAMDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceMonitoringDetails.
func (a *ApplianceMonitoringDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuDetails":
			err = unpopulate(val, "CPUDetails", &a.CPUDetails)
			delete(rawMsg, key)
		case "datastoreSnapshot":
			err = unpopulate(val, "DatastoreSnapshot", &a.DatastoreSnapshot)
			delete(rawMsg, key)
		case "disksReplicationDetails":
			err = unpopulate(val, "DisksReplicationDetails", &a.DisksReplicationDetails)
			delete(rawMsg, key)
		case "esxiNfcBuffer":
			err = unpopulate(val, "EsxiNfcBuffer", &a.EsxiNfcBuffer)
			delete(rawMsg, key)
		case "networkBandwidth":
			err = unpopulate(val, "NetworkBandwidth", &a.NetworkBandwidth)
			delete(rawMsg, key)
		case "ramDetails":
			err = unpopulate(val, "RAMDetails", &a.RAMDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceQueryParameter.
func (a ApplianceQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerType", a.ProviderType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceQueryParameter.
func (a *ApplianceQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerType":
			err = unpopulate(val, "ProviderType", &a.ProviderType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceResourceDetails.
func (a ApplianceResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "processUtilization", a.ProcessUtilization)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "totalUtilization", a.TotalUtilization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceResourceDetails.
func (a *ApplianceResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "processUtilization":
			err = unpopulate(val, "ProcessUtilization", &a.ProcessUtilization)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "totalUtilization":
			err = unpopulate(val, "TotalUtilization", &a.TotalUtilization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplianceSpecificDetails.
func (a ApplianceSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = a.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplianceSpecificDetails.
func (a *ApplianceSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplyRecoveryPointInput.
func (a ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplyRecoveryPointInput.
func (a *ApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplyRecoveryPointInputProperties.
func (a ApplyRecoveryPointInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", a.ProviderSpecificDetails)
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplyRecoveryPointInputProperties.
func (a *ApplyRecoveryPointInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			a.ProviderSpecificDetails, err = unmarshalApplyRecoveryPointProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplyRecoveryPointProviderSpecificInput.
func (a ApplyRecoveryPointProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = a.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplyRecoveryPointProviderSpecificInput.
func (a *ApplyRecoveryPointProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsrJobDetails.
func (a AsrJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", a.AffectedObjectDetails)
	objectMap["instanceType"] = "AsrJobDetails"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsrJobDetails.
func (a *AsrJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &a.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRunbookTaskDetails.
func (a AutomationRunbookTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "cloudServiceName", a.CloudServiceName)
	objectMap["instanceType"] = "AutomationRunbookTaskDetails"
	populate(objectMap, "isPrimarySideScript", a.IsPrimarySideScript)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "jobOutput", a.JobOutput)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "runbookId", a.RunbookID)
	populate(objectMap, "runbookName", a.RunbookName)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRunbookTaskDetails.
func (a *AutomationRunbookTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "cloudServiceName":
			err = unpopulate(val, "CloudServiceName", &a.CloudServiceName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "isPrimarySideScript":
			err = unpopulate(val, "IsPrimarySideScript", &a.IsPrimarySideScript)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "jobOutput":
			err = unpopulate(val, "JobOutput", &a.JobOutput)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "runbookId":
			err = unpopulate(val, "RunbookID", &a.RunbookID)
			delete(rawMsg, key)
		case "runbookName":
			err = unpopulate(val, "RunbookName", &a.RunbookName)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFabricCreationInput.
func (a AzureFabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "Azure"
	populate(objectMap, "location", a.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFabricCreationInput.
func (a *AzureFabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFabricSpecificDetails.
func (a AzureFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerIds", a.ContainerIDs)
	populate(objectMap, "extendedLocations", a.ExtendedLocations)
	objectMap["instanceType"] = "Azure"
	populate(objectMap, "location", a.Location)
	populate(objectMap, "locationDetails", a.LocationDetails)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFabricSpecificDetails.
func (a *AzureFabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerIds":
			err = unpopulate(val, "ContainerIDs", &a.ContainerIDs)
			delete(rawMsg, key)
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &a.ExtendedLocations)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "locationDetails":
			err = unpopulate(val, "LocationDetails", &a.LocationDetails)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureCreateNetworkMappingInput.
func (a AzureToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "AzureToAzure"
	populate(objectMap, "primaryNetworkId", a.PrimaryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureCreateNetworkMappingInput.
func (a *AzureToAzureCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &a.PrimaryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureNetworkMappingSettings.
func (a AzureToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "AzureToAzure"
	populate(objectMap, "primaryFabricLocation", a.PrimaryFabricLocation)
	populate(objectMap, "recoveryFabricLocation", a.RecoveryFabricLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureNetworkMappingSettings.
func (a *AzureToAzureNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "recoveryFabricLocation":
			err = unpopulate(val, "RecoveryFabricLocation", &a.RecoveryFabricLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureUpdateNetworkMappingInput.
func (a AzureToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "AzureToAzure"
	populate(objectMap, "primaryNetworkId", a.PrimaryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureUpdateNetworkMappingInput.
func (a *AzureToAzureUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &a.PrimaryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureVMSyncedConfigDetails.
func (a AzureToAzureVMSyncedConfigDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inputEndpoints", a.InputEndpoints)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureVMSyncedConfigDetails.
func (a *AzureToAzureVMSyncedConfigDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputEndpoints":
			err = unpopulate(val, "InputEndpoints", &a.InputEndpoints)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureVMDiskDetails.
func (a AzureVMDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customTargetDiskName", a.CustomTargetDiskName)
	populate(objectMap, "diskEncryptionSetId", a.DiskEncryptionSetID)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "lunId", a.LunID)
	populate(objectMap, "maxSizeMB", a.MaxSizeMB)
	populate(objectMap, "targetDiskLocation", a.TargetDiskLocation)
	populate(objectMap, "targetDiskName", a.TargetDiskName)
	populate(objectMap, "vhdId", a.VhdID)
	populate(objectMap, "vhdName", a.VhdName)
	populate(objectMap, "vhdType", a.VhdType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureVMDiskDetails.
func (a *AzureVMDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customTargetDiskName":
			err = unpopulate(val, "CustomTargetDiskName", &a.CustomTargetDiskName)
			delete(rawMsg, key)
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &a.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "lunId":
			err = unpopulate(val, "LunID", &a.LunID)
			delete(rawMsg, key)
		case "maxSizeMB":
			err = unpopulate(val, "MaxSizeMB", &a.MaxSizeMB)
			delete(rawMsg, key)
		case "targetDiskLocation":
			err = unpopulate(val, "TargetDiskLocation", &a.TargetDiskLocation)
			delete(rawMsg, key)
		case "targetDiskName":
			err = unpopulate(val, "TargetDiskName", &a.TargetDiskName)
			delete(rawMsg, key)
		case "vhdId":
			err = unpopulate(val, "VhdID", &a.VhdID)
			delete(rawMsg, key)
		case "vhdName":
			err = unpopulate(val, "VhdName", &a.VhdName)
			delete(rawMsg, key)
		case "vhdType":
			err = unpopulate(val, "VhdType", &a.VhdType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeSizeErrorDetails.
func (c ComputeSizeErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "severity", c.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeSizeErrorDetails.
func (c *ComputeSizeErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationSettings.
func (c ConfigurationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = c.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationSettings.
func (c *ConfigurationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &c.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigureAlertRequest.
func (c ConfigureAlertRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigureAlertRequest.
func (c *ConfigureAlertRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigureAlertRequestProperties.
func (c ConfigureAlertRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customEmailAddresses", c.CustomEmailAddresses)
	populate(objectMap, "locale", c.Locale)
	populate(objectMap, "sendToOwners", c.SendToOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigureAlertRequestProperties.
func (c *ConfigureAlertRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customEmailAddresses":
			err = unpopulate(val, "CustomEmailAddresses", &c.CustomEmailAddresses)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &c.Locale)
			delete(rawMsg, key)
		case "sendToOwners":
			err = unpopulate(val, "SendToOwners", &c.SendToOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConsistencyCheckTaskDetails.
func (c ConsistencyCheckTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "ConsistencyCheckTaskDetails"
	populate(objectMap, "vmDetails", c.VMDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsistencyCheckTaskDetails.
func (c *ConsistencyCheckTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &c.InstanceType)
			delete(rawMsg, key)
		case "vmDetails":
			err = unpopulate(val, "VMDetails", &c.VMDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateNetworkMappingInput.
func (c CreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateNetworkMappingInput.
func (c *CreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateNetworkMappingInputProperties.
func (c CreateNetworkMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricSpecificDetails", c.FabricSpecificDetails)
	populate(objectMap, "recoveryFabricName", c.RecoveryFabricName)
	populate(objectMap, "recoveryNetworkId", c.RecoveryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateNetworkMappingInputProperties.
func (c *CreateNetworkMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificDetails":
			c.FabricSpecificDetails, err = unmarshalFabricSpecificCreateNetworkMappingInputClassification(val)
			delete(rawMsg, key)
		case "recoveryFabricName":
			err = unpopulate(val, "RecoveryFabricName", &c.RecoveryFabricName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &c.RecoveryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreatePolicyInput.
func (c CreatePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreatePolicyInput.
func (c *CreatePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreatePolicyInputProperties.
func (c CreatePolicyInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreatePolicyInputProperties.
func (c *CreatePolicyInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalPolicyProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerInput.
func (c CreateProtectionContainerInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerInput.
func (c *CreateProtectionContainerInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerInputProperties.
func (c CreateProtectionContainerInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerInputProperties.
func (c *CreateProtectionContainerInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificContainerCreationInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerMappingInput.
func (c CreateProtectionContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerMappingInput.
func (c *CreateProtectionContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerMappingInputProperties.
func (c CreateProtectionContainerMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyId", c.PolicyID)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	populate(objectMap, "targetProtectionContainerId", c.TargetProtectionContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerMappingInputProperties.
func (c *CreateProtectionContainerMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &c.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificContainerMappingInputClassification(val)
			delete(rawMsg, key)
		case "targetProtectionContainerId":
			err = unpopulate(val, "TargetProtectionContainerID", &c.TargetProtectionContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionIntentInput.
func (c CreateProtectionIntentInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionIntentInput.
func (c *CreateProtectionIntentInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionIntentProperties.
func (c CreateProtectionIntentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", c.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionIntentProperties.
func (c *CreateProtectionIntentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			c.ProviderSpecificDetails, err = unmarshalCreateProtectionIntentProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionIntentProviderSpecificDetails.
func (c CreateProtectionIntentProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = c.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionIntentProviderSpecificDetails.
func (c *CreateProtectionIntentProviderSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &c.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateRecoveryPlanInput.
func (c CreateRecoveryPlanInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateRecoveryPlanInput.
func (c *CreateRecoveryPlanInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateRecoveryPlanInputProperties.
func (c CreateRecoveryPlanInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDeploymentModel", c.FailoverDeploymentModel)
	populate(objectMap, "groups", c.Groups)
	populate(objectMap, "primaryFabricId", c.PrimaryFabricID)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	populate(objectMap, "recoveryFabricId", c.RecoveryFabricID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateRecoveryPlanInputProperties.
func (c *CreateRecoveryPlanInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDeploymentModel":
			err = unpopulate(val, "FailoverDeploymentModel", &c.FailoverDeploymentModel)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &c.Groups)
			delete(rawMsg, key)
		case "primaryFabricId":
			err = unpopulate(val, "PrimaryFabricID", &c.PrimaryFabricID)
			delete(rawMsg, key)
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalRecoveryPlanProviderSpecificInputClassificationArray(val)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &c.RecoveryFabricID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CriticalJobHistoryDetails.
func (c CriticalJobHistoryDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", c.JobID)
	populate(objectMap, "jobName", c.JobName)
	populate(objectMap, "jobStatus", c.JobStatus)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CriticalJobHistoryDetails.
func (c *CriticalJobHistoryDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &c.JobName)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &c.JobStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CurrentJobDetails.
func (c CurrentJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", c.JobID)
	populate(objectMap, "jobName", c.JobName)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentJobDetails.
func (c *CurrentJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &c.JobName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CurrentScenarioDetails.
func (c CurrentScenarioDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", c.JobID)
	populate(objectMap, "scenarioName", c.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentScenarioDetails.
func (c *CurrentScenarioDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &c.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataStore.
func (d DataStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", d.Capacity)
	populate(objectMap, "freeSpace", d.FreeSpace)
	populate(objectMap, "symbolicName", d.SymbolicName)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "uuid", d.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataStore.
func (d *DataStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &d.Capacity)
			delete(rawMsg, key)
		case "freeSpace":
			err = unpopulate(val, "FreeSpace", &d.FreeSpace)
			delete(rawMsg, key)
		case "symbolicName":
			err = unpopulate(val, "SymbolicName", &d.SymbolicName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &d.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataStoreUtilizationDetails.
func (d DataStoreUtilizationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStoreName", d.DataStoreName)
	populate(objectMap, "totalSnapshotsCreated", d.TotalSnapshotsCreated)
	populate(objectMap, "totalSnapshotsSupported", d.TotalSnapshotsSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataStoreUtilizationDetails.
func (d *DataStoreUtilizationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreName":
			err = unpopulate(val, "DataStoreName", &d.DataStoreName)
			delete(rawMsg, key)
		case "totalSnapshotsCreated":
			err = unpopulate(val, "TotalSnapshotsCreated", &d.TotalSnapshotsCreated)
			delete(rawMsg, key)
		case "totalSnapshotsSupported":
			err = unpopulate(val, "TotalSnapshotsSupported", &d.TotalSnapshotsSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisableProtectionInput.
func (d DisableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisableProtectionInput.
func (d *DisableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisableProtectionInputProperties.
func (d DisableProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableProtectionReason", d.DisableProtectionReason)
	populate(objectMap, "replicationProviderInput", d.ReplicationProviderInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisableProtectionInputProperties.
func (d *DisableProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableProtectionReason":
			err = unpopulate(val, "DisableProtectionReason", &d.DisableProtectionReason)
			delete(rawMsg, key)
		case "replicationProviderInput":
			d.ReplicationProviderInput, err = unmarshalDisableProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisableProtectionProviderSpecificInput.
func (d DisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = d.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisableProtectionProviderSpecificInput.
func (d *DisableProtectionProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &d.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoverProtectableItemRequest.
func (d DiscoverProtectableItemRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoverProtectableItemRequest.
func (d *DiscoverProtectableItemRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoverProtectableItemRequestProperties.
func (d DiscoverProtectableItemRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "ipAddress", d.IPAddress)
	populate(objectMap, "osType", d.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoverProtectableItemRequestProperties.
func (d *DiscoverProtectableItemRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &d.IPAddress)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &d.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskDetails.
func (d DiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxSizeMB", d.MaxSizeMB)
	populate(objectMap, "vhdId", d.VhdID)
	populate(objectMap, "vhdName", d.VhdName)
	populate(objectMap, "vhdType", d.VhdType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskDetails.
func (d *DiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxSizeMB":
			err = unpopulate(val, "MaxSizeMB", &d.MaxSizeMB)
			delete(rawMsg, key)
		case "vhdId":
			err = unpopulate(val, "VhdID", &d.VhdID)
			delete(rawMsg, key)
		case "vhdName":
			err = unpopulate(val, "VhdName", &d.VhdName)
			delete(rawMsg, key)
		case "vhdType":
			err = unpopulate(val, "VhdType", &d.VhdType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionInfo.
func (d DiskEncryptionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionKeyInfo", d.DiskEncryptionKeyInfo)
	populate(objectMap, "keyEncryptionKeyInfo", d.KeyEncryptionKeyInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionInfo.
func (d *DiskEncryptionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionKeyInfo":
			err = unpopulate(val, "DiskEncryptionKeyInfo", &d.DiskEncryptionKeyInfo)
			delete(rawMsg, key)
		case "keyEncryptionKeyInfo":
			err = unpopulate(val, "KeyEncryptionKeyInfo", &d.KeyEncryptionKeyInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionKeyInfo.
func (d DiskEncryptionKeyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultResourceArmId", d.KeyVaultResourceArmID)
	populate(objectMap, "secretIdentifier", d.SecretIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionKeyInfo.
func (d *DiskEncryptionKeyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultResourceArmId":
			err = unpopulate(val, "KeyVaultResourceArmID", &d.KeyVaultResourceArmID)
			delete(rawMsg, key)
		case "secretIdentifier":
			err = unpopulate(val, "SecretIdentifier", &d.SecretIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskVolumeDetails.
func (d DiskVolumeDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "label", d.Label)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskVolumeDetails.
func (d *DiskVolumeDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &d.Label)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Display.
func (d Display) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "operation", d.Operation)
	populate(objectMap, "provider", d.Provider)
	populate(objectMap, "resource", d.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Display.
func (d *Display) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &d.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &d.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &d.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraDetails.
func (d DraDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", d.BiosID)
	populate(objectMap, "forwardProtectedItemCount", d.ForwardProtectedItemCount)
	populate(objectMap, "health", d.Health)
	populate(objectMap, "healthErrors", d.HealthErrors)
	populate(objectMap, "id", d.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", d.LastHeartbeatUTC)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "reverseProtectedItemCount", d.ReverseProtectedItemCount)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraDetails.
func (d *DraDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &d.BiosID)
			delete(rawMsg, key)
		case "forwardProtectedItemCount":
			err = unpopulate(val, "ForwardProtectedItemCount", &d.ForwardProtectedItemCount)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &d.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &d.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &d.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "reverseProtectedItemCount":
			err = unpopulate(val, "ReverseProtectedItemCount", &d.ReverseProtectedItemCount)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableMigrationInput.
func (e EnableMigrationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableMigrationInput.
func (e *EnableMigrationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableMigrationInputProperties.
func (e EnableMigrationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyId", e.PolicyID)
	populate(objectMap, "providerSpecificDetails", e.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableMigrationInputProperties.
func (e *EnableMigrationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &e.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEnableMigrationProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableMigrationProviderSpecificInput.
func (e EnableMigrationProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = e.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableMigrationProviderSpecificInput.
func (e *EnableMigrationProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableProtectionInput.
func (e EnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableProtectionInput.
func (e *EnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableProtectionInputProperties.
func (e EnableProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyId", e.PolicyID)
	populate(objectMap, "protectableItemId", e.ProtectableItemID)
	populate(objectMap, "providerSpecificDetails", e.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableProtectionInputProperties.
func (e *EnableProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &e.PolicyID)
			delete(rawMsg, key)
		case "protectableItemId":
			err = unpopulate(val, "ProtectableItemID", &e.ProtectableItemID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEnableProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableProtectionProviderSpecificInput.
func (e EnableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = e.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableProtectionProviderSpecificInput.
func (e *EnableProtectionProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionDetails.
func (e EncryptionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "kekCertExpiryDate", e.KekCertExpiryDate)
	populate(objectMap, "kekCertThumbprint", e.KekCertThumbprint)
	populate(objectMap, "kekState", e.KekState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionDetails.
func (e *EncryptionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kekCertExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "KekCertExpiryDate", &e.KekCertExpiryDate)
			delete(rawMsg, key)
		case "kekCertThumbprint":
			err = unpopulate(val, "KekCertThumbprint", &e.KekCertThumbprint)
			delete(rawMsg, key)
		case "kekState":
			err = unpopulate(val, "KekState", &e.KekState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Event.
func (e *Event) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventCollection.
func (e EventCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventCollection.
func (e *EventCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventProperties.
func (e EventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectCorrelationId", e.AffectedObjectCorrelationID)
	populate(objectMap, "affectedObjectFriendlyName", e.AffectedObjectFriendlyName)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "eventCode", e.EventCode)
	populate(objectMap, "eventSpecificDetails", e.EventSpecificDetails)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "fabricId", e.FabricID)
	populate(objectMap, "healthErrors", e.HealthErrors)
	populate(objectMap, "providerSpecificDetails", e.ProviderSpecificDetails)
	populate(objectMap, "severity", e.Severity)
	populateDateTimeRFC3339(objectMap, "timeOfOccurrence", e.TimeOfOccurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProperties.
func (e *EventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectCorrelationId":
			err = unpopulate(val, "AffectedObjectCorrelationID", &e.AffectedObjectCorrelationID)
			delete(rawMsg, key)
		case "affectedObjectFriendlyName":
			err = unpopulate(val, "AffectedObjectFriendlyName", &e.AffectedObjectFriendlyName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "eventCode":
			err = unpopulate(val, "EventCode", &e.EventCode)
			delete(rawMsg, key)
		case "eventSpecificDetails":
			e.EventSpecificDetails, err = unmarshalEventSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "fabricId":
			err = unpopulate(val, "FabricID", &e.FabricID)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &e.HealthErrors)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEventProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "timeOfOccurrence":
			err = unpopulateDateTimeRFC3339(val, "TimeOfOccurrence", &e.TimeOfOccurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventProviderSpecificDetails.
func (e EventProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = e.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProviderSpecificDetails.
func (e *EventProviderSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventQueryParameter.
func (e EventQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectCorrelationId", e.AffectedObjectCorrelationID)
	populate(objectMap, "affectedObjectFriendlyName", e.AffectedObjectFriendlyName)
	populateDateTimeRFC3339(objectMap, "endTime", e.EndTime)
	populate(objectMap, "eventCode", e.EventCode)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "fabricName", e.FabricName)
	populate(objectMap, "severity", e.Severity)
	populateDateTimeRFC3339(objectMap, "startTime", e.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventQueryParameter.
func (e *EventQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectCorrelationId":
			err = unpopulate(val, "AffectedObjectCorrelationID", &e.AffectedObjectCorrelationID)
			delete(rawMsg, key)
		case "affectedObjectFriendlyName":
			err = unpopulate(val, "AffectedObjectFriendlyName", &e.AffectedObjectFriendlyName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &e.EndTime)
			delete(rawMsg, key)
		case "eventCode":
			err = unpopulate(val, "EventCode", &e.EventCode)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &e.FabricName)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &e.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSpecificDetails.
func (e EventSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = e.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSpecificDetails.
func (e *EventSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingProtectionProfile.
func (e ExistingProtectionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protectionProfileId", e.ProtectionProfileID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingProtectionProfile.
func (e *ExistingProtectionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protectionProfileId":
			err = unpopulate(val, "ProtectionProfileID", &e.ProtectionProfileID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryAvailabilitySet.
func (e ExistingRecoveryAvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryAvailabilitySetId", e.RecoveryAvailabilitySetID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryAvailabilitySet.
func (e *ExistingRecoveryAvailabilitySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &e.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryProximityPlacementGroup.
func (e ExistingRecoveryProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryProximityPlacementGroupId", e.RecoveryProximityPlacementGroupID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryProximityPlacementGroup.
func (e *ExistingRecoveryProximityPlacementGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &e.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryResourceGroup.
func (e ExistingRecoveryResourceGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryResourceGroupId", e.RecoveryResourceGroupID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryResourceGroup.
func (e *ExistingRecoveryResourceGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &e.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryVirtualNetwork.
func (e ExistingRecoveryVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoverySubnetName", e.RecoverySubnetName)
	populate(objectMap, "recoveryVirtualNetworkId", e.RecoveryVirtualNetworkID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryVirtualNetwork.
func (e *ExistingRecoveryVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &e.RecoverySubnetName)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkId":
			err = unpopulate(val, "RecoveryVirtualNetworkID", &e.RecoveryVirtualNetworkID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingStorageAccount.
func (e ExistingStorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureStorageAccountId", e.AzureStorageAccountID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingStorageAccount.
func (e *ExistingStorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureStorageAccountId":
			err = unpopulate(val, "AzureStorageAccountID", &e.AzureStorageAccountID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportJobDetails.
func (e ExportJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", e.AffectedObjectDetails)
	populate(objectMap, "blobUri", e.BlobURI)
	objectMap["instanceType"] = "ExportJobDetails"
	populate(objectMap, "sasToken", e.SasToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportJobDetails.
func (e *ExportJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &e.AffectedObjectDetails)
			delete(rawMsg, key)
		case "blobUri":
			err = unpopulate(val, "BlobURI", &e.BlobURI)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &e.SasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Fabric.
func (f Fabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Fabric.
func (f *Fabric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricCollection.
func (f FabricCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricCollection.
func (f *FabricCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricCreationInput.
func (f FabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricCreationInput.
func (f *FabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricCreationInputProperties.
func (f FabricCreationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDetails", f.CustomDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricCreationInputProperties.
func (f *FabricCreationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDetails":
			f.CustomDetails, err = unmarshalFabricSpecificCreationInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricProperties.
func (f FabricProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bcdrState", f.BcdrState)
	populate(objectMap, "customDetails", f.CustomDetails)
	populate(objectMap, "encryptionDetails", f.EncryptionDetails)
	populate(objectMap, "friendlyName", f.FriendlyName)
	populate(objectMap, "health", f.Health)
	populate(objectMap, "healthErrorDetails", f.HealthErrorDetails)
	populate(objectMap, "internalIdentifier", f.InternalIdentifier)
	populate(objectMap, "rolloverEncryptionDetails", f.RolloverEncryptionDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricProperties.
func (f *FabricProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bcdrState":
			err = unpopulate(val, "BcdrState", &f.BcdrState)
			delete(rawMsg, key)
		case "customDetails":
			f.CustomDetails, err = unmarshalFabricSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "encryptionDetails":
			err = unpopulate(val, "EncryptionDetails", &f.EncryptionDetails)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &f.Health)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &f.HealthErrorDetails)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &f.InternalIdentifier)
			delete(rawMsg, key)
		case "rolloverEncryptionDetails":
			err = unpopulate(val, "RolloverEncryptionDetails", &f.RolloverEncryptionDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricQueryParameter.
func (f FabricQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", f.BiosID)
	populate(objectMap, "discoveryType", f.DiscoveryType)
	populate(objectMap, "extendedLocationMappings", f.ExtendedLocationMappings)
	populate(objectMap, "fetchAgentDetails", f.FetchAgentDetails)
	populate(objectMap, "fqdn", f.Fqdn)
	populate(objectMap, "locationDetails", f.LocationDetails)
	populate(objectMap, "osType", f.OSType)
	populate(objectMap, "zoneToZoneMappings", f.ZoneToZoneMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricQueryParameter.
func (f *FabricQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &f.BiosID)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &f.DiscoveryType)
			delete(rawMsg, key)
		case "extendedLocationMappings":
			err = unpopulate(val, "ExtendedLocationMappings", &f.ExtendedLocationMappings)
			delete(rawMsg, key)
		case "fetchAgentDetails":
			err = unpopulate(val, "FetchAgentDetails", &f.FetchAgentDetails)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &f.Fqdn)
			delete(rawMsg, key)
		case "locationDetails":
			err = unpopulate(val, "LocationDetails", &f.LocationDetails)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &f.OSType)
			delete(rawMsg, key)
		case "zoneToZoneMappings":
			err = unpopulate(val, "ZoneToZoneMappings", &f.ZoneToZoneMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricReplicationGroupTaskDetails.
func (f FabricReplicationGroupTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "FabricReplicationGroupTaskDetails"
	populate(objectMap, "jobTask", f.JobTask)
	populate(objectMap, "skippedReason", f.SkippedReason)
	populate(objectMap, "skippedReasonString", f.SkippedReasonString)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &f.JobTask)
			delete(rawMsg, key)
		case "skippedReason":
			err = unpopulate(val, "SkippedReason", &f.SkippedReason)
			delete(rawMsg, key)
		case "skippedReasonString":
			err = unpopulate(val, "SkippedReasonString", &f.SkippedReasonString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricSpecificCreateNetworkMappingInput.
func (f FabricSpecificCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = f.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricSpecificCreateNetworkMappingInput.
func (f *FabricSpecificCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricSpecificCreationInput.
func (f FabricSpecificCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = f.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricSpecificCreationInput.
func (f *FabricSpecificCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricSpecificDetails.
func (f FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = f.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricSpecificDetails.
func (f *FabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricSpecificUpdateNetworkMappingInput.
func (f FabricSpecificUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = f.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricSpecificUpdateNetworkMappingInput.
func (f *FabricSpecificUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverJobDetails.
func (f FailoverJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", f.AffectedObjectDetails)
	objectMap["instanceType"] = "FailoverJobDetails"
	populate(objectMap, "protectedItemDetails", f.ProtectedItemDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverJobDetails.
func (f *FailoverJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &f.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &f.ProtectedItemDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverProcessServerRequest.
func (f FailoverProcessServerRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverProcessServerRequest.
func (f *FailoverProcessServerRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverProcessServerRequestProperties.
func (f FailoverProcessServerRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", f.ContainerName)
	populate(objectMap, "sourceProcessServerId", f.SourceProcessServerID)
	populate(objectMap, "targetProcessServerId", f.TargetProcessServerID)
	populate(objectMap, "updateType", f.UpdateType)
	populate(objectMap, "vmsToMigrate", f.VMsToMigrate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverProcessServerRequestProperties.
func (f *FailoverProcessServerRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &f.ContainerName)
			delete(rawMsg, key)
		case "sourceProcessServerId":
			err = unpopulate(val, "SourceProcessServerID", &f.SourceProcessServerID)
			delete(rawMsg, key)
		case "targetProcessServerId":
			err = unpopulate(val, "TargetProcessServerID", &f.TargetProcessServerID)
			delete(rawMsg, key)
		case "updateType":
			err = unpopulate(val, "UpdateType", &f.UpdateType)
			delete(rawMsg, key)
		case "vmsToMigrate":
			err = unpopulate(val, "VMsToMigrate", &f.VMsToMigrate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverReplicationProtectedItemDetails.
func (f FailoverReplicationProtectedItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", f.FriendlyName)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "networkConnectionStatus", f.NetworkConnectionStatus)
	populate(objectMap, "networkFriendlyName", f.NetworkFriendlyName)
	populate(objectMap, "recoveryPointId", f.RecoveryPointID)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", f.RecoveryPointTime)
	populate(objectMap, "subnet", f.Subnet)
	populate(objectMap, "testVmFriendlyName", f.TestVMFriendlyName)
	populate(objectMap, "testVmName", f.TestVMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverReplicationProtectedItemDetails.
func (f *FailoverReplicationProtectedItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "networkConnectionStatus":
			err = unpopulate(val, "NetworkConnectionStatus", &f.NetworkConnectionStatus)
			delete(rawMsg, key)
		case "networkFriendlyName":
			err = unpopulate(val, "NetworkFriendlyName", &f.NetworkFriendlyName)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &f.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &f.RecoveryPointTime)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &f.Subnet)
			delete(rawMsg, key)
		case "testVmFriendlyName":
			err = unpopulate(val, "TestVMFriendlyName", &f.TestVMFriendlyName)
			delete(rawMsg, key)
		case "testVmName":
			err = unpopulate(val, "TestVMName", &f.TestVMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayOperationDetails.
func (g GatewayOperationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataStores", g.DataStores)
	populate(objectMap, "hostName", g.HostName)
	populate(objectMap, "progressPercentage", g.ProgressPercentage)
	populate(objectMap, "state", g.State)
	populate(objectMap, "timeElapsed", g.TimeElapsed)
	populate(objectMap, "timeRemaining", g.TimeRemaining)
	populate(objectMap, "uploadSpeed", g.UploadSpeed)
	populate(objectMap, "vmwareReadThroughput", g.VmwareReadThroughput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayOperationDetails.
func (g *GatewayOperationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStores":
			err = unpopulate(val, "DataStores", &g.DataStores)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &g.HostName)
			delete(rawMsg, key)
		case "progressPercentage":
			err = unpopulate(val, "ProgressPercentage", &g.ProgressPercentage)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "timeElapsed":
			err = unpopulate(val, "TimeElapsed", &g.TimeElapsed)
			delete(rawMsg, key)
		case "timeRemaining":
			err = unpopulate(val, "TimeRemaining", &g.TimeRemaining)
			delete(rawMsg, key)
		case "uploadSpeed":
			err = unpopulate(val, "UploadSpeed", &g.UploadSpeed)
			delete(rawMsg, key)
		case "vmwareReadThroughput":
			err = unpopulate(val, "VmwareReadThroughput", &g.VmwareReadThroughput)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupTaskDetails.
func (g GroupTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "childTasks", g.ChildTasks)
	objectMap["instanceType"] = g.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupTaskDetails.
func (g *GroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &g.ChildTasks)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &g.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthError.
func (h HealthError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTimeUtc", h.CreationTimeUTC)
	populate(objectMap, "customerResolvability", h.CustomerResolvability)
	populate(objectMap, "entityId", h.EntityID)
	populate(objectMap, "errorCategory", h.ErrorCategory)
	populate(objectMap, "errorCode", h.ErrorCode)
	populate(objectMap, "errorId", h.ErrorID)
	populate(objectMap, "errorLevel", h.ErrorLevel)
	populate(objectMap, "errorMessage", h.ErrorMessage)
	populate(objectMap, "errorSource", h.ErrorSource)
	populate(objectMap, "errorType", h.ErrorType)
	populate(objectMap, "innerHealthErrors", h.InnerHealthErrors)
	populate(objectMap, "possibleCauses", h.PossibleCauses)
	populate(objectMap, "recommendedAction", h.RecommendedAction)
	populate(objectMap, "recoveryProviderErrorMessage", h.RecoveryProviderErrorMessage)
	populate(objectMap, "summaryMessage", h.SummaryMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthError.
func (h *HealthError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreationTimeUTC", &h.CreationTimeUTC)
			delete(rawMsg, key)
		case "customerResolvability":
			err = unpopulate(val, "CustomerResolvability", &h.CustomerResolvability)
			delete(rawMsg, key)
		case "entityId":
			err = unpopulate(val, "EntityID", &h.EntityID)
			delete(rawMsg, key)
		case "errorCategory":
			err = unpopulate(val, "ErrorCategory", &h.ErrorCategory)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &h.ErrorCode)
			delete(rawMsg, key)
		case "errorId":
			err = unpopulate(val, "ErrorID", &h.ErrorID)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &h.ErrorLevel)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &h.ErrorMessage)
			delete(rawMsg, key)
		case "errorSource":
			err = unpopulate(val, "ErrorSource", &h.ErrorSource)
			delete(rawMsg, key)
		case "errorType":
			err = unpopulate(val, "ErrorType", &h.ErrorType)
			delete(rawMsg, key)
		case "innerHealthErrors":
			err = unpopulate(val, "InnerHealthErrors", &h.InnerHealthErrors)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &h.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &h.RecommendedAction)
			delete(rawMsg, key)
		case "recoveryProviderErrorMessage":
			err = unpopulate(val, "RecoveryProviderErrorMessage", &h.RecoveryProviderErrorMessage)
			delete(rawMsg, key)
		case "summaryMessage":
			err = unpopulate(val, "SummaryMessage", &h.SummaryMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthErrorSummary.
func (h HealthErrorSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedResourceCorrelationIds", h.AffectedResourceCorrelationIDs)
	populate(objectMap, "affectedResourceSubtype", h.AffectedResourceSubtype)
	populate(objectMap, "affectedResourceType", h.AffectedResourceType)
	populate(objectMap, "category", h.Category)
	populate(objectMap, "severity", h.Severity)
	populate(objectMap, "summaryCode", h.SummaryCode)
	populate(objectMap, "summaryMessage", h.SummaryMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthErrorSummary.
func (h *HealthErrorSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedResourceCorrelationIds":
			err = unpopulate(val, "AffectedResourceCorrelationIDs", &h.AffectedResourceCorrelationIDs)
			delete(rawMsg, key)
		case "affectedResourceSubtype":
			err = unpopulate(val, "AffectedResourceSubtype", &h.AffectedResourceSubtype)
			delete(rawMsg, key)
		case "affectedResourceType":
			err = unpopulate(val, "AffectedResourceType", &h.AffectedResourceType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &h.Category)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &h.Severity)
			delete(rawMsg, key)
		case "summaryCode":
			err = unpopulate(val, "SummaryCode", &h.SummaryCode)
			delete(rawMsg, key)
		case "summaryMessage":
			err = unpopulate(val, "SummaryMessage", &h.SummaryMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVHostDetails.
func (h HyperVHostDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "marsAgentVersion", h.MarsAgentVersion)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVHostDetails.
func (h *HyperVHostDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "marsAgentVersion":
			err = unpopulate(val, "MarsAgentVersion", &h.MarsAgentVersion)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplica2012EventDetails.
func (h HyperVReplica2012EventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", h.ContainerName)
	populate(objectMap, "fabricName", h.FabricName)
	objectMap["instanceType"] = "HyperVReplica2012"
	populate(objectMap, "remoteContainerName", h.RemoteContainerName)
	populate(objectMap, "remoteFabricName", h.RemoteFabricName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplica2012EventDetails.
func (h *HyperVReplica2012EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplica2012R2EventDetails.
func (h HyperVReplica2012R2EventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", h.ContainerName)
	populate(objectMap, "fabricName", h.FabricName)
	objectMap["instanceType"] = "HyperVReplica2012R2"
	populate(objectMap, "remoteContainerName", h.RemoteContainerName)
	populate(objectMap, "remoteFabricName", h.RemoteFabricName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplica2012R2EventDetails.
func (h *HyperVReplica2012R2EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h HyperVReplicaAzureApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h *HyperVReplicaAzureApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureDiskInputDetails.
func (h HyperVReplicaAzureDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", h.DiskEncryptionSetID)
	populate(objectMap, "diskId", h.DiskID)
	populate(objectMap, "diskType", h.DiskType)
	populate(objectMap, "logStorageAccountId", h.LogStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureDiskInputDetails.
func (h *HyperVReplicaAzureDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &h.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &h.DiskID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &h.DiskType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &h.LogStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureEnableProtectionInput.
func (h HyperVReplicaAzureEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", h.DiskEncryptionSetID)
	populate(objectMap, "diskType", h.DiskType)
	populate(objectMap, "disksToInclude", h.DisksToInclude)
	populate(objectMap, "disksToIncludeForManagedDisks", h.DisksToIncludeForManagedDisks)
	populate(objectMap, "enableRdpOnTargetOption", h.EnableRdpOnTargetOption)
	populate(objectMap, "hvHostVmId", h.HvHostVMID)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "licenseType", h.LicenseType)
	populate(objectMap, "logStorageAccountId", h.LogStorageAccountID)
	populate(objectMap, "osType", h.OSType)
	populate(objectMap, "sqlServerLicenseType", h.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", h.SeedManagedDiskTags)
	populate(objectMap, "targetAvailabilitySetId", h.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", h.TargetAvailabilityZone)
	populate(objectMap, "targetAzureNetworkId", h.TargetAzureNetworkID)
	populate(objectMap, "targetAzureSubnetId", h.TargetAzureSubnetID)
	populate(objectMap, "targetAzureV1ResourceGroupId", h.TargetAzureV1ResourceGroupID)
	populate(objectMap, "targetAzureV2ResourceGroupId", h.TargetAzureV2ResourceGroupID)
	populate(objectMap, "targetAzureVmName", h.TargetAzureVMName)
	populate(objectMap, "targetManagedDiskTags", h.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", h.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", h.TargetProximityPlacementGroupID)
	populate(objectMap, "targetStorageAccountId", h.TargetStorageAccountID)
	populate(objectMap, "targetVmSize", h.TargetVMSize)
	populate(objectMap, "targetVmTags", h.TargetVMTags)
	populate(objectMap, "useManagedDisks", h.UseManagedDisks)
	populate(objectMap, "useManagedDisksForReplication", h.UseManagedDisksForReplication)
	populate(objectMap, "vmName", h.VMName)
	populate(objectMap, "vhdId", h.VhdID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureEnableProtectionInput.
func (h *HyperVReplicaAzureEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &h.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &h.DiskType)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &h.DisksToInclude)
			delete(rawMsg, key)
		case "disksToIncludeForManagedDisks":
			err = unpopulate(val, "DisksToIncludeForManagedDisks", &h.DisksToIncludeForManagedDisks)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &h.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "hvHostVmId":
			err = unpopulate(val, "HvHostVMID", &h.HvHostVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &h.LicenseType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &h.LogStorageAccountID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &h.OSType)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &h.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &h.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetAzureNetworkId":
			err = unpopulate(val, "TargetAzureNetworkID", &h.TargetAzureNetworkID)
			delete(rawMsg, key)
		case "targetAzureSubnetId":
			err = unpopulate(val, "TargetAzureSubnetID", &h.TargetAzureSubnetID)
			delete(rawMsg, key)
		case "targetAzureV1ResourceGroupId":
			err = unpopulate(val, "TargetAzureV1ResourceGroupID", &h.TargetAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureV2ResourceGroupId":
			err = unpopulate(val, "TargetAzureV2ResourceGroupID", &h.TargetAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureVmName":
			err = unpopulate(val, "TargetAzureVMName", &h.TargetAzureVMName)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetStorageAccountId":
			err = unpopulate(val, "TargetStorageAccountID", &h.TargetStorageAccountID)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &h.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "useManagedDisksForReplication":
			err = unpopulate(val, "UseManagedDisksForReplication", &h.UseManagedDisksForReplication)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &h.VMName)
			delete(rawMsg, key)
		case "vhdId":
			err = unpopulate(val, "VhdID", &h.VhdID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureEventDetails.
func (h HyperVReplicaAzureEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", h.ContainerName)
	populate(objectMap, "fabricName", h.FabricName)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "remoteContainerName", h.RemoteContainerName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureEventDetails.
func (h *HyperVReplicaAzureEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureFailbackProviderInput.
func (h HyperVReplicaAzureFailbackProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSyncOption", h.DataSyncOption)
	objectMap["instanceType"] = "HyperVReplicaAzureFailback"
	populate(objectMap, "providerIdForAlternateRecovery", h.ProviderIDForAlternateRecovery)
	populate(objectMap, "recoveryVmCreationOption", h.RecoveryVMCreationOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureFailbackProviderInput.
func (h *HyperVReplicaAzureFailbackProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSyncOption":
			err = unpopulate(val, "DataSyncOption", &h.DataSyncOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "providerIdForAlternateRecovery":
			err = unpopulate(val, "ProviderIDForAlternateRecovery", &h.ProviderIDForAlternateRecovery)
			delete(rawMsg, key)
		case "recoveryVmCreationOption":
			err = unpopulate(val, "RecoveryVMCreationOption", &h.RecoveryVMCreationOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureManagedDiskDetails.
func (h HyperVReplicaAzureManagedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", h.DiskEncryptionSetID)
	populate(objectMap, "diskId", h.DiskID)
	populate(objectMap, "replicaDiskType", h.ReplicaDiskType)
	populate(objectMap, "seedManagedDiskId", h.SeedManagedDiskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureManagedDiskDetails.
func (h *HyperVReplicaAzureManagedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &h.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &h.DiskID)
			delete(rawMsg, key)
		case "replicaDiskType":
			err = unpopulate(val, "ReplicaDiskType", &h.ReplicaDiskType)
			delete(rawMsg, key)
		case "seedManagedDiskId":
			err = unpopulate(val, "SeedManagedDiskID", &h.SeedManagedDiskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h HyperVReplicaAzurePlannedFailoverProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "osUpgradeVersion", h.OSUpgradeVersion)
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h *HyperVReplicaAzurePlannedFailoverProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &h.OSUpgradeVersion)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzurePolicyDetails.
func (h HyperVReplicaAzurePolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeStorageAccountId", h.ActiveStorageAccountID)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "encryption", h.Encryption)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPointHistoryDurationInHours", h.RecoveryPointHistoryDurationInHours)
	populate(objectMap, "replicationInterval", h.ReplicationInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePolicyDetails.
func (h *HyperVReplicaAzurePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeStorageAccountId":
			err = unpopulate(val, "ActiveStorageAccountID", &h.ActiveStorageAccountID)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &h.Encryption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPointHistoryDurationInHours":
			err = unpopulate(val, "RecoveryPointHistoryDurationInHours", &h.RecoveryPointHistoryDurationInHours)
			delete(rawMsg, key)
		case "replicationInterval":
			err = unpopulate(val, "ReplicationInterval", &h.ReplicationInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzurePolicyInput.
func (h HyperVReplicaAzurePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPointHistoryDuration", h.RecoveryPointHistoryDuration)
	populate(objectMap, "replicationInterval", h.ReplicationInterval)
	populate(objectMap, "storageAccounts", h.StorageAccounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePolicyInput.
func (h *HyperVReplicaAzurePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPointHistoryDuration":
			err = unpopulate(val, "RecoveryPointHistoryDuration", &h.RecoveryPointHistoryDuration)
			delete(rawMsg, key)
		case "replicationInterval":
			err = unpopulate(val, "ReplicationInterval", &h.ReplicationInterval)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &h.StorageAccounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureReplicationDetails.
func (h HyperVReplicaAzureReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allAvailableOSUpgradeConfigurations", h.AllAvailableOSUpgradeConfigurations)
	populate(objectMap, "azureVmDiskDetails", h.AzureVMDiskDetails)
	populate(objectMap, "enableRdpOnTargetOption", h.EnableRdpOnTargetOption)
	populate(objectMap, "encryption", h.Encryption)
	populate(objectMap, "initialReplicationDetails", h.InitialReplicationDetails)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", h.LastRecoveryPointReceived)
	populateDateTimeRFC3339(objectMap, "lastReplicatedTime", h.LastReplicatedTime)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", h.LastRpoCalculatedTime)
	populate(objectMap, "licenseType", h.LicenseType)
	populate(objectMap, "oSDetails", h.OSDetails)
	populate(objectMap, "protectedManagedDisks", h.ProtectedManagedDisks)
	populate(objectMap, "recoveryAvailabilitySetId", h.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAzureLogStorageAccountId", h.RecoveryAzureLogStorageAccountID)
	populate(objectMap, "recoveryAzureResourceGroupId", h.RecoveryAzureResourceGroupID)
	populate(objectMap, "recoveryAzureStorageAccount", h.RecoveryAzureStorageAccount)
	populate(objectMap, "recoveryAzureVmName", h.RecoveryAzureVMName)
	populate(objectMap, "recoveryAzureVMSize", h.RecoveryAzureVMSize)
	populate(objectMap, "rpoInSeconds", h.RpoInSeconds)
	populate(objectMap, "sqlServerLicenseType", h.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", h.SeedManagedDiskTags)
	populate(objectMap, "selectedRecoveryAzureNetworkId", h.SelectedRecoveryAzureNetworkID)
	populate(objectMap, "selectedSourceNicId", h.SelectedSourceNicID)
	populate(objectMap, "sourceVmCpuCount", h.SourceVMCPUCount)
	populate(objectMap, "sourceVmRamSizeInMB", h.SourceVMRAMSizeInMB)
	populate(objectMap, "targetAvailabilityZone", h.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", h.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", h.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", h.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmTags", h.TargetVMTags)
	populate(objectMap, "useManagedDisks", h.UseManagedDisks)
	populate(objectMap, "vmId", h.VMID)
	populate(objectMap, "vmNics", h.VMNics)
	populate(objectMap, "vmProtectionState", h.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", h.VMProtectionStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureReplicationDetails.
func (h *HyperVReplicaAzureReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allAvailableOSUpgradeConfigurations":
			err = unpopulate(val, "AllAvailableOSUpgradeConfigurations", &h.AllAvailableOSUpgradeConfigurations)
			delete(rawMsg, key)
		case "azureVmDiskDetails":
			err = unpopulate(val, "AzureVMDiskDetails", &h.AzureVMDiskDetails)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &h.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &h.Encryption)
			delete(rawMsg, key)
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &h.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &h.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &h.LicenseType)
			delete(rawMsg, key)
		case "oSDetails":
			err = unpopulate(val, "OSDetails", &h.OSDetails)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &h.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &h.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureLogStorageAccountId":
			err = unpopulate(val, "RecoveryAzureLogStorageAccountID", &h.RecoveryAzureLogStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &h.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccount":
			err = unpopulate(val, "RecoveryAzureStorageAccount", &h.RecoveryAzureStorageAccount)
			delete(rawMsg, key)
		case "recoveryAzureVmName":
			err = unpopulate(val, "RecoveryAzureVMName", &h.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &h.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &h.RpoInSeconds)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &h.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &h.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &h.SelectedSourceNicID)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &h.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &h.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureReprotectInput.
func (h HyperVReplicaAzureReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hvHostVmId", h.HvHostVMID)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "logStorageAccountId", h.LogStorageAccountID)
	populate(objectMap, "osType", h.OSType)
	populate(objectMap, "storageAccountId", h.StorageAccountID)
	populate(objectMap, "vHDId", h.VHDID)
	populate(objectMap, "vmName", h.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureReprotectInput.
func (h *HyperVReplicaAzureReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hvHostVmId":
			err = unpopulate(val, "HvHostVMID", &h.HvHostVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &h.LogStorageAccountID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &h.OSType)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &h.StorageAccountID)
			delete(rawMsg, key)
		case "vHDId":
			err = unpopulate(val, "VHDID", &h.VHDID)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &h.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureTestFailoverInput.
func (h HyperVReplicaAzureTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "osUpgradeVersion", h.OSUpgradeVersion)
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureTestFailoverInput.
func (h *HyperVReplicaAzureTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &h.OSUpgradeVersion)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureUnplannedFailoverInput.
func (h HyperVReplicaAzureUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureUnplannedFailoverInput.
func (h *HyperVReplicaAzureUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h HyperVReplicaAzureUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskIdToDiskEncryptionMap", h.DiskIDToDiskEncryptionMap)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "recoveryAzureV1ResourceGroupId", h.RecoveryAzureV1ResourceGroupID)
	populate(objectMap, "recoveryAzureV2ResourceGroupId", h.RecoveryAzureV2ResourceGroupID)
	populate(objectMap, "sqlServerLicenseType", h.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilityZone", h.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", h.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", h.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", h.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmTags", h.TargetVMTags)
	populate(objectMap, "useManagedDisks", h.UseManagedDisks)
	populate(objectMap, "vmDisks", h.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h *HyperVReplicaAzureUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskIdToDiskEncryptionMap":
			err = unpopulate(val, "DiskIDToDiskEncryptionMap", &h.DiskIDToDiskEncryptionMap)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "recoveryAzureV1ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV1ResourceGroupID", &h.RecoveryAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureV2ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV2ResourceGroupID", &h.RecoveryAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &h.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBaseEventDetails.
func (h HyperVReplicaBaseEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerName", h.ContainerName)
	populate(objectMap, "fabricName", h.FabricName)
	objectMap["instanceType"] = "HyperVReplicaBaseEventDetails"
	populate(objectMap, "remoteContainerName", h.RemoteContainerName)
	populate(objectMap, "remoteFabricName", h.RemoteFabricName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBaseEventDetails.
func (h *HyperVReplicaBaseEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBasePolicyDetails.
func (h HyperVReplicaBasePolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplicaBasePolicyDetails"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletionOption", h.ReplicaDeletionOption)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBasePolicyDetails.
func (h *HyperVReplicaBasePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBaseReplicationDetails.
func (h HyperVReplicaBaseReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialReplicationDetails", h.InitialReplicationDetails)
	objectMap["instanceType"] = "HyperVReplicaBaseReplicationDetails"
	populateDateTimeRFC3339(objectMap, "lastReplicatedTime", h.LastReplicatedTime)
	populate(objectMap, "vMDiskDetails", h.VMDiskDetails)
	populate(objectMap, "vmId", h.VMID)
	populate(objectMap, "vmNics", h.VMNics)
	populate(objectMap, "vmProtectionState", h.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", h.VMProtectionStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBaseReplicationDetails.
func (h *HyperVReplicaBaseReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBluePolicyDetails.
func (h HyperVReplicaBluePolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012R2"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletionOption", h.ReplicaDeletionOption)
	populate(objectMap, "replicationFrequencyInSeconds", h.ReplicationFrequencyInSeconds)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBluePolicyDetails.
func (h *HyperVReplicaBluePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationFrequencyInSeconds":
			err = unpopulate(val, "ReplicationFrequencyInSeconds", &h.ReplicationFrequencyInSeconds)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBluePolicyInput.
func (h HyperVReplicaBluePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012R2"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletion", h.ReplicaDeletion)
	populate(objectMap, "replicationFrequencyInSeconds", h.ReplicationFrequencyInSeconds)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletion":
			err = unpopulate(val, "ReplicaDeletion", &h.ReplicaDeletion)
			delete(rawMsg, key)
		case "replicationFrequencyInSeconds":
			err = unpopulate(val, "ReplicationFrequencyInSeconds", &h.ReplicationFrequencyInSeconds)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBlueReplicationDetails.
func (h HyperVReplicaBlueReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialReplicationDetails", h.InitialReplicationDetails)
	objectMap["instanceType"] = "HyperVReplica2012R2"
	populateDateTimeRFC3339(objectMap, "lastReplicatedTime", h.LastReplicatedTime)
	populate(objectMap, "vMDiskDetails", h.VMDiskDetails)
	populate(objectMap, "vmId", h.VMID)
	populate(objectMap, "vmNics", h.VMNics)
	populate(objectMap, "vmProtectionState", h.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", h.VMProtectionStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBlueReplicationDetails.
func (h *HyperVReplicaBlueReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaPolicyDetails.
func (h HyperVReplicaPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletionOption", h.ReplicaDeletionOption)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaPolicyDetails.
func (h *HyperVReplicaPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaPolicyInput.
func (h HyperVReplicaPolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletion", h.ReplicaDeletion)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletion":
			err = unpopulate(val, "ReplicaDeletion", &h.ReplicaDeletion)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaReplicationDetails.
func (h HyperVReplicaReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialReplicationDetails", h.InitialReplicationDetails)
	objectMap["instanceType"] = "HyperVReplica2012"
	populateDateTimeRFC3339(objectMap, "lastReplicatedTime", h.LastReplicatedTime)
	populate(objectMap, "vMDiskDetails", h.VMDiskDetails)
	populate(objectMap, "vmId", h.VMID)
	populate(objectMap, "vmNics", h.VMNics)
	populate(objectMap, "vmProtectionState", h.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", h.VMProtectionStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaReplicationDetails.
func (h *HyperVReplicaReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVSiteDetails.
func (h HyperVSiteDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hyperVHosts", h.HyperVHosts)
	objectMap["instanceType"] = "HyperVSite"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVSiteDetails.
func (h *HyperVSiteDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hyperVHosts":
			err = unpopulate(val, "HyperVHosts", &h.HyperVHosts)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVVirtualMachineDetails.
func (h HyperVVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskDetails", h.DiskDetails)
	populate(objectMap, "generation", h.Generation)
	populate(objectMap, "hasFibreChannelAdapter", h.HasFibreChannelAdapter)
	populate(objectMap, "hasPhysicalDisk", h.HasPhysicalDisk)
	populate(objectMap, "hasSharedVhd", h.HasSharedVhd)
	populate(objectMap, "hyperVHostId", h.HyperVHostID)
	objectMap["instanceType"] = "HyperVVirtualMachine"
	populate(objectMap, "osDetails", h.OSDetails)
	populate(objectMap, "sourceItemId", h.SourceItemID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &h.DiskDetails)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &h.Generation)
			delete(rawMsg, key)
		case "hasFibreChannelAdapter":
			err = unpopulate(val, "HasFibreChannelAdapter", &h.HasFibreChannelAdapter)
			delete(rawMsg, key)
		case "hasPhysicalDisk":
			err = unpopulate(val, "HasPhysicalDisk", &h.HasPhysicalDisk)
			delete(rawMsg, key)
		case "hasSharedVhd":
			err = unpopulate(val, "HasSharedVhd", &h.HasSharedVhd)
			delete(rawMsg, key)
		case "hyperVHostId":
			err = unpopulate(val, "HyperVHostID", &h.HyperVHostID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &h.OSDetails)
			delete(rawMsg, key)
		case "sourceItemId":
			err = unpopulate(val, "SourceItemID", &h.SourceItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigDetails.
func (i IPConfigDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddressType", i.IPAddressType)
	populate(objectMap, "isPrimary", i.IsPrimary)
	populate(objectMap, "isSeletedForFailover", i.IsSeletedForFailover)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "recoveryIPAddressType", i.RecoveryIPAddressType)
	populate(objectMap, "recoveryLBBackendAddressPoolIds", i.RecoveryLBBackendAddressPoolIDs)
	populate(objectMap, "recoveryPublicIPAddressId", i.RecoveryPublicIPAddressID)
	populate(objectMap, "recoveryStaticIPAddress", i.RecoveryStaticIPAddress)
	populate(objectMap, "recoverySubnetName", i.RecoverySubnetName)
	populate(objectMap, "staticIPAddress", i.StaticIPAddress)
	populate(objectMap, "subnetName", i.SubnetName)
	populate(objectMap, "tfoLBBackendAddressPoolIds", i.TfoLBBackendAddressPoolIDs)
	populate(objectMap, "tfoPublicIPAddressId", i.TfoPublicIPAddressID)
	populate(objectMap, "tfoStaticIPAddress", i.TfoStaticIPAddress)
	populate(objectMap, "tfoSubnetName", i.TfoSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigDetails.
func (i *IPConfigDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddressType":
			err = unpopulate(val, "IPAddressType", &i.IPAddressType)
			delete(rawMsg, key)
		case "isPrimary":
			err = unpopulate(val, "IsPrimary", &i.IsPrimary)
			delete(rawMsg, key)
		case "isSeletedForFailover":
			err = unpopulate(val, "IsSeletedForFailover", &i.IsSeletedForFailover)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "recoveryIPAddressType":
			err = unpopulate(val, "RecoveryIPAddressType", &i.RecoveryIPAddressType)
			delete(rawMsg, key)
		case "recoveryLBBackendAddressPoolIds":
			err = unpopulate(val, "RecoveryLBBackendAddressPoolIDs", &i.RecoveryLBBackendAddressPoolIDs)
			delete(rawMsg, key)
		case "recoveryPublicIPAddressId":
			err = unpopulate(val, "RecoveryPublicIPAddressID", &i.RecoveryPublicIPAddressID)
			delete(rawMsg, key)
		case "recoveryStaticIPAddress":
			err = unpopulate(val, "RecoveryStaticIPAddress", &i.RecoveryStaticIPAddress)
			delete(rawMsg, key)
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &i.RecoverySubnetName)
			delete(rawMsg, key)
		case "staticIPAddress":
			err = unpopulate(val, "StaticIPAddress", &i.StaticIPAddress)
			delete(rawMsg, key)
		case "subnetName":
			err = unpopulate(val, "SubnetName", &i.SubnetName)
			delete(rawMsg, key)
		case "tfoLBBackendAddressPoolIds":
			err = unpopulate(val, "TfoLBBackendAddressPoolIDs", &i.TfoLBBackendAddressPoolIDs)
			delete(rawMsg, key)
		case "tfoPublicIPAddressId":
			err = unpopulate(val, "TfoPublicIPAddressID", &i.TfoPublicIPAddressID)
			delete(rawMsg, key)
		case "tfoStaticIPAddress":
			err = unpopulate(val, "TfoStaticIPAddress", &i.TfoStaticIPAddress)
			delete(rawMsg, key)
		case "tfoSubnetName":
			err = unpopulate(val, "TfoSubnetName", &i.TfoSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigInputDetails.
func (i IPConfigInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipConfigName", i.IPConfigName)
	populate(objectMap, "isPrimary", i.IsPrimary)
	populate(objectMap, "isSeletedForFailover", i.IsSeletedForFailover)
	populate(objectMap, "recoveryLBBackendAddressPoolIds", i.RecoveryLBBackendAddressPoolIDs)
	populate(objectMap, "recoveryPublicIPAddressId", i.RecoveryPublicIPAddressID)
	populate(objectMap, "recoveryStaticIPAddress", i.RecoveryStaticIPAddress)
	populate(objectMap, "recoverySubnetName", i.RecoverySubnetName)
	populate(objectMap, "tfoLBBackendAddressPoolIds", i.TfoLBBackendAddressPoolIDs)
	populate(objectMap, "tfoPublicIPAddressId", i.TfoPublicIPAddressID)
	populate(objectMap, "tfoStaticIPAddress", i.TfoStaticIPAddress)
	populate(objectMap, "tfoSubnetName", i.TfoSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigInputDetails.
func (i *IPConfigInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipConfigName":
			err = unpopulate(val, "IPConfigName", &i.IPConfigName)
			delete(rawMsg, key)
		case "isPrimary":
			err = unpopulate(val, "IsPrimary", &i.IsPrimary)
			delete(rawMsg, key)
		case "isSeletedForFailover":
			err = unpopulate(val, "IsSeletedForFailover", &i.IsSeletedForFailover)
			delete(rawMsg, key)
		case "recoveryLBBackendAddressPoolIds":
			err = unpopulate(val, "RecoveryLBBackendAddressPoolIDs", &i.RecoveryLBBackendAddressPoolIDs)
			delete(rawMsg, key)
		case "recoveryPublicIPAddressId":
			err = unpopulate(val, "RecoveryPublicIPAddressID", &i.RecoveryPublicIPAddressID)
			delete(rawMsg, key)
		case "recoveryStaticIPAddress":
			err = unpopulate(val, "RecoveryStaticIPAddress", &i.RecoveryStaticIPAddress)
			delete(rawMsg, key)
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &i.RecoverySubnetName)
			delete(rawMsg, key)
		case "tfoLBBackendAddressPoolIds":
			err = unpopulate(val, "TfoLBBackendAddressPoolIDs", &i.TfoLBBackendAddressPoolIDs)
			delete(rawMsg, key)
		case "tfoPublicIPAddressId":
			err = unpopulate(val, "TfoPublicIPAddressID", &i.TfoPublicIPAddressID)
			delete(rawMsg, key)
		case "tfoStaticIPAddress":
			err = unpopulate(val, "TfoStaticIPAddress", &i.TfoStaticIPAddress)
			delete(rawMsg, key)
		case "tfoSubnetName":
			err = unpopulate(val, "TfoSubnetName", &i.TfoSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderDetails.
func (i IdentityProviderDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadAuthority", i.AADAuthority)
	populate(objectMap, "applicationId", i.ApplicationID)
	populate(objectMap, "audience", i.Audience)
	populate(objectMap, "objectId", i.ObjectID)
	populate(objectMap, "tenantId", i.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderDetails.
func (i *IdentityProviderDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAuthority":
			err = unpopulate(val, "AADAuthority", &i.AADAuthority)
			delete(rawMsg, key)
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &i.ApplicationID)
			delete(rawMsg, key)
		case "audience":
			err = unpopulate(val, "Audience", &i.Audience)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &i.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProviderInput.
func (i IdentityProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadAuthority", i.AADAuthority)
	populate(objectMap, "applicationId", i.ApplicationID)
	populate(objectMap, "audience", i.Audience)
	populate(objectMap, "objectId", i.ObjectID)
	populate(objectMap, "tenantId", i.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProviderInput.
func (i *IdentityProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAuthority":
			err = unpopulate(val, "AADAuthority", &i.AADAuthority)
			delete(rawMsg, key)
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &i.ApplicationID)
			delete(rawMsg, key)
		case "audience":
			err = unpopulate(val, "Audience", &i.Audience)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &i.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAgentDetails.
func (i InMageAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", i.AgentExpiryDate)
	populate(objectMap, "agentUpdateStatus", i.AgentUpdateStatus)
	populate(objectMap, "agentVersion", i.AgentVersion)
	populate(objectMap, "postUpdateRebootStatus", i.PostUpdateRebootStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAgentDetails.
func (i *InMageAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &i.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentUpdateStatus":
			err = unpopulate(val, "AgentUpdateStatus", &i.AgentUpdateStatus)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &i.AgentVersion)
			delete(rawMsg, key)
		case "postUpdateRebootStatus":
			err = unpopulate(val, "PostUpdateRebootStatus", &i.PostUpdateRebootStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ApplyRecoveryPointInput.
func (i InMageAzureV2ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ApplyRecoveryPointInput.
func (i *InMageAzureV2ApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2DiskInputDetails.
func (i InMageAzureV2DiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2DiskInputDetails.
func (i *InMageAzureV2DiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2EnableProtectionInput.
func (i InMageAzureV2EnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	populate(objectMap, "enableRdpOnTargetOption", i.EnableRdpOnTargetOption)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "sqlServerLicenseType", i.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", i.SeedManagedDiskTags)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetAzureNetworkId", i.TargetAzureNetworkID)
	populate(objectMap, "targetAzureSubnetId", i.TargetAzureSubnetID)
	populate(objectMap, "targetAzureV1ResourceGroupId", i.TargetAzureV1ResourceGroupID)
	populate(objectMap, "targetAzureV2ResourceGroupId", i.TargetAzureV2ResourceGroupID)
	populate(objectMap, "targetAzureVmName", i.TargetAzureVMName)
	populate(objectMap, "targetManagedDiskTags", i.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", i.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "targetVmTags", i.TargetVMTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2EnableProtectionInput.
func (i *InMageAzureV2EnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &i.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &i.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetAzureNetworkId":
			err = unpopulate(val, "TargetAzureNetworkID", &i.TargetAzureNetworkID)
			delete(rawMsg, key)
		case "targetAzureSubnetId":
			err = unpopulate(val, "TargetAzureSubnetID", &i.TargetAzureSubnetID)
			delete(rawMsg, key)
		case "targetAzureV1ResourceGroupId":
			err = unpopulate(val, "TargetAzureV1ResourceGroupID", &i.TargetAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureV2ResourceGroupId":
			err = unpopulate(val, "TargetAzureV2ResourceGroupID", &i.TargetAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureVmName":
			err = unpopulate(val, "TargetAzureVMName", &i.TargetAzureVMName)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2EventDetails.
func (i InMageAzureV2EventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "component", i.Component)
	populate(objectMap, "correctiveAction", i.CorrectiveAction)
	populate(objectMap, "details", i.Details)
	populate(objectMap, "eventType", i.EventType)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "siteName", i.SiteName)
	populate(objectMap, "summary", i.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2EventDetails.
func (i *InMageAzureV2EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "component":
			err = unpopulate(val, "Component", &i.Component)
			delete(rawMsg, key)
		case "correctiveAction":
			err = unpopulate(val, "CorrectiveAction", &i.CorrectiveAction)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &i.Details)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &i.EventType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &i.SiteName)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &i.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ManagedDiskDetails.
func (i InMageAzureV2ManagedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "replicaDiskType", i.ReplicaDiskType)
	populate(objectMap, "seedManagedDiskId", i.SeedManagedDiskID)
	populate(objectMap, "targetDiskName", i.TargetDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ManagedDiskDetails.
func (i *InMageAzureV2ManagedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "replicaDiskType":
			err = unpopulate(val, "ReplicaDiskType", &i.ReplicaDiskType)
			delete(rawMsg, key)
		case "seedManagedDiskId":
			err = unpopulate(val, "SeedManagedDiskID", &i.SeedManagedDiskID)
			delete(rawMsg, key)
		case "targetDiskName":
			err = unpopulate(val, "TargetDiskName", &i.TargetDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2PolicyDetails.
func (i InMageAzureV2PolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2PolicyDetails.
func (i *InMageAzureV2PolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2PolicyInput.
func (i InMageAzureV2PolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2PolicyInput.
func (i *InMageAzureV2PolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ProtectedDiskDetails.
func (i InMageAzureV2ProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskCapacityInBytes", i.DiskCapacityInBytes)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskName", i.DiskName)
	populate(objectMap, "diskResized", i.DiskResized)
	populate(objectMap, "fileSystemCapacityInBytes", i.FileSystemCapacityInBytes)
	populate(objectMap, "healthErrorCode", i.HealthErrorCode)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", i.LastRpoCalculatedTime)
	populate(objectMap, "progressHealth", i.ProgressHealth)
	populate(objectMap, "progressStatus", i.ProgressStatus)
	populate(objectMap, "protectionStage", i.ProtectionStage)
	populate(objectMap, "psDataInMegaBytes", i.PsDataInMegaBytes)
	populate(objectMap, "resyncDurationInSeconds", i.ResyncDurationInSeconds)
	populate(objectMap, "resyncLast15MinutesTransferredBytes", i.ResyncLast15MinutesTransferredBytes)
	populateDateTimeRFC3339(objectMap, "resyncLastDataTransferTimeUTC", i.ResyncLastDataTransferTimeUTC)
	populate(objectMap, "resyncProcessedBytes", i.ResyncProcessedBytes)
	populate(objectMap, "resyncProgressPercentage", i.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", i.ResyncRequired)
	populateDateTimeRFC3339(objectMap, "resyncStartTime", i.ResyncStartTime)
	populate(objectMap, "resyncTotalTransferredBytes", i.ResyncTotalTransferredBytes)
	populate(objectMap, "rpoInSeconds", i.RpoInSeconds)
	populate(objectMap, "secondsToTakeSwitchProvider", i.SecondsToTakeSwitchProvider)
	populate(objectMap, "sourceDataInMegaBytes", i.SourceDataInMegaBytes)
	populate(objectMap, "targetDataInMegaBytes", i.TargetDataInMegaBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ProtectedDiskDetails.
func (i *InMageAzureV2ProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &i.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "fileSystemCapacityInBytes":
			err = unpopulate(val, "FileSystemCapacityInBytes", &i.FileSystemCapacityInBytes)
			delete(rawMsg, key)
		case "healthErrorCode":
			err = unpopulate(val, "HealthErrorCode", &i.HealthErrorCode)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressStatus":
			err = unpopulate(val, "ProgressStatus", &i.ProgressStatus)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "psDataInMegaBytes":
			err = unpopulate(val, "PsDataInMegaBytes", &i.PsDataInMegaBytes)
			delete(rawMsg, key)
		case "resyncDurationInSeconds":
			err = unpopulate(val, "ResyncDurationInSeconds", &i.ResyncDurationInSeconds)
			delete(rawMsg, key)
		case "resyncLast15MinutesTransferredBytes":
			err = unpopulate(val, "ResyncLast15MinutesTransferredBytes", &i.ResyncLast15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "resyncLastDataTransferTimeUTC":
			err = unpopulateDateTimeRFC3339(val, "ResyncLastDataTransferTimeUTC", &i.ResyncLastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncStartTime":
			err = unpopulateDateTimeRFC3339(val, "ResyncStartTime", &i.ResyncStartTime)
			delete(rawMsg, key)
		case "resyncTotalTransferredBytes":
			err = unpopulate(val, "ResyncTotalTransferredBytes", &i.ResyncTotalTransferredBytes)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "secondsToTakeSwitchProvider":
			err = unpopulate(val, "SecondsToTakeSwitchProvider", &i.SecondsToTakeSwitchProvider)
			delete(rawMsg, key)
		case "sourceDataInMegaBytes":
			err = unpopulate(val, "SourceDataInMegaBytes", &i.SourceDataInMegaBytes)
			delete(rawMsg, key)
		case "targetDataInMegaBytes":
			err = unpopulate(val, "TargetDataInMegaBytes", &i.TargetDataInMegaBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2RecoveryPointDetails.
func (i InMageAzureV2RecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "isMultiVmSyncPoint", i.IsMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2RecoveryPointDetails.
func (i *InMageAzureV2RecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isMultiVmSyncPoint":
			err = unpopulate(val, "IsMultiVMSyncPoint", &i.IsMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ReplicationDetails.
func (i InMageAzureV2ReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", i.AgentExpiryDate)
	populate(objectMap, "agentVersion", i.AgentVersion)
	populate(objectMap, "allAvailableOSUpgradeConfigurations", i.AllAvailableOSUpgradeConfigurations)
	populate(objectMap, "azureVMDiskDetails", i.AzureVMDiskDetails)
	populate(objectMap, "azureVmGeneration", i.AzureVMGeneration)
	populate(objectMap, "compressedDataRateInMB", i.CompressedDataRateInMB)
	populate(objectMap, "datastores", i.Datastores)
	populate(objectMap, "discoveryType", i.DiscoveryType)
	populate(objectMap, "diskResized", i.DiskResized)
	populate(objectMap, "enableRdpOnTargetOption", i.EnableRdpOnTargetOption)
	populate(objectMap, "firmwareType", i.FirmwareType)
	populate(objectMap, "ipAddress", i.IPAddress)
	populate(objectMap, "infrastructureVmId", i.InfrastructureVMID)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "isAdditionalStatsAvailable", i.IsAdditionalStatsAvailable)
	populate(objectMap, "isAgentUpdateRequired", i.IsAgentUpdateRequired)
	populate(objectMap, "isRebootAfterUpdateRequired", i.IsRebootAfterUpdateRequired)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", i.LastHeartbeat)
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", i.LastRecoveryPointReceived)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", i.LastRpoCalculatedTime)
	populateDateTimeRFC3339(objectMap, "lastUpdateReceivedTime", i.LastUpdateReceivedTime)
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "osDiskId", i.OSDiskID)
	populate(objectMap, "osName", i.OSName)
	populate(objectMap, "osType", i.OSType)
	populate(objectMap, "osVersion", i.OSVersion)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "processServerName", i.ProcessServerName)
	populate(objectMap, "protectedDisks", i.ProtectedDisks)
	populate(objectMap, "protectedManagedDisks", i.ProtectedManagedDisks)
	populate(objectMap, "protectionStage", i.ProtectionStage)
	populate(objectMap, "recoveryAvailabilitySetId", i.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAzureLogStorageAccountId", i.RecoveryAzureLogStorageAccountID)
	populate(objectMap, "recoveryAzureResourceGroupId", i.RecoveryAzureResourceGroupID)
	populate(objectMap, "recoveryAzureStorageAccount", i.RecoveryAzureStorageAccount)
	populate(objectMap, "recoveryAzureVMName", i.RecoveryAzureVMName)
	populate(objectMap, "recoveryAzureVMSize", i.RecoveryAzureVMSize)
	populate(objectMap, "replicaId", i.ReplicaID)
	populate(objectMap, "resyncProgressPercentage", i.ResyncProgressPercentage)
	populate(objectMap, "rpoInSeconds", i.RpoInSeconds)
	populate(objectMap, "sqlServerLicenseType", i.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", i.SeedManagedDiskTags)
	populate(objectMap, "selectedRecoveryAzureNetworkId", i.SelectedRecoveryAzureNetworkID)
	populate(objectMap, "selectedSourceNicId", i.SelectedSourceNicID)
	populate(objectMap, "selectedTfoAzureNetworkId", i.SelectedTfoAzureNetworkID)
	populate(objectMap, "sourceVmCpuCount", i.SourceVMCPUCount)
	populate(objectMap, "sourceVmRamSizeInMB", i.SourceVMRAMSizeInMB)
	populate(objectMap, "supportedOSVersions", i.SupportedOSVersions)
	populate(objectMap, "switchProviderBlockingErrorDetails", i.SwitchProviderBlockingErrorDetails)
	populate(objectMap, "switchProviderDetails", i.SwitchProviderDetails)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", i.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", i.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmId", i.TargetVMID)
	populate(objectMap, "targetVmTags", i.TargetVMTags)
	populate(objectMap, "totalDataTransferred", i.TotalDataTransferred)
	populate(objectMap, "totalProgressHealth", i.TotalProgressHealth)
	populate(objectMap, "uncompressedDataRateInMB", i.UncompressedDataRateInMB)
	populate(objectMap, "useManagedDisks", i.UseManagedDisks)
	populate(objectMap, "vCenterInfrastructureId", i.VCenterInfrastructureID)
	populate(objectMap, "vmId", i.VMID)
	populate(objectMap, "vmNics", i.VMNics)
	populate(objectMap, "vmProtectionState", i.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", i.VMProtectionStateDescription)
	populate(objectMap, "validationErrors", i.ValidationErrors)
	populate(objectMap, "vhdName", i.VhdName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ReplicationDetails.
func (i *InMageAzureV2ReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &i.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &i.AgentVersion)
			delete(rawMsg, key)
		case "allAvailableOSUpgradeConfigurations":
			err = unpopulate(val, "AllAvailableOSUpgradeConfigurations", &i.AllAvailableOSUpgradeConfigurations)
			delete(rawMsg, key)
		case "azureVMDiskDetails":
			err = unpopulate(val, "AzureVMDiskDetails", &i.AzureVMDiskDetails)
			delete(rawMsg, key)
		case "azureVmGeneration":
			err = unpopulate(val, "AzureVMGeneration", &i.AzureVMGeneration)
			delete(rawMsg, key)
		case "compressedDataRateInMB":
			err = unpopulate(val, "CompressedDataRateInMB", &i.CompressedDataRateInMB)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &i.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &i.FirmwareType)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "infrastructureVmId":
			err = unpopulate(val, "InfrastructureVMID", &i.InfrastructureVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isAdditionalStatsAvailable":
			err = unpopulate(val, "IsAdditionalStatsAvailable", &i.IsAdditionalStatsAvailable)
			delete(rawMsg, key)
		case "isAgentUpdateRequired":
			err = unpopulate(val, "IsAgentUpdateRequired", &i.IsAgentUpdateRequired)
			delete(rawMsg, key)
		case "isRebootAfterUpdateRequired":
			err = unpopulate(val, "IsRebootAfterUpdateRequired", &i.IsRebootAfterUpdateRequired)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &i.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &i.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastUpdateReceivedTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateReceivedTime", &i.LastUpdateReceivedTime)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "osDiskId":
			err = unpopulate(val, "OSDiskID", &i.OSDiskID)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &i.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &i.OSVersion)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "processServerName":
			err = unpopulate(val, "ProcessServerName", &i.ProcessServerName)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &i.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &i.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureLogStorageAccountId":
			err = unpopulate(val, "RecoveryAzureLogStorageAccountID", &i.RecoveryAzureLogStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &i.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccount":
			err = unpopulate(val, "RecoveryAzureStorageAccount", &i.RecoveryAzureStorageAccount)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &i.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &i.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "replicaId":
			err = unpopulate(val, "ReplicaID", &i.ReplicaID)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &i.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &i.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &i.SelectedSourceNicID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &i.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &i.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &i.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "supportedOSVersions":
			err = unpopulate(val, "SupportedOSVersions", &i.SupportedOSVersions)
			delete(rawMsg, key)
		case "switchProviderBlockingErrorDetails":
			err = unpopulate(val, "SwitchProviderBlockingErrorDetails", &i.SwitchProviderBlockingErrorDetails)
			delete(rawMsg, key)
		case "switchProviderDetails":
			err = unpopulate(val, "SwitchProviderDetails", &i.SwitchProviderDetails)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmId":
			err = unpopulate(val, "TargetVMID", &i.TargetVMID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		case "totalDataTransferred":
			err = unpopulate(val, "TotalDataTransferred", &i.TotalDataTransferred)
			delete(rawMsg, key)
		case "totalProgressHealth":
			err = unpopulate(val, "TotalProgressHealth", &i.TotalProgressHealth)
			delete(rawMsg, key)
		case "uncompressedDataRateInMB":
			err = unpopulate(val, "UncompressedDataRateInMB", &i.UncompressedDataRateInMB)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &i.UseManagedDisks)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &i.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &i.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &i.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &i.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &i.ValidationErrors)
			delete(rawMsg, key)
		case "vhdName":
			err = unpopulate(val, "VhdName", &i.VhdName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ReprotectInput.
func (i InMageAzureV2ReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ReprotectInput.
func (i *InMageAzureV2ReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2SwitchProviderBlockingErrorDetails.
func (i InMageAzureV2SwitchProviderBlockingErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorMessageParameters", i.ErrorMessageParameters)
	populate(objectMap, "errorTags", i.ErrorTags)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2SwitchProviderBlockingErrorDetails.
func (i *InMageAzureV2SwitchProviderBlockingErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorMessageParameters":
			err = unpopulate(val, "ErrorMessageParameters", &i.ErrorMessageParameters)
			delete(rawMsg, key)
		case "errorTags":
			err = unpopulate(val, "ErrorTags", &i.ErrorTags)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2SwitchProviderDetails.
func (i InMageAzureV2SwitchProviderDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetApplianceId", i.TargetApplianceID)
	populate(objectMap, "targetFabricId", i.TargetFabricID)
	populate(objectMap, "targetResourceId", i.TargetResourceID)
	populate(objectMap, "targetVaultId", i.TargetVaultID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2SwitchProviderDetails.
func (i *InMageAzureV2SwitchProviderDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetApplianceId":
			err = unpopulate(val, "TargetApplianceID", &i.TargetApplianceID)
			delete(rawMsg, key)
		case "targetFabricId":
			err = unpopulate(val, "TargetFabricID", &i.TargetFabricID)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &i.TargetResourceID)
			delete(rawMsg, key)
		case "targetVaultId":
			err = unpopulate(val, "TargetVaultID", &i.TargetVaultID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2SwitchProviderInput.
func (i InMageAzureV2SwitchProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "targetApplianceID", i.TargetApplianceID)
	populate(objectMap, "targetFabricID", i.TargetFabricID)
	populate(objectMap, "targetVaultID", i.TargetVaultID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2SwitchProviderInput.
func (i *InMageAzureV2SwitchProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "targetApplianceID":
			err = unpopulate(val, "TargetApplianceID", &i.TargetApplianceID)
			delete(rawMsg, key)
		case "targetFabricID":
			err = unpopulate(val, "TargetFabricID", &i.TargetFabricID)
			delete(rawMsg, key)
		case "targetVaultID":
			err = unpopulate(val, "TargetVaultID", &i.TargetVaultID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2TestFailoverInput.
func (i InMageAzureV2TestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "osUpgradeVersion", i.OSUpgradeVersion)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2TestFailoverInput.
func (i *InMageAzureV2TestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &i.OSUpgradeVersion)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2UnplannedFailoverInput.
func (i InMageAzureV2UnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "osUpgradeVersion", i.OSUpgradeVersion)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2UnplannedFailoverInput.
func (i *InMageAzureV2UnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &i.OSUpgradeVersion)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i InMageAzureV2UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryAzureV1ResourceGroupId", i.RecoveryAzureV1ResourceGroupID)
	populate(objectMap, "recoveryAzureV2ResourceGroupId", i.RecoveryAzureV2ResourceGroupID)
	populate(objectMap, "sqlServerLicenseType", i.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", i.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", i.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmTags", i.TargetVMTags)
	populate(objectMap, "useManagedDisks", i.UseManagedDisks)
	populate(objectMap, "vmDisks", i.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i *InMageAzureV2UpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryAzureV1ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV1ResourceGroupID", &i.RecoveryAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureV2ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV2ResourceGroupID", &i.RecoveryAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &i.UseManagedDisks)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &i.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageBasePolicyDetails.
func (i InMageBasePolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageBasePolicyDetails"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageBasePolicyDetails.
func (i *InMageBasePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDisableProtectionProviderSpecificInput.
func (i InMageDisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "replicaVmDeletionStatus", i.ReplicaVMDeletionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageDisableProtectionProviderSpecificInput.
func (i *InMageDisableProtectionProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "replicaVmDeletionStatus":
			err = unpopulate(val, "ReplicaVMDeletionStatus", &i.ReplicaVMDeletionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDiskDetails.
func (i InMageDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskConfiguration", i.DiskConfiguration)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskName", i.DiskName)
	populate(objectMap, "diskSizeInMB", i.DiskSizeInMB)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "volumeList", i.VolumeList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageDiskDetails.
func (i *InMageDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskConfiguration":
			err = unpopulate(val, "DiskConfiguration", &i.DiskConfiguration)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskSizeInMB":
			err = unpopulate(val, "DiskSizeInMB", &i.DiskSizeInMB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "volumeList":
			err = unpopulate(val, "VolumeList", &i.VolumeList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDiskExclusionInput.
func (i InMageDiskExclusionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSignatureOptions", i.DiskSignatureOptions)
	populate(objectMap, "volumeOptions", i.VolumeOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageDiskExclusionInput.
func (i *InMageDiskExclusionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSignatureOptions":
			err = unpopulate(val, "DiskSignatureOptions", &i.DiskSignatureOptions)
			delete(rawMsg, key)
		case "volumeOptions":
			err = unpopulate(val, "VolumeOptions", &i.VolumeOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDiskSignatureExclusionOptions.
func (i InMageDiskSignatureExclusionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSignature", i.DiskSignature)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageDiskSignatureExclusionOptions.
func (i *InMageDiskSignatureExclusionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSignature":
			err = unpopulate(val, "DiskSignature", &i.DiskSignature)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageEnableProtectionInput.
func (i InMageEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datastoreName", i.DatastoreName)
	populate(objectMap, "diskExclusionInput", i.DiskExclusionInput)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "retentionDrive", i.RetentionDrive)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "vmFriendlyName", i.VMFriendlyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageEnableProtectionInput.
func (i *InMageEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "diskExclusionInput":
			err = unpopulate(val, "DiskExclusionInput", &i.DiskExclusionInput)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "retentionDrive":
			err = unpopulate(val, "RetentionDrive", &i.RetentionDrive)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "vmFriendlyName":
			err = unpopulate(val, "VMFriendlyName", &i.VMFriendlyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageFabricSwitchProviderBlockingErrorDetails.
func (i InMageFabricSwitchProviderBlockingErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorMessageParameters", i.ErrorMessageParameters)
	populate(objectMap, "errorTags", i.ErrorTags)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageFabricSwitchProviderBlockingErrorDetails.
func (i *InMageFabricSwitchProviderBlockingErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorMessageParameters":
			err = unpopulate(val, "ErrorMessageParameters", &i.ErrorMessageParameters)
			delete(rawMsg, key)
		case "errorTags":
			err = unpopulate(val, "ErrorTags", &i.ErrorTags)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMagePolicyDetails.
func (i InMagePolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMagePolicyDetails.
func (i *InMagePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMagePolicyInput.
func (i InMagePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMagePolicyInput.
func (i *InMagePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageProtectedDiskDetails.
func (i InMageProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskCapacityInBytes", i.DiskCapacityInBytes)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskName", i.DiskName)
	populate(objectMap, "diskResized", i.DiskResized)
	populate(objectMap, "fileSystemCapacityInBytes", i.FileSystemCapacityInBytes)
	populate(objectMap, "healthErrorCode", i.HealthErrorCode)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", i.LastRpoCalculatedTime)
	populate(objectMap, "progressHealth", i.ProgressHealth)
	populate(objectMap, "progressStatus", i.ProgressStatus)
	populate(objectMap, "protectionStage", i.ProtectionStage)
	populate(objectMap, "psDataInMB", i.PsDataInMB)
	populate(objectMap, "resyncDurationInSeconds", i.ResyncDurationInSeconds)
	populate(objectMap, "resyncLast15MinutesTransferredBytes", i.ResyncLast15MinutesTransferredBytes)
	populateDateTimeRFC3339(objectMap, "resyncLastDataTransferTimeUTC", i.ResyncLastDataTransferTimeUTC)
	populate(objectMap, "resyncProcessedBytes", i.ResyncProcessedBytes)
	populate(objectMap, "resyncProgressPercentage", i.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", i.ResyncRequired)
	populateDateTimeRFC3339(objectMap, "resyncStartTime", i.ResyncStartTime)
	populate(objectMap, "resyncTotalTransferredBytes", i.ResyncTotalTransferredBytes)
	populate(objectMap, "rpoInSeconds", i.RpoInSeconds)
	populate(objectMap, "sourceDataInMB", i.SourceDataInMB)
	populate(objectMap, "targetDataInMB", i.TargetDataInMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageProtectedDiskDetails.
func (i *InMageProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &i.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "fileSystemCapacityInBytes":
			err = unpopulate(val, "FileSystemCapacityInBytes", &i.FileSystemCapacityInBytes)
			delete(rawMsg, key)
		case "healthErrorCode":
			err = unpopulate(val, "HealthErrorCode", &i.HealthErrorCode)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressStatus":
			err = unpopulate(val, "ProgressStatus", &i.ProgressStatus)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "psDataInMB":
			err = unpopulate(val, "PsDataInMB", &i.PsDataInMB)
			delete(rawMsg, key)
		case "resyncDurationInSeconds":
			err = unpopulate(val, "ResyncDurationInSeconds", &i.ResyncDurationInSeconds)
			delete(rawMsg, key)
		case "resyncLast15MinutesTransferredBytes":
			err = unpopulate(val, "ResyncLast15MinutesTransferredBytes", &i.ResyncLast15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "resyncLastDataTransferTimeUTC":
			err = unpopulateDateTimeRFC3339(val, "ResyncLastDataTransferTimeUTC", &i.ResyncLastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncStartTime":
			err = unpopulateDateTimeRFC3339(val, "ResyncStartTime", &i.ResyncStartTime)
			delete(rawMsg, key)
		case "resyncTotalTransferredBytes":
			err = unpopulate(val, "ResyncTotalTransferredBytes", &i.ResyncTotalTransferredBytes)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sourceDataInMB":
			err = unpopulate(val, "SourceDataInMB", &i.SourceDataInMB)
			delete(rawMsg, key)
		case "targetDataInMB":
			err = unpopulate(val, "TargetDataInMB", &i.TargetDataInMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmAgentUpgradeBlockingErrorDetails.
func (i InMageRcmAgentUpgradeBlockingErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorMessageParameters", i.ErrorMessageParameters)
	populate(objectMap, "errorTags", i.ErrorTags)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmAgentUpgradeBlockingErrorDetails.
func (i *InMageRcmAgentUpgradeBlockingErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorMessageParameters":
			err = unpopulate(val, "ErrorMessageParameters", &i.ErrorMessageParameters)
			delete(rawMsg, key)
		case "errorTags":
			err = unpopulate(val, "ErrorTags", &i.ErrorTags)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmApplianceDetails.
func (i InMageRcmApplianceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dra", i.Dra)
	populate(objectMap, "fabricArmId", i.FabricArmID)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "marsAgent", i.MarsAgent)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "processServer", i.ProcessServer)
	populate(objectMap, "pushInstaller", i.PushInstaller)
	populate(objectMap, "rcmProxy", i.RcmProxy)
	populate(objectMap, "replicationAgent", i.ReplicationAgent)
	populate(objectMap, "reprotectAgent", i.ReprotectAgent)
	populate(objectMap, "switchProviderBlockingErrorDetails", i.SwitchProviderBlockingErrorDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmApplianceDetails.
func (i *InMageRcmApplianceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dra":
			err = unpopulate(val, "Dra", &i.Dra)
			delete(rawMsg, key)
		case "fabricArmId":
			err = unpopulate(val, "FabricArmID", &i.FabricArmID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "marsAgent":
			err = unpopulate(val, "MarsAgent", &i.MarsAgent)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "processServer":
			err = unpopulate(val, "ProcessServer", &i.ProcessServer)
			delete(rawMsg, key)
		case "pushInstaller":
			err = unpopulate(val, "PushInstaller", &i.PushInstaller)
			delete(rawMsg, key)
		case "rcmProxy":
			err = unpopulate(val, "RcmProxy", &i.RcmProxy)
			delete(rawMsg, key)
		case "replicationAgent":
			err = unpopulate(val, "ReplicationAgent", &i.ReplicationAgent)
			delete(rawMsg, key)
		case "reprotectAgent":
			err = unpopulate(val, "ReprotectAgent", &i.ReprotectAgent)
			delete(rawMsg, key)
		case "switchProviderBlockingErrorDetails":
			err = unpopulate(val, "SwitchProviderBlockingErrorDetails", &i.SwitchProviderBlockingErrorDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmApplianceSpecificDetails.
func (i InMageRcmApplianceSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliances", i.Appliances)
	objectMap["instanceType"] = "InMageRcm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmApplianceSpecificDetails.
func (i *InMageRcmApplianceSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliances":
			err = unpopulate(val, "Appliances", &i.Appliances)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmApplyRecoveryPointInput.
func (i InMageRcmApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmApplyRecoveryPointInput.
func (i *InMageRcmApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmDiscoveredProtectedVMDetails.
func (i InMageRcmDiscoveredProtectedVMDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", i.CreatedTimestamp)
	populate(objectMap, "datastores", i.Datastores)
	populate(objectMap, "ipAddresses", i.IPAddresses)
	populate(objectMap, "isDeleted", i.IsDeleted)
	populateDateTimeRFC3339(objectMap, "lastDiscoveryTimeInUtc", i.LastDiscoveryTimeInUTC)
	populate(objectMap, "osName", i.OSName)
	populate(objectMap, "powerStatus", i.PowerStatus)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", i.UpdatedTimestamp)
	populate(objectMap, "vCenterFqdn", i.VCenterFqdn)
	populate(objectMap, "vCenterId", i.VCenterID)
	populate(objectMap, "vmFqdn", i.VMFqdn)
	populate(objectMap, "vmwareToolsStatus", i.VmwareToolsStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmDiscoveredProtectedVMDetails.
func (i *InMageRcmDiscoveredProtectedVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &i.CreatedTimestamp)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &i.IPAddresses)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &i.IsDeleted)
			delete(rawMsg, key)
		case "lastDiscoveryTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "LastDiscoveryTimeInUTC", &i.LastDiscoveryTimeInUTC)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &i.OSName)
			delete(rawMsg, key)
		case "powerStatus":
			err = unpopulate(val, "PowerStatus", &i.PowerStatus)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &i.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vCenterFqdn":
			err = unpopulate(val, "VCenterFqdn", &i.VCenterFqdn)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &i.VCenterID)
			delete(rawMsg, key)
		case "vmFqdn":
			err = unpopulate(val, "VMFqdn", &i.VMFqdn)
			delete(rawMsg, key)
		case "vmwareToolsStatus":
			err = unpopulate(val, "VmwareToolsStatus", &i.VmwareToolsStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmDiskInput.
func (i InMageRcmDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmDiskInput.
func (i *InMageRcmDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmDisksDefaultInput.
func (i InMageRcmDisksDefaultInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmDisksDefaultInput.
func (i *InMageRcmDisksDefaultInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmEnableProtectionInput.
func (i InMageRcmEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disksDefault", i.DisksDefault)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	populate(objectMap, "fabricDiscoveryMachineId", i.FabricDiscoveryMachineID)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", i.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetNetworkId", i.TargetNetworkID)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetSubnetName", i.TargetSubnetName)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "testNetworkId", i.TestNetworkID)
	populate(objectMap, "testSubnetName", i.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmEnableProtectionInput.
func (i *InMageRcmEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disksDefault":
			err = unpopulate(val, "DisksDefault", &i.DisksDefault)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &i.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &i.TargetSubnetName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &i.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmEventDetails.
func (i InMageRcmEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applianceName", i.ApplianceName)
	populate(objectMap, "componentDisplayName", i.ComponentDisplayName)
	populate(objectMap, "fabricName", i.FabricName)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "jobId", i.JobID)
	populate(objectMap, "latestAgentVersion", i.LatestAgentVersion)
	populate(objectMap, "protectedItemName", i.ProtectedItemName)
	populate(objectMap, "serverType", i.ServerType)
	populate(objectMap, "vmName", i.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmEventDetails.
func (i *InMageRcmEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceName":
			err = unpopulate(val, "ApplianceName", &i.ApplianceName)
			delete(rawMsg, key)
		case "componentDisplayName":
			err = unpopulate(val, "ComponentDisplayName", &i.ComponentDisplayName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &i.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &i.JobID)
			delete(rawMsg, key)
		case "latestAgentVersion":
			err = unpopulate(val, "LatestAgentVersion", &i.LatestAgentVersion)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &i.ProtectedItemName)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &i.ServerType)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &i.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFabricCreationInput.
func (i InMageRcmFabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "physicalSiteId", i.PhysicalSiteID)
	populate(objectMap, "sourceAgentIdentity", i.SourceAgentIdentity)
	populate(objectMap, "vmwareSiteId", i.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFabricCreationInput.
func (i *InMageRcmFabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &i.PhysicalSiteID)
			delete(rawMsg, key)
		case "sourceAgentIdentity":
			err = unpopulate(val, "SourceAgentIdentity", &i.SourceAgentIdentity)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &i.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFabricSpecificDetails.
func (i InMageRcmFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentDetails", i.AgentDetails)
	populate(objectMap, "controlPlaneUri", i.ControlPlaneURI)
	populate(objectMap, "dataPlaneUri", i.DataPlaneURI)
	populate(objectMap, "dras", i.Dras)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "marsAgents", i.MarsAgents)
	populate(objectMap, "physicalSiteId", i.PhysicalSiteID)
	populate(objectMap, "processServers", i.ProcessServers)
	populate(objectMap, "pushInstallers", i.PushInstallers)
	populate(objectMap, "rcmProxies", i.RcmProxies)
	populate(objectMap, "replicationAgents", i.ReplicationAgents)
	populate(objectMap, "reprotectAgents", i.ReprotectAgents)
	populate(objectMap, "serviceContainerId", i.ServiceContainerID)
	populate(objectMap, "serviceEndpoint", i.ServiceEndpoint)
	populate(objectMap, "serviceResourceId", i.ServiceResourceID)
	populate(objectMap, "sourceAgentIdentityDetails", i.SourceAgentIdentityDetails)
	populate(objectMap, "vmwareSiteId", i.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFabricSpecificDetails.
func (i *InMageRcmFabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentDetails":
			err = unpopulate(val, "AgentDetails", &i.AgentDetails)
			delete(rawMsg, key)
		case "controlPlaneUri":
			err = unpopulate(val, "ControlPlaneURI", &i.ControlPlaneURI)
			delete(rawMsg, key)
		case "dataPlaneUri":
			err = unpopulate(val, "DataPlaneURI", &i.DataPlaneURI)
			delete(rawMsg, key)
		case "dras":
			err = unpopulate(val, "Dras", &i.Dras)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "marsAgents":
			err = unpopulate(val, "MarsAgents", &i.MarsAgents)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &i.PhysicalSiteID)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &i.ProcessServers)
			delete(rawMsg, key)
		case "pushInstallers":
			err = unpopulate(val, "PushInstallers", &i.PushInstallers)
			delete(rawMsg, key)
		case "rcmProxies":
			err = unpopulate(val, "RcmProxies", &i.RcmProxies)
			delete(rawMsg, key)
		case "replicationAgents":
			err = unpopulate(val, "ReplicationAgents", &i.ReplicationAgents)
			delete(rawMsg, key)
		case "reprotectAgents":
			err = unpopulate(val, "ReprotectAgents", &i.ReprotectAgents)
			delete(rawMsg, key)
		case "serviceContainerId":
			err = unpopulate(val, "ServiceContainerID", &i.ServiceContainerID)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &i.ServiceEndpoint)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &i.ServiceResourceID)
			delete(rawMsg, key)
		case "sourceAgentIdentityDetails":
			err = unpopulate(val, "SourceAgentIdentityDetails", &i.SourceAgentIdentityDetails)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &i.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFabricSwitchProviderBlockingErrorDetails.
func (i InMageRcmFabricSwitchProviderBlockingErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorMessageParameters", i.ErrorMessageParameters)
	populate(objectMap, "errorTags", i.ErrorTags)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFabricSwitchProviderBlockingErrorDetails.
func (i *InMageRcmFabricSwitchProviderBlockingErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorMessageParameters":
			err = unpopulate(val, "ErrorMessageParameters", &i.ErrorMessageParameters)
			delete(rawMsg, key)
		case "errorTags":
			err = unpopulate(val, "ErrorTags", &i.ErrorTags)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackDiscoveredProtectedVMDetails.
func (i InMageRcmFailbackDiscoveredProtectedVMDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", i.CreatedTimestamp)
	populate(objectMap, "datastores", i.Datastores)
	populate(objectMap, "ipAddresses", i.IPAddresses)
	populate(objectMap, "isDeleted", i.IsDeleted)
	populateDateTimeRFC3339(objectMap, "lastDiscoveryTimeInUtc", i.LastDiscoveryTimeInUTC)
	populate(objectMap, "osName", i.OSName)
	populate(objectMap, "powerStatus", i.PowerStatus)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", i.UpdatedTimestamp)
	populate(objectMap, "vCenterFqdn", i.VCenterFqdn)
	populate(objectMap, "vCenterId", i.VCenterID)
	populate(objectMap, "vmFqdn", i.VMFqdn)
	populate(objectMap, "vmwareToolsStatus", i.VmwareToolsStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackDiscoveredProtectedVMDetails.
func (i *InMageRcmFailbackDiscoveredProtectedVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &i.CreatedTimestamp)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &i.IPAddresses)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &i.IsDeleted)
			delete(rawMsg, key)
		case "lastDiscoveryTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "LastDiscoveryTimeInUTC", &i.LastDiscoveryTimeInUTC)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &i.OSName)
			delete(rawMsg, key)
		case "powerStatus":
			err = unpopulate(val, "PowerStatus", &i.PowerStatus)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &i.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vCenterFqdn":
			err = unpopulate(val, "VCenterFqdn", &i.VCenterFqdn)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &i.VCenterID)
			delete(rawMsg, key)
		case "vmFqdn":
			err = unpopulate(val, "VMFqdn", &i.VMFqdn)
			delete(rawMsg, key)
		case "vmwareToolsStatus":
			err = unpopulate(val, "VmwareToolsStatus", &i.VmwareToolsStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackEventDetails.
func (i InMageRcmFailbackEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applianceName", i.ApplianceName)
	populate(objectMap, "componentDisplayName", i.ComponentDisplayName)
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "protectedItemName", i.ProtectedItemName)
	populate(objectMap, "serverType", i.ServerType)
	populate(objectMap, "vmName", i.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackEventDetails.
func (i *InMageRcmFailbackEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceName":
			err = unpopulate(val, "ApplianceName", &i.ApplianceName)
			delete(rawMsg, key)
		case "componentDisplayName":
			err = unpopulate(val, "ComponentDisplayName", &i.ComponentDisplayName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &i.ProtectedItemName)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &i.ServerType)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &i.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackMobilityAgentDetails.
func (i InMageRcmFailbackMobilityAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentVersionExpiryDate", i.AgentVersionExpiryDate)
	populate(objectMap, "driverVersion", i.DriverVersion)
	populateDateTimeRFC3339(objectMap, "driverVersionExpiryDate", i.DriverVersionExpiryDate)
	populate(objectMap, "isUpgradeable", i.IsUpgradeable)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", i.LastHeartbeatUTC)
	populate(objectMap, "latestUpgradableVersionWithoutReboot", i.LatestUpgradableVersionWithoutReboot)
	populate(objectMap, "latestVersion", i.LatestVersion)
	populate(objectMap, "reasonsBlockingUpgrade", i.ReasonsBlockingUpgrade)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackMobilityAgentDetails.
func (i *InMageRcmFailbackMobilityAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersionExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentVersionExpiryDate", &i.AgentVersionExpiryDate)
			delete(rawMsg, key)
		case "driverVersion":
			err = unpopulate(val, "DriverVersion", &i.DriverVersion)
			delete(rawMsg, key)
		case "driverVersionExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "DriverVersionExpiryDate", &i.DriverVersionExpiryDate)
			delete(rawMsg, key)
		case "isUpgradeable":
			err = unpopulate(val, "IsUpgradeable", &i.IsUpgradeable)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &i.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "latestUpgradableVersionWithoutReboot":
			err = unpopulate(val, "LatestUpgradableVersionWithoutReboot", &i.LatestUpgradableVersionWithoutReboot)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &i.LatestVersion)
			delete(rawMsg, key)
		case "reasonsBlockingUpgrade":
			err = unpopulate(val, "ReasonsBlockingUpgrade", &i.ReasonsBlockingUpgrade)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackNicDetails.
func (i InMageRcmFailbackNicDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adapterType", i.AdapterType)
	populate(objectMap, "macAddress", i.MacAddress)
	populate(objectMap, "networkName", i.NetworkName)
	populate(objectMap, "sourceIpAddress", i.SourceIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackNicDetails.
func (i *InMageRcmFailbackNicDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adapterType":
			err = unpopulate(val, "AdapterType", &i.AdapterType)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &i.MacAddress)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &i.NetworkName)
			delete(rawMsg, key)
		case "sourceIpAddress":
			err = unpopulate(val, "SourceIPAddress", &i.SourceIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i InMageRcmFailbackPlannedFailoverProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i *InMageRcmFailbackPlannedFailoverProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackPolicyCreationInput.
func (i InMageRcmFailbackPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageRcmFailback"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPolicyCreationInput.
func (i *InMageRcmFailbackPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackPolicyDetails.
func (i InMageRcmFailbackPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageRcmFailback"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPolicyDetails.
func (i *InMageRcmFailbackPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackProtectedDiskDetails.
func (i InMageRcmFailbackProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", i.CapacityInBytes)
	populate(objectMap, "dataPendingAtSourceAgentInMB", i.DataPendingAtSourceAgentInMB)
	populate(objectMap, "dataPendingInLogDataStoreInMB", i.DataPendingInLogDataStoreInMB)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskName", i.DiskName)
	populate(objectMap, "diskUuid", i.DiskUUID)
	populate(objectMap, "irDetails", i.IrDetails)
	populate(objectMap, "isInitialReplicationComplete", i.IsInitialReplicationComplete)
	populate(objectMap, "isOSDisk", i.IsOSDisk)
	populateDateTimeRFC3339(objectMap, "lastSyncTime", i.LastSyncTime)
	populate(objectMap, "resyncDetails", i.ResyncDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackProtectedDiskDetails.
func (i *InMageRcmFailbackProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &i.CapacityInBytes)
			delete(rawMsg, key)
		case "dataPendingAtSourceAgentInMB":
			err = unpopulate(val, "DataPendingAtSourceAgentInMB", &i.DataPendingAtSourceAgentInMB)
			delete(rawMsg, key)
		case "dataPendingInLogDataStoreInMB":
			err = unpopulate(val, "DataPendingInLogDataStoreInMB", &i.DataPendingInLogDataStoreInMB)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskUuid":
			err = unpopulate(val, "DiskUUID", &i.DiskUUID)
			delete(rawMsg, key)
		case "irDetails":
			err = unpopulate(val, "IrDetails", &i.IrDetails)
			delete(rawMsg, key)
		case "isInitialReplicationComplete":
			err = unpopulate(val, "IsInitialReplicationComplete", &i.IsInitialReplicationComplete)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &i.IsOSDisk)
			delete(rawMsg, key)
		case "lastSyncTime":
			err = unpopulateDateTimeRFC3339(val, "LastSyncTime", &i.LastSyncTime)
			delete(rawMsg, key)
		case "resyncDetails":
			err = unpopulate(val, "ResyncDetails", &i.ResyncDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackReplicationDetails.
func (i InMageRcmFailbackReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureVirtualMachineId", i.AzureVirtualMachineID)
	populate(objectMap, "discoveredVmDetails", i.DiscoveredVMDetails)
	populate(objectMap, "initialReplicationProcessedBytes", i.InitialReplicationProcessedBytes)
	populate(objectMap, "initialReplicationProgressHealth", i.InitialReplicationProgressHealth)
	populate(objectMap, "initialReplicationProgressPercentage", i.InitialReplicationProgressPercentage)
	populate(objectMap, "initialReplicationTransferredBytes", i.InitialReplicationTransferredBytes)
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "internalIdentifier", i.InternalIdentifier)
	populate(objectMap, "isAgentRegistrationSuccessfulAfterFailover", i.IsAgentRegistrationSuccessfulAfterFailover)
	populateDateTimeRFC3339(objectMap, "lastPlannedFailoverStartTime", i.LastPlannedFailoverStartTime)
	populate(objectMap, "lastPlannedFailoverStatus", i.LastPlannedFailoverStatus)
	populate(objectMap, "lastUsedPolicyFriendlyName", i.LastUsedPolicyFriendlyName)
	populate(objectMap, "lastUsedPolicyId", i.LastUsedPolicyID)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "mobilityAgentDetails", i.MobilityAgentDetails)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "osType", i.OSType)
	populate(objectMap, "protectedDisks", i.ProtectedDisks)
	populate(objectMap, "reprotectAgentId", i.ReprotectAgentID)
	populate(objectMap, "reprotectAgentName", i.ReprotectAgentName)
	populate(objectMap, "resyncProcessedBytes", i.ResyncProcessedBytes)
	populate(objectMap, "resyncProgressHealth", i.ResyncProgressHealth)
	populate(objectMap, "resyncProgressPercentage", i.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", i.ResyncRequired)
	populate(objectMap, "resyncState", i.ResyncState)
	populate(objectMap, "resyncTransferredBytes", i.ResyncTransferredBytes)
	populate(objectMap, "targetDataStoreName", i.TargetDataStoreName)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetvCenterId", i.TargetvCenterID)
	populate(objectMap, "vmNics", i.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackReplicationDetails.
func (i *InMageRcmFailbackReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureVirtualMachineId":
			err = unpopulate(val, "AzureVirtualMachineID", &i.AzureVirtualMachineID)
			delete(rawMsg, key)
		case "discoveredVmDetails":
			err = unpopulate(val, "DiscoveredVMDetails", &i.DiscoveredVMDetails)
			delete(rawMsg, key)
		case "initialReplicationProcessedBytes":
			err = unpopulate(val, "InitialReplicationProcessedBytes", &i.InitialReplicationProcessedBytes)
			delete(rawMsg, key)
		case "initialReplicationProgressHealth":
			err = unpopulate(val, "InitialReplicationProgressHealth", &i.InitialReplicationProgressHealth)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &i.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "initialReplicationTransferredBytes":
			err = unpopulate(val, "InitialReplicationTransferredBytes", &i.InitialReplicationTransferredBytes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &i.InternalIdentifier)
			delete(rawMsg, key)
		case "isAgentRegistrationSuccessfulAfterFailover":
			err = unpopulate(val, "IsAgentRegistrationSuccessfulAfterFailover", &i.IsAgentRegistrationSuccessfulAfterFailover)
			delete(rawMsg, key)
		case "lastPlannedFailoverStartTime":
			err = unpopulateDateTimeRFC3339(val, "LastPlannedFailoverStartTime", &i.LastPlannedFailoverStartTime)
			delete(rawMsg, key)
		case "lastPlannedFailoverStatus":
			err = unpopulate(val, "LastPlannedFailoverStatus", &i.LastPlannedFailoverStatus)
			delete(rawMsg, key)
		case "lastUsedPolicyFriendlyName":
			err = unpopulate(val, "LastUsedPolicyFriendlyName", &i.LastUsedPolicyFriendlyName)
			delete(rawMsg, key)
		case "lastUsedPolicyId":
			err = unpopulate(val, "LastUsedPolicyID", &i.LastUsedPolicyID)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "mobilityAgentDetails":
			err = unpopulate(val, "MobilityAgentDetails", &i.MobilityAgentDetails)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "reprotectAgentId":
			err = unpopulate(val, "ReprotectAgentID", &i.ReprotectAgentID)
			delete(rawMsg, key)
		case "reprotectAgentName":
			err = unpopulate(val, "ReprotectAgentName", &i.ReprotectAgentName)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressHealth":
			err = unpopulate(val, "ResyncProgressHealth", &i.ResyncProgressHealth)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &i.ResyncState)
			delete(rawMsg, key)
		case "resyncTransferredBytes":
			err = unpopulate(val, "ResyncTransferredBytes", &i.ResyncTransferredBytes)
			delete(rawMsg, key)
		case "targetDataStoreName":
			err = unpopulate(val, "TargetDataStoreName", &i.TargetDataStoreName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetvCenterId":
			err = unpopulate(val, "TargetvCenterID", &i.TargetvCenterID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackReprotectInput.
func (i InMageRcmFailbackReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackReprotectInput.
func (i *InMageRcmFailbackReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackSyncDetails.
func (i InMageRcmFailbackSyncDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "last15MinutesTransferredBytes", i.Last15MinutesTransferredBytes)
	populate(objectMap, "lastDataTransferTimeUtc", i.LastDataTransferTimeUTC)
	populate(objectMap, "lastRefreshTime", i.LastRefreshTime)
	populate(objectMap, "processedBytes", i.ProcessedBytes)
	populate(objectMap, "progressHealth", i.ProgressHealth)
	populate(objectMap, "progressPercentage", i.ProgressPercentage)
	populate(objectMap, "startTime", i.StartTime)
	populate(objectMap, "transferredBytes", i.TransferredBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackSyncDetails.
func (i *InMageRcmFailbackSyncDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "last15MinutesTransferredBytes":
			err = unpopulate(val, "Last15MinutesTransferredBytes", &i.Last15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "lastDataTransferTimeUtc":
			err = unpopulate(val, "LastDataTransferTimeUTC", &i.LastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "lastRefreshTime":
			err = unpopulate(val, "LastRefreshTime", &i.LastRefreshTime)
			delete(rawMsg, key)
		case "processedBytes":
			err = unpopulate(val, "ProcessedBytes", &i.ProcessedBytes)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressPercentage":
			err = unpopulate(val, "ProgressPercentage", &i.ProgressPercentage)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &i.StartTime)
			delete(rawMsg, key)
		case "transferredBytes":
			err = unpopulate(val, "TransferredBytes", &i.TransferredBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmLastAgentUpgradeErrorDetails.
func (i InMageRcmLastAgentUpgradeErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorMessageParameters", i.ErrorMessageParameters)
	populate(objectMap, "errorTags", i.ErrorTags)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmLastAgentUpgradeErrorDetails.
func (i *InMageRcmLastAgentUpgradeErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorMessageParameters":
			err = unpopulate(val, "ErrorMessageParameters", &i.ErrorMessageParameters)
			delete(rawMsg, key)
		case "errorTags":
			err = unpopulate(val, "ErrorTags", &i.ErrorTags)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmMobilityAgentDetails.
func (i InMageRcmMobilityAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentVersionExpiryDate", i.AgentVersionExpiryDate)
	populate(objectMap, "driverVersion", i.DriverVersion)
	populateDateTimeRFC3339(objectMap, "driverVersionExpiryDate", i.DriverVersionExpiryDate)
	populate(objectMap, "isUpgradeable", i.IsUpgradeable)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", i.LastHeartbeatUTC)
	populate(objectMap, "latestAgentReleaseDate", i.LatestAgentReleaseDate)
	populate(objectMap, "latestUpgradableVersionWithoutReboot", i.LatestUpgradableVersionWithoutReboot)
	populate(objectMap, "latestVersion", i.LatestVersion)
	populate(objectMap, "reasonsBlockingUpgrade", i.ReasonsBlockingUpgrade)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmMobilityAgentDetails.
func (i *InMageRcmMobilityAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersionExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentVersionExpiryDate", &i.AgentVersionExpiryDate)
			delete(rawMsg, key)
		case "driverVersion":
			err = unpopulate(val, "DriverVersion", &i.DriverVersion)
			delete(rawMsg, key)
		case "driverVersionExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "DriverVersionExpiryDate", &i.DriverVersionExpiryDate)
			delete(rawMsg, key)
		case "isUpgradeable":
			err = unpopulate(val, "IsUpgradeable", &i.IsUpgradeable)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &i.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "latestAgentReleaseDate":
			err = unpopulate(val, "LatestAgentReleaseDate", &i.LatestAgentReleaseDate)
			delete(rawMsg, key)
		case "latestUpgradableVersionWithoutReboot":
			err = unpopulate(val, "LatestUpgradableVersionWithoutReboot", &i.LatestUpgradableVersionWithoutReboot)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &i.LatestVersion)
			delete(rawMsg, key)
		case "reasonsBlockingUpgrade":
			err = unpopulate(val, "ReasonsBlockingUpgrade", &i.ReasonsBlockingUpgrade)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmNicDetails.
func (i InMageRcmNicDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPrimaryNic", i.IsPrimaryNic)
	populate(objectMap, "isSelectedForFailover", i.IsSelectedForFailover)
	populate(objectMap, "nicId", i.NicID)
	populate(objectMap, "sourceIPAddress", i.SourceIPAddress)
	populate(objectMap, "sourceIPAddressType", i.SourceIPAddressType)
	populate(objectMap, "sourceNetworkId", i.SourceNetworkID)
	populate(objectMap, "sourceSubnetName", i.SourceSubnetName)
	populate(objectMap, "targetIPAddress", i.TargetIPAddress)
	populate(objectMap, "targetIPAddressType", i.TargetIPAddressType)
	populate(objectMap, "targetSubnetName", i.TargetSubnetName)
	populate(objectMap, "testIPAddress", i.TestIPAddress)
	populate(objectMap, "testIPAddressType", i.TestIPAddressType)
	populate(objectMap, "testSubnetName", i.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmNicDetails.
func (i *InMageRcmNicDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPrimaryNic":
			err = unpopulate(val, "IsPrimaryNic", &i.IsPrimaryNic)
			delete(rawMsg, key)
		case "isSelectedForFailover":
			err = unpopulate(val, "IsSelectedForFailover", &i.IsSelectedForFailover)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &i.NicID)
			delete(rawMsg, key)
		case "sourceIPAddress":
			err = unpopulate(val, "SourceIPAddress", &i.SourceIPAddress)
			delete(rawMsg, key)
		case "sourceIPAddressType":
			err = unpopulate(val, "SourceIPAddressType", &i.SourceIPAddressType)
			delete(rawMsg, key)
		case "sourceNetworkId":
			err = unpopulate(val, "SourceNetworkID", &i.SourceNetworkID)
			delete(rawMsg, key)
		case "sourceSubnetName":
			err = unpopulate(val, "SourceSubnetName", &i.SourceSubnetName)
			delete(rawMsg, key)
		case "targetIPAddress":
			err = unpopulate(val, "TargetIPAddress", &i.TargetIPAddress)
			delete(rawMsg, key)
		case "targetIPAddressType":
			err = unpopulate(val, "TargetIPAddressType", &i.TargetIPAddressType)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &i.TargetSubnetName)
			delete(rawMsg, key)
		case "testIPAddress":
			err = unpopulate(val, "TestIPAddress", &i.TestIPAddress)
			delete(rawMsg, key)
		case "testIPAddressType":
			err = unpopulate(val, "TestIPAddressType", &i.TestIPAddressType)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &i.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmNicInput.
func (i InMageRcmNicInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPrimaryNic", i.IsPrimaryNic)
	populate(objectMap, "isSelectedForFailover", i.IsSelectedForFailover)
	populate(objectMap, "nicId", i.NicID)
	populate(objectMap, "targetStaticIPAddress", i.TargetStaticIPAddress)
	populate(objectMap, "targetSubnetName", i.TargetSubnetName)
	populate(objectMap, "testStaticIPAddress", i.TestStaticIPAddress)
	populate(objectMap, "testSubnetName", i.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmNicInput.
func (i *InMageRcmNicInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPrimaryNic":
			err = unpopulate(val, "IsPrimaryNic", &i.IsPrimaryNic)
			delete(rawMsg, key)
		case "isSelectedForFailover":
			err = unpopulate(val, "IsSelectedForFailover", &i.IsSelectedForFailover)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &i.NicID)
			delete(rawMsg, key)
		case "targetStaticIPAddress":
			err = unpopulate(val, "TargetStaticIPAddress", &i.TargetStaticIPAddress)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &i.TargetSubnetName)
			delete(rawMsg, key)
		case "testStaticIPAddress":
			err = unpopulate(val, "TestStaticIPAddress", &i.TestStaticIPAddress)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &i.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmPolicyCreationInput.
func (i InMageRcmPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	populate(objectMap, "enableMultiVmSync", i.EnableMultiVMSync)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointHistoryInMinutes", i.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmPolicyCreationInput.
func (i *InMageRcmPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "enableMultiVmSync":
			err = unpopulate(val, "EnableMultiVMSync", &i.EnableMultiVMSync)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &i.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmPolicyDetails.
func (i InMageRcmPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	populate(objectMap, "enableMultiVmSync", i.EnableMultiVMSync)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointHistoryInMinutes", i.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmPolicyDetails.
func (i *InMageRcmPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "enableMultiVmSync":
			err = unpopulate(val, "EnableMultiVMSync", &i.EnableMultiVMSync)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &i.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmProtectedDiskDetails.
func (i InMageRcmProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", i.CapacityInBytes)
	populate(objectMap, "dataPendingAtSourceAgentInMB", i.DataPendingAtSourceAgentInMB)
	populate(objectMap, "dataPendingInLogDataStoreInMB", i.DataPendingInLogDataStoreInMB)
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskId", i.DiskID)
	populate(objectMap, "diskName", i.DiskName)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "irDetails", i.IrDetails)
	populate(objectMap, "isInitialReplicationComplete", i.IsInitialReplicationComplete)
	populate(objectMap, "isOSDisk", i.IsOSDisk)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "resyncDetails", i.ResyncDetails)
	populate(objectMap, "seedBlobUri", i.SeedBlobURI)
	populate(objectMap, "seedManagedDiskId", i.SeedManagedDiskID)
	populate(objectMap, "targetManagedDiskId", i.TargetManagedDiskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmProtectedDiskDetails.
func (i *InMageRcmProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &i.CapacityInBytes)
			delete(rawMsg, key)
		case "dataPendingAtSourceAgentInMB":
			err = unpopulate(val, "DataPendingAtSourceAgentInMB", &i.DataPendingAtSourceAgentInMB)
			delete(rawMsg, key)
		case "dataPendingInLogDataStoreInMB":
			err = unpopulate(val, "DataPendingInLogDataStoreInMB", &i.DataPendingInLogDataStoreInMB)
			delete(rawMsg, key)
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "irDetails":
			err = unpopulate(val, "IrDetails", &i.IrDetails)
			delete(rawMsg, key)
		case "isInitialReplicationComplete":
			err = unpopulate(val, "IsInitialReplicationComplete", &i.IsInitialReplicationComplete)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &i.IsOSDisk)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "resyncDetails":
			err = unpopulate(val, "ResyncDetails", &i.ResyncDetails)
			delete(rawMsg, key)
		case "seedBlobUri":
			err = unpopulate(val, "SeedBlobURI", &i.SeedBlobURI)
			delete(rawMsg, key)
		case "seedManagedDiskId":
			err = unpopulate(val, "SeedManagedDiskID", &i.SeedManagedDiskID)
			delete(rawMsg, key)
		case "targetManagedDiskId":
			err = unpopulate(val, "TargetManagedDiskID", &i.TargetManagedDiskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmProtectionContainerMappingDetails.
func (i InMageRcmProtectionContainerMappingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableAgentAutoUpgrade", i.EnableAgentAutoUpgrade)
	objectMap["instanceType"] = "InMageRcm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmProtectionContainerMappingDetails.
func (i *InMageRcmProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAgentAutoUpgrade":
			err = unpopulate(val, "EnableAgentAutoUpgrade", &i.EnableAgentAutoUpgrade)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmRecoveryPointDetails.
func (i InMageRcmRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "isMultiVmSyncPoint", i.IsMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmRecoveryPointDetails.
func (i *InMageRcmRecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isMultiVmSyncPoint":
			err = unpopulate(val, "IsMultiVMSyncPoint", &i.IsMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmReplicationDetails.
func (i InMageRcmReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentUpgradeAttemptToVersion", i.AgentUpgradeAttemptToVersion)
	populate(objectMap, "agentUpgradeBlockingErrorDetails", i.AgentUpgradeBlockingErrorDetails)
	populate(objectMap, "agentUpgradeJobId", i.AgentUpgradeJobID)
	populate(objectMap, "agentUpgradeState", i.AgentUpgradeState)
	populate(objectMap, "allocatedMemoryInMB", i.AllocatedMemoryInMB)
	populate(objectMap, "discoveredVmDetails", i.DiscoveredVMDetails)
	populate(objectMap, "discoveryType", i.DiscoveryType)
	populate(objectMap, "fabricDiscoveryMachineId", i.FabricDiscoveryMachineID)
	populate(objectMap, "failoverRecoveryPointId", i.FailoverRecoveryPointID)
	populate(objectMap, "firmwareType", i.FirmwareType)
	populate(objectMap, "initialReplicationProcessedBytes", i.InitialReplicationProcessedBytes)
	populate(objectMap, "initialReplicationProgressHealth", i.InitialReplicationProgressHealth)
	populate(objectMap, "initialReplicationProgressPercentage", i.InitialReplicationProgressPercentage)
	populate(objectMap, "initialReplicationTransferredBytes", i.InitialReplicationTransferredBytes)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "internalIdentifier", i.InternalIdentifier)
	populate(objectMap, "isAgentRegistrationSuccessfulAfterFailover", i.IsAgentRegistrationSuccessfulAfterFailover)
	populate(objectMap, "isLastUpgradeSuccessful", i.IsLastUpgradeSuccessful)
	populate(objectMap, "lastAgentUpgradeErrorDetails", i.LastAgentUpgradeErrorDetails)
	populate(objectMap, "lastAgentUpgradeType", i.LastAgentUpgradeType)
	populate(objectMap, "lastRecoveryPointId", i.LastRecoveryPointID)
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", i.LastRecoveryPointReceived)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", i.LastRpoCalculatedTime)
	populate(objectMap, "lastRpoInSeconds", i.LastRpoInSeconds)
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "mobilityAgentDetails", i.MobilityAgentDetails)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "osType", i.OSType)
	populate(objectMap, "primaryNicIpAddress", i.PrimaryNicIPAddress)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "processServerName", i.ProcessServerName)
	populate(objectMap, "processorCoreCount", i.ProcessorCoreCount)
	populate(objectMap, "protectedDisks", i.ProtectedDisks)
	populate(objectMap, "resyncProcessedBytes", i.ResyncProcessedBytes)
	populate(objectMap, "resyncProgressHealth", i.ResyncProgressHealth)
	populate(objectMap, "resyncProgressPercentage", i.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", i.ResyncRequired)
	populate(objectMap, "resyncState", i.ResyncState)
	populate(objectMap, "resyncTransferredBytes", i.ResyncTransferredBytes)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", i.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetGeneration", i.TargetGeneration)
	populate(objectMap, "targetLocation", i.TargetLocation)
	populate(objectMap, "targetNetworkId", i.TargetNetworkID)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "testNetworkId", i.TestNetworkID)
	populate(objectMap, "vmNics", i.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmReplicationDetails.
func (i *InMageRcmReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentUpgradeAttemptToVersion":
			err = unpopulate(val, "AgentUpgradeAttemptToVersion", &i.AgentUpgradeAttemptToVersion)
			delete(rawMsg, key)
		case "agentUpgradeBlockingErrorDetails":
			err = unpopulate(val, "AgentUpgradeBlockingErrorDetails", &i.AgentUpgradeBlockingErrorDetails)
			delete(rawMsg, key)
		case "agentUpgradeJobId":
			err = unpopulate(val, "AgentUpgradeJobID", &i.AgentUpgradeJobID)
			delete(rawMsg, key)
		case "agentUpgradeState":
			err = unpopulate(val, "AgentUpgradeState", &i.AgentUpgradeState)
			delete(rawMsg, key)
		case "allocatedMemoryInMB":
			err = unpopulate(val, "AllocatedMemoryInMB", &i.AllocatedMemoryInMB)
			delete(rawMsg, key)
		case "discoveredVmDetails":
			err = unpopulate(val, "DiscoveredVMDetails", &i.DiscoveredVMDetails)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &i.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &i.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &i.FirmwareType)
			delete(rawMsg, key)
		case "initialReplicationProcessedBytes":
			err = unpopulate(val, "InitialReplicationProcessedBytes", &i.InitialReplicationProcessedBytes)
			delete(rawMsg, key)
		case "initialReplicationProgressHealth":
			err = unpopulate(val, "InitialReplicationProgressHealth", &i.InitialReplicationProgressHealth)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &i.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "initialReplicationTransferredBytes":
			err = unpopulate(val, "InitialReplicationTransferredBytes", &i.InitialReplicationTransferredBytes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &i.InternalIdentifier)
			delete(rawMsg, key)
		case "isAgentRegistrationSuccessfulAfterFailover":
			err = unpopulate(val, "IsAgentRegistrationSuccessfulAfterFailover", &i.IsAgentRegistrationSuccessfulAfterFailover)
			delete(rawMsg, key)
		case "isLastUpgradeSuccessful":
			err = unpopulate(val, "IsLastUpgradeSuccessful", &i.IsLastUpgradeSuccessful)
			delete(rawMsg, key)
		case "lastAgentUpgradeErrorDetails":
			err = unpopulate(val, "LastAgentUpgradeErrorDetails", &i.LastAgentUpgradeErrorDetails)
			delete(rawMsg, key)
		case "lastAgentUpgradeType":
			err = unpopulate(val, "LastAgentUpgradeType", &i.LastAgentUpgradeType)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &i.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &i.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastRpoInSeconds":
			err = unpopulate(val, "LastRpoInSeconds", &i.LastRpoInSeconds)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "mobilityAgentDetails":
			err = unpopulate(val, "MobilityAgentDetails", &i.MobilityAgentDetails)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "primaryNicIpAddress":
			err = unpopulate(val, "PrimaryNicIPAddress", &i.PrimaryNicIPAddress)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "processServerName":
			err = unpopulate(val, "ProcessServerName", &i.ProcessServerName)
			delete(rawMsg, key)
		case "processorCoreCount":
			err = unpopulate(val, "ProcessorCoreCount", &i.ProcessorCoreCount)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressHealth":
			err = unpopulate(val, "ResyncProgressHealth", &i.ResyncProgressHealth)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &i.ResyncState)
			delete(rawMsg, key)
		case "resyncTransferredBytes":
			err = unpopulate(val, "ResyncTransferredBytes", &i.ResyncTransferredBytes)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetGeneration":
			err = unpopulate(val, "TargetGeneration", &i.TargetGeneration)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &i.TargetLocation)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmReprotectInput.
func (i InMageRcmReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datastoreName", i.DatastoreName)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "reprotectAgentId", i.ReprotectAgentID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmReprotectInput.
func (i *InMageRcmReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "reprotectAgentId":
			err = unpopulate(val, "ReprotectAgentID", &i.ReprotectAgentID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmSyncDetails.
func (i InMageRcmSyncDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "last15MinutesTransferredBytes", i.Last15MinutesTransferredBytes)
	populate(objectMap, "lastDataTransferTimeUtc", i.LastDataTransferTimeUTC)
	populate(objectMap, "lastRefreshTime", i.LastRefreshTime)
	populate(objectMap, "processedBytes", i.ProcessedBytes)
	populate(objectMap, "progressHealth", i.ProgressHealth)
	populate(objectMap, "progressPercentage", i.ProgressPercentage)
	populate(objectMap, "startTime", i.StartTime)
	populate(objectMap, "transferredBytes", i.TransferredBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmSyncDetails.
func (i *InMageRcmSyncDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "last15MinutesTransferredBytes":
			err = unpopulate(val, "Last15MinutesTransferredBytes", &i.Last15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "lastDataTransferTimeUtc":
			err = unpopulate(val, "LastDataTransferTimeUTC", &i.LastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "lastRefreshTime":
			err = unpopulate(val, "LastRefreshTime", &i.LastRefreshTime)
			delete(rawMsg, key)
		case "processedBytes":
			err = unpopulate(val, "ProcessedBytes", &i.ProcessedBytes)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressPercentage":
			err = unpopulate(val, "ProgressPercentage", &i.ProgressPercentage)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &i.StartTime)
			delete(rawMsg, key)
		case "transferredBytes":
			err = unpopulate(val, "TransferredBytes", &i.TransferredBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmTestFailoverInput.
func (i InMageRcmTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "networkId", i.NetworkID)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmTestFailoverInput.
func (i *InMageRcmTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &i.NetworkID)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUnplannedFailoverInput.
func (i InMageRcmUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "performShutdown", i.PerformShutdown)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUnplannedFailoverInput.
func (i *InMageRcmUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "performShutdown":
			err = unpopulate(val, "PerformShutdown", &i.PerformShutdown)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i InMageRcmUpdateApplianceForReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i *InMageRcmUpdateApplianceForReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateContainerMappingInput.
func (i InMageRcmUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableAgentAutoUpgrade", i.EnableAgentAutoUpgrade)
	objectMap["instanceType"] = "InMageRcm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateContainerMappingInput.
func (i *InMageRcmUpdateContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAgentAutoUpgrade":
			err = unpopulate(val, "EnableAgentAutoUpgrade", &i.EnableAgentAutoUpgrade)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i InMageRcmUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", i.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetNetworkId", i.TargetNetworkID)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "testNetworkId", i.TestNetworkID)
	populate(objectMap, "vmNics", i.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i *InMageRcmUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageReplicationDetails.
func (i InMageReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeSiteType", i.ActiveSiteType)
	populate(objectMap, "agentDetails", i.AgentDetails)
	populate(objectMap, "azureStorageAccountId", i.AzureStorageAccountID)
	populate(objectMap, "compressedDataRateInMB", i.CompressedDataRateInMB)
	populate(objectMap, "consistencyPoints", i.ConsistencyPoints)
	populate(objectMap, "datastores", i.Datastores)
	populate(objectMap, "discoveryType", i.DiscoveryType)
	populate(objectMap, "diskResized", i.DiskResized)
	populate(objectMap, "ipAddress", i.IPAddress)
	populate(objectMap, "infrastructureVmId", i.InfrastructureVMID)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "isAdditionalStatsAvailable", i.IsAdditionalStatsAvailable)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", i.LastHeartbeat)
	populateDateTimeRFC3339(objectMap, "lastRpoCalculatedTime", i.LastRpoCalculatedTime)
	populateDateTimeRFC3339(objectMap, "lastUpdateReceivedTime", i.LastUpdateReceivedTime)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "osDetails", i.OSDetails)
	populate(objectMap, "osVersion", i.OSVersion)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "protectedDisks", i.ProtectedDisks)
	populate(objectMap, "protectionStage", i.ProtectionStage)
	populate(objectMap, "rebootAfterUpdateStatus", i.RebootAfterUpdateStatus)
	populate(objectMap, "replicaId", i.ReplicaID)
	populate(objectMap, "resyncDetails", i.ResyncDetails)
	populateDateTimeRFC3339(objectMap, "retentionWindowEnd", i.RetentionWindowEnd)
	populateDateTimeRFC3339(objectMap, "retentionWindowStart", i.RetentionWindowStart)
	populate(objectMap, "rpoInSeconds", i.RpoInSeconds)
	populate(objectMap, "sourceVmCpuCount", i.SourceVMCPUCount)
	populate(objectMap, "sourceVmRamSizeInMB", i.SourceVMRAMSizeInMB)
	populate(objectMap, "totalDataTransferred", i.TotalDataTransferred)
	populate(objectMap, "totalProgressHealth", i.TotalProgressHealth)
	populate(objectMap, "uncompressedDataRateInMB", i.UncompressedDataRateInMB)
	populate(objectMap, "vCenterInfrastructureId", i.VCenterInfrastructureID)
	populate(objectMap, "vmId", i.VMID)
	populate(objectMap, "vmNics", i.VMNics)
	populate(objectMap, "vmProtectionState", i.VMProtectionState)
	populate(objectMap, "vmProtectionStateDescription", i.VMProtectionStateDescription)
	populate(objectMap, "validationErrors", i.ValidationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageReplicationDetails.
func (i *InMageReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeSiteType":
			err = unpopulate(val, "ActiveSiteType", &i.ActiveSiteType)
			delete(rawMsg, key)
		case "agentDetails":
			err = unpopulate(val, "AgentDetails", &i.AgentDetails)
			delete(rawMsg, key)
		case "azureStorageAccountId":
			err = unpopulate(val, "AzureStorageAccountID", &i.AzureStorageAccountID)
			delete(rawMsg, key)
		case "compressedDataRateInMB":
			err = unpopulate(val, "CompressedDataRateInMB", &i.CompressedDataRateInMB)
			delete(rawMsg, key)
		case "consistencyPoints":
			err = unpopulate(val, "ConsistencyPoints", &i.ConsistencyPoints)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "infrastructureVmId":
			err = unpopulate(val, "InfrastructureVMID", &i.InfrastructureVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isAdditionalStatsAvailable":
			err = unpopulate(val, "IsAdditionalStatsAvailable", &i.IsAdditionalStatsAvailable)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &i.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastUpdateReceivedTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateReceivedTime", &i.LastUpdateReceivedTime)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &i.OSDetails)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &i.OSVersion)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "rebootAfterUpdateStatus":
			err = unpopulate(val, "RebootAfterUpdateStatus", &i.RebootAfterUpdateStatus)
			delete(rawMsg, key)
		case "replicaId":
			err = unpopulate(val, "ReplicaID", &i.ReplicaID)
			delete(rawMsg, key)
		case "resyncDetails":
			err = unpopulate(val, "ResyncDetails", &i.ResyncDetails)
			delete(rawMsg, key)
		case "retentionWindowEnd":
			err = unpopulateDateTimeRFC3339(val, "RetentionWindowEnd", &i.RetentionWindowEnd)
			delete(rawMsg, key)
		case "retentionWindowStart":
			err = unpopulateDateTimeRFC3339(val, "RetentionWindowStart", &i.RetentionWindowStart)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &i.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &i.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "totalDataTransferred":
			err = unpopulate(val, "TotalDataTransferred", &i.TotalDataTransferred)
			delete(rawMsg, key)
		case "totalProgressHealth":
			err = unpopulate(val, "TotalProgressHealth", &i.TotalProgressHealth)
			delete(rawMsg, key)
		case "uncompressedDataRateInMB":
			err = unpopulate(val, "UncompressedDataRateInMB", &i.UncompressedDataRateInMB)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &i.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &i.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &i.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &i.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &i.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageReprotectInput.
func (i InMageReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datastoreName", i.DatastoreName)
	populate(objectMap, "diskExclusionInput", i.DiskExclusionInput)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "profileId", i.ProfileID)
	populate(objectMap, "retentionDrive", i.RetentionDrive)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageReprotectInput.
func (i *InMageReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "diskExclusionInput":
			err = unpopulate(val, "DiskExclusionInput", &i.DiskExclusionInput)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "profileId":
			err = unpopulate(val, "ProfileID", &i.ProfileID)
			delete(rawMsg, key)
		case "retentionDrive":
			err = unpopulate(val, "RetentionDrive", &i.RetentionDrive)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageTestFailoverInput.
func (i InMageTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageTestFailoverInput.
func (i *InMageTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageUnplannedFailoverInput.
func (i InMageUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageUnplannedFailoverInput.
func (i *InMageUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageVolumeExclusionOptions.
func (i InMageVolumeExclusionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "onlyExcludeIfSingleVolume", i.OnlyExcludeIfSingleVolume)
	populate(objectMap, "volumeLabel", i.VolumeLabel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageVolumeExclusionOptions.
func (i *InMageVolumeExclusionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "onlyExcludeIfSingleVolume":
			err = unpopulate(val, "OnlyExcludeIfSingleVolume", &i.OnlyExcludeIfSingleVolume)
			delete(rawMsg, key)
		case "volumeLabel":
			err = unpopulate(val, "VolumeLabel", &i.VolumeLabel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InconsistentVMDetails.
func (i InconsistentVMDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudName", i.CloudName)
	populate(objectMap, "details", i.Details)
	populate(objectMap, "errorIds", i.ErrorIDs)
	populate(objectMap, "vmName", i.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InconsistentVMDetails.
func (i *InconsistentVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudName":
			err = unpopulate(val, "CloudName", &i.CloudName)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &i.Details)
			delete(rawMsg, key)
		case "errorIds":
			err = unpopulate(val, "ErrorIDs", &i.ErrorIDs)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &i.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InitialReplicationDetails.
func (i InitialReplicationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initialReplicationProgressPercentage", i.InitialReplicationProgressPercentage)
	populate(objectMap, "initialReplicationType", i.InitialReplicationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InitialReplicationDetails.
func (i *InitialReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &i.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "initialReplicationType":
			err = unpopulate(val, "InitialReplicationType", &i.InitialReplicationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InlineWorkflowTaskDetails.
func (i InlineWorkflowTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "childTasks", i.ChildTasks)
	objectMap["instanceType"] = "InlineWorkflowTaskDetails"
	populate(objectMap, "workflowIds", i.WorkflowIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InlineWorkflowTaskDetails.
func (i *InlineWorkflowTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &i.ChildTasks)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "workflowIds":
			err = unpopulate(val, "WorkflowIDs", &i.WorkflowIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerHealthError.
func (i InnerHealthError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTimeUtc", i.CreationTimeUTC)
	populate(objectMap, "customerResolvability", i.CustomerResolvability)
	populate(objectMap, "entityId", i.EntityID)
	populate(objectMap, "errorCategory", i.ErrorCategory)
	populate(objectMap, "errorCode", i.ErrorCode)
	populate(objectMap, "errorId", i.ErrorID)
	populate(objectMap, "errorLevel", i.ErrorLevel)
	populate(objectMap, "errorMessage", i.ErrorMessage)
	populate(objectMap, "errorSource", i.ErrorSource)
	populate(objectMap, "errorType", i.ErrorType)
	populate(objectMap, "possibleCauses", i.PossibleCauses)
	populate(objectMap, "recommendedAction", i.RecommendedAction)
	populate(objectMap, "recoveryProviderErrorMessage", i.RecoveryProviderErrorMessage)
	populate(objectMap, "summaryMessage", i.SummaryMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerHealthError.
func (i *InnerHealthError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreationTimeUTC", &i.CreationTimeUTC)
			delete(rawMsg, key)
		case "customerResolvability":
			err = unpopulate(val, "CustomerResolvability", &i.CustomerResolvability)
			delete(rawMsg, key)
		case "entityId":
			err = unpopulate(val, "EntityID", &i.EntityID)
			delete(rawMsg, key)
		case "errorCategory":
			err = unpopulate(val, "ErrorCategory", &i.ErrorCategory)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorId":
			err = unpopulate(val, "ErrorID", &i.ErrorID)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &i.ErrorLevel)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorSource":
			err = unpopulate(val, "ErrorSource", &i.ErrorSource)
			delete(rawMsg, key)
		case "errorType":
			err = unpopulate(val, "ErrorType", &i.ErrorType)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		case "recoveryProviderErrorMessage":
			err = unpopulate(val, "RecoveryProviderErrorMessage", &i.RecoveryProviderErrorMessage)
			delete(rawMsg, key)
		case "summaryMessage":
			err = unpopulate(val, "SummaryMessage", &i.SummaryMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InputEndpoint.
func (i InputEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointName", i.EndpointName)
	populate(objectMap, "privatePort", i.PrivatePort)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "publicPort", i.PublicPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InputEndpoint.
func (i *InputEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointName":
			err = unpopulate(val, "EndpointName", &i.EndpointName)
			delete(rawMsg, key)
		case "privatePort":
			err = unpopulate(val, "PrivatePort", &i.PrivatePort)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "publicPort":
			err = unpopulate(val, "PublicPort", &i.PublicPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &j.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobCollection.
func (j JobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobCollection.
func (j *JobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDetails.
func (j JobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", j.AffectedObjectDetails)
	objectMap["instanceType"] = j.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDetails.
func (j *JobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &j.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobEntity.
func (j JobEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobFriendlyName", j.JobFriendlyName)
	populate(objectMap, "jobId", j.JobID)
	populate(objectMap, "jobScenarioName", j.JobScenarioName)
	populate(objectMap, "targetInstanceType", j.TargetInstanceType)
	populate(objectMap, "targetObjectId", j.TargetObjectID)
	populate(objectMap, "targetObjectName", j.TargetObjectName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobEntity.
func (j *JobEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobFriendlyName":
			err = unpopulate(val, "JobFriendlyName", &j.JobFriendlyName)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "jobScenarioName":
			err = unpopulate(val, "JobScenarioName", &j.JobScenarioName)
			delete(rawMsg, key)
		case "targetInstanceType":
			err = unpopulate(val, "TargetInstanceType", &j.TargetInstanceType)
			delete(rawMsg, key)
		case "targetObjectId":
			err = unpopulate(val, "TargetObjectID", &j.TargetObjectID)
			delete(rawMsg, key)
		case "targetObjectName":
			err = unpopulate(val, "TargetObjectName", &j.TargetObjectName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorDetails.
func (j JobErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", j.CreationTime)
	populate(objectMap, "errorLevel", j.ErrorLevel)
	populate(objectMap, "providerErrorDetails", j.ProviderErrorDetails)
	populate(objectMap, "serviceErrorDetails", j.ServiceErrorDetails)
	populate(objectMap, "taskId", j.TaskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorDetails.
func (j *JobErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &j.CreationTime)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &j.ErrorLevel)
			delete(rawMsg, key)
		case "providerErrorDetails":
			err = unpopulate(val, "ProviderErrorDetails", &j.ProviderErrorDetails)
			delete(rawMsg, key)
		case "serviceErrorDetails":
			err = unpopulate(val, "ServiceErrorDetails", &j.ServiceErrorDetails)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &j.TaskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", j.ActivityID)
	populate(objectMap, "allowedActions", j.AllowedActions)
	populate(objectMap, "customDetails", j.CustomDetails)
	populateDateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "errors", j.Errors)
	populate(objectMap, "friendlyName", j.FriendlyName)
	populate(objectMap, "scenarioName", j.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "state", j.State)
	populate(objectMap, "stateDescription", j.StateDescription)
	populate(objectMap, "targetInstanceType", j.TargetInstanceType)
	populate(objectMap, "targetObjectId", j.TargetObjectID)
	populate(objectMap, "targetObjectName", j.TargetObjectName)
	populate(objectMap, "tasks", j.Tasks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &j.ActivityID)
			delete(rawMsg, key)
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &j.AllowedActions)
			delete(rawMsg, key)
		case "customDetails":
			j.CustomDetails, err = unmarshalJobDetailsClassification(val)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &j.Errors)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &j.FriendlyName)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &j.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		case "stateDescription":
			err = unpopulate(val, "StateDescription", &j.StateDescription)
			delete(rawMsg, key)
		case "targetInstanceType":
			err = unpopulate(val, "TargetInstanceType", &j.TargetInstanceType)
			delete(rawMsg, key)
		case "targetObjectId":
			err = unpopulate(val, "TargetObjectID", &j.TargetObjectID)
			delete(rawMsg, key)
		case "targetObjectName":
			err = unpopulate(val, "TargetObjectName", &j.TargetObjectName)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &j.Tasks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobQueryParameter.
func (j JobQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectTypes", j.AffectedObjectTypes)
	populate(objectMap, "endTime", j.EndTime)
	populate(objectMap, "fabricId", j.FabricID)
	populate(objectMap, "jobName", j.JobName)
	populate(objectMap, "jobOutputType", j.JobOutputType)
	populate(objectMap, "jobStatus", j.JobStatus)
	populate(objectMap, "startTime", j.StartTime)
	populate(objectMap, "timezoneOffset", j.TimezoneOffset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobQueryParameter.
func (j *JobQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectTypes":
			err = unpopulate(val, "AffectedObjectTypes", &j.AffectedObjectTypes)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulate(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "fabricId":
			err = unpopulate(val, "FabricID", &j.FabricID)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &j.JobName)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &j.JobOutputType)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &j.JobStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "timezoneOffset":
			err = unpopulate(val, "TimezoneOffset", &j.TimezoneOffset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStatusEventDetails.
func (j JobStatusEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectType", j.AffectedObjectType)
	objectMap["instanceType"] = "JobStatus"
	populate(objectMap, "jobFriendlyName", j.JobFriendlyName)
	populate(objectMap, "jobId", j.JobID)
	populate(objectMap, "jobStatus", j.JobStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStatusEventDetails.
func (j *JobStatusEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectType":
			err = unpopulate(val, "AffectedObjectType", &j.AffectedObjectType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		case "jobFriendlyName":
			err = unpopulate(val, "JobFriendlyName", &j.JobFriendlyName)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &j.JobStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobTaskDetails.
func (j JobTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "JobTaskDetails"
	populate(objectMap, "jobTask", j.JobTask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobTaskDetails.
func (j *JobTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &j.JobTask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyEncryptionKeyInfo.
func (k KeyEncryptionKeyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyIdentifier", k.KeyIdentifier)
	populate(objectMap, "keyVaultResourceArmId", k.KeyVaultResourceArmID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyEncryptionKeyInfo.
func (k *KeyEncryptionKeyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &k.KeyIdentifier)
			delete(rawMsg, key)
		case "keyVaultResourceArmId":
			err = unpopulate(val, "KeyVaultResourceArmID", &k.KeyVaultResourceArmID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogicalNetwork.
func (l LogicalNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogicalNetwork.
func (l *LogicalNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogicalNetworkCollection.
func (l LogicalNetworkCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogicalNetworkCollection.
func (l *LogicalNetworkCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogicalNetworkProperties.
func (l LogicalNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", l.FriendlyName)
	populate(objectMap, "logicalNetworkDefinitionsStatus", l.LogicalNetworkDefinitionsStatus)
	populate(objectMap, "logicalNetworkUsage", l.LogicalNetworkUsage)
	populate(objectMap, "networkVirtualizationStatus", l.NetworkVirtualizationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogicalNetworkProperties.
func (l *LogicalNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &l.FriendlyName)
			delete(rawMsg, key)
		case "logicalNetworkDefinitionsStatus":
			err = unpopulate(val, "LogicalNetworkDefinitionsStatus", &l.LogicalNetworkDefinitionsStatus)
			delete(rawMsg, key)
		case "logicalNetworkUsage":
			err = unpopulate(val, "LogicalNetworkUsage", &l.LogicalNetworkUsage)
			delete(rawMsg, key)
		case "networkVirtualizationStatus":
			err = unpopulate(val, "NetworkVirtualizationStatus", &l.NetworkVirtualizationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManualActionTaskDetails.
func (m ManualActionTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "ManualActionTaskDetails"
	populate(objectMap, "instructions", m.Instructions)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "observation", m.Observation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManualActionTaskDetails.
func (m *ManualActionTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &m.Instructions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "observation":
			err = unpopulate(val, "Observation", &m.Observation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MarsAgentDetails.
func (m MarsAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", m.BiosID)
	populate(objectMap, "fabricObjectId", m.FabricObjectID)
	populate(objectMap, "fqdn", m.Fqdn)
	populate(objectMap, "health", m.Health)
	populate(objectMap, "healthErrors", m.HealthErrors)
	populate(objectMap, "id", m.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", m.LastHeartbeatUTC)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarsAgentDetails.
func (m *MarsAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &m.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &m.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &m.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &m.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &m.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MasterTargetServer.
func (m MasterTargetServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", m.AgentExpiryDate)
	populate(objectMap, "agentVersion", m.AgentVersion)
	populate(objectMap, "agentVersionDetails", m.AgentVersionDetails)
	populate(objectMap, "dataStores", m.DataStores)
	populate(objectMap, "diskCount", m.DiskCount)
	populate(objectMap, "healthErrors", m.HealthErrors)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "ipAddress", m.IPAddress)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", m.LastHeartbeat)
	populateDateTimeRFC3339(objectMap, "marsAgentExpiryDate", m.MarsAgentExpiryDate)
	populate(objectMap, "marsAgentVersion", m.MarsAgentVersion)
	populate(objectMap, "marsAgentVersionDetails", m.MarsAgentVersionDetails)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "osVersion", m.OSVersion)
	populate(objectMap, "retentionVolumes", m.RetentionVolumes)
	populate(objectMap, "validationErrors", m.ValidationErrors)
	populate(objectMap, "versionStatus", m.VersionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MasterTargetServer.
func (m *MasterTargetServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &m.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &m.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &m.AgentVersionDetails)
			delete(rawMsg, key)
		case "dataStores":
			err = unpopulate(val, "DataStores", &m.DataStores)
			delete(rawMsg, key)
		case "diskCount":
			err = unpopulate(val, "DiskCount", &m.DiskCount)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &m.IPAddress)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &m.LastHeartbeat)
			delete(rawMsg, key)
		case "marsAgentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "MarsAgentExpiryDate", &m.MarsAgentExpiryDate)
			delete(rawMsg, key)
		case "marsAgentVersion":
			err = unpopulate(val, "MarsAgentVersion", &m.MarsAgentVersion)
			delete(rawMsg, key)
		case "marsAgentVersionDetails":
			err = unpopulate(val, "MarsAgentVersionDetails", &m.MarsAgentVersionDetails)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &m.OSVersion)
			delete(rawMsg, key)
		case "retentionVolumes":
			err = unpopulate(val, "RetentionVolumes", &m.RetentionVolumes)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &m.ValidationErrors)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &m.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateInput.
func (m MigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateInput.
func (m *MigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateInputProperties.
func (m MigrateInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", m.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateInputProperties.
func (m *MigrateInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			m.ProviderSpecificDetails, err = unmarshalMigrateProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateProviderSpecificInput.
func (m MigrateProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = m.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateProviderSpecificInput.
func (m *MigrateProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationItem.
func (m MigrationItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationItem.
func (m *MigrationItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationItemCollection.
func (m MigrationItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationItemCollection.
func (m *MigrationItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationItemProperties.
func (m MigrationItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedOperations", m.AllowedOperations)
	populate(objectMap, "criticalJobHistory", m.CriticalJobHistory)
	populate(objectMap, "currentJob", m.CurrentJob)
	populate(objectMap, "eventCorrelationId", m.EventCorrelationID)
	populate(objectMap, "health", m.Health)
	populate(objectMap, "healthErrors", m.HealthErrors)
	populate(objectMap, "lastMigrationStatus", m.LastMigrationStatus)
	populateDateTimeRFC3339(objectMap, "lastMigrationTime", m.LastMigrationTime)
	populate(objectMap, "lastTestMigrationStatus", m.LastTestMigrationStatus)
	populateDateTimeRFC3339(objectMap, "lastTestMigrationTime", m.LastTestMigrationTime)
	populate(objectMap, "machineName", m.MachineName)
	populate(objectMap, "migrationState", m.MigrationState)
	populate(objectMap, "migrationStateDescription", m.MigrationStateDescription)
	populate(objectMap, "policyFriendlyName", m.PolicyFriendlyName)
	populate(objectMap, "policyId", m.PolicyID)
	populate(objectMap, "providerSpecificDetails", m.ProviderSpecificDetails)
	populate(objectMap, "recoveryServicesProviderId", m.RecoveryServicesProviderID)
	populate(objectMap, "replicationStatus", m.ReplicationStatus)
	populate(objectMap, "testMigrateState", m.TestMigrateState)
	populate(objectMap, "testMigrateStateDescription", m.TestMigrateStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationItemProperties.
func (m *MigrationItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &m.AllowedOperations)
			delete(rawMsg, key)
		case "criticalJobHistory":
			err = unpopulate(val, "CriticalJobHistory", &m.CriticalJobHistory)
			delete(rawMsg, key)
		case "currentJob":
			err = unpopulate(val, "CurrentJob", &m.CurrentJob)
			delete(rawMsg, key)
		case "eventCorrelationId":
			err = unpopulate(val, "EventCorrelationID", &m.EventCorrelationID)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &m.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "lastMigrationStatus":
			err = unpopulate(val, "LastMigrationStatus", &m.LastMigrationStatus)
			delete(rawMsg, key)
		case "lastMigrationTime":
			err = unpopulateDateTimeRFC3339(val, "LastMigrationTime", &m.LastMigrationTime)
			delete(rawMsg, key)
		case "lastTestMigrationStatus":
			err = unpopulate(val, "LastTestMigrationStatus", &m.LastTestMigrationStatus)
			delete(rawMsg, key)
		case "lastTestMigrationTime":
			err = unpopulateDateTimeRFC3339(val, "LastTestMigrationTime", &m.LastTestMigrationTime)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &m.MachineName)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "migrationStateDescription":
			err = unpopulate(val, "MigrationStateDescription", &m.MigrationStateDescription)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &m.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &m.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			m.ProviderSpecificDetails, err = unmarshalMigrationProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "recoveryServicesProviderId":
			err = unpopulate(val, "RecoveryServicesProviderID", &m.RecoveryServicesProviderID)
			delete(rawMsg, key)
		case "replicationStatus":
			err = unpopulate(val, "ReplicationStatus", &m.ReplicationStatus)
			delete(rawMsg, key)
		case "testMigrateState":
			err = unpopulate(val, "TestMigrateState", &m.TestMigrateState)
			delete(rawMsg, key)
		case "testMigrateStateDescription":
			err = unpopulate(val, "TestMigrateStateDescription", &m.TestMigrateStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationItemsQueryParameter.
func (m MigrationItemsQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", m.InstanceType)
	populate(objectMap, "sourceContainerName", m.SourceContainerName)
	populate(objectMap, "sourceFabricName", m.SourceFabricName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationItemsQueryParameter.
func (m *MigrationItemsQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		case "sourceContainerName":
			err = unpopulate(val, "SourceContainerName", &m.SourceContainerName)
			delete(rawMsg, key)
		case "sourceFabricName":
			err = unpopulate(val, "SourceFabricName", &m.SourceFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationProviderSpecificSettings.
func (m MigrationProviderSpecificSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = m.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationProviderSpecificSettings.
func (m *MigrationProviderSpecificSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationRecoveryPoint.
func (m MigrationRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationRecoveryPoint.
func (m *MigrationRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationRecoveryPointCollection.
func (m MigrationRecoveryPointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationRecoveryPointCollection.
func (m *MigrationRecoveryPointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationRecoveryPointProperties.
func (m MigrationRecoveryPointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", m.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", m.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationRecoveryPointProperties.
func (m *MigrationRecoveryPointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &m.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &m.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MobilityServiceUpdate.
func (m MobilityServiceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "rebootStatus", m.RebootStatus)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MobilityServiceUpdate.
func (m *MobilityServiceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "rebootStatus":
			err = unpopulate(val, "RebootStatus", &m.RebootStatus)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Network.
func (n Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Network.
func (n *Network) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkCollection.
func (n NetworkCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkCollection.
func (n *NetworkCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkMapping.
func (n NetworkMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkMapping.
func (n *NetworkMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkMappingCollection.
func (n NetworkMappingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkMappingCollection.
func (n *NetworkMappingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkMappingFabricSpecificSettings.
func (n NetworkMappingFabricSpecificSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = n.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkMappingFabricSpecificSettings.
func (n *NetworkMappingFabricSpecificSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &n.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkMappingProperties.
func (n NetworkMappingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricSpecificSettings", n.FabricSpecificSettings)
	populate(objectMap, "primaryFabricFriendlyName", n.PrimaryFabricFriendlyName)
	populate(objectMap, "primaryNetworkFriendlyName", n.PrimaryNetworkFriendlyName)
	populate(objectMap, "primaryNetworkId", n.PrimaryNetworkID)
	populate(objectMap, "recoveryFabricArmId", n.RecoveryFabricArmID)
	populate(objectMap, "recoveryFabricFriendlyName", n.RecoveryFabricFriendlyName)
	populate(objectMap, "recoveryNetworkFriendlyName", n.RecoveryNetworkFriendlyName)
	populate(objectMap, "recoveryNetworkId", n.RecoveryNetworkID)
	populate(objectMap, "state", n.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkMappingProperties.
func (n *NetworkMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificSettings":
			n.FabricSpecificSettings, err = unmarshalNetworkMappingFabricSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &n.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryNetworkFriendlyName":
			err = unpopulate(val, "PrimaryNetworkFriendlyName", &n.PrimaryNetworkFriendlyName)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &n.PrimaryNetworkID)
			delete(rawMsg, key)
		case "recoveryFabricArmId":
			err = unpopulate(val, "RecoveryFabricArmID", &n.RecoveryFabricArmID)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &n.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryNetworkFriendlyName":
			err = unpopulate(val, "RecoveryNetworkFriendlyName", &n.RecoveryNetworkFriendlyName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &n.RecoveryNetworkID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &n.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProperties.
func (n NetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricType", n.FabricType)
	populate(objectMap, "friendlyName", n.FriendlyName)
	populate(objectMap, "networkType", n.NetworkType)
	populate(objectMap, "subnets", n.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProperties.
func (n *NetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricType":
			err = unpopulate(val, "FabricType", &n.FabricType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &n.FriendlyName)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &n.NetworkType)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &n.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewProtectionProfile.
func (n NewProtectionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", n.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", n.CrashConsistentFrequencyInMinutes)
	populate(objectMap, "multiVmSyncStatus", n.MultiVMSyncStatus)
	populate(objectMap, "policyName", n.PolicyName)
	populate(objectMap, "recoveryPointHistory", n.RecoveryPointHistory)
	objectMap["resourceType"] = "New"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewProtectionProfile.
func (n *NewProtectionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &n.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &n.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &n.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &n.PolicyName)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &n.RecoveryPointHistory)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewRecoveryVirtualNetwork.
func (n NewRecoveryVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recoveryVirtualNetworkName", n.RecoveryVirtualNetworkName)
	populate(objectMap, "recoveryVirtualNetworkResourceGroupName", n.RecoveryVirtualNetworkResourceGroupName)
	objectMap["resourceType"] = "New"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewRecoveryVirtualNetwork.
func (n *NewRecoveryVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryVirtualNetworkName":
			err = unpopulate(val, "RecoveryVirtualNetworkName", &n.RecoveryVirtualNetworkName)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkResourceGroupName":
			err = unpopulate(val, "RecoveryVirtualNetworkResourceGroupName", &n.RecoveryVirtualNetworkResourceGroupName)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDetails.
func (o OSDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osEdition", o.OSEdition)
	populate(objectMap, "oSMajorVersion", o.OSMajorVersion)
	populate(objectMap, "oSMinorVersion", o.OSMinorVersion)
	populate(objectMap, "osType", o.OSType)
	populate(objectMap, "oSVersion", o.OSVersion)
	populate(objectMap, "productType", o.ProductType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDetails.
func (o *OSDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osEdition":
			err = unpopulate(val, "OSEdition", &o.OSEdition)
			delete(rawMsg, key)
		case "oSMajorVersion":
			err = unpopulate(val, "OSMajorVersion", &o.OSMajorVersion)
			delete(rawMsg, key)
		case "oSMinorVersion":
			err = unpopulate(val, "OSMinorVersion", &o.OSMinorVersion)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		case "oSVersion":
			err = unpopulate(val, "OSVersion", &o.OSVersion)
			delete(rawMsg, key)
		case "productType":
			err = unpopulate(val, "ProductType", &o.ProductType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSDiskDetails.
func (o OSDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osType", o.OSType)
	populate(objectMap, "osVhdId", o.OSVhdID)
	populate(objectMap, "vhdName", o.VhdName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSDiskDetails.
func (o *OSDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		case "osVhdId":
			err = unpopulate(val, "OSVhdID", &o.OSVhdID)
			delete(rawMsg, key)
		case "vhdName":
			err = unpopulate(val, "VhdName", &o.VhdName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpgradeSupportedVersions.
func (o OSUpgradeSupportedVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedSourceOsVersion", o.SupportedSourceOsVersion)
	populate(objectMap, "supportedTargetOsVersions", o.SupportedTargetOsVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpgradeSupportedVersions.
func (o *OSUpgradeSupportedVersions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedSourceOsVersion":
			err = unpopulate(val, "SupportedSourceOsVersion", &o.SupportedSourceOsVersion)
			delete(rawMsg, key)
		case "supportedTargetOsVersions":
			err = unpopulate(val, "SupportedTargetOsVersions", &o.SupportedTargetOsVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSVersionWrapper.
func (o OSVersionWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "servicePack", o.ServicePack)
	populate(objectMap, "version", o.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSVersionWrapper.
func (o *OSVersionWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "servicePack":
			err = unpopulate(val, "ServicePack", &o.ServicePack)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &o.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDiscovery.
func (o OperationsDiscovery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDiscovery.
func (o *OperationsDiscovery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDiscoveryCollection.
func (o OperationsDiscoveryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDiscoveryCollection.
func (o *OperationsDiscoveryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PauseReplicationInput.
func (p PauseReplicationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PauseReplicationInput.
func (p *PauseReplicationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PauseReplicationInputProperties.
func (p PauseReplicationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", p.InstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PauseReplicationInputProperties.
func (p *PauseReplicationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverInput.
func (p PlannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverInput.
func (p *PlannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverInputProperties.
func (p PlannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", p.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", p.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverInputProperties.
func (p *PlannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &p.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalPlannedFailoverProviderSpecificFailoverInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverProviderSpecificFailoverInput.
func (p PlannedFailoverProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverProviderSpecificFailoverInput.
func (p *PlannedFailoverProviderSpecificFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Policy.
func (p *Policy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyCollection.
func (p PolicyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyCollection.
func (p *PolicyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProperties.
func (p PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "providerSpecificDetails", p.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalPolicyProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProviderSpecificDetails.
func (p PolicyProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProviderSpecificDetails.
func (p *PolicyProviderSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProviderSpecificInput.
func (p PolicyProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProviderSpecificInput.
func (p *PolicyProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessServer.
func (p ProcessServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", p.AgentExpiryDate)
	populate(objectMap, "agentVersion", p.AgentVersion)
	populate(objectMap, "agentVersionDetails", p.AgentVersionDetails)
	populate(objectMap, "availableMemoryInBytes", p.AvailableMemoryInBytes)
	populate(objectMap, "availableSpaceInBytes", p.AvailableSpaceInBytes)
	populate(objectMap, "cpuLoad", p.CPULoad)
	populate(objectMap, "cpuLoadStatus", p.CPULoadStatus)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "health", p.Health)
	populate(objectMap, "healthErrors", p.HealthErrors)
	populate(objectMap, "hostId", p.HostID)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "ipAddress", p.IPAddress)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", p.LastHeartbeat)
	populate(objectMap, "machineCount", p.MachineCount)
	populate(objectMap, "marsCommunicationStatus", p.MarsCommunicationStatus)
	populate(objectMap, "marsRegistrationStatus", p.MarsRegistrationStatus)
	populate(objectMap, "memoryUsageStatus", p.MemoryUsageStatus)
	populate(objectMap, "mobilityServiceUpdates", p.MobilityServiceUpdates)
	populate(objectMap, "osType", p.OSType)
	populate(objectMap, "osVersion", p.OSVersion)
	populate(objectMap, "psServiceStatus", p.PsServiceStatus)
	populateDateTimeRFC3339(objectMap, "psStatsRefreshTime", p.PsStatsRefreshTime)
	populate(objectMap, "replicationPairCount", p.ReplicationPairCount)
	populateDateTimeRFC3339(objectMap, "sslCertExpiryDate", p.SSLCertExpiryDate)
	populate(objectMap, "sslCertExpiryRemainingDays", p.SSLCertExpiryRemainingDays)
	populate(objectMap, "spaceUsageStatus", p.SpaceUsageStatus)
	populate(objectMap, "systemLoad", p.SystemLoad)
	populate(objectMap, "systemLoadStatus", p.SystemLoadStatus)
	populate(objectMap, "throughputInBytes", p.ThroughputInBytes)
	populate(objectMap, "throughputInMBps", p.ThroughputInMBps)
	populate(objectMap, "throughputStatus", p.ThroughputStatus)
	populate(objectMap, "throughputUploadPendingDataInBytes", p.ThroughputUploadPendingDataInBytes)
	populate(objectMap, "totalMemoryInBytes", p.TotalMemoryInBytes)
	populate(objectMap, "totalSpaceInBytes", p.TotalSpaceInBytes)
	populate(objectMap, "versionStatus", p.VersionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessServer.
func (p *ProcessServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &p.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &p.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &p.AgentVersionDetails)
			delete(rawMsg, key)
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &p.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &p.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "cpuLoad":
			err = unpopulate(val, "CPULoad", &p.CPULoad)
			delete(rawMsg, key)
		case "cpuLoadStatus":
			err = unpopulate(val, "CPULoadStatus", &p.CPULoadStatus)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &p.HostID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &p.IPAddress)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &p.LastHeartbeat)
			delete(rawMsg, key)
		case "machineCount":
			err = unpopulate(val, "MachineCount", &p.MachineCount)
			delete(rawMsg, key)
		case "marsCommunicationStatus":
			err = unpopulate(val, "MarsCommunicationStatus", &p.MarsCommunicationStatus)
			delete(rawMsg, key)
		case "marsRegistrationStatus":
			err = unpopulate(val, "MarsRegistrationStatus", &p.MarsRegistrationStatus)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &p.MemoryUsageStatus)
			delete(rawMsg, key)
		case "mobilityServiceUpdates":
			err = unpopulate(val, "MobilityServiceUpdates", &p.MobilityServiceUpdates)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &p.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &p.OSVersion)
			delete(rawMsg, key)
		case "psServiceStatus":
			err = unpopulate(val, "PsServiceStatus", &p.PsServiceStatus)
			delete(rawMsg, key)
		case "psStatsRefreshTime":
			err = unpopulateDateTimeRFC3339(val, "PsStatsRefreshTime", &p.PsStatsRefreshTime)
			delete(rawMsg, key)
		case "replicationPairCount":
			err = unpopulate(val, "ReplicationPairCount", &p.ReplicationPairCount)
			delete(rawMsg, key)
		case "sslCertExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "SSLCertExpiryDate", &p.SSLCertExpiryDate)
			delete(rawMsg, key)
		case "sslCertExpiryRemainingDays":
			err = unpopulate(val, "SSLCertExpiryRemainingDays", &p.SSLCertExpiryRemainingDays)
			delete(rawMsg, key)
		case "spaceUsageStatus":
			err = unpopulate(val, "SpaceUsageStatus", &p.SpaceUsageStatus)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &p.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &p.SystemLoadStatus)
			delete(rawMsg, key)
		case "throughputInBytes":
			err = unpopulate(val, "ThroughputInBytes", &p.ThroughputInBytes)
			delete(rawMsg, key)
		case "throughputInMBps":
			err = unpopulate(val, "ThroughputInMBps", &p.ThroughputInMBps)
			delete(rawMsg, key)
		case "throughputStatus":
			err = unpopulate(val, "ThroughputStatus", &p.ThroughputStatus)
			delete(rawMsg, key)
		case "throughputUploadPendingDataInBytes":
			err = unpopulate(val, "ThroughputUploadPendingDataInBytes", &p.ThroughputUploadPendingDataInBytes)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &p.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &p.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &p.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessServerDetails.
func (p ProcessServerDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableMemoryInBytes", p.AvailableMemoryInBytes)
	populate(objectMap, "availableSpaceInBytes", p.AvailableSpaceInBytes)
	populate(objectMap, "biosId", p.BiosID)
	populate(objectMap, "diskUsageStatus", p.DiskUsageStatus)
	populate(objectMap, "fabricObjectId", p.FabricObjectID)
	populate(objectMap, "fqdn", p.Fqdn)
	populate(objectMap, "freeSpacePercentage", p.FreeSpacePercentage)
	populate(objectMap, "health", p.Health)
	populate(objectMap, "healthErrors", p.HealthErrors)
	populate(objectMap, "historicHealth", p.HistoricHealth)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "ipAddresses", p.IPAddresses)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", p.LastHeartbeatUTC)
	populate(objectMap, "memoryUsagePercentage", p.MemoryUsagePercentage)
	populate(objectMap, "memoryUsageStatus", p.MemoryUsageStatus)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "processorUsagePercentage", p.ProcessorUsagePercentage)
	populate(objectMap, "processorUsageStatus", p.ProcessorUsageStatus)
	populate(objectMap, "protectedItemCount", p.ProtectedItemCount)
	populate(objectMap, "systemLoad", p.SystemLoad)
	populate(objectMap, "systemLoadStatus", p.SystemLoadStatus)
	populate(objectMap, "throughputInBytes", p.ThroughputInBytes)
	populate(objectMap, "throughputStatus", p.ThroughputStatus)
	populate(objectMap, "throughputUploadPendingDataInBytes", p.ThroughputUploadPendingDataInBytes)
	populate(objectMap, "totalMemoryInBytes", p.TotalMemoryInBytes)
	populate(objectMap, "totalSpaceInBytes", p.TotalSpaceInBytes)
	populate(objectMap, "usedMemoryInBytes", p.UsedMemoryInBytes)
	populate(objectMap, "usedSpaceInBytes", p.UsedSpaceInBytes)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessServerDetails.
func (p *ProcessServerDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &p.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &p.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &p.BiosID)
			delete(rawMsg, key)
		case "diskUsageStatus":
			err = unpopulate(val, "DiskUsageStatus", &p.DiskUsageStatus)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "freeSpacePercentage":
			err = unpopulate(val, "FreeSpacePercentage", &p.FreeSpacePercentage)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "historicHealth":
			err = unpopulate(val, "HistoricHealth", &p.HistoricHealth)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &p.IPAddresses)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &p.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "memoryUsagePercentage":
			err = unpopulate(val, "MemoryUsagePercentage", &p.MemoryUsagePercentage)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &p.MemoryUsageStatus)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "processorUsagePercentage":
			err = unpopulate(val, "ProcessorUsagePercentage", &p.ProcessorUsagePercentage)
			delete(rawMsg, key)
		case "processorUsageStatus":
			err = unpopulate(val, "ProcessorUsageStatus", &p.ProcessorUsageStatus)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &p.ProtectedItemCount)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &p.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &p.SystemLoadStatus)
			delete(rawMsg, key)
		case "throughputInBytes":
			err = unpopulate(val, "ThroughputInBytes", &p.ThroughputInBytes)
			delete(rawMsg, key)
		case "throughputStatus":
			err = unpopulate(val, "ThroughputStatus", &p.ThroughputStatus)
			delete(rawMsg, key)
		case "throughputUploadPendingDataInBytes":
			err = unpopulate(val, "ThroughputUploadPendingDataInBytes", &p.ThroughputUploadPendingDataInBytes)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &p.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &p.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "usedMemoryInBytes":
			err = unpopulate(val, "UsedMemoryInBytes", &p.UsedMemoryInBytes)
			delete(rawMsg, key)
		case "usedSpaceInBytes":
			err = unpopulate(val, "UsedSpaceInBytes", &p.UsedSpaceInBytes)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectableItem.
func (p ProtectableItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableItem.
func (p *ProtectableItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectableItemCollection.
func (p ProtectableItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableItemCollection.
func (p *ProtectableItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectableItemProperties.
func (p ProtectableItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDetails", p.CustomDetails)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "protectionReadinessErrors", p.ProtectionReadinessErrors)
	populate(objectMap, "protectionStatus", p.ProtectionStatus)
	populate(objectMap, "recoveryServicesProviderId", p.RecoveryServicesProviderID)
	populate(objectMap, "replicationProtectedItemId", p.ReplicationProtectedItemID)
	populate(objectMap, "supportedReplicationProviders", p.SupportedReplicationProviders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableItemProperties.
func (p *ProtectableItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDetails":
			p.CustomDetails, err = unmarshalConfigurationSettingsClassification(val)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "protectionReadinessErrors":
			err = unpopulate(val, "ProtectionReadinessErrors", &p.ProtectionReadinessErrors)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &p.ProtectionStatus)
			delete(rawMsg, key)
		case "recoveryServicesProviderId":
			err = unpopulate(val, "RecoveryServicesProviderID", &p.RecoveryServicesProviderID)
			delete(rawMsg, key)
		case "replicationProtectedItemId":
			err = unpopulate(val, "ReplicationProtectedItemID", &p.ReplicationProtectedItemID)
			delete(rawMsg, key)
		case "supportedReplicationProviders":
			err = unpopulate(val, "SupportedReplicationProviders", &p.SupportedReplicationProviders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectableItemQueryParameter.
func (p ProtectableItemQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableItemQueryParameter.
func (p *ProtectableItemQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemsQueryParameter.
func (p ProtectedItemsQueryParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricObjectId", p.FabricObjectID)
	populate(objectMap, "instanceType", p.InstanceType)
	populate(objectMap, "multiVmGroupCreateOption", p.MultiVMGroupCreateOption)
	populate(objectMap, "processServerId", p.ProcessServerID)
	populate(objectMap, "recoveryPlanName", p.RecoveryPlanName)
	populate(objectMap, "sourceFabricLocation", p.SourceFabricLocation)
	populate(objectMap, "sourceFabricName", p.SourceFabricName)
	populate(objectMap, "vCenterName", p.VCenterName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemsQueryParameter.
func (p *ProtectedItemsQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupCreateOption":
			err = unpopulate(val, "MultiVMGroupCreateOption", &p.MultiVMGroupCreateOption)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &p.ProcessServerID)
			delete(rawMsg, key)
		case "recoveryPlanName":
			err = unpopulate(val, "RecoveryPlanName", &p.RecoveryPlanName)
			delete(rawMsg, key)
		case "sourceFabricLocation":
			err = unpopulate(val, "SourceFabricLocation", &p.SourceFabricLocation)
			delete(rawMsg, key)
		case "sourceFabricName":
			err = unpopulate(val, "SourceFabricName", &p.SourceFabricName)
			delete(rawMsg, key)
		case "vCenterName":
			err = unpopulate(val, "VCenterName", &p.VCenterName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainer.
func (p ProtectionContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainer.
func (p *ProtectionContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerCollection.
func (p ProtectionContainerCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerCollection.
func (p *ProtectionContainerCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerFabricSpecificDetails.
func (p ProtectionContainerFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", p.InstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerFabricSpecificDetails.
func (p *ProtectionContainerFabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerMapping.
func (p ProtectionContainerMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerMapping.
func (p *ProtectionContainerMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerMappingCollection.
func (p ProtectionContainerMappingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerMappingCollection.
func (p *ProtectionContainerMappingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerMappingProperties.
func (p ProtectionContainerMappingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "health", p.Health)
	populate(objectMap, "healthErrorDetails", p.HealthErrorDetails)
	populate(objectMap, "policyFriendlyName", p.PolicyFriendlyName)
	populate(objectMap, "policyId", p.PolicyID)
	populate(objectMap, "providerSpecificDetails", p.ProviderSpecificDetails)
	populate(objectMap, "sourceFabricFriendlyName", p.SourceFabricFriendlyName)
	populate(objectMap, "sourceProtectionContainerFriendlyName", p.SourceProtectionContainerFriendlyName)
	populate(objectMap, "state", p.State)
	populate(objectMap, "targetFabricFriendlyName", p.TargetFabricFriendlyName)
	populate(objectMap, "targetProtectionContainerFriendlyName", p.TargetProtectionContainerFriendlyName)
	populate(objectMap, "targetProtectionContainerId", p.TargetProtectionContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerMappingProperties.
func (p *ProtectionContainerMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &p.HealthErrorDetails)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &p.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &p.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalProtectionContainerMappingProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "sourceFabricFriendlyName":
			err = unpopulate(val, "SourceFabricFriendlyName", &p.SourceFabricFriendlyName)
			delete(rawMsg, key)
		case "sourceProtectionContainerFriendlyName":
			err = unpopulate(val, "SourceProtectionContainerFriendlyName", &p.SourceProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "targetFabricFriendlyName":
			err = unpopulate(val, "TargetFabricFriendlyName", &p.TargetFabricFriendlyName)
			delete(rawMsg, key)
		case "targetProtectionContainerFriendlyName":
			err = unpopulate(val, "TargetProtectionContainerFriendlyName", &p.TargetProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "targetProtectionContainerId":
			err = unpopulate(val, "TargetProtectionContainerID", &p.TargetProtectionContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerMappingProviderSpecificDetails.
func (p ProtectionContainerMappingProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerMappingProviderSpecificDetails.
func (p *ProtectionContainerMappingProviderSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionContainerProperties.
func (p ProtectionContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricFriendlyName", p.FabricFriendlyName)
	populate(objectMap, "fabricSpecificDetails", p.FabricSpecificDetails)
	populate(objectMap, "fabricType", p.FabricType)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "pairingStatus", p.PairingStatus)
	populate(objectMap, "protectedItemCount", p.ProtectedItemCount)
	populate(objectMap, "role", p.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerProperties.
func (p *ProtectionContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricFriendlyName":
			err = unpopulate(val, "FabricFriendlyName", &p.FabricFriendlyName)
			delete(rawMsg, key)
		case "fabricSpecificDetails":
			err = unpopulate(val, "FabricSpecificDetails", &p.FabricSpecificDetails)
			delete(rawMsg, key)
		case "fabricType":
			err = unpopulate(val, "FabricType", &p.FabricType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "pairingStatus":
			err = unpopulate(val, "PairingStatus", &p.PairingStatus)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &p.ProtectedItemCount)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &p.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectionProfileCustomDetails.
func (p ProtectionProfileCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = p.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionProfileCustomDetails.
func (p *ProtectionProfileCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &p.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderError.
func (p ProviderError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", p.ErrorCode)
	populate(objectMap, "errorId", p.ErrorID)
	populate(objectMap, "errorMessage", p.ErrorMessage)
	populate(objectMap, "possibleCauses", p.PossibleCauses)
	populate(objectMap, "recommendedAction", p.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderError.
func (p *ProviderError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &p.ErrorCode)
			delete(rawMsg, key)
		case "errorId":
			err = unpopulate(val, "ErrorID", &p.ErrorID)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &p.ErrorMessage)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &p.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &p.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderSpecificRecoveryPointDetails.
func (p ProviderSpecificRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderSpecificRecoveryPointDetails.
func (p *ProviderSpecificRecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PushInstallerDetails.
func (p PushInstallerDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", p.BiosID)
	populate(objectMap, "fabricObjectId", p.FabricObjectID)
	populate(objectMap, "fqdn", p.Fqdn)
	populate(objectMap, "health", p.Health)
	populate(objectMap, "healthErrors", p.HealthErrors)
	populate(objectMap, "id", p.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", p.LastHeartbeatUTC)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushInstallerDetails.
func (p *PushInstallerDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &p.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &p.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RcmProxyDetails.
func (r RcmProxyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", r.BiosID)
	populate(objectMap, "clientAuthenticationType", r.ClientAuthenticationType)
	populate(objectMap, "fabricObjectId", r.FabricObjectID)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "health", r.Health)
	populate(objectMap, "healthErrors", r.HealthErrors)
	populate(objectMap, "id", r.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", r.LastHeartbeatUTC)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "version", r.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RcmProxyDetails.
func (r *RcmProxyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "clientAuthenticationType":
			err = unpopulate(val, "ClientAuthenticationType", &r.ClientAuthenticationType)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryAvailabilitySetCustomDetails.
func (r RecoveryAvailabilitySetCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = r.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryAvailabilitySetCustomDetails.
func (r *RecoveryAvailabilitySetCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlan.
func (r RecoveryPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlan.
func (r *RecoveryPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanA2ADetails.
func (r RecoveryPlanA2ADetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "primaryExtendedLocation", r.PrimaryExtendedLocation)
	populate(objectMap, "primaryZone", r.PrimaryZone)
	populate(objectMap, "recoveryExtendedLocation", r.RecoveryExtendedLocation)
	populate(objectMap, "recoveryZone", r.RecoveryZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2ADetails.
func (r *RecoveryPlanA2ADetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &r.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryZone":
			err = unpopulate(val, "PrimaryZone", &r.PrimaryZone)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &r.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryZone":
			err = unpopulate(val, "RecoveryZone", &r.RecoveryZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanA2AFailoverInput.
func (r RecoveryPlanA2AFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudServiceCreationOption", r.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmSyncPointOption", r.MultiVMSyncPointOption)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2AFailoverInput.
func (r *RecoveryPlanA2AFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &r.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncPointOption":
			err = unpopulate(val, "MultiVMSyncPointOption", &r.MultiVMSyncPointOption)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanA2AInput.
func (r RecoveryPlanA2AInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "primaryExtendedLocation", r.PrimaryExtendedLocation)
	populate(objectMap, "primaryZone", r.PrimaryZone)
	populate(objectMap, "recoveryExtendedLocation", r.RecoveryExtendedLocation)
	populate(objectMap, "recoveryZone", r.RecoveryZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2AInput.
func (r *RecoveryPlanA2AInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &r.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryZone":
			err = unpopulate(val, "PrimaryZone", &r.PrimaryZone)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &r.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryZone":
			err = unpopulate(val, "RecoveryZone", &r.RecoveryZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanAction.
func (r RecoveryPlanAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "customDetails", r.CustomDetails)
	populate(objectMap, "failoverDirections", r.FailoverDirections)
	populate(objectMap, "failoverTypes", r.FailoverTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanAction.
func (r *RecoveryPlanAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "customDetails":
			r.CustomDetails, err = unmarshalRecoveryPlanActionDetailsClassification(val)
			delete(rawMsg, key)
		case "failoverDirections":
			err = unpopulate(val, "FailoverDirections", &r.FailoverDirections)
			delete(rawMsg, key)
		case "failoverTypes":
			err = unpopulate(val, "FailoverTypes", &r.FailoverTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanActionDetails.
func (r RecoveryPlanActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanActionDetails.
func (r *RecoveryPlanActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r RecoveryPlanAutomationRunbookActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricLocation", r.FabricLocation)
	objectMap["instanceType"] = "AutomationRunbookActionDetails"
	populate(objectMap, "runbookId", r.RunbookID)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r *RecoveryPlanAutomationRunbookActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &r.FabricLocation)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "runbookId":
			err = unpopulate(val, "RunbookID", &r.RunbookID)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanCollection.
func (r RecoveryPlanCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanCollection.
func (r *RecoveryPlanCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanGroup.
func (r RecoveryPlanGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endGroupActions", r.EndGroupActions)
	populate(objectMap, "groupType", r.GroupType)
	populate(objectMap, "replicationProtectedItems", r.ReplicationProtectedItems)
	populate(objectMap, "startGroupActions", r.StartGroupActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanGroup.
func (r *RecoveryPlanGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endGroupActions":
			err = unpopulate(val, "EndGroupActions", &r.EndGroupActions)
			delete(rawMsg, key)
		case "groupType":
			err = unpopulate(val, "GroupType", &r.GroupType)
			delete(rawMsg, key)
		case "replicationProtectedItems":
			err = unpopulate(val, "ReplicationProtectedItems", &r.ReplicationProtectedItems)
			delete(rawMsg, key)
		case "startGroupActions":
			err = unpopulate(val, "StartGroupActions", &r.StartGroupActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanGroupTaskDetails.
func (r RecoveryPlanGroupTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "childTasks", r.ChildTasks)
	populate(objectMap, "groupId", r.GroupID)
	objectMap["instanceType"] = "RecoveryPlanGroupTaskDetails"
	populate(objectMap, "name", r.Name)
	populate(objectMap, "rpGroupType", r.RpGroupType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &r.ChildTasks)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &r.GroupID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "rpGroupType":
			err = unpopulate(val, "RpGroupType", &r.RpGroupType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r RecoveryPlanHyperVReplicaAzureFailbackInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSyncOption", r.DataSyncOption)
	objectMap["instanceType"] = "HyperVReplicaAzureFailback"
	populate(objectMap, "recoveryVmCreationOption", r.RecoveryVMCreationOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r *RecoveryPlanHyperVReplicaAzureFailbackInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSyncOption":
			err = unpopulate(val, "DataSyncOption", &r.DataSyncOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryVmCreationOption":
			err = unpopulate(val, "RecoveryVMCreationOption", &r.RecoveryVMCreationOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r RecoveryPlanHyperVReplicaAzureFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", r.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "secondaryKekCertificatePfx", r.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r *RecoveryPlanHyperVReplicaAzureFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &r.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &r.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageAzureV2FailoverInput.
func (r RecoveryPlanInMageAzureV2FailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageAzureV2FailoverInput.
func (r *RecoveryPlanInMageAzureV2FailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageFailoverInput.
func (r RecoveryPlanInMageFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageFailoverInput.
func (r *RecoveryPlanInMageFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r RecoveryPlanInMageRcmFailbackFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r *RecoveryPlanInMageRcmFailbackFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageRcmFailoverInput.
func (r RecoveryPlanInMageRcmFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageRcmFailoverInput.
func (r *RecoveryPlanInMageRcmFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanManualActionDetails.
func (r RecoveryPlanManualActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	objectMap["instanceType"] = "ManualActionDetails"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanManualActionDetails.
func (r *RecoveryPlanManualActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanPlannedFailoverInput.
func (r RecoveryPlanPlannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanPlannedFailoverInput.
func (r *RecoveryPlanPlannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanPlannedFailoverInputProperties.
func (r RecoveryPlanPlannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanPlannedFailoverInputProperties.
func (r *RecoveryPlanPlannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanProperties.
func (r RecoveryPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedOperations", r.AllowedOperations)
	populate(objectMap, "currentScenario", r.CurrentScenario)
	populate(objectMap, "currentScenarioStatus", r.CurrentScenarioStatus)
	populate(objectMap, "currentScenarioStatusDescription", r.CurrentScenarioStatusDescription)
	populate(objectMap, "failoverDeploymentModel", r.FailoverDeploymentModel)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "groups", r.Groups)
	populateDateTimeRFC3339(objectMap, "lastPlannedFailoverTime", r.LastPlannedFailoverTime)
	populateDateTimeRFC3339(objectMap, "lastTestFailoverTime", r.LastTestFailoverTime)
	populateDateTimeRFC3339(objectMap, "lastUnplannedFailoverTime", r.LastUnplannedFailoverTime)
	populate(objectMap, "primaryFabricFriendlyName", r.PrimaryFabricFriendlyName)
	populate(objectMap, "primaryFabricId", r.PrimaryFabricID)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	populate(objectMap, "recoveryFabricFriendlyName", r.RecoveryFabricFriendlyName)
	populate(objectMap, "recoveryFabricId", r.RecoveryFabricID)
	populate(objectMap, "replicationProviders", r.ReplicationProviders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProperties.
func (r *RecoveryPlanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &r.AllowedOperations)
			delete(rawMsg, key)
		case "currentScenario":
			err = unpopulate(val, "CurrentScenario", &r.CurrentScenario)
			delete(rawMsg, key)
		case "currentScenarioStatus":
			err = unpopulate(val, "CurrentScenarioStatus", &r.CurrentScenarioStatus)
			delete(rawMsg, key)
		case "currentScenarioStatusDescription":
			err = unpopulate(val, "CurrentScenarioStatusDescription", &r.CurrentScenarioStatusDescription)
			delete(rawMsg, key)
		case "failoverDeploymentModel":
			err = unpopulate(val, "FailoverDeploymentModel", &r.FailoverDeploymentModel)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &r.Groups)
			delete(rawMsg, key)
		case "lastPlannedFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastPlannedFailoverTime", &r.LastPlannedFailoverTime)
			delete(rawMsg, key)
		case "lastTestFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastTestFailoverTime", &r.LastTestFailoverTime)
			delete(rawMsg, key)
		case "lastUnplannedFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastUnplannedFailoverTime", &r.LastUnplannedFailoverTime)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &r.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryFabricId":
			err = unpopulate(val, "PrimaryFabricID", &r.PrimaryFabricID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &r.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &r.RecoveryFabricID)
			delete(rawMsg, key)
		case "replicationProviders":
			err = unpopulate(val, "ReplicationProviders", &r.ReplicationProviders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanProtectedItem.
func (r RecoveryPlanProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "virtualMachineId", r.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProtectedItem.
func (r *RecoveryPlanProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &r.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanProviderSpecificDetails.
func (r RecoveryPlanProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProviderSpecificDetails.
func (r *RecoveryPlanProviderSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanProviderSpecificFailoverInput.
func (r RecoveryPlanProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProviderSpecificFailoverInput.
func (r *RecoveryPlanProviderSpecificFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanProviderSpecificInput.
func (r RecoveryPlanProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProviderSpecificInput.
func (r *RecoveryPlanProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanScriptActionDetails.
func (r RecoveryPlanScriptActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricLocation", r.FabricLocation)
	objectMap["instanceType"] = "ScriptActionDetails"
	populate(objectMap, "path", r.Path)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanScriptActionDetails.
func (r *RecoveryPlanScriptActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &r.FabricLocation)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r RecoveryPlanShutdownGroupTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "childTasks", r.ChildTasks)
	populate(objectMap, "groupId", r.GroupID)
	objectMap["instanceType"] = "RecoveryPlanShutdownGroupTaskDetails"
	populate(objectMap, "name", r.Name)
	populate(objectMap, "rpGroupType", r.RpGroupType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &r.ChildTasks)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &r.GroupID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "rpGroupType":
			err = unpopulate(val, "RpGroupType", &r.RpGroupType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanTestFailoverCleanupInput.
func (r RecoveryPlanTestFailoverCleanupInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanTestFailoverCleanupInput.
func (r *RecoveryPlanTestFailoverCleanupInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanTestFailoverCleanupInputProperties.
func (r RecoveryPlanTestFailoverCleanupInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "comments", r.Comments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanTestFailoverCleanupInputProperties.
func (r *RecoveryPlanTestFailoverCleanupInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "comments":
			err = unpopulate(val, "Comments", &r.Comments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanTestFailoverInput.
func (r RecoveryPlanTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanTestFailoverInput.
func (r *RecoveryPlanTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanTestFailoverInputProperties.
func (r RecoveryPlanTestFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "networkId", r.NetworkID)
	populate(objectMap, "networkType", r.NetworkType)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanTestFailoverInputProperties.
func (r *RecoveryPlanTestFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &r.NetworkID)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &r.NetworkType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanUnplannedFailoverInput.
func (r RecoveryPlanUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanUnplannedFailoverInput.
func (r *RecoveryPlanUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanUnplannedFailoverInputProperties.
func (r RecoveryPlanUnplannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	populate(objectMap, "sourceSiteOperations", r.SourceSiteOperations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanUnplannedFailoverInputProperties.
func (r *RecoveryPlanUnplannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		case "sourceSiteOperations":
			err = unpopulate(val, "SourceSiteOperations", &r.SourceSiteOperations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPoint.
func (r RecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPoint.
func (r *RecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointCollection.
func (r RecoveryPointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointCollection.
func (r *RecoveryPointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointProperties.
func (r RecoveryPointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", r.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointProperties.
func (r *RecoveryPointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalProviderSpecificRecoveryPointDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &r.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryProximityPlacementGroupCustomDetails.
func (r RecoveryProximityPlacementGroupCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = r.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryProximityPlacementGroupCustomDetails.
func (r *RecoveryProximityPlacementGroupCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryResourceGroupCustomDetails.
func (r RecoveryResourceGroupCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = r.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryResourceGroupCustomDetails.
func (r *RecoveryResourceGroupCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryServicesProvider.
func (r RecoveryServicesProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryServicesProvider.
func (r *RecoveryServicesProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryServicesProviderCollection.
func (r RecoveryServicesProviderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryServicesProviderCollection.
func (r *RecoveryServicesProviderCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryServicesProviderProperties.
func (r RecoveryServicesProviderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedScenarios", r.AllowedScenarios)
	populate(objectMap, "authenticationIdentityDetails", r.AuthenticationIdentityDetails)
	populate(objectMap, "biosId", r.BiosID)
	populate(objectMap, "connectionStatus", r.ConnectionStatus)
	populate(objectMap, "dataPlaneAuthenticationIdentityDetails", r.DataPlaneAuthenticationIdentityDetails)
	populate(objectMap, "draIdentifier", r.DraIdentifier)
	populate(objectMap, "fabricFriendlyName", r.FabricFriendlyName)
	populate(objectMap, "fabricType", r.FabricType)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "healthErrorDetails", r.HealthErrorDetails)
	populateDateTimeRFC3339(objectMap, "lastHeartBeat", r.LastHeartBeat)
	populate(objectMap, "machineId", r.MachineID)
	populate(objectMap, "machineName", r.MachineName)
	populate(objectMap, "protectedItemCount", r.ProtectedItemCount)
	populate(objectMap, "providerVersion", r.ProviderVersion)
	populate(objectMap, "providerVersionDetails", r.ProviderVersionDetails)
	populateDateTimeRFC3339(objectMap, "providerVersionExpiryDate", r.ProviderVersionExpiryDate)
	populate(objectMap, "providerVersionState", r.ProviderVersionState)
	populate(objectMap, "resourceAccessIdentityDetails", r.ResourceAccessIdentityDetails)
	populate(objectMap, "serverVersion", r.ServerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryServicesProviderProperties.
func (r *RecoveryServicesProviderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedScenarios":
			err = unpopulate(val, "AllowedScenarios", &r.AllowedScenarios)
			delete(rawMsg, key)
		case "authenticationIdentityDetails":
			err = unpopulate(val, "AuthenticationIdentityDetails", &r.AuthenticationIdentityDetails)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &r.ConnectionStatus)
			delete(rawMsg, key)
		case "dataPlaneAuthenticationIdentityDetails":
			err = unpopulate(val, "DataPlaneAuthenticationIdentityDetails", &r.DataPlaneAuthenticationIdentityDetails)
			delete(rawMsg, key)
		case "draIdentifier":
			err = unpopulate(val, "DraIdentifier", &r.DraIdentifier)
			delete(rawMsg, key)
		case "fabricFriendlyName":
			err = unpopulate(val, "FabricFriendlyName", &r.FabricFriendlyName)
			delete(rawMsg, key)
		case "fabricType":
			err = unpopulate(val, "FabricType", &r.FabricType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &r.HealthErrorDetails)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartBeat", &r.LastHeartBeat)
			delete(rawMsg, key)
		case "machineId":
			err = unpopulate(val, "MachineID", &r.MachineID)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &r.MachineName)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &r.ProtectedItemCount)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &r.ProviderVersion)
			delete(rawMsg, key)
		case "providerVersionDetails":
			err = unpopulate(val, "ProviderVersionDetails", &r.ProviderVersionDetails)
			delete(rawMsg, key)
		case "providerVersionExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "ProviderVersionExpiryDate", &r.ProviderVersionExpiryDate)
			delete(rawMsg, key)
		case "providerVersionState":
			err = unpopulate(val, "ProviderVersionState", &r.ProviderVersionState)
			delete(rawMsg, key)
		case "resourceAccessIdentityDetails":
			err = unpopulate(val, "ResourceAccessIdentityDetails", &r.ResourceAccessIdentityDetails)
			delete(rawMsg, key)
		case "serverVersion":
			err = unpopulate(val, "ServerVersion", &r.ServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryVirtualNetworkCustomDetails.
func (r RecoveryVirtualNetworkCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = r.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryVirtualNetworkCustomDetails.
func (r *RecoveryVirtualNetworkCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveDisksInput.
func (r RemoveDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveDisksInput.
func (r *RemoveDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveDisksInputProperties.
func (r RemoveDisksInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveDisksInputProperties.
func (r *RemoveDisksInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRemoveDisksProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveDisksProviderSpecificInput.
func (r RemoveDisksProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveDisksProviderSpecificInput.
func (r *RemoveDisksProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveProtectionContainerMappingInput.
func (r RemoveProtectionContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveProtectionContainerMappingInput.
func (r *RemoveProtectionContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveProtectionContainerMappingInputProperties.
func (r RemoveProtectionContainerMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificInput", r.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveProtectionContainerMappingInputProperties.
func (r *RemoveProtectionContainerMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			err = unpopulate(val, "ProviderSpecificInput", &r.ProviderSpecificInput)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewCertificateInput.
func (r RenewCertificateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewCertificateInput.
func (r *RenewCertificateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewCertificateInputProperties.
func (r RenewCertificateInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "renewCertificateType", r.RenewCertificateType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewCertificateInputProperties.
func (r *RenewCertificateInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "renewCertificateType":
			err = unpopulate(val, "RenewCertificateType", &r.RenewCertificateType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationAgentDetails.
func (r ReplicationAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", r.BiosID)
	populate(objectMap, "fabricObjectId", r.FabricObjectID)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "health", r.Health)
	populate(objectMap, "healthErrors", r.HealthErrors)
	populate(objectMap, "id", r.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", r.LastHeartbeatUTC)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "version", r.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationAgentDetails.
func (r *ReplicationAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationAppliance.
func (r ReplicationAppliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationAppliance.
func (r *ReplicationAppliance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationApplianceProperties.
func (r ReplicationApplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationApplianceProperties.
func (r *ReplicationApplianceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalApplianceSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationEligibilityResults.
func (r ReplicationEligibilityResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationEligibilityResults.
func (r *ReplicationEligibilityResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationEligibilityResultsCollection.
func (r ReplicationEligibilityResultsCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationEligibilityResultsCollection.
func (r *ReplicationEligibilityResultsCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationEligibilityResultsErrorInfo.
func (r ReplicationEligibilityResultsErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "possibleCauses", r.PossibleCauses)
	populate(objectMap, "recommendedAction", r.RecommendedAction)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationEligibilityResultsErrorInfo.
func (r *ReplicationEligibilityResultsErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &r.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &r.RecommendedAction)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationEligibilityResultsProperties.
func (r ReplicationEligibilityResultsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientRequestId", r.ClientRequestID)
	populate(objectMap, "errors", r.Errors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationEligibilityResultsProperties.
func (r *ReplicationEligibilityResultsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &r.ClientRequestID)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &r.Errors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationGroupDetails.
func (r ReplicationGroupDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "ReplicationGroupDetails"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationGroupDetails.
func (r *ReplicationGroupDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectedItem.
func (r ReplicationProtectedItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectedItem.
func (r *ReplicationProtectedItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectedItemCollection.
func (r ReplicationProtectedItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectedItemCollection.
func (r *ReplicationProtectedItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectedItemProperties.
func (r ReplicationProtectedItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeLocation", r.ActiveLocation)
	populate(objectMap, "allowedOperations", r.AllowedOperations)
	populate(objectMap, "currentScenario", r.CurrentScenario)
	populate(objectMap, "eventCorrelationId", r.EventCorrelationID)
	populate(objectMap, "failoverHealth", r.FailoverHealth)
	populate(objectMap, "failoverRecoveryPointId", r.FailoverRecoveryPointID)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "healthErrors", r.HealthErrors)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulFailoverTime", r.LastSuccessfulFailoverTime)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulTestFailoverTime", r.LastSuccessfulTestFailoverTime)
	populate(objectMap, "policyFriendlyName", r.PolicyFriendlyName)
	populate(objectMap, "policyId", r.PolicyID)
	populate(objectMap, "primaryFabricFriendlyName", r.PrimaryFabricFriendlyName)
	populate(objectMap, "primaryFabricProvider", r.PrimaryFabricProvider)
	populate(objectMap, "primaryProtectionContainerFriendlyName", r.PrimaryProtectionContainerFriendlyName)
	populate(objectMap, "protectableItemId", r.ProtectableItemID)
	populate(objectMap, "protectedItemType", r.ProtectedItemType)
	populate(objectMap, "protectionState", r.ProtectionState)
	populate(objectMap, "protectionStateDescription", r.ProtectionStateDescription)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	populate(objectMap, "recoveryContainerId", r.RecoveryContainerID)
	populate(objectMap, "recoveryFabricFriendlyName", r.RecoveryFabricFriendlyName)
	populate(objectMap, "recoveryFabricId", r.RecoveryFabricID)
	populate(objectMap, "recoveryProtectionContainerFriendlyName", r.RecoveryProtectionContainerFriendlyName)
	populate(objectMap, "recoveryServicesProviderId", r.RecoveryServicesProviderID)
	populate(objectMap, "replicationHealth", r.ReplicationHealth)
	populate(objectMap, "switchProviderState", r.SwitchProviderState)
	populate(objectMap, "switchProviderStateDescription", r.SwitchProviderStateDescription)
	populate(objectMap, "testFailoverState", r.TestFailoverState)
	populate(objectMap, "testFailoverStateDescription", r.TestFailoverStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectedItemProperties.
func (r *ReplicationProtectedItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeLocation":
			err = unpopulate(val, "ActiveLocation", &r.ActiveLocation)
			delete(rawMsg, key)
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &r.AllowedOperations)
			delete(rawMsg, key)
		case "currentScenario":
			err = unpopulate(val, "CurrentScenario", &r.CurrentScenario)
			delete(rawMsg, key)
		case "eventCorrelationId":
			err = unpopulate(val, "EventCorrelationID", &r.EventCorrelationID)
			delete(rawMsg, key)
		case "failoverHealth":
			err = unpopulate(val, "FailoverHealth", &r.FailoverHealth)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &r.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "lastSuccessfulFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulFailoverTime", &r.LastSuccessfulFailoverTime)
			delete(rawMsg, key)
		case "lastSuccessfulTestFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulTestFailoverTime", &r.LastSuccessfulTestFailoverTime)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &r.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &r.PolicyID)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &r.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryFabricProvider":
			err = unpopulate(val, "PrimaryFabricProvider", &r.PrimaryFabricProvider)
			delete(rawMsg, key)
		case "primaryProtectionContainerFriendlyName":
			err = unpopulate(val, "PrimaryProtectionContainerFriendlyName", &r.PrimaryProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "protectableItemId":
			err = unpopulate(val, "ProtectableItemID", &r.ProtectableItemID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &r.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &r.ProtectionState)
			delete(rawMsg, key)
		case "protectionStateDescription":
			err = unpopulate(val, "ProtectionStateDescription", &r.ProtectionStateDescription)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReplicationProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &r.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &r.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &r.RecoveryFabricID)
			delete(rawMsg, key)
		case "recoveryProtectionContainerFriendlyName":
			err = unpopulate(val, "RecoveryProtectionContainerFriendlyName", &r.RecoveryProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "recoveryServicesProviderId":
			err = unpopulate(val, "RecoveryServicesProviderID", &r.RecoveryServicesProviderID)
			delete(rawMsg, key)
		case "replicationHealth":
			err = unpopulate(val, "ReplicationHealth", &r.ReplicationHealth)
			delete(rawMsg, key)
		case "switchProviderState":
			err = unpopulate(val, "SwitchProviderState", &r.SwitchProviderState)
			delete(rawMsg, key)
		case "switchProviderStateDescription":
			err = unpopulate(val, "SwitchProviderStateDescription", &r.SwitchProviderStateDescription)
			delete(rawMsg, key)
		case "testFailoverState":
			err = unpopulate(val, "TestFailoverState", &r.TestFailoverState)
			delete(rawMsg, key)
		case "testFailoverStateDescription":
			err = unpopulate(val, "TestFailoverStateDescription", &r.TestFailoverStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectionIntent.
func (r ReplicationProtectionIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectionIntent.
func (r *ReplicationProtectionIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectionIntentCollection.
func (r ReplicationProtectionIntentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectionIntentCollection.
func (r *ReplicationProtectionIntentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectionIntentProperties.
func (r ReplicationProtectionIntentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationTimeUTC", r.CreationTimeUTC)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "isActive", r.IsActive)
	populate(objectMap, "jobId", r.JobID)
	populate(objectMap, "jobState", r.JobState)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectionIntentProperties.
func (r *ReplicationProtectionIntentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUTC":
			err = unpopulate(val, "CreationTimeUTC", &r.CreationTimeUTC)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &r.IsActive)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &r.JobID)
			delete(rawMsg, key)
		case "jobState":
			err = unpopulate(val, "JobState", &r.JobState)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReplicationProtectionIntentProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProtectionIntentProviderSpecificSettings.
func (r ReplicationProtectionIntentProviderSpecificSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectionIntentProviderSpecificSettings.
func (r *ReplicationProtectionIntentProviderSpecificSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProviderContainerUnmappingInput.
func (r ReplicationProviderContainerUnmappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", r.InstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProviderContainerUnmappingInput.
func (r *ReplicationProviderContainerUnmappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProviderSpecificContainerCreationInput.
func (r ReplicationProviderSpecificContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProviderSpecificContainerCreationInput.
func (r *ReplicationProviderSpecificContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProviderSpecificContainerMappingInput.
func (r ReplicationProviderSpecificContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProviderSpecificContainerMappingInput.
func (r *ReplicationProviderSpecificContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProviderSpecificSettings.
func (r ReplicationProviderSpecificSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProviderSpecificSettings.
func (r *ReplicationProviderSpecificSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationProviderSpecificUpdateContainerMappingInput.
func (r ReplicationProviderSpecificUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProviderSpecificUpdateContainerMappingInput.
func (r *ReplicationProviderSpecificUpdateContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReprotectAgentDetails.
func (r ReprotectAgentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessibleDatastores", r.AccessibleDatastores)
	populate(objectMap, "biosId", r.BiosID)
	populate(objectMap, "fabricObjectId", r.FabricObjectID)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "health", r.Health)
	populate(objectMap, "healthErrors", r.HealthErrors)
	populate(objectMap, "id", r.ID)
	populateDateTimeRFC3339(objectMap, "lastDiscoveryInUtc", r.LastDiscoveryInUTC)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", r.LastHeartbeatUTC)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "protectedItemCount", r.ProtectedItemCount)
	populate(objectMap, "vcenterId", r.VcenterID)
	populate(objectMap, "version", r.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReprotectAgentDetails.
func (r *ReprotectAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessibleDatastores":
			err = unpopulate(val, "AccessibleDatastores", &r.AccessibleDatastores)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastDiscoveryInUtc":
			err = unpopulateDateTimeRFC3339(val, "LastDiscoveryInUTC", &r.LastDiscoveryInUTC)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &r.ProtectedItemCount)
			delete(rawMsg, key)
		case "vcenterId":
			err = unpopulate(val, "VcenterID", &r.VcenterID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolveHealthError.
func (r ResolveHealthError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthErrorId", r.HealthErrorID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolveHealthError.
func (r *ResolveHealthError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthErrorId":
			err = unpopulate(val, "HealthErrorID", &r.HealthErrorID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolveHealthInput.
func (r ResolveHealthInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolveHealthInput.
func (r *ResolveHealthInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolveHealthInputProperties.
func (r ResolveHealthInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthErrors", r.HealthErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResolveHealthInputProperties.
func (r *ResolveHealthInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHealthSummary.
func (r ResourceHealthSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "categorizedResourceCounts", r.CategorizedResourceCounts)
	populate(objectMap, "issues", r.Issues)
	populate(objectMap, "resourceCount", r.ResourceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceHealthSummary.
func (r *ResourceHealthSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "categorizedResourceCounts":
			err = unpopulate(val, "CategorizedResourceCounts", &r.CategorizedResourceCounts)
			delete(rawMsg, key)
		case "issues":
			err = unpopulate(val, "Issues", &r.Issues)
			delete(rawMsg, key)
		case "resourceCount":
			err = unpopulate(val, "ResourceCount", &r.ResourceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResumeJobParams.
func (r ResumeJobParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResumeJobParams.
func (r *ResumeJobParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResumeJobParamsProperties.
func (r ResumeJobParamsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "comments", r.Comments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResumeJobParamsProperties.
func (r *ResumeJobParamsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "comments":
			err = unpopulate(val, "Comments", &r.Comments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResumeReplicationInput.
func (r ResumeReplicationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResumeReplicationInput.
func (r *ResumeReplicationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResumeReplicationInputProperties.
func (r ResumeReplicationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResumeReplicationInputProperties.
func (r *ResumeReplicationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalResumeReplicationProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResumeReplicationProviderSpecificInput.
func (r ResumeReplicationProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResumeReplicationProviderSpecificInput.
func (r *ResumeReplicationProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResyncInput.
func (r ResyncInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResyncInput.
func (r *ResyncInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResyncInputProperties.
func (r ResyncInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResyncInputProperties.
func (r *ResyncInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalResyncProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResyncProviderSpecificInput.
func (r ResyncProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResyncProviderSpecificInput.
func (r *ResyncProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetentionVolume.
func (r RetentionVolume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", r.CapacityInBytes)
	populate(objectMap, "freeSpaceInBytes", r.FreeSpaceInBytes)
	populate(objectMap, "thresholdPercentage", r.ThresholdPercentage)
	populate(objectMap, "volumeName", r.VolumeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetentionVolume.
func (r *RetentionVolume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &r.CapacityInBytes)
			delete(rawMsg, key)
		case "freeSpaceInBytes":
			err = unpopulate(val, "FreeSpaceInBytes", &r.FreeSpaceInBytes)
			delete(rawMsg, key)
		case "thresholdPercentage":
			err = unpopulate(val, "ThresholdPercentage", &r.ThresholdPercentage)
			delete(rawMsg, key)
		case "volumeName":
			err = unpopulate(val, "VolumeName", &r.VolumeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseReplicationInput.
func (r ReverseReplicationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseReplicationInput.
func (r *ReverseReplicationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseReplicationInputProperties.
func (r ReverseReplicationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseReplicationInputProperties.
func (r *ReverseReplicationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReverseReplicationProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseReplicationProviderSpecificInput.
func (r ReverseReplicationProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseReplicationProviderSpecificInput.
func (r *ReverseReplicationProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunAsAccount.
func (r RunAsAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", r.AccountID)
	populate(objectMap, "accountName", r.AccountName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunAsAccount.
func (r *RunAsAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &r.AccountID)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &r.AccountName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionTaskDetails.
func (s ScriptActionTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "ScriptActionTaskDetails"
	populate(objectMap, "isPrimarySideScript", s.IsPrimarySideScript)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "output", s.Output)
	populate(objectMap, "path", s.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionTaskDetails.
func (s *ScriptActionTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		case "isPrimarySideScript":
			err = unpopulate(val, "IsPrimarySideScript", &s.IsPrimarySideScript)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &s.Output)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceError.
func (s ServiceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", s.ActivityID)
	populate(objectMap, "code", s.Code)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "possibleCauses", s.PossibleCauses)
	populate(objectMap, "recommendedAction", s.RecommendedAction)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceError.
func (s *ServiceError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &s.ActivityID)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &s.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &s.RecommendedAction)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountCustomDetails.
func (s StorageAccountCustomDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = s.ResourceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountCustomDetails.
func (s *StorageAccountCustomDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassification.
func (s StorageClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassification.
func (s *StorageClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationCollection.
func (s StorageClassificationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationCollection.
func (s *StorageClassificationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationMapping.
func (s StorageClassificationMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationMapping.
func (s *StorageClassificationMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationMappingCollection.
func (s StorageClassificationMappingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationMappingCollection.
func (s *StorageClassificationMappingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationMappingInput.
func (s StorageClassificationMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationMappingInput.
func (s *StorageClassificationMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationMappingProperties.
func (s StorageClassificationMappingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetStorageClassificationId", s.TargetStorageClassificationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationMappingProperties.
func (s *StorageClassificationMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetStorageClassificationId":
			err = unpopulate(val, "TargetStorageClassificationID", &s.TargetStorageClassificationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageClassificationProperties.
func (s StorageClassificationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", s.FriendlyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageClassificationProperties.
func (s *StorageClassificationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMappingInputProperties.
func (s StorageMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetStorageClassificationId", s.TargetStorageClassificationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMappingInputProperties.
func (s *StorageMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetStorageClassificationId":
			err = unpopulate(val, "TargetStorageClassificationID", &s.TargetStorageClassificationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressList", s.AddressList)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subnet.
func (s *Subnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressList":
			err = unpopulate(val, "AddressList", &s.AddressList)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedOSDetails.
func (s SupportedOSDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osName", s.OSName)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "osVersions", s.OSVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedOSDetails.
func (s *SupportedOSDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osName":
			err = unpopulate(val, "OSName", &s.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "osVersions":
			err = unpopulate(val, "OSVersions", &s.OSVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedOSProperties.
func (s SupportedOSProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedOsList", s.SupportedOsList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedOSProperties.
func (s *SupportedOSProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedOsList":
			err = unpopulate(val, "SupportedOsList", &s.SupportedOsList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedOSProperty.
func (s SupportedOSProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", s.InstanceType)
	populate(objectMap, "supportedOs", s.SupportedOs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedOSProperty.
func (s *SupportedOSProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		case "supportedOs":
			err = unpopulate(val, "SupportedOs", &s.SupportedOs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportedOperatingSystems.
func (s SupportedOperatingSystems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportedOperatingSystems.
func (s *SupportedOperatingSystems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProtectionInput.
func (s SwitchProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionInput.
func (s *SwitchProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProtectionInputProperties.
func (s SwitchProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", s.ProviderSpecificDetails)
	populate(objectMap, "replicationProtectedItemName", s.ReplicationProtectedItemName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionInputProperties.
func (s *SwitchProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			s.ProviderSpecificDetails, err = unmarshalSwitchProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "replicationProtectedItemName":
			err = unpopulate(val, "ReplicationProtectedItemName", &s.ReplicationProtectedItemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProtectionJobDetails.
func (s SwitchProtectionJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", s.AffectedObjectDetails)
	objectMap["instanceType"] = "SwitchProtectionJobDetails"
	populate(objectMap, "newReplicationProtectedItemId", s.NewReplicationProtectedItemID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionJobDetails.
func (s *SwitchProtectionJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &s.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		case "newReplicationProtectedItemId":
			err = unpopulate(val, "NewReplicationProtectedItemID", &s.NewReplicationProtectedItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProtectionProviderSpecificInput.
func (s SwitchProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = s.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionProviderSpecificInput.
func (s *SwitchProtectionProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProviderInput.
func (s SwitchProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProviderInput.
func (s *SwitchProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProviderInputProperties.
func (s SwitchProviderInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", s.ProviderSpecificDetails)
	populate(objectMap, "targetInstanceType", s.TargetInstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProviderInputProperties.
func (s *SwitchProviderInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			s.ProviderSpecificDetails, err = unmarshalSwitchProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "targetInstanceType":
			err = unpopulate(val, "TargetInstanceType", &s.TargetInstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProviderSpecificInput.
func (s SwitchProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = s.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProviderSpecificInput.
func (s *SwitchProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetComputeSize.
func (t TargetComputeSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetComputeSize.
func (t *TargetComputeSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetComputeSizeCollection.
func (t TargetComputeSizeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetComputeSizeCollection.
func (t *TargetComputeSizeCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetComputeSizeProperties.
func (t TargetComputeSizeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCoresCount", t.CPUCoresCount)
	populate(objectMap, "errors", t.Errors)
	populate(objectMap, "friendlyName", t.FriendlyName)
	populate(objectMap, "highIopsSupported", t.HighIopsSupported)
	populate(objectMap, "hyperVGenerations", t.HyperVGenerations)
	populate(objectMap, "maxDataDiskCount", t.MaxDataDiskCount)
	populate(objectMap, "maxNicsCount", t.MaxNicsCount)
	populate(objectMap, "memoryInGB", t.MemoryInGB)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "vCPUsAvailable", t.VCPUsAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetComputeSizeProperties.
func (t *TargetComputeSizeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCoresCount":
			err = unpopulate(val, "CPUCoresCount", &t.CPUCoresCount)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &t.Errors)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &t.FriendlyName)
			delete(rawMsg, key)
		case "highIopsSupported":
			err = unpopulate(val, "HighIopsSupported", &t.HighIopsSupported)
			delete(rawMsg, key)
		case "hyperVGenerations":
			err = unpopulate(val, "HyperVGenerations", &t.HyperVGenerations)
			delete(rawMsg, key)
		case "maxDataDiskCount":
			err = unpopulate(val, "MaxDataDiskCount", &t.MaxDataDiskCount)
			delete(rawMsg, key)
		case "maxNicsCount":
			err = unpopulate(val, "MaxNicsCount", &t.MaxNicsCount)
			delete(rawMsg, key)
		case "memoryInGB":
			err = unpopulate(val, "MemoryInGB", &t.MemoryInGB)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "vCPUsAvailable":
			err = unpopulate(val, "VCPUsAvailable", &t.VCPUsAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskTypeDetails.
func (t TaskTypeDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = t.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskTypeDetails.
func (t *TaskTypeDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverCleanupInput.
func (t TestFailoverCleanupInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverCleanupInput.
func (t *TestFailoverCleanupInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverCleanupInputProperties.
func (t TestFailoverCleanupInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "comments", t.Comments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverCleanupInputProperties.
func (t *TestFailoverCleanupInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "comments":
			err = unpopulate(val, "Comments", &t.Comments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverInput.
func (t TestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverInput.
func (t *TestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverInputProperties.
func (t TestFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", t.FailoverDirection)
	populate(objectMap, "networkId", t.NetworkID)
	populate(objectMap, "networkType", t.NetworkType)
	populate(objectMap, "providerSpecificDetails", t.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverInputProperties.
func (t *TestFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &t.FailoverDirection)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &t.NetworkID)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &t.NetworkType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			t.ProviderSpecificDetails, err = unmarshalTestFailoverProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverJobDetails.
func (t TestFailoverJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", t.AffectedObjectDetails)
	populate(objectMap, "comments", t.Comments)
	objectMap["instanceType"] = "TestFailoverJobDetails"
	populate(objectMap, "networkFriendlyName", t.NetworkFriendlyName)
	populate(objectMap, "networkName", t.NetworkName)
	populate(objectMap, "networkType", t.NetworkType)
	populate(objectMap, "protectedItemDetails", t.ProtectedItemDetails)
	populate(objectMap, "testFailoverStatus", t.TestFailoverStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverJobDetails.
func (t *TestFailoverJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &t.AffectedObjectDetails)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &t.Comments)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		case "networkFriendlyName":
			err = unpopulate(val, "NetworkFriendlyName", &t.NetworkFriendlyName)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &t.NetworkName)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &t.NetworkType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &t.ProtectedItemDetails)
			delete(rawMsg, key)
		case "testFailoverStatus":
			err = unpopulate(val, "TestFailoverStatus", &t.TestFailoverStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverProviderSpecificInput.
func (t TestFailoverProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = t.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverProviderSpecificInput.
func (t *TestFailoverProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateCleanupInput.
func (t TestMigrateCleanupInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateCleanupInput.
func (t *TestMigrateCleanupInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateCleanupInputProperties.
func (t TestMigrateCleanupInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "comments", t.Comments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateCleanupInputProperties.
func (t *TestMigrateCleanupInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "comments":
			err = unpopulate(val, "Comments", &t.Comments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateInput.
func (t TestMigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateInput.
func (t *TestMigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateInputProperties.
func (t TestMigrateInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", t.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateInputProperties.
func (t *TestMigrateInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			t.ProviderSpecificDetails, err = unmarshalTestMigrateProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateProviderSpecificInput.
func (t TestMigrateProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = t.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateProviderSpecificInput.
func (t *TestMigrateProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnplannedFailoverInput.
func (u UnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnplannedFailoverInput.
func (u *UnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnplannedFailoverInputProperties.
func (u UnplannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverDirection", u.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "sourceSiteOperations", u.SourceSiteOperations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnplannedFailoverInputProperties.
func (u *UnplannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &u.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUnplannedFailoverProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "sourceSiteOperations":
			err = unpopulate(val, "SourceSiteOperations", &u.SourceSiteOperations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnplannedFailoverProviderSpecificInput.
func (u UnplannedFailoverProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = u.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnplannedFailoverProviderSpecificInput.
func (u *UnplannedFailoverProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &u.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateApplianceForReplicationProtectedItemInput.
func (u UpdateApplianceForReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateApplianceForReplicationProtectedItemInput.
func (u *UpdateApplianceForReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateApplianceForReplicationProtectedItemInputProperties.
func (u UpdateApplianceForReplicationProtectedItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "targetApplianceId", u.TargetApplianceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateApplianceForReplicationProtectedItemInputProperties.
func (u *UpdateApplianceForReplicationProtectedItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "targetApplianceId":
			err = unpopulate(val, "TargetApplianceID", &u.TargetApplianceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateApplianceForReplicationProtectedItemProviderSpecificInput.
func (u UpdateApplianceForReplicationProtectedItemProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = u.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateApplianceForReplicationProtectedItemProviderSpecificInput.
func (u *UpdateApplianceForReplicationProtectedItemProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &u.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDiskInput.
func (u UpdateDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskId", u.DiskID)
	populate(objectMap, "targetDiskName", u.TargetDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateDiskInput.
func (u *UpdateDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskId":
			err = unpopulate(val, "DiskID", &u.DiskID)
			delete(rawMsg, key)
		case "targetDiskName":
			err = unpopulate(val, "TargetDiskName", &u.TargetDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMigrationItemInput.
func (u UpdateMigrationItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMigrationItemInput.
func (u *UpdateMigrationItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMigrationItemInputProperties.
func (u UpdateMigrationItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMigrationItemInputProperties.
func (u *UpdateMigrationItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateMigrationItemProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMigrationItemProviderSpecificInput.
func (u UpdateMigrationItemProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = u.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMigrationItemProviderSpecificInput.
func (u *UpdateMigrationItemProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &u.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMobilityServiceRequest.
func (u UpdateMobilityServiceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMobilityServiceRequest.
func (u *UpdateMobilityServiceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMobilityServiceRequestProperties.
func (u UpdateMobilityServiceRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runAsAccountId", u.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMobilityServiceRequestProperties.
func (u *UpdateMobilityServiceRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &u.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateNetworkMappingInput.
func (u UpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateNetworkMappingInput.
func (u *UpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateNetworkMappingInputProperties.
func (u UpdateNetworkMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricSpecificDetails", u.FabricSpecificDetails)
	populate(objectMap, "recoveryFabricName", u.RecoveryFabricName)
	populate(objectMap, "recoveryNetworkId", u.RecoveryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateNetworkMappingInputProperties.
func (u *UpdateNetworkMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificDetails":
			u.FabricSpecificDetails, err = unmarshalFabricSpecificUpdateNetworkMappingInputClassification(val)
			delete(rawMsg, key)
		case "recoveryFabricName":
			err = unpopulate(val, "RecoveryFabricName", &u.RecoveryFabricName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &u.RecoveryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdatePolicyInput.
func (u UpdatePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatePolicyInput.
func (u *UpdatePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdatePolicyInputProperties.
func (u UpdatePolicyInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "replicationProviderSettings", u.ReplicationProviderSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatePolicyInputProperties.
func (u *UpdatePolicyInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replicationProviderSettings":
			u.ReplicationProviderSettings, err = unmarshalPolicyProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateProtectionContainerMappingInput.
func (u UpdateProtectionContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateProtectionContainerMappingInput.
func (u *UpdateProtectionContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateProtectionContainerMappingInputProperties.
func (u UpdateProtectionContainerMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerSpecificInput", u.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateProtectionContainerMappingInputProperties.
func (u *UpdateProtectionContainerMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			u.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificUpdateContainerMappingInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateRecoveryPlanInput.
func (u UpdateRecoveryPlanInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateRecoveryPlanInput.
func (u *UpdateRecoveryPlanInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateRecoveryPlanInputProperties.
func (u UpdateRecoveryPlanInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groups", u.Groups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateRecoveryPlanInputProperties.
func (u *UpdateRecoveryPlanInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groups":
			err = unpopulate(val, "Groups", &u.Groups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateReplicationProtectedItemInput.
func (u UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateReplicationProtectedItemInput.
func (u *UpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateReplicationProtectedItemInputProperties.
func (u UpdateReplicationProtectedItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableRdpOnTargetOption", u.EnableRdpOnTargetOption)
	populate(objectMap, "licenseType", u.LicenseType)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "recoveryAvailabilitySetId", u.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAzureVMName", u.RecoveryAzureVMName)
	populate(objectMap, "recoveryAzureVMSize", u.RecoveryAzureVMSize)
	populate(objectMap, "selectedRecoveryAzureNetworkId", u.SelectedRecoveryAzureNetworkID)
	populate(objectMap, "selectedSourceNicId", u.SelectedSourceNicID)
	populate(objectMap, "selectedTfoAzureNetworkId", u.SelectedTfoAzureNetworkID)
	populate(objectMap, "vmNics", u.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateReplicationProtectedItemInputProperties.
func (u *UpdateReplicationProtectedItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &u.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &u.LicenseType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateReplicationProtectedItemProviderInputClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &u.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &u.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &u.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &u.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &u.SelectedSourceNicID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &u.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &u.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateReplicationProtectedItemProviderInput.
func (u UpdateReplicationProtectedItemProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = u.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateReplicationProtectedItemProviderInput.
func (u *UpdateReplicationProtectedItemProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &u.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateVCenterRequest.
func (u UpdateVCenterRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateVCenterRequest.
func (u *UpdateVCenterRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateVCenterRequestProperties.
func (u UpdateVCenterRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", u.FriendlyName)
	populate(objectMap, "ipAddress", u.IPAddress)
	populate(objectMap, "port", u.Port)
	populate(objectMap, "processServerId", u.ProcessServerID)
	populate(objectMap, "runAsAccountId", u.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateVCenterRequestProperties.
func (u *UpdateVCenterRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &u.FriendlyName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &u.IPAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &u.Port)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &u.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &u.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCenter.
func (v VCenter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenter.
func (v *VCenter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCenterCollection.
func (v VCenterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenterCollection.
func (v *VCenterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCenterProperties.
func (v VCenterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "discoveryStatus", v.DiscoveryStatus)
	populate(objectMap, "fabricArmResourceName", v.FabricArmResourceName)
	populate(objectMap, "friendlyName", v.FriendlyName)
	populate(objectMap, "healthErrors", v.HealthErrors)
	populate(objectMap, "ipAddress", v.IPAddress)
	populate(objectMap, "infrastructureId", v.InfrastructureID)
	populate(objectMap, "internalId", v.InternalID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", v.LastHeartbeat)
	populate(objectMap, "port", v.Port)
	populate(objectMap, "processServerId", v.ProcessServerID)
	populate(objectMap, "runAsAccountId", v.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenterProperties.
func (v *VCenterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "discoveryStatus":
			err = unpopulate(val, "DiscoveryStatus", &v.DiscoveryStatus)
			delete(rawMsg, key)
		case "fabricArmResourceName":
			err = unpopulate(val, "FabricArmResourceName", &v.FabricArmResourceName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &v.FriendlyName)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &v.HealthErrors)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "infrastructureId":
			err = unpopulate(val, "InfrastructureID", &v.InfrastructureID)
			delete(rawMsg, key)
		case "internalId":
			err = unpopulate(val, "InternalID", &v.InternalID)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &v.LastHeartbeat)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &v.Port)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &v.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &v.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMNicDetails.
func (v VMNicDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableAcceleratedNetworkingOnRecovery", v.EnableAcceleratedNetworkingOnRecovery)
	populate(objectMap, "enableAcceleratedNetworkingOnTfo", v.EnableAcceleratedNetworkingOnTfo)
	populate(objectMap, "ipConfigs", v.IPConfigs)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "recoveryNetworkSecurityGroupId", v.RecoveryNetworkSecurityGroupID)
	populate(objectMap, "recoveryNicName", v.RecoveryNicName)
	populate(objectMap, "recoveryNicResourceGroupName", v.RecoveryNicResourceGroupName)
	populate(objectMap, "recoveryVMNetworkId", v.RecoveryVMNetworkID)
	populate(objectMap, "replicaNicId", v.ReplicaNicID)
	populate(objectMap, "reuseExistingNic", v.ReuseExistingNic)
	populate(objectMap, "selectionType", v.SelectionType)
	populate(objectMap, "sourceNicArmId", v.SourceNicArmID)
	populate(objectMap, "targetNicName", v.TargetNicName)
	populate(objectMap, "tfoNetworkSecurityGroupId", v.TfoNetworkSecurityGroupID)
	populate(objectMap, "tfoRecoveryNicName", v.TfoRecoveryNicName)
	populate(objectMap, "tfoRecoveryNicResourceGroupName", v.TfoRecoveryNicResourceGroupName)
	populate(objectMap, "tfoReuseExistingNic", v.TfoReuseExistingNic)
	populate(objectMap, "tfoVMNetworkId", v.TfoVMNetworkID)
	populate(objectMap, "vMNetworkName", v.VMNetworkName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMNicDetails.
func (v *VMNicDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAcceleratedNetworkingOnRecovery":
			err = unpopulate(val, "EnableAcceleratedNetworkingOnRecovery", &v.EnableAcceleratedNetworkingOnRecovery)
			delete(rawMsg, key)
		case "enableAcceleratedNetworkingOnTfo":
			err = unpopulate(val, "EnableAcceleratedNetworkingOnTfo", &v.EnableAcceleratedNetworkingOnTfo)
			delete(rawMsg, key)
		case "ipConfigs":
			err = unpopulate(val, "IPConfigs", &v.IPConfigs)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "recoveryNetworkSecurityGroupId":
			err = unpopulate(val, "RecoveryNetworkSecurityGroupID", &v.RecoveryNetworkSecurityGroupID)
			delete(rawMsg, key)
		case "recoveryNicName":
			err = unpopulate(val, "RecoveryNicName", &v.RecoveryNicName)
			delete(rawMsg, key)
		case "recoveryNicResourceGroupName":
			err = unpopulate(val, "RecoveryNicResourceGroupName", &v.RecoveryNicResourceGroupName)
			delete(rawMsg, key)
		case "recoveryVMNetworkId":
			err = unpopulate(val, "RecoveryVMNetworkID", &v.RecoveryVMNetworkID)
			delete(rawMsg, key)
		case "replicaNicId":
			err = unpopulate(val, "ReplicaNicID", &v.ReplicaNicID)
			delete(rawMsg, key)
		case "reuseExistingNic":
			err = unpopulate(val, "ReuseExistingNic", &v.ReuseExistingNic)
			delete(rawMsg, key)
		case "selectionType":
			err = unpopulate(val, "SelectionType", &v.SelectionType)
			delete(rawMsg, key)
		case "sourceNicArmId":
			err = unpopulate(val, "SourceNicArmID", &v.SourceNicArmID)
			delete(rawMsg, key)
		case "targetNicName":
			err = unpopulate(val, "TargetNicName", &v.TargetNicName)
			delete(rawMsg, key)
		case "tfoNetworkSecurityGroupId":
			err = unpopulate(val, "TfoNetworkSecurityGroupID", &v.TfoNetworkSecurityGroupID)
			delete(rawMsg, key)
		case "tfoRecoveryNicName":
			err = unpopulate(val, "TfoRecoveryNicName", &v.TfoRecoveryNicName)
			delete(rawMsg, key)
		case "tfoRecoveryNicResourceGroupName":
			err = unpopulate(val, "TfoRecoveryNicResourceGroupName", &v.TfoRecoveryNicResourceGroupName)
			delete(rawMsg, key)
		case "tfoReuseExistingNic":
			err = unpopulate(val, "TfoReuseExistingNic", &v.TfoReuseExistingNic)
			delete(rawMsg, key)
		case "tfoVMNetworkId":
			err = unpopulate(val, "TfoVMNetworkID", &v.TfoVMNetworkID)
			delete(rawMsg, key)
		case "vMNetworkName":
			err = unpopulate(val, "VMNetworkName", &v.VMNetworkName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMNicInputDetails.
func (v VMNicInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableAcceleratedNetworkingOnRecovery", v.EnableAcceleratedNetworkingOnRecovery)
	populate(objectMap, "enableAcceleratedNetworkingOnTfo", v.EnableAcceleratedNetworkingOnTfo)
	populate(objectMap, "ipConfigs", v.IPConfigs)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "recoveryNetworkSecurityGroupId", v.RecoveryNetworkSecurityGroupID)
	populate(objectMap, "recoveryNicName", v.RecoveryNicName)
	populate(objectMap, "recoveryNicResourceGroupName", v.RecoveryNicResourceGroupName)
	populate(objectMap, "reuseExistingNic", v.ReuseExistingNic)
	populate(objectMap, "selectionType", v.SelectionType)
	populate(objectMap, "targetNicName", v.TargetNicName)
	populate(objectMap, "tfoNetworkSecurityGroupId", v.TfoNetworkSecurityGroupID)
	populate(objectMap, "tfoNicName", v.TfoNicName)
	populate(objectMap, "tfoNicResourceGroupName", v.TfoNicResourceGroupName)
	populate(objectMap, "tfoReuseExistingNic", v.TfoReuseExistingNic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMNicInputDetails.
func (v *VMNicInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAcceleratedNetworkingOnRecovery":
			err = unpopulate(val, "EnableAcceleratedNetworkingOnRecovery", &v.EnableAcceleratedNetworkingOnRecovery)
			delete(rawMsg, key)
		case "enableAcceleratedNetworkingOnTfo":
			err = unpopulate(val, "EnableAcceleratedNetworkingOnTfo", &v.EnableAcceleratedNetworkingOnTfo)
			delete(rawMsg, key)
		case "ipConfigs":
			err = unpopulate(val, "IPConfigs", &v.IPConfigs)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "recoveryNetworkSecurityGroupId":
			err = unpopulate(val, "RecoveryNetworkSecurityGroupID", &v.RecoveryNetworkSecurityGroupID)
			delete(rawMsg, key)
		case "recoveryNicName":
			err = unpopulate(val, "RecoveryNicName", &v.RecoveryNicName)
			delete(rawMsg, key)
		case "recoveryNicResourceGroupName":
			err = unpopulate(val, "RecoveryNicResourceGroupName", &v.RecoveryNicResourceGroupName)
			delete(rawMsg, key)
		case "reuseExistingNic":
			err = unpopulate(val, "ReuseExistingNic", &v.ReuseExistingNic)
			delete(rawMsg, key)
		case "selectionType":
			err = unpopulate(val, "SelectionType", &v.SelectionType)
			delete(rawMsg, key)
		case "targetNicName":
			err = unpopulate(val, "TargetNicName", &v.TargetNicName)
			delete(rawMsg, key)
		case "tfoNetworkSecurityGroupId":
			err = unpopulate(val, "TfoNetworkSecurityGroupID", &v.TfoNetworkSecurityGroupID)
			delete(rawMsg, key)
		case "tfoNicName":
			err = unpopulate(val, "TfoNicName", &v.TfoNicName)
			delete(rawMsg, key)
		case "tfoNicResourceGroupName":
			err = unpopulate(val, "TfoNicResourceGroupName", &v.TfoNicResourceGroupName)
			delete(rawMsg, key)
		case "tfoReuseExistingNic":
			err = unpopulate(val, "TfoReuseExistingNic", &v.TfoReuseExistingNic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMNicUpdatesTaskDetails.
func (v VMNicUpdatesTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmNicUpdatesTaskDetails"
	populate(objectMap, "name", v.Name)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "vmId", v.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMNicUpdatesTaskDetails.
func (v *VMNicUpdatesTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtContainerCreationInput.
func (v VMwareCbtContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtContainerCreationInput.
func (v *VMwareCbtContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtContainerMappingInput.
func (v VMwareCbtContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "keyVaultId", v.KeyVaultID)
	populate(objectMap, "keyVaultUri", v.KeyVaultURI)
	populate(objectMap, "serviceBusConnectionStringSecretName", v.ServiceBusConnectionStringSecretName)
	populate(objectMap, "storageAccountId", v.StorageAccountID)
	populate(objectMap, "storageAccountSasSecretName", v.StorageAccountSasSecretName)
	populate(objectMap, "targetLocation", v.TargetLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtContainerMappingInput.
func (v *VMwareCbtContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &v.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &v.KeyVaultURI)
			delete(rawMsg, key)
		case "serviceBusConnectionStringSecretName":
			err = unpopulate(val, "ServiceBusConnectionStringSecretName", &v.ServiceBusConnectionStringSecretName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &v.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtDiskInput.
func (v VMwareCbtDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskEncryptionSetId", v.DiskEncryptionSetID)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "diskType", v.DiskType)
	populate(objectMap, "isOSDisk", v.IsOSDisk)
	populate(objectMap, "logStorageAccountId", v.LogStorageAccountID)
	populate(objectMap, "logStorageAccountSasSecretName", v.LogStorageAccountSasSecretName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtDiskInput.
func (v *VMwareCbtDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &v.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &v.DiskType)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &v.IsOSDisk)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &v.LogStorageAccountID)
			delete(rawMsg, key)
		case "logStorageAccountSasSecretName":
			err = unpopulate(val, "LogStorageAccountSasSecretName", &v.LogStorageAccountSasSecretName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtEnableMigrationInput.
func (v VMwareCbtEnableMigrationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "confidentialVmKeyVaultId", v.ConfidentialVMKeyVaultID)
	populate(objectMap, "dataMoverRunAsAccountId", v.DataMoverRunAsAccountID)
	populate(objectMap, "disksToInclude", v.DisksToInclude)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "performSqlBulkRegistration", v.PerformSQLBulkRegistration)
	populate(objectMap, "sqlServerLicenseType", v.SQLServerLicenseType)
	populate(objectMap, "seedDiskTags", v.SeedDiskTags)
	populate(objectMap, "snapshotRunAsAccountId", v.SnapshotRunAsAccountID)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", v.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetDiskTags", v.TargetDiskTags)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetNicTags", v.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", v.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetSubnetName", v.TargetSubnetName)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "targetVmSecurityProfile", v.TargetVMSecurityProfile)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "targetVmTags", v.TargetVMTags)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "testSubnetName", v.TestSubnetName)
	populate(objectMap, "vmwareMachineId", v.VmwareMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtEnableMigrationInput.
func (v *VMwareCbtEnableMigrationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confidentialVmKeyVaultId":
			err = unpopulate(val, "ConfidentialVMKeyVaultID", &v.ConfidentialVMKeyVaultID)
			delete(rawMsg, key)
		case "dataMoverRunAsAccountId":
			err = unpopulate(val, "DataMoverRunAsAccountID", &v.DataMoverRunAsAccountID)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &v.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "performSqlBulkRegistration":
			err = unpopulate(val, "PerformSQLBulkRegistration", &v.PerformSQLBulkRegistration)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedDiskTags":
			err = unpopulate(val, "SeedDiskTags", &v.SeedDiskTags)
			delete(rawMsg, key)
		case "snapshotRunAsAccountId":
			err = unpopulate(val, "SnapshotRunAsAccountID", &v.SnapshotRunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &v.TargetSubnetName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSecurityProfile":
			err = unpopulate(val, "TargetVMSecurityProfile", &v.TargetVMSecurityProfile)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &v.TestSubnetName)
			delete(rawMsg, key)
		case "vmwareMachineId":
			err = unpopulate(val, "VmwareMachineID", &v.VmwareMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtEventDetails.
func (v VMwareCbtEventDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "migrationItemName", v.MigrationItemName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtEventDetails.
func (v *VMwareCbtEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationItemName":
			err = unpopulate(val, "MigrationItemName", &v.MigrationItemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtMigrateInput.
func (v VMwareCbtMigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "osUpgradeVersion", v.OSUpgradeVersion)
	populate(objectMap, "performShutdown", v.PerformShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtMigrateInput.
func (v *VMwareCbtMigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &v.OSUpgradeVersion)
			delete(rawMsg, key)
		case "performShutdown":
			err = unpopulate(val, "PerformShutdown", &v.PerformShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtMigrationDetails.
func (v VMwareCbtMigrationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applianceMonitoringDetails", v.ApplianceMonitoringDetails)
	populate(objectMap, "confidentialVmKeyVaultId", v.ConfidentialVMKeyVaultID)
	populate(objectMap, "dataMoverRunAsAccountId", v.DataMoverRunAsAccountID)
	populate(objectMap, "deltaSyncProgressPercentage", v.DeltaSyncProgressPercentage)
	populate(objectMap, "deltaSyncRetryCount", v.DeltaSyncRetryCount)
	populate(objectMap, "firmwareType", v.FirmwareType)
	populate(objectMap, "gatewayOperationDetails", v.GatewayOperationDetails)
	populate(objectMap, "initialSeedingProgressPercentage", v.InitialSeedingProgressPercentage)
	populate(objectMap, "initialSeedingRetryCount", v.InitialSeedingRetryCount)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "isCheckSumResyncCycle", v.IsCheckSumResyncCycle)
	populate(objectMap, "lastRecoveryPointId", v.LastRecoveryPointID)
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", v.LastRecoveryPointReceived)
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "migrationProgressPercentage", v.MigrationProgressPercentage)
	populate(objectMap, "migrationRecoveryPointId", v.MigrationRecoveryPointID)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "operationName", v.OperationName)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "protectedDisks", v.ProtectedDisks)
	populate(objectMap, "resumeProgressPercentage", v.ResumeProgressPercentage)
	populate(objectMap, "resumeRetryCount", v.ResumeRetryCount)
	populate(objectMap, "resyncProgressPercentage", v.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", v.ResyncRequired)
	populate(objectMap, "resyncRetryCount", v.ResyncRetryCount)
	populate(objectMap, "resyncState", v.ResyncState)
	populate(objectMap, "sqlServerLicenseType", v.SQLServerLicenseType)
	populate(objectMap, "seedDiskTags", v.SeedDiskTags)
	populate(objectMap, "snapshotRunAsAccountId", v.SnapshotRunAsAccountID)
	populate(objectMap, "storageAccountId", v.StorageAccountID)
	populate(objectMap, "supportedOSVersions", v.SupportedOSVersions)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", v.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetDiskTags", v.TargetDiskTags)
	populate(objectMap, "targetGeneration", v.TargetGeneration)
	populate(objectMap, "targetLocation", v.TargetLocation)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetNicTags", v.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", v.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "targetVmSecurityProfile", v.TargetVMSecurityProfile)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "targetVmTags", v.TargetVMTags)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "vmNics", v.VMNics)
	populate(objectMap, "vmwareMachineId", v.VmwareMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtMigrationDetails.
func (v *VMwareCbtMigrationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceMonitoringDetails":
			err = unpopulate(val, "ApplianceMonitoringDetails", &v.ApplianceMonitoringDetails)
			delete(rawMsg, key)
		case "confidentialVmKeyVaultId":
			err = unpopulate(val, "ConfidentialVMKeyVaultID", &v.ConfidentialVMKeyVaultID)
			delete(rawMsg, key)
		case "dataMoverRunAsAccountId":
			err = unpopulate(val, "DataMoverRunAsAccountID", &v.DataMoverRunAsAccountID)
			delete(rawMsg, key)
		case "deltaSyncProgressPercentage":
			err = unpopulate(val, "DeltaSyncProgressPercentage", &v.DeltaSyncProgressPercentage)
			delete(rawMsg, key)
		case "deltaSyncRetryCount":
			err = unpopulate(val, "DeltaSyncRetryCount", &v.DeltaSyncRetryCount)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &v.FirmwareType)
			delete(rawMsg, key)
		case "gatewayOperationDetails":
			err = unpopulate(val, "GatewayOperationDetails", &v.GatewayOperationDetails)
			delete(rawMsg, key)
		case "initialSeedingProgressPercentage":
			err = unpopulate(val, "InitialSeedingProgressPercentage", &v.InitialSeedingProgressPercentage)
			delete(rawMsg, key)
		case "initialSeedingRetryCount":
			err = unpopulate(val, "InitialSeedingRetryCount", &v.InitialSeedingRetryCount)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "isCheckSumResyncCycle":
			err = unpopulate(val, "IsCheckSumResyncCycle", &v.IsCheckSumResyncCycle)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &v.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &v.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "migrationProgressPercentage":
			err = unpopulate(val, "MigrationProgressPercentage", &v.MigrationProgressPercentage)
			delete(rawMsg, key)
		case "migrationRecoveryPointId":
			err = unpopulate(val, "MigrationRecoveryPointID", &v.MigrationRecoveryPointID)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &v.OperationName)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &v.ProtectedDisks)
			delete(rawMsg, key)
		case "resumeProgressPercentage":
			err = unpopulate(val, "ResumeProgressPercentage", &v.ResumeProgressPercentage)
			delete(rawMsg, key)
		case "resumeRetryCount":
			err = unpopulate(val, "ResumeRetryCount", &v.ResumeRetryCount)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &v.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &v.ResyncRequired)
			delete(rawMsg, key)
		case "resyncRetryCount":
			err = unpopulate(val, "ResyncRetryCount", &v.ResyncRetryCount)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &v.ResyncState)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedDiskTags":
			err = unpopulate(val, "SeedDiskTags", &v.SeedDiskTags)
			delete(rawMsg, key)
		case "snapshotRunAsAccountId":
			err = unpopulate(val, "SnapshotRunAsAccountID", &v.SnapshotRunAsAccountID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "supportedOSVersions":
			err = unpopulate(val, "SupportedOSVersions", &v.SupportedOSVersions)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetGeneration":
			err = unpopulate(val, "TargetGeneration", &v.TargetGeneration)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSecurityProfile":
			err = unpopulate(val, "TargetVMSecurityProfile", &v.TargetVMSecurityProfile)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		case "vmwareMachineId":
			err = unpopulate(val, "VmwareMachineID", &v.VmwareMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtNicDetails.
func (v VMwareCbtNicDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPrimaryNic", v.IsPrimaryNic)
	populate(objectMap, "isSelectedForMigration", v.IsSelectedForMigration)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "sourceIPAddress", v.SourceIPAddress)
	populate(objectMap, "sourceIPAddressType", v.SourceIPAddressType)
	populate(objectMap, "sourceNetworkId", v.SourceNetworkID)
	populate(objectMap, "targetIPAddress", v.TargetIPAddress)
	populate(objectMap, "targetIPAddressType", v.TargetIPAddressType)
	populate(objectMap, "targetNicName", v.TargetNicName)
	populate(objectMap, "targetSubnetName", v.TargetSubnetName)
	populate(objectMap, "testIPAddress", v.TestIPAddress)
	populate(objectMap, "testIPAddressType", v.TestIPAddressType)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "testSubnetName", v.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtNicDetails.
func (v *VMwareCbtNicDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPrimaryNic":
			err = unpopulate(val, "IsPrimaryNic", &v.IsPrimaryNic)
			delete(rawMsg, key)
		case "isSelectedForMigration":
			err = unpopulate(val, "IsSelectedForMigration", &v.IsSelectedForMigration)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "sourceIPAddress":
			err = unpopulate(val, "SourceIPAddress", &v.SourceIPAddress)
			delete(rawMsg, key)
		case "sourceIPAddressType":
			err = unpopulate(val, "SourceIPAddressType", &v.SourceIPAddressType)
			delete(rawMsg, key)
		case "sourceNetworkId":
			err = unpopulate(val, "SourceNetworkID", &v.SourceNetworkID)
			delete(rawMsg, key)
		case "targetIPAddress":
			err = unpopulate(val, "TargetIPAddress", &v.TargetIPAddress)
			delete(rawMsg, key)
		case "targetIPAddressType":
			err = unpopulate(val, "TargetIPAddressType", &v.TargetIPAddressType)
			delete(rawMsg, key)
		case "targetNicName":
			err = unpopulate(val, "TargetNicName", &v.TargetNicName)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &v.TargetSubnetName)
			delete(rawMsg, key)
		case "testIPAddress":
			err = unpopulate(val, "TestIPAddress", &v.TestIPAddress)
			delete(rawMsg, key)
		case "testIPAddressType":
			err = unpopulate(val, "TestIPAddressType", &v.TestIPAddressType)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &v.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtNicInput.
func (v VMwareCbtNicInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPrimaryNic", v.IsPrimaryNic)
	populate(objectMap, "isSelectedForMigration", v.IsSelectedForMigration)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "targetNicName", v.TargetNicName)
	populate(objectMap, "targetStaticIPAddress", v.TargetStaticIPAddress)
	populate(objectMap, "targetSubnetName", v.TargetSubnetName)
	populate(objectMap, "testStaticIPAddress", v.TestStaticIPAddress)
	populate(objectMap, "testSubnetName", v.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtNicInput.
func (v *VMwareCbtNicInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPrimaryNic":
			err = unpopulate(val, "IsPrimaryNic", &v.IsPrimaryNic)
			delete(rawMsg, key)
		case "isSelectedForMigration":
			err = unpopulate(val, "IsSelectedForMigration", &v.IsSelectedForMigration)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "targetNicName":
			err = unpopulate(val, "TargetNicName", &v.TargetNicName)
			delete(rawMsg, key)
		case "targetStaticIPAddress":
			err = unpopulate(val, "TargetStaticIPAddress", &v.TargetStaticIPAddress)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &v.TargetSubnetName)
			delete(rawMsg, key)
		case "testStaticIPAddress":
			err = unpopulate(val, "TestStaticIPAddress", &v.TestStaticIPAddress)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &v.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtPolicyCreationInput.
func (v VMwareCbtPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", v.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", v.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "recoveryPointHistoryInMinutes", v.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtPolicyCreationInput.
func (v *VMwareCbtPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &v.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &v.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &v.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtProtectedDiskDetails.
func (v VMwareCbtProtectedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", v.CapacityInBytes)
	populate(objectMap, "diskEncryptionSetId", v.DiskEncryptionSetID)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "diskName", v.DiskName)
	populate(objectMap, "diskPath", v.DiskPath)
	populate(objectMap, "diskType", v.DiskType)
	populate(objectMap, "gatewayOperationDetails", v.GatewayOperationDetails)
	populate(objectMap, "isOSDisk", v.IsOSDisk)
	populate(objectMap, "logStorageAccountId", v.LogStorageAccountID)
	populate(objectMap, "logStorageAccountSasSecretName", v.LogStorageAccountSasSecretName)
	populate(objectMap, "seedBlobUri", v.SeedBlobURI)
	populate(objectMap, "seedManagedDiskId", v.SeedManagedDiskID)
	populate(objectMap, "targetBlobUri", v.TargetBlobURI)
	populate(objectMap, "targetDiskName", v.TargetDiskName)
	populate(objectMap, "targetManagedDiskId", v.TargetManagedDiskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtProtectedDiskDetails.
func (v *VMwareCbtProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &v.CapacityInBytes)
			delete(rawMsg, key)
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &v.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &v.DiskName)
			delete(rawMsg, key)
		case "diskPath":
			err = unpopulate(val, "DiskPath", &v.DiskPath)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &v.DiskType)
			delete(rawMsg, key)
		case "gatewayOperationDetails":
			err = unpopulate(val, "GatewayOperationDetails", &v.GatewayOperationDetails)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &v.IsOSDisk)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &v.LogStorageAccountID)
			delete(rawMsg, key)
		case "logStorageAccountSasSecretName":
			err = unpopulate(val, "LogStorageAccountSasSecretName", &v.LogStorageAccountSasSecretName)
			delete(rawMsg, key)
		case "seedBlobUri":
			err = unpopulate(val, "SeedBlobURI", &v.SeedBlobURI)
			delete(rawMsg, key)
		case "seedManagedDiskId":
			err = unpopulate(val, "SeedManagedDiskID", &v.SeedManagedDiskID)
			delete(rawMsg, key)
		case "targetBlobUri":
			err = unpopulate(val, "TargetBlobURI", &v.TargetBlobURI)
			delete(rawMsg, key)
		case "targetDiskName":
			err = unpopulate(val, "TargetDiskName", &v.TargetDiskName)
			delete(rawMsg, key)
		case "targetManagedDiskId":
			err = unpopulate(val, "TargetManagedDiskID", &v.TargetManagedDiskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtProtectionContainerMappingDetails.
func (v VMwareCbtProtectionContainerMappingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludedSkus", v.ExcludedSKUs)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "keyVaultId", v.KeyVaultID)
	populate(objectMap, "keyVaultUri", v.KeyVaultURI)
	populate(objectMap, "roleSizeToNicCountMap", v.RoleSizeToNicCountMap)
	populate(objectMap, "serviceBusConnectionStringSecretName", v.ServiceBusConnectionStringSecretName)
	populate(objectMap, "storageAccountId", v.StorageAccountID)
	populate(objectMap, "storageAccountSasSecretName", v.StorageAccountSasSecretName)
	populate(objectMap, "targetLocation", v.TargetLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtProtectionContainerMappingDetails.
func (v *VMwareCbtProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedSkus":
			err = unpopulate(val, "ExcludedSKUs", &v.ExcludedSKUs)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &v.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &v.KeyVaultURI)
			delete(rawMsg, key)
		case "roleSizeToNicCountMap":
			err = unpopulate(val, "RoleSizeToNicCountMap", &v.RoleSizeToNicCountMap)
			delete(rawMsg, key)
		case "serviceBusConnectionStringSecretName":
			err = unpopulate(val, "ServiceBusConnectionStringSecretName", &v.ServiceBusConnectionStringSecretName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &v.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtResumeReplicationInput.
func (v VMwareCbtResumeReplicationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleteMigrationResources", v.DeleteMigrationResources)
	objectMap["instanceType"] = "VMwareCbt"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtResumeReplicationInput.
func (v *VMwareCbtResumeReplicationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteMigrationResources":
			err = unpopulate(val, "DeleteMigrationResources", &v.DeleteMigrationResources)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtResyncInput.
func (v VMwareCbtResyncInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "skipCbtReset", v.SkipCbtReset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtResyncInput.
func (v *VMwareCbtResyncInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "skipCbtReset":
			err = unpopulate(val, "SkipCbtReset", &v.SkipCbtReset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtSecurityProfileProperties.
func (v VMwareCbtSecurityProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isTargetVmConfidentialEncryptionEnabled", v.IsTargetVMConfidentialEncryptionEnabled)
	populate(objectMap, "isTargetVmIntegrityMonitoringEnabled", v.IsTargetVMIntegrityMonitoringEnabled)
	populate(objectMap, "isTargetVmSecureBootEnabled", v.IsTargetVMSecureBootEnabled)
	populate(objectMap, "isTargetVmTpmEnabled", v.IsTargetVMTpmEnabled)
	populate(objectMap, "targetVmSecurityType", v.TargetVMSecurityType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtSecurityProfileProperties.
func (v *VMwareCbtSecurityProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isTargetVmConfidentialEncryptionEnabled":
			err = unpopulate(val, "IsTargetVMConfidentialEncryptionEnabled", &v.IsTargetVMConfidentialEncryptionEnabled)
			delete(rawMsg, key)
		case "isTargetVmIntegrityMonitoringEnabled":
			err = unpopulate(val, "IsTargetVMIntegrityMonitoringEnabled", &v.IsTargetVMIntegrityMonitoringEnabled)
			delete(rawMsg, key)
		case "isTargetVmSecureBootEnabled":
			err = unpopulate(val, "IsTargetVMSecureBootEnabled", &v.IsTargetVMSecureBootEnabled)
			delete(rawMsg, key)
		case "isTargetVmTpmEnabled":
			err = unpopulate(val, "IsTargetVMTpmEnabled", &v.IsTargetVMTpmEnabled)
			delete(rawMsg, key)
		case "targetVmSecurityType":
			err = unpopulate(val, "TargetVMSecurityType", &v.TargetVMSecurityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtTestMigrateInput.
func (v VMwareCbtTestMigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "networkId", v.NetworkID)
	populate(objectMap, "osUpgradeVersion", v.OSUpgradeVersion)
	populate(objectMap, "recoveryPointId", v.RecoveryPointID)
	populate(objectMap, "vmNics", v.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtTestMigrateInput.
func (v *VMwareCbtTestMigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &v.NetworkID)
			delete(rawMsg, key)
		case "osUpgradeVersion":
			err = unpopulate(val, "OSUpgradeVersion", &v.OSUpgradeVersion)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &v.RecoveryPointID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtUpdateDiskInput.
func (v VMwareCbtUpdateDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "isOSDisk", v.IsOSDisk)
	populate(objectMap, "targetDiskName", v.TargetDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtUpdateDiskInput.
func (v *VMwareCbtUpdateDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &v.IsOSDisk)
			delete(rawMsg, key)
		case "targetDiskName":
			err = unpopulate(val, "TargetDiskName", &v.TargetDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtUpdateMigrationItemInput.
func (v VMwareCbtUpdateMigrationItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "sqlServerLicenseType", v.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", v.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetDiskTags", v.TargetDiskTags)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetNicTags", v.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", v.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "targetVmTags", v.TargetVMTags)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "vmDisks", v.VMDisks)
	populate(objectMap, "vmNics", v.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtUpdateMigrationItemInput.
func (v *VMwareCbtUpdateMigrationItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &v.VMDisks)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareDetails.
func (v VMwareDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentCount", v.AgentCount)
	populateDateTimeRFC3339(objectMap, "agentExpiryDate", v.AgentExpiryDate)
	populate(objectMap, "agentVersion", v.AgentVersion)
	populate(objectMap, "agentVersionDetails", v.AgentVersionDetails)
	populate(objectMap, "availableMemoryInBytes", v.AvailableMemoryInBytes)
	populate(objectMap, "availableSpaceInBytes", v.AvailableSpaceInBytes)
	populate(objectMap, "cpuLoad", v.CPULoad)
	populate(objectMap, "cpuLoadStatus", v.CPULoadStatus)
	populate(objectMap, "csServiceStatus", v.CsServiceStatus)
	populate(objectMap, "databaseServerLoad", v.DatabaseServerLoad)
	populate(objectMap, "databaseServerLoadStatus", v.DatabaseServerLoadStatus)
	populate(objectMap, "hostName", v.HostName)
	populate(objectMap, "ipAddress", v.IPAddress)
	objectMap["instanceType"] = "VMware"
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", v.LastHeartbeat)
	populate(objectMap, "masterTargetServers", v.MasterTargetServers)
	populate(objectMap, "memoryUsageStatus", v.MemoryUsageStatus)
	populate(objectMap, "processServerCount", v.ProcessServerCount)
	populate(objectMap, "processServers", v.ProcessServers)
	populate(objectMap, "protectedServers", v.ProtectedServers)
	populate(objectMap, "psTemplateVersion", v.PsTemplateVersion)
	populate(objectMap, "replicationPairCount", v.ReplicationPairCount)
	populate(objectMap, "runAsAccounts", v.RunAsAccounts)
	populateDateTimeRFC3339(objectMap, "sslCertExpiryDate", v.SSLCertExpiryDate)
	populate(objectMap, "sslCertExpiryRemainingDays", v.SSLCertExpiryRemainingDays)
	populate(objectMap, "spaceUsageStatus", v.SpaceUsageStatus)
	populate(objectMap, "switchProviderBlockingErrorDetails", v.SwitchProviderBlockingErrorDetails)
	populate(objectMap, "systemLoad", v.SystemLoad)
	populate(objectMap, "systemLoadStatus", v.SystemLoadStatus)
	populate(objectMap, "totalMemoryInBytes", v.TotalMemoryInBytes)
	populate(objectMap, "totalSpaceInBytes", v.TotalSpaceInBytes)
	populate(objectMap, "versionStatus", v.VersionStatus)
	populate(objectMap, "webLoad", v.WebLoad)
	populate(objectMap, "webLoadStatus", v.WebLoadStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareDetails.
func (v *VMwareDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentCount":
			err = unpopulate(val, "AgentCount", &v.AgentCount)
			delete(rawMsg, key)
		case "agentExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "AgentExpiryDate", &v.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &v.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &v.AgentVersionDetails)
			delete(rawMsg, key)
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &v.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &v.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "cpuLoad":
			err = unpopulate(val, "CPULoad", &v.CPULoad)
			delete(rawMsg, key)
		case "cpuLoadStatus":
			err = unpopulate(val, "CPULoadStatus", &v.CPULoadStatus)
			delete(rawMsg, key)
		case "csServiceStatus":
			err = unpopulate(val, "CsServiceStatus", &v.CsServiceStatus)
			delete(rawMsg, key)
		case "databaseServerLoad":
			err = unpopulate(val, "DatabaseServerLoad", &v.DatabaseServerLoad)
			delete(rawMsg, key)
		case "databaseServerLoadStatus":
			err = unpopulate(val, "DatabaseServerLoadStatus", &v.DatabaseServerLoadStatus)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &v.HostName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &v.LastHeartbeat)
			delete(rawMsg, key)
		case "masterTargetServers":
			err = unpopulate(val, "MasterTargetServers", &v.MasterTargetServers)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &v.MemoryUsageStatus)
			delete(rawMsg, key)
		case "processServerCount":
			err = unpopulate(val, "ProcessServerCount", &v.ProcessServerCount)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &v.ProcessServers)
			delete(rawMsg, key)
		case "protectedServers":
			err = unpopulate(val, "ProtectedServers", &v.ProtectedServers)
			delete(rawMsg, key)
		case "psTemplateVersion":
			err = unpopulate(val, "PsTemplateVersion", &v.PsTemplateVersion)
			delete(rawMsg, key)
		case "replicationPairCount":
			err = unpopulate(val, "ReplicationPairCount", &v.ReplicationPairCount)
			delete(rawMsg, key)
		case "runAsAccounts":
			err = unpopulate(val, "RunAsAccounts", &v.RunAsAccounts)
			delete(rawMsg, key)
		case "sslCertExpiryDate":
			err = unpopulateDateTimeRFC3339(val, "SSLCertExpiryDate", &v.SSLCertExpiryDate)
			delete(rawMsg, key)
		case "sslCertExpiryRemainingDays":
			err = unpopulate(val, "SSLCertExpiryRemainingDays", &v.SSLCertExpiryRemainingDays)
			delete(rawMsg, key)
		case "spaceUsageStatus":
			err = unpopulate(val, "SpaceUsageStatus", &v.SpaceUsageStatus)
			delete(rawMsg, key)
		case "switchProviderBlockingErrorDetails":
			err = unpopulate(val, "SwitchProviderBlockingErrorDetails", &v.SwitchProviderBlockingErrorDetails)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &v.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &v.SystemLoadStatus)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &v.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &v.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &v.VersionStatus)
			delete(rawMsg, key)
		case "webLoad":
			err = unpopulate(val, "WebLoad", &v.WebLoad)
			delete(rawMsg, key)
		case "webLoadStatus":
			err = unpopulate(val, "WebLoadStatus", &v.WebLoadStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareV2FabricCreationInput.
func (v VMwareV2FabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareV2"
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "physicalSiteId", v.PhysicalSiteID)
	populate(objectMap, "vmwareSiteId", v.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareV2FabricCreationInput.
func (v *VMwareV2FabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &v.PhysicalSiteID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareV2FabricSpecificDetails.
func (v VMwareV2FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareV2"
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "physicalSiteId", v.PhysicalSiteID)
	populate(objectMap, "processServers", v.ProcessServers)
	populate(objectMap, "serviceContainerId", v.ServiceContainerID)
	populate(objectMap, "serviceEndpoint", v.ServiceEndpoint)
	populate(objectMap, "serviceResourceId", v.ServiceResourceID)
	populate(objectMap, "vmwareSiteId", v.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareV2FabricSpecificDetails.
func (v *VMwareV2FabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &v.PhysicalSiteID)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &v.ProcessServers)
			delete(rawMsg, key)
		case "serviceContainerId":
			err = unpopulate(val, "ServiceContainerID", &v.ServiceContainerID)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &v.ServiceEndpoint)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &v.ServiceResourceID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareVirtualMachineDetails.
func (v VMwareVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentGeneratedId", v.AgentGeneratedID)
	populate(objectMap, "agentInstalled", v.AgentInstalled)
	populate(objectMap, "agentVersion", v.AgentVersion)
	populate(objectMap, "discoveryType", v.DiscoveryType)
	populate(objectMap, "diskDetails", v.DiskDetails)
	populate(objectMap, "ipAddress", v.IPAddress)
	objectMap["instanceType"] = "VMwareVirtualMachine"
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "poweredOn", v.PoweredOn)
	populate(objectMap, "vCenterInfrastructureId", v.VCenterInfrastructureID)
	populate(objectMap, "validationErrors", v.ValidationErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareVirtualMachineDetails.
func (v *VMwareVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentGeneratedId":
			err = unpopulate(val, "AgentGeneratedID", &v.AgentGeneratedID)
			delete(rawMsg, key)
		case "agentInstalled":
			err = unpopulate(val, "AgentInstalled", &v.AgentInstalled)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &v.AgentVersion)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &v.DiscoveryType)
			delete(rawMsg, key)
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &v.DiskDetails)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "poweredOn":
			err = unpopulate(val, "PoweredOn", &v.PoweredOn)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &v.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &v.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultHealthDetails.
func (v VaultHealthDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultHealthDetails.
func (v *VaultHealthDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultHealthProperties.
func (v VaultHealthProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containersHealth", v.ContainersHealth)
	populate(objectMap, "fabricsHealth", v.FabricsHealth)
	populate(objectMap, "protectedItemsHealth", v.ProtectedItemsHealth)
	populate(objectMap, "vaultErrors", v.VaultErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultHealthProperties.
func (v *VaultHealthProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containersHealth":
			err = unpopulate(val, "ContainersHealth", &v.ContainersHealth)
			delete(rawMsg, key)
		case "fabricsHealth":
			err = unpopulate(val, "FabricsHealth", &v.FabricsHealth)
			delete(rawMsg, key)
		case "protectedItemsHealth":
			err = unpopulate(val, "ProtectedItemsHealth", &v.ProtectedItemsHealth)
			delete(rawMsg, key)
		case "vaultErrors":
			err = unpopulate(val, "VaultErrors", &v.VaultErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSetting.
func (v VaultSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSetting.
func (v *VaultSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSettingCollection.
func (v VaultSettingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSettingCollection.
func (v *VaultSettingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSettingCreationInput.
func (v VaultSettingCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSettingCreationInput.
func (v *VaultSettingCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSettingCreationInputProperties.
func (v VaultSettingCreationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "vmwareToAzureProviderType", v.VmwareToAzureProviderType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSettingCreationInputProperties.
func (v *VaultSettingCreationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "vmwareToAzureProviderType":
			err = unpopulate(val, "VmwareToAzureProviderType", &v.VmwareToAzureProviderType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultSettingProperties.
func (v VaultSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "vmwareToAzureProviderType", v.VmwareToAzureProviderType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultSettingProperties.
func (v *VaultSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "vmwareToAzureProviderType":
			err = unpopulate(val, "VmwareToAzureProviderType", &v.VmwareToAzureProviderType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VersionDetails.
func (v VersionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiryDate", v.ExpiryDate)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VersionDetails.
func (v *VersionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryDate":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDate", &v.ExpiryDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTaskDetails.
func (v VirtualMachineTaskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VirtualMachineTaskDetails"
	populate(objectMap, "jobTask", v.JobTask)
	populate(objectMap, "skippedReason", v.SkippedReason)
	populate(objectMap, "skippedReasonString", v.SkippedReasonString)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &v.JobTask)
			delete(rawMsg, key)
		case "skippedReason":
			err = unpopulate(val, "SkippedReason", &v.SkippedReason)
			delete(rawMsg, key)
		case "skippedReasonString":
			err = unpopulate(val, "SkippedReasonString", &v.SkippedReasonString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmDetails.
func (v VmmDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMM"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmDetails.
func (v *VmmDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToAzureCreateNetworkMappingInput.
func (v VmmToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToAzure"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureCreateNetworkMappingInput.
func (v *VmmToAzureCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToAzureNetworkMappingSettings.
func (v VmmToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToAzure"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureNetworkMappingSettings.
func (v *VmmToAzureNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToAzureUpdateNetworkMappingInput.
func (v VmmToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToAzure"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureUpdateNetworkMappingInput.
func (v *VmmToAzureUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToVmmCreateNetworkMappingInput.
func (v VmmToVmmCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToVmm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmCreateNetworkMappingInput.
func (v *VmmToVmmCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToVmmNetworkMappingSettings.
func (v VmmToVmmNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToVmm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmNetworkMappingSettings.
func (v *VmmToVmmNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToVmmUpdateNetworkMappingInput.
func (v VmmToVmmUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VmmToVmm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmUpdateNetworkMappingInput.
func (v *VmmToVmmUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmVirtualMachineDetails.
func (v VmmVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskDetails", v.DiskDetails)
	populate(objectMap, "generation", v.Generation)
	populate(objectMap, "hasFibreChannelAdapter", v.HasFibreChannelAdapter)
	populate(objectMap, "hasPhysicalDisk", v.HasPhysicalDisk)
	populate(objectMap, "hasSharedVhd", v.HasSharedVhd)
	populate(objectMap, "hyperVHostId", v.HyperVHostID)
	objectMap["instanceType"] = "VmmVirtualMachine"
	populate(objectMap, "osDetails", v.OSDetails)
	populate(objectMap, "sourceItemId", v.SourceItemID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &v.DiskDetails)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &v.Generation)
			delete(rawMsg, key)
		case "hasFibreChannelAdapter":
			err = unpopulate(val, "HasFibreChannelAdapter", &v.HasFibreChannelAdapter)
			delete(rawMsg, key)
		case "hasPhysicalDisk":
			err = unpopulate(val, "HasPhysicalDisk", &v.HasPhysicalDisk)
			delete(rawMsg, key)
		case "hasSharedVhd":
			err = unpopulate(val, "HasSharedVhd", &v.HasSharedVhd)
			delete(rawMsg, key)
		case "hyperVHostId":
			err = unpopulate(val, "HyperVHostID", &v.HyperVHostID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &v.OSDetails)
			delete(rawMsg, key)
		case "sourceItemId":
			err = unpopulate(val, "SourceItemID", &v.SourceItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmwareCbtPolicyDetails.
func (v VmwareCbtPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", v.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", v.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "recoveryPointHistoryInMinutes", v.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmwareCbtPolicyDetails.
func (v *VmwareCbtPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &v.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &v.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &v.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
