//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicesbackup_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/v2-Get-Policy.json
func ExampleProtectionPoliciesClient_Get_getAzureIaasVmEnhancedProtectionPolicyDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().Get(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "v2-daily-sample", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("v2-daily-sample"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/v2-daily-sample"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		InstantRpRetentionRangeInDays: to.Ptr[int32](30),
	// 		PolicyType: to.Ptr(armrecoveryservicesbackup.IAASVMPolicyTypeV2),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](1),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t}())},
	// 				},
	// 			},
	// 			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicyV2{
	// 				SchedulePolicyType: to.Ptr("SimpleSchedulePolicyV2"),
	// 				DailySchedule: &armrecoveryservicesbackup.DailySchedule{
	// 					ScheduleRunTimes: []*time.Time{
	// 						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 					},
	// 					ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 				},
	// 				TimeZone: to.Ptr("Pacific Standard Time"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_Get.json
func ExampleProtectionPoliciesClient_Get_getAzureIaasVmProtectionPolicyDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().Get(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "testPolicy1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("testPolicy1"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/testPolicy1"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](1),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t}())},
	// 				},
	// 			},
	// 			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 				SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 				ScheduleRunTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t}())},
	// 					ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 				},
	// 				TimeZone: to.Ptr("Pacific Standard Time"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Hardened.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateAzureStorageVaultStandardProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "swaggertestvault", "SwaggerTestRg", "newPolicyV2", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
			BackupManagementType: to.Ptr("AzureStorage"),
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
				SchedulePolicyType:   to.Ptr("SimpleSchedulePolicy"),
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
				ScheduleRunTimes: []*time.Time{
					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t }())},
			},
			TimeZone: to.Ptr("UTC"),
			VaultRetentionPolicy: &armrecoveryservicesbackup.VaultRetentionPolicy{
				SnapshotRetentionInDays: to.Ptr[int32](5),
				VaultRetention: &armrecoveryservicesbackup.LongTermRetentionPolicy{
					RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
					DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](30),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
						},
						RetentionTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t }())},
					},
					MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](60),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
						},
						RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
						RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
							DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
								to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
						},
						RetentionTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t }())},
					},
					WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](12),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
						},
						RetentionTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t }())},
					},
					YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
						MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
							to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](10),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
						},
						RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
						RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
							DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
								to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
						},
						RetentionTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t }())},
					},
				},
			},
			WorkLoadType: to.Ptr(armrecoveryservicesbackup.WorkloadTypeAzureFileShare),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("newPolicyV2"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/swaggertestvault/backupPolicies/newPolicyV2"),
	// 	Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureStorage"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 			SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 			ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 			ScheduleRunTimes: []*time.Time{
	// 				to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t}())},
	// 			},
	// 			TimeZone: to.Ptr("UTC"),
	// 			VaultRetentionPolicy: &armrecoveryservicesbackup.VaultRetentionPolicy{
	// 				SnapshotRetentionInDays: to.Ptr[int32](5),
	// 				VaultRetention: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 					RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 					DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 							Count: to.Ptr[int32](30),
	// 							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 						},
	// 						RetentionTimes: []*time.Time{
	// 							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t}())},
	// 						},
	// 						MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 							RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 								Count: to.Ptr[int32](60),
	// 								DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 							},
	// 							RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 							RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 									WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 										to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 									},
	// 									RetentionTimes: []*time.Time{
	// 										to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t}())},
	// 									},
	// 									WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 										DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 											to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 											RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 												Count: to.Ptr[int32](12),
	// 												DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 											},
	// 											RetentionTimes: []*time.Time{
	// 												to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t}())},
	// 											},
	// 											YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 												MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 													to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
	// 													RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 														Count: to.Ptr[int32](10),
	// 														DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 													},
	// 													RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 													RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 														DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 															to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 															WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 																to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 															},
	// 															RetentionTimes: []*time.Time{
	// 																to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-18T09:30:00.000Z"); return t}())},
	// 															},
	// 														},
	// 													},
	// 												},
	// 											}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Daily.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateDailyAzureStorageProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "swaggertestvault", "SwaggerTestRg", "dailyPolicy2", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
			BackupManagementType: to.Ptr("AzureStorage"),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](5),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }())},
				},
				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](60),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }())},
				},
				WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
						to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](12),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }())},
				},
				YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
					MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
						to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](10),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }())},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
				SchedulePolicyType:   to.Ptr("SimpleSchedulePolicy"),
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
				ScheduleRunTimes: []*time.Time{
					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }())},
			},
			TimeZone:     to.Ptr("UTC"),
			WorkLoadType: to.Ptr(armrecoveryservicesbackup.WorkloadTypeAzureFileShare),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("dailyPolicy2"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/swaggertestvault/backupPolicies/dailyPolicy2"),
	// 	Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureStorage"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](5),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}())},
	// 				},
	// 				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 						Count: to.Ptr[int32](60),
	// 						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 					},
	// 					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 							},
	// 							RetentionTimes: []*time.Time{
	// 								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}())},
	// 							},
	// 							WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 									RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 										Count: to.Ptr[int32](12),
	// 										DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 									},
	// 									RetentionTimes: []*time.Time{
	// 										to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}())},
	// 									},
	// 									YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 										MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 											to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
	// 											RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 												Count: to.Ptr[int32](10),
	// 												DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 											},
	// 											RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 											RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 												DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 													WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 														to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 													},
	// 													RetentionTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}())},
	// 													},
	// 												},
	// 												SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 													SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 													ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 													ScheduleRunTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}())},
	// 														ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 													},
	// 													TimeZone: to.Ptr("UTC"),
	// 												},
	// 											}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/IaaS_v2_hourly.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateEnhancedAzureVmProtectionPolicyWithHourlyBackup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "v2-daily-sample", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
			BackupManagementType:          to.Ptr("AzureIaasVM"),
			InstantRpRetentionRangeInDays: to.Ptr[int32](30),
			PolicyType:                    to.Ptr(armrecoveryservicesbackup.IAASVMPolicyTypeV2),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](180),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](60),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
						to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](12),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
					MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
						to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](10),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicyV2{
				SchedulePolicyType: to.Ptr("SimpleSchedulePolicyV2"),
				HourlySchedule: &armrecoveryservicesbackup.HourlySchedule{
					Interval:                to.Ptr[int32](4),
					ScheduleWindowDuration:  to.Ptr[int32](16),
					ScheduleWindowStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }()),
				},
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeHourly),
			},
			TimeZone: to.Ptr("India Standard Time"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("v2-daily-sample"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/v2-daily-sample"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		InstantRpRetentionRangeInDays: to.Ptr[int32](30),
	// 		PolicyType: to.Ptr(armrecoveryservicesbackup.IAASVMPolicyTypeV2),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](180),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 				},
	// 				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 						Count: to.Ptr[int32](60),
	// 						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 					},
	// 					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 							},
	// 							RetentionTimes: []*time.Time{
	// 								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 							},
	// 							WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 									RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 										Count: to.Ptr[int32](12),
	// 										DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 									},
	// 									RetentionTimes: []*time.Time{
	// 										to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 									},
	// 									YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 										MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 											to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
	// 											RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 												Count: to.Ptr[int32](10),
	// 												DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 											},
	// 											RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 											RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 												DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 													WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 														to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 													},
	// 													RetentionTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 													},
	// 												},
	// 												SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicyV2{
	// 													SchedulePolicyType: to.Ptr("SimpleSchedulePolicyV2"),
	// 													HourlySchedule: &armrecoveryservicesbackup.HourlySchedule{
	// 														Interval: to.Ptr[int32](4),
	// 														ScheduleWindowDuration: to.Ptr[int32](16),
	// 														ScheduleWindowStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}()),
	// 													},
	// 													ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeHourly),
	// 												},
	// 												TimeZone: to.Ptr("India Standard Time"),
	// 											},
	// 										}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/IaaS_v2_daily.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateEnhancedAzureVmProtectionPolicyWithDailyBackup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "v2-daily-sample", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
			BackupManagementType:          to.Ptr("AzureIaasVM"),
			InstantRpRetentionRangeInDays: to.Ptr[int32](30),
			PolicyType:                    to.Ptr(armrecoveryservicesbackup.IAASVMPolicyTypeV2),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](180),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](60),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
						to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](12),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
				YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
					MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
						to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](10),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t }())},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicyV2{
				SchedulePolicyType: to.Ptr("SimpleSchedulePolicyV2"),
				DailySchedule: &armrecoveryservicesbackup.DailySchedule{
					ScheduleRunTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
				},
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
			},
			TimeZone: to.Ptr("India Standard Time"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("v2-daily-sample"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/v2-daily-sample"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		InstantRpRetentionRangeInDays: to.Ptr[int32](30),
	// 		PolicyType: to.Ptr(armrecoveryservicesbackup.IAASVMPolicyTypeV2),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](180),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 				},
	// 				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 						Count: to.Ptr[int32](60),
	// 						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 					},
	// 					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 							},
	// 							RetentionTimes: []*time.Time{
	// 								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 							},
	// 							WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 									RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 										Count: to.Ptr[int32](12),
	// 										DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 									},
	// 									RetentionTimes: []*time.Time{
	// 										to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 									},
	// 									YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 										MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 											to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
	// 											RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 												Count: to.Ptr[int32](10),
	// 												DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 											},
	// 											RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 											RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 												DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 													WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 														to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 													},
	// 													RetentionTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-12-17T08:00:00.000Z"); return t}())},
	// 													},
	// 												},
	// 												SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicyV2{
	// 													SchedulePolicyType: to.Ptr("SimpleSchedulePolicyV2"),
	// 													DailySchedule: &armrecoveryservicesbackup.DailySchedule{
	// 														ScheduleRunTimes: []*time.Time{
	// 															to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 														},
	// 														ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 													},
	// 													TimeZone: to.Ptr("India Standard Time"),
	// 												},
	// 											}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_CreateOrUpdate_Complex.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateFullAzureVmProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "testPolicy1", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
			BackupManagementType: to.Ptr("AzureIaasVM"),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](2),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
							to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst),
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthThird)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
				},
				WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
						to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
						to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
						to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](1),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
				},
				YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
					MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
						to.Ptr(armrecoveryservicesbackup.MonthOfYearFebruary),
						to.Ptr(armrecoveryservicesbackup.MonthOfYearNovember)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](4),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
							to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFourth)},
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
				SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
				ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
					to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
					to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
					to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
				ScheduleRunTimes: []*time.Time{
					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
			},
			TimeZone: to.Ptr("Pacific Standard Time"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("testPolicy1"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/testPolicy1"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](2),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 				},
	// 				RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 				RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 						to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
	// 						to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
	// 						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst),
	// 							to.Ptr(armrecoveryservicesbackup.WeekOfMonthThird)},
	// 						},
	// 						RetentionTimes: []*time.Time{
	// 							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 						},
	// 						WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 							DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 								to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
	// 								to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
	// 								to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
	// 								RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 									Count: to.Ptr[int32](1),
	// 									DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 								},
	// 								RetentionTimes: []*time.Time{
	// 									to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 								},
	// 								YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 									MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 										to.Ptr(armrecoveryservicesbackup.MonthOfYearFebruary),
	// 										to.Ptr(armrecoveryservicesbackup.MonthOfYearNovember)},
	// 										RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 											Count: to.Ptr[int32](4),
	// 											DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 										},
	// 										RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 										RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 											DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 												to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
	// 												to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
	// 												WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 													to.Ptr(armrecoveryservicesbackup.WeekOfMonthFourth)},
	// 												},
	// 												RetentionTimes: []*time.Time{
	// 													to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 												},
	// 											},
	// 											SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 												SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 												ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekMonday),
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekWednesday),
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekThursday)},
	// 													ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
	// 													ScheduleRunTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 														ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 													},
	// 													TimeZone: to.Ptr("Pacific Standard Time"),
	// 												},
	// 											}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureWorkload/ProtectionPolicies_CreateOrUpdate_Complex.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateFullAzureWorkloadProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "testPolicy1", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureVMWorkloadProtectionPolicy{
			BackupManagementType: to.Ptr("AzureWorkload"),
			Settings: &armrecoveryservicesbackup.Settings{
				Issqlcompression: to.Ptr(false),
				TimeZone:         to.Ptr("Pacific Standard Time"),
			},
			SubProtectionPolicy: []*armrecoveryservicesbackup.SubProtectionPolicy{
				{
					PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeFull),
					RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
						RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
						MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
							RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
								Count:        to.Ptr[int32](1),
								DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
							},
							RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
							RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
								WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
									to.Ptr(armrecoveryservicesbackup.WeekOfMonthSecond)},
							},
							RetentionTimes: []*time.Time{
								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
						},
						WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
							DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
								to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday),
								to.Ptr(armrecoveryservicesbackup.DayOfWeekTuesday)},
							RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
								Count:        to.Ptr[int32](2),
								DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
							},
							RetentionTimes: []*time.Time{
								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
						},
						YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
							MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
								to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary),
								to.Ptr(armrecoveryservicesbackup.MonthOfYearJune),
								to.Ptr(armrecoveryservicesbackup.MonthOfYearDecember)},
							RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
								Count:        to.Ptr[int32](1),
								DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
							},
							RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
							RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
								WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
									to.Ptr(armrecoveryservicesbackup.WeekOfMonthLast)},
							},
							RetentionTimes: []*time.Time{
								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
						},
					},
					SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
						SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
						ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday),
							to.Ptr(armrecoveryservicesbackup.DayOfWeekTuesday)},
						ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
						ScheduleRunTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
					},
				},
				{
					PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeDifferential),
					RetentionPolicy: &armrecoveryservicesbackup.SimpleRetentionPolicy{
						RetentionPolicyType: to.Ptr("SimpleRetentionPolicy"),
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](8),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
						},
					},
					SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
						SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
						ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekFriday)},
						ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
						ScheduleRunTimes: []*time.Time{
							to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t }())},
					},
				},
				{
					PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeLog),
					RetentionPolicy: &armrecoveryservicesbackup.SimpleRetentionPolicy{
						RetentionPolicyType: to.Ptr("SimpleRetentionPolicy"),
						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
							Count:        to.Ptr[int32](7),
							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
						},
					},
					SchedulePolicy: &armrecoveryservicesbackup.LogSchedulePolicy{
						SchedulePolicyType:      to.Ptr("LogSchedulePolicy"),
						ScheduleFrequencyInMins: to.Ptr[int32](60),
					},
				}},
			WorkLoadType: to.Ptr(armrecoveryservicesbackup.WorkloadTypeSQLDataBase),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("testPolicy1"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/testPolicy1"),
	// 	Properties: &armrecoveryservicesbackup.AzureVMWorkloadProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureWorkload"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		Settings: &armrecoveryservicesbackup.Settings{
	// 			Issqlcompression: to.Ptr(false),
	// 			TimeZone: to.Ptr("Pacific Standard Time"),
	// 		},
	// 		SubProtectionPolicy: []*armrecoveryservicesbackup.SubProtectionPolicy{
	// 			{
	// 				PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeFull),
	// 				RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 					RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 					MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 						RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 							Count: to.Ptr[int32](1),
	// 							DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 						},
	// 						RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 						RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 							DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 								to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 								WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 									to.Ptr(armrecoveryservicesbackup.WeekOfMonthSecond)},
	// 								},
	// 								RetentionTimes: []*time.Time{
	// 									to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 								},
	// 								WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 									DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 										to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday),
	// 										to.Ptr(armrecoveryservicesbackup.DayOfWeekTuesday)},
	// 										RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 											Count: to.Ptr[int32](2),
	// 											DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 										},
	// 										RetentionTimes: []*time.Time{
	// 											to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 										},
	// 										YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 											MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 												to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary),
	// 												to.Ptr(armrecoveryservicesbackup.MonthOfYearJune),
	// 												to.Ptr(armrecoveryservicesbackup.MonthOfYearDecember)},
	// 												RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 													Count: to.Ptr[int32](1),
	// 													DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 												},
	// 												RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 												RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 													DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 														to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 														WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 															to.Ptr(armrecoveryservicesbackup.WeekOfMonthLast)},
	// 														},
	// 														RetentionTimes: []*time.Time{
	// 															to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 														},
	// 													},
	// 													SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 														SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 														ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
	// 															to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday),
	// 															to.Ptr(armrecoveryservicesbackup.DayOfWeekTuesday)},
	// 															ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
	// 															ScheduleRunTimes: []*time.Time{
	// 																to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 																ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 															},
	// 														},
	// 														{
	// 															PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeDifferential),
	// 															RetentionPolicy: &armrecoveryservicesbackup.SimpleRetentionPolicy{
	// 																RetentionPolicyType: to.Ptr("SimpleRetentionPolicy"),
	// 																RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 																	Count: to.Ptr[int32](8),
	// 																	DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 																},
	// 															},
	// 															SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 																SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 																ScheduleRunDays: []*armrecoveryservicesbackup.DayOfWeek{
	// 																	to.Ptr(armrecoveryservicesbackup.DayOfWeekFriday)},
	// 																	ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeWeekly),
	// 																	ScheduleRunTimes: []*time.Time{
	// 																		to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T10:00:00.000Z"); return t}())},
	// 																		ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 																	},
	// 																},
	// 																{
	// 																	PolicyType: to.Ptr(armrecoveryservicesbackup.PolicyTypeLog),
	// 																	RetentionPolicy: &armrecoveryservicesbackup.SimpleRetentionPolicy{
	// 																		RetentionPolicyType: to.Ptr("SimpleRetentionPolicy"),
	// 																		RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 																			Count: to.Ptr[int32](7),
	// 																			DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 																		},
	// 																	},
	// 																	SchedulePolicy: &armrecoveryservicesbackup.LogSchedulePolicy{
	// 																		SchedulePolicyType: to.Ptr("LogSchedulePolicy"),
	// 																		ScheduleFrequencyInMins: to.Ptr[int32](60),
	// 																	},
	// 															}},
	// 															WorkLoadType: to.Ptr(armrecoveryservicesbackup.WorkloadTypeSQLDataBase),
	// 														},
	// 													}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Hourly.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateHourlyAzureStorageProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "swaggertestvault", "SwaggerTestRg", "newPolicy2", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
			BackupManagementType: to.Ptr("AzureStorage"),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](5),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
					},
				},
				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](60),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
				},
				WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
					DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
						to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](12),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
					},
				},
				YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
					MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
						to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](10),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
					},
					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
						WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
							to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
					},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
				SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
				HourlySchedule: &armrecoveryservicesbackup.HourlySchedule{
					Interval:                to.Ptr[int32](4),
					ScheduleWindowDuration:  to.Ptr[int32](12),
					ScheduleWindowStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t }()),
				},
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeHourly),
			},
			TimeZone:     to.Ptr("UTC"),
			WorkLoadType: to.Ptr(armrecoveryservicesbackup.WorkloadTypeAzureFileShare),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("newPolicy2"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/swaggertestvault/backupPolicies/newPolicy2"),
	// 	Properties: &armrecoveryservicesbackup.AzureFileShareProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureStorage"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](5),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T20:00:00.000Z"); return t}())},
	// 				},
	// 				MonthlySchedule: &armrecoveryservicesbackup.MonthlyRetentionSchedule{
	// 					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 						Count: to.Ptr[int32](60),
	// 						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeMonths),
	// 					},
	// 					RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 					RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 						DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 							to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 							WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 								to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 							},
	// 							RetentionTimes: []*time.Time{
	// 								to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T20:00:00.000Z"); return t}())},
	// 							},
	// 							WeeklySchedule: &armrecoveryservicesbackup.WeeklyRetentionSchedule{
	// 								DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 									to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 									RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 										Count: to.Ptr[int32](12),
	// 										DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeWeeks),
	// 									},
	// 									RetentionTimes: []*time.Time{
	// 										to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T20:00:00.000Z"); return t}())},
	// 									},
	// 									YearlySchedule: &armrecoveryservicesbackup.YearlyRetentionSchedule{
	// 										MonthsOfYear: []*armrecoveryservicesbackup.MonthOfYear{
	// 											to.Ptr(armrecoveryservicesbackup.MonthOfYearJanuary)},
	// 											RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 												Count: to.Ptr[int32](10),
	// 												DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeYears),
	// 											},
	// 											RetentionScheduleFormatType: to.Ptr(armrecoveryservicesbackup.RetentionScheduleFormatWeekly),
	// 											RetentionScheduleWeekly: &armrecoveryservicesbackup.WeeklyRetentionFormat{
	// 												DaysOfTheWeek: []*armrecoveryservicesbackup.DayOfWeek{
	// 													to.Ptr(armrecoveryservicesbackup.DayOfWeekSunday)},
	// 													WeeksOfTheMonth: []*armrecoveryservicesbackup.WeekOfMonth{
	// 														to.Ptr(armrecoveryservicesbackup.WeekOfMonthFirst)},
	// 													},
	// 													RetentionTimes: []*time.Time{
	// 														to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T20:00:00.000Z"); return t}())},
	// 													},
	// 												},
	// 												SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 													SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 													HourlySchedule: &armrecoveryservicesbackup.HourlySchedule{
	// 														Interval: to.Ptr[int32](4),
	// 														ScheduleWindowDuration: to.Ptr[int32](12),
	// 														ScheduleWindowStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-29T08:00:00.000Z"); return t}()),
	// 													},
	// 													ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeHourly),
	// 													ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 												},
	// 												TimeZone: to.Ptr("UTC"),
	// 											},
	// 										}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_CreateOrUpdate_Simple.json
func ExampleProtectionPoliciesClient_CreateOrUpdate_createOrUpdateSimpleAzureVmProtectionPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProtectionPoliciesClient().CreateOrUpdate(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "testPolicy1", armrecoveryservicesbackup.ProtectionPolicyResource{
		Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
			BackupManagementType: to.Ptr("AzureIaasVM"),
			RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
				RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
				DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
					RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
						Count:        to.Ptr[int32](1),
						DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
					},
					RetentionTimes: []*time.Time{
						to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t }())},
				},
			},
			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
				SchedulePolicyType:   to.Ptr("SimpleSchedulePolicy"),
				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
				ScheduleRunTimes: []*time.Time{
					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t }())},
			},
			TimeZone: to.Ptr("Pacific Standard Time"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProtectionPolicyResource = armrecoveryservicesbackup.ProtectionPolicyResource{
	// 	Name: to.Ptr("testPolicy1"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupPolicies"),
	// 	ID: to.Ptr("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/testPolicy1"),
	// 	Properties: &armrecoveryservicesbackup.AzureIaaSVMProtectionPolicy{
	// 		BackupManagementType: to.Ptr("AzureIaasVM"),
	// 		ProtectedItemsCount: to.Ptr[int32](0),
	// 		RetentionPolicy: &armrecoveryservicesbackup.LongTermRetentionPolicy{
	// 			RetentionPolicyType: to.Ptr("LongTermRetentionPolicy"),
	// 			DailySchedule: &armrecoveryservicesbackup.DailyRetentionSchedule{
	// 				RetentionDuration: &armrecoveryservicesbackup.RetentionDuration{
	// 					Count: to.Ptr[int32](1),
	// 					DurationType: to.Ptr(armrecoveryservicesbackup.RetentionDurationTypeDays),
	// 				},
	// 				RetentionTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t}())},
	// 				},
	// 			},
	// 			SchedulePolicy: &armrecoveryservicesbackup.SimpleSchedulePolicy{
	// 				SchedulePolicyType: to.Ptr("SimpleSchedulePolicy"),
	// 				ScheduleRunFrequency: to.Ptr(armrecoveryservicesbackup.ScheduleRunTypeDaily),
	// 				ScheduleRunTimes: []*time.Time{
	// 					to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-01-24T02:00:00.000Z"); return t}())},
	// 					ScheduleWeeklyFrequency: to.Ptr[int32](0),
	// 				},
	// 				TimeZone: to.Ptr("Pacific Standard Time"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_Delete.json
func ExampleProtectionPoliciesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProtectionPoliciesClient().BeginDelete(ctx, "NetSDKTestRsVault", "SwaggerTestRg", "testPolicy1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
