//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// DeletedProtectionContainersServer is a fake server for instances of the armrecoveryservicesbackup.DeletedProtectionContainersClient type.
type DeletedProtectionContainersServer struct {
	// NewListPager is the fake for method DeletedProtectionContainersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, vaultName string, options *armrecoveryservicesbackup.DeletedProtectionContainersClientListOptions) (resp azfake.PagerResponder[armrecoveryservicesbackup.DeletedProtectionContainersClientListResponse])
}

// NewDeletedProtectionContainersServerTransport creates a new instance of DeletedProtectionContainersServerTransport with the provided implementation.
// The returned DeletedProtectionContainersServerTransport instance is connected to an instance of armrecoveryservicesbackup.DeletedProtectionContainersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeletedProtectionContainersServerTransport(srv *DeletedProtectionContainersServer) *DeletedProtectionContainersServerTransport {
	return &DeletedProtectionContainersServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armrecoveryservicesbackup.DeletedProtectionContainersClientListResponse]](),
	}
}

// DeletedProtectionContainersServerTransport connects instances of armrecoveryservicesbackup.DeletedProtectionContainersClient to instances of DeletedProtectionContainersServer.
// Don't use this type directly, use NewDeletedProtectionContainersServerTransport instead.
type DeletedProtectionContainersServerTransport struct {
	srv          *DeletedProtectionContainersServer
	newListPager *tracker[azfake.PagerResponder[armrecoveryservicesbackup.DeletedProtectionContainersClientListResponse]]
}

// Do implements the policy.Transporter interface for DeletedProtectionContainersServerTransport.
func (d *DeletedProtectionContainersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeletedProtectionContainersClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeletedProtectionContainersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupDeletedProtectionContainers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armrecoveryservicesbackup.DeletedProtectionContainersClientListOptions
		if filterParam != nil {
			options = &armrecoveryservicesbackup.DeletedProtectionContainersClientListOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListPager(resourceGroupNameParam, vaultNameParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicesbackup.DeletedProtectionContainersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
