//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ManagementServer is a fake server for instances of the armnetwork.ManagementClient type.
type ManagementServer struct {
	// CheckDNSNameAvailability is the fake for method ManagementClient.CheckDNSNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckDNSNameAvailability func(ctx context.Context, location string, domainNameLabel string, options *armnetwork.ManagementClientCheckDNSNameAvailabilityOptions) (resp azfake.Responder[armnetwork.ManagementClientCheckDNSNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginDeleteBastionShareableLink is the fake for method ManagementClient.BeginDeleteBastionShareableLink
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteBastionShareableLink func(ctx context.Context, resourceGroupName string, bastionHostName string, bslRequest armnetwork.BastionShareableLinkListRequest, options *armnetwork.ManagementClientBeginDeleteBastionShareableLinkOptions) (resp azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkResponse], errResp azfake.ErrorResponder)

	// BeginDeleteBastionShareableLinkByToken is the fake for method ManagementClient.BeginDeleteBastionShareableLinkByToken
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginDeleteBastionShareableLinkByToken func(ctx context.Context, resourceGroupName string, bastionHostName string, bslTokenRequest armnetwork.BastionShareableLinkTokenListRequest, options *armnetwork.ManagementClientBeginDeleteBastionShareableLinkByTokenOptions) (resp azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkByTokenResponse], errResp azfake.ErrorResponder)

	// NewDisconnectActiveSessionsPager is the fake for method ManagementClient.NewDisconnectActiveSessionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewDisconnectActiveSessionsPager func(resourceGroupName string, bastionHostName string, sessionIDs armnetwork.SessionIDs, options *armnetwork.ManagementClientDisconnectActiveSessionsOptions) (resp azfake.PagerResponder[armnetwork.ManagementClientDisconnectActiveSessionsResponse])

	// ExpressRouteProviderPort is the fake for method ManagementClient.ExpressRouteProviderPort
	// HTTP status codes to indicate success: http.StatusOK
	ExpressRouteProviderPort func(ctx context.Context, providerport string, options *armnetwork.ManagementClientExpressRouteProviderPortOptions) (resp azfake.Responder[armnetwork.ManagementClientExpressRouteProviderPortResponse], errResp azfake.ErrorResponder)

	// BeginGeneratevirtualwanvpnserverconfigurationvpnprofile is the fake for method ManagementClient.BeginGeneratevirtualwanvpnserverconfigurationvpnprofile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGeneratevirtualwanvpnserverconfigurationvpnprofile func(ctx context.Context, resourceGroupName string, virtualWANName string, vpnClientParams armnetwork.VirtualWanVPNProfileParameters, options *armnetwork.ManagementClientBeginGeneratevirtualwanvpnserverconfigurationvpnprofileOptions) (resp azfake.PollerResponder[armnetwork.ManagementClientGeneratevirtualwanvpnserverconfigurationvpnprofileResponse], errResp azfake.ErrorResponder)

	// BeginGetActiveSessions is the fake for method ManagementClient.BeginGetActiveSessions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetActiveSessions func(ctx context.Context, resourceGroupName string, bastionHostName string, options *armnetwork.ManagementClientBeginGetActiveSessionsOptions) (resp azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientGetActiveSessionsResponse]], errResp azfake.ErrorResponder)

	// NewGetBastionShareableLinkPager is the fake for method ManagementClient.NewGetBastionShareableLinkPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetBastionShareableLinkPager func(resourceGroupName string, bastionHostName string, bslRequest armnetwork.BastionShareableLinkListRequest, options *armnetwork.ManagementClientGetBastionShareableLinkOptions) (resp azfake.PagerResponder[armnetwork.ManagementClientGetBastionShareableLinkResponse])

	// ListActiveConnectivityConfigurations is the fake for method ManagementClient.ListActiveConnectivityConfigurations
	// HTTP status codes to indicate success: http.StatusOK
	ListActiveConnectivityConfigurations func(ctx context.Context, resourceGroupName string, networkManagerName string, parameters armnetwork.ActiveConfigurationParameter, options *armnetwork.ManagementClientListActiveConnectivityConfigurationsOptions) (resp azfake.Responder[armnetwork.ManagementClientListActiveConnectivityConfigurationsResponse], errResp azfake.ErrorResponder)

	// ListActiveSecurityAdminRules is the fake for method ManagementClient.ListActiveSecurityAdminRules
	// HTTP status codes to indicate success: http.StatusOK
	ListActiveSecurityAdminRules func(ctx context.Context, resourceGroupName string, networkManagerName string, parameters armnetwork.ActiveConfigurationParameter, options *armnetwork.ManagementClientListActiveSecurityAdminRulesOptions) (resp azfake.Responder[armnetwork.ManagementClientListActiveSecurityAdminRulesResponse], errResp azfake.ErrorResponder)

	// ListNetworkManagerEffectiveConnectivityConfigurations is the fake for method ManagementClient.ListNetworkManagerEffectiveConnectivityConfigurations
	// HTTP status codes to indicate success: http.StatusOK
	ListNetworkManagerEffectiveConnectivityConfigurations func(ctx context.Context, resourceGroupName string, virtualNetworkName string, parameters armnetwork.QueryRequestOptions, options *armnetwork.ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsOptions) (resp azfake.Responder[armnetwork.ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsResponse], errResp azfake.ErrorResponder)

	// ListNetworkManagerEffectiveSecurityAdminRules is the fake for method ManagementClient.ListNetworkManagerEffectiveSecurityAdminRules
	// HTTP status codes to indicate success: http.StatusOK
	ListNetworkManagerEffectiveSecurityAdminRules func(ctx context.Context, resourceGroupName string, virtualNetworkName string, parameters armnetwork.QueryRequestOptions, options *armnetwork.ManagementClientListNetworkManagerEffectiveSecurityAdminRulesOptions) (resp azfake.Responder[armnetwork.ManagementClientListNetworkManagerEffectiveSecurityAdminRulesResponse], errResp azfake.ErrorResponder)

	// BeginPutBastionShareableLink is the fake for method ManagementClient.BeginPutBastionShareableLink
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPutBastionShareableLink func(ctx context.Context, resourceGroupName string, bastionHostName string, bslRequest armnetwork.BastionShareableLinkListRequest, options *armnetwork.ManagementClientBeginPutBastionShareableLinkOptions) (resp azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientPutBastionShareableLinkResponse]], errResp azfake.ErrorResponder)

	// SupportedSecurityProviders is the fake for method ManagementClient.SupportedSecurityProviders
	// HTTP status codes to indicate success: http.StatusOK
	SupportedSecurityProviders func(ctx context.Context, resourceGroupName string, virtualWANName string, options *armnetwork.ManagementClientSupportedSecurityProvidersOptions) (resp azfake.Responder[armnetwork.ManagementClientSupportedSecurityProvidersResponse], errResp azfake.ErrorResponder)
}

// NewManagementServerTransport creates a new instance of ManagementServerTransport with the provided implementation.
// The returned ManagementServerTransport instance is connected to an instance of armnetwork.ManagementClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementServerTransport(srv *ManagementServer) *ManagementServerTransport {
	return &ManagementServerTransport{
		srv:                                    srv,
		beginDeleteBastionShareableLink:        newTracker[azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkResponse]](),
		beginDeleteBastionShareableLinkByToken: newTracker[azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkByTokenResponse]](),
		newDisconnectActiveSessionsPager:       newTracker[azfake.PagerResponder[armnetwork.ManagementClientDisconnectActiveSessionsResponse]](),
		beginGeneratevirtualwanvpnserverconfigurationvpnprofile: newTracker[azfake.PollerResponder[armnetwork.ManagementClientGeneratevirtualwanvpnserverconfigurationvpnprofileResponse]](),
		beginGetActiveSessions:          newTracker[azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientGetActiveSessionsResponse]]](),
		newGetBastionShareableLinkPager: newTracker[azfake.PagerResponder[armnetwork.ManagementClientGetBastionShareableLinkResponse]](),
		beginPutBastionShareableLink:    newTracker[azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientPutBastionShareableLinkResponse]]](),
	}
}

// ManagementServerTransport connects instances of armnetwork.ManagementClient to instances of ManagementServer.
// Don't use this type directly, use NewManagementServerTransport instead.
type ManagementServerTransport struct {
	srv                                                     *ManagementServer
	beginDeleteBastionShareableLink                         *tracker[azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkResponse]]
	beginDeleteBastionShareableLinkByToken                  *tracker[azfake.PollerResponder[armnetwork.ManagementClientDeleteBastionShareableLinkByTokenResponse]]
	newDisconnectActiveSessionsPager                        *tracker[azfake.PagerResponder[armnetwork.ManagementClientDisconnectActiveSessionsResponse]]
	beginGeneratevirtualwanvpnserverconfigurationvpnprofile *tracker[azfake.PollerResponder[armnetwork.ManagementClientGeneratevirtualwanvpnserverconfigurationvpnprofileResponse]]
	beginGetActiveSessions                                  *tracker[azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientGetActiveSessionsResponse]]]
	newGetBastionShareableLinkPager                         *tracker[azfake.PagerResponder[armnetwork.ManagementClientGetBastionShareableLinkResponse]]
	beginPutBastionShareableLink                            *tracker[azfake.PollerResponder[azfake.PagerResponder[armnetwork.ManagementClientPutBastionShareableLinkResponse]]]
}

// Do implements the policy.Transporter interface for ManagementServerTransport.
func (m *ManagementServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementClient.CheckDNSNameAvailability":
		resp, err = m.dispatchCheckDNSNameAvailability(req)
	case "ManagementClient.BeginDeleteBastionShareableLink":
		resp, err = m.dispatchBeginDeleteBastionShareableLink(req)
	case "ManagementClient.BeginDeleteBastionShareableLinkByToken":
		resp, err = m.dispatchBeginDeleteBastionShareableLinkByToken(req)
	case "ManagementClient.NewDisconnectActiveSessionsPager":
		resp, err = m.dispatchNewDisconnectActiveSessionsPager(req)
	case "ManagementClient.ExpressRouteProviderPort":
		resp, err = m.dispatchExpressRouteProviderPort(req)
	case "ManagementClient.BeginGeneratevirtualwanvpnserverconfigurationvpnprofile":
		resp, err = m.dispatchBeginGeneratevirtualwanvpnserverconfigurationvpnprofile(req)
	case "ManagementClient.BeginGetActiveSessions":
		resp, err = m.dispatchBeginGetActiveSessions(req)
	case "ManagementClient.NewGetBastionShareableLinkPager":
		resp, err = m.dispatchNewGetBastionShareableLinkPager(req)
	case "ManagementClient.ListActiveConnectivityConfigurations":
		resp, err = m.dispatchListActiveConnectivityConfigurations(req)
	case "ManagementClient.ListActiveSecurityAdminRules":
		resp, err = m.dispatchListActiveSecurityAdminRules(req)
	case "ManagementClient.ListNetworkManagerEffectiveConnectivityConfigurations":
		resp, err = m.dispatchListNetworkManagerEffectiveConnectivityConfigurations(req)
	case "ManagementClient.ListNetworkManagerEffectiveSecurityAdminRules":
		resp, err = m.dispatchListNetworkManagerEffectiveSecurityAdminRules(req)
	case "ManagementClient.BeginPutBastionShareableLink":
		resp, err = m.dispatchBeginPutBastionShareableLink(req)
	case "ManagementClient.SupportedSecurityProviders":
		resp, err = m.dispatchSupportedSecurityProviders(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchCheckDNSNameAvailability(req *http.Request) (*http.Response, error) {
	if m.srv.CheckDNSNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckDNSNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/CheckDnsNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	domainNameLabelParam, err := url.QueryUnescape(qp.Get("domainNameLabel"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CheckDNSNameAvailability(req.Context(), locationParam, domainNameLabelParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DNSNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginDeleteBastionShareableLink(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteBastionShareableLink == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteBastionShareableLink not implemented")}
	}
	beginDeleteBastionShareableLink := m.beginDeleteBastionShareableLink.get(req)
	if beginDeleteBastionShareableLink == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteShareableLinks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.BastionShareableLinkListRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteBastionShareableLink(req.Context(), resourceGroupNameParam, bastionHostNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteBastionShareableLink = &respr
		m.beginDeleteBastionShareableLink.add(req, beginDeleteBastionShareableLink)
	}

	resp, err := server.PollerResponderNext(beginDeleteBastionShareableLink, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginDeleteBastionShareableLink.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteBastionShareableLink) {
		m.beginDeleteBastionShareableLink.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginDeleteBastionShareableLinkByToken(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteBastionShareableLinkByToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteBastionShareableLinkByToken not implemented")}
	}
	beginDeleteBastionShareableLinkByToken := m.beginDeleteBastionShareableLinkByToken.get(req)
	if beginDeleteBastionShareableLinkByToken == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteShareableLinksByToken`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.BastionShareableLinkTokenListRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteBastionShareableLinkByToken(req.Context(), resourceGroupNameParam, bastionHostNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteBastionShareableLinkByToken = &respr
		m.beginDeleteBastionShareableLinkByToken.add(req, beginDeleteBastionShareableLinkByToken)
	}

	resp, err := server.PollerResponderNext(beginDeleteBastionShareableLinkByToken, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		m.beginDeleteBastionShareableLinkByToken.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteBastionShareableLinkByToken) {
		m.beginDeleteBastionShareableLinkByToken.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewDisconnectActiveSessionsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewDisconnectActiveSessionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewDisconnectActiveSessionsPager not implemented")}
	}
	newDisconnectActiveSessionsPager := m.newDisconnectActiveSessionsPager.get(req)
	if newDisconnectActiveSessionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disconnectActiveSessions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.SessionIDs](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewDisconnectActiveSessionsPager(resourceGroupNameParam, bastionHostNameParam, body, nil)
		newDisconnectActiveSessionsPager = &resp
		m.newDisconnectActiveSessionsPager.add(req, newDisconnectActiveSessionsPager)
		server.PagerResponderInjectNextLinks(newDisconnectActiveSessionsPager, req, func(page *armnetwork.ManagementClientDisconnectActiveSessionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newDisconnectActiveSessionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newDisconnectActiveSessionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newDisconnectActiveSessionsPager) {
		m.newDisconnectActiveSessionsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchExpressRouteProviderPort(req *http.Request) (*http.Response, error) {
	if m.srv.ExpressRouteProviderPort == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExpressRouteProviderPort not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteProviderPorts/(?P<providerport>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerportParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerport")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ExpressRouteProviderPort(req.Context(), providerportParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExpressRouteProviderPort, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginGeneratevirtualwanvpnserverconfigurationvpnprofile(req *http.Request) (*http.Response, error) {
	if m.srv.BeginGeneratevirtualwanvpnserverconfigurationvpnprofile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGeneratevirtualwanvpnserverconfigurationvpnprofile not implemented")}
	}
	beginGeneratevirtualwanvpnserverconfigurationvpnprofile := m.beginGeneratevirtualwanvpnserverconfigurationvpnprofile.get(req)
	if beginGeneratevirtualwanvpnserverconfigurationvpnprofile == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualWans/(?P<virtualWANName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/GenerateVpnProfile`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VirtualWanVPNProfileParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualWANNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualWANName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginGeneratevirtualwanvpnserverconfigurationvpnprofile(req.Context(), resourceGroupNameParam, virtualWANNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGeneratevirtualwanvpnserverconfigurationvpnprofile = &respr
		m.beginGeneratevirtualwanvpnserverconfigurationvpnprofile.add(req, beginGeneratevirtualwanvpnserverconfigurationvpnprofile)
	}

	resp, err := server.PollerResponderNext(beginGeneratevirtualwanvpnserverconfigurationvpnprofile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginGeneratevirtualwanvpnserverconfigurationvpnprofile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGeneratevirtualwanvpnserverconfigurationvpnprofile) {
		m.beginGeneratevirtualwanvpnserverconfigurationvpnprofile.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginGetActiveSessions(req *http.Request) (*http.Response, error) {
	if m.srv.BeginGetActiveSessions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetActiveSessions not implemented")}
	}
	beginGetActiveSessions := m.beginGetActiveSessions.get(req)
	if beginGetActiveSessions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getActiveSessions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginGetActiveSessions(req.Context(), resourceGroupNameParam, bastionHostNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetActiveSessions = &respr
		m.beginGetActiveSessions.add(req, beginGetActiveSessions)
	}

	resp, err := server.PollerResponderNext(beginGetActiveSessions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginGetActiveSessions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetActiveSessions) {
		m.beginGetActiveSessions.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchNewGetBastionShareableLinkPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewGetBastionShareableLinkPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetBastionShareableLinkPager not implemented")}
	}
	newGetBastionShareableLinkPager := m.newGetBastionShareableLinkPager.get(req)
	if newGetBastionShareableLinkPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getShareableLinks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.BastionShareableLinkListRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewGetBastionShareableLinkPager(resourceGroupNameParam, bastionHostNameParam, body, nil)
		newGetBastionShareableLinkPager = &resp
		m.newGetBastionShareableLinkPager.add(req, newGetBastionShareableLinkPager)
		server.PagerResponderInjectNextLinks(newGetBastionShareableLinkPager, req, func(page *armnetwork.ManagementClientGetBastionShareableLinkResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetBastionShareableLinkPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newGetBastionShareableLinkPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetBastionShareableLinkPager) {
		m.newGetBastionShareableLinkPager.remove(req)
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchListActiveConnectivityConfigurations(req *http.Request) (*http.Response, error) {
	if m.srv.ListActiveConnectivityConfigurations == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListActiveConnectivityConfigurations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkManagers/(?P<networkManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listActiveConnectivityConfigurations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armnetwork.ActiveConfigurationParameter](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkManagerName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armnetwork.ManagementClientListActiveConnectivityConfigurationsOptions
	if topParam != nil {
		options = &armnetwork.ManagementClientListActiveConnectivityConfigurationsOptions{
			Top: topParam,
		}
	}
	respr, errRespr := m.srv.ListActiveConnectivityConfigurations(req.Context(), resourceGroupNameParam, networkManagerNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActiveConnectivityConfigurationsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchListActiveSecurityAdminRules(req *http.Request) (*http.Response, error) {
	if m.srv.ListActiveSecurityAdminRules == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListActiveSecurityAdminRules not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkManagers/(?P<networkManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listActiveSecurityAdminRules`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armnetwork.ActiveConfigurationParameter](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkManagerName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armnetwork.ManagementClientListActiveSecurityAdminRulesOptions
	if topParam != nil {
		options = &armnetwork.ManagementClientListActiveSecurityAdminRulesOptions{
			Top: topParam,
		}
	}
	respr, errRespr := m.srv.ListActiveSecurityAdminRules(req.Context(), resourceGroupNameParam, networkManagerNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActiveSecurityAdminRulesListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchListNetworkManagerEffectiveConnectivityConfigurations(req *http.Request) (*http.Response, error) {
	if m.srv.ListNetworkManagerEffectiveConnectivityConfigurations == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListNetworkManagerEffectiveConnectivityConfigurations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworks/(?P<virtualNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listNetworkManagerEffectiveConnectivityConfigurations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armnetwork.QueryRequestOptions](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armnetwork.ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsOptions
	if topParam != nil {
		options = &armnetwork.ManagementClientListNetworkManagerEffectiveConnectivityConfigurationsOptions{
			Top: topParam,
		}
	}
	respr, errRespr := m.srv.ListNetworkManagerEffectiveConnectivityConfigurations(req.Context(), resourceGroupNameParam, virtualNetworkNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagerEffectiveConnectivityConfigurationListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchListNetworkManagerEffectiveSecurityAdminRules(req *http.Request) (*http.Response, error) {
	if m.srv.ListNetworkManagerEffectiveSecurityAdminRules == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListNetworkManagerEffectiveSecurityAdminRules not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworks/(?P<virtualNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listNetworkManagerEffectiveSecurityAdminRules`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armnetwork.QueryRequestOptions](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armnetwork.ManagementClientListNetworkManagerEffectiveSecurityAdminRulesOptions
	if topParam != nil {
		options = &armnetwork.ManagementClientListNetworkManagerEffectiveSecurityAdminRulesOptions{
			Top: topParam,
		}
	}
	respr, errRespr := m.srv.ListNetworkManagerEffectiveSecurityAdminRules(req.Context(), resourceGroupNameParam, virtualNetworkNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagerEffectiveSecurityAdminRulesListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchBeginPutBastionShareableLink(req *http.Request) (*http.Response, error) {
	if m.srv.BeginPutBastionShareableLink == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPutBastionShareableLink not implemented")}
	}
	beginPutBastionShareableLink := m.beginPutBastionShareableLink.get(req)
	if beginPutBastionShareableLink == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/bastionHosts/(?P<bastionHostName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/createShareableLinks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.BastionShareableLinkListRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bastionHostNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bastionHostName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginPutBastionShareableLink(req.Context(), resourceGroupNameParam, bastionHostNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPutBastionShareableLink = &respr
		m.beginPutBastionShareableLink.add(req, beginPutBastionShareableLink)
	}

	resp, err := server.PollerResponderNext(beginPutBastionShareableLink, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginPutBastionShareableLink.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPutBastionShareableLink) {
		m.beginPutBastionShareableLink.remove(req)
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchSupportedSecurityProviders(req *http.Request) (*http.Response, error) {
	if m.srv.SupportedSecurityProviders == nil {
		return nil, &nonRetriableError{errors.New("fake for method SupportedSecurityProviders not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualWans/(?P<virtualWANName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedSecurityProviders`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualWANNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualWANName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.SupportedSecurityProviders(req.Context(), resourceGroupNameParam, virtualWANNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualWanSecurityProviders, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
