//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/netapp/armnetapp/v6"
	"net/http"
	"net/url"
	"regexp"
)

// BackupsServer is a fake server for instances of the armnetapp.BackupsClient type.
type BackupsServer struct {
	// GetVolumeRestoreStatus is the fake for method BackupsClient.GetVolumeRestoreStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetVolumeRestoreStatus func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.BackupsClientGetVolumeRestoreStatusOptions) (resp azfake.Responder[armnetapp.BackupsClientGetVolumeRestoreStatusResponse], errResp azfake.ErrorResponder)
}

// NewBackupsServerTransport creates a new instance of BackupsServerTransport with the provided implementation.
// The returned BackupsServerTransport instance is connected to an instance of armnetapp.BackupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupsServerTransport(srv *BackupsServer) *BackupsServerTransport {
	return &BackupsServerTransport{srv: srv}
}

// BackupsServerTransport connects instances of armnetapp.BackupsClient to instances of BackupsServer.
// Don't use this type directly, use NewBackupsServerTransport instead.
type BackupsServerTransport struct {
	srv *BackupsServer
}

// Do implements the policy.Transporter interface for BackupsServerTransport.
func (b *BackupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupsClient.GetVolumeRestoreStatus":
		resp, err = b.dispatchGetVolumeRestoreStatus(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupsServerTransport) dispatchGetVolumeRestoreStatus(req *http.Request) (*http.Response, error) {
	if b.srv.GetVolumeRestoreStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVolumeRestoreStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreStatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
	if err != nil {
		return nil, err
	}
	volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetVolumeRestoreStatus(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RestoreStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
