//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// SimsServer is a fake server for instances of the armmobilenetwork.SimsClient type.
type SimsServer struct {
	// BeginBulkDelete is the fake for method SimsClient.BeginBulkDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginBulkDelete func(ctx context.Context, resourceGroupName string, simGroupName string, parameters armmobilenetwork.SimDeleteList, options *armmobilenetwork.SimsClientBeginBulkDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.SimsClientBulkDeleteResponse], errResp azfake.ErrorResponder)

	// BeginBulkUpload is the fake for method SimsClient.BeginBulkUpload
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBulkUpload func(ctx context.Context, resourceGroupName string, simGroupName string, parameters armmobilenetwork.SimUploadList, options *armmobilenetwork.SimsClientBeginBulkUploadOptions) (resp azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadResponse], errResp azfake.ErrorResponder)

	// BeginBulkUploadEncrypted is the fake for method SimsClient.BeginBulkUploadEncrypted
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBulkUploadEncrypted func(ctx context.Context, resourceGroupName string, simGroupName string, parameters armmobilenetwork.EncryptedSimUploadList, options *armmobilenetwork.SimsClientBeginBulkUploadEncryptedOptions) (resp azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadEncryptedResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method SimsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, simGroupName string, simName string, parameters armmobilenetwork.Sim, options *armmobilenetwork.SimsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmobilenetwork.SimsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SimsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, simGroupName string, simName string, options *armmobilenetwork.SimsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.SimsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SimsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, simGroupName string, simName string, options *armmobilenetwork.SimsClientGetOptions) (resp azfake.Responder[armmobilenetwork.SimsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByGroupPager is the fake for method SimsClient.NewListByGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByGroupPager func(resourceGroupName string, simGroupName string, options *armmobilenetwork.SimsClientListByGroupOptions) (resp azfake.PagerResponder[armmobilenetwork.SimsClientListByGroupResponse])
}

// NewSimsServerTransport creates a new instance of SimsServerTransport with the provided implementation.
// The returned SimsServerTransport instance is connected to an instance of armmobilenetwork.SimsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSimsServerTransport(srv *SimsServer) *SimsServerTransport {
	return &SimsServerTransport{
		srv:                      srv,
		beginBulkDelete:          newTracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkDeleteResponse]](),
		beginBulkUpload:          newTracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadResponse]](),
		beginBulkUploadEncrypted: newTracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadEncryptedResponse]](),
		beginCreateOrUpdate:      newTracker[azfake.PollerResponder[armmobilenetwork.SimsClientCreateOrUpdateResponse]](),
		beginDelete:              newTracker[azfake.PollerResponder[armmobilenetwork.SimsClientDeleteResponse]](),
		newListByGroupPager:      newTracker[azfake.PagerResponder[armmobilenetwork.SimsClientListByGroupResponse]](),
	}
}

// SimsServerTransport connects instances of armmobilenetwork.SimsClient to instances of SimsServer.
// Don't use this type directly, use NewSimsServerTransport instead.
type SimsServerTransport struct {
	srv                      *SimsServer
	beginBulkDelete          *tracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkDeleteResponse]]
	beginBulkUpload          *tracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadResponse]]
	beginBulkUploadEncrypted *tracker[azfake.PollerResponder[armmobilenetwork.SimsClientBulkUploadEncryptedResponse]]
	beginCreateOrUpdate      *tracker[azfake.PollerResponder[armmobilenetwork.SimsClientCreateOrUpdateResponse]]
	beginDelete              *tracker[azfake.PollerResponder[armmobilenetwork.SimsClientDeleteResponse]]
	newListByGroupPager      *tracker[azfake.PagerResponder[armmobilenetwork.SimsClientListByGroupResponse]]
}

// Do implements the policy.Transporter interface for SimsServerTransport.
func (s *SimsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SimsClient.BeginBulkDelete":
		resp, err = s.dispatchBeginBulkDelete(req)
	case "SimsClient.BeginBulkUpload":
		resp, err = s.dispatchBeginBulkUpload(req)
	case "SimsClient.BeginBulkUploadEncrypted":
		resp, err = s.dispatchBeginBulkUploadEncrypted(req)
	case "SimsClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "SimsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SimsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SimsClient.NewListByGroupPager":
		resp, err = s.dispatchNewListByGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchBeginBulkDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginBulkDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBulkDelete not implemented")}
	}
	beginBulkDelete := s.beginBulkDelete.get(req)
	if beginBulkDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteSims`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.SimDeleteList](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginBulkDelete(req.Context(), resourceGroupNameParam, simGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBulkDelete = &respr
		s.beginBulkDelete.add(req, beginBulkDelete)
	}

	resp, err := server.PollerResponderNext(beginBulkDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginBulkDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBulkDelete) {
		s.beginBulkDelete.remove(req)
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchBeginBulkUpload(req *http.Request) (*http.Response, error) {
	if s.srv.BeginBulkUpload == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBulkUpload not implemented")}
	}
	beginBulkUpload := s.beginBulkUpload.get(req)
	if beginBulkUpload == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/uploadSims`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.SimUploadList](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginBulkUpload(req.Context(), resourceGroupNameParam, simGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBulkUpload = &respr
		s.beginBulkUpload.add(req, beginBulkUpload)
	}

	resp, err := server.PollerResponderNext(beginBulkUpload, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginBulkUpload.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBulkUpload) {
		s.beginBulkUpload.remove(req)
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchBeginBulkUploadEncrypted(req *http.Request) (*http.Response, error) {
	if s.srv.BeginBulkUploadEncrypted == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBulkUploadEncrypted not implemented")}
	}
	beginBulkUploadEncrypted := s.beginBulkUploadEncrypted.get(req)
	if beginBulkUploadEncrypted == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/uploadEncryptedSims`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.EncryptedSimUploadList](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginBulkUploadEncrypted(req.Context(), resourceGroupNameParam, simGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBulkUploadEncrypted = &respr
		s.beginBulkUploadEncrypted.add(req, beginBulkUploadEncrypted)
	}

	resp, err := server.PollerResponderNext(beginBulkUploadEncrypted, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginBulkUploadEncrypted.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBulkUploadEncrypted) {
		s.beginBulkUploadEncrypted.remove(req)
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sims/(?P<simName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.Sim](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		simNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, simGroupNameParam, simNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sims/(?P<simName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		simNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, simGroupNameParam, simNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SimsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sims/(?P<simName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
	if err != nil {
		return nil, err
	}
	simNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, simGroupNameParam, simNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Sim, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SimsServerTransport) dispatchNewListByGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByGroupPager not implemented")}
	}
	newListByGroupPager := s.newListByGroupPager.get(req)
	if newListByGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/simGroups/(?P<simGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sims`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		simGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("simGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByGroupPager(resourceGroupNameParam, simGroupNameParam, nil)
		newListByGroupPager = &resp
		s.newListByGroupPager.add(req, newListByGroupPager)
		server.PagerResponderInjectNextLinks(newListByGroupPager, req, func(page *armmobilenetwork.SimsClientListByGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByGroupPager) {
		s.newListByGroupPager.remove(req)
	}
	return resp, nil
}
