//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// AttachedDataNetworksServer is a fake server for instances of the armmobilenetwork.AttachedDataNetworksClient type.
type AttachedDataNetworksServer struct {
	// BeginCreateOrUpdate is the fake for method AttachedDataNetworksClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCoreDataPlaneName string, attachedDataNetworkName string, parameters armmobilenetwork.AttachedDataNetwork, options *armmobilenetwork.AttachedDataNetworksClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AttachedDataNetworksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCoreDataPlaneName string, attachedDataNetworkName string, options *armmobilenetwork.AttachedDataNetworksClientBeginDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AttachedDataNetworksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCoreDataPlaneName string, attachedDataNetworkName string, options *armmobilenetwork.AttachedDataNetworksClientGetOptions) (resp azfake.Responder[armmobilenetwork.AttachedDataNetworksClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPacketCoreDataPlanePager is the fake for method AttachedDataNetworksClient.NewListByPacketCoreDataPlanePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPacketCoreDataPlanePager func(resourceGroupName string, packetCoreControlPlaneName string, packetCoreDataPlaneName string, options *armmobilenetwork.AttachedDataNetworksClientListByPacketCoreDataPlaneOptions) (resp azfake.PagerResponder[armmobilenetwork.AttachedDataNetworksClientListByPacketCoreDataPlaneResponse])

	// UpdateTags is the fake for method AttachedDataNetworksClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCoreDataPlaneName string, attachedDataNetworkName string, parameters armmobilenetwork.TagsObject, options *armmobilenetwork.AttachedDataNetworksClientUpdateTagsOptions) (resp azfake.Responder[armmobilenetwork.AttachedDataNetworksClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewAttachedDataNetworksServerTransport creates a new instance of AttachedDataNetworksServerTransport with the provided implementation.
// The returned AttachedDataNetworksServerTransport instance is connected to an instance of armmobilenetwork.AttachedDataNetworksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAttachedDataNetworksServerTransport(srv *AttachedDataNetworksServer) *AttachedDataNetworksServerTransport {
	return &AttachedDataNetworksServerTransport{
		srv:                               srv,
		beginCreateOrUpdate:               newTracker[azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientCreateOrUpdateResponse]](),
		beginDelete:                       newTracker[azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientDeleteResponse]](),
		newListByPacketCoreDataPlanePager: newTracker[azfake.PagerResponder[armmobilenetwork.AttachedDataNetworksClientListByPacketCoreDataPlaneResponse]](),
	}
}

// AttachedDataNetworksServerTransport connects instances of armmobilenetwork.AttachedDataNetworksClient to instances of AttachedDataNetworksServer.
// Don't use this type directly, use NewAttachedDataNetworksServerTransport instead.
type AttachedDataNetworksServerTransport struct {
	srv                               *AttachedDataNetworksServer
	beginCreateOrUpdate               *tracker[azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientCreateOrUpdateResponse]]
	beginDelete                       *tracker[azfake.PollerResponder[armmobilenetwork.AttachedDataNetworksClientDeleteResponse]]
	newListByPacketCoreDataPlanePager *tracker[azfake.PagerResponder[armmobilenetwork.AttachedDataNetworksClientListByPacketCoreDataPlaneResponse]]
}

// Do implements the policy.Transporter interface for AttachedDataNetworksServerTransport.
func (a *AttachedDataNetworksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AttachedDataNetworksClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "AttachedDataNetworksClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AttachedDataNetworksClient.Get":
		resp, err = a.dispatchGet(req)
	case "AttachedDataNetworksClient.NewListByPacketCoreDataPlanePager":
		resp, err = a.dispatchNewListByPacketCoreDataPlanePager(req)
	case "AttachedDataNetworksClient.UpdateTags":
		resp, err = a.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AttachedDataNetworksServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCoreDataPlanes/(?P<packetCoreDataPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDataNetworks/(?P<attachedDataNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.AttachedDataNetwork](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCoreDataPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreDataPlaneName")])
		if err != nil {
			return nil, err
		}
		attachedDataNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDataNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCoreDataPlaneNameParam, attachedDataNetworkNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *AttachedDataNetworksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCoreDataPlanes/(?P<packetCoreDataPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDataNetworks/(?P<attachedDataNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCoreDataPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreDataPlaneName")])
		if err != nil {
			return nil, err
		}
		attachedDataNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDataNetworkName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCoreDataPlaneNameParam, attachedDataNetworkNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AttachedDataNetworksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCoreDataPlanes/(?P<packetCoreDataPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDataNetworks/(?P<attachedDataNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	packetCoreDataPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreDataPlaneName")])
	if err != nil {
		return nil, err
	}
	attachedDataNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDataNetworkName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCoreDataPlaneNameParam, attachedDataNetworkNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AttachedDataNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttachedDataNetworksServerTransport) dispatchNewListByPacketCoreDataPlanePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByPacketCoreDataPlanePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPacketCoreDataPlanePager not implemented")}
	}
	newListByPacketCoreDataPlanePager := a.newListByPacketCoreDataPlanePager.get(req)
	if newListByPacketCoreDataPlanePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCoreDataPlanes/(?P<packetCoreDataPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDataNetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCoreDataPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreDataPlaneName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByPacketCoreDataPlanePager(resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCoreDataPlaneNameParam, nil)
		newListByPacketCoreDataPlanePager = &resp
		a.newListByPacketCoreDataPlanePager.add(req, newListByPacketCoreDataPlanePager)
		server.PagerResponderInjectNextLinks(newListByPacketCoreDataPlanePager, req, func(page *armmobilenetwork.AttachedDataNetworksClientListByPacketCoreDataPlaneResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPacketCoreDataPlanePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByPacketCoreDataPlanePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPacketCoreDataPlanePager) {
		a.newListByPacketCoreDataPlanePager.remove(req)
	}
	return resp, nil
}

func (a *AttachedDataNetworksServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCoreDataPlanes/(?P<packetCoreDataPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachedDataNetworks/(?P<attachedDataNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	packetCoreDataPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreDataPlaneName")])
	if err != nil {
		return nil, err
	}
	attachedDataNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedDataNetworkName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateTags(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCoreDataPlaneNameParam, attachedDataNetworkNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AttachedDataNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
