//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrationdiscoverysap

import "time"

// ConfigurationData - The SAP instance specific configuration data.
type ConfigurationData struct {
	// READ-ONLY; Provide the CPU value of the server. For example, 16, 32 etc.
	CPU *int32

	// READ-ONLY; Provide the CPU clock speed of the server in MHz. This should be a non-zero value. For example, 2100.
	CPUInMhz *int32

	// READ-ONLY; Provide the CPU architecture type of the server. For example, Xeon Platinum 8171M, Xeon E5-2673 v3.
	CPUType *string

	// READ-ONLY; The database of this is a server instance. Applicable only if SAP instance type for this server instance is
	// 'DB'.
	DatabaseType *DatabaseType

	// READ-ONLY; Provide the HW manufacturer company of the server. For example, Microsoft Corporation.
	HardwareManufacturer *string

	// READ-ONLY; Specify if the Hardware is a physical server or virtual machine.
	Model *string

	// READ-ONLY; Provide the RAM of the server. This should be a non-zero value. For example, 256.
	RAM *int32

	// READ-ONLY; Provide the SAPS for each server of the SAP system. This should be a non-zero value. For example, 1000.
	Saps *int32

	// READ-ONLY; Provide the target HANA database size you need. Applicable only if SAP instance type for this server instance
	// is 'DB' and you are migrating an AnyDb database to SAP S/4HANA.
	TargetHanaRAMSizeGB *int32

	// READ-ONLY; Provide the total disk IOPS capacity. Add the disk volume for each individual disk and provide the sum total
	// in this field.
	TotalDiskIops *int32

	// READ-ONLY; Provide the total disk volume capacity in GB. Add the disk volume for each individual disks and provide the
	// total sum in this field.
	TotalDiskSizeGB *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string

	// READ-ONLY; Description of the recommendation.
	Recommendation *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExcelPerformanceData - The SAP instance specific performance data for Excel import.
type ExcelPerformanceData struct {
	// REQUIRED; The data source of the performance data.
	DataSource *DataSource

	// READ-ONLY; Provide the max CPU percentage load on the server. Omit the percentage symbol while filling this value.
	MaxCPULoad *int32

	// READ-ONLY; Provide the source Database size in GB. Applicable only if SAP instance type for this server instance is 'DB'.
	TotalSourceDbSizeGB *int32
}

// GetPerformanceData implements the PerformanceDataClassification interface for type ExcelPerformanceData.
func (e *ExcelPerformanceData) GetPerformanceData() *PerformanceData {
	return &PerformanceData{
		DataSource: e.DataSource,
	}
}

// ExtendedLocation - The extended location definition.
type ExtendedLocation struct {
	// REQUIRED; The extended location name.
	Name *string

	// REQUIRED; The extended location type.
	Type *string
}

// NativePerformanceData - The SAP instance specific performance data for native discovery.
type NativePerformanceData struct {
	// REQUIRED; The data source of the performance data.
	DataSource *DataSource
}

// GetPerformanceData implements the PerformanceDataClassification interface for type NativePerformanceData.
func (n *NativePerformanceData) GetPerformanceData() *PerformanceData {
	return &PerformanceData{
		DataSource: n.DataSource,
	}
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time
}

// PerformanceData - The SAP instance specific performance data.
type PerformanceData struct {
	// REQUIRED; The data source of the performance data.
	DataSource *DataSource
}

// GetPerformanceData implements the PerformanceDataClassification interface for type PerformanceData.
func (p *PerformanceData) GetPerformanceData() *PerformanceData { return p }

// SAPDiscoverySite - Define the SAP Migration discovery site resource.
type SAPDiscoverySite struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extended location definition.
	ExtendedLocation *ExtendedLocation

	// The resource-specific properties for this resource.
	Properties *SAPDiscoverySiteProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPDiscoverySiteListResult - The response of a SAPDiscoverySite list operation.
type SAPDiscoverySiteListResult struct {
	// REQUIRED; The SAPDiscoverySite items on this page
	Value []*SAPDiscoverySite

	// READ-ONLY; The link to the next page of items
	NextLink *string
}

// SAPDiscoverySiteProperties - Defines the SAP Migration discovery site resource properties.
type SAPDiscoverySiteProperties struct {
	// The master site ID from Azure Migrate.
	MasterSiteID *string

	// The migrate project ID from Azure Migrate.
	MigrateProjectID *string

	// READ-ONLY; Indicates any errors on the SAP Migration discovery site resource.
	Errors *SAPMigrateError

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *ProvisioningState
}

// SAPDiscoverySiteTagsUpdate - The type used for updating tags in SAPDiscoverySite resources.
type SAPDiscoverySiteTagsUpdate struct {
	// Resource tags.
	Tags map[string]*string
}

// SAPInstance - Define the SAP Instance resource.
type SAPInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The resource-specific properties for this resource.
	Properties *SAPInstanceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SAPInstanceListResult - The response of a SAPInstance list operation.
type SAPInstanceListResult struct {
	// REQUIRED; The SAPInstance items on this page
	Value []*SAPInstance

	// READ-ONLY; The link to the next page of items
	NextLink *string
}

// SAPInstanceProperties - Defines the SAP Instance properties.
type SAPInstanceProperties struct {
	// READ-ONLY; Enter a business function/department identifier to group multiple SIDs.
	Application *string

	// READ-ONLY; The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown
	// values.
	Environment *SapInstanceEnvironment

	// READ-ONLY; Defines the errors related to SAP Instance resource.
	Errors *SAPMigrateError

	// READ-ONLY; This is the SID of the production system in a landscape. An SAP system could itself be a production SID or a
	// part of a landscape with a different Production SID. This field can be used to relate
	// non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID.
	LandscapeSid *string

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *ProvisioningState

	// READ-ONLY; This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System
	// SID IDs.
	SystemSid *string
}

// SAPInstanceTagsUpdate - The type used for updating tags in SAPInstance resources.
type SAPInstanceTagsUpdate struct {
	// Resource tags.
	Tags map[string]*string
}

// SAPMigrateError - An error response from the SAP migrate resources.
type SAPMigrateError struct {
	// The SAP Discovery site resource error body.
	Properties *ErrorDefinition
}

// ServerInstance - Define the Server Instance resource.
type ServerInstance struct {
	// The resource-specific properties for this resource.
	Properties *ServerInstanceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerInstanceListResult - The response of a ServerInstance list operation.
type ServerInstanceListResult struct {
	// REQUIRED; The ServerInstance items on this page
	Value []*ServerInstance

	// READ-ONLY; The link to the next page of items
	NextLink *string
}

// ServerInstanceProperties - Defines the SAP Instance properties.
type ServerInstanceProperties struct {
	// READ-ONLY; Configuration data for this server instance.
	ConfigurationData *ConfigurationData

	// READ-ONLY; Defines the errors related to SAP Instance resource.
	Errors *SAPMigrateError

	// READ-ONLY; This is the Instance SID for ASCS/AP/DB instance. An SAP system with HANA database for example could have a
	// different SID for database Instance than that of ASCS instance.
	InstanceSid *string

	// READ-ONLY; This is Operating System on which the host server is running.
	OperatingSystem *OperatingSystem

	// READ-ONLY; Configuration data for this server instance.
	PerformanceData PerformanceDataClassification

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Defines the type SAP instance on this server instance.
	SapInstanceType *SapInstanceType

	// READ-ONLY; This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP ENHANCE PACKAGE.
	SapProduct *string

	// READ-ONLY; Provide the product version of the SAP product.
	SapProductVersion *string

	// READ-ONLY; This is the Virtual Machine Name of the SAP system. Add all the virtual machines attached to an SAP system which
	// you wish to migrate to Azure. Keeping this not equal to ID as for single tier all
	// InstanceTypes would be on same server, leading to multiple resources with same servername.
	ServerName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpdateServerInstanceRequest - Defines the request body for updating Server Instances resource.
type UpdateServerInstanceRequest struct {
	// Server instances properties.
	Properties *ServerInstanceProperties
}
