//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlargeinstance

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureLargeInstanceClient contains the methods for the AzureLargeInstance group.
// Don't use this type directly, use NewAzureLargeInstanceClient() instead.
type AzureLargeInstanceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAzureLargeInstanceClient creates a new instance of AzureLargeInstanceClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAzureLargeInstanceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureLargeInstanceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AzureLargeInstanceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets an Azure Large Instance for the specified subscription, resource group, and instance name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureLargeInstanceName - Name of the AzureLargeInstance.
//   - options - AzureLargeInstanceClientGetOptions contains the optional parameters for the AzureLargeInstanceClient.Get method.
func (client *AzureLargeInstanceClient) Get(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientGetOptions) (AzureLargeInstanceClientGetResponse, error) {
	var err error
	const operationName = "AzureLargeInstanceClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, azureLargeInstanceName, options)
	if err != nil {
		return AzureLargeInstanceClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureLargeInstanceClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureLargeInstanceClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AzureLargeInstanceClient) getCreateRequest(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureLargeInstanceName == "" {
		return nil, errors.New("parameter azureLargeInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureLargeInstanceName}", url.PathEscape(azureLargeInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AzureLargeInstanceClient) getHandleResponse(resp *http.Response) (AzureLargeInstanceClientGetResponse, error) {
	result := AzureLargeInstanceClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureLargeInstance); err != nil {
		return AzureLargeInstanceClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets a list of Azure Large Instances in the specified subscription and resource group. The
// operations returns various properties of each Azure Large Instance.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - AzureLargeInstanceClientListByResourceGroupOptions contains the optional parameters for the AzureLargeInstanceClient.NewListByResourceGroupPager
//     method.
func (client *AzureLargeInstanceClient) NewListByResourceGroupPager(resourceGroupName string, options *AzureLargeInstanceClientListByResourceGroupOptions) *runtime.Pager[AzureLargeInstanceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureLargeInstanceClientListByResourceGroupResponse]{
		More: func(page AzureLargeInstanceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureLargeInstanceClientListByResourceGroupResponse) (AzureLargeInstanceClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureLargeInstanceClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return AzureLargeInstanceClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *AzureLargeInstanceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *AzureLargeInstanceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *AzureLargeInstanceClient) listByResourceGroupHandleResponse(resp *http.Response) (AzureLargeInstanceClientListByResourceGroupResponse, error) {
	result := AzureLargeInstanceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureLargeInstanceListResult); err != nil {
		return AzureLargeInstanceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Gets a list of Azure Large Instances in the specified subscription. The operations returns
// various properties of each Azure Large Instance.
//
// Generated from API version 2023-07-20-preview
//   - options - AzureLargeInstanceClientListBySubscriptionOptions contains the optional parameters for the AzureLargeInstanceClient.NewListBySubscriptionPager
//     method.
func (client *AzureLargeInstanceClient) NewListBySubscriptionPager(options *AzureLargeInstanceClientListBySubscriptionOptions) *runtime.Pager[AzureLargeInstanceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureLargeInstanceClientListBySubscriptionResponse]{
		More: func(page AzureLargeInstanceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureLargeInstanceClientListBySubscriptionResponse) (AzureLargeInstanceClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureLargeInstanceClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return AzureLargeInstanceClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *AzureLargeInstanceClient) listBySubscriptionCreateRequest(ctx context.Context, options *AzureLargeInstanceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AzureLargeInstance/azureLargeInstances"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *AzureLargeInstanceClient) listBySubscriptionHandleResponse(resp *http.Response) (AzureLargeInstanceClientListBySubscriptionResponse, error) {
	result := AzureLargeInstanceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureLargeInstanceListResult); err != nil {
		return AzureLargeInstanceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginRestart - The operation to restart an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureLargeInstanceName - Name of the AzureLargeInstance.
//   - options - AzureLargeInstanceClientBeginRestartOptions contains the optional parameters for the AzureLargeInstanceClient.BeginRestart
//     method.
func (client *AzureLargeInstanceClient) BeginRestart(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginRestartOptions) (*runtime.Poller[AzureLargeInstanceClientRestartResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.restart(ctx, resourceGroupName, azureLargeInstanceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[AzureLargeInstanceClientRestartResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[AzureLargeInstanceClientRestartResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Restart - The operation to restart an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
func (client *AzureLargeInstanceClient) restart(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginRestartOptions) (*http.Response, error) {
	var err error
	const operationName = "AzureLargeInstanceClient.BeginRestart"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.restartCreateRequest(ctx, resourceGroupName, azureLargeInstanceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// restartCreateRequest creates the Restart request.
func (client *AzureLargeInstanceClient) restartCreateRequest(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginRestartOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}/restart"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureLargeInstanceName == "" {
		return nil, errors.New("parameter azureLargeInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureLargeInstanceName}", url.PathEscape(azureLargeInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ForceParameter != nil {
		if err := runtime.MarshalAsJSON(req, *options.ForceParameter); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// BeginShutdown - The operation to shutdown an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureLargeInstanceName - Name of the AzureLargeInstance.
//   - options - AzureLargeInstanceClientBeginShutdownOptions contains the optional parameters for the AzureLargeInstanceClient.BeginShutdown
//     method.
func (client *AzureLargeInstanceClient) BeginShutdown(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginShutdownOptions) (*runtime.Poller[AzureLargeInstanceClientShutdownResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.shutdown(ctx, resourceGroupName, azureLargeInstanceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[AzureLargeInstanceClientShutdownResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[AzureLargeInstanceClientShutdownResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Shutdown - The operation to shutdown an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
func (client *AzureLargeInstanceClient) shutdown(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginShutdownOptions) (*http.Response, error) {
	var err error
	const operationName = "AzureLargeInstanceClient.BeginShutdown"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.shutdownCreateRequest(ctx, resourceGroupName, azureLargeInstanceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// shutdownCreateRequest creates the Shutdown request.
func (client *AzureLargeInstanceClient) shutdownCreateRequest(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginShutdownOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}/shutdown"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureLargeInstanceName == "" {
		return nil, errors.New("parameter azureLargeInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureLargeInstanceName}", url.PathEscape(azureLargeInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginStart - The operation to start an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureLargeInstanceName - Name of the AzureLargeInstance.
//   - options - AzureLargeInstanceClientBeginStartOptions contains the optional parameters for the AzureLargeInstanceClient.BeginStart
//     method.
func (client *AzureLargeInstanceClient) BeginStart(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginStartOptions) (*runtime.Poller[AzureLargeInstanceClientStartResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.start(ctx, resourceGroupName, azureLargeInstanceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[AzureLargeInstanceClientStartResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[AzureLargeInstanceClientStartResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Start - The operation to start an Azure Large Instance (only for compute instances)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
func (client *AzureLargeInstanceClient) start(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginStartOptions) (*http.Response, error) {
	var err error
	const operationName = "AzureLargeInstanceClient.BeginStart"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.startCreateRequest(ctx, resourceGroupName, azureLargeInstanceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// startCreateRequest creates the Start request.
func (client *AzureLargeInstanceClient) startCreateRequest(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, options *AzureLargeInstanceClientBeginStartOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}/start"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureLargeInstanceName == "" {
		return nil, errors.New("parameter azureLargeInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureLargeInstanceName}", url.PathEscape(azureLargeInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Patches the Tags field of an Azure Large Instance for the specified subscription, resource group, and instance
// name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-20-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - azureLargeInstanceName - Name of the AzureLargeInstance.
//   - properties - The resource properties to be updated.
//   - options - AzureLargeInstanceClientUpdateOptions contains the optional parameters for the AzureLargeInstanceClient.Update
//     method.
func (client *AzureLargeInstanceClient) Update(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, properties AzureLargeInstanceTagsUpdate, options *AzureLargeInstanceClientUpdateOptions) (AzureLargeInstanceClientUpdateResponse, error) {
	var err error
	const operationName = "AzureLargeInstanceClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, azureLargeInstanceName, properties, options)
	if err != nil {
		return AzureLargeInstanceClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureLargeInstanceClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureLargeInstanceClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *AzureLargeInstanceClient) updateCreateRequest(ctx context.Context, resourceGroupName string, azureLargeInstanceName string, properties AzureLargeInstanceTagsUpdate, options *AzureLargeInstanceClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureLargeInstance/azureLargeInstances/{azureLargeInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if azureLargeInstanceName == "" {
		return nil, errors.New("parameter azureLargeInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{azureLargeInstanceName}", url.PathEscape(azureLargeInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-20-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *AzureLargeInstanceClient) updateHandleResponse(resp *http.Response) (AzureLargeInstanceClientUpdateResponse, error) {
	result := AzureLargeInstanceClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureLargeInstance); err != nil {
		return AzureLargeInstanceClientUpdateResponse{}, err
	}
	return result, nil
}
