//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiotfirmwaredefense_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_ListBySubscription_MaximumSet_Gen.json
func ExampleWorkspacesClient_NewListBySubscriptionPager_workspacesListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceList = armiotfirmwaredefense.WorkspaceList{
		// 	Value: []*armiotfirmwaredefense.Workspace{
		// 		{
		// 			Name: to.Ptr("tbrqhnzpsatbrnhtj"),
		// 			Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
		// 			ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
		// 			SystemData: &armiotfirmwaredefense.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
		// 				CreatedBy: to.Ptr("kmgstbzxtl"),
		// 				CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("rfnhyhbyqzxnumjmjhwkhduztidk"),
		// 				LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
		// 			Tags: map[string]*string{
		// 				"key450": to.Ptr("rzqqumbpfsbibnpirsm"),
		// 			},
		// 			Properties: &armiotfirmwaredefense.WorkspaceProperties{
		// 				ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_ListBySubscription_MinimumSet_Gen.json
func ExampleWorkspacesClient_NewListBySubscriptionPager_workspacesListBySubscriptionMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceList = armiotfirmwaredefense.WorkspaceList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_ListByResourceGroup_MaximumSet_Gen.json
func ExampleWorkspacesClient_NewListByResourceGroupPager_workspacesListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListByResourceGroupPager("rgworkspaces", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceList = armiotfirmwaredefense.WorkspaceList{
		// 	Value: []*armiotfirmwaredefense.Workspace{
		// 		{
		// 			Name: to.Ptr("tbrqhnzpsatbrnhtj"),
		// 			Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
		// 			ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
		// 			SystemData: &armiotfirmwaredefense.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
		// 				CreatedBy: to.Ptr("kmgstbzxtl"),
		// 				CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("rfnhyhbyqzxnumjmjhwkhduztidk"),
		// 				LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
		// 			Tags: map[string]*string{
		// 				"key450": to.Ptr("rzqqumbpfsbibnpirsm"),
		// 			},
		// 			Properties: &armiotfirmwaredefense.WorkspaceProperties{
		// 				ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_ListByResourceGroup_MinimumSet_Gen.json
func ExampleWorkspacesClient_NewListByResourceGroupPager_workspacesListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspacesClient().NewListByResourceGroupPager("rgworkspaces", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkspaceList = armiotfirmwaredefense.WorkspaceList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Create_MaximumSet_Gen.json
func ExampleWorkspacesClient_Create_workspacesCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Create(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.Workspace{
		Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
		Tags: map[string]*string{
			"key450": to.Ptr("rzqqumbpfsbibnpirsm"),
		},
		Properties: &armiotfirmwaredefense.WorkspaceProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Name: to.Ptr("tbrqhnzpsatbrnhtj"),
	// 	Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
	// 		CreatedBy: to.Ptr("kmgstbzxtl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("rfnhyhbyqzxnumjmjhwkhduztidk"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
	// 	Tags: map[string]*string{
	// 		"key450": to.Ptr("rzqqumbpfsbibnpirsm"),
	// 	},
	// 	Properties: &armiotfirmwaredefense.WorkspaceProperties{
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Create_MinimumSet_Gen.json
func ExampleWorkspacesClient_Create_workspacesCreateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Create(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.Workspace{
		Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Name: to.Ptr("tbrqhnzpsatbrnhtj"),
	// 	Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
	// 	Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Update_MaximumSet_Gen.json
func ExampleWorkspacesClient_Update_workspacesUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Update(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.WorkspaceUpdateDefinition{
		Properties: &armiotfirmwaredefense.WorkspaceProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Name: to.Ptr("tbrqhnzpsatbrnhtj"),
	// 	Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
	// 		CreatedBy: to.Ptr("kmgstbzxtl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T05:35:25.545Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("rfnhyhbyqzxnumjmjhwkhduztidk"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
	// 	Tags: map[string]*string{
	// 		"key450": to.Ptr("rzqqumbpfsbibnpirsm"),
	// 	},
	// 	Properties: &armiotfirmwaredefense.WorkspaceProperties{
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Update_MinimumSet_Gen.json
func ExampleWorkspacesClient_Update_workspacesUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Update(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.WorkspaceUpdateDefinition{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Location: to.Ptr("jjwbseilitjgdrhbvvkwviqj"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Delete_MaximumSet_Gen.json
func ExampleWorkspacesClient_Delete_workspacesDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkspacesClient().Delete(ctx, "rgworkspaces", "E___-3", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Delete_MinimumSet_Gen.json
func ExampleWorkspacesClient_Delete_workspacesDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkspacesClient().Delete(ctx, "rgworkspaces", "E___-3", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Get_MaximumSet_Gen.json
func ExampleWorkspacesClient_Get_workspacesGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "rgworkspaces", "E_US", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Name: to.Ptr("vbgktdhddtb"),
	// 	Type: to.Ptr("ux"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-21T14:59:45.580Z"); return t}()),
	// 		CreatedBy: to.Ptr("vnrbl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-21T14:59:45.580Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("zmmusinjpfjqy"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("zxwrauqottoy"),
	// 	Tags: map[string]*string{
	// 		"key6364": to.Ptr("itpmlxzoingnevgitv"),
	// 	},
	// 	Properties: &armiotfirmwaredefense.WorkspaceProperties{
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_Get_MinimumSet_Gen.json
func ExampleWorkspacesClient_Get_workspacesGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().Get(ctx, "rgworkspaces", "E_US", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workspace = armiotfirmwaredefense.Workspace{
	// 	Name: to.Ptr("tbrqhnzpsatbrnhtj"),
	// 	Type: to.Ptr("angrpzpxmuppzqpzpljasjirao"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/workspaces/blah"),
	// 	Location: to.Ptr("zxwrauqottoy"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_GenerateUploadUrl_MaximumSet_Gen.json
func ExampleWorkspacesClient_GenerateUploadURL_workspacesGenerateUploadUrlMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().GenerateUploadURL(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.GenerateUploadURLRequest{
		FirmwareID: to.Ptr("ytsfprbywi"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// 	URL: to.Ptr("https://i/am/a/sas/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Workspaces_GenerateUploadUrl_MinimumSet_Gen.json
func ExampleWorkspacesClient_GenerateUploadURL_workspacesGenerateUploadUrlMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspacesClient().GenerateUploadURL(ctx, "rgworkspaces", "E___-3", armiotfirmwaredefense.GenerateUploadURLRequest{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// }
}
