//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// Client contains the methods for the HybridContainerService group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	internal *arm.Client
}

// NewClient creates a new instance of Client with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*Client, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &Client{
		internal: cl,
	}
	return client, nil
}

// BeginDeleteKubernetesVersions - Delete the default kubernetes versions resource type
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - options - ClientBeginDeleteKubernetesVersionsOptions contains the optional parameters for the Client.BeginDeleteKubernetesVersions
//     method.
func (client *Client) BeginDeleteKubernetesVersions(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteKubernetesVersionsOptions) (*runtime.Poller[ClientDeleteKubernetesVersionsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteKubernetesVersions(ctx, customLocationResourceURI, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteKubernetesVersionsResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteKubernetesVersionsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteKubernetesVersions - Delete the default kubernetes versions resource type
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
func (client *Client) deleteKubernetesVersions(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteKubernetesVersionsOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDeleteKubernetesVersions"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteKubernetesVersionsCreateRequest(ctx, customLocationResourceURI, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteKubernetesVersionsCreateRequest creates the DeleteKubernetesVersions request.
func (client *Client) deleteKubernetesVersionsCreateRequest(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteKubernetesVersionsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/kubernetesVersions/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteVMSKUs - Deletes the default VM skus resource type
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - options - ClientBeginDeleteVMSKUsOptions contains the optional parameters for the Client.BeginDeleteVMSKUs method.
func (client *Client) BeginDeleteVMSKUs(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteVMSKUsOptions) (*runtime.Poller[ClientDeleteVMSKUsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteVMSKUs(ctx, customLocationResourceURI, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteVMSKUsResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteVMSKUsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteVMSKUs - Deletes the default VM skus resource type
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
func (client *Client) deleteVMSKUs(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteVMSKUsOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDeleteVMSKUs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteVMSKUsCreateRequest(ctx, customLocationResourceURI, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteVMSKUsCreateRequest creates the DeleteVMSKUs request.
func (client *Client) deleteVMSKUsCreateRequest(ctx context.Context, customLocationResourceURI string, options *ClientBeginDeleteVMSKUsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/skus/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetKubernetesVersions - Lists the supported kubernetes versions for the specified custom location
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - options - ClientGetKubernetesVersionsOptions contains the optional parameters for the Client.GetKubernetesVersions method.
func (client *Client) GetKubernetesVersions(ctx context.Context, customLocationResourceURI string, options *ClientGetKubernetesVersionsOptions) (ClientGetKubernetesVersionsResponse, error) {
	var err error
	const operationName = "Client.GetKubernetesVersions"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getKubernetesVersionsCreateRequest(ctx, customLocationResourceURI, options)
	if err != nil {
		return ClientGetKubernetesVersionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetKubernetesVersionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetKubernetesVersionsResponse{}, err
	}
	resp, err := client.getKubernetesVersionsHandleResponse(httpResp)
	return resp, err
}

// getKubernetesVersionsCreateRequest creates the GetKubernetesVersions request.
func (client *Client) getKubernetesVersionsCreateRequest(ctx context.Context, customLocationResourceURI string, options *ClientGetKubernetesVersionsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/kubernetesVersions/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKubernetesVersionsHandleResponse handles the GetKubernetesVersions response.
func (client *Client) getKubernetesVersionsHandleResponse(resp *http.Response) (ClientGetKubernetesVersionsResponse, error) {
	result := ClientGetKubernetesVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KubernetesVersionProfile); err != nil {
		return ClientGetKubernetesVersionsResponse{}, err
	}
	return result, nil
}

// GetVMSKUs - Lists the supported VM skus for the specified custom location
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - options - ClientGetVMSKUsOptions contains the optional parameters for the Client.GetVMSKUs method.
func (client *Client) GetVMSKUs(ctx context.Context, customLocationResourceURI string, options *ClientGetVMSKUsOptions) (ClientGetVMSKUsResponse, error) {
	var err error
	const operationName = "Client.GetVMSKUs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getVMSKUsCreateRequest(ctx, customLocationResourceURI, options)
	if err != nil {
		return ClientGetVMSKUsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetVMSKUsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetVMSKUsResponse{}, err
	}
	resp, err := client.getVMSKUsHandleResponse(httpResp)
	return resp, err
}

// getVMSKUsCreateRequest creates the GetVMSKUs request.
func (client *Client) getVMSKUsCreateRequest(ctx context.Context, customLocationResourceURI string, options *ClientGetVMSKUsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/skus/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVMSKUsHandleResponse handles the GetVMSKUs response.
func (client *Client) getVMSKUsHandleResponse(resp *http.Response) (ClientGetVMSKUsResponse, error) {
	result := ClientGetVMSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMSKUProfile); err != nil {
		return ClientGetVMSKUsResponse{}, err
	}
	return result, nil
}

// BeginPutKubernetesVersions - Puts the default kubernetes version resource type (one time operation, before listing the
// kubernetes versions)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - kubernetesVersions - Kubernetes Versions resource definition
//   - options - ClientBeginPutKubernetesVersionsOptions contains the optional parameters for the Client.BeginPutKubernetesVersions
//     method.
func (client *Client) BeginPutKubernetesVersions(ctx context.Context, customLocationResourceURI string, kubernetesVersions KubernetesVersionProfile, options *ClientBeginPutKubernetesVersionsOptions) (*runtime.Poller[ClientPutKubernetesVersionsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.putKubernetesVersions(ctx, customLocationResourceURI, kubernetesVersions, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientPutKubernetesVersionsResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientPutKubernetesVersionsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PutKubernetesVersions - Puts the default kubernetes version resource type (one time operation, before listing the kubernetes
// versions)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
func (client *Client) putKubernetesVersions(ctx context.Context, customLocationResourceURI string, kubernetesVersions KubernetesVersionProfile, options *ClientBeginPutKubernetesVersionsOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginPutKubernetesVersions"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.putKubernetesVersionsCreateRequest(ctx, customLocationResourceURI, kubernetesVersions, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// putKubernetesVersionsCreateRequest creates the PutKubernetesVersions request.
func (client *Client) putKubernetesVersionsCreateRequest(ctx context.Context, customLocationResourceURI string, kubernetesVersions KubernetesVersionProfile, options *ClientBeginPutKubernetesVersionsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/kubernetesVersions/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, kubernetesVersions); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginPutVMSKUs - Puts the default VM skus resource type (one time operation, before listing the VM skus)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
//   - customLocationResourceURI - The fully qualified Azure Resource Manager identifier of the custom location resource.
//   - skus - VM SKUs resource definition
//   - options - ClientBeginPutVMSKUsOptions contains the optional parameters for the Client.BeginPutVMSKUs method.
func (client *Client) BeginPutVMSKUs(ctx context.Context, customLocationResourceURI string, skus VMSKUProfile, options *ClientBeginPutVMSKUsOptions) (*runtime.Poller[ClientPutVMSKUsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.putVMSKUs(ctx, customLocationResourceURI, skus, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientPutVMSKUsResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientPutVMSKUsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PutVMSKUs - Puts the default VM skus resource type (one time operation, before listing the VM skus)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-01
func (client *Client) putVMSKUs(ctx context.Context, customLocationResourceURI string, skus VMSKUProfile, options *ClientBeginPutVMSKUsOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginPutVMSKUs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.putVMSKUsCreateRequest(ctx, customLocationResourceURI, skus, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// putVMSKUsCreateRequest creates the PutVMSKUs request.
func (client *Client) putVMSKUsCreateRequest(ctx context.Context, customLocationResourceURI string, skus VMSKUProfile, options *ClientBeginPutVMSKUsOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/skus/default"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, skus); err != nil {
		return nil, err
	}
	return req, nil
}
