//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsightcontainers/armhdinsightcontainers"
	"net/http"
	"net/url"
	"regexp"
)

// ClustersServer is a fake server for instances of the armhdinsightcontainers.ClustersClient type.
type ClustersServer struct {
	// BeginCreate is the fake for method ClustersClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, hdInsightCluster armhdinsightcontainers.Cluster, options *armhdinsightcontainers.ClustersClientBeginCreateOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClustersClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ClustersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClustersClientBeginDeleteOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClustersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ClustersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClustersClientGetOptions) (resp azfake.Responder[armhdinsightcontainers.ClustersClientGetResponse], errResp azfake.ErrorResponder)

	// GetInstanceView is the fake for method ClustersClient.GetInstanceView
	// HTTP status codes to indicate success: http.StatusOK
	GetInstanceView func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClustersClientGetInstanceViewOptions) (resp azfake.Responder[armhdinsightcontainers.ClustersClientGetInstanceViewResponse], errResp azfake.ErrorResponder)

	// NewListByClusterPoolNamePager is the fake for method ClustersClient.NewListByClusterPoolNamePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByClusterPoolNamePager func(resourceGroupName string, clusterPoolName string, options *armhdinsightcontainers.ClustersClientListByClusterPoolNameOptions) (resp azfake.PagerResponder[armhdinsightcontainers.ClustersClientListByClusterPoolNameResponse])

	// NewListInstanceViewsPager is the fake for method ClustersClient.NewListInstanceViewsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInstanceViewsPager func(resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClustersClientListInstanceViewsOptions) (resp azfake.PagerResponder[armhdinsightcontainers.ClustersClientListInstanceViewsResponse])

	// NewListServiceConfigsPager is the fake for method ClustersClient.NewListServiceConfigsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListServiceConfigsPager func(resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClustersClientListServiceConfigsOptions) (resp azfake.PagerResponder[armhdinsightcontainers.ClustersClientListServiceConfigsResponse])

	// BeginResize is the fake for method ClustersClient.BeginResize
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResize func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, clusterResizeRequest armhdinsightcontainers.ClusterResizeData, options *armhdinsightcontainers.ClustersClientBeginResizeOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClustersClientResizeResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ClustersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, clusterPatchRequest armhdinsightcontainers.ClusterPatch, options *armhdinsightcontainers.ClustersClientBeginUpdateOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpgrade is the fake for method ClustersClient.BeginUpgrade
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpgrade func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, clusterUpgradeRequest armhdinsightcontainers.ClusterUpgrade, options *armhdinsightcontainers.ClustersClientBeginUpgradeOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpgradeResponse], errResp azfake.ErrorResponder)
}

// NewClustersServerTransport creates a new instance of ClustersServerTransport with the provided implementation.
// The returned ClustersServerTransport instance is connected to an instance of armhdinsightcontainers.ClustersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewClustersServerTransport(srv *ClustersServer) *ClustersServerTransport {
	return &ClustersServerTransport{
		srv:                           srv,
		beginCreate:                   newTracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientCreateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientDeleteResponse]](),
		newListByClusterPoolNamePager: newTracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListByClusterPoolNameResponse]](),
		newListInstanceViewsPager:     newTracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListInstanceViewsResponse]](),
		newListServiceConfigsPager:    newTracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListServiceConfigsResponse]](),
		beginResize:                   newTracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientResizeResponse]](),
		beginUpdate:                   newTracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpdateResponse]](),
		beginUpgrade:                  newTracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpgradeResponse]](),
	}
}

// ClustersServerTransport connects instances of armhdinsightcontainers.ClustersClient to instances of ClustersServer.
// Don't use this type directly, use NewClustersServerTransport instead.
type ClustersServerTransport struct {
	srv                           *ClustersServer
	beginCreate                   *tracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientCreateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientDeleteResponse]]
	newListByClusterPoolNamePager *tracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListByClusterPoolNameResponse]]
	newListInstanceViewsPager     *tracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListInstanceViewsResponse]]
	newListServiceConfigsPager    *tracker[azfake.PagerResponder[armhdinsightcontainers.ClustersClientListServiceConfigsResponse]]
	beginResize                   *tracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientResizeResponse]]
	beginUpdate                   *tracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpdateResponse]]
	beginUpgrade                  *tracker[azfake.PollerResponder[armhdinsightcontainers.ClustersClientUpgradeResponse]]
}

// Do implements the policy.Transporter interface for ClustersServerTransport.
func (c *ClustersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ClustersClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "ClustersClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ClustersClient.Get":
		resp, err = c.dispatchGet(req)
	case "ClustersClient.GetInstanceView":
		resp, err = c.dispatchGetInstanceView(req)
	case "ClustersClient.NewListByClusterPoolNamePager":
		resp, err = c.dispatchNewListByClusterPoolNamePager(req)
	case "ClustersClient.NewListInstanceViewsPager":
		resp, err = c.dispatchNewListInstanceViewsPager(req)
	case "ClustersClient.NewListServiceConfigsPager":
		resp, err = c.dispatchNewListServiceConfigsPager(req)
	case "ClustersClient.BeginResize":
		resp, err = c.dispatchBeginResize(req)
	case "ClustersClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	case "ClustersClient.BeginUpgrade":
		resp, err = c.dispatchBeginUpgrade(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsightcontainers.Cluster](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Cluster, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchGetInstanceView(req *http.Request) (*http.Response, error) {
	if c.srv.GetInstanceView == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInstanceView not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceViews/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetInstanceView(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterInstanceViewResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListByClusterPoolNamePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByClusterPoolNamePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByClusterPoolNamePager not implemented")}
	}
	newListByClusterPoolNamePager := c.newListByClusterPoolNamePager.get(req)
	if newListByClusterPoolNamePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByClusterPoolNamePager(resourceGroupNameParam, clusterPoolNameParam, nil)
		newListByClusterPoolNamePager = &resp
		c.newListByClusterPoolNamePager.add(req, newListByClusterPoolNamePager)
		server.PagerResponderInjectNextLinks(newListByClusterPoolNamePager, req, func(page *armhdinsightcontainers.ClustersClientListByClusterPoolNameResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByClusterPoolNamePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByClusterPoolNamePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByClusterPoolNamePager) {
		c.newListByClusterPoolNamePager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListInstanceViewsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListInstanceViewsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInstanceViewsPager not implemented")}
	}
	newListInstanceViewsPager := c.newListInstanceViewsPager.get(req)
	if newListInstanceViewsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instanceViews`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListInstanceViewsPager(resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, nil)
		newListInstanceViewsPager = &resp
		c.newListInstanceViewsPager.add(req, newListInstanceViewsPager)
		server.PagerResponderInjectNextLinks(newListInstanceViewsPager, req, func(page *armhdinsightcontainers.ClustersClientListInstanceViewsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInstanceViewsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListInstanceViewsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInstanceViewsPager) {
		c.newListInstanceViewsPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListServiceConfigsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListServiceConfigsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListServiceConfigsPager not implemented")}
	}
	newListServiceConfigsPager := c.newListServiceConfigsPager.get(req)
	if newListServiceConfigsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serviceConfigs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListServiceConfigsPager(resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, nil)
		newListServiceConfigsPager = &resp
		c.newListServiceConfigsPager.add(req, newListServiceConfigsPager)
		server.PagerResponderInjectNextLinks(newListServiceConfigsPager, req, func(page *armhdinsightcontainers.ClustersClientListServiceConfigsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListServiceConfigsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListServiceConfigsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListServiceConfigsPager) {
		c.newListServiceConfigsPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginResize(req *http.Request) (*http.Response, error) {
	if c.srv.BeginResize == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResize not implemented")}
	}
	beginResize := c.beginResize.get(req)
	if beginResize == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resize`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsightcontainers.ClusterResizeData](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginResize(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResize = &respr
		c.beginResize.add(req, beginResize)
	}

	resp, err := server.PollerResponderNext(beginResize, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginResize.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResize) {
		c.beginResize.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsightcontainers.ClusterPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginUpgrade(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpgrade == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgrade not implemented")}
	}
	beginUpgrade := c.beginUpgrade.get(req)
	if beginUpgrade == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsightcontainers.ClusterUpgrade](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpgrade(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgrade = &respr
		c.beginUpgrade.add(req, beginUpgrade)
	}

	resp, err := server.PollerResponderNext(beginUpgrade, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpgrade.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgrade) {
		c.beginUpgrade.remove(req)
	}

	return resp, nil
}
