//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeventgrid_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_Get.json
func ExampleNamespaceTopicsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespaceTopicsClient().Get(ctx, "examplerg", "examplenamespace2", "examplenamespacetopic2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceTopic = armeventgrid.NamespaceTopic{
	// 	Name: to.Ptr("examplenamespacetopic2"),
	// 	Type: to.Ptr("Microsoft.EventGrid/namespaces/topics"),
	// 	ID: to.Ptr("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e41/resourceGroups/examplerg/providers/Microsoft.EventGrid/namespaces/examplenamespace2/topics/examplenamespacetopic2"),
	// 	Properties: &armeventgrid.NamespaceTopicProperties{
	// 		EventRetentionInDays: to.Ptr[int32](1),
	// 		InputSchema: to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
	// 		ProvisioningState: to.Ptr(armeventgrid.NamespaceTopicProvisioningStateSucceeded),
	// 		PublisherType: to.Ptr(armeventgrid.PublisherTypeCustom),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_CreateOrUpdate.json
func ExampleNamespaceTopicsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespaceTopicsClient().BeginCreateOrUpdate(ctx, "examplerg", "examplenamespace2", "examplenamespacetopic2", armeventgrid.NamespaceTopic{
		Properties: &armeventgrid.NamespaceTopicProperties{
			EventRetentionInDays: to.Ptr[int32](1),
			InputSchema:          to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
			PublisherType:        to.Ptr(armeventgrid.PublisherTypeCustom),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceTopic = armeventgrid.NamespaceTopic{
	// 	Name: to.Ptr("examplenamespacetopic2"),
	// 	Type: to.Ptr("Microsoft.EventGrid/namespaces/topics"),
	// 	ID: to.Ptr("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/namespaces/examplenamespace2/topics/examplenamespacetopic2"),
	// 	Properties: &armeventgrid.NamespaceTopicProperties{
	// 		EventRetentionInDays: to.Ptr[int32](1),
	// 		InputSchema: to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
	// 		ProvisioningState: to.Ptr(armeventgrid.NamespaceTopicProvisioningStateSucceeded),
	// 		PublisherType: to.Ptr(armeventgrid.PublisherTypeCustom),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_Delete.json
func ExampleNamespaceTopicsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespaceTopicsClient().BeginDelete(ctx, "examplerg", "examplenamespace2", "examplenamespacetopic2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_Update.json
func ExampleNamespaceTopicsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespaceTopicsClient().BeginUpdate(ctx, "examplerg", "exampleNamespaceName1", "exampleNamespaceTopicName1", armeventgrid.NamespaceTopicUpdateParameters{
		Properties: &armeventgrid.NamespaceTopicUpdateParameterProperties{
			EventRetentionInDays: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceTopic = armeventgrid.NamespaceTopic{
	// 	Name: to.Ptr("examplenamespacetopic2"),
	// 	Type: to.Ptr("Microsoft.EventGrid/namespaces/topics"),
	// 	ID: to.Ptr("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/namespaces/exampleNamespaceName1/topics/exampleNamespaceTopicName1"),
	// 	Properties: &armeventgrid.NamespaceTopicProperties{
	// 		EventRetentionInDays: to.Ptr[int32](1),
	// 		InputSchema: to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
	// 		ProvisioningState: to.Ptr(armeventgrid.NamespaceTopicProvisioningStateSucceeded),
	// 		PublisherType: to.Ptr(armeventgrid.PublisherTypeCustom),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_ListByNamespace.json
func ExampleNamespaceTopicsClient_NewListByNamespacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespaceTopicsClient().NewListByNamespacePager("examplerg", "examplenamespace2", &armeventgrid.NamespaceTopicsClientListByNamespaceOptions{Filter: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NamespaceTopicsListResult = armeventgrid.NamespaceTopicsListResult{
		// 	Value: []*armeventgrid.NamespaceTopic{
		// 		{
		// 			Name: to.Ptr("examplenamespacetopic2"),
		// 			Type: to.Ptr("Microsoft.EventGrid/namespaces/topics"),
		// 			ID: to.Ptr("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/namespaces/examplenamespace2/topics/examplenamespacetopic2"),
		// 			Properties: &armeventgrid.NamespaceTopicProperties{
		// 				EventRetentionInDays: to.Ptr[int32](1),
		// 				InputSchema: to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
		// 				ProvisioningState: to.Ptr(armeventgrid.NamespaceTopicProvisioningStateSucceeded),
		// 				PublisherType: to.Ptr(armeventgrid.PublisherTypeCustom),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("examplenamespacetopic4"),
		// 			Type: to.Ptr("Microsoft.EventGrid/namespaces/topics"),
		// 			ID: to.Ptr("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/namespaces/examplenamespace2/topics/examplenamespacetopic4"),
		// 			Properties: &armeventgrid.NamespaceTopicProperties{
		// 				EventRetentionInDays: to.Ptr[int32](1),
		// 				InputSchema: to.Ptr(armeventgrid.EventInputSchemaCloudEventSchemaV10),
		// 				ProvisioningState: to.Ptr(armeventgrid.NamespaceTopicProvisioningStateSucceeded),
		// 				PublisherType: to.Ptr(armeventgrid.PublisherTypeCustom),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_ListSharedAccessKeys.json
func ExampleNamespaceTopicsClient_ListSharedAccessKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespaceTopicsClient().ListSharedAccessKeys(ctx, "examplerg", "examplenamespace2", "examplenamespacetopic2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TopicSharedAccessKeys = armeventgrid.TopicSharedAccessKeys{
	// 	Key1: to.Ptr("testKey1Value"),
	// 	Key2: to.Ptr("testKey2Value"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8691fbfca8fcdc5a241a0b501c32fd4a76bb0cd/specification/eventgrid/resource-manager/Microsoft.EventGrid/preview/2024-06-01-preview/examples/NamespaceTopics_RegenerateKey.json
func ExampleNamespaceTopicsClient_BeginRegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventgrid.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespaceTopicsClient().BeginRegenerateKey(ctx, "examplerg", "examplenamespace2", "examplenamespacetopic2", armeventgrid.TopicRegenerateKeyRequest{
		KeyName: to.Ptr("key1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TopicSharedAccessKeys = armeventgrid.TopicSharedAccessKeys{
	// 	Key1: to.Ptr("testKey1Value"),
	// 	Key2: to.Ptr("testKey2Value"),
	// }
}
