//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid"
	moduleVersion = "v2.3.0-beta.2"
)

// AdvancedFilterOperatorType - The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
type AdvancedFilterOperatorType string

const (
	AdvancedFilterOperatorTypeBoolEquals                AdvancedFilterOperatorType = "BoolEquals"
	AdvancedFilterOperatorTypeIsNotNull                 AdvancedFilterOperatorType = "IsNotNull"
	AdvancedFilterOperatorTypeIsNullOrUndefined         AdvancedFilterOperatorType = "IsNullOrUndefined"
	AdvancedFilterOperatorTypeNumberGreaterThan         AdvancedFilterOperatorType = "NumberGreaterThan"
	AdvancedFilterOperatorTypeNumberGreaterThanOrEquals AdvancedFilterOperatorType = "NumberGreaterThanOrEquals"
	AdvancedFilterOperatorTypeNumberIn                  AdvancedFilterOperatorType = "NumberIn"
	AdvancedFilterOperatorTypeNumberInRange             AdvancedFilterOperatorType = "NumberInRange"
	AdvancedFilterOperatorTypeNumberLessThan            AdvancedFilterOperatorType = "NumberLessThan"
	AdvancedFilterOperatorTypeNumberLessThanOrEquals    AdvancedFilterOperatorType = "NumberLessThanOrEquals"
	AdvancedFilterOperatorTypeNumberNotIn               AdvancedFilterOperatorType = "NumberNotIn"
	AdvancedFilterOperatorTypeNumberNotInRange          AdvancedFilterOperatorType = "NumberNotInRange"
	AdvancedFilterOperatorTypeStringBeginsWith          AdvancedFilterOperatorType = "StringBeginsWith"
	AdvancedFilterOperatorTypeStringContains            AdvancedFilterOperatorType = "StringContains"
	AdvancedFilterOperatorTypeStringEndsWith            AdvancedFilterOperatorType = "StringEndsWith"
	AdvancedFilterOperatorTypeStringIn                  AdvancedFilterOperatorType = "StringIn"
	AdvancedFilterOperatorTypeStringNotBeginsWith       AdvancedFilterOperatorType = "StringNotBeginsWith"
	AdvancedFilterOperatorTypeStringNotContains         AdvancedFilterOperatorType = "StringNotContains"
	AdvancedFilterOperatorTypeStringNotEndsWith         AdvancedFilterOperatorType = "StringNotEndsWith"
	AdvancedFilterOperatorTypeStringNotIn               AdvancedFilterOperatorType = "StringNotIn"
)

// PossibleAdvancedFilterOperatorTypeValues returns the possible values for the AdvancedFilterOperatorType const type.
func PossibleAdvancedFilterOperatorTypeValues() []AdvancedFilterOperatorType {
	return []AdvancedFilterOperatorType{
		AdvancedFilterOperatorTypeBoolEquals,
		AdvancedFilterOperatorTypeIsNotNull,
		AdvancedFilterOperatorTypeIsNullOrUndefined,
		AdvancedFilterOperatorTypeNumberGreaterThan,
		AdvancedFilterOperatorTypeNumberGreaterThanOrEquals,
		AdvancedFilterOperatorTypeNumberIn,
		AdvancedFilterOperatorTypeNumberInRange,
		AdvancedFilterOperatorTypeNumberLessThan,
		AdvancedFilterOperatorTypeNumberLessThanOrEquals,
		AdvancedFilterOperatorTypeNumberNotIn,
		AdvancedFilterOperatorTypeNumberNotInRange,
		AdvancedFilterOperatorTypeStringBeginsWith,
		AdvancedFilterOperatorTypeStringContains,
		AdvancedFilterOperatorTypeStringEndsWith,
		AdvancedFilterOperatorTypeStringIn,
		AdvancedFilterOperatorTypeStringNotBeginsWith,
		AdvancedFilterOperatorTypeStringNotContains,
		AdvancedFilterOperatorTypeStringNotEndsWith,
		AdvancedFilterOperatorTypeStringNotIn,
	}
}

// AlternativeAuthenticationNameSource - Alternative authentication name sources related to client authentication settings
// for namespace resource.
type AlternativeAuthenticationNameSource string

const (
	AlternativeAuthenticationNameSourceClientCertificateDNS     AlternativeAuthenticationNameSource = "ClientCertificateDns"
	AlternativeAuthenticationNameSourceClientCertificateEmail   AlternativeAuthenticationNameSource = "ClientCertificateEmail"
	AlternativeAuthenticationNameSourceClientCertificateIP      AlternativeAuthenticationNameSource = "ClientCertificateIp"
	AlternativeAuthenticationNameSourceClientCertificateSubject AlternativeAuthenticationNameSource = "ClientCertificateSubject"
	AlternativeAuthenticationNameSourceClientCertificateURI     AlternativeAuthenticationNameSource = "ClientCertificateUri"
)

// PossibleAlternativeAuthenticationNameSourceValues returns the possible values for the AlternativeAuthenticationNameSource const type.
func PossibleAlternativeAuthenticationNameSourceValues() []AlternativeAuthenticationNameSource {
	return []AlternativeAuthenticationNameSource{
		AlternativeAuthenticationNameSourceClientCertificateDNS,
		AlternativeAuthenticationNameSourceClientCertificateEmail,
		AlternativeAuthenticationNameSourceClientCertificateIP,
		AlternativeAuthenticationNameSourceClientCertificateSubject,
		AlternativeAuthenticationNameSourceClientCertificateURI,
	}
}

// CaCertificateProvisioningState - Provisioning state of the CA Certificate resource.
type CaCertificateProvisioningState string

const (
	CaCertificateProvisioningStateCanceled  CaCertificateProvisioningState = "Canceled"
	CaCertificateProvisioningStateCreating  CaCertificateProvisioningState = "Creating"
	CaCertificateProvisioningStateDeleted   CaCertificateProvisioningState = "Deleted"
	CaCertificateProvisioningStateDeleting  CaCertificateProvisioningState = "Deleting"
	CaCertificateProvisioningStateFailed    CaCertificateProvisioningState = "Failed"
	CaCertificateProvisioningStateSucceeded CaCertificateProvisioningState = "Succeeded"
	CaCertificateProvisioningStateUpdating  CaCertificateProvisioningState = "Updating"
)

// PossibleCaCertificateProvisioningStateValues returns the possible values for the CaCertificateProvisioningState const type.
func PossibleCaCertificateProvisioningStateValues() []CaCertificateProvisioningState {
	return []CaCertificateProvisioningState{
		CaCertificateProvisioningStateCanceled,
		CaCertificateProvisioningStateCreating,
		CaCertificateProvisioningStateDeleted,
		CaCertificateProvisioningStateDeleting,
		CaCertificateProvisioningStateFailed,
		CaCertificateProvisioningStateSucceeded,
		CaCertificateProvisioningStateUpdating,
	}
}

// ChannelProvisioningState - Provisioning state of the channel.
type ChannelProvisioningState string

const (
	ChannelProvisioningStateCanceled                                    ChannelProvisioningState = "Canceled"
	ChannelProvisioningStateCreating                                    ChannelProvisioningState = "Creating"
	ChannelProvisioningStateDeleting                                    ChannelProvisioningState = "Deleting"
	ChannelProvisioningStateFailed                                      ChannelProvisioningState = "Failed"
	ChannelProvisioningStateIdleDueToMirroredPartnerDestinationDeletion ChannelProvisioningState = "IdleDueToMirroredPartnerDestinationDeletion"
	ChannelProvisioningStateIdleDueToMirroredPartnerTopicDeletion       ChannelProvisioningState = "IdleDueToMirroredPartnerTopicDeletion"
	ChannelProvisioningStateSucceeded                                   ChannelProvisioningState = "Succeeded"
	ChannelProvisioningStateUpdating                                    ChannelProvisioningState = "Updating"
)

// PossibleChannelProvisioningStateValues returns the possible values for the ChannelProvisioningState const type.
func PossibleChannelProvisioningStateValues() []ChannelProvisioningState {
	return []ChannelProvisioningState{
		ChannelProvisioningStateCanceled,
		ChannelProvisioningStateCreating,
		ChannelProvisioningStateDeleting,
		ChannelProvisioningStateFailed,
		ChannelProvisioningStateIdleDueToMirroredPartnerDestinationDeletion,
		ChannelProvisioningStateIdleDueToMirroredPartnerTopicDeletion,
		ChannelProvisioningStateSucceeded,
		ChannelProvisioningStateUpdating,
	}
}

// ChannelType - The type of the event channel which represents the direction flow of events.
type ChannelType string

const (
	ChannelTypePartnerDestination ChannelType = "PartnerDestination"
	ChannelTypePartnerTopic       ChannelType = "PartnerTopic"
)

// PossibleChannelTypeValues returns the possible values for the ChannelType const type.
func PossibleChannelTypeValues() []ChannelType {
	return []ChannelType{
		ChannelTypePartnerDestination,
		ChannelTypePartnerTopic,
	}
}

// ClientCertificateValidationScheme - The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
type ClientCertificateValidationScheme string

const (
	ClientCertificateValidationSchemeDNSMatchesAuthenticationName     ClientCertificateValidationScheme = "DnsMatchesAuthenticationName"
	ClientCertificateValidationSchemeEmailMatchesAuthenticationName   ClientCertificateValidationScheme = "EmailMatchesAuthenticationName"
	ClientCertificateValidationSchemeIPMatchesAuthenticationName      ClientCertificateValidationScheme = "IpMatchesAuthenticationName"
	ClientCertificateValidationSchemeSubjectMatchesAuthenticationName ClientCertificateValidationScheme = "SubjectMatchesAuthenticationName"
	ClientCertificateValidationSchemeThumbprintMatch                  ClientCertificateValidationScheme = "ThumbprintMatch"
	ClientCertificateValidationSchemeURIMatchesAuthenticationName     ClientCertificateValidationScheme = "UriMatchesAuthenticationName"
)

// PossibleClientCertificateValidationSchemeValues returns the possible values for the ClientCertificateValidationScheme const type.
func PossibleClientCertificateValidationSchemeValues() []ClientCertificateValidationScheme {
	return []ClientCertificateValidationScheme{
		ClientCertificateValidationSchemeDNSMatchesAuthenticationName,
		ClientCertificateValidationSchemeEmailMatchesAuthenticationName,
		ClientCertificateValidationSchemeIPMatchesAuthenticationName,
		ClientCertificateValidationSchemeSubjectMatchesAuthenticationName,
		ClientCertificateValidationSchemeThumbprintMatch,
		ClientCertificateValidationSchemeURIMatchesAuthenticationName,
	}
}

// ClientGroupProvisioningState - Provisioning state of the ClientGroup resource.
type ClientGroupProvisioningState string

const (
	ClientGroupProvisioningStateCanceled  ClientGroupProvisioningState = "Canceled"
	ClientGroupProvisioningStateCreating  ClientGroupProvisioningState = "Creating"
	ClientGroupProvisioningStateDeleted   ClientGroupProvisioningState = "Deleted"
	ClientGroupProvisioningStateDeleting  ClientGroupProvisioningState = "Deleting"
	ClientGroupProvisioningStateFailed    ClientGroupProvisioningState = "Failed"
	ClientGroupProvisioningStateSucceeded ClientGroupProvisioningState = "Succeeded"
	ClientGroupProvisioningStateUpdating  ClientGroupProvisioningState = "Updating"
)

// PossibleClientGroupProvisioningStateValues returns the possible values for the ClientGroupProvisioningState const type.
func PossibleClientGroupProvisioningStateValues() []ClientGroupProvisioningState {
	return []ClientGroupProvisioningState{
		ClientGroupProvisioningStateCanceled,
		ClientGroupProvisioningStateCreating,
		ClientGroupProvisioningStateDeleted,
		ClientGroupProvisioningStateDeleting,
		ClientGroupProvisioningStateFailed,
		ClientGroupProvisioningStateSucceeded,
		ClientGroupProvisioningStateUpdating,
	}
}

// ClientProvisioningState - Provisioning state of the Client resource.
type ClientProvisioningState string

const (
	ClientProvisioningStateCanceled  ClientProvisioningState = "Canceled"
	ClientProvisioningStateCreating  ClientProvisioningState = "Creating"
	ClientProvisioningStateDeleted   ClientProvisioningState = "Deleted"
	ClientProvisioningStateDeleting  ClientProvisioningState = "Deleting"
	ClientProvisioningStateFailed    ClientProvisioningState = "Failed"
	ClientProvisioningStateSucceeded ClientProvisioningState = "Succeeded"
	ClientProvisioningStateUpdating  ClientProvisioningState = "Updating"
)

// PossibleClientProvisioningStateValues returns the possible values for the ClientProvisioningState const type.
func PossibleClientProvisioningStateValues() []ClientProvisioningState {
	return []ClientProvisioningState{
		ClientProvisioningStateCanceled,
		ClientProvisioningStateCreating,
		ClientProvisioningStateDeleted,
		ClientProvisioningStateDeleting,
		ClientProvisioningStateFailed,
		ClientProvisioningStateSucceeded,
		ClientProvisioningStateUpdating,
	}
}

// ClientState - Indicates if the client is enabled or not. Default value is Enabled.
type ClientState string

const (
	ClientStateDisabled ClientState = "Disabled"
	ClientStateEnabled  ClientState = "Enabled"
)

// PossibleClientStateValues returns the possible values for the ClientState const type.
func PossibleClientStateValues() []ClientState {
	return []ClientState{
		ClientStateDisabled,
		ClientStateEnabled,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// CustomDomainIdentityType - The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
type CustomDomainIdentityType string

const (
	CustomDomainIdentityTypeSystemAssigned CustomDomainIdentityType = "SystemAssigned"
	CustomDomainIdentityTypeUserAssigned   CustomDomainIdentityType = "UserAssigned"
)

// PossibleCustomDomainIdentityTypeValues returns the possible values for the CustomDomainIdentityType const type.
func PossibleCustomDomainIdentityTypeValues() []CustomDomainIdentityType {
	return []CustomDomainIdentityType{
		CustomDomainIdentityTypeSystemAssigned,
		CustomDomainIdentityTypeUserAssigned,
	}
}

// CustomDomainValidationState - Validation state for the custom domain. This is a read only property and is initially set
// to 'Pending' and will be updated to 'Approved' by Event Grid only after ownership of the domain name has been
// successfully validated.
type CustomDomainValidationState string

const (
	CustomDomainValidationStateApproved                 CustomDomainValidationState = "Approved"
	CustomDomainValidationStateErrorRetrievingDNSRecord CustomDomainValidationState = "ErrorRetrievingDnsRecord"
	CustomDomainValidationStatePending                  CustomDomainValidationState = "Pending"
)

// PossibleCustomDomainValidationStateValues returns the possible values for the CustomDomainValidationState const type.
func PossibleCustomDomainValidationStateValues() []CustomDomainValidationState {
	return []CustomDomainValidationState{
		CustomDomainValidationStateApproved,
		CustomDomainValidationStateErrorRetrievingDNSRecord,
		CustomDomainValidationStatePending,
	}
}

// CustomJwtAuthenticationManagedIdentityType - The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
type CustomJwtAuthenticationManagedIdentityType string

const (
	CustomJwtAuthenticationManagedIdentityTypeSystemAssigned CustomJwtAuthenticationManagedIdentityType = "SystemAssigned"
	CustomJwtAuthenticationManagedIdentityTypeUserAssigned   CustomJwtAuthenticationManagedIdentityType = "UserAssigned"
)

// PossibleCustomJwtAuthenticationManagedIdentityTypeValues returns the possible values for the CustomJwtAuthenticationManagedIdentityType const type.
func PossibleCustomJwtAuthenticationManagedIdentityTypeValues() []CustomJwtAuthenticationManagedIdentityType {
	return []CustomJwtAuthenticationManagedIdentityType{
		CustomJwtAuthenticationManagedIdentityTypeSystemAssigned,
		CustomJwtAuthenticationManagedIdentityTypeUserAssigned,
	}
}

// DataResidencyBoundary - Data Residency Boundary of the resource.
type DataResidencyBoundary string

const (
	DataResidencyBoundaryWithinGeopair DataResidencyBoundary = "WithinGeopair"
	DataResidencyBoundaryWithinRegion  DataResidencyBoundary = "WithinRegion"
)

// PossibleDataResidencyBoundaryValues returns the possible values for the DataResidencyBoundary const type.
func PossibleDataResidencyBoundaryValues() []DataResidencyBoundary {
	return []DataResidencyBoundary{
		DataResidencyBoundaryWithinGeopair,
		DataResidencyBoundaryWithinRegion,
	}
}

// DeadLetterEndPointType - Type of the endpoint for the dead letter destination
type DeadLetterEndPointType string

const (
	DeadLetterEndPointTypeStorageBlob DeadLetterEndPointType = "StorageBlob"
)

// PossibleDeadLetterEndPointTypeValues returns the possible values for the DeadLetterEndPointType const type.
func PossibleDeadLetterEndPointTypeValues() []DeadLetterEndPointType {
	return []DeadLetterEndPointType{
		DeadLetterEndPointTypeStorageBlob,
	}
}

// DeliveryAttributeMappingType - Type of the delivery attribute or header name.
type DeliveryAttributeMappingType string

const (
	DeliveryAttributeMappingTypeDynamic DeliveryAttributeMappingType = "Dynamic"
	DeliveryAttributeMappingTypeStatic  DeliveryAttributeMappingType = "Static"
)

// PossibleDeliveryAttributeMappingTypeValues returns the possible values for the DeliveryAttributeMappingType const type.
func PossibleDeliveryAttributeMappingTypeValues() []DeliveryAttributeMappingType {
	return []DeliveryAttributeMappingType{
		DeliveryAttributeMappingTypeDynamic,
		DeliveryAttributeMappingTypeStatic,
	}
}

// DeliveryMode - Delivery mode of the event subscription.
type DeliveryMode string

const (
	DeliveryModePush  DeliveryMode = "Push"
	DeliveryModeQueue DeliveryMode = "Queue"
)

// PossibleDeliveryModeValues returns the possible values for the DeliveryMode const type.
func PossibleDeliveryModeValues() []DeliveryMode {
	return []DeliveryMode{
		DeliveryModePush,
		DeliveryModeQueue,
	}
}

// DeliverySchema - The event delivery schema for the event subscription.
type DeliverySchema string

const (
	DeliverySchemaCloudEventSchemaV10 DeliverySchema = "CloudEventSchemaV1_0"
)

// PossibleDeliverySchemaValues returns the possible values for the DeliverySchema const type.
func PossibleDeliverySchemaValues() []DeliverySchema {
	return []DeliverySchema{
		DeliverySchemaCloudEventSchemaV10,
	}
}

// DomainProvisioningState - Provisioning state of the Event Grid Domain Resource.
type DomainProvisioningState string

const (
	DomainProvisioningStateCanceled  DomainProvisioningState = "Canceled"
	DomainProvisioningStateCreating  DomainProvisioningState = "Creating"
	DomainProvisioningStateDeleting  DomainProvisioningState = "Deleting"
	DomainProvisioningStateFailed    DomainProvisioningState = "Failed"
	DomainProvisioningStateSucceeded DomainProvisioningState = "Succeeded"
	DomainProvisioningStateUpdating  DomainProvisioningState = "Updating"
)

// PossibleDomainProvisioningStateValues returns the possible values for the DomainProvisioningState const type.
func PossibleDomainProvisioningStateValues() []DomainProvisioningState {
	return []DomainProvisioningState{
		DomainProvisioningStateCanceled,
		DomainProvisioningStateCreating,
		DomainProvisioningStateDeleting,
		DomainProvisioningStateFailed,
		DomainProvisioningStateSucceeded,
		DomainProvisioningStateUpdating,
	}
}

// DomainTopicProvisioningState - Provisioning state of the domain topic.
type DomainTopicProvisioningState string

const (
	DomainTopicProvisioningStateCanceled  DomainTopicProvisioningState = "Canceled"
	DomainTopicProvisioningStateCreating  DomainTopicProvisioningState = "Creating"
	DomainTopicProvisioningStateDeleting  DomainTopicProvisioningState = "Deleting"
	DomainTopicProvisioningStateFailed    DomainTopicProvisioningState = "Failed"
	DomainTopicProvisioningStateSucceeded DomainTopicProvisioningState = "Succeeded"
	DomainTopicProvisioningStateUpdating  DomainTopicProvisioningState = "Updating"
)

// PossibleDomainTopicProvisioningStateValues returns the possible values for the DomainTopicProvisioningState const type.
func PossibleDomainTopicProvisioningStateValues() []DomainTopicProvisioningState {
	return []DomainTopicProvisioningState{
		DomainTopicProvisioningStateCanceled,
		DomainTopicProvisioningStateCreating,
		DomainTopicProvisioningStateDeleting,
		DomainTopicProvisioningStateFailed,
		DomainTopicProvisioningStateSucceeded,
		DomainTopicProvisioningStateUpdating,
	}
}

// EndpointType - Type of the endpoint for the event subscription destination.
type EndpointType string

const (
	EndpointTypeAzureFunction      EndpointType = "AzureFunction"
	EndpointTypeEventHub           EndpointType = "EventHub"
	EndpointTypeHybridConnection   EndpointType = "HybridConnection"
	EndpointTypeMonitorAlert       EndpointType = "MonitorAlert"
	EndpointTypeNamespaceTopic     EndpointType = "NamespaceTopic"
	EndpointTypePartnerDestination EndpointType = "PartnerDestination"
	EndpointTypeServiceBusQueue    EndpointType = "ServiceBusQueue"
	EndpointTypeServiceBusTopic    EndpointType = "ServiceBusTopic"
	EndpointTypeStorageQueue       EndpointType = "StorageQueue"
	EndpointTypeWebHook            EndpointType = "WebHook"
)

// PossibleEndpointTypeValues returns the possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{
		EndpointTypeAzureFunction,
		EndpointTypeEventHub,
		EndpointTypeHybridConnection,
		EndpointTypeMonitorAlert,
		EndpointTypeNamespaceTopic,
		EndpointTypePartnerDestination,
		EndpointTypeServiceBusQueue,
		EndpointTypeServiceBusTopic,
		EndpointTypeStorageQueue,
		EndpointTypeWebHook,
	}
}

// EventDefinitionKind - The kind of event type used.
type EventDefinitionKind string

const (
	EventDefinitionKindInline EventDefinitionKind = "Inline"
)

// PossibleEventDefinitionKindValues returns the possible values for the EventDefinitionKind const type.
func PossibleEventDefinitionKindValues() []EventDefinitionKind {
	return []EventDefinitionKind{
		EventDefinitionKindInline,
	}
}

// EventDeliverySchema - The event delivery schema for the event subscription.
type EventDeliverySchema string

const (
	EventDeliverySchemaCloudEventSchemaV10 EventDeliverySchema = "CloudEventSchemaV1_0"
	EventDeliverySchemaCustomInputSchema   EventDeliverySchema = "CustomInputSchema"
	EventDeliverySchemaEventGridSchema     EventDeliverySchema = "EventGridSchema"
)

// PossibleEventDeliverySchemaValues returns the possible values for the EventDeliverySchema const type.
func PossibleEventDeliverySchemaValues() []EventDeliverySchema {
	return []EventDeliverySchema{
		EventDeliverySchemaCloudEventSchemaV10,
		EventDeliverySchemaCustomInputSchema,
		EventDeliverySchemaEventGridSchema,
	}
}

// EventInputSchema - This determines the format that is expected for incoming events published to the topic.
type EventInputSchema string

const (
	EventInputSchemaCloudEventSchemaV10 EventInputSchema = "CloudEventSchemaV1_0"
)

// PossibleEventInputSchemaValues returns the possible values for the EventInputSchema const type.
func PossibleEventInputSchemaValues() []EventInputSchema {
	return []EventInputSchema{
		EventInputSchemaCloudEventSchemaV10,
	}
}

// EventSubscriptionIdentityType - The type of managed identity used. Can be either 'SystemAssigned' or 'UserAssigned'.
type EventSubscriptionIdentityType string

const (
	EventSubscriptionIdentityTypeSystemAssigned EventSubscriptionIdentityType = "SystemAssigned"
	EventSubscriptionIdentityTypeUserAssigned   EventSubscriptionIdentityType = "UserAssigned"
)

// PossibleEventSubscriptionIdentityTypeValues returns the possible values for the EventSubscriptionIdentityType const type.
func PossibleEventSubscriptionIdentityTypeValues() []EventSubscriptionIdentityType {
	return []EventSubscriptionIdentityType{
		EventSubscriptionIdentityTypeSystemAssigned,
		EventSubscriptionIdentityTypeUserAssigned,
	}
}

// EventSubscriptionProvisioningState - Provisioning state of the event subscription.
type EventSubscriptionProvisioningState string

const (
	EventSubscriptionProvisioningStateAwaitingManualAction EventSubscriptionProvisioningState = "AwaitingManualAction"
	EventSubscriptionProvisioningStateCanceled             EventSubscriptionProvisioningState = "Canceled"
	EventSubscriptionProvisioningStateCreating             EventSubscriptionProvisioningState = "Creating"
	EventSubscriptionProvisioningStateDeleting             EventSubscriptionProvisioningState = "Deleting"
	EventSubscriptionProvisioningStateFailed               EventSubscriptionProvisioningState = "Failed"
	EventSubscriptionProvisioningStateSucceeded            EventSubscriptionProvisioningState = "Succeeded"
	EventSubscriptionProvisioningStateUpdating             EventSubscriptionProvisioningState = "Updating"
)

// PossibleEventSubscriptionProvisioningStateValues returns the possible values for the EventSubscriptionProvisioningState const type.
func PossibleEventSubscriptionProvisioningStateValues() []EventSubscriptionProvisioningState {
	return []EventSubscriptionProvisioningState{
		EventSubscriptionProvisioningStateAwaitingManualAction,
		EventSubscriptionProvisioningStateCanceled,
		EventSubscriptionProvisioningStateCreating,
		EventSubscriptionProvisioningStateDeleting,
		EventSubscriptionProvisioningStateFailed,
		EventSubscriptionProvisioningStateSucceeded,
		EventSubscriptionProvisioningStateUpdating,
	}
}

// FilterOperatorType - The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
type FilterOperatorType string

const (
	FilterOperatorTypeBoolEquals                FilterOperatorType = "BoolEquals"
	FilterOperatorTypeIsNotNull                 FilterOperatorType = "IsNotNull"
	FilterOperatorTypeIsNullOrUndefined         FilterOperatorType = "IsNullOrUndefined"
	FilterOperatorTypeNumberGreaterThan         FilterOperatorType = "NumberGreaterThan"
	FilterOperatorTypeNumberGreaterThanOrEquals FilterOperatorType = "NumberGreaterThanOrEquals"
	FilterOperatorTypeNumberIn                  FilterOperatorType = "NumberIn"
	FilterOperatorTypeNumberInRange             FilterOperatorType = "NumberInRange"
	FilterOperatorTypeNumberLessThan            FilterOperatorType = "NumberLessThan"
	FilterOperatorTypeNumberLessThanOrEquals    FilterOperatorType = "NumberLessThanOrEquals"
	FilterOperatorTypeNumberNotIn               FilterOperatorType = "NumberNotIn"
	FilterOperatorTypeNumberNotInRange          FilterOperatorType = "NumberNotInRange"
	FilterOperatorTypeStringBeginsWith          FilterOperatorType = "StringBeginsWith"
	FilterOperatorTypeStringContains            FilterOperatorType = "StringContains"
	FilterOperatorTypeStringEndsWith            FilterOperatorType = "StringEndsWith"
	FilterOperatorTypeStringIn                  FilterOperatorType = "StringIn"
	FilterOperatorTypeStringNotBeginsWith       FilterOperatorType = "StringNotBeginsWith"
	FilterOperatorTypeStringNotContains         FilterOperatorType = "StringNotContains"
	FilterOperatorTypeStringNotEndsWith         FilterOperatorType = "StringNotEndsWith"
	FilterOperatorTypeStringNotIn               FilterOperatorType = "StringNotIn"
)

// PossibleFilterOperatorTypeValues returns the possible values for the FilterOperatorType const type.
func PossibleFilterOperatorTypeValues() []FilterOperatorType {
	return []FilterOperatorType{
		FilterOperatorTypeBoolEquals,
		FilterOperatorTypeIsNotNull,
		FilterOperatorTypeIsNullOrUndefined,
		FilterOperatorTypeNumberGreaterThan,
		FilterOperatorTypeNumberGreaterThanOrEquals,
		FilterOperatorTypeNumberIn,
		FilterOperatorTypeNumberInRange,
		FilterOperatorTypeNumberLessThan,
		FilterOperatorTypeNumberLessThanOrEquals,
		FilterOperatorTypeNumberNotIn,
		FilterOperatorTypeNumberNotInRange,
		FilterOperatorTypeStringBeginsWith,
		FilterOperatorTypeStringContains,
		FilterOperatorTypeStringEndsWith,
		FilterOperatorTypeStringIn,
		FilterOperatorTypeStringNotBeginsWith,
		FilterOperatorTypeStringNotContains,
		FilterOperatorTypeStringNotEndsWith,
		FilterOperatorTypeStringNotIn,
	}
}

// IPActionType - Action to perform based on the match or no match of the IpMask.
type IPActionType string

const (
	IPActionTypeAllow IPActionType = "Allow"
)

// PossibleIPActionTypeValues returns the possible values for the IPActionType const type.
func PossibleIPActionTypeValues() []IPActionType {
	return []IPActionType{
		IPActionTypeAllow,
	}
}

// IdentityType - The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
// identity and a set of user-assigned identities. The type 'None' will remove any identity.
type IdentityType string

const (
	IdentityTypeNone                       IdentityType = "None"
	IdentityTypeSystemAssigned             IdentityType = "SystemAssigned"
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	IdentityTypeUserAssigned               IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
		IdentityTypeSystemAssignedUserAssigned,
		IdentityTypeUserAssigned,
	}
}

// InputSchema - This determines the format that Event Grid should expect for incoming events published to the Event Grid
// Domain Resource.
type InputSchema string

const (
	InputSchemaCloudEventSchemaV10 InputSchema = "CloudEventSchemaV1_0"
	InputSchemaCustomEventSchema   InputSchema = "CustomEventSchema"
	InputSchemaEventGridSchema     InputSchema = "EventGridSchema"
)

// PossibleInputSchemaValues returns the possible values for the InputSchema const type.
func PossibleInputSchemaValues() []InputSchema {
	return []InputSchema{
		InputSchemaCloudEventSchemaV10,
		InputSchemaCustomEventSchema,
		InputSchemaEventGridSchema,
	}
}

// InputSchemaMappingType - Type of the custom mapping
type InputSchemaMappingType string

const (
	InputSchemaMappingTypeJSON InputSchemaMappingType = "Json"
)

// PossibleInputSchemaMappingTypeValues returns the possible values for the InputSchemaMappingType const type.
func PossibleInputSchemaMappingTypeValues() []InputSchemaMappingType {
	return []InputSchemaMappingType{
		InputSchemaMappingTypeJSON,
	}
}

// MonitorAlertSeverity - The severity that will be attached to every Alert fired through this event subscription. This field
// must be provided.
type MonitorAlertSeverity string

const (
	MonitorAlertSeveritySev0 MonitorAlertSeverity = "Sev0"
	MonitorAlertSeveritySev1 MonitorAlertSeverity = "Sev1"
	MonitorAlertSeveritySev2 MonitorAlertSeverity = "Sev2"
	MonitorAlertSeveritySev3 MonitorAlertSeverity = "Sev3"
	MonitorAlertSeveritySev4 MonitorAlertSeverity = "Sev4"
)

// PossibleMonitorAlertSeverityValues returns the possible values for the MonitorAlertSeverity const type.
func PossibleMonitorAlertSeverityValues() []MonitorAlertSeverity {
	return []MonitorAlertSeverity{
		MonitorAlertSeveritySev0,
		MonitorAlertSeveritySev1,
		MonitorAlertSeveritySev2,
		MonitorAlertSeveritySev3,
		MonitorAlertSeveritySev4,
	}
}

// NamespaceProvisioningState - Provisioning state of the namespace resource.
type NamespaceProvisioningState string

const (
	NamespaceProvisioningStateCanceled      NamespaceProvisioningState = "Canceled"
	NamespaceProvisioningStateCreateFailed  NamespaceProvisioningState = "CreateFailed"
	NamespaceProvisioningStateCreating      NamespaceProvisioningState = "Creating"
	NamespaceProvisioningStateDeleteFailed  NamespaceProvisioningState = "DeleteFailed"
	NamespaceProvisioningStateDeleted       NamespaceProvisioningState = "Deleted"
	NamespaceProvisioningStateDeleting      NamespaceProvisioningState = "Deleting"
	NamespaceProvisioningStateFailed        NamespaceProvisioningState = "Failed"
	NamespaceProvisioningStateSucceeded     NamespaceProvisioningState = "Succeeded"
	NamespaceProvisioningStateUpdatedFailed NamespaceProvisioningState = "UpdatedFailed"
	NamespaceProvisioningStateUpdating      NamespaceProvisioningState = "Updating"
)

// PossibleNamespaceProvisioningStateValues returns the possible values for the NamespaceProvisioningState const type.
func PossibleNamespaceProvisioningStateValues() []NamespaceProvisioningState {
	return []NamespaceProvisioningState{
		NamespaceProvisioningStateCanceled,
		NamespaceProvisioningStateCreateFailed,
		NamespaceProvisioningStateCreating,
		NamespaceProvisioningStateDeleteFailed,
		NamespaceProvisioningStateDeleted,
		NamespaceProvisioningStateDeleting,
		NamespaceProvisioningStateFailed,
		NamespaceProvisioningStateSucceeded,
		NamespaceProvisioningStateUpdatedFailed,
		NamespaceProvisioningStateUpdating,
	}
}

// NamespaceTopicProvisioningState - Provisioning state of the namespace topic.
type NamespaceTopicProvisioningState string

const (
	NamespaceTopicProvisioningStateCanceled      NamespaceTopicProvisioningState = "Canceled"
	NamespaceTopicProvisioningStateCreateFailed  NamespaceTopicProvisioningState = "CreateFailed"
	NamespaceTopicProvisioningStateCreating      NamespaceTopicProvisioningState = "Creating"
	NamespaceTopicProvisioningStateDeleteFailed  NamespaceTopicProvisioningState = "DeleteFailed"
	NamespaceTopicProvisioningStateDeleted       NamespaceTopicProvisioningState = "Deleted"
	NamespaceTopicProvisioningStateDeleting      NamespaceTopicProvisioningState = "Deleting"
	NamespaceTopicProvisioningStateFailed        NamespaceTopicProvisioningState = "Failed"
	NamespaceTopicProvisioningStateSucceeded     NamespaceTopicProvisioningState = "Succeeded"
	NamespaceTopicProvisioningStateUpdatedFailed NamespaceTopicProvisioningState = "UpdatedFailed"
	NamespaceTopicProvisioningStateUpdating      NamespaceTopicProvisioningState = "Updating"
)

// PossibleNamespaceTopicProvisioningStateValues returns the possible values for the NamespaceTopicProvisioningState const type.
func PossibleNamespaceTopicProvisioningStateValues() []NamespaceTopicProvisioningState {
	return []NamespaceTopicProvisioningState{
		NamespaceTopicProvisioningStateCanceled,
		NamespaceTopicProvisioningStateCreateFailed,
		NamespaceTopicProvisioningStateCreating,
		NamespaceTopicProvisioningStateDeleteFailed,
		NamespaceTopicProvisioningStateDeleted,
		NamespaceTopicProvisioningStateDeleting,
		NamespaceTopicProvisioningStateFailed,
		NamespaceTopicProvisioningStateSucceeded,
		NamespaceTopicProvisioningStateUpdatedFailed,
		NamespaceTopicProvisioningStateUpdating,
	}
}

// NetworkSecurityPerimeterAssociationAccessMode - Network security perimeter access mode.
type NetworkSecurityPerimeterAssociationAccessMode string

const (
	NetworkSecurityPerimeterAssociationAccessModeAudit    NetworkSecurityPerimeterAssociationAccessMode = "Audit"
	NetworkSecurityPerimeterAssociationAccessModeEnforced NetworkSecurityPerimeterAssociationAccessMode = "Enforced"
	NetworkSecurityPerimeterAssociationAccessModeLearning NetworkSecurityPerimeterAssociationAccessMode = "Learning"
)

// PossibleNetworkSecurityPerimeterAssociationAccessModeValues returns the possible values for the NetworkSecurityPerimeterAssociationAccessMode const type.
func PossibleNetworkSecurityPerimeterAssociationAccessModeValues() []NetworkSecurityPerimeterAssociationAccessMode {
	return []NetworkSecurityPerimeterAssociationAccessMode{
		NetworkSecurityPerimeterAssociationAccessModeAudit,
		NetworkSecurityPerimeterAssociationAccessModeEnforced,
		NetworkSecurityPerimeterAssociationAccessModeLearning,
	}
}

// NetworkSecurityPerimeterConfigProvisioningState - Provisioning state to reflect configuration state and indicate status
// of nsp profile configuration retrieval.
type NetworkSecurityPerimeterConfigProvisioningState string

const (
	NetworkSecurityPerimeterConfigProvisioningStateAccepted  NetworkSecurityPerimeterConfigProvisioningState = "Accepted"
	NetworkSecurityPerimeterConfigProvisioningStateCanceled  NetworkSecurityPerimeterConfigProvisioningState = "Canceled"
	NetworkSecurityPerimeterConfigProvisioningStateCreating  NetworkSecurityPerimeterConfigProvisioningState = "Creating"
	NetworkSecurityPerimeterConfigProvisioningStateDeleted   NetworkSecurityPerimeterConfigProvisioningState = "Deleted"
	NetworkSecurityPerimeterConfigProvisioningStateDeleting  NetworkSecurityPerimeterConfigProvisioningState = "Deleting"
	NetworkSecurityPerimeterConfigProvisioningStateFailed    NetworkSecurityPerimeterConfigProvisioningState = "Failed"
	NetworkSecurityPerimeterConfigProvisioningStateSucceeded NetworkSecurityPerimeterConfigProvisioningState = "Succeeded"
	NetworkSecurityPerimeterConfigProvisioningStateUpdating  NetworkSecurityPerimeterConfigProvisioningState = "Updating"
)

// PossibleNetworkSecurityPerimeterConfigProvisioningStateValues returns the possible values for the NetworkSecurityPerimeterConfigProvisioningState const type.
func PossibleNetworkSecurityPerimeterConfigProvisioningStateValues() []NetworkSecurityPerimeterConfigProvisioningState {
	return []NetworkSecurityPerimeterConfigProvisioningState{
		NetworkSecurityPerimeterConfigProvisioningStateAccepted,
		NetworkSecurityPerimeterConfigProvisioningStateCanceled,
		NetworkSecurityPerimeterConfigProvisioningStateCreating,
		NetworkSecurityPerimeterConfigProvisioningStateDeleted,
		NetworkSecurityPerimeterConfigProvisioningStateDeleting,
		NetworkSecurityPerimeterConfigProvisioningStateFailed,
		NetworkSecurityPerimeterConfigProvisioningStateSucceeded,
		NetworkSecurityPerimeterConfigProvisioningStateUpdating,
	}
}

// NetworkSecurityPerimeterConfigurationIssueSeverity - Provisioning issue severity.
type NetworkSecurityPerimeterConfigurationIssueSeverity string

const (
	NetworkSecurityPerimeterConfigurationIssueSeverityError   NetworkSecurityPerimeterConfigurationIssueSeverity = "Error"
	NetworkSecurityPerimeterConfigurationIssueSeverityWarning NetworkSecurityPerimeterConfigurationIssueSeverity = "Warning"
)

// PossibleNetworkSecurityPerimeterConfigurationIssueSeverityValues returns the possible values for the NetworkSecurityPerimeterConfigurationIssueSeverity const type.
func PossibleNetworkSecurityPerimeterConfigurationIssueSeverityValues() []NetworkSecurityPerimeterConfigurationIssueSeverity {
	return []NetworkSecurityPerimeterConfigurationIssueSeverity{
		NetworkSecurityPerimeterConfigurationIssueSeverityError,
		NetworkSecurityPerimeterConfigurationIssueSeverityWarning,
	}
}

// NetworkSecurityPerimeterConfigurationIssueType - Provisioning issue type.
type NetworkSecurityPerimeterConfigurationIssueType string

const (
	NetworkSecurityPerimeterConfigurationIssueTypeConfigurationPropagationFailure NetworkSecurityPerimeterConfigurationIssueType = "ConfigurationPropagationFailure"
	NetworkSecurityPerimeterConfigurationIssueTypeMissingIdentityConfiguration    NetworkSecurityPerimeterConfigurationIssueType = "MissingIdentityConfiguration"
	NetworkSecurityPerimeterConfigurationIssueTypeMissingPerimeterConfiguration   NetworkSecurityPerimeterConfigurationIssueType = "MissingPerimeterConfiguration"
	NetworkSecurityPerimeterConfigurationIssueTypeOther                           NetworkSecurityPerimeterConfigurationIssueType = "Other"
)

// PossibleNetworkSecurityPerimeterConfigurationIssueTypeValues returns the possible values for the NetworkSecurityPerimeterConfigurationIssueType const type.
func PossibleNetworkSecurityPerimeterConfigurationIssueTypeValues() []NetworkSecurityPerimeterConfigurationIssueType {
	return []NetworkSecurityPerimeterConfigurationIssueType{
		NetworkSecurityPerimeterConfigurationIssueTypeConfigurationPropagationFailure,
		NetworkSecurityPerimeterConfigurationIssueTypeMissingIdentityConfiguration,
		NetworkSecurityPerimeterConfigurationIssueTypeMissingPerimeterConfiguration,
		NetworkSecurityPerimeterConfigurationIssueTypeOther,
	}
}

// NetworkSecurityPerimeterProfileAccessRuleDirection - NSP access rule direction.
type NetworkSecurityPerimeterProfileAccessRuleDirection string

const (
	NetworkSecurityPerimeterProfileAccessRuleDirectionInbound  NetworkSecurityPerimeterProfileAccessRuleDirection = "Inbound"
	NetworkSecurityPerimeterProfileAccessRuleDirectionOutbound NetworkSecurityPerimeterProfileAccessRuleDirection = "Outbound"
)

// PossibleNetworkSecurityPerimeterProfileAccessRuleDirectionValues returns the possible values for the NetworkSecurityPerimeterProfileAccessRuleDirection const type.
func PossibleNetworkSecurityPerimeterProfileAccessRuleDirectionValues() []NetworkSecurityPerimeterProfileAccessRuleDirection {
	return []NetworkSecurityPerimeterProfileAccessRuleDirection{
		NetworkSecurityPerimeterProfileAccessRuleDirectionInbound,
		NetworkSecurityPerimeterProfileAccessRuleDirectionOutbound,
	}
}

type NetworkSecurityPerimeterResourceType string

const (
	NetworkSecurityPerimeterResourceTypeDomains NetworkSecurityPerimeterResourceType = "domains"
	NetworkSecurityPerimeterResourceTypeTopics  NetworkSecurityPerimeterResourceType = "topics"
)

// PossibleNetworkSecurityPerimeterResourceTypeValues returns the possible values for the NetworkSecurityPerimeterResourceType const type.
func PossibleNetworkSecurityPerimeterResourceTypeValues() []NetworkSecurityPerimeterResourceType {
	return []NetworkSecurityPerimeterResourceType{
		NetworkSecurityPerimeterResourceTypeDomains,
		NetworkSecurityPerimeterResourceTypeTopics,
	}
}

// PartnerClientAuthenticationType - Type of client authentication
type PartnerClientAuthenticationType string

const (
	PartnerClientAuthenticationTypeAzureAD PartnerClientAuthenticationType = "AzureAD"
)

// PossiblePartnerClientAuthenticationTypeValues returns the possible values for the PartnerClientAuthenticationType const type.
func PossiblePartnerClientAuthenticationTypeValues() []PartnerClientAuthenticationType {
	return []PartnerClientAuthenticationType{
		PartnerClientAuthenticationTypeAzureAD,
	}
}

// PartnerConfigurationProvisioningState - Provisioning state of the partner configuration.
type PartnerConfigurationProvisioningState string

const (
	PartnerConfigurationProvisioningStateCanceled  PartnerConfigurationProvisioningState = "Canceled"
	PartnerConfigurationProvisioningStateCreating  PartnerConfigurationProvisioningState = "Creating"
	PartnerConfigurationProvisioningStateDeleting  PartnerConfigurationProvisioningState = "Deleting"
	PartnerConfigurationProvisioningStateFailed    PartnerConfigurationProvisioningState = "Failed"
	PartnerConfigurationProvisioningStateSucceeded PartnerConfigurationProvisioningState = "Succeeded"
	PartnerConfigurationProvisioningStateUpdating  PartnerConfigurationProvisioningState = "Updating"
)

// PossiblePartnerConfigurationProvisioningStateValues returns the possible values for the PartnerConfigurationProvisioningState const type.
func PossiblePartnerConfigurationProvisioningStateValues() []PartnerConfigurationProvisioningState {
	return []PartnerConfigurationProvisioningState{
		PartnerConfigurationProvisioningStateCanceled,
		PartnerConfigurationProvisioningStateCreating,
		PartnerConfigurationProvisioningStateDeleting,
		PartnerConfigurationProvisioningStateFailed,
		PartnerConfigurationProvisioningStateSucceeded,
		PartnerConfigurationProvisioningStateUpdating,
	}
}

// PartnerDestinationActivationState - Activation state of the partner destination.
type PartnerDestinationActivationState string

const (
	PartnerDestinationActivationStateActivated      PartnerDestinationActivationState = "Activated"
	PartnerDestinationActivationStateNeverActivated PartnerDestinationActivationState = "NeverActivated"
)

// PossiblePartnerDestinationActivationStateValues returns the possible values for the PartnerDestinationActivationState const type.
func PossiblePartnerDestinationActivationStateValues() []PartnerDestinationActivationState {
	return []PartnerDestinationActivationState{
		PartnerDestinationActivationStateActivated,
		PartnerDestinationActivationStateNeverActivated,
	}
}

// PartnerDestinationProvisioningState - Provisioning state of the partner destination.
type PartnerDestinationProvisioningState string

const (
	PartnerDestinationProvisioningStateCanceled                                 PartnerDestinationProvisioningState = "Canceled"
	PartnerDestinationProvisioningStateCreating                                 PartnerDestinationProvisioningState = "Creating"
	PartnerDestinationProvisioningStateDeleting                                 PartnerDestinationProvisioningState = "Deleting"
	PartnerDestinationProvisioningStateFailed                                   PartnerDestinationProvisioningState = "Failed"
	PartnerDestinationProvisioningStateIdleDueToMirroredChannelResourceDeletion PartnerDestinationProvisioningState = "IdleDueToMirroredChannelResourceDeletion"
	PartnerDestinationProvisioningStateSucceeded                                PartnerDestinationProvisioningState = "Succeeded"
	PartnerDestinationProvisioningStateUpdating                                 PartnerDestinationProvisioningState = "Updating"
)

// PossiblePartnerDestinationProvisioningStateValues returns the possible values for the PartnerDestinationProvisioningState const type.
func PossiblePartnerDestinationProvisioningStateValues() []PartnerDestinationProvisioningState {
	return []PartnerDestinationProvisioningState{
		PartnerDestinationProvisioningStateCanceled,
		PartnerDestinationProvisioningStateCreating,
		PartnerDestinationProvisioningStateDeleting,
		PartnerDestinationProvisioningStateFailed,
		PartnerDestinationProvisioningStateIdleDueToMirroredChannelResourceDeletion,
		PartnerDestinationProvisioningStateSucceeded,
		PartnerDestinationProvisioningStateUpdating,
	}
}

// PartnerEndpointType - Type of the endpoint for the partner destination
type PartnerEndpointType string

const (
	PartnerEndpointTypeWebHook PartnerEndpointType = "WebHook"
)

// PossiblePartnerEndpointTypeValues returns the possible values for the PartnerEndpointType const type.
func PossiblePartnerEndpointTypeValues() []PartnerEndpointType {
	return []PartnerEndpointType{
		PartnerEndpointTypeWebHook,
	}
}

// PartnerNamespaceProvisioningState - Provisioning state of the partner namespace.
type PartnerNamespaceProvisioningState string

const (
	PartnerNamespaceProvisioningStateCanceled  PartnerNamespaceProvisioningState = "Canceled"
	PartnerNamespaceProvisioningStateCreating  PartnerNamespaceProvisioningState = "Creating"
	PartnerNamespaceProvisioningStateDeleting  PartnerNamespaceProvisioningState = "Deleting"
	PartnerNamespaceProvisioningStateFailed    PartnerNamespaceProvisioningState = "Failed"
	PartnerNamespaceProvisioningStateSucceeded PartnerNamespaceProvisioningState = "Succeeded"
	PartnerNamespaceProvisioningStateUpdating  PartnerNamespaceProvisioningState = "Updating"
)

// PossiblePartnerNamespaceProvisioningStateValues returns the possible values for the PartnerNamespaceProvisioningState const type.
func PossiblePartnerNamespaceProvisioningStateValues() []PartnerNamespaceProvisioningState {
	return []PartnerNamespaceProvisioningState{
		PartnerNamespaceProvisioningStateCanceled,
		PartnerNamespaceProvisioningStateCreating,
		PartnerNamespaceProvisioningStateDeleting,
		PartnerNamespaceProvisioningStateFailed,
		PartnerNamespaceProvisioningStateSucceeded,
		PartnerNamespaceProvisioningStateUpdating,
	}
}

// PartnerRegistrationProvisioningState - Provisioning state of the partner registration.
type PartnerRegistrationProvisioningState string

const (
	PartnerRegistrationProvisioningStateCanceled  PartnerRegistrationProvisioningState = "Canceled"
	PartnerRegistrationProvisioningStateCreating  PartnerRegistrationProvisioningState = "Creating"
	PartnerRegistrationProvisioningStateDeleting  PartnerRegistrationProvisioningState = "Deleting"
	PartnerRegistrationProvisioningStateFailed    PartnerRegistrationProvisioningState = "Failed"
	PartnerRegistrationProvisioningStateSucceeded PartnerRegistrationProvisioningState = "Succeeded"
	PartnerRegistrationProvisioningStateUpdating  PartnerRegistrationProvisioningState = "Updating"
)

// PossiblePartnerRegistrationProvisioningStateValues returns the possible values for the PartnerRegistrationProvisioningState const type.
func PossiblePartnerRegistrationProvisioningStateValues() []PartnerRegistrationProvisioningState {
	return []PartnerRegistrationProvisioningState{
		PartnerRegistrationProvisioningStateCanceled,
		PartnerRegistrationProvisioningStateCreating,
		PartnerRegistrationProvisioningStateDeleting,
		PartnerRegistrationProvisioningStateFailed,
		PartnerRegistrationProvisioningStateSucceeded,
		PartnerRegistrationProvisioningStateUpdating,
	}
}

// PartnerTopicActivationState - Activation state of the partner topic.
type PartnerTopicActivationState string

const (
	PartnerTopicActivationStateActivated      PartnerTopicActivationState = "Activated"
	PartnerTopicActivationStateDeactivated    PartnerTopicActivationState = "Deactivated"
	PartnerTopicActivationStateNeverActivated PartnerTopicActivationState = "NeverActivated"
)

// PossiblePartnerTopicActivationStateValues returns the possible values for the PartnerTopicActivationState const type.
func PossiblePartnerTopicActivationStateValues() []PartnerTopicActivationState {
	return []PartnerTopicActivationState{
		PartnerTopicActivationStateActivated,
		PartnerTopicActivationStateDeactivated,
		PartnerTopicActivationStateNeverActivated,
	}
}

// PartnerTopicProvisioningState - Provisioning state of the partner topic.
type PartnerTopicProvisioningState string

const (
	PartnerTopicProvisioningStateCanceled                                 PartnerTopicProvisioningState = "Canceled"
	PartnerTopicProvisioningStateCreating                                 PartnerTopicProvisioningState = "Creating"
	PartnerTopicProvisioningStateDeleting                                 PartnerTopicProvisioningState = "Deleting"
	PartnerTopicProvisioningStateFailed                                   PartnerTopicProvisioningState = "Failed"
	PartnerTopicProvisioningStateIdleDueToMirroredChannelResourceDeletion PartnerTopicProvisioningState = "IdleDueToMirroredChannelResourceDeletion"
	PartnerTopicProvisioningStateSucceeded                                PartnerTopicProvisioningState = "Succeeded"
	PartnerTopicProvisioningStateUpdating                                 PartnerTopicProvisioningState = "Updating"
)

// PossiblePartnerTopicProvisioningStateValues returns the possible values for the PartnerTopicProvisioningState const type.
func PossiblePartnerTopicProvisioningStateValues() []PartnerTopicProvisioningState {
	return []PartnerTopicProvisioningState{
		PartnerTopicProvisioningStateCanceled,
		PartnerTopicProvisioningStateCreating,
		PartnerTopicProvisioningStateDeleting,
		PartnerTopicProvisioningStateFailed,
		PartnerTopicProvisioningStateIdleDueToMirroredChannelResourceDeletion,
		PartnerTopicProvisioningStateSucceeded,
		PartnerTopicProvisioningStateUpdating,
	}
}

// PartnerTopicRoutingMode - This determines if events published to this partner namespace should use the source attribute
// in the event payload or use the channel name in the header when matching to the partner topic. If none is
// specified, source attribute routing will be used to match the partner topic.
type PartnerTopicRoutingMode string

const (
	PartnerTopicRoutingModeChannelNameHeader    PartnerTopicRoutingMode = "ChannelNameHeader"
	PartnerTopicRoutingModeSourceEventAttribute PartnerTopicRoutingMode = "SourceEventAttribute"
)

// PossiblePartnerTopicRoutingModeValues returns the possible values for the PartnerTopicRoutingMode const type.
func PossiblePartnerTopicRoutingModeValues() []PartnerTopicRoutingMode {
	return []PartnerTopicRoutingMode{
		PartnerTopicRoutingModeChannelNameHeader,
		PartnerTopicRoutingModeSourceEventAttribute,
	}
}

// PermissionBindingProvisioningState - Provisioning state of the PermissionBinding resource.
type PermissionBindingProvisioningState string

const (
	PermissionBindingProvisioningStateCanceled  PermissionBindingProvisioningState = "Canceled"
	PermissionBindingProvisioningStateCreating  PermissionBindingProvisioningState = "Creating"
	PermissionBindingProvisioningStateDeleted   PermissionBindingProvisioningState = "Deleted"
	PermissionBindingProvisioningStateDeleting  PermissionBindingProvisioningState = "Deleting"
	PermissionBindingProvisioningStateFailed    PermissionBindingProvisioningState = "Failed"
	PermissionBindingProvisioningStateSucceeded PermissionBindingProvisioningState = "Succeeded"
	PermissionBindingProvisioningStateUpdating  PermissionBindingProvisioningState = "Updating"
)

// PossiblePermissionBindingProvisioningStateValues returns the possible values for the PermissionBindingProvisioningState const type.
func PossiblePermissionBindingProvisioningStateValues() []PermissionBindingProvisioningState {
	return []PermissionBindingProvisioningState{
		PermissionBindingProvisioningStateCanceled,
		PermissionBindingProvisioningStateCreating,
		PermissionBindingProvisioningStateDeleted,
		PermissionBindingProvisioningStateDeleting,
		PermissionBindingProvisioningStateFailed,
		PermissionBindingProvisioningStateSucceeded,
		PermissionBindingProvisioningStateUpdating,
	}
}

// PermissionType - The allowed permission.
type PermissionType string

const (
	PermissionTypePublisher  PermissionType = "Publisher"
	PermissionTypeSubscriber PermissionType = "Subscriber"
)

// PossiblePermissionTypeValues returns the possible values for the PermissionType const type.
func PossiblePermissionTypeValues() []PermissionType {
	return []PermissionType{
		PermissionTypePublisher,
		PermissionTypeSubscriber,
	}
}

// PersistedConnectionStatus - Status of the connection.
type PersistedConnectionStatus string

const (
	PersistedConnectionStatusApproved     PersistedConnectionStatus = "Approved"
	PersistedConnectionStatusDisconnected PersistedConnectionStatus = "Disconnected"
	PersistedConnectionStatusPending      PersistedConnectionStatus = "Pending"
	PersistedConnectionStatusRejected     PersistedConnectionStatus = "Rejected"
)

// PossiblePersistedConnectionStatusValues returns the possible values for the PersistedConnectionStatus const type.
func PossiblePersistedConnectionStatusValues() []PersistedConnectionStatus {
	return []PersistedConnectionStatus{
		PersistedConnectionStatusApproved,
		PersistedConnectionStatusDisconnected,
		PersistedConnectionStatusPending,
		PersistedConnectionStatusRejected,
	}
}

type PrivateEndpointConnectionsParentType string

const (
	PrivateEndpointConnectionsParentTypeDomains           PrivateEndpointConnectionsParentType = "domains"
	PrivateEndpointConnectionsParentTypeNamespaces        PrivateEndpointConnectionsParentType = "namespaces"
	PrivateEndpointConnectionsParentTypePartnerNamespaces PrivateEndpointConnectionsParentType = "partnerNamespaces"
	PrivateEndpointConnectionsParentTypeTopics            PrivateEndpointConnectionsParentType = "topics"
)

// PossiblePrivateEndpointConnectionsParentTypeValues returns the possible values for the PrivateEndpointConnectionsParentType const type.
func PossiblePrivateEndpointConnectionsParentTypeValues() []PrivateEndpointConnectionsParentType {
	return []PrivateEndpointConnectionsParentType{
		PrivateEndpointConnectionsParentTypeDomains,
		PrivateEndpointConnectionsParentTypeNamespaces,
		PrivateEndpointConnectionsParentTypePartnerNamespaces,
		PrivateEndpointConnectionsParentTypeTopics,
	}
}

// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled. You can further
// restrict to specific IPs by configuring
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled           PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled            PublicNetworkAccess = "Enabled"
	PublicNetworkAccessSecuredByPerimeter PublicNetworkAccess = "SecuredByPerimeter"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
		PublicNetworkAccessSecuredByPerimeter,
	}
}

// PublisherType - Publisher type of the namespace topic.
type PublisherType string

const (
	PublisherTypeCustom PublisherType = "Custom"
)

// PossiblePublisherTypeValues returns the possible values for the PublisherType const type.
func PossiblePublisherTypeValues() []PublisherType {
	return []PublisherType{
		PublisherTypeCustom,
	}
}

// ReadinessState - The readiness state of the corresponding partner topic.
type ReadinessState string

const (
	ReadinessStateActivated      ReadinessState = "Activated"
	ReadinessStateNeverActivated ReadinessState = "NeverActivated"
)

// PossibleReadinessStateValues returns the possible values for the ReadinessState const type.
func PossibleReadinessStateValues() []ReadinessState {
	return []ReadinessState{
		ReadinessStateActivated,
		ReadinessStateNeverActivated,
	}
}

// ResourceKind - Kind of the resource.
type ResourceKind string

const (
	ResourceKindAzure    ResourceKind = "Azure"
	ResourceKindAzureArc ResourceKind = "AzureArc"
)

// PossibleResourceKindValues returns the possible values for the ResourceKind const type.
func PossibleResourceKindValues() []ResourceKind {
	return []ResourceKind{
		ResourceKindAzure,
		ResourceKindAzureArc,
	}
}

// ResourceProvisioningState - Provisioning state of the Private Endpoint Connection.
type ResourceProvisioningState string

const (
	ResourceProvisioningStateCanceled  ResourceProvisioningState = "Canceled"
	ResourceProvisioningStateCreating  ResourceProvisioningState = "Creating"
	ResourceProvisioningStateDeleting  ResourceProvisioningState = "Deleting"
	ResourceProvisioningStateFailed    ResourceProvisioningState = "Failed"
	ResourceProvisioningStateSucceeded ResourceProvisioningState = "Succeeded"
	ResourceProvisioningStateUpdating  ResourceProvisioningState = "Updating"
)

// PossibleResourceProvisioningStateValues returns the possible values for the ResourceProvisioningState const type.
func PossibleResourceProvisioningStateValues() []ResourceProvisioningState {
	return []ResourceProvisioningState{
		ResourceProvisioningStateCanceled,
		ResourceProvisioningStateCreating,
		ResourceProvisioningStateDeleting,
		ResourceProvisioningStateFailed,
		ResourceProvisioningStateSucceeded,
		ResourceProvisioningStateUpdating,
	}
}

// ResourceRegionType - Region type of the resource.
type ResourceRegionType string

const (
	ResourceRegionTypeGlobalResource   ResourceRegionType = "GlobalResource"
	ResourceRegionTypeRegionalResource ResourceRegionType = "RegionalResource"
)

// PossibleResourceRegionTypeValues returns the possible values for the ResourceRegionType const type.
func PossibleResourceRegionTypeValues() []ResourceRegionType {
	return []ResourceRegionType{
		ResourceRegionTypeGlobalResource,
		ResourceRegionTypeRegionalResource,
	}
}

// RoutingIdentityType - Routing identity type for topic spaces configuration.
type RoutingIdentityType string

const (
	RoutingIdentityTypeNone           RoutingIdentityType = "None"
	RoutingIdentityTypeSystemAssigned RoutingIdentityType = "SystemAssigned"
	RoutingIdentityTypeUserAssigned   RoutingIdentityType = "UserAssigned"
)

// PossibleRoutingIdentityTypeValues returns the possible values for the RoutingIdentityType const type.
func PossibleRoutingIdentityTypeValues() []RoutingIdentityType {
	return []RoutingIdentityType{
		RoutingIdentityTypeNone,
		RoutingIdentityTypeSystemAssigned,
		RoutingIdentityTypeUserAssigned,
	}
}

// SKU - The Sku name of the resource. The possible values are: Basic or Premium.
type SKU string

const (
	SKUBasic   SKU = "Basic"
	SKUPremium SKU = "Premium"
)

// PossibleSKUValues returns the possible values for the SKU const type.
func PossibleSKUValues() []SKU {
	return []SKU{
		SKUBasic,
		SKUPremium,
	}
}

// SKUName - The name of the SKU.
type SKUName string

const (
	SKUNameStandard SKUName = "Standard"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameStandard,
	}
}

// StaticRoutingEnrichmentType - Static routing enrichment value type. For e.g. this property value can be 'String'.
type StaticRoutingEnrichmentType string

const (
	StaticRoutingEnrichmentTypeString StaticRoutingEnrichmentType = "String"
)

// PossibleStaticRoutingEnrichmentTypeValues returns the possible values for the StaticRoutingEnrichmentType const type.
func PossibleStaticRoutingEnrichmentTypeValues() []StaticRoutingEnrichmentType {
	return []StaticRoutingEnrichmentType{
		StaticRoutingEnrichmentTypeString,
	}
}

// SubscriptionProvisioningState - Provisioning state of the event subscription.
type SubscriptionProvisioningState string

const (
	SubscriptionProvisioningStateAwaitingManualAction SubscriptionProvisioningState = "AwaitingManualAction"
	SubscriptionProvisioningStateCanceled             SubscriptionProvisioningState = "Canceled"
	SubscriptionProvisioningStateCreateFailed         SubscriptionProvisioningState = "CreateFailed"
	SubscriptionProvisioningStateCreating             SubscriptionProvisioningState = "Creating"
	SubscriptionProvisioningStateDeleteFailed         SubscriptionProvisioningState = "DeleteFailed"
	SubscriptionProvisioningStateDeleted              SubscriptionProvisioningState = "Deleted"
	SubscriptionProvisioningStateDeleting             SubscriptionProvisioningState = "Deleting"
	SubscriptionProvisioningStateFailed               SubscriptionProvisioningState = "Failed"
	SubscriptionProvisioningStateSucceeded            SubscriptionProvisioningState = "Succeeded"
	SubscriptionProvisioningStateUpdatedFailed        SubscriptionProvisioningState = "UpdatedFailed"
	SubscriptionProvisioningStateUpdating             SubscriptionProvisioningState = "Updating"
)

// PossibleSubscriptionProvisioningStateValues returns the possible values for the SubscriptionProvisioningState const type.
func PossibleSubscriptionProvisioningStateValues() []SubscriptionProvisioningState {
	return []SubscriptionProvisioningState{
		SubscriptionProvisioningStateAwaitingManualAction,
		SubscriptionProvisioningStateCanceled,
		SubscriptionProvisioningStateCreateFailed,
		SubscriptionProvisioningStateCreating,
		SubscriptionProvisioningStateDeleteFailed,
		SubscriptionProvisioningStateDeleted,
		SubscriptionProvisioningStateDeleting,
		SubscriptionProvisioningStateFailed,
		SubscriptionProvisioningStateSucceeded,
		SubscriptionProvisioningStateUpdatedFailed,
		SubscriptionProvisioningStateUpdating,
	}
}

// TLSVersion - Minimum TLS version of the publisher allowed to publish to this domain
type TLSVersion string

const (
	TLSVersionOne0 TLSVersion = "1.0"
	TLSVersionOne1 TLSVersion = "1.1"
	TLSVersionOne2 TLSVersion = "1.2"
)

// PossibleTLSVersionValues returns the possible values for the TLSVersion const type.
func PossibleTLSVersionValues() []TLSVersion {
	return []TLSVersion{
		TLSVersionOne0,
		TLSVersionOne1,
		TLSVersionOne2,
	}
}

// TopicProvisioningState - Provisioning state of the topic.
type TopicProvisioningState string

const (
	TopicProvisioningStateCanceled  TopicProvisioningState = "Canceled"
	TopicProvisioningStateCreating  TopicProvisioningState = "Creating"
	TopicProvisioningStateDeleting  TopicProvisioningState = "Deleting"
	TopicProvisioningStateFailed    TopicProvisioningState = "Failed"
	TopicProvisioningStateSucceeded TopicProvisioningState = "Succeeded"
	TopicProvisioningStateUpdating  TopicProvisioningState = "Updating"
)

// PossibleTopicProvisioningStateValues returns the possible values for the TopicProvisioningState const type.
func PossibleTopicProvisioningStateValues() []TopicProvisioningState {
	return []TopicProvisioningState{
		TopicProvisioningStateCanceled,
		TopicProvisioningStateCreating,
		TopicProvisioningStateDeleting,
		TopicProvisioningStateFailed,
		TopicProvisioningStateSucceeded,
		TopicProvisioningStateUpdating,
	}
}

// TopicSpaceProvisioningState - Provisioning state of the TopicSpace resource.
type TopicSpaceProvisioningState string

const (
	TopicSpaceProvisioningStateCanceled  TopicSpaceProvisioningState = "Canceled"
	TopicSpaceProvisioningStateCreating  TopicSpaceProvisioningState = "Creating"
	TopicSpaceProvisioningStateDeleted   TopicSpaceProvisioningState = "Deleted"
	TopicSpaceProvisioningStateDeleting  TopicSpaceProvisioningState = "Deleting"
	TopicSpaceProvisioningStateFailed    TopicSpaceProvisioningState = "Failed"
	TopicSpaceProvisioningStateSucceeded TopicSpaceProvisioningState = "Succeeded"
	TopicSpaceProvisioningStateUpdating  TopicSpaceProvisioningState = "Updating"
)

// PossibleTopicSpaceProvisioningStateValues returns the possible values for the TopicSpaceProvisioningState const type.
func PossibleTopicSpaceProvisioningStateValues() []TopicSpaceProvisioningState {
	return []TopicSpaceProvisioningState{
		TopicSpaceProvisioningStateCanceled,
		TopicSpaceProvisioningStateCreating,
		TopicSpaceProvisioningStateDeleted,
		TopicSpaceProvisioningStateDeleting,
		TopicSpaceProvisioningStateFailed,
		TopicSpaceProvisioningStateSucceeded,
		TopicSpaceProvisioningStateUpdating,
	}
}

// TopicSpacesConfigurationState - Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
type TopicSpacesConfigurationState string

const (
	TopicSpacesConfigurationStateDisabled TopicSpacesConfigurationState = "Disabled"
	TopicSpacesConfigurationStateEnabled  TopicSpacesConfigurationState = "Enabled"
)

// PossibleTopicSpacesConfigurationStateValues returns the possible values for the TopicSpacesConfigurationState const type.
func PossibleTopicSpacesConfigurationStateValues() []TopicSpacesConfigurationState {
	return []TopicSpacesConfigurationState{
		TopicSpacesConfigurationStateDisabled,
		TopicSpacesConfigurationStateEnabled,
	}
}

// TopicTypeProvisioningState - Provisioning state of the topic type.
type TopicTypeProvisioningState string

const (
	TopicTypeProvisioningStateCanceled  TopicTypeProvisioningState = "Canceled"
	TopicTypeProvisioningStateCreating  TopicTypeProvisioningState = "Creating"
	TopicTypeProvisioningStateDeleting  TopicTypeProvisioningState = "Deleting"
	TopicTypeProvisioningStateFailed    TopicTypeProvisioningState = "Failed"
	TopicTypeProvisioningStateSucceeded TopicTypeProvisioningState = "Succeeded"
	TopicTypeProvisioningStateUpdating  TopicTypeProvisioningState = "Updating"
)

// PossibleTopicTypeProvisioningStateValues returns the possible values for the TopicTypeProvisioningState const type.
func PossibleTopicTypeProvisioningStateValues() []TopicTypeProvisioningState {
	return []TopicTypeProvisioningState{
		TopicTypeProvisioningStateCanceled,
		TopicTypeProvisioningStateCreating,
		TopicTypeProvisioningStateDeleting,
		TopicTypeProvisioningStateFailed,
		TopicTypeProvisioningStateSucceeded,
		TopicTypeProvisioningStateUpdating,
	}
}

type TopicTypeSourceScope string

const (
	TopicTypeSourceScopeAzureSubscription TopicTypeSourceScope = "AzureSubscription"
	TopicTypeSourceScopeManagementGroup   TopicTypeSourceScope = "ManagementGroup"
	TopicTypeSourceScopeResource          TopicTypeSourceScope = "Resource"
	TopicTypeSourceScopeResourceGroup     TopicTypeSourceScope = "ResourceGroup"
)

// PossibleTopicTypeSourceScopeValues returns the possible values for the TopicTypeSourceScope const type.
func PossibleTopicTypeSourceScopeValues() []TopicTypeSourceScope {
	return []TopicTypeSourceScope{
		TopicTypeSourceScopeAzureSubscription,
		TopicTypeSourceScopeManagementGroup,
		TopicTypeSourceScopeResource,
		TopicTypeSourceScopeResourceGroup,
	}
}

// VerifiedPartnerProvisioningState - Provisioning state of the verified partner.
type VerifiedPartnerProvisioningState string

const (
	VerifiedPartnerProvisioningStateCanceled  VerifiedPartnerProvisioningState = "Canceled"
	VerifiedPartnerProvisioningStateCreating  VerifiedPartnerProvisioningState = "Creating"
	VerifiedPartnerProvisioningStateDeleting  VerifiedPartnerProvisioningState = "Deleting"
	VerifiedPartnerProvisioningStateFailed    VerifiedPartnerProvisioningState = "Failed"
	VerifiedPartnerProvisioningStateSucceeded VerifiedPartnerProvisioningState = "Succeeded"
	VerifiedPartnerProvisioningStateUpdating  VerifiedPartnerProvisioningState = "Updating"
)

// PossibleVerifiedPartnerProvisioningStateValues returns the possible values for the VerifiedPartnerProvisioningState const type.
func PossibleVerifiedPartnerProvisioningStateValues() []VerifiedPartnerProvisioningState {
	return []VerifiedPartnerProvisioningState{
		VerifiedPartnerProvisioningStateCanceled,
		VerifiedPartnerProvisioningStateCreating,
		VerifiedPartnerProvisioningStateDeleting,
		VerifiedPartnerProvisioningStateFailed,
		VerifiedPartnerProvisioningStateSucceeded,
		VerifiedPartnerProvisioningStateUpdating,
	}
}
