//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datafactory/armdatafactory/v7"
	"net/http"
	"net/url"
	"regexp"
)

// ActivityRunsServer is a fake server for instances of the armdatafactory.ActivityRunsClient type.
type ActivityRunsServer struct {
	// QueryByPipelineRun is the fake for method ActivityRunsClient.QueryByPipelineRun
	// HTTP status codes to indicate success: http.StatusOK
	QueryByPipelineRun func(ctx context.Context, resourceGroupName string, factoryName string, runID string, filterParameters armdatafactory.RunFilterParameters, options *armdatafactory.ActivityRunsClientQueryByPipelineRunOptions) (resp azfake.Responder[armdatafactory.ActivityRunsClientQueryByPipelineRunResponse], errResp azfake.ErrorResponder)
}

// NewActivityRunsServerTransport creates a new instance of ActivityRunsServerTransport with the provided implementation.
// The returned ActivityRunsServerTransport instance is connected to an instance of armdatafactory.ActivityRunsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewActivityRunsServerTransport(srv *ActivityRunsServer) *ActivityRunsServerTransport {
	return &ActivityRunsServerTransport{srv: srv}
}

// ActivityRunsServerTransport connects instances of armdatafactory.ActivityRunsClient to instances of ActivityRunsServer.
// Don't use this type directly, use NewActivityRunsServerTransport instead.
type ActivityRunsServerTransport struct {
	srv *ActivityRunsServer
}

// Do implements the policy.Transporter interface for ActivityRunsServerTransport.
func (a *ActivityRunsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ActivityRunsClient.QueryByPipelineRun":
		resp, err = a.dispatchQueryByPipelineRun(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ActivityRunsServerTransport) dispatchQueryByPipelineRun(req *http.Request) (*http.Response, error) {
	if a.srv.QueryByPipelineRun == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryByPipelineRun not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataFactory/factories/(?P<factoryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pipelineruns/(?P<runId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryActivityruns`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatafactory.RunFilterParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	factoryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("factoryName")])
	if err != nil {
		return nil, err
	}
	runIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("runId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.QueryByPipelineRun(req.Context(), resourceGroupNameParam, factoryNameParam, runIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActivityRunsQueryResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
