//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatafactory

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription identifier.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewActivityRunsClient creates a new instance of ActivityRunsClient.
func (c *ClientFactory) NewActivityRunsClient() *ActivityRunsClient {
	return &ActivityRunsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewChangeDataCaptureClient creates a new instance of ChangeDataCaptureClient.
func (c *ClientFactory) NewChangeDataCaptureClient() *ChangeDataCaptureClient {
	return &ChangeDataCaptureClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCredentialOperationsClient creates a new instance of CredentialOperationsClient.
func (c *ClientFactory) NewCredentialOperationsClient() *CredentialOperationsClient {
	return &CredentialOperationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDataFlowDebugSessionClient creates a new instance of DataFlowDebugSessionClient.
func (c *ClientFactory) NewDataFlowDebugSessionClient() *DataFlowDebugSessionClient {
	return &DataFlowDebugSessionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDataFlowsClient creates a new instance of DataFlowsClient.
func (c *ClientFactory) NewDataFlowsClient() *DataFlowsClient {
	return &DataFlowsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDatasetsClient creates a new instance of DatasetsClient.
func (c *ClientFactory) NewDatasetsClient() *DatasetsClient {
	return &DatasetsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewExposureControlClient creates a new instance of ExposureControlClient.
func (c *ClientFactory) NewExposureControlClient() *ExposureControlClient {
	return &ExposureControlClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewFactoriesClient creates a new instance of FactoriesClient.
func (c *ClientFactory) NewFactoriesClient() *FactoriesClient {
	return &FactoriesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGlobalParametersClient creates a new instance of GlobalParametersClient.
func (c *ClientFactory) NewGlobalParametersClient() *GlobalParametersClient {
	return &GlobalParametersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewIntegrationRuntimeNodesClient creates a new instance of IntegrationRuntimeNodesClient.
func (c *ClientFactory) NewIntegrationRuntimeNodesClient() *IntegrationRuntimeNodesClient {
	return &IntegrationRuntimeNodesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewIntegrationRuntimeObjectMetadataClient creates a new instance of IntegrationRuntimeObjectMetadataClient.
func (c *ClientFactory) NewIntegrationRuntimeObjectMetadataClient() *IntegrationRuntimeObjectMetadataClient {
	return &IntegrationRuntimeObjectMetadataClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewIntegrationRuntimesClient creates a new instance of IntegrationRuntimesClient.
func (c *ClientFactory) NewIntegrationRuntimesClient() *IntegrationRuntimesClient {
	return &IntegrationRuntimesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewLinkedServicesClient creates a new instance of LinkedServicesClient.
func (c *ClientFactory) NewLinkedServicesClient() *LinkedServicesClient {
	return &LinkedServicesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewManagedPrivateEndpointsClient creates a new instance of ManagedPrivateEndpointsClient.
func (c *ClientFactory) NewManagedPrivateEndpointsClient() *ManagedPrivateEndpointsClient {
	return &ManagedPrivateEndpointsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewManagedVirtualNetworksClient creates a new instance of ManagedVirtualNetworksClient.
func (c *ClientFactory) NewManagedVirtualNetworksClient() *ManagedVirtualNetworksClient {
	return &ManagedVirtualNetworksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPipelineRunsClient creates a new instance of PipelineRunsClient.
func (c *ClientFactory) NewPipelineRunsClient() *PipelineRunsClient {
	return &PipelineRunsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPipelinesClient creates a new instance of PipelinesClient.
func (c *ClientFactory) NewPipelinesClient() *PipelinesClient {
	return &PipelinesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateEndPointConnectionsClient creates a new instance of PrivateEndPointConnectionsClient.
func (c *ClientFactory) NewPrivateEndPointConnectionsClient() *PrivateEndPointConnectionsClient {
	return &PrivateEndPointConnectionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateEndpointConnectionClient creates a new instance of PrivateEndpointConnectionClient.
func (c *ClientFactory) NewPrivateEndpointConnectionClient() *PrivateEndpointConnectionClient {
	return &PrivateEndpointConnectionClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	return &PrivateLinkResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTriggerRunsClient creates a new instance of TriggerRunsClient.
func (c *ClientFactory) NewTriggerRunsClient() *TriggerRunsClient {
	return &TriggerRunsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTriggersClient creates a new instance of TriggersClient.
func (c *ClientFactory) NewTriggersClient() *TriggersClient {
	return &TriggersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
