//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatafactory_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datafactory/armdatafactory/v7"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_ListByFactory.json
func ExampleChangeDataCaptureClient_NewListByFactoryPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewChangeDataCaptureClient().NewListByFactoryPager("exampleResourceGroup", "exampleFactoryName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ChangeDataCaptureListResponse = armdatafactory.ChangeDataCaptureListResponse{
		// 	Value: []*armdatafactory.ChangeDataCaptureResource{
		// 		{
		// 			Name: to.Ptr("exampleChangeDataCapture"),
		// 			Type: to.Ptr("Microsoft.DataFactory/factories/adfcdcs"),
		// 			Etag: to.Ptr("4200eefe-0000-0100-0000-641aa97a0000"),
		// 			ID: to.Ptr("/subscriptions/d3bb3b2e-9a7e-4194-9960-5171bd192117/resourceGroups/amja-rg-03/providers/Microsoft.DataFactory/factories/amja-adf-04/adfcdcs/exampleChangeDataCapture"),
		// 			Properties: &armdatafactory.ChangeDataCapture{
		// 				Description: to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings."),
		// 				AllowVNetOverride: to.Ptr(false),
		// 				Status: to.Ptr("Stopped"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Create.json
func ExampleChangeDataCaptureClient_CreateOrUpdate_changeDataCaptureCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChangeDataCaptureClient().CreateOrUpdate(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", armdatafactory.ChangeDataCaptureResource{
		Properties: &armdatafactory.ChangeDataCapture{
			Description:       to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings."),
			AllowVNetOverride: to.Ptr(false),
		},
	}, &armdatafactory.ChangeDataCaptureClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChangeDataCaptureResource = armdatafactory.ChangeDataCaptureResource{
	// 	Name: to.Ptr("exampleChangeDataCapture"),
	// 	Type: to.Ptr("Microsoft.DataFactory/factories/adfcdcs"),
	// 	Etag: to.Ptr("4300f91d-0000-0100-0000-641ab34d0000"),
	// 	ID: to.Ptr("/subscriptions/d3bb3b2e-9a7e-4194-9960-5171bd192117/resourceGroups/amja-rg-03/providers/Microsoft.DataFactory/factories/amja-adf-04/adfcdcs/exampleChangeDataCapture"),
	// 	Properties: &armdatafactory.ChangeDataCapture{
	// 		Description: to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
	// 		AllowVNetOverride: to.Ptr(false),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Update.json
func ExampleChangeDataCaptureClient_CreateOrUpdate_changeDataCaptureUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChangeDataCaptureClient().CreateOrUpdate(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", armdatafactory.ChangeDataCaptureResource{
		Properties: &armdatafactory.ChangeDataCapture{
			Description:       to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
			AllowVNetOverride: to.Ptr(false),
			Status:            to.Ptr("Stopped"),
		},
	}, &armdatafactory.ChangeDataCaptureClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChangeDataCaptureResource = armdatafactory.ChangeDataCaptureResource{
	// 	Name: to.Ptr("exampleChangeDataCapture"),
	// 	Type: to.Ptr("Microsoft.DataFactory/factories/adfcdcs"),
	// 	Etag: to.Ptr("43008e18-0000-0100-0000-641aafca0000"),
	// 	ID: to.Ptr("/subscriptions/d3bb3b2e-9a7e-4194-9960-5171bd192117/resourceGroups/amja-rg-03/providers/Microsoft.DataFactory/factories/amja-adf-04/adfcdcs/exampleChangeDataCapture"),
	// 	Properties: &armdatafactory.ChangeDataCapture{
	// 		Description: to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
	// 		AllowVNetOverride: to.Ptr(false),
	// 		Status: to.Ptr("Stopped"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Get.json
func ExampleChangeDataCaptureClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChangeDataCaptureClient().Get(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", &armdatafactory.ChangeDataCaptureClientGetOptions{IfNoneMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChangeDataCaptureResource = armdatafactory.ChangeDataCaptureResource{
	// 	Name: to.Ptr("exampleChangeDataCapture"),
	// 	Type: to.Ptr("Microsoft.DataFactory/factories/adfcdcs"),
	// 	Etag: to.Ptr("4300f91d-0000-0100-0000-641ab34d0000"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.DataFactory/factories/exampleFactoryName/adfcdcs/exampleChangeDataCapture"),
	// 	Properties: &armdatafactory.ChangeDataCapture{
	// 		Description: to.Ptr("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
	// 		AllowVNetOverride: to.Ptr(false),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Delete.json
func ExampleChangeDataCaptureClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewChangeDataCaptureClient().Delete(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Start.json
func ExampleChangeDataCaptureClient_Start() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewChangeDataCaptureClient().Start(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Stop.json
func ExampleChangeDataCaptureClient_Stop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewChangeDataCaptureClient().Stop(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Status.json
func ExampleChangeDataCaptureClient_Status() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewChangeDataCaptureClient().Status(ctx, "exampleResourceGroup", "exampleFactoryName", "exampleChangeDataCapture", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "Stopped"
}
