//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbatch_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/batch/armbatch/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/ApplicationPackageActivate.json
func ExampleApplicationPackageClient_Activate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationPackageClient().Activate(ctx, "default-azurebatch-japaneast", "sampleacct", "app1", "1", armbatch.ActivateApplicationPackageParameters{
		Format: to.Ptr("zip"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationPackage = armbatch.ApplicationPackage{
	// 	Name: to.Ptr("1"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/applications/versions"),
	// 	Etag: to.Ptr("W/\"0x8D64FEC83A3B436\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/applications/app1/versions/1"),
	// 	Properties: &armbatch.ApplicationPackageProperties{
	// 		Format: to.Ptr("zip"),
	// 		LastActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-27T18:48:09.933Z"); return t}()),
	// 		State: to.Ptr(armbatch.PackageStateActive),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/ApplicationPackageCreate.json
func ExampleApplicationPackageClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationPackageClient().Create(ctx, "default-azurebatch-japaneast", "sampleacct", "app1", "1", &armbatch.ApplicationPackageClientCreateOptions{Parameters: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationPackage = armbatch.ApplicationPackage{
	// 	Name: to.Ptr("1"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/applications/versions"),
	// 	Etag: to.Ptr("W/\"0x8D64FEC83A3B436\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/applications/app1/versions/1"),
	// 	Properties: &armbatch.ApplicationPackageProperties{
	// 		State: to.Ptr(armbatch.PackageStatePending),
	// 		StorageURL: to.Ptr("http://mystorage1.blob.core.windows.net/myapp?mysas"),
	// 		StorageURLExpiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-27T18:48:09.933Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/ApplicationPackageDelete.json
func ExampleApplicationPackageClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewApplicationPackageClient().Delete(ctx, "default-azurebatch-japaneast", "sampleacct", "app1", "1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/ApplicationPackageGet.json
func ExampleApplicationPackageClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationPackageClient().Get(ctx, "default-azurebatch-japaneast", "sampleacct", "app1", "1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationPackage = armbatch.ApplicationPackage{
	// 	Name: to.Ptr("1"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/applications/versions"),
	// 	Etag: to.Ptr("W/\"0x8D64FEC83A3B436\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/applications/app1/versions/1"),
	// 	Properties: &armbatch.ApplicationPackageProperties{
	// 		Format: to.Ptr("zip"),
	// 		LastActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-27T18:48:09.933Z"); return t}()),
	// 		State: to.Ptr(armbatch.PackageStateActive),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/ApplicationPackageList.json
func ExampleApplicationPackageClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationPackageClient().NewListPager("default-azurebatch-japaneast", "sampleacct", "app1", &armbatch.ApplicationPackageClientListOptions{Maxresults: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListApplicationPackagesResult = armbatch.ListApplicationPackagesResult{
		// 	Value: []*armbatch.ApplicationPackage{
		// 		{
		// 			Name: to.Ptr("1.0"),
		// 			Type: to.Ptr("Microsoft.Batch/batchAccounts/applications/versions"),
		// 			Etag: to.Ptr("W/\"0x8D64FF0B9F47F67\""),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/applications/app1/versions/1.0"),
		// 			Properties: &armbatch.ApplicationPackageProperties{
		// 				State: to.Ptr(armbatch.PackageStatePending),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("2.0"),
		// 			Type: to.Ptr("Microsoft.Batch/batchAccounts/applications/versions"),
		// 			Etag: to.Ptr("W/\"0x8D64FF0B9F47F67\""),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/sampleacct/applications/app1/versions/2.0"),
		// 			Properties: &armbatch.ApplicationPackageProperties{
		// 				Format: to.Ptr("zip"),
		// 				LastActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-27T18:48:09.933Z"); return t}()),
		// 				State: to.Ptr(armbatch.PackageStateActive),
		// 			},
		// 	}},
		// }
	}
}
