//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappcontainers_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicies_List.json
func ExampleDaprComponentResiliencyPoliciesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDaprComponentResiliencyPoliciesClient().NewListPager("examplerg", "myenvironment", "mydaprcomponent", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DaprComponentResiliencyPoliciesCollection = armappcontainers.DaprComponentResiliencyPoliciesCollection{
		// 	Value: []*armappcontainers.DaprComponentResiliencyPolicy{
		// 		{
		// 			Name: to.Ptr("something"),
		// 			Type: to.Ptr("Microsoft.App/managedEnvironments/daprComponents/resiliencyPolicies"),
		// 			ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprComponents/mydaprcomponent/resiliencyPolicies/myresiliencypolicy"),
		// 			Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
		// 				InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
		// 					CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
		// 						ConsecutiveErrors: to.Ptr[int32](5),
		// 						TimeoutInSeconds: to.Ptr[int32](10),
		// 					},
		// 					HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
		// 						MaxRetries: to.Ptr[int32](15),
		// 						RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
		// 							InitialDelayInMilliseconds: to.Ptr[int32](2000),
		// 							MaxIntervalInMilliseconds: to.Ptr[int32](5500),
		// 						},
		// 					},
		// 					TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
		// 						ResponseTimeoutInSeconds: to.Ptr[int32](30),
		// 					},
		// 				},
		// 				OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
		// 					CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
		// 						ConsecutiveErrors: to.Ptr[int32](3),
		// 						IntervalInSeconds: to.Ptr[int32](60),
		// 						TimeoutInSeconds: to.Ptr[int32](20),
		// 					},
		// 					HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
		// 						MaxRetries: to.Ptr[int32](5),
		// 						RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
		// 							InitialDelayInMilliseconds: to.Ptr[int32](100),
		// 							MaxIntervalInMilliseconds: to.Ptr[int32](30000),
		// 						},
		// 					},
		// 					TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
		// 						ResponseTimeoutInSeconds: to.Ptr[int32](12),
		// 					},
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicies_Get.json
func ExampleDaprComponentResiliencyPoliciesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprComponentResiliencyPoliciesClient().Get(ctx, "examplerg", "myenvironment", "mydaprcomponent", "myresiliencypolicy", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprComponentResiliencyPolicy = armappcontainers.DaprComponentResiliencyPolicy{
	// 	Name: to.Ptr("myresiliencypolicy"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprComponents/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprComponents/mydaprcomponent/resiliencyPolicies/myresiliencypolicy"),
	// 	Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
	// 		InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](5),
	// 				TimeoutInSeconds: to.Ptr[int32](10),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](15),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](2000),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](5500),
	// 				},
	// 			},
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](30),
	// 			},
	// 		},
	// 		OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](3),
	// 				IntervalInSeconds: to.Ptr[int32](60),
	// 				TimeoutInSeconds: to.Ptr[int32](20),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](5),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](100),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](30000),
	// 				},
	// 			},
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](12),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicy_CreateOrUpdate_AllOptions.json
func ExampleDaprComponentResiliencyPoliciesClient_CreateOrUpdate_createOrUpdateDaprComponentResiliencyPolicyWithAllOptions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprComponentResiliencyPoliciesClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mydaprcomponent", "myresiliencypolicy", armappcontainers.DaprComponentResiliencyPolicy{
		Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
			InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
				CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
					ConsecutiveErrors: to.Ptr[int32](5),
					IntervalInSeconds: to.Ptr[int32](4),
					TimeoutInSeconds:  to.Ptr[int32](10),
				},
				HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
					MaxRetries: to.Ptr[int32](15),
					RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
						InitialDelayInMilliseconds: to.Ptr[int32](2000),
						MaxIntervalInMilliseconds:  to.Ptr[int32](5500),
					},
				},
				TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
					ResponseTimeoutInSeconds: to.Ptr[int32](30),
				},
			},
			OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
				CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
					ConsecutiveErrors: to.Ptr[int32](3),
					IntervalInSeconds: to.Ptr[int32](60),
					TimeoutInSeconds:  to.Ptr[int32](20),
				},
				HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
					MaxRetries: to.Ptr[int32](5),
					RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
						InitialDelayInMilliseconds: to.Ptr[int32](100),
						MaxIntervalInMilliseconds:  to.Ptr[int32](30000),
					},
				},
				TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
					ResponseTimeoutInSeconds: to.Ptr[int32](12),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprComponentResiliencyPolicy = armappcontainers.DaprComponentResiliencyPolicy{
	// 	Name: to.Ptr("myresiliencypolicy"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprComponents/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprComponents/mydaprcomponent/resiliencyPolicies/myresiliencypolicy"),
	// 	Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
	// 		InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](5),
	// 				IntervalInSeconds: to.Ptr[int32](4),
	// 				TimeoutInSeconds: to.Ptr[int32](10),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](15),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](2000),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](5500),
	// 				},
	// 			},
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](30),
	// 			},
	// 		},
	// 		OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](3),
	// 				IntervalInSeconds: to.Ptr[int32](60),
	// 				TimeoutInSeconds: to.Ptr[int32](20),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](5),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](100),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](30000),
	// 				},
	// 			},
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](12),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicy_CreateOrUpdate_OutboundOnly.json
func ExampleDaprComponentResiliencyPoliciesClient_CreateOrUpdate_createOrUpdateDaprComponentResiliencyPolicyWithOutboundPolicyOnly() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprComponentResiliencyPoliciesClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mydaprcomponent", "myresiliencypolicy", armappcontainers.DaprComponentResiliencyPolicy{
		Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
			OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
				CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
					ConsecutiveErrors: to.Ptr[int32](3),
					IntervalInSeconds: to.Ptr[int32](60),
					TimeoutInSeconds:  to.Ptr[int32](20),
				},
				HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
					MaxRetries: to.Ptr[int32](5),
					RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
						InitialDelayInMilliseconds: to.Ptr[int32](100),
						MaxIntervalInMilliseconds:  to.Ptr[int32](30000),
					},
				},
				TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
					ResponseTimeoutInSeconds: to.Ptr[int32](12),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprComponentResiliencyPolicy = armappcontainers.DaprComponentResiliencyPolicy{
	// 	Name: to.Ptr("myresiliencypolicy"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprComponents/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprComponents/mydaprcomponent/resiliencyPolicies/myresiliencypolicy"),
	// 	Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
	// 		OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](3),
	// 				IntervalInSeconds: to.Ptr[int32](60),
	// 				TimeoutInSeconds: to.Ptr[int32](20),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](5),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](100),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](30000),
	// 				},
	// 			},
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](12),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicy_CreateOrUpdate_SparseOptions.json
func ExampleDaprComponentResiliencyPoliciesClient_CreateOrUpdate_createOrUpdateDaprComponentResiliencyPolicyWithSparseOptions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDaprComponentResiliencyPoliciesClient().CreateOrUpdate(ctx, "examplerg", "myenvironment", "mydaprcomponent", "myresiliencypolicy", armappcontainers.DaprComponentResiliencyPolicy{
		Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
			InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
				CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
					ConsecutiveErrors: to.Ptr[int32](3),
					TimeoutInSeconds:  to.Ptr[int32](20),
				},
				HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
					MaxRetries: to.Ptr[int32](5),
					RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
						InitialDelayInMilliseconds: to.Ptr[int32](2000),
						MaxIntervalInMilliseconds:  to.Ptr[int32](5500),
					},
				},
			},
			OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
				TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
					ResponseTimeoutInSeconds: to.Ptr[int32](12),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DaprComponentResiliencyPolicy = armappcontainers.DaprComponentResiliencyPolicy{
	// 	Name: to.Ptr("myresiliencypolicy"),
	// 	Type: to.Ptr("Microsoft.App/managedEnvironments/daprComponents/resiliencyPolicies"),
	// 	ID: to.Ptr("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/daprComponents/mydaprcomponent/resiliencyPolicies/myresiliencypolicy"),
	// 	Properties: &armappcontainers.DaprComponentResiliencyPolicyProperties{
	// 		InboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			CircuitBreakerPolicy: &armappcontainers.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration{
	// 				ConsecutiveErrors: to.Ptr[int32](3),
	// 				TimeoutInSeconds: to.Ptr[int32](20),
	// 			},
	// 			HTTPRetryPolicy: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryPolicyConfiguration{
	// 				MaxRetries: to.Ptr[int32](5),
	// 				RetryBackOff: &armappcontainers.DaprComponentResiliencyPolicyHTTPRetryBackOffConfiguration{
	// 					InitialDelayInMilliseconds: to.Ptr[int32](2000),
	// 					MaxIntervalInMilliseconds: to.Ptr[int32](5500),
	// 				},
	// 			},
	// 		},
	// 		OutboundPolicy: &armappcontainers.DaprComponentResiliencyPolicyConfiguration{
	// 			TimeoutPolicy: &armappcontainers.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration{
	// 				ResponseTimeoutInSeconds: to.Ptr[int32](12),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d74afb775446d7f0bc1810fdc5a128c56289e854/specification/app/resource-manager/Microsoft.App/preview/2023-11-02-preview/examples/DaprComponentResiliencyPolicies_Delete.json
func ExampleDaprComponentResiliencyPoliciesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappcontainers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDaprComponentResiliencyPoliciesClient().Delete(ctx, "examplerg", "myenvironment", "mydaprcomponent", "myresiliencypolicy", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
