//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armalertsmanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// TenantActivityLogAlertsClient contains the methods for the TenantActivityLogAlerts group.
// Don't use this type directly, use NewTenantActivityLogAlertsClient() instead.
type TenantActivityLogAlertsClient struct {
	internal *arm.Client
}

// NewTenantActivityLogAlertsClient creates a new instance of TenantActivityLogAlertsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewTenantActivityLogAlertsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*TenantActivityLogAlertsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &TenantActivityLogAlertsClient{
		internal: cl,
	}
	return client, nil
}

// CreateOrUpdate - Create a new Tenant Activity Log Alert rule or update an existing one.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - managementGroupName - The name of the management group. The name is case insensitive.
//   - alertRuleName - The name of the Tenant Activity Log Alert rule.
//   - tenantActivityLogAlertRule - The Tenant Activity Log Alert rule to create or use for the update.
//   - options - TenantActivityLogAlertsClientCreateOrUpdateOptions contains the optional parameters for the TenantActivityLogAlertsClient.CreateOrUpdate
//     method.
func (client *TenantActivityLogAlertsClient) CreateOrUpdate(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRule TenantActivityLogAlertResource, options *TenantActivityLogAlertsClientCreateOrUpdateOptions) (TenantActivityLogAlertsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "TenantActivityLogAlertsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, managementGroupName, alertRuleName, tenantActivityLogAlertRule, options)
	if err != nil {
		return TenantActivityLogAlertsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TenantActivityLogAlertsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return TenantActivityLogAlertsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *TenantActivityLogAlertsClient) createOrUpdateCreateRequest(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRule TenantActivityLogAlertResource, options *TenantActivityLogAlertsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts/{alertRuleName}"
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	if alertRuleName == "" {
		return nil, errors.New("parameter alertRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertRuleName}", url.PathEscape(alertRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, tenantActivityLogAlertRule); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *TenantActivityLogAlertsClient) createOrUpdateHandleResponse(resp *http.Response) (TenantActivityLogAlertsClientCreateOrUpdateResponse, error) {
	result := TenantActivityLogAlertsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantActivityLogAlertResource); err != nil {
		return TenantActivityLogAlertsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a Tenant Activity Log Alert rule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - managementGroupName - The name of the management group. The name is case insensitive.
//   - alertRuleName - The name of the Tenant Activity Log Alert rule.
//   - options - TenantActivityLogAlertsClientDeleteOptions contains the optional parameters for the TenantActivityLogAlertsClient.Delete
//     method.
func (client *TenantActivityLogAlertsClient) Delete(ctx context.Context, managementGroupName string, alertRuleName string, options *TenantActivityLogAlertsClientDeleteOptions) (TenantActivityLogAlertsClientDeleteResponse, error) {
	var err error
	const operationName = "TenantActivityLogAlertsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, managementGroupName, alertRuleName, options)
	if err != nil {
		return TenantActivityLogAlertsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TenantActivityLogAlertsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return TenantActivityLogAlertsClientDeleteResponse{}, err
	}
	return TenantActivityLogAlertsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *TenantActivityLogAlertsClient) deleteCreateRequest(ctx context.Context, managementGroupName string, alertRuleName string, options *TenantActivityLogAlertsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts/{alertRuleName}"
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	if alertRuleName == "" {
		return nil, errors.New("parameter alertRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertRuleName}", url.PathEscape(alertRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get Tenant Activity Log Alert rule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - managementGroupName - The name of the management group. The name is case insensitive.
//   - alertRuleName - The name of the Tenant Activity Log Alert rule.
//   - options - TenantActivityLogAlertsClientGetOptions contains the optional parameters for the TenantActivityLogAlertsClient.Get
//     method.
func (client *TenantActivityLogAlertsClient) Get(ctx context.Context, managementGroupName string, alertRuleName string, options *TenantActivityLogAlertsClientGetOptions) (TenantActivityLogAlertsClientGetResponse, error) {
	var err error
	const operationName = "TenantActivityLogAlertsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupName, alertRuleName, options)
	if err != nil {
		return TenantActivityLogAlertsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TenantActivityLogAlertsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return TenantActivityLogAlertsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *TenantActivityLogAlertsClient) getCreateRequest(ctx context.Context, managementGroupName string, alertRuleName string, options *TenantActivityLogAlertsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts/{alertRuleName}"
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	if alertRuleName == "" {
		return nil, errors.New("parameter alertRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertRuleName}", url.PathEscape(alertRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *TenantActivityLogAlertsClient) getHandleResponse(resp *http.Response) (TenantActivityLogAlertsClientGetResponse, error) {
	result := TenantActivityLogAlertsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantActivityLogAlertResource); err != nil {
		return TenantActivityLogAlertsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByManagementGroupPager - Get a list of all Tenant Activity Log Alert rules in a management group.
//
// Generated from API version 2023-04-01-preview
//   - managementGroupName - The name of the management group. The name is case insensitive.
//   - options - TenantActivityLogAlertsClientListByManagementGroupOptions contains the optional parameters for the TenantActivityLogAlertsClient.NewListByManagementGroupPager
//     method.
func (client *TenantActivityLogAlertsClient) NewListByManagementGroupPager(managementGroupName string, options *TenantActivityLogAlertsClientListByManagementGroupOptions) *runtime.Pager[TenantActivityLogAlertsClientListByManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[TenantActivityLogAlertsClientListByManagementGroupResponse]{
		More: func(page TenantActivityLogAlertsClientListByManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TenantActivityLogAlertsClientListByManagementGroupResponse) (TenantActivityLogAlertsClientListByManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "TenantActivityLogAlertsClient.NewListByManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByManagementGroupCreateRequest(ctx, managementGroupName, options)
			}, nil)
			if err != nil {
				return TenantActivityLogAlertsClientListByManagementGroupResponse{}, err
			}
			return client.listByManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByManagementGroupCreateRequest creates the ListByManagementGroup request.
func (client *TenantActivityLogAlertsClient) listByManagementGroupCreateRequest(ctx context.Context, managementGroupName string, options *TenantActivityLogAlertsClientListByManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts"
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagementGroupHandleResponse handles the ListByManagementGroup response.
func (client *TenantActivityLogAlertsClient) listByManagementGroupHandleResponse(resp *http.Response) (TenantActivityLogAlertsClientListByManagementGroupResponse, error) {
	result := TenantActivityLogAlertsClientListByManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantAlertRuleList); err != nil {
		return TenantActivityLogAlertsClientListByManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListByTenantPager - Get a list of all Tenant Activity Log Alert rules in the tenant.
//
// Generated from API version 2023-04-01-preview
//   - options - TenantActivityLogAlertsClientListByTenantOptions contains the optional parameters for the TenantActivityLogAlertsClient.NewListByTenantPager
//     method.
func (client *TenantActivityLogAlertsClient) NewListByTenantPager(options *TenantActivityLogAlertsClientListByTenantOptions) *runtime.Pager[TenantActivityLogAlertsClientListByTenantResponse] {
	return runtime.NewPager(runtime.PagingHandler[TenantActivityLogAlertsClientListByTenantResponse]{
		More: func(page TenantActivityLogAlertsClientListByTenantResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TenantActivityLogAlertsClientListByTenantResponse) (TenantActivityLogAlertsClientListByTenantResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "TenantActivityLogAlertsClient.NewListByTenantPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByTenantCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return TenantActivityLogAlertsClientListByTenantResponse{}, err
			}
			return client.listByTenantHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByTenantCreateRequest creates the ListByTenant request.
func (client *TenantActivityLogAlertsClient) listByTenantCreateRequest(ctx context.Context, options *TenantActivityLogAlertsClientListByTenantOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByTenantHandleResponse handles the ListByTenant response.
func (client *TenantActivityLogAlertsClient) listByTenantHandleResponse(resp *http.Response) (TenantActivityLogAlertsClientListByTenantResponse, error) {
	result := TenantActivityLogAlertsClientListByTenantResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantAlertRuleList); err != nil {
		return TenantActivityLogAlertsClientListByTenantResponse{}, err
	}
	return result, nil
}

// Update - Updates 'tags' and 'enabled' fields in an existing Tenant Alert rule. This method is used to update the Alert
// rule tags, and to enable or disable the Alert rule. To update other fields use
// CreateOrUpdate operation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - managementGroupName - The name of the management group. The name is case insensitive.
//   - alertRuleName - The name of the Tenant Activity Log Alert rule.
//   - tenantActivityLogAlertRulePatch - Parameters supplied to the operation.
//   - options - TenantActivityLogAlertsClientUpdateOptions contains the optional parameters for the TenantActivityLogAlertsClient.Update
//     method.
func (client *TenantActivityLogAlertsClient) Update(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRulePatch TenantAlertRulePatchObject, options *TenantActivityLogAlertsClientUpdateOptions) (TenantActivityLogAlertsClientUpdateResponse, error) {
	var err error
	const operationName = "TenantActivityLogAlertsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, managementGroupName, alertRuleName, tenantActivityLogAlertRulePatch, options)
	if err != nil {
		return TenantActivityLogAlertsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return TenantActivityLogAlertsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return TenantActivityLogAlertsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *TenantActivityLogAlertsClient) updateCreateRequest(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRulePatch TenantAlertRulePatchObject, options *TenantActivityLogAlertsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.AlertsManagement/tenantActivityLogAlerts/{alertRuleName}"
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	if alertRuleName == "" {
		return nil, errors.New("parameter alertRuleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{alertRuleName}", url.PathEscape(alertRuleName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, tenantActivityLogAlertRulePatch); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *TenantActivityLogAlertsClient) updateHandleResponse(resp *http.Response) (TenantActivityLogAlertsClientUpdateResponse, error) {
	result := TenantActivityLogAlertsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantActivityLogAlertResource); err != nil {
		return TenantActivityLogAlertsClientUpdateResponse{}, err
	}
	return result, nil
}
