  !
  !--------------------------------------------------------------------------------
  !
  ! <DOCUMENTATION name="startXML/backend.inc">
  !   <VERSION>
  !              ID: startXML/backend.inc,v 1.3.0  2017-08-28 Hans Ungerechts
  !              ID: startXML/backend.inc,v 1.2.3  2014-04-29 Hans Ungerechts
  !              ID: startXML/backend.inc,v 1.2.0  2012-06-13 Hans Ungerechts
  !              based on:
  !              Id: startXML/backend.inc,v 1.1.12 2012-02-20 Hans Ungerechts
  !   </VERSION>
  !   <PROGRAM>
  !                Pako
  !   </PROGRAM>
  !   <FAMILY>
  !                XML
  !   </FAMILY>
  !   <SIBLINGS>
  !
  !   </SIBLINGS>        
  !
  !   Pako include file to write XML for BACKEND
  !
  ! </DOCUMENTATION> <!-- name="startXML/backend.inc" -->
  !
  !---------------------------------------------------------------------------------
  !
  Call pako_message(seve%t,programName,                                          &
       &          " --> startXML/backend.inc,v 1.3.0  2017-08-28  ")             ! this allows to trace execution
  !
  Call pakoXMLwriteStartElement("RESOURCE","backends",                           &
       &                         comment="generated by paKo",                    &
       &                         space ="before",                                &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteStartElement("TABLE","backends",                              &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","backendName",                                &
       &                         dataType="char",                                &
       &                         comment="generated by paKo",                    &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","nPart",                                      &
       &                         dataType="int",                                 &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","resolution",                                 &
       &                         dataType="double",                              &
       &                         unit="GHz",                                     &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","bandwidth",                                  &
       &                         dataType="double",                              &
       &                         unit="GHz",                                     &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","fShift",                                     &
       &                         dataType="double",                              &
       &                         unit="GHz",                                     &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","receiver",                                   &
       &                         dataType="char",                                &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","receiver2",                                  &
       &                         dataType="char",                                &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","mode",                                       &
       &                         dataType="char",                                &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteElement("FIELD","percentage",                                 &
       &                         dataType="float",                               &
       &                         unit="%",                                       &
       &                         error=errorXML)                                 !
  !
  Call queryReceiver("EMIR", receiverIsEMIR)
  !
  !D  Write (6,*) "   --> receiverIsEMIR: ", receiverIsEMIR
  !
  If (receiverIsEMIR) Then
     !
     Call pakoXMLwriteElement("FIELD","lineName",                                &
          &                         dataType="char",                             &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteElement("FIELD","polarization",                            &
          &                         dataType="char",                             &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteElement("FIELD","subband",                                 &
          &                         dataType="char",                             &
          &                         error=errorXML)                              !
     !
  End If
  !
  Call pakoXMLwriteStartElement("DATA",                                          &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteStartElement("TABLEDATA",                                     &
       &                         comment="generated by paKo",                    &
       &                         error=errorXML)                                 !
  !
  Call queryReceiver(rec%bolo, receiverIsBolo,                                   &
       &       bolometerName = bolometerName)                                    !
  !
  Call queryReceiver(RxHolography, receiverIsHolo)
  !
  !D Write (6,*) "      RxHolography:      ", RxHolography
  !D Write (6,*) "      receiverIsHolo:    ", receiverIsHolo
  !
  !
  If (receiverIsBolo) Then
     Call pakoXMLwriteStartElement("TR",                                         &
          &                         error=errorXML)                              !
     !
     valueC = '--'
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,*) 1
     valueC = ''
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)') 50.0  !!  old nominal value
     valueC = ''
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)') 50.0  !!  old nominal value
     valueC = ''
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')  0.0
     valueC = ''
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = bolometerName
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = "--"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = "--"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(F10.3)') 100.0  !!  old nominal value
     valueC = ''
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteEndElement("TR",                                           &
          &                         error=errorXML)                              !
  Else If (receiverIsHolo) Then
     !
     Call pakoXMLwriteStartElement("TR",                                         &
          &                         error=errorXML)                              !
     !
     valueC = "BBC"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,*) "1"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 4.0/1.0D3                                            !
     Write (valueComment,*) 4.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 4.0/1.0D3                                            !
     Write (valueComment,*) 4.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 0.0/1.0D3                                            !
     Write (valueComment,*) 0.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     valueC = RxHolography(1:len_trim(RxHolography))//"-S"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = "--"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = BEmode%Simp
     !
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(F10.3)')                                                    &
          &                  100.0                                               !
     Write (valueComment,'(F10.0,A)') 100.0, " %"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteEndElement("TR",                                           &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteStartElement("TR",                                         &
          &                         error=errorXML)                              !
     !
     valueC = "BBC"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,*) "2"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 4.0/1.0D3                                            !
     Write (valueComment,*) 4.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 4.0/1.0D3                                            !
     Write (valueComment,*) 4.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 0.0/1.0D3                                            !
     Write (valueComment,*) 0.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     valueC = RxHolography(1:len_trim(RxHolography))//"-R"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = "--"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = BEmode%Simp
     !
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(F10.3)')                                                    &
          &                  100.0                                               !
     Write (valueComment,'(F10.0,A)') 100.0, " %"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteEndElement("TR",                                           &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteStartElement("TR",                                         &
          &                         error=errorXML)                              !
     !
     valueC = "HP35670A"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,*) "1"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 4/1.0D9                                              !
     Write (valueComment,*) 4,' Hz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 400.0/1.0D9                                          !
     Write (valueComment,*) 400.0,' Hz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(ES20.6)')                                                   &
          &                 0.0/1.0D3                                            !
     Write (valueComment,*) 0.0,' MHz' 
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     valueC = RxHolography(1:len_trim(RxHolography))
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = "--"
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     valueC = BEmode%Simp
     !
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         error=errorXML)                              !
     !
     Write (valueC,'(F10.3)')                                                    &
          &                  100.0                                               !
     Write (valueComment,'(F10.0,A)') 100.0, " %"         
     Call pakoXMLwriteElement("TD",                                              &
          &                         content=valueC,                              &
          &                         comment=valueComment,                        &
          &                         error=errorXML)                              !
     !
     Call pakoXMLwriteEndElement("TR",                                           &
          &                         error=errorXML)                              !
     !
     ! **
  Else
     !
     ! **
     Do jj = 1,nDimBackends,1
        Do ii = 1,nDimParts,1
           If (listBe(jj,ii)%isConnected) Then
              Call pakoXMLwriteStartElement("TR",                                &
                   &                         error=errorXML)                     !
              !
              valueC = listBe(jj,ii)%name
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         error=errorXML)                     !
              !
              Write (valueC,*)                                                   &
                   &                  listBe(jj,ii)%nPart                        !
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         error=errorXML)                     !
              !
              Write (valueC,'(ES20.6)')                                          &
                   &                  listBe(jj,ii)%resolution/1.0D3             !
              Write (valueComment,*) listBe(jj,ii)%resolution,'MHz' 
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         comment=valueComment,               &
                   &                         error=errorXML)                     !
              !
              Write (valueC,'(ES20.6)')                                          &
                   &                  listBe(jj,ii)%bandwidth/1.0D3              !
              Write (valueComment,*) listBe(jj,ii)%bandwidth,'MHz' 
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         comment=valueComment,               &
                   &                         error=errorXML)                     !
              !
              Write (valueC,'(ES20.6)')                                          &
                   &                  listBe(jj,ii)%fShift/1.0D3                 !
              Write (valueComment,*) listBe(jj,ii)%fShift,'MHz' 
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         comment=valueComment,               &
                   &                         error=errorXML)                     !
              !
              valueC = listBe(jj,ii)%receiverName
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         error=errorXML)                     !
              !
              If (listBe(jj,ii)%receiverName2 .Ne. GPnone) Then
                 valueC = listBe(jj,ii)%receiverName2
              Else
                 valueC = "--"
              End If
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         error=errorXML)                     !
              !
              If (listBe(jj,ii)%mode .Ne. GPnone) Then
                 valueC = listBe(jj,ii)%mode
              Else
                 valueC = "--"
                 valueC = BEmode%Simp
              End If
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         error=errorXML)                     !
              !
              Write (valueC,'(F10.3)')                                           &
                   &                  listBe(jj,ii)%percentage                   !
              Write (valueComment,'(F10.0,A)') listBe(jj,ii)%percentage," %"
              Call pakoXMLwriteElement("TD",                                     &
                   &                         content=valueC,                     &
                   &                         comment=valueComment,               &
                   &                         error=errorXML)                     !
              !
              !  ** EMIR
              !
              If     (                                                           &
                   &        listBe(jj,ii)%receiverName.Eq.rec%E090               &
                   &   .Or. listBe(jj,ii)%receiverName.Eq.rec%E150               &
                   &   .Or. listBe(jj,ii)%receiverName.Eq.rec%E230               &
                   &   .Or. listBe(jj,ii)%receiverName.Eq.rec%E300               &
                   & ) Then                                                      !
                 !
                 If     (       listBe(jj,ii)%lineNameIsSet                      &
                      &   .And. listBe(jj,ii)%lineName .Ne. GPnone               &
                      &   .And. listBe(jj,ii)%lineName .Ne. "") Then             !
                    valueC = listBe(jj,ii)%linename
                 Else
                    valueC = "--"
                 End If
                 Call pakoXMLwriteElement("TD",                                  &
                      &                         content=valueC,                  &
                      &                         error=errorXML)                  !
                 !
                 valueC = listBe(jj,ii)%polarization
                 Call pakoXMLwriteElement("TD",                                  &
                      &                         content=valueC,                  & 
                      &                         error=errorXML)                  !
                 !
                 valueC = listBe(jj,ii)%subband
                 Call pakoXMLwriteElement("TD",                                  &
                      &                         content=valueC,                  &
                      &                         error=errorXML)                  !
                 !
              End If
              !
              Call pakoXMLwriteEndElement("TR",                                  &
                   &                         error=errorXML)                     !
              !
           End If
           !
        End Do   !!   ii = 1,nDimParts,1
        !
        !D       Write (6,*) " jj:  ", jj, " listBe(jj,1)%name: ", listBe(jj,1)%name
        !D       If (          listBe(jj,1)%name.Eq.bac%BBC                                 &
        !D            &  .Or.  listBe(jj,1)%name.Eq.bac%VESPA                               &
        !D            &  .Or.  listBe(jj,1)%name.Eq.bac%WILMA                               &
        !D            &  ) Then                                                             !
        !D          Write (6,*) " vars(iValue,jj)%samplesIsSet: ",                          &
        !D               &        vars(iValue,jj)%samplesIsSet
        !D          Write (6,*) " vars(iValue,jj)%nSamples:     ",                          &
        !D               &        vars(iValue,jj)%nSamples
        !D       End If
        !
     End Do   !!   jj = 1,nDimBackends,1
     !
  End If   !!   If (receiverIsBolo) Then ... Else branch
  !
  ! **
  !
  Call pakoXMLwriteEndElement  ("TABLEDATA",                                     &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteEndElement  ("DATA",                                          &
       &                         error=errorXML)                                 !
  !
  Call pakoXMLwriteEndElement  ("TABLE","backends",                              &
       &                         error=errorXML)                                 !
  !
  If     (      vars(iValue,iBBC)%samplesIsSet                                   &
       &   .Or. vars(iValue,iVESPA)%samplesIsSet                                 &
       &   .Or. vars(iValue,iWILMA)%samplesIsSet)  Then                          !
     !
     Call pakoXMLwriteStartElement("RESOURCE","options",                         &
          &                         error=errorXML)                              !
     Call pakoXMLwriteStartElement("RESOURCE","samples",                         &
          &                         error=errorXML)                              !
     !
     If ( vars(iValue,iBBC)%samplesIsSet ) Then
        Write (valueC,*) vars(iValue,iBBC)%nSamples
        Call pakoXMLwriteElement("PARAM","nSamplesBBC",valueC,                   &
             &                         dataType="int",                           &
             &                         unit="--",                                &
             &                         error=errorXML)                           !
     End If
     !
     If ( vars(iValue,iVESPA)%samplesIsSet ) Then
        Write (valueC,*) vars(iValue,iVESPA)%nSamples
        Call pakoXMLwriteElement("PARAM","nSamplesVESPA",valueC,                 &
             &                         dataType="int",                           &
             &                         unit="--",                                &
             &                         error=errorXML)                           !
     End If
     !
     If ( vars(iValue,iWILMA)%samplesIsSet ) Then
        Write (valueC,*) vars(iValue,iWILMA)%nSamples
        Call pakoXMLwriteElement("PARAM","nSamplesWILMA",valueC,                 &
             &                         dataType="int",                           &
             &                         unit="--",                                &
             &                         error=errorXML)                           !
     End If
     !   
     Call pakoXMLwriteEndElement  ("RESOURCE","samples",                         &
          &                         error=errorXML)                              !
     Call pakoXMLwriteEndElement  ("RESOURCE","options",                         &
          &                         error=errorXML)                              !
     !
  End If
  !
  Call pakoXMLwriteEndElement  ("RESOURCE","backends",                           &
       &                         space="after",                                  &
       &                         error=errorXML)                                 !
  !



