/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.apm;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.ApplePartitionMap;
import org.catacombae.hfsexplorer.partitioning.DriverDescriptorRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.ps.PartitionSystemRecognizer;

public class APMRecognizer
implements PartitionSystemRecognizer {
    public boolean detect(ReadableRandomAccessStream fsStream, long offset, long length) {
        try {
            int blockSize;
            ApplePartitionMap apm;
            byte[] firstBlock = new byte[512];
            fsStream.seek(0L);
            fsStream.readFully(firstBlock);
            DriverDescriptorRecord ddr = new DriverDescriptorRecord(firstBlock, 0);
            if (ddr.isValid() && (apm = new ApplePartitionMap(fsStream, (long)((blockSize = Util.unsign(ddr.getSbBlkSize())) * 1), blockSize)).getUsedPartitionCount() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }
}

