/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.PrintStream;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.FileSystemBrowser;
import org.catacombae.hfsexplorer.fs.BaseHFSFileSystemView;
import org.catacombae.hfsexplorer.gui.FileInfoPanel;
import org.catacombae.hfsexplorer.gui.FolderInfoPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.hfsexplorer.io.JTextAreaOutputStream;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafRecord;
import org.jdesktop.layout.GroupLayout;

public class ExtentsInfoPanel
extends JPanel {
    private static final int UNIT_INCREMENT = 10;
    public JTree catalogTree;
    private JScrollPane catalogTreeScroller;
    private JLabel descriptionLabel;
    private JPanel infoPanel;
    private JPanel jPanel1;
    private JSplitPane jSplitPane1;

    public ExtentsInfoPanel(final BaseHFSFileSystemView fsView) {
        this.initComponents();
        JTree dirTree = this.catalogTree;
        CommonBTNode iNode = fsView.getExtentsOverflowNode(-1L);
        if (iNode == null) {
            DefaultTreeModel model = new DefaultTreeModel(new FileSystemBrowser.NoLeafMutableTreeNode("<empty>"));
            dirTree.setModel(model);
            return;
        }
        FileSystemBrowser.NoLeafMutableTreeNode rootNode = new FileSystemBrowser.NoLeafMutableTreeNode(new BTNodeStorage(iNode, "Extents overflow root"));
        this.expandNode(rootNode, iNode, fsView);
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        dirTree.setModel(model);
        dirTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                Object obj2;
                DefaultMutableTreeNode dmtn;
                TreePath tp = e.getPath();
                Object obj = tp.getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode) {
                    dmtn = (DefaultMutableTreeNode)obj;
                    obj2 = dmtn.getUserObject();
                    if (!(obj2 instanceof BTNodeStorage)) {
                        throw new RuntimeException("Wrong user object type in expandable node!");
                    }
                } else {
                    throw new RuntimeException("Wrong node type in tree!");
                }
                CommonBTNode node = ((BTNodeStorage)obj2).getNode();
                ExtentsInfoPanel.this.expandNode(dmtn, node, fsView);
            }

            public void treeWillCollapse(TreeExpansionEvent e) {
            }
        });
        String INDEX_NAME = "index";
        String LEAF_NAME = "leaf";
        String PRINT_FIELDS_AREA_NAME = "printfieldsarea";
        String OTHER_NAME = "other";
        String FILE_NAME = "file";
        String FOLDER_NAME = "folder";
        String FILE_THREAD_NAME = "filethread";
        String FOLDER_THREAD_NAME = "folderthread";
        String STRUCT_VIEW_PANEL_NAME = "structview";
        final CardLayout clRoot = new CardLayout();
        final JPanel leafPanel = new JPanel();
        final CardLayout clLeaf = new CardLayout();
        leafPanel.setLayout(clLeaf);
        leafPanel.add((Component)new JLabel("INTERNAL ERROR!", 0), "other");
        leafPanel.add((Component)new JLabel("Displaying file thread information is not yet supported.", 0), "filethread");
        leafPanel.add((Component)new JLabel("Displaying folder thread information is not yet supported.", 0), "folderthread");
        final JScrollPane structViewPanelScroller = new JScrollPane();
        structViewPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        structViewPanelScroller.getHorizontalScrollBar().setUnitIncrement(10);
        leafPanel.add((Component)structViewPanelScroller, "structview");
        FileInfoPanel fileInfoPanel = new FileInfoPanel();
        JScrollPane fileInfoPanelScroller = new JScrollPane(fileInfoPanel);
        fileInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        fileInfoPanelScroller.getHorizontalScrollBar().setUnitIncrement(10);
        leafPanel.add((Component)fileInfoPanelScroller, "file");
        FolderInfoPanel folderInfoPanel = new FolderInfoPanel();
        JScrollPane folderInfoPanelScroller = new JScrollPane(folderInfoPanel);
        folderInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        folderInfoPanelScroller.getHorizontalScrollBar().setUnitIncrement(10);
        leafPanel.add((Component)folderInfoPanelScroller, "folder");
        final JTextArea printFieldsTextArea = new JTextArea(0, 0);
        printFieldsTextArea.setEditable(false);
        printFieldsTextArea.setLineWrap(false);
        JScrollPane printFieldsTextAreaScroller = new JScrollPane(printFieldsTextArea);
        printFieldsTextAreaScroller.getVerticalScrollBar().setUnitIncrement(10);
        printFieldsTextAreaScroller.getHorizontalScrollBar().setUnitIncrement(10);
        leafPanel.add((Component)printFieldsTextAreaScroller, "printfieldsarea");
        this.infoPanel.setLayout(clRoot);
        final JLabel indexNodeLabel = new JLabel("No selection.", 0);
        this.infoPanel.add((Component)indexNodeLabel, "index");
        this.infoPanel.add((Component)leafPanel, "leaf");
        this.catalogTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent te) {
                Object o = te.getPath().getLastPathComponent();
                if (o instanceof DefaultMutableTreeNode) {
                    Object o2 = ((DefaultMutableTreeNode)o).getUserObject();
                    if (o2 instanceof BTNodeStorage) {
                        CommonBTNode btn = ((BTNodeStorage)o2).getNode();
                        CommonBTNodeDescriptor btnd = btn.getNodeDescriptor();
                        switch (btnd.getNodeType()) {
                            case INDEX: {
                                indexNodeLabel.setText("Index node with " + btnd.getNumberOfRecords() + " records.");
                                break;
                            }
                            case LEAF: {
                                indexNodeLabel.setText("Leaf node with " + btnd.getNumberOfRecords() + " records.");
                                break;
                            }
                            default: {
                                indexNodeLabel.setText("Unknown error!");
                            }
                        }
                        clRoot.show(ExtentsInfoPanel.this.infoPanel, "index");
                    } else if (o2 instanceof ExtentLeafStorage) {
                        CommonHFSExtentLeafRecord rec = ((ExtentLeafStorage)o2).getRecord();
                        if (rec instanceof StructElements) {
                            Dictionary dict = rec.getStructElements();
                            String label = dict.getTypeDescription();
                            if (label == null) {
                                label = dict.getTypeName();
                            }
                            structViewPanelScroller.setViewportView(new StructViewPanel(label + ":", dict));
                            clLeaf.show(leafPanel, "structview");
                        } else if (rec instanceof PrintableStruct) {
                            PrintStream ps = new PrintStream(new JTextAreaOutputStream(System.err, printFieldsTextArea));
                            printFieldsTextArea.setText("");
                            rec.print(ps, "");
                            ps.close();
                            printFieldsTextArea.setCaretPosition(0);
                            clLeaf.show(leafPanel, "printfieldsarea");
                        } else {
                            System.err.println("CatalogInfoPanel: Could not show record type " + rec.getClass());
                            clLeaf.show(leafPanel, "other");
                        }
                        clRoot.show(ExtentsInfoPanel.this.infoPanel, "leaf");
                    } else {
                        System.err.println("WARNING: unknown type in catalog tree user object - " + o2.getClass().toString());
                    }
                } else {
                    System.err.println("WARNING: unknown type in catalog tree - " + o.getClass().toString());
                }
            }
        });
    }

    public void expandNode(DefaultMutableTreeNode dmtn, CommonBTNode node, BaseHFSFileSystemView fsView) {
        if (node instanceof CommonHFSExtentIndexNode) {
            List recs = ((CommonHFSExtentIndexNode)node).getBTRecords();
            for (CommonBTIndexRecord rec : recs) {
                CommonBTNode curNode = fsView.getExtentsOverflowNode(rec.getIndex());
                CommonHFSExtentKey key = (CommonHFSExtentKey)rec.getKey();
                dmtn.add(new FileSystemBrowser.NoLeafMutableTreeNode(new BTNodeStorage(curNode, key.getForkType() + ":" + key.getFileID().toLong() + ":" + key.getStartBlock())));
            }
        } else if (node instanceof CommonHFSExtentLeafNode) {
            CommonHFSExtentLeafRecord[] recs;
            for (CommonHFSExtentLeafRecord rec : recs = ((CommonHFSExtentLeafNode)node).getLeafRecords()) {
                CommonHFSExtentKey key = rec.getKey();
                dmtn.add(new DefaultMutableTreeNode(new ExtentLeafStorage(rec, key.getForkType() + ":" + key.getFileID().toLong() + ":" + key.getStartBlock())));
            }
        } else {
            throw new RuntimeException("Invalid node type in tree: " + node);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.catalogTreeScroller = new JScrollPane();
        this.catalogTree = new JTree();
        this.infoPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.jSplitPane1.setDividerLocation(330);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.catalogTreeScroller.setViewportView(this.catalogTree);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.catalogTreeScroller, -1, 359, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.catalogTreeScroller, -1, 329, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.infoPanel.setPreferredSize(new Dimension(100, 140));
        GroupLayout infoPanelLayout = new GroupLayout((Container)this.infoPanel);
        this.infoPanel.setLayout((LayoutManager)infoPanelLayout);
        infoPanelLayout.setHorizontalGroup((GroupLayout.Group)infoPanelLayout.createParallelGroup(1).add(0, 359, Short.MAX_VALUE));
        infoPanelLayout.setVerticalGroup((GroupLayout.Group)infoPanelLayout.createParallelGroup(1).add(0, 101, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.infoPanel);
        this.descriptionLabel.setText("View of the extent overflow file's B*-tree:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 361, Short.MAX_VALUE).add((Component)this.descriptionLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.descriptionLabel).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 437, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ExtentLeafStorage {
        private CommonHFSExtentLeafRecord rec;
        private String text;

        public ExtentLeafStorage(CommonHFSExtentLeafRecord rec, String text) {
            this.rec = rec;
            this.text = text;
        }

        public CommonHFSExtentLeafRecord getRecord() {
            return this.rec;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class BTNodeStorage {
        private CommonBTNode node;
        private String text;

        public BTNodeStorage(CommonBTNode node, String text) {
            this.node = node;
            this.text = text;
        }

        public CommonBTNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.text;
        }
    }
}

