/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import java.util.zip.CRC32;
import org.catacombae.io.ReadableRandomAccessStream;

public class ReadableCRC32FilterStream
implements ReadableRandomAccessStream {
    private ReadableRandomAccessStream source;
    private CRC32 checksum;

    public ReadableCRC32FilterStream(ReadableRandomAccessStream source) {
        this.source = source;
        this.checksum = new CRC32();
    }

    public int getChecksumValue() {
        return (int)(this.checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public void resetChecksum() {
        this.checksum.reset();
    }

    public void seek(long pos) {
        this.source.seek(pos);
    }

    public int read() {
        int res = this.source.read();
        if (res > 0) {
            this.checksum.update(res);
        }
        return res;
    }

    public int read(byte[] data) {
        int res = this.source.read(data);
        if (res > 0) {
            this.checksum.update(data, 0, res);
        }
        return res;
    }

    public int read(byte[] data, int pos, int len) {
        int res = this.source.read(data);
        if (res > 0) {
            this.checksum.update(data, pos, res);
        }
        return res;
    }

    public void readFully(byte[] data) {
        this.source.readFully(data);
        this.checksum.update(data);
    }

    public void readFully(byte[] data, int offset, int length) {
        this.source.readFully(data, offset, length);
        this.checksum.update(data, offset, length);
    }

    public long length() {
        return this.source.length();
    }

    public long getFilePointer() {
        return this.source.getFilePointer();
    }

    public void close() {
        this.source.close();
    }
}

