/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.mbr;

import org.catacombae.hfsexplorer.partitioning.MBRPartitionTable;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.StandardPartition;

public class MBRHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public MBRHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        MBRPartitionTable apm = this.readPartitionTable();
        return apm.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        MBRPartitionTable partitionTable = this.readPartitionTable();
        Partition[] result = new Partition[partitionTable.getUsedPartitionCount()];
        org.catacombae.hfsexplorer.partitioning.Partition[] parts = partitionTable.getUsedPartitionEntries();
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StandardPartition(parts[i].getStartOffset(), parts[i].getLength(), parts[i].getType());
        }
        return result;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBRPartitionTable readPartitionTable() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            MBRPartitionTable mbt = new MBRPartitionTable(firstBlock, 0);
            if (mbt.isValid()) {
                MBRPartitionTable mBRPartitionTable = mbt;
                return mBRPartitionTable;
            }
            MBRPartitionTable mBRPartitionTable = null;
            return mBRPartitionTable;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

