{-# LANGUAGE MagicHash, UnboxedTuples, ExtendedLiterals #-}
import GHC.Int
import GHC.Prim

test :: (Int, Int, Int, Int, Int, Int, Int, Int) -> (Int16X8# -> Int16X8# -> Int16X8#) -> IO ()
test t shuffle = do
  let a = packInt16X8# (# 0#Int16, 10#Int16, 20#Int16, 30#Int16, 40#Int16, 50#Int16, 60#Int16, 70#Int16 #)
      b = packInt16X8# (# 80#Int16, 90#Int16, 100#Int16, 110#Int16, 120#Int16, 130#Int16, 140#Int16, 150#Int16 #)
      c = shuffle a b
      (# x0, x1, x2, x3, x4, x5, x6, x7 #) = unpackInt16X8# c
  putStrLn $ show t ++ ": " ++ show (I16# x0, I16# x1, I16# x2, I16# x3, I16# x4, I16# x5, I16# x6, I16# x7)
{-# NOINLINE test #-}

test0x :: (Int, Int, Int, Int, Int, Int, Int, Int) -> (Int16X8# -> Int16X8#) -> IO ()
test0x t shuffle = do
  let b = packInt16X8# (# 80#Int16, 90#Int16, 100#Int16, 110#Int16, 120#Int16, 130#Int16, 140#Int16, 150#Int16 #)
      c = shuffle b
      (# x0, x1, x2, x3, x4, x5, x6, x7 #) = unpackInt16X8# c
  putStrLn $ show t ++ ": " ++ show (I16# x0, I16# x1, I16# x2, I16# x3, I16# x4, I16# x5, I16# x6, I16# x7)
{-# NOINLINE test0x #-}

testx0 :: (Int, Int, Int, Int, Int, Int, Int, Int) -> (Int16X8# -> Int16X8#) -> IO ()
testx0 t shuffle = do
  let a = packInt16X8# (# 100#Int16, 101#Int16, 102#Int16, 103#Int16, 104#Int16, 105#Int16, 106#Int16, 107#Int16 #)
      c = shuffle a
      (# x0, x1, x2, x3, x4, x5, x6, x7 #) = unpackInt16X8# c
  putStrLn $ show t ++ ": " ++ show (I16# x0, I16# x1, I16# x2, I16# x3, I16# x4, I16# x5, I16# x6, I16# x7)
{-# NOINLINE testx0 #-}

main :: IO ()
main = do
  test (0, 0, 0, 0, 0, 0, 0, 0) $ \a b -> shuffleInt16X8# a b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test (0, 1, 0, 2, 3, 2, 0, 1) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 0#, 2#, 3#, 2#, 0#, 1# #)
  test (0, 1, 2, 3, 0, 1, 2, 3) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 2#, 3#, 0#, 1#, 2#, 3# #)
  test (0, 1, 2, 3, 4, 5, 6, 7) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 2#, 3#, 4#, 5#, 6#, 7# #)
  test (0, 1, 2, 3, 8, 9, 10, 11) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 2#, 3#, 8#, 9#, 10#, 11# #)
  test (0, 1, 2, 3, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 2#, 3#, 12#, 13#, 14#, 15# #)
  test (0, 1, 10, 11, 4, 5, 14, 15) $ \a b -> shuffleInt16X8# a b (# 0#, 1#, 10#, 11#, 4#, 5#, 14#, 15# #)
  test (0, 2, 1, 1, 11, 11, 9, 8) $ \a b -> shuffleInt16X8# a b (# 0#, 2#, 1#, 1#, 11#, 11#, 9#, 8# #)
  test (0, 2, 2, 1, 8, 9, 8, 10) $ \a b -> shuffleInt16X8# a b (# 0#, 2#, 2#, 1#, 8#, 9#, 8#, 10# #)
  test (0, 3, 0, 0, 12, 12, 14, 14) $ \a b -> shuffleInt16X8# a b (# 0#, 3#, 0#, 0#, 12#, 12#, 14#, 14# #)
  test (0, 3, 1, 0, 9, 9, 9, 8) $ \a b -> shuffleInt16X8# a b (# 0#, 3#, 1#, 0#, 9#, 9#, 9#, 8# #)
  test (0, 3, 2, 3, 2, 2, 2, 1) $ \a b -> shuffleInt16X8# a b (# 0#, 3#, 2#, 3#, 2#, 2#, 2#, 1# #)
  test (0, 3, 3, 3, 6, 7, 4, 6) $ \a b -> shuffleInt16X8# a b (# 0#, 3#, 3#, 3#, 6#, 7#, 4#, 6# #)
  test (0, 3, 3, 3, 15, 15, 13, 12) $ \a b -> shuffleInt16X8# a b (# 0#, 3#, 3#, 3#, 15#, 15#, 13#, 12# #)
  test (0, 6, 3, 5, 6, 1, 4, 14) $ \a b -> shuffleInt16X8# a b (# 0#, 6#, 3#, 5#, 6#, 1#, 4#, 14# #)
  test (0, 8, 1, 9, 2, 10, 3, 11) $ \a b -> shuffleInt16X8# a b (# 0#, 8#, 1#, 9#, 2#, 10#, 3#, 11# #)
  test (0, 8, 11, 9, 15, 14, 5, 6) $ \a b -> shuffleInt16X8# a b (# 0#, 8#, 11#, 9#, 15#, 14#, 5#, 6# #)
  test (0, 9, 2, 3, 12, 13, 6, 7) $ \a b -> shuffleInt16X8# a b (# 0#, 9#, 2#, 3#, 12#, 13#, 6#, 7# #)
  test (0, 9, 2, 11, 4, 13, 6, 7) $ \a b -> shuffleInt16X8# a b (# 0#, 9#, 2#, 11#, 4#, 13#, 6#, 7# #)
  test (0, 9, 2, 11, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 0#, 9#, 2#, 11#, 12#, 13#, 14#, 15# #)
  test (0, 9, 10, 11, 12, 5, 6, 15) $ \a b -> shuffleInt16X8# a b (# 0#, 9#, 10#, 11#, 12#, 5#, 6#, 15# #)
  test (0, 10, 9, 1, 4, 14, 14, 13) $ \a b -> shuffleInt16X8# a b (# 0#, 10#, 9#, 1#, 4#, 14#, 14#, 13# #)
  test (1, 0, 2, 0, 14, 15, 15, 13) $ \a b -> shuffleInt16X8# a b (# 1#, 0#, 2#, 0#, 14#, 15#, 15#, 13# #)
  test (1, 0, 2, 10, 14, 15, 6, 7) $ \a b -> shuffleInt16X8# a b (# 1#, 0#, 2#, 10#, 14#, 15#, 6#, 7# #)
  test (1, 1, 0, 0, 2, 1, 2, 0) $ \a b -> shuffleInt16X8# a b (# 1#, 1#, 0#, 0#, 2#, 1#, 2#, 0# #)
  test (1, 1, 1, 1, 1, 1, 1, 1) $ \a b -> shuffleInt16X8# a b (# 1#, 1#, 1#, 1#, 1#, 1#, 1#, 1# #)
  test (1, 1, 3, 2, 8, 11, 10, 9) $ \a b -> shuffleInt16X8# a b (# 1#, 1#, 3#, 2#, 8#, 11#, 10#, 9# #)
  test (1, 2, 1, 4, 1, 8, 11, 5) $ \a b -> shuffleInt16X8# a b (# 1#, 2#, 1#, 4#, 1#, 8#, 11#, 5# #)
  test (1, 2, 3, 4, 5, 6, 7, 8) $ \a b -> shuffleInt16X8# a b (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  test (1, 3, 8, 8, 13, 15, 14, 13) $ \a b -> shuffleInt16X8# a b (# 1#, 3#, 8#, 8#, 13#, 15#, 14#, 13# #)
  test (1, 5, 10, 11, 6, 9, 11, 6) $ \a b -> shuffleInt16X8# a b (# 1#, 5#, 10#, 11#, 6#, 9#, 11#, 6# #)
  test (1, 7, 5, 5, 9, 2, 6, 15) $ \a b -> shuffleInt16X8# a b (# 1#, 7#, 5#, 5#, 9#, 2#, 6#, 15# #)
  test (1, 9, 10, 8, 5, 5, 15, 7) $ \a b -> shuffleInt16X8# a b (# 1#, 9#, 10#, 8#, 5#, 5#, 15#, 7# #)
  test (1, 10, 0, 8, 11, 11, 2, 1) $ \a b -> shuffleInt16X8# a b (# 1#, 10#, 0#, 8#, 11#, 11#, 2#, 1# #)
  test (1, 11, 15, 9, 2, 3, 3, 0) $ \a b -> shuffleInt16X8# a b (# 1#, 11#, 15#, 9#, 2#, 3#, 3#, 0# #)
  test (1, 12, 8, 15, 8, 4, 11, 12) $ \a b -> shuffleInt16X8# a b (# 1#, 12#, 8#, 15#, 8#, 4#, 11#, 12# #)
  test (1, 14, 10, 9, 5, 9, 13, 6) $ \a b -> shuffleInt16X8# a b (# 1#, 14#, 10#, 9#, 5#, 9#, 13#, 6# #)
  test (2, 0, 9, 10, 9, 11, 2, 3) $ \a b -> shuffleInt16X8# a b (# 2#, 0#, 9#, 10#, 9#, 11#, 2#, 3# #)
  test (2, 0, 11, 11, 10, 3, 8, 1) $ \a b -> shuffleInt16X8# a b (# 2#, 0#, 11#, 11#, 10#, 3#, 8#, 1# #)
  test (2, 1, 1, 0, 15, 14, 14, 14) $ \a b -> shuffleInt16X8# a b (# 2#, 1#, 1#, 0#, 15#, 14#, 14#, 14# #)
  test (2, 1, 2, 0, 2, 2, 1, 0) $ \a b -> shuffleInt16X8# a b (# 2#, 1#, 2#, 0#, 2#, 2#, 1#, 0# #)
  test (2, 1, 2, 3, 4, 7, 6, 4) $ \a b -> shuffleInt16X8# a b (# 2#, 1#, 2#, 3#, 4#, 7#, 6#, 4# #)
  test (2, 1, 5, 3, 14, 14, 5, 0) $ \a b -> shuffleInt16X8# a b (# 2#, 1#, 5#, 3#, 14#, 14#, 5#, 0# #)
  test (2, 2, 2, 2, 2, 2, 2, 2) $ \a b -> shuffleInt16X8# a b (# 2#, 2#, 2#, 2#, 2#, 2#, 2#, 2# #)
  test (2, 2, 3, 0, 4, 5, 4, 7) $ \a b -> shuffleInt16X8# a b (# 2#, 2#, 3#, 0#, 4#, 5#, 4#, 7# #)
  test (2, 2, 3, 3, 1, 0, 2, 1) $ \a b -> shuffleInt16X8# a b (# 2#, 2#, 3#, 3#, 1#, 0#, 2#, 1# #)
  test (2, 3, 1, 1, 13, 15, 15, 14) $ \a b -> shuffleInt16X8# a b (# 2#, 3#, 1#, 1#, 13#, 15#, 15#, 14# #)
  test (2, 3, 2, 0, 5, 7, 5, 5) $ \a b -> shuffleInt16X8# a b (# 2#, 3#, 2#, 0#, 5#, 7#, 5#, 5# #)
  test (2, 3, 4, 5, 6, 7, 8, 9) $ \a b -> shuffleInt16X8# a b (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 9# #)
  test (2, 3, 10, 3, 3, 0, 2, 14) $ \a b -> shuffleInt16X8# a b (# 2#, 3#, 10#, 3#, 3#, 0#, 2#, 14# #)
  test (2, 8, 15, 3, 1, 15, 7, 0) $ \a b -> shuffleInt16X8# a b (# 2#, 8#, 15#, 3#, 1#, 15#, 7#, 0# #)
  test (2, 10, 7, 13, 12, 11, 4, 0) $ \a b -> shuffleInt16X8# a b (# 2#, 10#, 7#, 13#, 12#, 11#, 4#, 0# #)
  test (2, 10, 13, 6, 15, 11, 8, 8) $ \a b -> shuffleInt16X8# a b (# 2#, 10#, 13#, 6#, 15#, 11#, 8#, 8# #)
  test (3, 0, 2, 8, 5, 12, 6, 5) $ \a b -> shuffleInt16X8# a b (# 3#, 0#, 2#, 8#, 5#, 12#, 6#, 5# #)
  test (3, 1, 15, 11, 14, 0, 10, 13) $ \a b -> shuffleInt16X8# a b (# 3#, 1#, 15#, 11#, 14#, 0#, 10#, 13# #)
  test (3, 2, 0, 2, 11, 9, 11, 11) $ \a b -> shuffleInt16X8# a b (# 3#, 2#, 0#, 2#, 11#, 9#, 11#, 11# #)
  test (3, 2, 1, 0, 5, 7, 4, 6) $ \a b -> shuffleInt16X8# a b (# 3#, 2#, 1#, 0#, 5#, 7#, 4#, 6# #)
  test (3, 3, 3, 3, 3, 3, 3, 3) $ \a b -> shuffleInt16X8# a b (# 3#, 3#, 3#, 3#, 3#, 3#, 3#, 3# #)
  test (3, 4, 5, 6, 7, 8, 9, 10) $ \a b -> shuffleInt16X8# a b (# 3#, 4#, 5#, 6#, 7#, 8#, 9#, 10# #)
  test (3, 6, 11, 10, 12, 13, 9, 5) $ \a b -> shuffleInt16X8# a b (# 3#, 6#, 11#, 10#, 12#, 13#, 9#, 5# #)
  test (3, 9, 10, 3, 0, 2, 9, 9) $ \a b -> shuffleInt16X8# a b (# 3#, 9#, 10#, 3#, 0#, 2#, 9#, 9# #)
  test (3, 13, 15, 15, 8, 1, 6, 12) $ \a b -> shuffleInt16X8# a b (# 3#, 13#, 15#, 15#, 8#, 1#, 6#, 12# #)
  test (3, 15, 12, 4, 9, 3, 2, 2) $ \a b -> shuffleInt16X8# a b (# 3#, 15#, 12#, 4#, 9#, 3#, 2#, 2# #)
  test (4, 0, 7, 2, 6, 13, 8, 8) $ \a b -> shuffleInt16X8# a b (# 4#, 0#, 7#, 2#, 6#, 13#, 8#, 8# #)
  test (4, 1, 12, 10, 12, 10, 12, 0) $ \a b -> shuffleInt16X8# a b (# 4#, 1#, 12#, 10#, 12#, 10#, 12#, 0# #)
  test (4, 4, 4, 4, 4, 4, 4, 4) $ \a b -> shuffleInt16X8# a b (# 4#, 4#, 4#, 4#, 4#, 4#, 4#, 4# #)
  test (4, 4, 5, 4, 2, 2, 1, 3) $ \a b -> shuffleInt16X8# a b (# 4#, 4#, 5#, 4#, 2#, 2#, 1#, 3# #)
  test (4, 5, 6, 7, 0, 1, 2, 3) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 6#, 7#, 0#, 1#, 2#, 3# #)
  test (4, 5, 6, 7, 4, 5, 6, 7) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 6#, 7#, 4#, 5#, 6#, 7# #)
  test (4, 5, 6, 7, 8, 9, 10, 11) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 6#, 7#, 8#, 9#, 10#, 11# #)
  test (4, 5, 6, 7, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 6#, 7#, 12#, 13#, 14#, 15# #)
  test (4, 5, 13, 0, 10, 3, 10, 12) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 13#, 0#, 10#, 3#, 10#, 12# #)
  test (4, 5, 13, 15, 6, 13, 5, 12) $ \a b -> shuffleInt16X8# a b (# 4#, 5#, 13#, 15#, 6#, 13#, 5#, 12# #)
  test (4, 7, 7, 5, 3, 0, 1, 2) $ \a b -> shuffleInt16X8# a b (# 4#, 7#, 7#, 5#, 3#, 0#, 1#, 2# #)
  test (4, 7, 7, 6, 6, 5, 4, 6) $ \a b -> shuffleInt16X8# a b (# 4#, 7#, 7#, 6#, 6#, 5#, 4#, 6# #)
  test (4, 10, 6, 8, 12, 11, 12, 10) $ \a b -> shuffleInt16X8# a b (# 4#, 10#, 6#, 8#, 12#, 11#, 12#, 10# #)
  test (4, 11, 9, 11, 6, 13, 1, 1) $ \a b -> shuffleInt16X8# a b (# 4#, 11#, 9#, 11#, 6#, 13#, 1#, 1# #)
  test (4, 12, 5, 13, 6, 14, 7, 15) $ \a b -> shuffleInt16X8# a b (# 4#, 12#, 5#, 13#, 6#, 14#, 7#, 15# #)
  test (4, 14, 0, 7, 2, 13, 5, 0) $ \a b -> shuffleInt16X8# a b (# 4#, 14#, 0#, 7#, 2#, 13#, 5#, 0# #)
  test (5, 0, 2, 9, 4, 0, 15, 0) $ \a b -> shuffleInt16X8# a b (# 5#, 0#, 2#, 9#, 4#, 0#, 15#, 0# #)
  test (5, 4, 4, 6, 14, 15, 15, 13) $ \a b -> shuffleInt16X8# a b (# 5#, 4#, 4#, 6#, 14#, 15#, 15#, 13# #)
  test (5, 4, 6, 4, 14, 15, 12, 14) $ \a b -> shuffleInt16X8# a b (# 5#, 4#, 6#, 4#, 14#, 15#, 12#, 14# #)
  test (5, 4, 6, 7, 6, 5, 6, 4) $ \a b -> shuffleInt16X8# a b (# 5#, 4#, 6#, 7#, 6#, 5#, 6#, 4# #)
  test (5, 4, 7, 7, 9, 11, 8, 8) $ \a b -> shuffleInt16X8# a b (# 5#, 4#, 7#, 7#, 9#, 11#, 8#, 8# #)
  test (5, 4, 15, 15, 7, 6, 14, 12) $ \a b -> shuffleInt16X8# a b (# 5#, 4#, 15#, 15#, 7#, 6#, 14#, 12# #)
  test (5, 5, 4, 6, 13, 14, 12, 13) $ \a b -> shuffleInt16X8# a b (# 5#, 5#, 4#, 6#, 13#, 14#, 12#, 13# #)
  test (5, 5, 5, 5, 5, 5, 5, 5) $ \a b -> shuffleInt16X8# a b (# 5#, 5#, 5#, 5#, 5#, 5#, 5#, 5# #)
  test (5, 5, 11, 2, 0, 5, 7, 4) $ \a b -> shuffleInt16X8# a b (# 5#, 5#, 11#, 2#, 0#, 5#, 7#, 4# #)
  test (5, 6, 3, 0, 14, 5, 5, 13) $ \a b -> shuffleInt16X8# a b (# 5#, 6#, 3#, 0#, 14#, 5#, 5#, 13# #)
  test (5, 6, 7, 8, 9, 10, 11, 12) $ \a b -> shuffleInt16X8# a b (# 5#, 6#, 7#, 8#, 9#, 10#, 11#, 12# #)
  test (5, 7, 7, 4, 3, 3, 2, 3) $ \a b -> shuffleInt16X8# a b (# 5#, 7#, 7#, 4#, 3#, 3#, 2#, 3# #)
  test (5, 12, 4, 10, 15, 8, 4, 9) $ \a b -> shuffleInt16X8# a b (# 5#, 12#, 4#, 10#, 15#, 8#, 4#, 9# #)
  test (5, 12, 12, 2, 4, 12, 13, 9) $ \a b -> shuffleInt16X8# a b (# 5#, 12#, 12#, 2#, 4#, 12#, 13#, 9# #)
  test (5, 15, 6, 14, 7, 13, 6, 14) $ \a b -> shuffleInt16X8# a b (# 5#, 15#, 6#, 14#, 7#, 13#, 6#, 14# #)
  test (5, 15, 7, 12, 15, 14, 6, 7) $ \a b -> shuffleInt16X8# a b (# 5#, 15#, 7#, 12#, 15#, 14#, 6#, 7# #)
  test (6, 4, 7, 4, 3, 0, 1, 2) $ \a b -> shuffleInt16X8# a b (# 6#, 4#, 7#, 4#, 3#, 0#, 1#, 2# #)
  test (6, 4, 7, 4, 5, 5, 5, 4) $ \a b -> shuffleInt16X8# a b (# 6#, 4#, 7#, 4#, 5#, 5#, 5#, 4# #)
  test (6, 4, 10, 4, 0, 3, 1, 13) $ \a b -> shuffleInt16X8# a b (# 6#, 4#, 10#, 4#, 0#, 3#, 1#, 13# #)
  test (6, 4, 10, 11, 14, 0, 8, 0) $ \a b -> shuffleInt16X8# a b (# 6#, 4#, 10#, 11#, 14#, 0#, 8#, 0# #)
  test (6, 5, 6, 7, 12, 12, 9, 12) $ \a b -> shuffleInt16X8# a b (# 6#, 5#, 6#, 7#, 12#, 12#, 9#, 12# #)
  test (6, 6, 6, 5, 8, 9, 10, 8) $ \a b -> shuffleInt16X8# a b (# 6#, 6#, 6#, 5#, 8#, 9#, 10#, 8# #)
  test (6, 6, 6, 6, 6, 6, 6, 6) $ \a b -> shuffleInt16X8# a b (# 6#, 6#, 6#, 6#, 6#, 6#, 6#, 6# #)
  test (6, 7, 7, 5, 5, 5, 6, 4) $ \a b -> shuffleInt16X8# a b (# 6#, 7#, 7#, 5#, 5#, 5#, 6#, 4# #)
  test (6, 7, 8, 9, 10, 11, 12, 13) $ \a b -> shuffleInt16X8# a b (# 6#, 7#, 8#, 9#, 10#, 11#, 12#, 13# #)
  test (6, 8, 12, 12, 11, 10, 10, 12) $ \a b -> shuffleInt16X8# a b (# 6#, 8#, 12#, 12#, 11#, 10#, 10#, 12# #)
  test (6, 13, 3, 0, 2, 0, 13, 15) $ \a b -> shuffleInt16X8# a b (# 6#, 13#, 3#, 0#, 2#, 0#, 13#, 15# #)
  test (6, 14, 10, 7, 14, 2, 12, 4) $ \a b -> shuffleInt16X8# a b (# 6#, 14#, 10#, 7#, 14#, 2#, 12#, 4# #)
  test (7, 4, 7, 4, 2, 2, 1, 1) $ \a b -> shuffleInt16X8# a b (# 7#, 4#, 7#, 4#, 2#, 2#, 1#, 1# #)
  test (7, 4, 7, 4, 9, 9, 9, 9) $ \a b -> shuffleInt16X8# a b (# 7#, 4#, 7#, 4#, 9#, 9#, 9#, 9# #)
  test (7, 5, 5, 5, 13, 13, 14, 12) $ \a b -> shuffleInt16X8# a b (# 7#, 5#, 5#, 5#, 13#, 13#, 14#, 12# #)
  test (7, 6, 4, 13, 15, 12, 5, 11) $ \a b -> shuffleInt16X8# a b (# 7#, 6#, 4#, 13#, 15#, 12#, 5#, 11# #)
  test (7, 6, 5, 7, 11, 9, 11, 11) $ \a b -> shuffleInt16X8# a b (# 7#, 6#, 5#, 7#, 11#, 9#, 11#, 11# #)
  test (7, 6, 6, 4, 15, 12, 12, 14) $ \a b -> shuffleInt16X8# a b (# 7#, 6#, 6#, 4#, 15#, 12#, 12#, 14# #)
  test (7, 7, 5, 5, 7, 5, 7, 7) $ \a b -> shuffleInt16X8# a b (# 7#, 7#, 5#, 5#, 7#, 5#, 7#, 7# #)
  test (7, 7, 5, 6, 8, 8, 10, 10) $ \a b -> shuffleInt16X8# a b (# 7#, 7#, 5#, 6#, 8#, 8#, 10#, 10# #)
  test (7, 7, 7, 7, 7, 7, 7, 7) $ \a b -> shuffleInt16X8# a b (# 7#, 7#, 7#, 7#, 7#, 7#, 7#, 7# #)
  test (7, 7, 12, 4, 11, 15, 13, 4) $ \a b -> shuffleInt16X8# a b (# 7#, 7#, 12#, 4#, 11#, 15#, 13#, 4# #)
  test (7, 7, 13, 8, 14, 9, 9, 10) $ \a b -> shuffleInt16X8# a b (# 7#, 7#, 13#, 8#, 14#, 9#, 9#, 10# #)
  test (7, 8, 8, 3, 0, 0, 14, 0) $ \a b -> shuffleInt16X8# a b (# 7#, 8#, 8#, 3#, 0#, 0#, 14#, 0# #)
  test (7, 8, 9, 10, 11, 12, 13, 14) $ \a b -> shuffleInt16X8# a b (# 7#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  test (7, 10, 14, 2, 15, 9, 4, 2) $ \a b -> shuffleInt16X8# a b (# 7#, 10#, 14#, 2#, 15#, 9#, 4#, 2# #)
  test (7, 12, 13, 7, 7, 12, 12, 4) $ \a b -> shuffleInt16X8# a b (# 7#, 12#, 13#, 7#, 7#, 12#, 12#, 4# #)
  test (7, 12, 15, 13, 3, 7, 10, 6) $ \a b -> shuffleInt16X8# a b (# 7#, 12#, 15#, 13#, 3#, 7#, 10#, 6# #)
  test (8, 0, 2, 9, 14, 7, 12, 12) $ \a b -> shuffleInt16X8# a b (# 8#, 0#, 2#, 9#, 14#, 7#, 12#, 12# #)
  test (8, 0, 9, 1, 10, 2, 11, 3) $ \a b -> shuffleInt16X8# a b (# 8#, 0#, 9#, 1#, 10#, 2#, 11#, 3# #)
  test (8, 1, 2, 3, 12, 5, 14, 15) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 2#, 3#, 12#, 5#, 14#, 15# #)
  test (8, 1, 2, 11, 4, 13, 14, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 2#, 11#, 4#, 13#, 14#, 7# #)
  test (8, 1, 4, 3, 11, 11, 14, 10) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 4#, 3#, 11#, 11#, 14#, 10# #)
  test (8, 1, 10, 3, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 10#, 3#, 12#, 13#, 14#, 15# #)
  test (8, 1, 10, 11, 12, 5, 14, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 10#, 11#, 12#, 5#, 14#, 7# #)
  test (8, 1, 11, 1, 1, 2, 8, 10) $ \a b -> shuffleInt16X8# a b (# 8#, 1#, 11#, 1#, 1#, 2#, 8#, 10# #)
  test (8, 2, 5, 8, 4, 2, 6, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 2#, 5#, 8#, 4#, 2#, 6#, 7# #)
  test (8, 6, 9, 14, 3, 12, 14, 0) $ \a b -> shuffleInt16X8# a b (# 8#, 6#, 9#, 14#, 3#, 12#, 14#, 0# #)
  test (8, 8, 2, 2, 13, 14, 5, 6) $ \a b -> shuffleInt16X8# a b (# 8#, 8#, 2#, 2#, 13#, 14#, 5#, 6# #)
  test (8, 8, 8, 8, 8, 8, 8, 8) $ \a b -> shuffleInt16X8# a b (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test (8, 8, 8, 9, 10, 8, 8, 11) $ \a b -> shuffleInt16X8# a b (# 8#, 8#, 8#, 9#, 10#, 8#, 8#, 11# #)
  test (8, 8, 10, 10, 15, 15, 14, 12) $ \a b -> shuffleInt16X8# a b (# 8#, 8#, 10#, 10#, 15#, 15#, 14#, 12# #)
  test (8, 9, 9, 9, 1, 3, 3, 1) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 9#, 9#, 1#, 3#, 3#, 1# #)
  test (8, 9, 9, 9, 4, 5, 6, 6) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 9#, 9#, 4#, 5#, 6#, 6# #)
  test (8, 9, 10, 3, 4, 5, 6, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 10#, 3#, 4#, 5#, 6#, 7# #)
  test (8, 9, 10, 11, 0, 1, 2, 3) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 10#, 11#, 0#, 1#, 2#, 3# #)
  test (8, 9, 10, 11, 4, 5, 6, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 10#, 11#, 4#, 5#, 6#, 7# #)
  test (8, 9, 10, 11, 8, 9, 10, 11) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 10#, 11#, 8#, 9#, 10#, 11# #)
  test (8, 9, 10, 11, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 8#, 9#, 10#, 11#, 12#, 13#, 14#, 15# #)
  test (8, 10, 7, 12, 2, 4, 6, 3) $ \a b -> shuffleInt16X8# a b (# 8#, 10#, 7#, 12#, 2#, 4#, 6#, 3# #)
  test (8, 10, 11, 9, 11, 11, 11, 8) $ \a b -> shuffleInt16X8# a b (# 8#, 10#, 11#, 9#, 11#, 11#, 11#, 8# #)
  test (8, 11, 8, 8, 1, 2, 1, 3) $ \a b -> shuffleInt16X8# a b (# 8#, 11#, 8#, 8#, 1#, 2#, 1#, 3# #)
  test (8, 11, 8, 11, 7, 6, 7, 7) $ \a b -> shuffleInt16X8# a b (# 8#, 11#, 8#, 11#, 7#, 6#, 7#, 7# #)
  test (8, 11, 11, 8, 6, 13, 14, 4) $ \a b -> shuffleInt16X8# a b (# 8#, 11#, 11#, 8#, 6#, 13#, 14#, 4# #)
  test (8, 12, 6, 11, 4, 15, 9, 14) $ \a b -> shuffleInt16X8# a b (# 8#, 12#, 6#, 11#, 4#, 15#, 9#, 14# #)
  test (9, 0, 1, 11, 10, 11, 3, 2) $ \a b -> shuffleInt16X8# a b (# 9#, 0#, 1#, 11#, 10#, 11#, 3#, 2# #)
  test (9, 1, 4, 14, 15, 15, 9, 13) $ \a b -> shuffleInt16X8# a b (# 9#, 1#, 4#, 14#, 15#, 15#, 9#, 13# #)
  test (9, 2, 5, 12, 5, 5, 5, 14) $ \a b -> shuffleInt16X8# a b (# 9#, 2#, 5#, 12#, 5#, 5#, 5#, 14# #)
  test (9, 3, 3, 10, 8, 3, 11, 3) $ \a b -> shuffleInt16X8# a b (# 9#, 3#, 3#, 10#, 8#, 3#, 11#, 3# #)
  test (9, 3, 9, 4, 13, 7, 2, 10) $ \a b -> shuffleInt16X8# a b (# 9#, 3#, 9#, 4#, 13#, 7#, 2#, 10# #)
  test (9, 6, 13, 6, 10, 6, 15, 9) $ \a b -> shuffleInt16X8# a b (# 9#, 6#, 13#, 6#, 10#, 6#, 15#, 9# #)
  test (9, 6, 15, 6, 8, 15, 7, 2) $ \a b -> shuffleInt16X8# a b (# 9#, 6#, 15#, 6#, 8#, 15#, 7#, 2# #)
  test (9, 8, 10, 9, 0, 3, 1, 1) $ \a b -> shuffleInt16X8# a b (# 9#, 8#, 10#, 9#, 0#, 3#, 1#, 1# #)
  test (9, 9, 9, 9, 9, 9, 9, 9) $ \a b -> shuffleInt16X8# a b (# 9#, 9#, 9#, 9#, 9#, 9#, 9#, 9# #)
  test (9, 9, 13, 1, 10, 15, 5, 0) $ \a b -> shuffleInt16X8# a b (# 9#, 9#, 13#, 1#, 10#, 15#, 5#, 0# #)
  test (9, 10, 9, 10, 0, 3, 3, 0) $ \a b -> shuffleInt16X8# a b (# 9#, 10#, 9#, 10#, 0#, 3#, 3#, 0# #)
  test (9, 10, 11, 12, 13, 14, 15, 0) $ \a b -> shuffleInt16X8# a b (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 0# #)
  test (9, 11, 9, 11, 4, 4, 4, 7) $ \a b -> shuffleInt16X8# a b (# 9#, 11#, 9#, 11#, 4#, 4#, 4#, 7# #)
  test (9, 11, 10, 8, 12, 15, 13, 12) $ \a b -> shuffleInt16X8# a b (# 9#, 11#, 10#, 8#, 12#, 15#, 13#, 12# #)
  test (9, 12, 8, 11, 9, 9, 6, 6) $ \a b -> shuffleInt16X8# a b (# 9#, 12#, 8#, 11#, 9#, 9#, 6#, 6# #)
  test (9, 13, 8, 11, 14, 8, 15, 11) $ \a b -> shuffleInt16X8# a b (# 9#, 13#, 8#, 11#, 14#, 8#, 15#, 11# #)
  test (10, 2, 0, 10, 9, 8, 2, 2) $ \a b -> shuffleInt16X8# a b (# 10#, 2#, 0#, 10#, 9#, 8#, 2#, 2# #)
  test (10, 2, 7, 9, 10, 9, 13, 11) $ \a b -> shuffleInt16X8# a b (# 10#, 2#, 7#, 9#, 10#, 9#, 13#, 11# #)
  test (10, 4, 3, 8, 9, 8, 4, 4) $ \a b -> shuffleInt16X8# a b (# 10#, 4#, 3#, 8#, 9#, 8#, 4#, 4# #)
  test (10, 5, 2, 1, 15, 1, 7, 8) $ \a b -> shuffleInt16X8# a b (# 10#, 5#, 2#, 1#, 15#, 1#, 7#, 8# #)
  test (10, 8, 10, 10, 6, 7, 7, 7) $ \a b -> shuffleInt16X8# a b (# 10#, 8#, 10#, 10#, 6#, 7#, 7#, 7# #)
  test (10, 8, 11, 8, 5, 5, 5, 7) $ \a b -> shuffleInt16X8# a b (# 10#, 8#, 11#, 8#, 5#, 5#, 5#, 7# #)
  test (10, 9, 10, 9, 5, 6, 12, 8) $ \a b -> shuffleInt16X8# a b (# 10#, 9#, 10#, 9#, 5#, 6#, 12#, 8# #)
  test (10, 10, 3, 0, 14, 10, 8, 7) $ \a b -> shuffleInt16X8# a b (# 10#, 10#, 3#, 0#, 14#, 10#, 8#, 7# #)
  test (10, 10, 10, 10, 10, 10, 10, 10) $ \a b -> shuffleInt16X8# a b (# 10#, 10#, 10#, 10#, 10#, 10#, 10#, 10# #)
  test (10, 10, 11, 10, 11, 11, 9, 8) $ \a b -> shuffleInt16X8# a b (# 10#, 10#, 11#, 10#, 11#, 11#, 9#, 8# #)
  test (10, 11, 8, 10, 12, 12, 12, 13) $ \a b -> shuffleInt16X8# a b (# 10#, 11#, 8#, 10#, 12#, 12#, 12#, 13# #)
  test (10, 11, 9, 9, 10, 11, 9, 8) $ \a b -> shuffleInt16X8# a b (# 10#, 11#, 9#, 9#, 10#, 11#, 9#, 8# #)
  test (10, 11, 11, 11, 1, 3, 2, 1) $ \a b -> shuffleInt16X8# a b (# 10#, 11#, 11#, 11#, 1#, 3#, 2#, 1# #)
  test (10, 11, 12, 13, 14, 15, 0, 1) $ \a b -> shuffleInt16X8# a b (# 10#, 11#, 12#, 13#, 14#, 15#, 0#, 1# #)
  test (10, 13, 12, 2, 5, 5, 12, 6) $ \a b -> shuffleInt16X8# a b (# 10#, 13#, 12#, 2#, 5#, 5#, 12#, 6# #)
  test (11, 0, 11, 3, 8, 3, 3, 11) $ \a b -> shuffleInt16X8# a b (# 11#, 0#, 11#, 3#, 8#, 3#, 3#, 11# #)
  test (11, 8, 10, 8, 11, 11, 9, 11) $ \a b -> shuffleInt16X8# a b (# 11#, 8#, 10#, 8#, 11#, 11#, 9#, 11# #)
  test (11, 9, 10, 11, 14, 14, 13, 12) $ \a b -> shuffleInt16X8# a b (# 11#, 9#, 10#, 11#, 14#, 14#, 13#, 12# #)
  test (11, 10, 3, 2, 0, 9, 10, 1) $ \a b -> shuffleInt16X8# a b (# 11#, 10#, 3#, 2#, 0#, 9#, 10#, 1# #)
  test (11, 10, 7, 12, 2, 14, 2, 7) $ \a b -> shuffleInt16X8# a b (# 11#, 10#, 7#, 12#, 2#, 14#, 2#, 7# #)
  test (11, 11, 10, 8, 14, 15, 13, 14) $ \a b -> shuffleInt16X8# a b (# 11#, 11#, 10#, 8#, 14#, 15#, 13#, 14# #)
  test (11, 11, 10, 11, 4, 6, 4, 14) $ \a b -> shuffleInt16X8# a b (# 11#, 11#, 10#, 11#, 4#, 6#, 4#, 14# #)
  test (11, 11, 11, 11, 11, 11, 11, 11) $ \a b -> shuffleInt16X8# a b (# 11#, 11#, 11#, 11#, 11#, 11#, 11#, 11# #)
  test (11, 12, 1, 6, 15, 1, 2, 5) $ \a b -> shuffleInt16X8# a b (# 11#, 12#, 1#, 6#, 15#, 1#, 2#, 5# #)
  test (11, 12, 13, 14, 15, 0, 1, 2) $ \a b -> shuffleInt16X8# a b (# 11#, 12#, 13#, 14#, 15#, 0#, 1#, 2# #)
  test (12, 2, 3, 5, 2, 2, 1, 4) $ \a b -> shuffleInt16X8# a b (# 12#, 2#, 3#, 5#, 2#, 2#, 1#, 4# #)
  test (12, 2, 6, 2, 15, 3, 3, 5) $ \a b -> shuffleInt16X8# a b (# 12#, 2#, 6#, 2#, 15#, 3#, 3#, 5# #)
  test (12, 3, 0, 11, 12, 8, 7, 0) $ \a b -> shuffleInt16X8# a b (# 12#, 3#, 0#, 11#, 12#, 8#, 7#, 0# #)
  test (12, 4, 5, 2, 3, 3, 11, 0) $ \a b -> shuffleInt16X8# a b (# 12#, 4#, 5#, 2#, 3#, 3#, 11#, 0# #)
  test (12, 4, 13, 5, 14, 6, 15, 7) $ \a b -> shuffleInt16X8# a b (# 12#, 4#, 13#, 5#, 14#, 6#, 15#, 7# #)
  test (12, 5, 14, 10, 10, 13, 15, 8) $ \a b -> shuffleInt16X8# a b (# 12#, 5#, 14#, 10#, 10#, 13#, 15#, 8# #)
  test (12, 6, 10, 6, 9, 0, 8, 10) $ \a b -> shuffleInt16X8# a b (# 12#, 6#, 10#, 6#, 9#, 0#, 8#, 10# #)
  test (12, 11, 9, 11, 12, 6, 5, 4) $ \a b -> shuffleInt16X8# a b (# 12#, 11#, 9#, 11#, 12#, 6#, 5#, 4# #)
  test (12, 12, 0, 9, 10, 6, 7, 5) $ \a b -> shuffleInt16X8# a b (# 12#, 12#, 0#, 9#, 10#, 6#, 7#, 5# #)
  test (12, 12, 12, 12, 12, 12, 12, 12) $ \a b -> shuffleInt16X8# a b (# 12#, 12#, 12#, 12#, 12#, 12#, 12#, 12# #)
  test (12, 12, 15, 15, 8, 11, 8, 10) $ \a b -> shuffleInt16X8# a b (# 12#, 12#, 15#, 15#, 8#, 11#, 8#, 10# #)
  test (12, 13, 12, 13, 5, 4, 5, 6) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 12#, 13#, 5#, 4#, 5#, 6# #)
  test (12, 13, 14, 13, 15, 15, 15, 12) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 14#, 13#, 15#, 15#, 15#, 12# #)
  test (12, 13, 14, 15, 0, 1, 2, 3) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 14#, 15#, 0#, 1#, 2#, 3# #)
  test (12, 13, 14, 15, 4, 5, 6, 7) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 14#, 15#, 4#, 5#, 6#, 7# #)
  test (12, 13, 14, 15, 8, 9, 10, 11) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 14#, 15#, 8#, 9#, 10#, 11# #)
  test (12, 13, 14, 15, 12, 13, 14, 15) $ \a b -> shuffleInt16X8# a b (# 12#, 13#, 14#, 15#, 12#, 13#, 14#, 15# #)
  test (12, 14, 12, 13, 6, 7, 4, 4) $ \a b -> shuffleInt16X8# a b (# 12#, 14#, 12#, 13#, 6#, 7#, 4#, 4# #)
  test (12, 15, 10, 0, 12, 8, 3, 12) $ \a b -> shuffleInt16X8# a b (# 12#, 15#, 10#, 0#, 12#, 8#, 3#, 12# #)
  test (12, 15, 13, 12, 15, 14, 13, 14) $ \a b -> shuffleInt16X8# a b (# 12#, 15#, 13#, 12#, 15#, 14#, 13#, 14# #)
  test (12, 15, 15, 12, 9, 10, 11, 8) $ \a b -> shuffleInt16X8# a b (# 12#, 15#, 15#, 12#, 9#, 10#, 11#, 8# #)
  test (13, 0, 2, 2, 0, 1, 7, 0) $ \a b -> shuffleInt16X8# a b (# 13#, 0#, 2#, 2#, 0#, 1#, 7#, 0# #)
  test (13, 0, 12, 15, 13, 8, 6, 2) $ \a b -> shuffleInt16X8# a b (# 13#, 0#, 12#, 15#, 13#, 8#, 6#, 2# #)
  test (13, 3, 3, 8, 0, 13, 14, 9) $ \a b -> shuffleInt16X8# a b (# 13#, 3#, 3#, 8#, 0#, 13#, 14#, 9# #)
  test (13, 7, 4, 15, 7, 14, 5, 13) $ \a b -> shuffleInt16X8# a b (# 13#, 7#, 4#, 15#, 7#, 14#, 5#, 13# #)
  test (13, 9, 7, 7, 7, 7, 1, 8) $ \a b -> shuffleInt16X8# a b (# 13#, 9#, 7#, 7#, 7#, 7#, 1#, 8# #)
  test (13, 9, 15, 1, 0, 3, 3, 5) $ \a b -> shuffleInt16X8# a b (# 13#, 9#, 15#, 1#, 0#, 3#, 3#, 5# #)
  test (13, 12, 12, 14, 1, 2, 1, 1) $ \a b -> shuffleInt16X8# a b (# 13#, 12#, 12#, 14#, 1#, 2#, 1#, 1# #)
  test (13, 13, 0, 0, 11, 9, 3, 3) $ \a b -> shuffleInt16X8# a b (# 13#, 13#, 0#, 0#, 11#, 9#, 3#, 3# #)
  test (13, 13, 12, 13, 4, 4, 7, 6) $ \a b -> shuffleInt16X8# a b (# 13#, 13#, 12#, 13#, 4#, 4#, 7#, 6# #)
  test (13, 13, 13, 13, 13, 13, 13, 13) $ \a b -> shuffleInt16X8# a b (# 13#, 13#, 13#, 13#, 13#, 13#, 13#, 13# #)
  test (13, 14, 6, 0, 3, 9, 1, 5) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 6#, 0#, 3#, 9#, 1#, 5# #)
  test (13, 14, 12, 12, 2, 0, 3, 0) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 12#, 12#, 2#, 0#, 3#, 0# #)
  test (13, 14, 13, 12, 7, 4, 4, 5) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 13#, 12#, 7#, 4#, 4#, 5# #)
  test (13, 14, 14, 12, 10, 11, 9, 11) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 14#, 12#, 10#, 11#, 9#, 11# #)
  test (13, 14, 14, 13, 3, 2, 2, 3) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 14#, 13#, 3#, 2#, 2#, 3# #)
  test (13, 14, 15, 0, 1, 2, 3, 4) $ \a b -> shuffleInt16X8# a b (# 13#, 14#, 15#, 0#, 1#, 2#, 3#, 4# #)
  test (13, 15, 12, 15, 8, 6, 14, 4) $ \a b -> shuffleInt16X8# a b (# 13#, 15#, 12#, 15#, 8#, 6#, 14#, 4# #)
  test (14, 0, 6, 8, 7, 0, 7, 5) $ \a b -> shuffleInt16X8# a b (# 14#, 0#, 6#, 8#, 7#, 0#, 7#, 5# #)
  test (14, 3, 1, 5, 7, 3, 14, 14) $ \a b -> shuffleInt16X8# a b (# 14#, 3#, 1#, 5#, 7#, 3#, 14#, 14# #)
  test (14, 4, 2, 8, 9, 3, 2, 7) $ \a b -> shuffleInt16X8# a b (# 14#, 4#, 2#, 8#, 9#, 3#, 2#, 7# #)
  test (14, 4, 5, 15, 5, 15, 7, 14) $ \a b -> shuffleInt16X8# a b (# 14#, 4#, 5#, 15#, 5#, 15#, 7#, 14# #)
  test (14, 4, 13, 7, 5, 15, 6, 15) $ \a b -> shuffleInt16X8# a b (# 14#, 4#, 13#, 7#, 5#, 15#, 6#, 15# #)
  test (14, 5, 5, 11, 1, 7, 10, 4) $ \a b -> shuffleInt16X8# a b (# 14#, 5#, 5#, 11#, 1#, 7#, 10#, 4# #)
  test (14, 6, 3, 10, 5, 8, 4, 10) $ \a b -> shuffleInt16X8# a b (# 14#, 6#, 3#, 10#, 5#, 8#, 4#, 10# #)
  test (14, 6, 6, 5, 0, 4, 15, 1) $ \a b -> shuffleInt16X8# a b (# 14#, 6#, 6#, 5#, 0#, 4#, 15#, 1# #)
  test (14, 7, 12, 7, 4, 7, 13, 15) $ \a b -> shuffleInt16X8# a b (# 14#, 7#, 12#, 7#, 4#, 7#, 13#, 15# #)
  test (14, 7, 15, 11, 2, 5, 1, 12) $ \a b -> shuffleInt16X8# a b (# 14#, 7#, 15#, 11#, 2#, 5#, 1#, 12# #)
  test (14, 9, 5, 14, 2, 14, 8, 11) $ \a b -> shuffleInt16X8# a b (# 14#, 9#, 5#, 14#, 2#, 14#, 8#, 11# #)
  test (14, 10, 11, 4, 13, 6, 12, 5) $ \a b -> shuffleInt16X8# a b (# 14#, 10#, 11#, 4#, 13#, 6#, 12#, 5# #)
  test (14, 10, 15, 13, 1, 0, 6, 10) $ \a b -> shuffleInt16X8# a b (# 14#, 10#, 15#, 13#, 1#, 0#, 6#, 10# #)
  test (14, 10, 15, 15, 5, 7, 10, 12) $ \a b -> shuffleInt16X8# a b (# 14#, 10#, 15#, 15#, 5#, 7#, 10#, 12# #)
  test (14, 12, 15, 15, 8, 9, 10, 9) $ \a b -> shuffleInt16X8# a b (# 14#, 12#, 15#, 15#, 8#, 9#, 10#, 9# #)
  test (14, 13, 12, 13, 7, 5, 4, 5) $ \a b -> shuffleInt16X8# a b (# 14#, 13#, 12#, 13#, 7#, 5#, 4#, 5# #)
  test (14, 13, 12, 15, 12, 6, 1, 11) $ \a b -> shuffleInt16X8# a b (# 14#, 13#, 12#, 15#, 12#, 6#, 1#, 11# #)
  test (14, 13, 13, 13, 12, 13, 13, 14) $ \a b -> shuffleInt16X8# a b (# 14#, 13#, 13#, 13#, 12#, 13#, 13#, 14# #)
  test (14, 14, 5, 6, 5, 12, 7, 12) $ \a b -> shuffleInt16X8# a b (# 14#, 14#, 5#, 6#, 5#, 12#, 7#, 12# #)
  test (14, 14, 12, 13, 2, 0, 1, 0) $ \a b -> shuffleInt16X8# a b (# 14#, 14#, 12#, 13#, 2#, 0#, 1#, 0# #)
  test (14, 14, 14, 14, 14, 14, 14, 14) $ \a b -> shuffleInt16X8# a b (# 14#, 14#, 14#, 14#, 14#, 14#, 14#, 14# #)
  test (14, 14, 15, 8, 12, 10, 5, 10) $ \a b -> shuffleInt16X8# a b (# 14#, 14#, 15#, 8#, 12#, 10#, 5#, 10# #)
  test (14, 15, 0, 1, 2, 3, 4, 5) $ \a b -> shuffleInt16X8# a b (# 14#, 15#, 0#, 1#, 2#, 3#, 4#, 5# #)
  test (14, 15, 15, 15, 14, 14, 13, 13) $ \a b -> shuffleInt16X8# a b (# 14#, 15#, 15#, 15#, 14#, 14#, 13#, 13# #)
  test (15, 0, 1, 2, 3, 4, 5, 6) $ \a b -> shuffleInt16X8# a b (# 15#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  test (15, 3, 6, 2, 7, 6, 8, 11) $ \a b -> shuffleInt16X8# a b (# 15#, 3#, 6#, 2#, 7#, 6#, 8#, 11# #)
  test (15, 3, 8, 11, 10, 0, 13, 8) $ \a b -> shuffleInt16X8# a b (# 15#, 3#, 8#, 11#, 10#, 0#, 13#, 8# #)
  test (15, 3, 8, 13, 4, 11, 3, 9) $ \a b -> shuffleInt16X8# a b (# 15#, 3#, 8#, 13#, 4#, 11#, 3#, 9# #)
  test (15, 4, 6, 12, 6, 2, 13, 8) $ \a b -> shuffleInt16X8# a b (# 15#, 4#, 6#, 12#, 6#, 2#, 13#, 8# #)
  test (15, 6, 6, 14, 13, 13, 5, 5) $ \a b -> shuffleInt16X8# a b (# 15#, 6#, 6#, 14#, 13#, 13#, 5#, 5# #)
  test (15, 8, 11, 1, 15, 7, 2, 4) $ \a b -> shuffleInt16X8# a b (# 15#, 8#, 11#, 1#, 15#, 7#, 2#, 4# #)
  test (15, 9, 4, 4, 11, 7, 0, 8) $ \a b -> shuffleInt16X8# a b (# 15#, 9#, 4#, 4#, 11#, 7#, 0#, 8# #)
  test (15, 10, 4, 9, 14, 6, 14, 9) $ \a b -> shuffleInt16X8# a b (# 15#, 10#, 4#, 9#, 14#, 6#, 14#, 9# #)
  test (15, 12, 11, 8, 3, 10, 7, 4) $ \a b -> shuffleInt16X8# a b (# 15#, 12#, 11#, 8#, 3#, 10#, 7#, 4# #)
  test (15, 14, 12, 13, 3, 0, 2, 2) $ \a b -> shuffleInt16X8# a b (# 15#, 14#, 12#, 13#, 3#, 0#, 2#, 2# #)
  test (15, 14, 13, 15, 8, 10, 11, 11) $ \a b -> shuffleInt16X8# a b (# 15#, 14#, 13#, 15#, 8#, 10#, 11#, 11# #)
  test (15, 14, 14, 12, 14, 15, 13, 13) $ \a b -> shuffleInt16X8# a b (# 15#, 14#, 14#, 12#, 14#, 15#, 13#, 13# #)
  test (15, 15, 6, 11, 11, 1, 13, 5) $ \a b -> shuffleInt16X8# a b (# 15#, 15#, 6#, 11#, 11#, 1#, 13#, 5# #)
  test (15, 15, 15, 15, 15, 15, 15, 15) $ \a b -> shuffleInt16X8# a b (# 15#, 15#, 15#, 15#, 15#, 15#, 15#, 15# #)
  test0x (8, 0, 1, 2, 3, 4, 5, 6) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  test0x (8, 8, 0, 1, 2, 3, 4, 5) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 0#, 1#, 2#, 3#, 4#, 5# #)
  test0x (8, 8, 8, 0, 1, 2, 3, 4) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 0#, 1#, 2#, 3#, 4# #)
  test0x (8, 8, 8, 8, 0, 1, 2, 3) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 0#, 1#, 2#, 3# #)
  test0x (8, 8, 8, 8, 8, 0, 1, 2) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 8#, 0#, 1#, 2# #)
  test0x (8, 8, 8, 8, 8, 8, 0, 1) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 8#, 8#, 0#, 1# #)
  test0x (8, 8, 8, 8, 8, 8, 8, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 0# #)
  test0x (8, 8, 8, 8, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test0x (0, 8, 9, 10, 11, 12, 13, 14) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  test0x (0, 0, 8, 9, 10, 11, 12, 13) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 8#, 9#, 10#, 11#, 12#, 13# #)
  test0x (0, 0, 0, 8, 9, 10, 11, 12) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 8#, 9#, 10#, 11#, 12# #)
  test0x (0, 0, 0, 0, 8, 9, 10, 11) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 8#, 9#, 10#, 11# #)
  test0x (0, 0, 0, 0, 0, 8, 9, 10) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 0#, 8#, 9#, 10# #)
  test0x (0, 0, 0, 0, 0, 0, 8, 9) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 0#, 0#, 8#, 9# #)
  test0x (0, 0, 0, 0, 0, 0, 0, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 8# #)
  test0x (0, 0, 0, 0, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x (1, 2, 3, 4, 5, 6, 7, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  test0x (2, 3, 4, 5, 6, 7, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 8# #)
  test0x (3, 4, 5, 6, 7, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 3#, 4#, 5#, 6#, 7#, 8#, 8#, 8# #)
  test0x (4, 5, 6, 7, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 4#, 5#, 6#, 7#, 8#, 8#, 8#, 8# #)
  test0x (5, 6, 7, 8, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 5#, 6#, 7#, 8#, 8#, 8#, 8#, 8# #)
  test0x (6, 7, 8, 8, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 6#, 7#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test0x (7, 8, 8, 8, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 7#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test0x (8, 8, 8, 8, 8, 8, 8, 8) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  test0x (9, 10, 11, 12, 13, 14, 15, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 0# #)
  test0x (10, 11, 12, 13, 14, 15, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 10#, 11#, 12#, 13#, 14#, 15#, 0#, 0# #)
  test0x (11, 12, 13, 14, 15, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 11#, 12#, 13#, 14#, 15#, 0#, 0#, 0# #)
  test0x (12, 13, 14, 15, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 12#, 13#, 14#, 15#, 0#, 0#, 0#, 0# #)
  test0x (13, 14, 15, 0, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 13#, 14#, 15#, 0#, 0#, 0#, 0#, 0# #)
  test0x (14, 15, 0, 0, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 14#, 15#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x (15, 0, 0, 0, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 15#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  test0x (0, 0, 0, 0, 0, 0, 0, 0) $ \b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 (8, 0, 1, 2, 3, 4, 5, 6) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 0#, 1#, 2#, 3#, 4#, 5#, 6# #)
  testx0 (8, 8, 0, 1, 2, 3, 4, 5) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 0#, 1#, 2#, 3#, 4#, 5# #)
  testx0 (8, 8, 8, 0, 1, 2, 3, 4) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 0#, 1#, 2#, 3#, 4# #)
  testx0 (8, 8, 8, 8, 0, 1, 2, 3) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 0#, 1#, 2#, 3# #)
  testx0 (8, 8, 8, 8, 8, 0, 1, 2) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 8#, 0#, 1#, 2# #)
  testx0 (8, 8, 8, 8, 8, 8, 0, 1) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 8#, 8#, 0#, 1# #)
  testx0 (8, 8, 8, 8, 8, 8, 8, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 0# #)
  testx0 (8, 8, 8, 8, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  testx0 (0, 8, 9, 10, 11, 12, 13, 14) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 8#, 9#, 10#, 11#, 12#, 13#, 14# #)
  testx0 (0, 0, 8, 9, 10, 11, 12, 13) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 8#, 9#, 10#, 11#, 12#, 13# #)
  testx0 (0, 0, 0, 8, 9, 10, 11, 12) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 8#, 9#, 10#, 11#, 12# #)
  testx0 (0, 0, 0, 0, 8, 9, 10, 11) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 8#, 9#, 10#, 11# #)
  testx0 (0, 0, 0, 0, 0, 8, 9, 10) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 0#, 8#, 9#, 10# #)
  testx0 (0, 0, 0, 0, 0, 0, 8, 9) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 0#, 0#, 8#, 9# #)
  testx0 (0, 0, 0, 0, 0, 0, 0, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 8# #)
  testx0 (0, 0, 0, 0, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 (1, 2, 3, 4, 5, 6, 7, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 1#, 2#, 3#, 4#, 5#, 6#, 7#, 8# #)
  testx0 (2, 3, 4, 5, 6, 7, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 2#, 3#, 4#, 5#, 6#, 7#, 8#, 8# #)
  testx0 (3, 4, 5, 6, 7, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 3#, 4#, 5#, 6#, 7#, 8#, 8#, 8# #)
  testx0 (4, 5, 6, 7, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 4#, 5#, 6#, 7#, 8#, 8#, 8#, 8# #)
  testx0 (5, 6, 7, 8, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 5#, 6#, 7#, 8#, 8#, 8#, 8#, 8# #)
  testx0 (6, 7, 8, 8, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 6#, 7#, 8#, 8#, 8#, 8#, 8#, 8# #)
  testx0 (7, 8, 8, 8, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 7#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  testx0 (8, 8, 8, 8, 8, 8, 8, 8) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 8#, 8#, 8#, 8#, 8#, 8#, 8#, 8# #)
  testx0 (9, 10, 11, 12, 13, 14, 15, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 9#, 10#, 11#, 12#, 13#, 14#, 15#, 0# #)
  testx0 (10, 11, 12, 13, 14, 15, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 10#, 11#, 12#, 13#, 14#, 15#, 0#, 0# #)
  testx0 (11, 12, 13, 14, 15, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 11#, 12#, 13#, 14#, 15#, 0#, 0#, 0# #)
  testx0 (12, 13, 14, 15, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 12#, 13#, 14#, 15#, 0#, 0#, 0#, 0# #)
  testx0 (13, 14, 15, 0, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 13#, 14#, 15#, 0#, 0#, 0#, 0#, 0# #)
  testx0 (14, 15, 0, 0, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 14#, 15#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 (15, 0, 0, 0, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 15#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)
  testx0 (0, 0, 0, 0, 0, 0, 0, 0) $ \a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# 0#, 0#, 0#, 0#, 0#, 0#, 0#, 0# #)

{- Generated by:
{- cabal:
build-depends: base, random >= 1.3.0
-}
import System.Random.Stateful
import qualified Data.List as List
import Control.Monad

main :: IO ()
main = do
  let fixedCases = [[i,i,i,i,i,i,i,i] | i <- [0..15]]
        ++ [ p ++ q
           | p <- [[0..3],[4..7],[8..11],[12..15]]
           , q <- [[0..3],[4..7],[8..11],[12..15]]
           ]
        ++ [[0,8,1,9,2,10,3,11]
           ,[8,0,9,1,10,2,11,3]
           ,[4,12,5,13,6,14,7,15]
           ,[12,4,13,5,14,6,15,7]
           ]
        ++ [take 8 (drop i [0..15]) | i <- [0..8]] -- PALIGNR
        ++ [take 8 (drop i ([8..15] ++ [0..7])) | i <- [0..8]] -- PALIGNR
      cases :: [[Int]]
      cases = runStateGen_ (mkStdGen 42) $ \g -> do
        unpcklCases <- replicateM 10 $ do
          p1 <- replicateM 2 $ uniformRM (0, 3) g
          p2 <- replicateM 2 $ uniformRM (8, 11) g
          p <- uniformShuffleListM (p1 ++ p2) g
          q1 <- replicateM 2 $ uniformRM (0, 3) g
          q2 <- replicateM 2 $ uniformRM (8, 11) g
          q <- uniformShuffleListM (q1 ++ q2) g
          pure $ p ++ q
        unpckhCases <- replicateM 10 $ do
          p1 <- replicateM 2 $ uniformRM (4, 7) g
          p2 <- replicateM 2 $ uniformRM (12, 15) g
          p <- uniformShuffleListM (p1 ++ p2) g
          q1 <- replicateM 2 $ uniformRM (4, 7) g
          q2 <- replicateM 2 $ uniformRM (12, 15) g
          q <- uniformShuffleListM (q1 ++ q2) g
          pure $ p ++ q
        blendCases <- replicateM 10 $ do
          p <- replicateM 4 $ (\i -> if i >= 4 then i + 4 else i) <$> uniformRM (0, 7) g
          q <- replicateM 4 $ (\i -> if i >= 4 then i + 8 else i + 4) <$> uniformRM (0, 7) g
          pure $ p ++ q
        blend2 <- replicateM 10 $ replicateM 8 (uniformRM (0, 1) g)
        let blendCases2 = [[8 * i + j | (i,j) <- zip is [0..]] | is <- blend2]
        otherCases <- do
          fmap concat $ forM [(0, 3), (4, 7), (8, 11), (12, 15)] $ \r1 -> do
            fmap concat $ forM [(0, 3), (4, 7), (8, 11), (12, 15)] $ \r2 -> replicateM 5 $ do
              p <- replicateM 4 (uniformRM r1 g)
              q <- replicateM 4 (uniformRM r2 g)
              pure $ p ++ q
        randomCases <- replicateM 100 $ replicateM 8 (uniformRM (0, 15) g)
        pure $ List.nub $ List.sort $ fixedCases ++ unpcklCases ++ unpckhCases ++ blendCases ++ blendCases2 ++ otherCases ++ randomCases
  forM_ cases $ \xs -> do
    putStrLn $ "  test (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a b -> shuffleInt16X8# a b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  let shiftCases = concat
        [[replicate i 8 ++ [0..7-i] | i <- [1..8]] -- PSLLDQ
        ,[replicate i 0 ++ [8..15-i] | i <- [1..8]] -- PSLLDQ
        ,[[i..7] ++ replicate i 8 | i <- [1..8]] -- PSRLDQ
        ,[[8+i..15] ++ replicate i 0 | i <- [1..8]] -- PSRLDQ
        ]
  forM_ shiftCases $ \xs -> do
    putStrLn $ "  test0x (" ++ List.intercalate ", " (map show xs) ++ ") $ \\b -> shuffleInt16X8# (broadcastInt16X8# 0#Int16) b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  forM_ shiftCases $ \xs -> do
    putStrLn $ "  testx0 (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a -> shuffleInt16X8# a (broadcastInt16X8# 0#Int16) (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
-}
