/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.jwk.source;

import com.databricks.client.jdbc42.internal.nimbusjose.KeySourceException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKSet;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetCacheRefreshEvaluator;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSource;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSourceWrapper;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.SecurityContext;
import com.databricks.client.jdbc42.internal.nimbusjose.util.health.HealthReport;
import com.databricks.client.jdbc42.internal.nimbusjose.util.health.HealthReportListener;
import com.databricks.client.jdbc42.internal.nimbusjose.util.health.HealthStatus;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWKSetSourceWithHealthStatusReporting<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener;

    public JWKSetSourceWithHealthStatusReporting(JWKSetSource<C> source, HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener) {
        super(source);
        Objects.requireNonNull(healthReportListener);
        this.healthReportListener = healthReportListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, C context) throws KeySourceException {
        JWKSet jwkSet;
        try {
            jwkSet = this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
            this.healthReportListener.notify(new HealthReport<JWKSetSourceWithHealthStatusReporting, C>(this, HealthStatus.HEALTHY, currentTime, context));
        }
        catch (Exception e) {
            this.healthReportListener.notify(new HealthReport<JWKSetSourceWithHealthStatusReporting, C>(this, HealthStatus.NOT_HEALTHY, e, currentTime, context));
            throw e;
        }
        return jwkSet;
    }
}

