function
eval_derivative(p1)
{
	var flag, i, n, X, Y;

	push(cadr(p1));
	evalf();
	p1 = cddr(p1);

	if (!iscons(p1)) {
		push_symbol(X_LOWER);
		derivative();
		return;
	}

	flag = 0;

	while (iscons(p1) || flag) {

		if (flag) {
			X = Y;
			flag = 0;
		} else {
			push(car(p1));
			evalf();
			X = pop();
			p1 = cdr(p1);
		}

		if (isnum(X)) {
			push(X);
			n = pop_integer();
			push_symbol(X_LOWER);
			X = pop();
			for (i = 0; i < n; i++) {
				push(X);
				derivative();
			}
			continue;
		}

		if (iscons(p1)) {

			push(car(p1));
			evalf();
			Y = pop();
			p1 = cdr(p1);

			if (isnum(Y)) {
				push(Y);
				n = pop_integer();
				for (i = 0; i < n; i++) {
					push(X);
					derivative();
				}
				continue;
			}

			flag = 1;
		}

		push(X);
		derivative();
	}
}

function
derivative()
{
	var F, X;

	X = pop();
	F = pop();

	if (istensor(F)) {
		if (istensor(X))
			d_tensor_tensor(F, X);
		else
			d_tensor_scalar(F, X);
	} else {
		if (istensor(X))
			d_scalar_tensor(F, X);
		else
			d_scalar_scalar(F, X);
	}
}

function
d_scalar_scalar(F, X)
{
	if (!isusersymbol(X))
		stopf("derivative: symbol expected");

	if (car(F) == symbol(DERIVATIVE)) {
		derivative_of_derivative(F, X);
		return;
	}

	if (car(F) == symbol(INTEGRAL)) {
		derivative_of_integral(F, X);
		return;
	}

	// d(x,x)?

	if (equal(F, X)) {
		push_integer(1);
		return;
	}

	// d(a,x)?

	if (!iscons(F)) {
		push_integer(0);
		return;
	}

	if (car(F) == symbol(ADD)) {
		dsum(F, X);
		return;
	}

	if (car(F) == symbol(MULTIPLY)) {
		dproduct(F, X);
		return;
	}

	if (car(F) == symbol(POWER)) {
		dpower(F, X);
		return;
	}

	if (car(F) == symbol(LOG)) {
		dlog(F, X);
		return;
	}

	if (car(F) == symbol(SIN)) {
		dsin(F, X);
		return;
	}

	if (car(F) == symbol(COS)) {
		dcos(F, X);
		return;
	}

	if (car(F) == symbol(TAN)) {
		dtan(F, X);
		return;
	}

	if (car(F) == symbol(ARCSIN)) {
		darcsin(F, X);
		return;
	}

	if (car(F) == symbol(ARCCOS)) {
		darccos(F, X);
		return;
	}

	if (car(F) == symbol(ARCTAN)) {
		darctan(F, X);
		return;
	}

	if (car(F) == symbol(SINH)) {
		dsinh(F, X);
		return;
	}

	if (car(F) == symbol(COSH)) {
		dcosh(F, X);
		return;
	}

	if (car(F) == symbol(TANH)) {
		dtanh(F, X);
		return;
	}

	if (car(F) == symbol(ARCSINH)) {
		darcsinh(F, X);
		return;
	}

	if (car(F) == symbol(ARCCOSH)) {
		darccosh(F, X);
		return;
	}

	if (car(F) == symbol(ARCTANH)) {
		darctanh(F, X);
		return;
	}

	if (car(F) == symbol(ERF)) {
		derf(F, X);
		return;
	}

	if (car(F) == symbol(ERFC)) {
		derfc(F, X);
		return;
	}

	dfunction(F, X);
}

function
dsum(p1, p2)
{
	var h = stack.length;
	p1 = cdr(p1);
	while (iscons(p1)) {
		push(car(p1));
		push(p2);
		derivative();
		p1 = cdr(p1);
	}
	add_terms(stack.length - h);
}

function
dproduct(p1, p2)
{
	var i, j, n, p3;
	n = lengthf(p1) - 1;
	for (i = 0; i < n; i++) {
		p3 = cdr(p1);
		for (j = 0; j < n; j++) {
			push(car(p3));
			if (i == j) {
				push(p2);
				derivative();
			}
			p3 = cdr(p3);
		}
		multiply_factors(n);
	}
	add_terms(n);
}

//	     v
//	y = u
//
//	log y = v log u
//
//	1 dy   v du           dv
//	- -- = - -- + (log u) --
//	y dx   u dx           dx
//
//	dy    v  v du           dv
//	-- = u  (- -- + (log u) --)
//	dx       u dx           dx

function
dpower(F, X)
{
	if (isnum(cadr(F)) && isnum(caddr(F))) {
		push_integer(0); // irr or imag
		return;
	}

	push(caddr(F));		// v/u
	push(cadr(F));
	divide();

	push(cadr(F));		// du/dx
	push(X);
	derivative();

	multiply();

	push(cadr(F));		// log u
	logfunc();

	push(caddr(F));		// dv/dx
	push(X);
	derivative();

	multiply();

	add();

	push(F);		// u^v

	multiply();
}

function
dlog(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	divide();
}

// derivative of a generic function

function
dfunction(f, x)
{
	if (dependent(f, x)) {
		push_symbol(DERIVATIVE);
		push(f);
		push(x);
		list(3);
	} else
		push_integer(0);
}

function
dsin(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	cosfunc();
	multiply();
}

function
dcos(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	sinfunc();
	multiply();
	negate();
}

function
dtan(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	cosfunc();
	push_integer(-2);
	power();
	multiply();
}

function
darcsin(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push_integer(1);
	push(cadr(p1));
	push_integer(2);
	power();
	subtract();
	push_rational(-1, 2);
	power();
	multiply();
}

function
darccos(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push_integer(1);
	push(cadr(p1));
	push_integer(2);
	power();
	subtract();
	push_rational(-1, 2);
	power();
	multiply();
	negate();
}

function
darctan(p1, p2)
{
	if (!findf(p1, p2)) {
		push_integer(0);
		return;
	}
	if (iszero(cadr(p1)) || iszero(caddr(p1))) {
		push_symbol(DERIVATIVE);
		push(p1);
		push(p2);
		list(3);
		return;
	}
	push(cadr(p1));		// y
	push(caddr(p1));	// x
	divide();
	p1 = pop();
	push(p1);
	push(p1);
	multiply();
	push_integer(1);
	add();
	reciprocate();
	push(p1);
	push(p2);
	derivative();
	multiply();
}

function
dsinh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	coshfunc();
	multiply();
}

function
dcosh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	sinhfunc();
	multiply();
}

function
dtanh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	coshfunc();
	push_integer(-2);
	power();
	multiply();
}

function
darcsinh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	push_integer(2);
	power();
	push_integer(1);
	add();
	push_rational(-1, 2);
	power();
	multiply();
}

function
darccosh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push(cadr(p1));
	push_integer(2);
	power();
	push_integer(-1);
	add();
	push_rational(-1, 2);
	power();
	multiply();
}

function
darctanh(p1, p2)
{
	push(cadr(p1));
	push(p2);
	derivative();
	push_integer(1);
	push(cadr(p1));
	push_integer(2);
	power();
	subtract();
	reciprocate();
	multiply();
}

function
derf(p1, p2)
{
	push(cadr(p1));
	push_integer(2);
	power();
	push_integer(-1);
	multiply();
	expfunc();
	push_symbol(PI);
	push_rational(-1, 2);
	power();
	multiply();
	push_integer(2);
	multiply();
	push(cadr(p1));
	push(p2);
	derivative();
	multiply();
}


function
derfc(p1, p2)
{
	push(cadr(p1));
	push_integer(2);
	power();
	push_integer(-1);
	multiply();
	expfunc();
	push_symbol(PI);
	push_rational(-1,2);
	power();
	multiply();
	push_integer(-2);
	multiply();
	push(cadr(p1));
	push(p2);
	derivative();
	multiply();
}

// gradient of tensor p1 wrt tensor p2

function
d_tensor_tensor(p1, p2)
{
	var i, j, k, m, n, p3;

	n = p1.elem.length;
	m = p2.elem.length;

	p3 = alloc_tensor();

	for (i = 0; i < n; i++) {
		for (j = 0; j < m; j++) {
			push(p1.elem[i]);
			push(p2.elem[j]);
			derivative();
			p3.elem[m * i + j] = pop();
		}
	}

	// dim info

	k = 0;

	n = p1.dim.length;

	for (i = 0; i < n; i++)
		p3.dim[k++] = p1.dim[i];

	n = p2.dim.length;

	for (i = 0; i < n; i++)
		p3.dim[k++] = p2.dim[i];

	push(p3);
}

// gradient of scalar p1 wrt tensor p2

function
d_scalar_tensor(p1, p2)
{
	var i, n, p3;

	p3 = copy_tensor(p2);

	n = p2.elem.length;

	for (i = 0; i < n; i++) {
		push(p1);
		push(p2.elem[i]);
		derivative();
		p3.elem[i] = pop();
	}

	push(p3);
}

// derivative of tensor p1 wrt scalar p2

function
d_tensor_scalar(p1, p2)
{
	var i, n, p3;

	p3 = copy_tensor(p1);

	n = p1.elem.length;

	for (i = 0; i < n; i++) {
		push(p1.elem[i]);
		push(p2);
		derivative();
		p3.elem[i] = pop();
	}

	push(p3);
}

function
derivative_of_derivative(F, X)
{
	var G, Y;

	G = cadr(F);
	Y = caddr(F);

	if (X == Y) {
		push_symbol(DERIVATIVE);
		push(F);
		push(X);
		list(3);
		return;
	}

	push(G);
	push(X);
	derivative();

	G = pop();

	if (car(G) == symbol(DERIVATIVE)) {

		// sort derivatives

		F = cadr(G);
		X = caddr(G);

		push_symbol(DERIVATIVE);
		push_symbol(DERIVATIVE);
		push(F);

		if (lessp(X, Y)) {
			push(X);
			list(3);
			push(Y);
			list(3);
		} else {
			push(Y);
			list(3);
			push(X);
			list(3);
		}

		return;
	}

	push(G);
	push(Y);
	derivative();
}

function
derivative_of_integral(F, X)
{
	var G, Y;

	G = cadr(F);
	Y = caddr(F);

	if (X == Y) {
		push(G); // derivative and integral cancel
		return;
	}

	push(G);
	push(X);
	derivative();
	push(Y);
	integral();
}
