# nes-core

Emulation core for the Nintendo Entertainment System (NES) / Famicom.

This console contains the following components:
* Modified 6502 CPU clocked at roughly 1.79 MHz
  * The only difference between the NES 6502 and a stock 6502 is that the NES 6502 removed the binary-coded decimal arithmetic hardware, which causes the decimal mode flag to do nothing
* PPU (picture processing unit)
  * Renders frames at 256x240, though displays typically only showed the center 256x224 (NTSC) or 252x239 (PAL)
  * Supports 64 different colors in total, each composed of a 4-bit chroma (hue) and a 2-bit luma (brightness)
  * Supports color emphasis bits that tint the image red, green, or blue
    * Enabling all three bits simultaneously darkens the entire image
  * Supports 4 background palettes and 4 sprite palettes of up to 3 different colors each
  * Supports a single scrollable background layer
    * VRAM is only large enough to fit 2 fullscreen background tile maps, so games can smoothly scroll either horizontally or vertically but not both (unless the cartridge contains additional VRAM)
  * Supports up to 64 sprites onscreen simultaneously and up to 8 sprites per scanline, with sprites being 8x8 pixels
  * Does not support scanline interrupts or a scanline counter, but does support a rudimentary once-per-frame signal called "sprite 0 hit" that triggers when an opaque pixel from the first sprite in the sprite table overlaps an opaque background pixel
* APU (audio processing unit) containing 5 audio channels
  * 2 square wave generators, both supporting sweep functionality which can automatically adjust the wave frequency over time
  * A triangle wave generator that generates a stepped triangle wave with 16 different step values
  * A noise generator that generates pseudo-random noise using a linear feedback shift register
  * A delta modulation channel (DMC) that can play delta-encoded 7-bit PCM samples stored in ROM or RAM
  * All channels except the DMC support a length counter that can automatically silence the channel after a set period of time
  * The square wave generators and the noise generator support envelope functionality that can automatically adjust channel volume over time
* 2KB of working RAM
* 2KB of VRAM, typically used to store the nametables (background tile maps)
* 256 bytes of OAM (object attribute memory, used to store the sprite table)
* 32 bytes of palette RAM

NES cartridges are also interesting technically compared to other consoles:
* Connections to both the CPU bus and the PPU bus
  * Many cartridges contain 2 ROM chips: a PRG ROM chip (program ROM) connected to the CPU bus, and a CHR ROM chip (character ROM) connected to the PPU bus
  * Some cartridges contain read/write CHR RAM (typically 8KB) instead of a CHR ROM chip
* Connection to the 6502 IRQ line
  * Some cartridges use this to generate scanline interrupts by sniffing the PPU address bus (e.g. MMC3, MMC5)
  * Other cartridges use this to generate interrupts based on CPU cycle counts (e.g. Konami VRC boards, Namco 163)
* Connection to audio output (JP consoles only)
  * The audio signal generated by the APU is routed through the cartridge before it is sent to the audio output
  * Some cartridges contain additional wave generators that can mix into the audio signal (MMC5, Konami VRC6, Sunsoft 5B)
  * One cartridge board contains wavetable channels that can play 4-bit PCM samples from 128 bytes of on-cartridge wavetable RAM (Namco 163)
  * One cartridge board contains a Yamaha FM synthesis sound chip, a stripped down version of the YM2413/OPLL (Konami VRC7)