@AZ780  ; Astrolog 7.80 time zone changes.

; Time zone changes composed using data from TZ database version "2025b": https://data.iana.org/time-zones/tz-link.html
; From TZ database file LICENSE:
;   all files in the tz code and data are in the public domain.
; (Astrolog's processing and use of this data is still under Astrolog's GPL license.)

; Part 1: Time zone change rules for Daylight Saving Time
; Column 1: Year time zone changes start
; Column 2: Year time zone changes end (only = same year as start)
; Column 3: Month a particular time zone change takes place
; Column 4: Day a particular time zone change takes place
;   (lastSun = last Sunday in month, Sun>=1 first Sunday on or after 1st, Fri<=1 first Friday on or before 1st)
; Column 5: Hour a particular time zone change takes place (default = local time, s = standard time, u = UTC)
; Column 6: Hour offset of time zone change (0 = Daylight off, 1 = Daylight on)

-YY1 142 2195
Albania	25
1940	only	Jun	16	0	1
1942	only	Nov	2	3	0
1943	only	Mar	29	2	1
1943	only	Apr	10	3	0
1974	only	May	4	0	1
1974	only	Oct	2	0	0
1975	only	May	1	0	1
1975	only	Oct	2	0	0
1976	only	May	2	0	1
1976	only	Oct	3	0	0
1977	only	May	8	0	1
1977	only	Oct	2	0	0
1978	only	May	6	0	1
1978	only	Oct	1	0	0
1979	only	May	5	0	1
1979	only	Sep	30	0	0
1980	only	May	3	0	1
1980	only	Oct	4	0	0
1981	only	Apr	26	0	1
1981	only	Sep	27	0	0
1982	only	May	2	0	1
1982	only	Oct	3	0	0
1983	only	Apr	18	0	1
1983	only	Oct	1	0	0
1984	only	Apr	1	0	1
Algeria	22
1916	only	Jun	14	23s	1
1916	1919	Oct	Sun>=1	23s	0
1917	only	Mar	24	23s	1
1918	only	Mar	9	23s	1
1919	only	Mar	1	23s	1
1920	only	Feb	14	23s	1
1920	only	Oct	23	23s	0
1921	only	Mar	14	23s	1
1921	only	Jun	21	23s	0
1939	only	Sep	11	23s	1
1939	only	Nov	19	1	0
1944	1945	Apr	Mon>=1	2	1
1944	only	Oct	8	2	0
1945	only	Sep	16	1	0
1971	only	Apr	25	23s	1
1971	only	Sep	26	23s	0
1977	only	May	6	0	1
1977	only	Oct	21	0	0
1978	only	Mar	24	1	1
1978	only	Sep	22	3	0
1980	only	Apr	25	0	1
1980	only	Oct	31	2	0
AN	16
1971	1985	Oct	lastSun	2s	1
1972	only	Feb	27	2s	0
1973	1981	Mar	Sun>=1	2s	0
1982	only	Apr	Sun>=1	2s	0
1983	1985	Mar	Sun>=1	2s	0
1986	1989	Mar	Sun>=15	2s	0
1986	only	Oct	19	2s	1
1987	1999	Oct	lastSun	2s	1
1990	1995	Mar	Sun>=1	2s	0
1996	2005	Mar	lastSun	2s	0
2000	only	Aug	lastSun	2s	1
2001	2007	Oct	lastSun	2s	1
2006	only	Apr	Sun>=1	2s	0
2007	only	Mar	lastSun	2s	0
2008	max	Apr	Sun>=1	2s	0
2008	max	Oct	Sun>=1	2s	1
AQ	4
1971	only	Oct	lastSun	2s	1
1972	only	Feb	lastSun	2s	0
1989	1991	Oct	lastSun	2s	1
1990	1992	Mar	Sun>=1	2s	0
Arg	29
1930	only	Dec	1	0	1
1931	only	Apr	1	0	0
1931	only	Oct	15	0	1
1932	1940	Mar	1	0	0
1932	1939	Nov	1	0	1
1940	only	Jul	1	0	1
1941	only	Jun	15	0	0
1941	only	Oct	15	0	1
1943	only	Aug	1	0	0
1943	only	Oct	15	0	1
1946	only	Mar	1	0	0
1946	only	Oct	1	0	1
1963	only	Oct	1	0	0
1963	only	Dec	15	0	1
1964	1966	Mar	1	0	0
1964	1966	Oct	15	0	1
1967	only	Apr	2	0	0
1967	1968	Oct	Sun>=1	0	1
1968	1969	Apr	Sun>=1	0	0
1974	only	Jan	23	0	1
1974	only	May	1	0	0
1988	only	Dec	1	0	1
1989	1993	Mar	Sun>=1	0	0
1989	1992	Oct	Sun>=15	0	1
1999	only	Oct	Sun>=1	0	1
2000	only	Mar	3	0	0
2007	only	Dec	30	0	1
2008	2009	Mar	Sun>=15	0	0
2008	only	Oct	Sun>=15	0	1
Armenia	2
2011	only	Mar	lastSun	2s	1
2011	only	Oct	lastSun	2s	0
AS	15
1971	1985	Oct	lastSun	2s	1
1972	only	Feb	27	2s	0
1973	1985	Mar	Sun>=1	2s	0
1986	1990	Mar	Sun>=15	2s	0
1986	only	Oct	19	2s	1
1987	2007	Oct	lastSun	2s	1
1991	only	Mar	3	2s	0
1992	only	Mar	22	2s	0
1993	only	Mar	7	2s	0
1994	only	Mar	20	2s	0
1995	2005	Mar	lastSun	2s	0
2006	only	Apr	2	2s	0
2007	only	Mar	lastSun	2s	0
2008	max	Apr	Sun>=1	2s	0
2008	max	Oct	Sun>=1	2s	1
AT	23
1916	only	Oct	Sun>=1	2s	1
1917	only	Mar	lastSun	2s	0
1917	1918	Oct	Sun>=22	2s	1
1918	1919	Mar	Sun>=1	2s	0
1967	only	Oct	Sun>=1	2s	1
1968	only	Mar	Sun>=29	2s	0
1968	1985	Oct	lastSun	2s	1
1969	1971	Mar	Sun>=8	2s	0
1972	only	Feb	lastSun	2s	0
1973	1981	Mar	Sun>=1	2s	0
1982	1983	Mar	lastSun	2s	0
1984	1986	Mar	Sun>=1	2s	0
1986	only	Oct	Sun>=15	2s	1
1987	1990	Mar	Sun>=15	2s	0
1987	only	Oct	Sun>=22	2s	1
1988	1990	Oct	lastSun	2s	1
1991	2005	Mar	lastSun	2s	0
1991	1999	Oct	Sun>=1	2s	1
2000	only	Aug	lastSun	2s	1
2001	max	Oct	Sun>=1	2s	1
2006	only	Apr	Sun>=1	2s	0
2007	only	Mar	lastSun	2s	0
2008	max	Apr	Sun>=1	2s	0
Aus	7
1917	only	Jan	1	2s	1
1917	only	Mar	lastSun	2s	0
1942	only	Jan	1	2s	1
1942	only	Mar	lastSun	2s	0
1942	only	Sep	27	2s	1
1943	1944	Mar	lastSun	2s	0
1943	only	Oct	3	2s	1
Austria	9
1920	only	Apr	5	2s	1
1920	only	Sep	13	2s	0
1946	only	Apr	14	2s	1
1946	only	Oct	7	2s	0
1947	only	Apr	6	2s	1
1947	1948	Oct	Sun>=1	2s	0
1948	only	Apr	18	2s	1
1980	only	Apr	6	0	1
1980	only	Sep	28	0	0
AV	14
1971	1985	Oct	lastSun	2s	1
1972	only	Feb	lastSun	2s	0
1973	1985	Mar	Sun>=1	2s	0
1986	1990	Mar	Sun>=15	2s	0
1986	1987	Oct	Sun>=15	2s	1
1988	1999	Oct	lastSun	2s	1
1991	1994	Mar	Sun>=1	2s	0
1995	2005	Mar	lastSun	2s	0
2000	only	Aug	lastSun	2s	1
2001	2007	Oct	lastSun	2s	1
2006	only	Apr	Sun>=1	2s	0
2007	only	Mar	lastSun	2s	0
2008	max	Apr	Sun>=1	2s	0
2008	max	Oct	Sun>=1	2s	1
AW	9
1974	only	Oct	lastSun	2s	1
1975	only	Mar	Sun>=1	2s	0
1983	only	Oct	lastSun	2s	1
1984	only	Mar	Sun>=1	2s	0
1991	only	Nov	17	2s	1
1992	only	Mar	Sun>=1	2s	0
2006	only	Dec	3	2s	1
2007	2009	Mar	lastSun	2s	0
2007	2008	Oct	lastSun	2s	1
Azer	2
1997	2015	Mar	lastSun	4	1
1997	2015	Oct	lastSun	5	0
Bahamas	7
1942	only	May	1	24	1
1944	only	Dec	31	24	0
1945	only	Feb	1	0	1
1945	only	Aug	14	23u	1
1945	only	Oct	17	24	0
1964	1975	Apr	lastSun	2	1
1964	1975	Oct	lastSun	2	0
Barb	11
1942	only	Apr	19	5u	1
1942	only	Aug	31	6u	0
1943	only	May	2	5u	1
1943	only	Sep	5	6u	0
1944	only	Apr	10	5u	0:30
1944	only	Sep	10	6u	0
1977	only	Jun	12	2	1
1977	1978	Oct	Sun>=1	2	0
1978	1980	Apr	Sun>=15	2	1
1979	only	Sep	30	2	0
1980	only	Sep	25	2	0
Belgium	34
1918	only	Mar	9	0s	1
1918	1919	Oct	Sat>=1	23s	0
1919	only	Mar	1	23s	1
1920	only	Feb	14	23s	1
1920	only	Oct	23	23s	0
1921	only	Mar	14	23s	1
1921	only	Oct	25	23s	0
1922	only	Mar	25	23s	1
1922	1927	Oct	Sat>=1	23s	0
1923	only	Apr	21	23s	1
1924	only	Mar	29	23s	1
1925	only	Apr	4	23s	1
1926	only	Apr	17	23s	1
1927	only	Apr	9	23s	1
1928	only	Apr	14	23s	1
1928	1938	Oct	Sun>=2	2s	0
1929	only	Apr	21	2s	1
1930	only	Apr	13	2s	1
1931	only	Apr	19	2s	1
1932	only	Apr	3	2s	1
1933	only	Mar	26	2s	1
1934	only	Apr	8	2s	1
1935	only	Mar	31	2s	1
1936	only	Apr	19	2s	1
1937	only	Apr	4	2s	1
1938	only	Mar	27	2s	1
1939	only	Apr	16	2s	1
1939	only	Nov	19	2s	0
1940	only	Feb	25	2s	1
1944	only	Sep	17	2s	0
1945	only	Apr	2	2s	1
1945	only	Sep	16	2s	0
1946	only	May	19	2s	1
1946	only	Oct	7	2s	0
Belize	11
1918	1941	Oct	Sat>=1	24	0:30
1919	1942	Feb	Sat>=8	24	0
1942	only	Jun	27	24	1
1945	only	Aug	14	23u	1
1945	only	Dec	15	24	0
1947	1967	Oct	Sat>=1	24	0:30
1948	1968	Feb	Sat>=8	24	0
1973	only	Dec	5	0	1
1974	only	Feb	9	0	0
1982	only	Dec	18	0	1
1983	only	Feb	12	0	0
Bermuda	16
1917	only	Apr	5	24	1
1917	only	Sep	30	24	0
1918	only	Apr	13	24	1
1918	only	Sep	15	24	0
1942	only	Jan	11	2	1
1942	only	Oct	18	2	0
1943	only	Mar	21	2	1
1943	only	Oct	31	2	0
1944	1945	Mar	Sun>=8	2	1
1944	1945	Nov	Sun>=1	2	0
1947	only	May	Sun>=15	2	1
1947	only	Sep	Sun>=8	2	0
1948	1952	May	Sun>=22	2	1
1948	1952	Sep	Sun>=1	2	0
1956	only	May	Sun>=22	2	1
1956	only	Oct	lastSun	2	0
Brazil	57
1931	only	Oct	3	11	1
1932	1933	Apr	1	0	0
1932	only	Oct	3	0	1
1949	1952	Dec	1	0	1
1950	only	Apr	16	1	0
1951	1952	Apr	1	0	0
1953	only	Mar	1	0	0
1963	only	Dec	9	0	1
1964	only	Mar	1	0	0
1965	only	Jan	31	0	1
1965	only	Mar	31	0	0
1965	only	Dec	1	0	1
1966	1968	Mar	1	0	0
1966	1967	Nov	1	0	1
1985	only	Nov	2	0	1
1986	only	Mar	15	0	0
1986	only	Oct	25	0	1
1987	only	Feb	14	0	0
1987	only	Oct	25	0	1
1988	only	Feb	7	0	0
1988	only	Oct	16	0	1
1989	only	Jan	29	0	0
1989	only	Oct	15	0	1
1990	only	Feb	11	0	0
1990	only	Oct	21	0	1
1991	only	Feb	17	0	0
1991	only	Oct	20	0	1
1992	only	Feb	9	0	0
1992	only	Oct	25	0	1
1993	only	Jan	31	0	0
1993	1995	Oct	Sun>=11	0	1
1994	1995	Feb	Sun>=15	0	0
1996	only	Feb	11	0	0
1996	only	Oct	6	0	1
1997	only	Feb	16	0	0
1997	only	Oct	6	0	1
1998	only	Mar	1	0	0
1998	only	Oct	11	0	1
1999	only	Feb	21	0	0
1999	only	Oct	3	0	1
2000	only	Feb	27	0	0
2000	2001	Oct	Sun>=8	0	1
2001	2006	Feb	Sun>=15	0	0
2002	only	Nov	3	0	1
2003	only	Oct	19	0	1
2004	only	Nov	2	0	1
2005	only	Oct	16	0	1
2006	only	Nov	5	0	1
2007	only	Feb	25	0	0
2007	only	Oct	Sun>=8	0	1
2008	2011	Feb	Sun>=15	0	0
2008	2017	Oct	Sun>=15	0	1
2012	only	Feb	Sun>=22	0	0
2013	2014	Feb	Sun>=15	0	0
2015	only	Feb	Sun>=22	0	0
2016	2019	Feb	Sun>=15	0	0
2018	only	Nov	Sun>=1	0	1
Bulg	5
1979	only	Mar	31	23	1
1979	only	Oct	1	1	0
1980	1982	Apr	Sat>=1	23	1
1980	only	Sep	29	1	0
1981	only	Sep	27	2	0
CA	5
1948	only	Mar	14	2:01	1
1949	only	Jan	1	2	0
1950	1966	Apr	lastSun	1	1
1950	1961	Sep	lastSun	2	0
1962	1966	Oct	lastSun	2	0
Canada	10
1918	only	Apr	14	2	1
1918	only	Oct	27	2	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	30	2	0
1974	1986	Apr	lastSun	2	1
1974	2006	Oct	lastSun	2	0
1987	2006	Apr	Sun>=1	2	1
2007	max	Mar	Sun>=8	2	1
2007	max	Nov	Sun>=1	2	0
C-Eur	17
1916	only	Apr	30	23	1
1916	only	Oct	1	1	0
1917	1918	Apr	Mon>=15	2s	1
1917	1918	Sep	Mon>=15	2s	0
1940	only	Apr	1	2s	1
1942	only	Nov	2	2s	0
1943	only	Mar	29	2s	1
1943	only	Oct	4	2s	0
1944	1945	Apr	Mon>=1	2s	1
1944	only	Oct	2	2s	0
1945	only	Sep	16	2s	0
1977	1980	Apr	Sun>=1	2s	1
1977	only	Sep	lastSun	2s	0
1978	only	Oct	1	2s	0
1979	1995	Sep	lastSun	2s	0
1981	max	Mar	lastSun	2s	1
1996	max	Oct	lastSun	2s	0
Chatham	9
1974	only	Nov	Sun>=1	2:45s	1
1975	only	Feb	lastSun	2:45s	0
1975	1988	Oct	lastSun	2:45s	1
1976	1989	Mar	Sun>=1	2:45s	0
1989	only	Oct	Sun>=8	2:45s	1
1990	2007	Mar	Sun>=15	2:45s	0
1990	2006	Oct	Sun>=1	2:45s	1
2007	max	Sep	lastSun	2:45s	1
2008	max	Apr	Sun>=1	2:45s	0
Chicago	6
1920	only	Jun	13	2	1
1920	1921	Oct	lastSun	2	0
1921	only	Mar	lastSun	2	1
1922	1966	Apr	lastSun	2	1
1922	1954	Sep	lastSun	2	0
1955	1966	Oct	lastSun	2	0
Chile	36
1927	1931	Sep	1	0	1
1928	1932	Apr	1	0	0
1968	only	Nov	3	4u	1
1969	only	Mar	30	3u	0
1969	only	Nov	23	4u	1
1970	only	Mar	29	3u	0
1970	1972	Oct	Sun>=9	4u	1
1971	only	Mar	14	3u	0
1972	1986	Mar	Sun>=9	3u	0
1973	only	Sep	30	4u	1
1974	1987	Oct	Sun>=9	4u	1
1987	only	Apr	12	3u	0
1988	1990	Mar	Sun>=9	3u	0
1988	1989	Oct	Sun>=9	4u	1
1990	only	Sep	16	4u	1
1991	1996	Mar	Sun>=9	3u	0
1991	1997	Oct	Sun>=9	4u	1
1997	only	Mar	30	3u	0
1998	only	Mar	Sun>=9	3u	0
1998	only	Sep	27	4u	1
1999	only	Apr	4	3u	0
1999	2010	Oct	Sun>=9	4u	1
2000	2007	Mar	Sun>=9	3u	0
2008	only	Mar	30	3u	0
2009	only	Mar	Sun>=9	3u	0
2010	only	Apr	Sun>=1	3u	0
2011	only	May	Sun>=2	3u	0
2011	only	Aug	Sun>=16	4u	1
2012	2014	Apr	Sun>=23	3u	0
2012	2014	Sep	Sun>=2	4u	1
2016	2018	May	Sun>=9	3u	0
2016	2018	Aug	Sun>=9	4u	1
2019	max	Apr	Sun>=2	3u	0
2019	2021	Sep	Sun>=2	4u	1
2022	only	Sep	Sun>=9	4u	1
2023	max	Sep	Sun>=2	4u	1
CO	2
1992	only	May	3	0	1
1993	only	Feb	6	24	0
Cook	3
1978	only	Nov	12	0	0:30
1979	1991	Mar	Sun>=1	0	0
1979	1990	Oct	lastSun	0	0:30
CR	5
1979	1980	Feb	lastSun	0	1
1979	1980	Jun	Sun>=1	0	0
1991	1992	Jan	Sat>=15	0	1
1991	only	Jul	1	0	0
1992	only	Mar	15	0	0
Cuba	39
1928	only	Jun	10	0	1
1928	only	Oct	10	0	0
1940	1942	Jun	Sun>=1	0	1
1940	1942	Sep	Sun>=1	0	0
1945	1946	Jun	Sun>=1	0	1
1945	1946	Sep	Sun>=1	0	0
1965	only	Jun	1	0	1
1965	only	Sep	30	0	0
1966	only	May	29	0	1
1966	only	Oct	2	0	0
1967	only	Apr	8	0	1
1967	1968	Sep	Sun>=8	0	0
1968	only	Apr	14	0	1
1969	1977	Apr	lastSun	0	1
1969	1971	Oct	lastSun	0	0
1972	1974	Oct	8	0	0
1975	1977	Oct	lastSun	0	0
1978	only	May	7	0	1
1978	1990	Oct	Sun>=8	0	0
1979	1980	Mar	Sun>=15	0	1
1981	1985	May	Sun>=5	0	1
1986	1989	Mar	Sun>=14	0	1
1990	1997	Apr	Sun>=1	0	1
1991	1995	Oct	Sun>=8	0s	0
1996	only	Oct	6	0s	0
1997	only	Oct	12	0s	0
1998	1999	Mar	lastSun	0s	1
1998	2003	Oct	lastSun	0s	0
2000	2003	Apr	Sun>=1	0s	1
2004	only	Mar	lastSun	0s	1
2006	2010	Oct	lastSun	0s	0
2007	only	Mar	Sun>=8	0s	1
2008	only	Mar	Sun>=15	0s	1
2009	2010	Mar	Sun>=8	0s	1
2011	only	Mar	Sun>=15	0s	1
2011	only	Nov	13	0s	0
2012	only	Apr	1	0s	1
2012	max	Nov	Sun>=1	0s	0
2013	max	Mar	Sun>=8	0s	1
Cyprus	9
1975	only	Apr	13	0	1
1975	only	Oct	12	0	0
1976	only	May	15	0	1
1976	only	Oct	11	0	0
1977	1980	Apr	Sun>=1	0	1
1977	only	Sep	25	0	0
1978	only	Oct	2	0	0
1979	1997	Sep	lastSun	0	0
1981	1998	Mar	lastSun	0	1
Czech	6
1945	only	Apr	Mon>=1	2s	1
1945	only	Oct	1	2s	0
1946	only	May	6	2s	1
1946	1949	Oct	Sun>=1	2s	0
1947	1948	Apr	Sun>=15	2s	1
1949	only	Apr	9	2s	1
Denmark	11
1916	only	May	14	23	1
1916	only	Sep	30	23	0
1940	only	May	15	0	1
1945	only	Apr	2	2s	1
1945	only	Aug	15	2s	0
1946	only	May	1	2s	1
1946	only	Sep	1	2s	0
1947	only	May	4	2s	1
1947	only	Aug	10	2s	0
1948	only	May	9	2s	1
1948	only	Aug	8	2s	0
Denver	5
1920	1921	Mar	lastSun	2	1
1920	only	Oct	lastSun	2	0
1921	only	May	22	2	0
1965	1966	Apr	lastSun	2	1
1965	1966	Oct	lastSun	2	0
Detroit	2
1948	only	Apr	lastSun	2	1
1948	only	Sep	lastSun	2	0
Dhaka	2
2009	only	Jun	19	23	1
2009	only	Dec	31	24	0
DR	6
1966	only	Oct	30	0	1
1967	only	Feb	28	0	0
1969	1973	Oct	lastSun	0	0:30
1970	only	Feb	21	0	0
1971	only	Jan	20	0	0
1972	1974	Jan	21	0	0
Ecuador	2
1992	only	Nov	28	0	1
1993	only	Feb	5	0	0
Edm	13
1918	1919	Apr	Sun>=8	2	1
1918	only	Oct	27	2	0
1919	only	May	27	2	0
1920	1923	Apr	lastSun	2	1
1920	only	Oct	lastSun	2	0
1921	1923	Sep	lastSun	2	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	lastSun	2	0
1947	only	Apr	lastSun	2	1
1947	only	Sep	lastSun	2	0
1972	1986	Apr	lastSun	2	1
1972	2006	Oct	lastSun	2	0
E-Eur	6
1977	1980	Apr	Sun>=1	0	1
1977	only	Sep	lastSun	0	0
1978	only	Oct	1	0	0
1979	1995	Sep	lastSun	0	0
1981	max	Mar	lastSun	0	1
1996	max	Oct	lastSun	0	0
E-EurAsia	3
1979	1995	Sep	lastSun	0	0
1981	max	Mar	lastSun	0	1
1996	max	Oct	lastSun	0	0
Egypt	34
1940	only	Jul	15	0	1
1940	only	Oct	1	0	0
1941	only	Apr	15	0	1
1941	only	Sep	16	0	0
1942	1944	Apr	1	0	1
1942	only	Oct	27	0	0
1943	1945	Nov	1	0	0
1945	only	Apr	16	0	1
1957	only	May	10	0	1
1957	1958	Oct	1	0	0
1958	only	May	1	0	1
1959	1981	May	1	1	1
1959	1965	Sep	30	3	0
1966	1994	Oct	1	3	0
1982	only	Jul	25	1	1
1983	only	Jul	12	1	1
1984	1988	May	1	1	1
1989	only	May	6	1	1
1990	1994	May	1	1	1
1995	2010	Apr	lastFri	0s	1
1995	2005	Sep	lastThu	24	0
2006	only	Sep	21	24	0
2007	only	Sep	Thu>=1	24	0
2008	only	Aug	lastThu	24	0
2009	only	Aug	20	24	0
2010	only	Aug	10	24	0
2010	only	Sep	9	24	1
2010	only	Sep	lastThu	24	0
2014	only	May	15	24	1
2014	only	Jun	26	24	0
2014	only	Jul	31	24	1
2014	only	Sep	lastThu	24	0
2023	max	Apr	lastFri	0	1
2023	max	Oct	lastThu	24	0
EgyptAsia	6
1957	only	May	10	0	1
1957	1958	Oct	1	0	0
1958	only	May	1	0	1
1959	1967	May	1	1	1
1959	1965	Sep	30	3	0
1966	only	Oct	1	3	0
Eire	7
1971	only	Oct	31	2u	-1
1972	1980	Mar	Sun>=16	2u	0
1972	1980	Oct	Sun>=23	2u	-1
1981	max	Mar	lastSun	1u	0
1981	1989	Oct	Sun>=23	1u	-1
1990	1995	Oct	Sun>=22	1u	-1
1996	max	Oct	lastSun	1u	-1
EU	6
1977	1980	Apr	Sun>=1	1u	1
1977	only	Sep	lastSun	1u	0
1978	only	Oct	1	1u	0
1979	1995	Sep	lastSun	1u	0
1981	max	Mar	lastSun	1u	1
1996	max	Oct	lastSun	1u	0
EUAsia	3
1979	1995	Sep	lastSun	1u	0
1981	max	Mar	lastSun	1u	1
1996	max	Oct	lastSun	1u	0
Falk	12
1937	1938	Sep	lastSun	0	1
1938	1942	Mar	Sun>=19	0	0
1939	only	Oct	1	0	1
1940	1942	Sep	lastSun	0	1
1943	only	Jan	1	0	0
1983	only	Sep	lastSun	0	1
1984	1985	Apr	lastSun	0	0
1984	only	Sep	16	0	1
1985	2000	Sep	Sun>=9	0	1
1986	2000	Apr	Sun>=16	0	0
2001	2010	Apr	Sun>=15	2	0
2001	2010	Sep	Sun>=1	2	1
Fiji	12
1998	1999	Nov	Sun>=1	2	1
1999	2000	Feb	lastSun	3	0
2009	only	Nov	29	2	1
2010	only	Mar	lastSun	3	0
2010	2013	Oct	Sun>=21	2	1
2011	only	Mar	Sun>=1	3	0
2012	2013	Jan	Sun>=18	3	0
2014	only	Jan	Sun>=18	2	0
2014	2018	Nov	Sun>=1	2	1
2015	2021	Jan	Sun>=12	3	0
2019	only	Nov	Sun>=8	2	1
2020	only	Dec	20	0	1
Finland	4
1942	only	Apr	2	24	1
1942	only	Oct	4	1	0
1981	1982	Mar	lastSun	2	1
1981	1982	Sep	lastSun	3	0
France	42
1916	only	Jun	14	23s	1
1916	1919	Oct	Sun>=1	23s	0
1917	only	Mar	24	23s	1
1918	only	Mar	9	23s	1
1919	only	Mar	1	23s	1
1920	only	Feb	14	23s	1
1920	only	Oct	23	23s	0
1921	only	Mar	14	23s	1
1921	only	Oct	25	23s	0
1922	only	Mar	25	23s	1
1922	1938	Oct	Sat>=1	23s	0
1923	only	May	26	23s	1
1924	only	Mar	29	23s	1
1925	only	Apr	4	23s	1
1926	only	Apr	17	23s	1
1927	only	Apr	9	23s	1
1928	only	Apr	14	23s	1
1929	only	Apr	20	23s	1
1930	only	Apr	12	23s	1
1931	only	Apr	18	23s	1
1932	only	Apr	2	23s	1
1933	only	Mar	25	23s	1
1934	only	Apr	7	23s	1
1935	only	Mar	30	23s	1
1936	only	Apr	18	23s	1
1937	only	Apr	3	23s	1
1938	only	Mar	26	23s	1
1939	only	Apr	15	23s	1
1939	only	Nov	18	23s	0
1940	only	Feb	25	2	1
1941	only	May	5	0	2
1941	only	Oct	6	0	1
1942	only	Mar	9	0	2
1942	only	Nov	2	3	1
1943	only	Mar	29	2	2
1943	only	Oct	4	3	1
1944	only	Apr	3	2	2
1944	only	Oct	8	1	1
1945	only	Apr	2	2	2
1945	only	Sep	16	3	0
1976	only	Mar	28	1	1
1976	only	Sep	26	1	0
GB-Eire	65
1916	only	May	21	2s	1
1916	only	Oct	1	2s	0
1917	only	Apr	8	2s	1
1917	only	Sep	17	2s	0
1918	only	Mar	24	2s	1
1918	only	Sep	30	2s	0
1919	only	Mar	30	2s	1
1919	only	Sep	29	2s	0
1920	only	Mar	28	2s	1
1920	only	Oct	25	2s	0
1921	only	Apr	3	2s	1
1921	only	Oct	3	2s	0
1922	only	Mar	26	2s	1
1922	only	Oct	8	2s	0
1923	only	Apr	Sun>=16	2s	1
1923	1924	Sep	Sun>=16	2s	0
1924	only	Apr	Sun>=9	2s	1
1925	1926	Apr	Sun>=16	2s	1
1925	1938	Oct	Sun>=2	2s	0
1927	only	Apr	Sun>=9	2s	1
1928	1929	Apr	Sun>=16	2s	1
1930	only	Apr	Sun>=9	2s	1
1931	1932	Apr	Sun>=16	2s	1
1933	only	Apr	Sun>=9	2s	1
1934	only	Apr	Sun>=16	2s	1
1935	only	Apr	Sun>=9	2s	1
1936	1937	Apr	Sun>=16	2s	1
1938	only	Apr	Sun>=9	2s	1
1939	only	Apr	Sun>=16	2s	1
1939	only	Nov	Sun>=16	2s	0
1940	only	Feb	Sun>=23	2s	1
1941	only	May	Sun>=2	1s	2
1941	1943	Aug	Sun>=9	1s	1
1942	1944	Apr	Sun>=2	1s	2
1944	only	Sep	Sun>=16	1s	1
1945	only	Apr	Mon>=2	1s	2
1945	only	Jul	Sun>=9	1s	1
1945	1946	Oct	Sun>=2	2s	0
1946	only	Apr	Sun>=9	2s	1
1947	only	Mar	16	2s	1
1947	only	Apr	13	1s	2
1947	only	Aug	10	1s	1
1947	only	Nov	2	2s	0
1948	only	Mar	14	2s	1
1948	only	Oct	31	2s	0
1949	only	Apr	3	2s	1
1949	only	Oct	30	2s	0
1950	1952	Apr	Sun>=14	2s	1
1950	1952	Oct	Sun>=21	2s	0
1953	only	Apr	Sun>=16	2s	1
1953	1960	Oct	Sun>=2	2s	0
1954	only	Apr	Sun>=9	2s	1
1955	1956	Apr	Sun>=16	2s	1
1957	only	Apr	Sun>=9	2s	1
1958	1959	Apr	Sun>=16	2s	1
1960	only	Apr	Sun>=9	2s	1
1961	1963	Mar	lastSun	2s	1
1961	1968	Oct	Sun>=23	2s	0
1964	1967	Mar	Sun>=19	2s	1
1968	only	Feb	18	2s	1
1972	1980	Mar	Sun>=16	2s	1
1972	1980	Oct	Sun>=23	2s	0
1981	1995	Mar	lastSun	1u	1
1981	1989	Oct	Sun>=23	1u	0
1990	1995	Oct	Sun>=22	1u	0
Germany	8
1946	only	Apr	14	2s	1
1946	only	Oct	7	2s	0
1947	only	Apr	6	3s	1
1947	only	May	11	2s	2
1947	only	Jun	29	3	1
1947	1949	Oct	Sun>=1	2s	0
1948	only	Apr	18	2s	1
1949	only	Apr	10	2s	1
Ghana	6
1919	only	Nov	24	0	0:20
1920	1942	Jan	1	2	0
1920	1939	Sep	1	2	0:20
1940	1941	May	1	2	0:20
1950	1955	Sep	1	2	0:30
1951	1956	Jan	1	2	0
Greece	19
1932	only	Jul	7	0	1
1932	only	Sep	1	0	0
1941	only	Apr	7	0	1
1942	only	Nov	2	3	0
1943	only	Mar	30	0	1
1943	only	Oct	4	0	0
1952	only	Jul	1	0	1
1952	only	Nov	2	0	0
1975	only	Apr	12	0s	1
1975	only	Nov	26	0s	0
1976	only	Apr	11	2s	1
1976	only	Oct	10	2s	0
1977	1978	Apr	Sun>=1	2s	1
1977	only	Sep	26	2s	0
1978	only	Sep	24	4	0
1979	only	Apr	1	9	1
1979	only	Sep	29	2	0
1980	only	Apr	1	0	1
1980	only	Sep	28	0	0
Guam	14
1959	only	Jun	27	2	1
1961	only	Jan	29	2	0
1967	only	Sep	1	2	1
1969	only	Jan	26	0:01	0
1969	only	Jun	22	2	1
1969	only	Aug	31	2	0
1970	1971	Apr	lastSun	0	1
1970	1971	Sep	Sun>=1	2	0
1973	only	Dec	16	2	1
1974	only	Feb	24	2	0
1976	only	May	26	2	1
1976	only	Aug	22	2:01	0
1977	only	Apr	24	2	1
1977	only	Aug	28	2	0
Guat	8
1973	only	Nov	25	0	1
1974	only	Feb	24	0	0
1983	only	May	21	0	1
1983	only	Sep	22	0	0
1991	only	Mar	23	0	1
1991	only	Sep	7	0	0
2006	only	Apr	30	0	1
2006	only	Oct	1	0	0
Haiti	11
1983	only	May	8	0	1
1983	1987	Oct	lastSun	0	0
1984	1987	Apr	lastSun	0	1
1988	1997	Apr	Sun>=1	1s	1
1988	1997	Oct	lastSun	1s	0
2005	2006	Apr	Sun>=1	0	1
2005	2006	Oct	lastSun	0	0
2012	2015	Mar	Sun>=8	2	1
2012	2015	Nov	Sun>=1	2	0
2017	max	Mar	Sun>=8	2	1
2017	max	Nov	Sun>=1	2	0
Halifax	41
1916	only	Apr	1	0	1
1916	only	Oct	1	0	0
1920	only	May	9	0	1
1920	only	Aug	29	0	0
1921	only	May	6	0	1
1921	1922	Sep	5	0	0
1922	only	Apr	30	0	1
1923	1925	May	Sun>=1	0	1
1923	only	Sep	4	0	0
1924	only	Sep	15	0	0
1925	only	Sep	28	0	0
1926	only	May	16	0	1
1926	only	Sep	13	0	0
1927	only	May	1	0	1
1927	only	Sep	26	0	0
1928	1931	May	Sun>=8	0	1
1928	only	Sep	9	0	0
1929	only	Sep	3	0	0
1930	only	Sep	15	0	0
1931	1932	Sep	Mon>=24	0	0
1932	only	May	1	0	1
1933	only	Apr	30	0	1
1933	only	Oct	2	0	0
1934	only	May	20	0	1
1934	only	Sep	16	0	0
1935	only	Jun	2	0	1
1935	only	Sep	30	0	0
1936	only	Jun	1	0	1
1936	only	Sep	14	0	0
1937	1938	May	Sun>=1	0	1
1937	1941	Sep	Mon>=24	0	0
1939	only	May	28	0	1
1940	1941	May	Sun>=1	0	1
1946	1949	Apr	lastSun	2	1
1946	1949	Sep	lastSun	2	0
1951	1954	Apr	lastSun	2	1
1951	1954	Sep	lastSun	2	0
1956	1959	Apr	lastSun	2	1
1956	1959	Sep	lastSun	2	0
1962	1973	Apr	lastSun	2	1
1962	1973	Oct	lastSun	2	0
HK	14
1946	only	Apr	21	0	1
1946	only	Dec	1	3:30s	0
1947	only	Apr	13	3:30s	1
1947	only	Nov	30	3:30s	0
1948	only	May	2	3:30s	1
1948	1952	Oct	Sun>=28	3:30s	0
1949	1953	Apr	Sun>=1	3:30	1
1953	1964	Oct	Sun>=31	3:30	0
1954	1964	Mar	Sun>=18	3:30	1
1965	1976	Apr	Sun>=16	3:30	1
1965	1976	Oct	Sun>=16	3:30	0
1973	only	Dec	30	3:30	1
1979	only	May	13	3:30	1
1979	only	Oct	21	3:30	0
Holiday	2
1992	1993	Oct	lastSun	2s	1
1993	1994	Mar	Sun>=1	2s	0
Hond	4
1987	1988	May	Sun>=1	0	1
1987	1988	Sep	lastSun	0	0
2006	only	May	Sun>=1	0	1
2006	only	Aug	Mon>=1	0	0
Hungary	19
1918	1919	Apr	15	2	1
1918	1920	Sep	Mon>=15	3	0
1920	only	Apr	5	2	1
1945	only	May	1	23	1
1945	only	Nov	1	1	0
1946	only	Mar	31	2s	1
1946	only	Oct	7	2	0
1947	1949	Apr	Sun>=4	2s	1
1947	1949	Oct	Sun>=1	2s	0
1954	only	May	23	0	1
1954	only	Oct	3	0	0
1955	only	May	22	2	1
1955	only	Oct	2	3	0
1956	1957	Jun	Sun>=1	2	1
1956	1957	Sep	lastSun	3	0
1980	only	Apr	6	0	1
1980	only	Sep	28	1	0
1981	1983	Mar	lastSun	0	1
1981	1983	Sep	lastSun	1	0
Iceland	16
1917	1919	Feb	19	23	1
1917	only	Oct	21	1	0
1918	1919	Nov	16	1	0
1921	only	Mar	19	23	1
1921	only	Jun	23	1	0
1939	only	Apr	29	23	1
1939	only	Oct	29	2	0
1940	only	Feb	25	2	1
1940	1941	Nov	Sun>=2	1s	0
1941	1942	Mar	Sun>=2	1s	1
1942	1948	Oct	Sun>=22	1s	0
1943	1946	Mar	Sun>=1	1s	1
1947	1967	Apr	Sun>=1	1s	1
1949	only	Oct	30	1s	0
1950	1966	Oct	Sun>=22	1s	0
1967	only	Oct	29	1s	0
Indianapolis	3
1941	only	Jun	22	2	1
1941	1954	Sep	lastSun	2	0
1946	1954	Apr	lastSun	2	1
Iran	40
1910	only	Jan	1	0	0
1977	only	Mar	21	23	1
1977	only	Oct	20	24	0
1978	only	Mar	24	24	1
1978	only	Aug	5	1	0
1979	only	May	26	0	1
1979	only	Sep	18	0	0
1980	only	Mar	20	0	1
1980	only	Sep	22	0	0
1991	only	May	2	0	1
1991	1995	Sep	21	0	0
1992	1995	Mar	21	0	1
1996	only	Mar	20	0	1
1996	only	Sep	20	24	0
1997	1999	Mar	21	24	1
1997	1999	Sep	21	24	0
2000	only	Mar	20	24	1
2000	only	Sep	20	24	0
2001	2003	Mar	21	24	1
2001	2003	Sep	21	24	0
2004	only	Mar	20	24	1
2004	only	Sep	20	24	0
2005	only	Mar	21	24	1
2005	only	Sep	21	24	0
2008	only	Mar	20	24	1
2008	only	Sep	20	24	0
2009	2011	Mar	21	24	1
2009	2011	Sep	21	24	0
2012	only	Mar	20	24	1
2012	only	Sep	20	24	0
2013	2015	Mar	21	24	1
2013	2015	Sep	21	24	0
2016	only	Mar	20	24	1
2016	only	Sep	20	24	0
2017	2019	Mar	21	24	1
2017	2019	Sep	21	24	0
2020	only	Mar	20	24	1
2020	only	Sep	20	24	0
2021	2022	Mar	21	24	1
2021	2022	Sep	21	24	0
Iraq	8
1982	only	May	1	0	1
1982	1984	Oct	1	0	0
1983	only	Mar	31	0	1
1984	1985	Apr	1	0	1
1985	1990	Sep	lastSun	1s	0
1986	1990	Mar	lastSun	1s	1
1991	2007	Apr	1	3s	1
1991	2007	Oct	1	3s	0
Italy	41
1916	only	Jun	3	24	1
1916	1917	Sep	30	24	0
1917	only	Mar	31	24	1
1918	only	Mar	9	24	1
1918	only	Oct	6	24	0
1919	only	Mar	1	24	1
1919	only	Oct	4	24	0
1920	only	Mar	20	24	1
1920	only	Sep	18	24	0
1940	only	Jun	14	24	1
1942	only	Nov	2	2s	0
1943	only	Mar	29	2s	1
1943	only	Oct	4	2s	0
1944	only	Apr	2	2s	1
1944	only	Sep	17	2s	0
1945	only	Apr	2	2	1
1945	only	Sep	15	1	0
1946	only	Mar	17	2s	1
1946	only	Oct	6	2s	0
1947	only	Mar	16	0s	1
1947	only	Oct	5	0s	0
1948	only	Feb	29	2s	1
1948	only	Oct	3	2s	0
1966	1968	May	Sun>=22	0s	1
1966	only	Sep	24	24	0
1967	1969	Sep	Sun>=22	0s	0
1969	only	Jun	1	0s	1
1970	only	May	31	0s	1
1970	only	Sep	lastSun	0s	0
1971	1972	May	Sun>=22	0s	1
1971	only	Sep	lastSun	0s	0
1972	only	Oct	1	0s	0
1973	only	Jun	3	0s	1
1973	1974	Sep	lastSun	0s	0
1974	only	May	26	0s	1
1975	only	Jun	1	0s	1
1975	1977	Sep	lastSun	0s	0
1976	only	May	30	0s	1
1977	1979	May	Sun>=22	0s	1
1978	only	Oct	1	0s	0
1979	only	Sep	30	0s	0
Japan	4
1948	only	May	Sat>=1	24	1
1948	1951	Sep	Sat>=8	25	0
1949	only	Apr	Sat>=1	24	1
1950	1951	May	Sat>=1	24	1
Jordan	32
1973	only	Jun	6	0	1
1973	1975	Oct	1	0	0
1974	1977	May	1	0	1
1976	only	Nov	1	0	0
1977	only	Oct	1	0	0
1978	only	Apr	30	0	1
1978	only	Sep	30	0	0
1985	only	Apr	1	0	1
1985	only	Oct	1	0	0
1986	1988	Apr	Fri>=1	0	1
1986	1990	Oct	Fri>=1	0	0
1989	only	May	8	0	1
1990	only	Apr	27	0	1
1991	only	Apr	17	0	1
1991	only	Sep	27	0	0
1992	only	Apr	10	0	1
1992	1993	Oct	Fri>=1	0	0
1993	1998	Apr	Fri>=1	0	1
1994	only	Sep	Fri>=15	0	0
1995	1998	Sep	Fri>=15	0s	0
1999	only	Jul	1	0s	1
1999	2002	Sep	lastFri	0s	0
2000	2001	Mar	lastThu	0s	1
2002	2012	Mar	lastThu	24	1
2003	only	Oct	24	0s	0
2004	only	Oct	15	0s	0
2005	only	Sep	lastFri	0s	0
2006	2011	Oct	lastFri	0s	0
2013	only	Dec	20	0	0
2014	2021	Mar	lastThu	24	1
2014	2022	Oct	lastFri	0s	0
2022	only	Feb	lastThu	24	1
Kyrgyz	4
1992	1996	Apr	Sun>=7	0s	1
1992	1996	Sep	lastSun	0	0
1997	2005	Mar	lastSun	2:30	1
1997	2004	Oct	lastSun	2:30	0
Latvia	2
1989	1996	Mar	lastSun	2s	1
1989	1996	Sep	lastSun	2s	0
Lebanon	24
1920	only	Mar	28	0	1
1920	only	Oct	25	0	0
1921	only	Apr	3	0	1
1921	only	Oct	3	0	0
1922	only	Mar	26	0	1
1922	only	Oct	8	0	0
1923	only	Apr	22	0	1
1923	only	Sep	16	0	0
1957	1961	May	1	0	1
1957	1961	Oct	1	0	0
1972	only	Jun	22	0	1
1972	1977	Oct	1	0	0
1973	1977	May	1	0	1
1978	only	Apr	30	0	1
1978	only	Sep	30	0	0
1984	1987	May	1	0	1
1984	1991	Oct	16	0	0
1988	only	Jun	1	0	1
1989	only	May	10	0	1
1990	1992	May	1	0	1
1992	only	Oct	4	0	0
1993	max	Mar	lastSun	0	1
1993	1998	Sep	lastSun	0	0
1999	max	Oct	lastSun	0	0
LH	14
1981	1984	Oct	lastSun	2	1
1982	1985	Mar	Sun>=1	2	0
1985	only	Oct	lastSun	2	0:30
1986	1989	Mar	Sun>=15	2	0
1986	only	Oct	19	2	0:30
1987	1999	Oct	lastSun	2	0:30
1990	1995	Mar	Sun>=1	2	0
1996	2005	Mar	lastSun	2	0
2000	only	Aug	lastSun	2	0:30
2001	2007	Oct	lastSun	2	0:30
2006	only	Apr	Sun>=1	2	0
2007	only	Mar	lastSun	2	0
2008	max	Apr	Sun>=1	2	0
2008	max	Oct	Sun>=1	2	0:30
Libya	17
1951	only	Oct	14	2	1
1952	only	Jan	1	0	0
1953	only	Oct	9	2	1
1954	only	Jan	1	0	0
1955	only	Sep	30	0	1
1956	only	Jan	1	0	0
1982	1984	Apr	1	0	1
1982	1985	Oct	1	0	0
1985	only	Apr	6	0	1
1986	only	Apr	4	0	1
1986	only	Oct	3	0	0
1987	1989	Apr	1	0	1
1987	1989	Oct	1	0	0
1997	only	Apr	4	0	1
1997	only	Oct	4	0	0
2013	only	Mar	lastFri	1	1
2013	only	Oct	lastFri	2	0
Louisville	9
1921	only	May	1	2	1
1921	only	Sep	1	2	0
1941	only	Apr	lastSun	2	1
1941	only	Sep	lastSun	2	0
1946	only	Apr	lastSun	0:01	1
1946	only	Jun	2	2	0
1950	1961	Apr	lastSun	2	1
1950	1955	Sep	lastSun	2	0
1956	1961	Oct	lastSun	2	0
Lux	23
1916	only	May	14	23	1
1916	only	Oct	1	1	0
1917	only	Apr	28	23	1
1917	only	Sep	17	1	0
1918	only	Apr	Mon>=15	2s	1
1918	only	Sep	Mon>=15	2s	0
1919	only	Mar	1	23	1
1919	only	Oct	5	3	0
1920	only	Feb	14	23	1
1920	only	Oct	24	2	0
1921	only	Mar	14	23	1
1921	only	Oct	26	2	0
1922	only	Mar	25	23	1
1922	only	Oct	Sun>=2	1	0
1923	only	Apr	21	23	1
1923	only	Oct	Sun>=2	2	0
1924	only	Mar	29	23	1
1924	1928	Oct	Sun>=2	1	0
1925	only	Apr	5	23	1
1926	only	Apr	17	23	1
1927	only	Apr	9	23	1
1928	only	Apr	14	23	1
1929	only	Apr	20	23	1
Macau	27
1942	1943	Apr	30	23	1
1942	only	Nov	17	23	0
1943	only	Sep	30	23	0
1946	only	Apr	30	23s	1
1946	only	Sep	30	23s	0
1947	only	Apr	19	23s	1
1947	only	Nov	30	23s	0
1948	only	May	2	23s	1
1948	only	Oct	31	23s	0
1949	1950	Apr	Sat>=1	23s	1
1949	1950	Oct	lastSat	23s	0
1951	only	Mar	31	23s	1
1951	only	Oct	28	23s	0
1952	1953	Apr	Sat>=1	23s	1
1952	only	Nov	1	23s	0
1953	1954	Oct	lastSat	23s	0
1954	1956	Mar	Sat>=17	23s	1
1955	only	Nov	5	23s	0
1956	1964	Nov	Sun>=1	3:30	0
1957	1964	Mar	Sun>=18	3:30	1
1965	1973	Apr	Sun>=16	3:30	1
1965	1966	Oct	Sun>=16	2:30	0
1967	1976	Oct	Sun>=16	3:30	0
1973	only	Dec	30	3:30	1
1975	1976	Apr	Sun>=16	3:30	1
1979	only	May	13	3:30	1
1979	only	Oct	Sun>=16	3:30	0
Malta	7
1973	only	Mar	31	0s	1
1973	only	Sep	29	0s	0
1974	only	Apr	21	0s	1
1974	only	Sep	16	0s	0
1975	1979	Apr	Sun>=15	2	1
1975	1980	Sep	Sun>=15	2	0
1980	only	Mar	31	2	1
Marengo	4
1951	only	Apr	lastSun	2	1
1951	only	Sep	lastSun	2	0
1954	1960	Apr	lastSun	2	1
1954	1960	Sep	lastSun	2	0
Mauritius	4
1982	only	Oct	10	0	1
1983	only	Mar	21	0	0
2008	only	Oct	lastSun	2	1
2009	only	Mar	lastSun	2	0
Menominee	4
1946	only	Apr	lastSun	2	1
1946	only	Sep	lastSun	2	0
1966	only	Apr	lastSun	2	1
1966	only	Oct	lastSun	2	0
Mexico	16
1931	only	Apr	30	0	1
1931	only	Oct	1	0	0
1939	only	Feb	5	0	1
1939	only	Jun	25	0	0
1940	only	Dec	9	0	1
1941	only	Apr	1	0	0
1943	only	Dec	16	0	1
1944	only	May	1	0	0
1950	only	Feb	12	0	1
1950	only	Jul	30	0	0
1996	2000	Apr	Sun>=1	2	1
1996	2000	Oct	lastSun	2	0
2001	only	May	Sun>=1	2	1
2001	only	Sep	lastSun	2	0
2002	2022	Apr	Sun>=1	2	1
2002	2022	Oct	lastSun	2	0
Moldova	2
1997	max	Mar	lastSun	2	1
1997	max	Oct	lastSun	3	0
Moncton	13
1933	1935	Jun	Sun>=8	1	1
1933	1935	Sep	Sun>=8	1	0
1936	1938	Jun	Sun>=1	1	1
1936	1938	Sep	Sun>=1	1	0
1939	only	May	27	1	1
1939	1941	Sep	Sat>=21	1	0
1940	only	May	19	1	1
1941	only	May	4	1	1
1946	1972	Apr	lastSun	2	1
1946	1956	Sep	lastSun	2	0
1957	1972	Oct	lastSun	2	0
1993	2006	Apr	Sun>=1	0:01	1
1993	2006	Oct	lastSun	0:01	0
Mongol	9
1983	1984	Apr	1	0	1
1983	only	Oct	1	0	0
1984	1998	Sep	lastSun	0	0
1985	1998	Mar	lastSun	0	1
2001	only	Apr	lastSat	2	1
2001	2006	Sep	lastSat	2	0
2002	2006	Mar	lastSat	2	1
2015	2016	Mar	lastSat	2	1
2015	2016	Sep	lastSat	0	0
Morocco	183
1939	only	Sep	12	0	1
1939	only	Nov	19	0	0
1940	only	Feb	25	0	1
1945	only	Nov	18	0	0
1950	only	Jun	11	0	1
1950	only	Oct	29	0	0
1967	only	Jun	3	12	1
1967	only	Oct	1	0	0
1974	only	Jun	24	0	1
1974	only	Sep	1	0	0
1976	1977	May	1	0	1
1976	only	Aug	1	0	0
1977	only	Sep	28	0	0
1978	only	Jun	1	0	1
1978	only	Aug	4	0	0
2008	only	Jun	1	0	1
2008	only	Sep	1	0	0
2009	only	Jun	1	0	1
2009	only	Aug	21	0	0
2010	only	May	2	0	1
2010	only	Aug	8	0	0
2011	only	Apr	3	0	1
2011	only	Jul	31	0	0
2012	2013	Apr	lastSun	2	1
2012	only	Jul	20	3	0
2012	only	Aug	20	2	1
2012	only	Sep	30	3	0
2013	only	Jul	7	3	0
2013	only	Aug	10	2	1
2013	2018	Oct	lastSun	3	0
2014	2018	Mar	lastSun	2	1
2014	only	Jun	28	3	0
2014	only	Aug	2	2	1
2015	only	Jun	14	3	0
2015	only	Jul	19	2	1
2016	only	Jun	5	3	0
2016	only	Jul	10	2	1
2017	only	May	21	3	0
2017	only	Jul	2	2	1
2018	only	May	13	3	0
2018	only	Jun	17	2	1
2019	only	May	5	3	-1
2019	only	Jun	9	2	0
2020	only	Apr	19	3	-1
2020	only	May	31	2	0
2021	only	Apr	11	3	-1
2021	only	May	16	2	0
2022	only	Mar	27	3	-1
2022	only	May	8	2	0
2023	only	Mar	19	3	-1
2023	only	Apr	23	2	0
2024	only	Mar	10	3	-1
2024	only	Apr	14	2	0
2025	only	Feb	23	3	-1
2025	only	Apr	6	2	0
2026	only	Feb	15	3	-1
2026	only	Mar	22	2	0
2027	only	Feb	7	3	-1
2027	only	Mar	14	2	0
2028	only	Jan	23	3	-1
2028	only	Mar	5	2	0
2029	only	Jan	14	3	-1
2029	only	Feb	18	2	0
2029	only	Dec	30	3	-1
2030	only	Feb	10	2	0
2030	only	Dec	22	3	-1
2031	only	Jan	26	2	0
2031	only	Dec	14	3	-1
2032	only	Jan	18	2	0
2032	only	Nov	28	3	-1
2033	only	Jan	9	2	0
2033	only	Nov	20	3	-1
2033	only	Dec	25	2	0
2034	only	Nov	5	3	-1
2034	only	Dec	17	2	0
2035	only	Oct	28	3	-1
2035	only	Dec	9	2	0
2036	only	Oct	19	3	-1
2036	only	Nov	23	2	0
2037	only	Oct	4	3	-1
2037	only	Nov	15	2	0
2038	only	Sep	26	3	-1
2038	only	Oct	31	2	0
2039	only	Sep	18	3	-1
2039	only	Oct	23	2	0
2040	only	Sep	2	3	-1
2040	only	Oct	14	2	0
2041	only	Aug	25	3	-1
2041	only	Sep	29	2	0
2042	only	Aug	10	3	-1
2042	only	Sep	21	2	0
2043	only	Aug	2	3	-1
2043	only	Sep	13	2	0
2044	only	Jul	24	3	-1
2044	only	Aug	28	2	0
2045	only	Jul	9	3	-1
2045	only	Aug	20	2	0
2046	only	Jul	1	3	-1
2046	only	Aug	5	2	0
2047	only	Jun	23	3	-1
2047	only	Jul	28	2	0
2048	only	Jun	7	3	-1
2048	only	Jul	19	2	0
2049	only	May	30	3	-1
2049	only	Jul	4	2	0
2050	only	May	15	3	-1
2050	only	Jun	26	2	0
2051	only	May	7	3	-1
2051	only	Jun	18	2	0
2052	only	Apr	28	3	-1
2052	only	Jun	2	2	0
2053	only	Apr	13	3	-1
2053	only	May	25	2	0
2054	only	Apr	5	3	-1
2054	only	May	10	2	0
2055	only	Mar	28	3	-1
2055	only	May	2	2	0
2056	only	Mar	12	3	-1
2056	only	Apr	23	2	0
2057	only	Mar	4	3	-1
2057	only	Apr	8	2	0
2058	only	Feb	17	3	-1
2058	only	Mar	31	2	0
2059	only	Feb	9	3	-1
2059	only	Mar	23	2	0
2060	only	Feb	1	3	-1
2060	only	Mar	7	2	0
2061	only	Jan	16	3	-1
2061	only	Feb	27	2	0
2062	only	Jan	8	3	-1
2062	only	Feb	12	2	0
2062	only	Dec	31	3	-1
2063	only	Feb	4	2	0
2063	only	Dec	16	3	-1
2064	only	Jan	27	2	0
2064	only	Dec	7	3	-1
2065	only	Jan	11	2	0
2065	only	Nov	22	3	-1
2066	only	Jan	3	2	0
2066	only	Nov	14	3	-1
2066	only	Dec	26	2	0
2067	only	Nov	6	3	-1
2067	only	Dec	11	2	0
2068	only	Oct	21	3	-1
2068	only	Dec	2	2	0
2069	only	Oct	13	3	-1
2069	only	Nov	17	2	0
2070	only	Oct	5	3	-1
2070	only	Nov	9	2	0
2071	only	Sep	20	3	-1
2071	only	Nov	1	2	0
2072	only	Sep	11	3	-1
2072	only	Oct	16	2	0
2073	only	Aug	27	3	-1
2073	only	Oct	8	2	0
2074	only	Aug	19	3	-1
2074	only	Sep	30	2	0
2075	only	Aug	11	3	-1
2075	only	Sep	15	2	0
2076	only	Jul	26	3	-1
2076	only	Sep	6	2	0
2077	only	Jul	18	3	-1
2077	only	Aug	22	2	0
2078	only	Jul	10	3	-1
2078	only	Aug	14	2	0
2079	only	Jun	25	3	-1
2079	only	Aug	6	2	0
2080	only	Jun	16	3	-1
2080	only	Jul	21	2	0
2081	only	Jun	1	3	-1
2081	only	Jul	13	2	0
2082	only	May	24	3	-1
2082	only	Jun	28	2	0
2083	only	May	16	3	-1
2083	only	Jun	20	2	0
2084	only	Apr	30	3	-1
2084	only	Jun	11	2	0
2085	only	Apr	22	3	-1
2085	only	May	27	2	0
2086	only	Apr	14	3	-1
2086	only	May	19	2	0
2087	only	Mar	30	3	-1
2087	only	May	11	2	0
Namibia	3
1994	only	Mar	21	0	-1
1994	2017	Sep	Sun>=1	2	0
1995	2017	Apr	Sun>=1	2	-1
NBorneo	2
1935	1941	Sep	14	0	0:20
1935	1941	Dec	14	0	0
NC	4
1977	1978	Dec	Sun>=1	0	1
1978	1979	Feb	27	0	0
1996	only	Dec	1	2s	0
1997	only	Mar	2	2s	0
Neth	20
1916	only	May	1	0	1
1916	only	Oct	1	0	0
1917	only	Apr	16	2s	1
1917	only	Sep	17	2s	0
1918	1921	Apr	Mon>=1	2s	1
1918	1921	Sep	lastMon	2s	0
1922	only	Mar	lastSun	2s	1
1922	1936	Oct	Sun>=2	2s	0
1923	only	Jun	Fri>=1	2s	1
1924	only	Mar	lastSun	2s	1
1925	only	Jun	Fri>=1	2s	1
1926	1931	May	15	2s	1
1932	only	May	22	2s	1
1933	1936	May	15	2s	1
1937	only	May	22	2s	1
1937	only	Jul	1	0	1
1937	1939	Oct	Sun>=2	2s	0
1938	1939	May	15	2s	1
1945	only	Apr	2	2s	1
1945	only	Sep	16	2s	0
Nic	6
1979	1980	Mar	Sun>=16	0	1
1979	1980	Jun	Mon>=23	0	0
2005	only	Apr	10	0	1
2005	only	Oct	Sun>=1	0	0
2006	only	Apr	30	2	1
2006	only	Oct	Sun>=1	1	0
Norway	7
1916	only	May	22	1	1
1916	only	Sep	30	0	0
1945	only	Apr	2	2s	1
1945	only	Oct	1	2s	0
1959	1964	Mar	Sun>=15	2s	1
1959	1965	Sep	Sun>=15	2s	0
1965	only	Apr	25	2s	1
NT_YK	10
1918	only	Apr	14	2	1
1918	only	Oct	27	2	0
1919	only	May	25	2	1
1919	only	Nov	1	0	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	30	2	0
1972	1986	Apr	lastSun	2	1
1972	2006	Oct	lastSun	2	0
1987	2006	Apr	Sun>=1	2	1
NYC	5
1920	only	Mar	lastSun	2	1
1920	only	Oct	lastSun	2	0
1921	1966	Apr	lastSun	2	1
1921	1954	Sep	lastSun	2	0
1955	1966	Oct	lastSun	2	0
NZ	16
1927	only	Nov	6	2	0
1928	only	Mar	4	2	0
1928	1933	Oct	Sun>=8	2	0:30
1929	1933	Mar	Sun>=15	2	0
1934	1940	Apr	lastSun	2	0
1934	1940	Sep	lastSun	2	0:30
1946	only	Jan	1	0	0
1974	only	Nov	Sun>=1	2s	1
1975	only	Feb	lastSun	2s	0
1975	1988	Oct	lastSun	2s	1
1976	1989	Mar	Sun>=1	2s	0
1989	only	Oct	Sun>=8	2s	1
1990	2007	Mar	Sun>=15	2s	0
1990	2006	Oct	Sun>=1	2s	1
2007	max	Sep	lastSun	2s	1
2008	max	Apr	Sun>=1	2s	0
Pakistan	5
2002	only	Apr	Sun>=2	0	1
2002	only	Oct	Sun>=2	0	0
2008	only	Jun	1	0	1
2008	2009	Nov	1	0	0
2009	only	Apr	15	0	1
Palestine	110
1999	2005	Apr	Fri>=15	0	1
1999	2003	Oct	Fri>=15	0	0
2004	only	Oct	1	1	0
2005	only	Oct	4	2	0
2006	2007	Apr	1	0	1
2006	only	Sep	22	0	0
2007	only	Sep	13	2	0
2008	2009	Mar	lastFri	0	1
2008	only	Sep	1	0	0
2009	only	Sep	4	1	0
2010	only	Mar	26	0	1
2010	only	Aug	11	0	0
2011	only	Apr	1	0:01	1
2011	only	Aug	1	0	0
2011	only	Aug	30	0	1
2011	only	Sep	30	0	0
2012	2014	Mar	lastThu	24	1
2012	only	Sep	21	1	0
2013	only	Sep	27	0	0
2014	only	Oct	24	0	0
2015	only	Mar	28	0	1
2015	only	Oct	23	1	0
2016	2018	Mar	Sat<=30	1	1
2016	2018	Oct	Sat<=30	1	0
2019	only	Mar	29	0	1
2019	only	Oct	Sat<=30	0	0
2020	2021	Mar	Sat<=30	0	1
2020	only	Oct	24	1	0
2021	only	Oct	29	1	0
2022	only	Mar	27	0	1
2022	2035	Oct	Sat<=30	2	0
2023	only	Apr	29	2	1
2024	only	Apr	20	2	1
2025	only	Apr	12	2	1
2026	2054	Mar	Sat<=30	2	1
2036	only	Oct	18	2	0
2037	only	Oct	10	2	0
2038	only	Sep	25	2	0
2039	only	Sep	17	2	0
2040	only	Sep	1	2	0
2040	only	Oct	20	2	1
2040	2067	Oct	Sat<=30	2	0
2041	only	Aug	24	2	0
2041	only	Oct	5	2	1
2042	only	Aug	16	2	0
2042	only	Sep	27	2	1
2043	only	Aug	1	2	0
2043	only	Sep	19	2	1
2044	only	Jul	23	2	0
2044	only	Sep	3	2	1
2045	only	Jul	15	2	0
2045	only	Aug	26	2	1
2046	only	Jun	30	2	0
2046	only	Aug	18	2	1
2047	only	Jun	22	2	0
2047	only	Aug	3	2	1
2048	only	Jun	6	2	0
2048	only	Jul	25	2	1
2049	only	May	29	2	0
2049	only	Jul	10	2	1
2050	only	May	21	2	0
2050	only	Jul	2	0	1
2051	only	May	6	0	0
2051	only	Jun	24	2	1
2052	only	Apr	27	2	0
2052	only	Jun	8	2	1
2053	only	Apr	12	2	0
2053	only	May	31	2	1
2054	only	Apr	4	2	0
2054	only	May	23	2	1
2055	only	May	8	2	1
2056	only	Apr	29	2	1
2057	only	Apr	14	2	1
2058	only	Apr	6	2	1
2059	max	Mar	Sat<=30	2	1
2068	only	Oct	20	2	0
2069	only	Oct	12	2	0
2070	only	Oct	4	2	0
2071	only	Sep	19	2	0
2072	only	Sep	10	2	0
2072	only	Oct	22	2	1
2072	max	Oct	Sat<=30	2	0
2073	only	Sep	2	2	0
2073	only	Oct	14	2	1
2074	only	Aug	18	2	0
2074	only	Oct	6	2	1
2075	only	Aug	10	2	0
2075	only	Sep	21	2	1
2076	only	Jul	25	2	0
2076	only	Sep	12	2	1
2077	only	Jul	17	2	0
2077	only	Sep	4	2	1
2078	only	Jul	9	2	0
2078	only	Aug	20	2	1
2079	only	Jun	24	2	0
2079	only	Aug	12	2	1
2080	only	Jun	15	2	0
2080	only	Jul	27	2	1
2081	only	Jun	7	2	0
2081	only	Jul	19	2	1
2082	only	May	23	2	0
2082	only	Jul	11	2	1
2083	only	May	15	2	0
2083	only	Jun	26	2	1
2084	only	Apr	29	2	0
2084	only	Jun	17	2	1
2085	only	Apr	21	2	0
2085	only	Jun	9	2	1
2086	only	Apr	13	2	0
2086	only	May	25	2	1
Para	22
1975	1978	Mar	1	0	0
1975	1988	Oct	1	0	1
1979	1991	Apr	1	0	0
1989	only	Oct	22	0	1
1990	only	Oct	1	0	1
1991	only	Oct	6	0	1
1992	only	Mar	1	0	0
1992	only	Oct	5	0	1
1993	only	Mar	31	0	0
1993	1995	Oct	1	0	1
1994	1995	Feb	lastSun	0	0
1996	only	Mar	1	0	0
1996	2001	Oct	Sun>=1	0	1
1997	only	Feb	lastSun	0	0
1998	2001	Mar	Sun>=1	0	0
2002	2004	Apr	Sun>=1	0	0
2002	2003	Sep	Sun>=1	0	1
2004	2009	Oct	Sun>=15	0	1
2005	2009	Mar	Sun>=8	0	0
2010	2012	Apr	Sun>=8	0	0
2010	2024	Oct	Sun>=1	0	1
2013	2024	Mar	Sun>=22	0	0
Perry	4
1955	only	May	1	0	1
1955	1960	Sep	lastSun	2	0
1956	1963	Apr	lastSun	2	1
1961	1963	Oct	lastSun	2	0
Peru	10
1938	only	Jan	1	0	1
1938	only	Apr	1	0	0
1938	1939	Sep	lastSun	0	1
1939	1940	Mar	Sun>=24	0	0
1986	1987	Jan	1	0	0
1986	1987	Apr	1	0	0
1990	only	Jan	1	0	0
1990	only	Apr	1	0	0
1994	only	Jan	1	0	0
1994	only	Apr	1	0	0
Phil	10
1936	only	Oct	31	24	1
1937	only	Jan	15	24	0
1941	only	Dec	15	24	1
1945	only	Nov	30	24	0
1954	only	Apr	11	24	1
1954	only	Jun	4	24	0
1977	only	Mar	27	24	1
1977	only	Sep	21	24	0
1990	only	May	21	0	1
1990	only	Jul	28	24	0
Pike	4
1955	only	May	1	0	1
1955	1960	Sep	lastSun	2	0
1956	1964	Apr	lastSun	2	1
1961	1964	Oct	lastSun	2	0
Poland	20
1918	1919	Sep	16	2s	0
1919	only	Apr	15	2s	1
1944	only	Apr	3	2s	1
1944	only	Oct	4	2	0
1945	only	Apr	29	0	1
1945	only	Nov	1	0	0
1946	only	Apr	14	0s	1
1946	only	Oct	7	2s	0
1947	only	May	4	2s	1
1947	1949	Oct	Sun>=1	2s	0
1948	only	Apr	18	2s	1
1949	only	Apr	10	2s	1
1957	only	Jun	2	1s	1
1957	1958	Sep	lastSun	1s	0
1958	only	Mar	30	1s	1
1959	only	May	31	1s	1
1959	1961	Oct	Sun>=1	1s	0
1960	only	Apr	3	1s	1
1961	1964	May	lastSun	1s	1
1962	1964	Sep	lastSun	1s	0
Port	45
1916	only	Jun	17	23	1
1916	only	Nov	1	1	0
1917	1921	Mar	1	0	1
1917	1921	Oct	14	24	0
1924	only	Apr	16	23s	1
1924	only	Oct	4	23s	0
1926	only	Apr	17	23s	1
1926	1929	Oct	Sat>=1	23s	0
1927	only	Apr	9	23s	1
1928	only	Apr	14	23s	1
1929	only	Apr	20	23s	1
1931	only	Apr	18	23s	1
1931	1932	Oct	Sat>=1	23s	0
1932	only	Apr	2	23s	1
1934	only	Apr	7	23s	1
1934	1938	Oct	Sat>=1	23s	0
1935	only	Mar	30	23s	1
1936	only	Apr	18	23s	1
1937	only	Apr	3	23s	1
1938	only	Mar	26	23s	1
1939	only	Apr	15	23s	1
1939	only	Nov	18	23s	0
1940	only	Feb	24	23s	1
1940	only	Oct	7	23s	0
1941	only	Apr	5	23s	1
1941	only	Oct	5	23s	0
1942	1945	Mar	Sat>=8	23s	1
1942	only	Apr	25	22s	2
1942	only	Aug	15	22s	1
1942	1945	Oct	Sat>=24	23s	0
1943	only	Apr	17	22s	2
1943	1945	Aug	Sat>=25	22s	1
1944	1945	Apr	Sat>=21	22s	2
1946	only	Apr	Sat>=1	23s	1
1946	only	Oct	Sat>=1	23s	0
1947	1966	Apr	Sun>=1	2s	1
1947	1965	Oct	Sun>=1	2s	0
1976	only	Sep	lastSun	1	0
1977	only	Mar	lastSun	0s	1
1977	only	Sep	lastSun	0s	0
1978	1980	Apr	Sun>=1	1s	1
1978	only	Oct	1	1s	0
1979	1980	Sep	lastSun	1s	0
1981	1986	Mar	lastSun	0s	1
1981	1985	Sep	lastSun	0s	0
PRC	3
1986	only	May	4	2	1
1986	1991	Sep	Sun>=11	2	0
1987	1991	Apr	Sun>=11	2	1
Pulaski	4
1946	1960	Apr	lastSun	2	1
1946	1954	Sep	lastSun	2	0
1955	1956	Oct	lastSun	2	0
1957	1960	Sep	lastSun	2	0
Regina	17
1918	only	Apr	14	2	1
1918	only	Oct	27	2	0
1930	1934	May	Sun>=1	0	1
1930	1934	Oct	Sun>=1	0	0
1937	1941	Apr	Sun>=8	0	1
1937	only	Oct	Sun>=8	0	0
1938	only	Oct	Sun>=1	0	0
1939	1941	Oct	Sun>=8	0	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	lastSun	2	0
1946	only	Apr	Sun>=8	2	1
1946	only	Oct	Sun>=8	2	0
1947	1957	Apr	lastSun	2	1
1947	1957	Sep	lastSun	2	0
1959	only	Apr	lastSun	2	1
1959	only	Oct	lastSun	2	0
ROK	14
1948	only	Jun	1	0	1
1948	only	Sep	12	24	0
1949	only	Apr	3	0	1
1949	1951	Sep	Sat>=7	24	0
1950	only	Apr	1	0	1
1951	only	May	6	0	1
1955	only	May	5	0	1
1955	only	Sep	8	24	0
1956	only	May	20	0	1
1956	only	Sep	29	24	0
1957	1960	May	Sun>=1	0	1
1957	1960	Sep	Sat>=17	24	0
1987	1988	May	Sun>=8	2	1
1987	1988	Oct	Sun>=8	3	0
Romania	9
1932	only	May	21	0s	1
1932	1939	Oct	Sun>=1	0s	0
1933	1939	Apr	Sun>=2	0s	1
1979	only	May	27	0	1
1979	only	Sep	lastSun	0	0
1980	only	Apr	5	23	1
1980	only	Sep	lastSun	1	0
1991	1993	Mar	lastSun	0s	1
1991	1993	Sep	lastSun	0s	0
Russia	16
1917	only	Jul	1	23	1
1917	only	Dec	28	0	0
1918	only	May	31	22	2
1918	only	Sep	16	1	1
1919	only	May	31	23	2
1919	only	Jul	1	0u	1
1919	only	Aug	16	0	0
1921	only	Feb	14	23	1
1921	only	Mar	20	23	2
1921	only	Sep	1	0	1
1921	only	Oct	1	0	0
1981	1984	Apr	1	0	1
1981	1983	Oct	1	0	0
1984	1995	Sep	lastSun	2s	0
1985	2010	Mar	lastSun	2s	1
1996	2010	Oct	lastSun	2s	0
RussiaAsia	5
1981	1984	Apr	1	0	1
1981	1983	Oct	1	0	0
1984	1995	Sep	lastSun	2s	0
1985	2010	Mar	lastSun	2s	1
1996	2010	Oct	lastSun	2s	0
SA	2
1942	1943	Sep	Sun>=15	2	1
1943	1944	Mar	Sun>=15	2	0
Salv	2
1987	1988	May	Sun>=1	0	1
1987	1988	Sep	lastSun	0	0
SanLuis	2
2007	2008	Oct	Sun>=8	0	1
2008	2009	Mar	Sun>=8	0	0
Shang	14
1919	only	Apr	12	24	1
1919	only	Sep	30	24	0
1940	only	Jun	1	0	1
1940	only	Oct	12	24	0
1941	only	Mar	15	0	1
1941	only	Nov	1	24	0
1942	only	Jan	31	0	0
1945	only	Sep	1	24	0
1946	only	May	15	0	1
1946	only	Sep	30	24	0
1947	only	Apr	15	0	1
1947	only	Oct	31	24	0
1948	1949	May	1	0	1
1948	1949	Sep	30	24	0
SL	4
1932	only	Dec	1	0	0:20
1933	1938	Mar	31	24	0
1933	1939	Aug	31	24	0:20
1939	only	May	31	24	0
SovietZone	3
1945	only	May	24	2	2
1945	only	Sep	24	3	1
1945	only	Nov	18	2s	0
Spain	30
1918	only	Apr	15	23	1
1918	1919	Oct	6	24s	0
1919	only	Apr	6	23	1
1924	only	Apr	16	23	1
1924	only	Oct	4	24s	0
1926	only	Apr	17	23	1
1926	1929	Oct	Sat>=1	24s	0
1927	only	Apr	9	23	1
1928	only	Apr	15	0	1
1929	only	Apr	20	23	1
1937	only	Jun	16	23	1
1937	only	Oct	2	24s	0
1938	only	Apr	2	23	1
1938	only	Apr	30	23	2
1938	only	Oct	2	24	1
1939	only	Oct	7	24s	0
1942	only	May	2	23	1
1942	only	Sep	1	1	0
1943	1946	Apr	Sat>=13	23	1
1943	1944	Oct	Sun>=1	1	0
1945	1946	Sep	lastSun	1	0
1949	only	Apr	30	23	1
1949	only	Oct	2	1	0
1974	1975	Apr	Sat>=12	23	1
1974	1975	Oct	Sun>=1	1	0
1976	only	Mar	27	23	1
1976	1977	Sep	lastSun	1	0
1977	only	Apr	2	23	1
1978	only	Apr	2	2s	1
1978	only	Oct	1	2s	0
SpainAfrica	9
1967	only	Jun	3	12	1
1967	only	Oct	1	0	0
1974	only	Jun	24	0	1
1974	only	Sep	1	0	0
1976	1977	May	1	0	1
1976	only	Aug	1	0	0
1977	only	Sep	28	0	0
1978	only	Jun	1	0	1
1978	only	Aug	4	0	0
Starke	5
1947	1961	Apr	lastSun	2	1
1947	1954	Sep	lastSun	2	0
1955	1956	Oct	lastSun	2	0
1957	1958	Sep	lastSun	2	0
1959	1961	Oct	lastSun	2	0
StJohns	19
1917	only	Apr	8	2	1
1917	only	Sep	17	2	0
1919	only	May	5	23	1
1919	only	Aug	12	23	0
1920	1935	May	Sun>=1	23	1
1920	1935	Oct	lastSun	23	0
1936	1941	May	Mon>=9	0	1
1936	1941	Oct	Mon>=2	0	0
1946	1950	May	Sun>=8	2	1
1946	1950	Oct	Sun>=2	2	0
1951	1986	Apr	lastSun	2	1
1951	1959	Sep	lastSun	2	0
1960	1986	Oct	lastSun	0	0
1987	only	Apr	Sun>=1	0:01	1
1987	2006	Oct	lastSun	0:01	0
1988	only	Apr	Sun>=1	0:01	2
1989	2006	Apr	Sun>=1	0:01	1
2007	2011	Mar	Sun>=8	0:01	1
2007	2010	Nov	Sun>=1	0:01	0
Sudan	4
1970	only	May	1	0	1
1970	1985	Oct	15	0	0
1971	only	Apr	30	0	1
1972	1985	Apr	lastSun	0	1
Swift	5
1957	only	Apr	lastSun	2	1
1957	only	Oct	lastSun	2	0
1959	1961	Apr	lastSun	2	1
1959	only	Oct	lastSun	2	0
1960	1961	Sep	lastSun	2	0
Swiss	2
1941	1942	May	Mon>=1	1	1
1941	1942	Oct	Mon>=1	2	0
Syria	41
1920	1923	Apr	Sun>=15	2	1
1920	1923	Oct	Sun>=1	2	0
1962	only	Apr	29	2	1
1962	only	Oct	1	2	0
1963	1965	May	1	2	1
1963	only	Sep	30	2	0
1964	only	Oct	1	2	0
1965	only	Sep	30	2	0
1966	only	Apr	24	2	1
1966	1976	Oct	1	2	0
1967	1978	May	1	2	1
1977	1978	Sep	1	2	0
1983	1984	Apr	9	2	1
1983	1984	Oct	1	2	0
1986	only	Feb	16	2	1
1986	only	Oct	9	2	0
1987	only	Mar	1	2	1
1987	1988	Oct	31	2	0
1988	only	Mar	15	2	1
1989	only	Mar	31	2	1
1989	only	Oct	1	0	0
1990	only	Apr	1	2	1
1990	only	Sep	30	2	0
1991	only	Apr	1	0	1
1991	1992	Oct	1	0	0
1992	only	Apr	8	0	1
1993	only	Mar	26	0	1
1993	only	Sep	25	0	0
1994	1996	Apr	1	0	1
1994	2005	Oct	1	0	0
1997	1998	Mar	lastMon	0	1
1999	2006	Apr	1	0	1
2006	only	Sep	22	0	0
2007	only	Mar	lastFri	0	1
2007	only	Nov	Fri>=1	0	0
2008	only	Apr	Fri>=1	0	1
2008	only	Nov	1	0	0
2009	only	Mar	lastFri	0	1
2009	2022	Oct	lastFri	0	0
2010	2011	Apr	Fri>=1	0	1
2012	2022	Mar	lastFri	0	1
Taiwan	15
1946	only	May	15	0	1
1946	only	Oct	1	0	0
1947	only	Apr	15	0	1
1947	only	Nov	1	0	0
1948	1951	May	1	0	1
1948	1951	Oct	1	0	0
1952	only	Mar	1	0	1
1952	1954	Nov	1	0	0
1953	1959	Apr	1	0	1
1955	1961	Oct	1	0	0
1960	1961	Jun	1	0	1
1974	1975	Apr	1	0	1
1974	1975	Oct	1	0	0
1979	only	Jul	1	0	1
1979	only	Oct	1	0	0
Thule	6
1991	1992	Mar	lastSun	2	1
1991	1992	Sep	lastSun	2	0
1993	2006	Apr	Sun>=1	2	1
1993	2006	Oct	lastSun	2	0
2007	max	Mar	Sun>=8	2	1
2007	max	Nov	Sun>=1	2	0
Tonga	6
1999	only	Oct	7	2s	1
2000	only	Mar	19	2s	0
2000	2001	Nov	Sun>=1	2	1
2001	2002	Jan	lastSun	2	0
2016	only	Nov	Sun>=1	2	1
2017	only	Jan	Sun>=15	3	0
Toronto	18
1919	only	Mar	30	23:30	1
1919	only	Oct	26	0	0
1920	only	May	2	2	1
1920	only	Sep	26	0	0
1921	only	May	15	2	1
1921	only	Sep	15	2	0
1922	1923	May	Sun>=8	2	1
1922	1926	Sep	Sun>=15	2	0
1924	1927	May	Sun>=1	2	1
1927	1937	Sep	Sun>=25	2	0
1928	1937	Apr	Sun>=25	2	1
1938	1940	Apr	lastSun	2	1
1938	1939	Sep	lastSun	2	0
1945	1948	Sep	lastSun	2	0
1946	1973	Apr	lastSun	2	1
1949	1950	Nov	lastSun	2	0
1951	1956	Sep	lastSun	2	0
1957	1973	Oct	lastSun	2	0
Troll	2
2004	max	Oct	lastSun	1u	0
2005	max	Mar	lastSun	1u	2
Tunisia	25
1939	only	Apr	15	23s	1
1939	only	Nov	18	23s	0
1940	only	Feb	25	23s	1
1941	only	Oct	6	0	0
1942	only	Mar	9	0	1
1942	only	Nov	2	3	0
1943	only	Mar	29	2	1
1943	only	Apr	17	2	0
1943	only	Apr	25	2	1
1943	only	Oct	4	2	0
1944	1945	Apr	Mon>=1	2	1
1944	only	Oct	8	0	0
1945	only	Sep	16	0	0
1977	only	Apr	30	0s	1
1977	only	Sep	24	0s	0
1978	only	May	1	0s	1
1978	only	Oct	1	0s	0
1988	only	Jun	1	0s	1
1988	1990	Sep	lastSun	0s	0
1989	only	Mar	26	0s	1
1990	only	May	1	0s	1
2005	only	May	1	0s	1
2005	only	Sep	30	1s	0
2006	2008	Mar	lastSun	2s	1
2006	2008	Oct	lastSun	2s	0
Turkey	45
1916	only	May	1	0	1
1916	only	Oct	1	0	0
1920	only	Mar	28	0	1
1920	only	Oct	25	0	0
1921	only	Apr	3	0	1
1921	only	Oct	3	0	0
1922	only	Mar	26	0	1
1922	only	Oct	8	0	0
1924	only	May	13	0	1
1924	1925	Oct	1	0	0
1925	only	May	1	0	1
1940	only	Jul	1	0	1
1940	only	Oct	6	0	0
1940	only	Dec	1	0	1
1941	only	Sep	21	0	0
1942	only	Apr	1	0	1
1945	only	Oct	8	0	0
1946	only	Jun	1	0	1
1946	only	Oct	1	0	0
1947	1948	Apr	Sun>=16	0	1
1947	1951	Oct	Sun>=2	0	0
1949	only	Apr	10	0	1
1950	only	Apr	16	0	1
1951	only	Apr	22	0	1
1962	only	Jul	15	0	1
1963	only	Oct	30	0	0
1964	only	May	15	0	1
1964	only	Oct	1	0	0
1973	only	Jun	3	1	1
1973	1976	Oct	Sun>=31	2	0
1974	only	Mar	31	2	1
1975	only	Mar	22	2	1
1976	only	Mar	21	2	1
1977	1978	Apr	Sun>=1	2	1
1977	1978	Oct	Sun>=15	2	0
1978	only	Jun	29	0	0
1983	only	Jul	31	2	1
1983	only	Oct	2	2	0
1985	only	Apr	20	1s	1
1985	only	Sep	28	1s	0
1986	1993	Mar	lastSun	1s	1
1986	1995	Sep	lastSun	1s	0
1994	only	Mar	20	1s	1
1995	2006	Mar	lastSun	1s	1
1996	2006	Oct	lastSun	1s	0
Uruguay	48
1923	1925	Oct	1	0	0:30
1924	1926	Apr	1	0	0
1933	1938	Oct	lastSun	0	0:30
1934	1941	Mar	lastSat	24	0
1939	only	Oct	1	0	0:30
1940	only	Oct	27	0	0:30
1941	only	Aug	1	0	0:30
1942	only	Dec	14	0	0:30
1943	only	Mar	14	0	0
1959	only	May	24	0	0:30
1959	only	Nov	15	0	0
1960	only	Jan	17	0	1
1960	only	Mar	6	0	0
1965	only	Apr	4	0	1
1965	only	Sep	26	0	0
1968	only	May	27	0	0:30
1968	only	Dec	1	0	0
1970	only	Apr	25	0	1
1970	only	Jun	14	0	0
1972	only	Apr	23	0	1
1972	only	Jul	16	0	0
1974	only	Jan	13	0	1:30
1974	only	Mar	10	0	0:30
1974	only	Sep	1	0	0
1974	only	Dec	22	0	1
1975	only	Mar	30	0	0
1976	only	Dec	19	0	1
1977	only	Mar	6	0	0
1977	only	Dec	4	0	1
1978	1979	Mar	Sun>=1	0	0
1978	only	Dec	17	0	1
1979	only	Apr	29	0	1
1980	only	Mar	16	0	0
1987	only	Dec	14	0	1
1988	only	Feb	28	0	0
1988	only	Dec	11	0	1
1989	only	Mar	5	0	0
1989	only	Oct	29	0	1
1990	only	Feb	25	0	0
1990	1991	Oct	Sun>=21	0	1
1991	1992	Mar	Sun>=1	0	0
1992	only	Oct	18	0	1
1993	only	Feb	28	0	0
2004	only	Sep	19	0	1
2005	only	Mar	27	2	0
2005	only	Oct	9	2	1
2006	2015	Mar	Sun>=8	2	0
2006	2014	Oct	Sun>=1	2	1
US	13
1918	1919	Mar	lastSun	2	1
1918	1919	Oct	lastSun	2	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	30	2	0
1967	1973	Apr	lastSun	2	1
1967	2006	Oct	lastSun	2	0
1974	only	Jan	6	2	1
1975	only	Feb	lastSun	2	1
1976	1986	Apr	lastSun	2	1
1987	2006	Apr	Sun>=1	2	1
2007	max	Mar	Sun>=8	2	1
2007	max	Nov	Sun>=1	2	0
Vanc	9
1918	only	Apr	14	2	1
1918	only	Oct	27	2	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	30	2	0
1946	1986	Apr	lastSun	0	1
1946	only	Sep	29	0	0
1947	1961	Sep	lastSun	2	0
1962	2006	Oct	lastSun	0	0
Vanuatu	6
1973	only	Dec	22	12u	1
1974	only	Mar	30	12u	0
1983	1991	Sep	Sat>=22	24	1
1984	1991	Mar	Sat>=22	24	0
1992	1993	Jan	Sat>=22	24	0
1992	only	Oct	Sat>=22	24	1
Vincennes	9
1946	only	Apr	lastSun	2	1
1946	only	Sep	lastSun	2	0
1953	1954	Apr	lastSun	2	1
1953	1959	Sep	lastSun	2	0
1955	only	May	1	0	1
1956	1963	Apr	lastSun	2	1
1960	only	Oct	lastSun	2	0
1961	only	Sep	lastSun	2	0
1962	1963	Oct	lastSun	2	0
W-Eur	6
1977	1980	Apr	Sun>=1	1s	1
1977	only	Sep	lastSun	1s	0
1978	only	Oct	1	1s	0
1979	1995	Sep	lastSun	1s	0
1981	max	Mar	lastSun	1s	1
1996	max	Oct	lastSun	1s	0
Winn	24
1916	only	Apr	23	0	1
1916	only	Sep	17	0	0
1918	only	Apr	14	2	1
1918	only	Oct	27	2	0
1937	only	May	16	2	1
1937	only	Sep	26	2	0
1942	only	Feb	9	2	1
1945	only	Aug	14	23u	1
1945	only	Sep	lastSun	0	0
1946	only	May	12	0	1
1946	only	Oct	13	0	0
1947	1949	Apr	lastSun	0	1
1947	1949	Sep	lastSun	0	0
1950	only	May	1	0	1
1950	only	Sep	30	2	0
1951	1960	Apr	lastSun	2	1
1951	1958	Sep	lastSun	2	0
1959	only	Oct	lastSun	2	0
1960	only	Sep	lastSun	2	0
1963	only	Apr	lastSun	2	1
1963	only	Sep	22	2	0
1966	1986	Apr	lastSun	2s	1
1966	2005	Oct	lastSun	2s	0
1987	2005	Apr	Sun>=1	2s	1
WS	5
2010	only	Sep	lastSun	0	1
2011	only	Apr	Sat>=1	4	0
2011	only	Sep	lastSat	3	1
2012	2021	Apr	Sun>=1	4	0
2012	2020	Sep	lastSun	3	1
Yukon	2
1965	only	Apr	lastSun	0	2
1965	only	Oct	lastSun	2	0
Zion	85
1940	only	May	31	24u	1
1940	only	Sep	30	24u	0
1940	only	Nov	16	24u	1
1942	1946	Oct	31	24u	0
1943	1944	Mar	31	24u	1
1945	1946	Apr	15	24u	1
1948	only	May	22	24u	2
1948	only	Aug	31	24u	1
1948	1949	Oct	31	24u	0
1949	only	Apr	30	24u	1
1950	only	Apr	15	24u	1
1950	only	Sep	14	24u	0
1951	only	Mar	31	24u	1
1951	only	Nov	10	24u	0
1952	only	Apr	19	24u	1
1952	only	Oct	18	24u	0
1953	only	Apr	11	24u	1
1953	only	Sep	12	24u	0
1954	only	Jun	12	24u	1
1954	only	Sep	11	24u	0
1955	only	Jun	11	24u	1
1955	only	Sep	10	24u	0
1956	only	Jun	2	24u	1
1956	only	Sep	29	24u	0
1957	only	Apr	27	24u	1
1957	only	Sep	21	24u	0
1974	only	Jul	6	24	1
1974	only	Oct	12	24	0
1975	only	Apr	19	24	1
1975	only	Aug	30	24	0
1980	only	Aug	2	24s	1
1980	only	Sep	13	24s	0
1984	only	May	5	24s	1
1984	only	Aug	25	24s	0
1985	only	Apr	13	24	1
1985	only	Aug	31	24	0
1986	only	May	17	24	1
1986	only	Sep	6	24	0
1987	only	Apr	14	24	1
1987	only	Sep	12	24	0
1988	only	Apr	9	24	1
1988	only	Sep	3	24	0
1989	only	Apr	29	24	1
1989	only	Sep	2	24	0
1990	only	Mar	24	24	1
1990	only	Aug	25	24	0
1991	only	Mar	23	24	1
1991	only	Aug	31	24	0
1992	only	Mar	28	24	1
1992	only	Sep	5	24	0
1993	only	Apr	2	0	1
1993	only	Sep	5	0	0
1994	only	Apr	1	0	1
1994	only	Aug	28	0	0
1995	only	Mar	31	0	1
1995	only	Sep	3	0	0
1996	only	Mar	14	24	1
1996	only	Sep	15	24	0
1997	only	Mar	20	24	1
1997	only	Sep	13	24	0
1998	only	Mar	20	0	1
1998	only	Sep	6	0	0
1999	only	Apr	2	2	1
1999	only	Sep	3	2	0
2000	only	Apr	14	2	1
2000	only	Oct	6	1	0
2001	only	Apr	9	1	1
2001	only	Sep	24	1	0
2002	only	Mar	29	1	1
2002	only	Oct	7	1	0
2003	only	Mar	28	1	1
2003	only	Oct	3	1	0
2004	only	Apr	7	1	1
2004	only	Sep	22	1	0
2005	2012	Apr	Fri<=1	2	1
2005	only	Oct	9	2	0
2006	only	Oct	1	2	0
2007	only	Sep	16	2	0
2008	only	Oct	5	2	0
2009	only	Sep	27	2	0
2010	only	Sep	12	2	0
2011	only	Oct	2	2	0
2012	only	Sep	23	2	0
2013	max	Mar	Fri>=23	2	1
2013	max	Oct	lastSun	2	0

; Part 2: Time zone changes within each named time zone
; Column 1: Time zone offset (hours before UTC)
; Column 2: Rule set to apply for Daylight Saving (- = no rule, number = that Daylight offset always)
; Column 3: Year this time zone offset changes (absent = lasts forever)
; Column 4: Month this time zone offset changes (absent = Jan 1 at 0:00)
; Column 5: Day this time zone offset changes (absent = 1st of month)
; Column 6: Hour this time zone offset changes (absent = 0:00, default = local time, s = standard time, u = UTC)

-YY2 414 2293
Africa/Abidjan	2
0:16:08	-	1912
0	-
Africa/Accra	4
0:00:52	-	1915	Nov	2
0	Ghana	1942	Feb	8
-0:30	-	1946	Jan	6
0	Ghana
Africa/Addis_Ababa	3
-2:34:48	-	1870
-2:35:20	-	1936	May	5
-3	-
Africa/Algiers	10
-0:12:12	-	1891	Mar	16
-0:09:21	-	1911	Mar	11
0	Algeria	1940	Feb	25	2
-1	Algeria	1946	Oct	7
0	-	1956	Jan	29
-1	-	1963	Apr	14
0	Algeria	1977	Oct	21
-1	Algeria	1979	Oct	26
0	Algeria	1981	May
-1	-
Africa/Asmara	4
-2:35:32	-	1870
-2:35:32	-	1890
-2:35:20	-	1936	May	5
-3	-
Africa/Bamako	4
0:32	-	1912
0	-	1934	Feb	26
1	-	1960	Jun	20
0	-
Africa/Bangui	2
-1:14:20	-	1912
-1	-
Africa/Banjul	4
1:06:36	-	1912
1:06:36	-	1933	Apr
1	-	1942	Feb
0	-
Africa/Bissau	3
1:02:20	-	1912	Jan	1	1u
1	-	1975
0	-
Africa/Blantyre	4
-2:20	-	1911	Jul	24
-2:21:10	-	1914	Jun	30
-2:21	-	1925	Jul
-2	-
Africa/Brazzaville	2
-1:01:08	-	1912
-1	-
Africa/Bujumbura	2
-1:57:28	-	1890
-2	-
Africa/Cairo	2
-2:05:09	-	1900	Oct
-2	Egypt
Africa/Casablanca	5
0:30:20	-	1913	Oct	26
0	Morocco	1984	Mar	16
-1	-	1986
0	Morocco	2018	Oct	28	3
-1	Morocco
Africa/Ceuta	9
0:21:16	-	1901	Jan	1	0u
0	-	1918	May	6	23
0	1	1918	Oct	7	23
0	-	1924
0	Spain	1929
0	-	1967
0	SpainAfrica	1984	Mar	16
-1	-	1986
-1	EU
Africa/Conakry	4
0:54:52	-	1912
0	-	1934	Feb	26
1	-	1960
0	-
Africa/Dakar	3
1:09:44	-	1912
1	-	1941	Jun
0	-
Africa/Dar_es_Salaam	4
-2:37:08	-	1931
-3	-	1948
-2:45	-	1961
-3	-
Africa/Djibouti	2
-2:52:36	-	1911	Jul
-3	-
Africa/Douala	2
-0:38:48	-	1912
-1	-
Africa/El_Aaiun	4
0:52:48	-	1934
1	-	1976	Apr	14
0	Morocco	2018	Oct	28	3
-1	Morocco
Africa/Freetown	5
0:53	-	1882
0:53	-	1913	Jul
1	SL	1939	Sep	5
1	-	1941	Dec	6	24
0	-
Africa/Gaborone	5
-1:43:40	-	1885
-1:30	-	1903	Mar
-2	-	1943	Sep	19	2
-2	1	1944	Mar	19	2
-2	-
Africa/Harare	2
-2:04:12	-	1903	Mar
-2	-
Africa/Johannesburg	3
-1:52	-	1892	Feb	8
-1:30	-	1903	Mar
-2	SA
Africa/Juba	4
-2:06:28	-	1931
-2	Sudan	2000	Jan	15	12
-3	-	2021	Feb
-2	-
Africa/Kampala	5
-2:09:40	-	1928	Jul
-3	-	1930
-2:30	-	1948
-2:45	-	1957
-3	-
Africa/Khartoum	4
-2:10:08	-	1931
-2	Sudan	2000	Jan	15	12
-3	-	2017	Nov
-2	-
Africa/Kigali	2
-2:00:16	-	1935	Jun
-2	-
Africa/Kinshasa	2
-1:01:12	-	1897	Nov	9
-1	-
Africa/Lagos	5
-0:13:35	-	1905	Jul
0	-	1908	Jul
-0:13:35	-	1914
-0:30	-	1919	Sep
-1	-
Africa/Libreville	2
-0:37:48	-	1912
-1	-
Africa/Lome	2
-0:04:52	-	1893
0	-
Africa/Luanda	3
-0:52:56	-	1892
-0:52:04	-	1911	Dec	31	23u
-1	-
Africa/Lubumbashi	3
-1:49:52	-	1897	Nov	9
-1	-	1920	Apr	25
-2	-
Africa/Lusaka	2
-1:53:08	-	1903	Mar
-2	-
Africa/Malabo	3
-0:35:08	-	1912
0	-	1963	Dec	15
-1	-
Africa/Maputo	2
-2:10:18	-	1909
-2	-
Africa/Maseru	4
-1:50	-	1903	Mar
-2	-	1943	Sep	19	2
-2	1	1944	Mar	19	2
-2	-
Africa/Mbabane	2
-2:04:24	-	1903	Mar
-2	-
Africa/Mogadishu	4
-3:01:28	-	1893	Nov
-3	-	1931
-2:30	-	1957
-3	-
Africa/Monrovia	4
0:43:08	-	1882
0:43:08	-	1919	Mar
0:44:30	-	1972	Jan	7
0	-
Africa/Nairobi	6
-2:27:16	-	1908	May
-2:30	-	1928	Jun	30	24
-3	-	1930	Jan	4	24
-2:30	-	1936	Dec	31	24
-2:45	-	1942	Jul	31	24
-3	-
Africa/Ndjamena	4
-1:00:12	-	1912
-1	-	1979	Oct	14
-1	1	1980	Mar	8
-1	-
Africa/Niamey	4
-0:08:28	-	1912
1	-	1934	Feb	26
0	-	1960
-1	-
Africa/Nouakchott	4
1:03:48	-	1912
0	-	1934	Feb	26
1	-	1960	Nov	28
0	-
Africa/Ouagadougou	2
0:06:04	-	1912
0	-
Africa/Porto-Novo	3
-0:10:28	-	1912
0	-	1934	Feb	26
-1	-
Africa/Sao_Tome	5
-0:26:56	-	1884
0:36:45	-	1912	Jan	1	0u
0	-	2018	Jan	1	1
-1	-	2019	Jan	1	2
0	-
Africa/Tripoli	9
-0:52:44	-	1920
-1	Libya	1959
-2	-	1982
-1	Libya	1990	May	4
-2	-	1996	Sep	30
-1	Libya	1997	Oct	4
-2	-	2012	Nov	10	2
-1	Libya	2013	Oct	25	2
-2	-
Africa/Tunis	3
-0:40:44	-	1881	May	12
-0:09:21	-	1911	Mar	11
-1	Tunisia
Africa/Windhoek	6
-1:08:24	-	1892	Feb	8
-1:30	-	1903	Mar
-2	-	1942	Sep	20	2
-2	1	1943	Mar	21	2
-2	-	1990	Mar	21
-2	Namibia
America/Adak	9
-12:13:22	-	1867	Oct	19	12:44:35
11:46:38	-	1900	Aug	20	12
11	-	1942
11	US	1946
11	-	1967	Apr
11	-	1969
11	US	1983	Oct	30	2
10	US	1983	Nov	30
10	US
America/Anchorage	8
-14:00:24	-	1867	Oct	19	14:31:37
9:59:36	-	1900	Aug	20	12
10	-	1942
10	US	1967	Apr
10	-	1969
10	US	1983	Oct	30	2
9	US	1983	Nov	30
9	US
America/Anguilla	2
4:12:16	-	1912	Mar	2
4	-
America/Antigua	3
4:07:12	-	1912	Mar	2
5	-	1951
4	-
America/Araguaina	7
3:12:48	-	1914
3	Brazil	1990	Sep	17
3	-	1995	Sep	14
3	Brazil	2003	Sep	24
3	-	2012	Oct	21
3	Brazil	2013	Sep
3	-
America/Argentina/Buenos_Aires	7
3:53:48	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	Arg
America/Argentina/Catamarca	12
4:23:08	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar	3
4	-	1991	Oct	20
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	Jun
4	-	2004	Jun	20
3	Arg	2008	Oct	18
3	-
America/Argentina/Cordoba	9
4:16:48	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar	3
4	-	1991	Oct	20
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	Arg
America/Argentina/Jujuy	13
4:21:12	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1990	Mar	4
4	-	1990	Oct	28
4	1	1991	Mar	17
4	-	1991	Oct	6
3	1	1992
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	Arg	2008	Oct	18
3	-
America/Argentina/La_Rioja	12
4:27:24	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar
4	-	1991	May	7
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	Jun
4	-	2004	Jun	20
3	Arg	2008	Oct	18
3	-
America/Argentina/Mendoza	16
4:35:16	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1990	Mar	4
4	-	1990	Oct	15
4	1	1991	Mar
4	-	1991	Oct	15
4	1	1992	Mar
4	-	1992	Oct	18
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	May	23
4	-	2004	Sep	26
3	Arg	2008	Oct	18
3	-
America/Argentina/Rio_Gallegos	10
4:36:52	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	Jun
4	-	2004	Jun	20
3	Arg	2008	Oct	18
3	-
America/Argentina/Salta	10
4:21:40	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar	3
4	-	1991	Oct	20
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	Arg	2008	Oct	18
3	-
America/Argentina/San_Juan	12
4:34:04	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar
4	-	1991	May	7
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	May	31
4	-	2004	Jul	25
3	Arg	2008	Oct	18
3	-
America/Argentina/San_Luis	16
4:25:24	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1990
3	1	1990	Mar	14
4	-	1990	Oct	15
4	1	1991	Mar
4	-	1991	Jun
3	-	1999	Oct	3
4	1	2000	Mar	3
3	-	2004	May	31
4	-	2004	Jul	25
3	Arg	2008	Jan	21
4	SanLuis	2009	Oct	11
3	-
America/Argentina/Tucuman	11
4:20:52	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1991	Mar	3
4	-	1991	Oct	20
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	Jun
4	-	2004	Jun	13
3	Arg
America/Argentina/Ushuaia	10
4:33:12	-	1894	Oct	31
4:16:48	-	1920	May
4	-	1930	Dec
4	Arg	1969	Oct	5
3	Arg	1999	Oct	3
4	Arg	2000	Mar	3
3	-	2004	May	30
4	-	2004	Jun	20
3	Arg	2008	Oct	18
3	-
America/Aruba	3
4:40:24	-	1912	Feb	12
4:30	-	1965
4	-
America/Asuncion	6
3:50:40	-	1890
3:50:40	-	1931	Oct	10
4	-	1972	Oct
3	-	1974	Apr
4	Para	2024	Oct	15
3	-
America/Atikokan	5
6:06:28	-	1895
6	Canada	1940	Sep	29
6	1	1942	Feb	9	2s
6	Canada	1945	Sep	30	2
5	-
America/Bahia	5
2:34:04	-	1914
3	Brazil	2003	Sep	24
3	-	2011	Oct	16
3	Brazil	2012	Oct	21
3	-
America/Bahia_Banderas	8
7:01	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1942	Apr	24
7	-	1970
7	Mexico	2010	Apr	4	2
6	Mexico
America/Barbados	4
3:58:29	-	1911	Aug	28
4	Barb	1944
4	Barb	1945
4	Barb
America/Belem	3
3:13:56	-	1914
3	Brazil	1988	Sep	12
3	-
America/Belize	2
5:52:48	-	1912	Apr
6	Belize
America/Blanc-Sablon	3
3:48:28	-	1884
4	Canada	1970
4	-
America/Boa_Vista	5
4:02:40	-	1914
4	Brazil	1988	Sep	12
4	-	1999	Sep	30
4	Brazil	2000	Oct	15
4	-
America/Bogota	3
4:56:16	-	1884	Mar	13
4:56:16	-	1914	Nov	23
5	CO
America/Boise	5
7:44:49	-	1883	Nov	18	20u
8	US	1923	May	13	2
7	US	1974
7	-	1974	Feb	3	2
7	US
America/Cambridge_Bay	6
0	-	1920
7	NT_YK	1999	Oct	31	2
6	Canada	2000	Oct	29	2
5	-	2000	Nov	5
6	-	2001	Apr	1	3
7	Canada
America/Campo_Grande	2
3:38:28	-	1914
4	Brazil
America/Cancun	7
5:47:04	-	1922	Jan	1	6u
6	-	1981	Dec	26	2
5	-	1983	Jan	4
6	Mexico	1997	Oct	26	2
5	Mexico	1998	Aug	2	2
6	Mexico	2015	Feb	1	2
5	-
America/Caracas	6
4:27:44	-	1890
4:27:40	-	1912	Feb	12
4:30	-	1965
4	-	2007	Dec	9	3
4:30	-	2016	May	1	2:30
4	-
America/Cayenne	3
3:29:20	-	1911	Jul
4	-	1967	Oct
3	-
America/Cayman	3
5:25:32	-	1890
5:07:10	-	1912	Feb
5	-
America/Chicago	8
5:50:36	-	1883	Nov	18	18u
6	US	1920
6	Chicago	1936	Mar	1	2
5	-	1936	Nov	15	2
6	Chicago	1942
6	US	1946
6	Chicago	1967
6	US
America/Chihuahua	9
7:04:20	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1996
6	Mexico	1998
6	-	1998	Apr	0	3
7	Mexico	2022	Oct	30	2
6	-
America/Costa_Rica	3
5:36:13	-	1890
5:36:13	-	1921	Jan	15
6	CR
America/Creston	4
7:46:04	-	1884
7	-	1916	Oct
8	-	1918	Jun	2
7	-
America/Cuiaba	4
3:44:20	-	1914
4	Brazil	2003	Sep	24
4	-	2004	Oct
4	Brazil
America/Curacao	3
4:35:47	-	1912	Feb	12
4:30	-	1965
4	-
America/Danmarkshavn	4
1:14:40	-	1916	Jul	28
3	-	1980	Apr	6	2
3	EU	1996
0	-
America/Dawson	6
9:17:40	-	1900	Aug	20
9	NT_YK	1965
9	Yukon	1973	Oct	28
8	-	1980
8	Canada	2020	Nov
7	-
America/Dawson_Creek	4
8:00:56	-	1884
8	Canada	1947
8	Vanc	1972	Aug	30	2
7	-
America/Denver	6
6:59:56	-	1883	Nov	18	19u
7	US	1920
7	Denver	1942
7	US	1946
7	Denver	1967
7	US
America/Detroit	10
5:32:11	-	1905
6	-	1915	May	15	2
5	-	1942
5	US	1946
5	Detroit	1967	Jun	14	0:01
5	US	1969
5	-	1973
5	US	1975
5	-	1975	Apr	27	2
5	US
America/Dominica	2
4:05:36	-	1911	Jul	1	0:01
4	-
America/Edmonton	3
7:33:52	-	1906	Sep
7	Edm	1987
7	Canada
America/Eirunepe	7
4:39:28	-	1914
5	Brazil	1988	Sep	12
5	-	1993	Sep	28
5	Brazil	1994	Sep	22
5	-	2008	Jun	24
4	-	2013	Nov	10
5	-
America/El_Salvador	2
5:56:48	-	1921
6	Salv
America/Fort_Nelson	6
8:10:47	-	1884
8	Vanc	1946
8	-	1947
8	Vanc	1987
8	Canada	2015	Mar	8	2
7	-
America/Fortaleza	7
2:34	-	1914
3	Brazil	1990	Sep	17
3	-	1999	Sep	30
3	Brazil	2000	Oct	22
3	-	2001	Sep	13
3	Brazil	2002	Oct
3	-
America/Glace_Bay	6
3:59:48	-	1902	Jun	15
4	Canada	1953
4	Halifax	1954
4	-	1972
4	Halifax	1974
4	Canada
America/Godthab	3
3:26:56	-	1916	Jul	28
3	-	1980	Apr	6	2
3	EU
America/Goose_Bay	10
4:01:40	-	1884
3:30:52	-	1918
3:30:52	Canada	1919
3:30:52	-	1935	Mar	30
3:30	-	1936
3:30	StJohns	1942	May	11
3:30	Canada	1946
3:30	StJohns	1966	Mar	15	2
4	StJohns	2011	Nov
4	Canada
America/Grand_Turk	6
4:44:32	-	1890
5:07:10	-	1912	Feb
5	-	1979
5	US	2015	Mar	8	2
4	-	2018	Mar	11	3
5	US
America/Grenada	2
4:07	-	1911	Jul
4	-
America/Guadeloupe	2
4:06:08	-	1911	Jun	8
4	-
America/Guatemala	2
6:02:04	-	1918	Oct	5
6	Guat
America/Guayaquil	3
5:19:20	-	1890
5:14	-	1931
5	Ecuador
America/Guyana	5
3:52:39	-	1911	Aug
4	-	1915	Mar
3:45	-	1975	Aug
3	-	1992	Mar	29	1
4	-
America/Halifax	7
4:14:24	-	1902	Jun	15
4	Halifax	1918
4	Canada	1919
4	Halifax	1942	Feb	9	2s
4	Canada	1946
4	Halifax	1974
4	Canada
America/Havana	3
5:29:28	-	1890
5:29:36	-	1925	Jul	19	12
5	Cuba
America/Hermosillo	8
7:23:52	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1942	Apr	24
7	-	1996
7	Mexico	1999
7	-
America/Indiana/Indianapolis	11
5:44:38	-	1883	Nov	18	18u
6	US	1920
6	Indianapolis	1942
6	US	1946
6	Indianapolis	1955	Apr	24	2
5	-	1957	Sep	29	2
6	-	1958	Apr	27	2
5	-	1969
5	US	1971
5	-	2006
5	US
America/Indiana/Knox	7
5:46:30	-	1883	Nov	18	18u
6	US	1947
6	Starke	1962	Apr	29	2
5	-	1963	Oct	27	2
6	US	1991	Oct	27	2
5	-	2006	Apr	2	2
6	US
America/Indiana/Marengo	9
5:45:23	-	1883	Nov	18	18u
6	US	1951
6	Marengo	1961	Apr	30	2
5	-	1969
5	US	1974	Jan	6	2
6	1	1974	Oct	27	2
5	US	1976
5	-	2006
5	US
America/Indiana/Petersburg	8
5:49:07	-	1883	Nov	18	18u
6	US	1955
6	Pike	1965	Apr	25	2
5	-	1966	Oct	30	2
6	US	1977	Oct	30	2
5	-	2006	Apr	2	2
6	US	2007	Nov	4	2
5	US
America/Indiana/Tell_City	8
5:47:03	-	1883	Nov	18	18u
6	US	1946
6	Perry	1964	Apr	26	2
5	-	1967	Oct	29	2
6	US	1969	Apr	27	2
5	US	1971
5	-	2006	Apr	2	2
6	US
America/Indiana/Vevay	6
5:40:16	-	1883	Nov	18	18u
6	US	1954	Apr	25	2
5	-	1969
5	US	1973
5	-	2006
5	US
America/Indiana/Vincennes	8
5:50:07	-	1883	Nov	18	18u
6	US	1946
6	Vincennes	1964	Apr	26	2
5	-	1969
5	US	1971
5	-	2006	Apr	2	2
6	US	2007	Nov	4	2
5	US
America/Indiana/Winamac	8
5:46:25	-	1883	Nov	18	18u
6	US	1946
6	Pulaski	1961	Apr	30	2
5	-	1969
5	US	1971
5	-	2006	Apr	2	2
6	US	2007	Mar	11	2
5	US
America/Inuvik	4
0	-	1953
8	NT_YK	1979	Apr	0	2
7	NT_YK	1980
7	Canada
America/Iqaluit	4
0	-	1942	Aug
5	NT_YK	1999	Oct	31	2
6	Canada	2000	Oct	29	2
5	Canada
America/Jamaica	5
5:07:10	-	1890
5:07:10	-	1912	Feb
5	-	1974
5	US	1984
5	-
America/Juneau	10
-15:02:19	-	1867	Oct	19	15:33:32
8:57:41	-	1900	Aug	20	12
8	-	1942
8	US	1946
8	-	1969
8	US	1980	Apr	27	2
9	US	1980	Oct	26	2
8	US	1983	Oct	30	2
9	US	1983	Nov	30
9	US
America/Kentucky/Louisville	9
5:43:02	-	1883	Nov	18	18u
6	US	1921
6	Louisville	1942
6	US	1946
6	Louisville	1961	Jul	23	2
5	-	1968
5	US	1974	Jan	6	2
6	1	1974	Oct	27	2
5	US
America/Kentucky/Monticello	5
5:39:24	-	1883	Nov	18	18u
6	US	1946
6	-	1968
6	US	2000	Oct	29	2
5	US
America/La_Paz	4
4:32:36	-	1890
4:32:36	-	1931	Oct	15
4:32:36	1	1932	Mar	21
4	-
America/Lima	3
5:08:12	-	1890
5:08:36	-	1908	Jul	28
5	Peru
America/Los_Angeles	4
7:52:58	-	1883	Nov	18	20u
8	US	1946
8	CA	1967
8	US
America/Maceio	9
2:22:52	-	1914
3	Brazil	1990	Sep	17
3	-	1995	Oct	13
3	Brazil	1996	Sep	4
3	-	1999	Sep	30
3	Brazil	2000	Oct	22
3	-	2001	Sep	13
3	Brazil	2002	Oct
3	-
America/Managua	9
5:45:08	-	1890
5:45:12	-	1934	Jun	23
6	-	1973	May
5	-	1975	Feb	16
6	Nic	1992	Jan	1	4
5	-	1992	Sep	24
6	-	1993
5	-	1997
6	Nic
America/Manaus	5
4:00:04	-	1914
4	Brazil	1988	Sep	12
4	-	1993	Sep	28
4	Brazil	1994	Sep	22
4	-
America/Martinique	5
4:04:20	-	1890
4:04:20	-	1911	May
4	-	1980	Apr	6
4	1	1980	Sep	28
4	-
America/Matamoros	5
6:30	-	1922	Jan	1	6u
6	-	1988
6	US	1989
6	Mexico	2010
6	US
America/Mazatlan	7
7:05:40	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1942	Apr	24
7	-	1970
7	Mexico
America/Menominee	5
5:50:27	-	1885	Sep	18	12
6	US	1946
6	Menominee	1969	Apr	27	2
5	-	1973	Apr	29	2
6	US
America/Merida	4
5:58:28	-	1922	Jan	1	6u
6	-	1981	Dec	26	2
5	-	1982	Nov	2	2
6	Mexico
America/Metlakatla	10
-15:13:42	-	1867	Oct	19	15:44:55
8:46:18	-	1900	Aug	20	12
8	-	1942
8	US	1946
8	-	1969
8	US	1983	Oct	30	2
8	-	2015	Nov	1	2
9	US	2018	Nov	4	2
8	-	2019	Jan	20	2
9	US
America/Mexico_City	7
6:36:36	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	Mexico	2001	Sep	30	2
6	-	2002	Feb	20
6	Mexico
America/Miquelon	4
3:44:40	-	1911	Jun	15
4	-	1980	May
3	-	1987
3	Canada
America/Moncton	9
4:19:08	-	1883	Dec	9
5	-	1902	Jun	15
4	Canada	1933
4	Moncton	1942
4	Canada	1946
4	Moncton	1973
4	Canada	1993
4	Moncton	2007
4	Canada
America/Monterrey	7
6:41:16	-	1922	Jan	1	6u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1988
6	US	1989
6	Mexico
America/Montevideo	11
3:44:51	-	1908	Jun	10
3:44:51	-	1920	May
4	-	1923	Oct
3:30	Uruguay	1942	Dec	14
3	Uruguay	1960
3	Uruguay	1968
3	Uruguay	1970
3	Uruguay	1974
3	Uruguay	1974	Mar	10
3	Uruguay	1974	Dec	22
3	Uruguay
America/Montserrat	2
4:08:52	-	1911	Jul	1	0:01
4	-
America/Nassau	3
5:09:30	-	1912	Mar	2
5	Bahamas	1976
5	US
America/New_York	6
4:56:02	-	1883	Nov	18	17u
5	US	1920
5	NYC	1942
5	US	1946
5	NYC	1967
5	US
America/Nipigon	4
5:53:04	-	1895
5	Canada	1940	Sep	29
5	1	1942	Feb	9	2s
5	Canada
America/Nome	9
-12:58:22	-	1867	Oct	19	13:29:35
11:01:38	-	1900	Aug	20	12
11	-	1942
11	US	1946
11	-	1967	Apr
11	-	1969
11	US	1983	Oct	30	2
9	US	1983	Nov	30
9	US
America/Noronha	7
2:09:40	-	1914
2	Brazil	1990	Sep	17
2	-	1999	Sep	30
2	Brazil	2000	Oct	15
2	-	2001	Sep	13
2	Brazil	2002	Oct
2	-
America/North_Dakota/Beulah	3
6:47:07	-	1883	Nov	18	19u
7	US	2010	Nov	7	2
6	US
America/North_Dakota/Center	3
6:45:12	-	1883	Nov	18	19u
7	US	1992	Oct	25	2
6	US
America/North_Dakota/New_Salem	3
6:45:39	-	1883	Nov	18	19u
7	US	2003	Oct	26	2
6	US
America/Ojinaga	11
6:57:40	-	1922	Jan	1	7u
7	-	1927	Jun	10
6	-	1930	Nov	15
7	Mexico	1932	Apr
6	-	1996
6	Mexico	1998
6	-	1998	Apr	0	3
7	Mexico	2010
7	US	2022	Oct	30	2
6	-	2022	Nov	30
6	US
America/Panama	3
5:18:08	-	1890
5:19:36	-	1908	Apr	22
5	-
America/Pangnirtung	4
0	-	1921
5	NT_YK	1999	Oct	31	2
6	Canada	2000	Oct	29	2
5	Canada
America/Paramaribo	5
3:40:40	-	1911
3:40:52	-	1935
3:40:36	-	1945	Oct
3:30	-	1984	Oct
3	-
America/Phoenix	7
7:28:18	-	1883	Nov	18	19u
7	US	1944	Jan	1	0:01
7	-	1944	Apr	1	0:01
7	US	1944	Oct	1	0:01
7	-	1967
7	US	1968	Mar	21
7	-
America/Port_of_Spain	2
4:06:04	-	1912	Mar	2
4	-
America/Port-au-Prince	3
4:49:20	-	1890
4:49	-	1917	Jan	24	12
5	Haiti
America/Porto_Velho	3
4:15:36	-	1914
4	Brazil	1988	Sep	12
4	-
America/Puerto_Rico	4
4:24:25	-	1899	Mar	28	12
4	-	1942	May	3
4	US	1946
4	-
America/Punta_Arenas	14
4:43:40	-	1890
4:42:45	-	1910	Jan	10
5	-	1916	Jul
4:42:45	-	1918	Sep	10
4	-	1919	Jul
4:42:45	-	1927	Sep
5	Chile	1932	Sep
4	-	1942	Jun
5	-	1942	Aug
4	-	1946	Aug	28	24
5	1	1947	Mar	31	24
5	-	1947	May	21	23
4	Chile	2016	Dec	4
3	-
America/Rainy_River	4
6:18:16	-	1895
6	Canada	1940	Sep	29
6	1	1942	Feb	9	2s
6	Canada
America/Rankin_Inlet	4
0	-	1957
6	NT_YK	2000	Oct	29	2
5	-	2001	Apr	1	3
6	Canada
America/Recife	7
2:19:36	-	1914
3	Brazil	1990	Sep	17
3	-	1999	Sep	30
3	Brazil	2000	Oct	15
3	-	2001	Sep	13
3	Brazil	2002	Oct
3	-
America/Regina	3
6:58:36	-	1905	Sep
7	Regina	1960	Apr	0	2
6	-
America/Resolute	6
0	-	1947	Aug	31
6	NT_YK	2000	Oct	29	2
5	-	2001	Apr	1	3
6	Canada	2006	Oct	29	2
5	-	2007	Mar	11	3
6	Canada
America/Rio_Branco	5
4:31:12	-	1914
5	Brazil	1988	Sep	12
5	-	2008	Jun	24
4	-	2013	Nov	10
5	-
America/Santarem	4
3:38:48	-	1914
4	Brazil	1988	Sep	12
4	-	2008	Jun	24
3	-
America/Santiago	14
4:42:45	-	1890
4:42:45	-	1910	Jan	10
5	-	1916	Jul
4:42:45	-	1918	Sep	10
4	-	1919	Jul
4:42:45	-	1927	Sep
5	Chile	1932	Sep
4	-	1942	Jun
5	-	1942	Aug
4	-	1946	Jul	14	24
4	1	1946	Aug	28	24
5	1	1947	Mar	31	24
5	-	1947	May	21	23
4	Chile
America/Santo_Domingo	6
4:39:36	-	1890
4:40	-	1933	Apr	1	12
5	DR	1974	Oct	27
4	-	2000	Oct	29	2
5	US	2000	Dec	3	1
4	-
America/Sao_Paulo	4
3:06:28	-	1914
3	Brazil	1963	Oct	23
3	1	1964
3	Brazil
America/Scoresbysund	5
1:27:52	-	1916	Jul	28
2	-	1980	Apr	6	2
2	C-Eur	1981	Mar	29
1	EU	2024	Mar	31
2	EU
America/Sitka	8
-14:58:47	-	1867	Oct	19	15:30
9:01:13	-	1900	Aug	20	12
8	-	1942
8	US	1946
8	-	1969
8	US	1983	Oct	30	2
9	US	1983	Nov	30
9	US
America/St_Johns	8
3:30:52	-	1884
3:30:52	StJohns	1918
3:30:52	Canada	1919
3:30:52	StJohns	1935	Mar	30
3:30	StJohns	1942	May	11
3:30	Canada	1946
3:30	StJohns	2011	Nov
3:30	Canada
America/St_Kitts	2
4:10:52	-	1912	Mar	2
4	-
America/St_Lucia	3
4:04	-	1890
4:04	-	1912
4	-
America/St_Thomas	2
4:19:44	-	1911	Jul
4	-
America/St_Vincent	3
4:04:56	-	1890
4:04:56	-	1912
4	-
America/Swift_Current	5
7:11:20	-	1905	Sep
7	Canada	1946	Apr	0	2
7	Regina	1950
7	Swift	1972	Apr	0	2
6	-
America/Tegucigalpa	2
5:48:52	-	1921	Apr
6	Hond
America/Thule	2
4:35:08	-	1916	Jul	28
4	Thule
America/Thunder_Bay	6
5:57	-	1895
6	-	1910
5	-	1942
5	Canada	1970
5	Toronto	1974
5	Canada
America/Tijuana	25
7:48:04	-	1922	Jan	1	7u
7	-	1924
8	-	1927	Jun	10
7	-	1930	Nov	15
8	-	1931	Apr
8	1	1931	Sep	30
8	-	1942	Apr	24
8	1	1945	Aug	14	23u
8	1	1945	Nov	15
8	-	1948	Apr	5
8	1	1949	Jan	14
8	-	1950	May
8	1	1950	Sep	24
8	-	1951	Apr	29	2
8	1	1951	Sep	30	2
8	-	1952	Apr	27	2
8	1	1952	Sep	28	2
8	-	1954
8	CA	1961
8	-	1976
8	US	1996
8	Mexico	2001
8	US	2002	Feb	20
8	Mexico	2010
8	US
America/Toronto	6
5:17:32	-	1895
5	Canada	1919
5	Toronto	1942	Feb	9	2s
5	Canada	1946
5	Toronto	1974
5	Canada
America/Tortola	2
4:18:28	-	1911	Jul
4	-
America/Vancouver	3
8:12:28	-	1884
8	Vanc	1987
8	Canada
America/Whitehorse	6
9:00:12	-	1900	Aug	20
9	NT_YK	1965
9	Yukon	1966	Feb	27
8	-	1980
8	Canada	2020	Nov
7	-
America/Winnipeg	3
6:28:36	-	1887	Jul	16
6	Winn	2006
6	Canada
America/Yakutat	7
-14:41:05	-	1867	Oct	19	15:12:18
9:18:55	-	1900	Aug	20	12
9	-	1942
9	US	1946
9	-	1969
9	US	1983	Nov	30
9	US
America/Yellowknife	3
0	-	1935
7	NT_YK	1980
7	Canada
Antarctica/Casey	18
0	-	1969
-8	-	2009	Oct	18	2
-11	-	2010	Mar	5	2
-8	-	2011	Oct	28	2
-11	-	2012	Feb	21	17u
-8	-	2016	Oct	22
-11	-	2018	Mar	11	4
-8	-	2018	Oct	7	4
-11	-	2019	Mar	17	3
-8	-	2019	Oct	4	3
-11	-	2020	Mar	8	3
-8	-	2020	Oct	4	0:01
-11	-	2021	Mar	14
-8	-	2021	Oct	3	0:01
-11	-	2022	Mar	13
-8	-	2022	Oct	2	0:01
-11	-	2023	Mar	9	3
-8	-
Antarctica/Davis	8
0	-	1957	Jan	13
-7	-	1964	Nov
0	-	1969	Feb
-7	-	2009	Oct	18	2
-5	-	2010	Mar	10	20u
-7	-	2011	Oct	28	2
-5	-	2012	Feb	21	20u
-7	-
Antarctica/DumontDUrville	4
0	-	1947
-10	-	1952	Jan	14
0	-	1956	Nov
-10	-
Antarctica/Macquarie	9
0	-	1899	Nov
-10	-	1916	Oct	1	2
-10	1	1917	Feb
-10	Aus	1919	Apr	1	0s
0	-	1948	Mar	25
-10	Aus	1967
-10	AT	2010
-10	1	2011
-10	AT
Antarctica/Mawson	3
0	-	1954	Feb	13
-6	-	2009	Oct	18	2
-5	-
Antarctica/McMurdo	2
0	-	1956
-12	NZ
Antarctica/Palmer	5
0	-	1965
4	Arg	1969	Oct	5
3	Arg	1982	May
4	Chile	2016	Dec	4
3	-
Antarctica/Rothera	2
0	-	1976	Dec
3	-
Antarctica/Syowa	2
0	-	1957	Jan	29
-3	-
Antarctica/Troll	2
0	-	2005	Feb	12
0	Troll
Antarctica/Vostok	5
0	-	1957	Dec	16
-7	-	1994	Feb
0	-	1994	Nov
-7	-	2023	Dec	18	2
-5	-
Asia/Aden	2
-2:59:54	-	1950
-3	-
Asia/Almaty	7
-5:07:48	-	1924	May	2
-5	-	1930	Jun	21
-6	RussiaAsia	1991	Mar	31	2s
-5	RussiaAsia	1992	Jan	19	2s
-6	RussiaAsia	2004	Oct	31	2s
-6	-	2024	Mar
-5	-
Asia/Amman	3
-2:23:44	-	1931
-2	Jordan	2022	Oct	28	0s
-3	-
Asia/Anadyr	8
-11:49:56	-	1924	May	2
-12	-	1930	Jun	21
-13	Russia	1982	Apr	1	0s
-12	Russia	1991	Mar	31	2s
-11	Russia	1992	Jan	19	2s
-12	Russia	2010	Mar	28	2s
-11	Russia	2011	Mar	27	2s
-12	-
Asia/Aqtau	9
-3:21:04	-	1924	May	2
-4	-	1930	Jun	21
-5	-	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1991	Mar	31	2s
-4	RussiaAsia	1992	Jan	19	2s
-5	RussiaAsia	1994	Sep	25	2s
-4	RussiaAsia	2004	Oct	31	2s
-5	-
Asia/Aqtobe	9
-3:48:40	-	1924	May	2
-4	-	1930	Jun	21
-5	-	1981	Apr
-5	1	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1991	Mar	31	2s
-4	RussiaAsia	1992	Jan	19	2s
-5	RussiaAsia	2004	Oct	31	2s
-5	-
Asia/Ashgabat	5
-3:53:32	-	1924	May	2
-4	-	1930	Jun	21
-5	RussiaAsia	1991	Mar	31	2
-4	RussiaAsia	1992	Jan	19	2
-5	-
Asia/Atyrau	9
-3:27:44	-	1924	May	2
-3	-	1930	Jun	21
-5	-	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1991	Mar	31	2s
-4	RussiaAsia	1992	Jan	19	2s
-5	RussiaAsia	1999	Mar	28	2s
-4	RussiaAsia	2004	Oct	31	2s
-5	-
Asia/Baghdad	4
-2:57:40	-	1890
-2:57:36	-	1918
-3	-	1982	May
-3	Iraq
Asia/Bahrain	4
-3:22:20	-	1941	Jul	20
-3:30	-	1944
-4	-	1972	Jun
-3	-
Asia/Baku	7
-3:19:24	-	1924	May	2
-3	-	1957	Mar
-4	RussiaAsia	1991	Mar	31	2s
-3	RussiaAsia	1992	Sep	0	2s
-4	-	1996
-4	EUAsia	1997
-4	Azer
Asia/Bangkok	3
-6:42:04	-	1880
-6:42:04	-	1920	Apr
-7	-
Asia/Barnaul	9
-5:35	-	1919	Dec	10
-6	-	1930	Jun	21
-7	Russia	1991	Mar	31	2s
-6	Russia	1992	Jan	19	2s
-7	Russia	1995	May	28
-6	Russia	2011	Mar	27	2s
-7	-	2014	Oct	26	2s
-6	-	2016	Mar	27	2s
-7	-
Asia/Beirut	2
-2:22	-	1880
-2	Lebanon
Asia/Bishkek	6
-4:58:24	-	1924	May	2
-5	-	1930	Jun	21
-6	RussiaAsia	1991	Mar	31	2s
-5	RussiaAsia	1991	Aug	31	2
-5	Kyrgyz	2005	Aug	12
-6	-
Asia/Brunei	3
-7:39:40	-	1926	Mar
-7:30	-	1933
-8	-
Asia/Chita	8
-7:33:52	-	1919	Dec	15
-8	-	1930	Jun	21
-9	Russia	1991	Mar	31	2s
-8	Russia	1992	Jan	19	2s
-9	Russia	2011	Mar	27	2s
-10	-	2014	Oct	26	2s
-8	-	2016	Mar	27	2
-9	-
Asia/Choibalsan	5
-7:38	-	1905	Aug
-7	-	1978
-8	-	1983	Apr
-9	Mongol	2008	Mar	31
-8	Mongol
Asia/Colombo	9
-5:19:24	-	1880
-5:19:32	-	1906
-5:30	-	1942	Jan	5
-5:30	0:30	1942	Sep
-5:30	1	1945	Oct	16	2
-5:30	-	1996	May	25
-6:30	-	1996	Oct	26	0:30
-6	-	2006	Apr	15	0:30
-5:30	-
Asia/Damascus	3
-2:25:12	-	1920
-2	Syria	2022	Oct	28
-3	-
Asia/Dhaka	7
-6:01:40	-	1890
-5:53:20	-	1941	Oct
-6:30	-	1942	May	15
-5:30	-	1942	Sep
-6:30	-	1951	Sep	30
-6	-	2009
-6	Dhaka
Asia/Dili	5
-8:22:20	-	1911	Dec	31	16u
-8	-	1942	Feb	21	23
-9	-	1976	May	3
-8	-	2000	Sep	17
-9	-
Asia/Dubai	2
-3:41:12	-	1920
-4	-
Asia/Dushanbe	5
-4:35:12	-	1924	May	2
-5	-	1930	Jun	21
-6	RussiaAsia	1991	Mar	31	2s
-5	1	1991	Sep	9	2s
-5	-
Asia/Famagusta	5
-2:15:48	-	1921	Nov	14
-2	Cyprus	1998	Sep
-2	EUAsia	2016	Sep	8
-3	-	2017	Oct	29	1u
-2	EUAsia
Asia/Gaza	12
-2:17:52	-	1900	Oct
-2	Zion	1948	May	15
-2	EgyptAsia	1967	Jun	5
-2	Zion	1996
-2	Jordan	1999
-2	Palestine	2008	Aug	29
-2	-	2008	Sep
-2	Palestine	2010
-2	-	2010	Mar	27	0:01
-2	Palestine	2011	Aug
-2	-	2012
-2	Palestine
Asia/Hebron	6
-2:20:23	-	1900	Oct
-2	Zion	1948	May	15
-2	EgyptAsia	1967	Jun	5
-2	Zion	1996
-2	Jordan	1999
-2	Palestine
Asia/Ho_Chi_Minh	10
-7:06:30	-	1906	Jul
-7:06:30	-	1911	May
-7	-	1942	Dec	31	23
-8	-	1945	Mar	14	23
-9	-	1945	Sep	1	24
-7	-	1947	Apr
-8	-	1955	Jul	1	1
-7	-	1959	Dec	31	23
-8	-	1975	Jun	13
-7	-
Asia/Hong_Kong	6
-7:36:42	-	1904	Oct	29	17u
-8	-	1941	Jun	15	3
-8	1	1941	Oct	1	4
-8	0:30	1941	Dec	25
-9	-	1945	Nov	18	2
-8	HK
Asia/Hovd	3
-6:06:36	-	1905	Aug
-6	-	1978
-7	Mongol
Asia/Irkutsk	8
-6:57:05	-	1880
-6:57:05	-	1920	Jan	25
-7	-	1930	Jun	21
-8	Russia	1991	Mar	31	2s
-7	Russia	1992	Jan	19	2s
-8	Russia	2011	Mar	27	2s
-9	-	2014	Oct	26	2s
-8	-
Asia/Jakarta	9
-7:07:12	-	1867	Aug	10
-7:07:12	-	1923	Dec	31	16:40u
-7:20	-	1932	Nov
-7:30	-	1942	Mar	23
-9	-	1945	Sep	23
-7:30	-	1948	May
-8	-	1950	May
-7:30	-	1964
-7	-
Asia/Jayapura	4
-9:22:48	-	1932	Nov
-9	-	1944	Sep
-9:30	-	1964
-9	-
Asia/Jerusalem	3
-2:20:54	-	1880
-2:20:40	-	1918
-2	Zion
Asia/Kabul	3
-4:36:48	-	1890
-4	-	1945
-4:30	-
Asia/Kamchatka	7
-10:34:36	-	1922	Nov	10
-11	-	1930	Jun	21
-12	Russia	1991	Mar	31	2s
-11	Russia	1992	Jan	19	2s
-12	Russia	2010	Mar	28	2s
-11	Russia	2011	Mar	27	2s
-12	-
Asia/Karachi	6
-4:28:12	-	1907
-5:30	-	1942	Sep
-5:30	1	1945	Oct	15
-5:30	-	1951	Sep	30
-5	-	1971	Mar	26
-5	Pakistan
Asia/Kathmandu	3
-5:41:16	-	1920
-5:30	-	1986
-5:45	-
Asia/Khandyga	9
-9:02:13	-	1919	Dec	15
-8	-	1930	Jun	21
-9	Russia	1991	Mar	31	2s
-8	Russia	1992	Jan	19	2s
-9	Russia	2004
-10	Russia	2011	Mar	27	2s
-11	-	2011	Sep	13	0s
-10	-	2014	Oct	26	2s
-9	-
Asia/Kolkata	8
-5:53:28	-	1854	Jun	28
-5:53:20	-	1870
-5:21:10	-	1906
-5:30	-	1941	Oct
-5:30	1	1942	May	15
-5:30	-	1942	Sep
-5:30	1	1945	Oct	15
-5:30	-
Asia/Krasnoyarsk	7
-6:11:26	-	1920	Jan	6
-6	-	1930	Jun	21
-7	Russia	1991	Mar	31	2s
-6	Russia	1992	Jan	19	2s
-7	Russia	2011	Mar	27	2s
-8	-	2014	Oct	26	2s
-7	-
Asia/Kuala_Lumpur	9
-6:46:46	-	1901
-6:55:25	-	1905	Jun
-7	-	1933
-7	0:20	1936
-7:20	-	1941	Sep
-7:30	-	1942	Feb	16
-9	-	1945	Sep	12
-7:30	-	1981	Dec	31	16u
-8	-
Asia/Kuching	5
-7:21:20	-	1926	Mar
-7:30	-	1933
-8	NBorneo	1942	Feb	16
-9	-	1945	Sep	12
-8	-
Asia/Kuwait	2
-3:11:56	-	1950
-3	-
Asia/Macau	4
-7:34:10	-	1904	Oct	30
-8	-	1941	Dec	21	23
-9	Macau	1945	Sep	30	24
-8	Macau
Asia/Magadan	8
-10:03:12	-	1924	May	2
-10	-	1930	Jun	21
-11	Russia	1991	Mar	31	2s
-10	Russia	1992	Jan	19	2s
-11	Russia	2011	Mar	27	2s
-12	-	2014	Oct	26	2s
-10	-	2016	Apr	24	2s
-11	-
Asia/Makassar	5
-7:57:36	-	1920
-7:57:36	-	1932	Nov
-8	-	1942	Feb	9
-9	-	1945	Sep	23
-8	-
Asia/Manila	5
15:56:08	-	1844	Dec	31
-8:03:52	-	1899	Sep	6	4u
-8	Phil	1942	Feb	11	24
-9	-	1945	Mar	4
-8	Phil
Asia/Muscat	2
-3:54:24	-	1920
-4	-
Asia/Nicosia	3
-2:13:28	-	1921	Nov	14
-2	Cyprus	1998	Sep
-2	EUAsia
Asia/Novokuznetsk	7
-5:48:48	-	1924	May
-6	-	1930	Jun	21
-7	Russia	1991	Mar	31	2s
-6	Russia	1992	Jan	19	2s
-7	Russia	2010	Mar	28	2s
-6	Russia	2011	Mar	27	2s
-7	-
Asia/Novosibirsk	9
-5:31:40	-	1919	Dec	14	6
-6	-	1930	Jun	21
-7	Russia	1991	Mar	31	2s
-6	Russia	1992	Jan	19	2s
-7	Russia	1993	May	23
-6	Russia	2011	Mar	27	2s
-7	-	2014	Oct	26	2s
-6	-	2016	Jul	24	2s
-7	-
Asia/Omsk	7
-4:53:30	-	1919	Nov	14
-5	-	1930	Jun	21
-6	Russia	1991	Mar	31	2s
-5	Russia	1992	Jan	19	2s
-6	Russia	2011	Mar	27	2s
-7	-	2014	Oct	26	2s
-6	-
Asia/Oral	10
-3:25:24	-	1924	May	2
-3	-	1930	Jun	21
-5	-	1981	Apr
-5	1	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1989	Mar	26	2s
-4	RussiaAsia	1992	Jan	19	2s
-5	RussiaAsia	1992	Mar	29	2s
-4	RussiaAsia	2004	Oct	31	2s
-5	-
Asia/Phnom_Penh	6
-6:59:40	-	1906	Jul
-7:06:30	-	1911	May
-7	-	1942	Dec	31	23
-8	-	1945	Mar	14	23
-9	-	1945	Sep	2
-7	-
Asia/Pontianak	9
-7:17:20	-	1908	May
-7:17:20	-	1932	Nov
-7:30	-	1942	Jan	29
-9	-	1945	Sep	23
-7:30	-	1948	May
-8	-	1950	May
-7:30	-	1964
-8	-	1988
-7	-
Asia/Pyongyang	6
-8:23	-	1908	Apr
-8:30	-	1912
-9	-	1945	Aug	24
-9	-	2015	Aug	15
-8:30	-	2018	May	4	23:30
-9	-
Asia/Qatar	3
-3:26:08	-	1920
-4	-	1972	Jun
-3	-
Asia/Qostanay	10
-4:14:28	-	1924	May	2
-4	-	1930	Jun	21
-5	-	1981	Apr
-5	1	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1991	Mar	31	2s
-4	RussiaAsia	1992	Jan	19	2s
-5	RussiaAsia	2004	Oct	31	2s
-6	-	2024	Mar
-5	-
Asia/Qyzylorda	12
-4:21:52	-	1924	May	2
-4	-	1930	Jun	21
-5	-	1981	Apr
-5	1	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1991	Mar	31	2s
-4	RussiaAsia	1991	Sep	29	2s
-5	RussiaAsia	1992	Jan	19	2s
-6	RussiaAsia	1992	Mar	29	2s
-5	RussiaAsia	2004	Oct	31	2s
-6	-	2018	Dec	21
-5	-
Asia/Riyadh	2
-3:06:52	-	1947	Mar	14
-3	-
Asia/Sakhalin	9
-9:30:48	-	1905	Aug	23
-9	-	1945	Aug	25
-11	Russia	1991	Mar	31	2s
-10	Russia	1992	Jan	19	2s
-11	Russia	1997	Mar	0	2s
-10	Russia	2011	Mar	27	2s
-11	-	2014	Oct	26	2s
-10	-	2016	Mar	27	2s
-11	-
Asia/Samarkand	7
-4:27:53	-	1924	May	2
-4	-	1930	Jun	21
-5	-	1981	Apr
-5	1	1981	Oct
-6	-	1982	Apr
-5	RussiaAsia	1992
-5	-
Asia/Seoul	6
-8:27:52	-	1908	Apr
-8:30	-	1912
-9	-	1945	Sep	8
-9	ROK	1954	Mar	21
-8:30	ROK	1961	Aug	10
-9	ROK
Asia/Shanghai	3
-8:05:43	-	1901
-8	Shang	1949	May	28
-8	PRC
Asia/Singapore	9
-6:55:25	-	1901
-6:55:25	-	1905	Jun
-7	-	1933
-7	0:20	1936
-7:20	-	1941	Sep
-7:30	-	1942	Feb	16
-9	-	1945	Sep	12
-7:30	-	1981	Dec	31	16u
-8	-
Asia/Srednekolymsk	7
-10:14:52	-	1924	May	2
-10	-	1930	Jun	21
-11	Russia	1991	Mar	31	2s
-10	Russia	1992	Jan	19	2s
-11	Russia	2011	Mar	27	2s
-12	-	2014	Oct	26	2s
-11	-
Asia/Taipei	4
-8:06	-	1896
-8	-	1937	Oct
-9	-	1945	Sep	21	1
-8	Taiwan
Asia/Tashkent	5
-4:37:11	-	1924	May	2
-5	-	1930	Jun	21
-6	RussiaAsia	1991	Mar	31	2
-5	RussiaAsia	1992
-5	-
Asia/Tbilisi	11
-2:59:11	-	1880
-2:59:11	-	1924	May	2
-3	-	1957	Mar
-4	RussiaAsia	1991	Mar	31	2s
-3	RussiaAsia	1992
-3	E-EurAsia	1994	Sep	0
-4	E-EurAsia	1996	Oct	0
-4	1	1997	Mar	0
-4	E-EurAsia	2004	Jun	27
-3	RussiaAsia	2005	Mar	0	2
-4	-
Asia/Tehran	5
-3:25:44	-	1916
-3:25:44	-	1935	Jun	13
-3:30	Iran	1977	Oct	20	24
-4	Iran	1978	Nov	10	24
-3:30	Iran
Asia/Thimphu	3
-5:58:36	-	1947	Aug	15
-5:30	-	1987	Oct
-6	-
Asia/Tokyo	2
-9:18:59	-	1887	Dec	31	15u
-9	Japan
Asia/Tomsk	9
-5:39:51	-	1919	Dec	22
-6	-	1930	Jun	21
-7	Russia	1991	Mar	31	2s
-6	Russia	1992	Jan	19	2s
-7	Russia	2002	May	1	3
-6	Russia	2011	Mar	27	2s
-7	-	2014	Oct	26	2s
-6	-	2016	May	29	2s
-7	-
Asia/Ulaanbaatar	3
-7:07:32	-	1905	Aug
-7	-	1978
-8	Mongol
Asia/Urumqi	2
-5:50:20	-	1928
-6	-
Asia/Ust-Nera	9
-9:32:54	-	1919	Dec	15
-8	-	1930	Jun	21
-9	Russia	1981	Apr
-11	Russia	1991	Mar	31	2s
-10	Russia	1992	Jan	19	2s
-11	Russia	2011	Mar	27	2s
-12	-	2011	Sep	13	0s
-11	-	2014	Oct	26	2s
-10	-
Asia/Vientiane	8
-6:50:24	-	1906	Jul
-7:06:30	-	1911	May
-7	-	1942	Dec	31	23
-8	-	1945	Mar	14	23
-9	-	1945	Sep	2
-7	-	1947	Apr
-8	-	1955	Apr	15
-7	-
Asia/Vladivostok	7
-8:47:31	-	1922	Nov	15
-9	-	1930	Jun	21
-10	Russia	1991	Mar	31	2s
-9	Russia	1992	Jan	19	2s
-10	Russia	2011	Mar	27	2s
-11	-	2014	Oct	26	2s
-10	-
Asia/Yakutsk	7
-8:38:58	-	1919	Dec	15
-8	-	1930	Jun	21
-9	Russia	1991	Mar	31	2s
-8	Russia	1992	Jan	19	2s
-9	Russia	2011	Mar	27	2s
-10	-	2014	Oct	26	2s
-9	-
Asia/Yangon	5
-6:24:47	-	1880
-6:24:47	-	1920
-6:30	-	1942	May
-9	-	1945	May	3
-6:30	-
Asia/Yekaterinburg	8
-4:02:33	-	1916	Jul	3
-3:45:05	-	1919	Jul	15	4
-4	-	1930	Jun	21
-5	Russia	1991	Mar	31	2s
-4	Russia	1992	Jan	19	2s
-5	Russia	2011	Mar	27	2s
-6	-	2014	Oct	26	2s
-5	-
Asia/Yerevan	7
-2:58	-	1924	May	2
-3	-	1957	Mar
-4	RussiaAsia	1991	Mar	31	2s
-3	RussiaAsia	1995	Sep	24	2s
-4	-	1997
-4	RussiaAsia	2011
-4	Armenia
Atlantic/Azores	8
1:42:40	-	1884
1:54:32	-	1912	Jan	1	2u
2	Port	1966	Oct	2	2s
1	-	1982	Mar	28	0s
1	Port	1986
1	EU	1992	Dec	27	1s
0	EU	1993	Jun	17	1u
1	EU
Atlantic/Bermuda	5
4:19:18	-	1890
4:19:18	Bermuda	1930	Jan	1	2
4	Bermuda	1974	Apr	28	2
4	Canada	1976
4	US
Atlantic/Canary	5
1:01:36	-	1922	Mar
1	-	1946	Sep	30	1
0	-	1980	Apr	6	0s
0	1	1980	Sep	28	1u
0	EU
Atlantic/Cape_Verde	5
1:34:04	-	1912	Jan	1	2u
2	-	1942	Sep
2	1	1945	Oct	15
2	-	1975	Nov	25	2
1	-
Atlantic/Faroe	3
0:27:04	-	1908	Jan	11
0	-	1981
0	EU
Atlantic/Madeira	6
1:07:36	-	1884
1:07:36	-	1912	Jan	1	1u
1	Port	1966	Oct	2	2s
0	-	1982	Apr	4
0	Port	1986	Jul	31
0	EU
Atlantic/Reykjavik	3
1:28	-	1908
1	Iceland	1968	Apr	7	1s
0	-
Atlantic/South_Georgia	2
2:26:08	-	1890
2	-
Atlantic/St_Helena	3
0:22:48	-	1890
0:22:48	-	1951
0	-
Atlantic/Stanley	6
3:51:24	-	1890
3:51:24	-	1912	Mar	12
4	Falk	1983	May
3	Falk	1985	Sep	15
4	Falk	2010	Sep	5	2
3	-
Australia/Adelaide	4
-9:14:20	-	1895	Feb
-9	-	1899	May
-9:30	Aus	1971
-9:30	AS
Australia/Brisbane	3
-10:12:08	-	1895
-10	Aus	1971
-10	AQ
Australia/Broken_Hill	6
-9:25:48	-	1895	Feb
-10	-	1896	Aug	23
-9	-	1899	May
-9:30	Aus	1971
-9:30	AN	2000
-9:30	AS
Australia/Currie	4
-9:35:28	-	1895	Sep
-10	AT	1919	Oct	24
-10	Aus	1968	Oct	15
-10	AT
Australia/Darwin	3
-8:43:20	-	1895	Feb
-9	-	1899	May
-9:30	Aus
Australia/Eucla	3
-8:35:28	-	1895	Dec
-8:45	Aus	1943	Jul
-8:45	AW
Australia/Hobart	4
-9:49:16	-	1895	Sep
-10	AT	1919	Oct	24
-10	Aus	1967
-10	AT
Australia/Lindeman	4
-9:55:56	-	1895
-10	Aus	1971
-10	AQ	1992	Jul
-10	Holiday
Australia/Lord_Howe	4
-10:36:20	-	1895	Feb
-10	-	1981	Mar
-10:30	LH	1985	Jul
-10:30	LH
Australia/Melbourne	3
-9:39:52	-	1895	Feb
-10	Aus	1971
-10	AV
Australia/Perth	3
-7:43:24	-	1895	Dec
-8	Aus	1943	Jul
-8	AW
Australia/Sydney	3
-10:04:52	-	1895	Feb
-10	Aus	1971
-10	AN
Europe/Amsterdam	6
-0:19:32	-	1835
-0:19:32	Neth	1937	Jul
-0:20	Neth	1940	May	16
-1	C-Eur	1945	Apr	2	2
-1	Neth	1977
-1	EU
Europe/Andorra	4
-0:06:04	-	1901
0	-	1946	Sep	30
-1	-	1985	Mar	31	2
-1	EU
Europe/Astrakhan	9
-3:12:12	-	1924	May
-3	-	1930	Jun	21
-4	Russia	1989	Mar	26	2s
-3	Russia	1991	Mar	31	2s
-4	-	1992	Mar	29	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-	2016	Mar	27	2s
-4	-
Europe/Athens	6
-1:34:52	-	1895	Sep	14
-1:34:52	-	1916	Jul	28	0:01
-2	Greece	1941	Apr	30
-1	Greece	1944	Apr	4
-2	Greece	1981
-2	EU
Europe/Belgrade	7
-1:22	-	1884
-1	-	1941	Apr	18	23
-1	C-Eur	1945
-1	-	1945	May	8	2s
-1	1	1945	Sep	16	2s
-1	-	1982	Nov	27
-1	EU
Europe/Berlin	5
-0:53:28	-	1893	Apr
-1	C-Eur	1945	May	24	2
-1	SovietZone	1946
-1	Germany	1980
-1	EU
Europe/Brussels	9
-0:17:30	-	1880
-0:17:30	-	1892	May	1	0:17:30
0	-	1914	Nov	8
-1	-	1916	May
-1	C-Eur	1918	Nov	11	11u
0	Belgium	1940	May	20	2s
-1	C-Eur	1944	Sep	3
-1	Belgium	1977
-1	EU
Europe/Bucharest	7
-1:44:24	-	1891	Oct
-1:44:24	-	1931	Jul	24
-2	Romania	1981	Mar	29	2s
-2	C-Eur	1991
-2	Romania	1994
-2	E-Eur	1997
-2	EU
Europe/Budapest	6
-1:16:20	-	1890	Nov
-1	C-Eur	1918
-1	Hungary	1941	Apr	7	23
-1	C-Eur	1945
-1	Hungary	1984
-1	EU
Europe/Chisinau	10
-1:55:20	-	1880
-1:55	-	1918	Feb	15
-1:44:24	-	1931	Jul	24
-2	Romania	1940	Aug	15
-2	1	1941	Jul	17
-1	C-Eur	1944	Aug	24
-3	Russia	1990	May	6	2
-2	Russia	1992
-2	E-Eur	1997
-2	Moldova
Europe/Copenhagen	6
-0:50:20	-	1890
-0:50:20	-	1894
-1	Denmark	1942	Nov	2	2s
-1	C-Eur	1945	Apr	2	2
-1	Denmark	1980
-1	EU
Europe/Dublin	11
0:25:21	-	1880	Aug	2
0:25:21	-	1916	May	21	2s
0:25:21	1	1916	Oct	1	2s
0	GB-Eire	1921	Dec	6
0	GB-Eire	1940	Feb	25	2s
0	1	1946	Oct	6	2s
0	-	1947	Mar	16	2s
0	1	1947	Nov	2	2s
0	-	1948	Apr	18	2s
0	GB-Eire	1968	Oct	27
-1	Eire
Europe/Gibraltar	4
0:21:24	-	1880	Aug	2
0	GB-Eire	1957	Apr	14	2
-1	-	1982
-1	EU
Europe/Guernsey	7
0:10:09	-	1913	Jun	18
0	GB-Eire	1940	Jul	2
-1	C-Eur	1945	May	8
0	GB-Eire	1968	Oct	27
-1	-	1971	Oct	31	2u
0	GB-Eire	1996
0	EU
Europe/Helsinki	4
-1:39:49	-	1878	May	31
-1:39:49	-	1921	May
-2	Finland	1983
-2	EU
Europe/Isle_of_Man	5
0:17:55	-	1883	Mar	30	0s
0	GB-Eire	1968	Oct	27
-1	-	1971	Oct	31	2u
0	GB-Eire	1996
0	EU
Europe/Istanbul	13
-1:55:52	-	1880
-1:56:56	-	1910	Oct
-2	Turkey	1978	Jun	29
-3	Turkey	1984	Nov	1	2
-2	Turkey	2007
-2	EU	2011	Mar	27	1u
-2	-	2011	Mar	28	1u
-2	EU	2014	Mar	30	1u
-2	-	2014	Mar	31	1u
-2	EU	2015	Oct	25	1u
-2	1	2015	Nov	8	1u
-2	EU	2016	Sep	7
-3	-
Europe/Jersey	7
0:08:26	-	1898	Jun	11	16u
0	GB-Eire	1940	Jul	2
-1	C-Eur	1945	May	8
0	GB-Eire	1968	Oct	27
-1	-	1971	Oct	31	2u
0	GB-Eire	1996
0	EU
Europe/Kaliningrad	7
-1:22	-	1893	Apr
-1	C-Eur	1945	Apr	10
-2	Poland	1946	Apr	7
-3	Russia	1989	Mar	26	2s
-2	Russia	2011	Mar	27	2s
-3	-	2014	Oct	26	2s
-2	-
Europe/Kiev	9
-2:02:04	-	1880
-2:02:04	-	1924	May	2
-2	-	1930	Jun	21
-3	-	1941	Sep	20
-1	C-Eur	1943	Nov	6
-3	Russia	1990	Jul	1	2
-2	1	1991	Sep	29	3
-2	C-Eur	1996	May	13
-2	EU
Europe/Kirov	8
-3:18:48	-	1919	Jul	1	0u
-3	-	1930	Jun	21
-4	Russia	1989	Mar	26	2s
-3	Russia	1991	Mar	31	2s
-4	-	1992	Mar	29	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-
Europe/Lisbon	8
0:36:45	-	1884
0:36:45	-	1912	Jan	1	0u
0	Port	1966	Oct	2	2s
-1	-	1976	Sep	26	1
0	Port	1986
0	EU	1992	Sep	27	1u
-1	EU	1996	Mar	31	1u
0	EU
Europe/Ljubljana	6
-0:58:04	-	1884
-1	-	1941	Apr	18	23
-1	C-Eur	1945	May	8	2s
-1	1	1945	Sep	16	2s
-1	-	1982	Nov	27
-1	EU
Europe/London	5
0:01:15	-	1847	Dec
0	GB-Eire	1968	Oct	27
-1	-	1971	Oct	31	2u
0	GB-Eire	1996
0	EU
Europe/Luxembourg	7
-0:24:36	-	1904	Jun
-1	Lux	1918	Nov	25
0	Lux	1929	Oct	6	2s
0	Belgium	1940	May	14	3
-1	C-Eur	1944	Sep	18	3
-1	Belgium	1977
-1	EU
Europe/Madrid	4
0:14:44	-	1901	Jan	1	0u
0	Spain	1940	Mar	16	23
-1	Spain	1979
-1	EU
Europe/Malta	4
-0:58:04	-	1893	Nov	2
-1	Italy	1973	Mar	31
-1	Malta	1981
-1	EU
Europe/Minsk	9
-1:50:16	-	1880
-1:50	-	1924	May	2
-2	-	1930	Jun	21
-3	-	1941	Jun	28
-1	C-Eur	1944	Jul	3
-3	Russia	1990
-3	-	1991	Mar	31	2s
-2	Russia	2011	Mar	27	2s
-3	-
Europe/Monaco	5
-0:29:32	-	1892	Jun
-0:09:21	-	1911	Mar	29
0	France	1945	Sep	16	3
-1	France	1977
-1	EU
Europe/Moscow	11
-2:30:17	-	1880
-2:30:17	-	1916	Jul	3
-2:31:19	Russia	1919	Jul	1	0u
-3	Russia	1921	Oct
-3	Russia	1922	Oct
-2	-	1930	Jun	21
-3	Russia	1991	Mar	31	2s
-2	Russia	1992	Jan	19	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-
Europe/Oslo	5
-0:43	-	1895
-1	Norway	1940	Aug	10	23
-1	C-Eur	1945	Apr	2	2
-1	Norway	1980
-1	EU
Europe/Paris	7
-0:09:21	-	1891	Mar	16
-0:09:21	-	1911	Mar	11
0	France	1940	Jun	14	23
-1	C-Eur	1944	Aug	25
0	France	1945	Sep	16	3
-1	France	1977
-1	EU
Europe/Prague	7
-0:57:44	-	1850
-0:57:44	-	1891	Oct
-1	C-Eur	1945	May	9
-1	Czech	1946	Dec	1	3
-1	-1	1947	Feb	23	2
-1	Czech	1979
-1	EU
Europe/Riga	15
-1:36:34	-	1880
-1:36:34	-	1918	Apr	15	2
-1:36:34	1	1918	Sep	16	3
-1:36:34	-	1919	Apr	1	2
-1:36:34	1	1919	May	22	3
-1:36:34	-	1926	May	11
-2	-	1940	Aug	5
-3	-	1941	Jul
-1	C-Eur	1944	Oct	13
-3	Russia	1989	Mar	0	2s
-2	1	1989	Sep	0	2s
-2	Latvia	1997	Jan	21
-2	EU	2000	Feb	29
-2	-	2001	Jan	2
-2	EU
Europe/Rome	6
-0:49:56	-	1866	Dec	12
-0:49:56	-	1893	Oct	31	23u
-1	Italy	1943	Sep	10
-1	C-Eur	1944	Jun	4
-1	Italy	1980
-1	EU
Europe/Samara	10
-3:20:20	-	1919	Jul	1	0u
-3	-	1930	Jun	21
-4	-	1935	Jan	27
-4	Russia	1989	Mar	26	2s
-3	Russia	1991	Mar	31	2s
-2	Russia	1991	Sep	29	2s
-3	-	1991	Oct	20	3
-4	Russia	2010	Mar	28	2s
-3	Russia	2011	Mar	27	2s
-4	-
Europe/Sarajevo	6
-1:13:40	-	1884
-1	-	1941	Apr	18	23
-1	C-Eur	1945	May	8	2s
-1	1	1945	Sep	16	2s
-1	-	1982	Nov	27
-1	EU
Europe/Saratov	9
-3:04:18	-	1919	Jul	1	0u
-3	-	1930	Jun	21
-4	Russia	1988	Mar	27	2s
-3	Russia	1991	Mar	31	2s
-4	-	1992	Mar	29	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-	2016	Dec	4	2s
-4	-
Europe/Simferopol	15
-2:16:24	-	1880
-2:16	-	1924	May	2
-2	-	1930	Jun	21
-3	-	1941	Nov
-1	C-Eur	1944	Apr	13
-3	Russia	1990
-3	-	1990	Jul	1	2
-2	-	1992	Mar	20
-2	C-Eur	1994	May
-3	C-Eur	1996	Mar	31	0s
-3	1	1996	Oct	27	3s
-3	-	1997	Mar	0	1u
-2	EU	2014	Mar	30	2
-4	-	2014	Oct	26	2s
-3	-
Europe/Skopje	6
-1:25:44	-	1884
-1	-	1941	Apr	18	23
-1	C-Eur	1945	May	8	2s
-1	1	1945	Sep	16	2s
-1	-	1982	Nov	27
-1	EU
Europe/Sofia	10
-1:33:16	-	1880
-1:56:56	-	1894	Nov	30
-2	-	1942	Nov	2	3
-1	C-Eur	1945
-1	-	1945	Apr	2	3
-2	-	1979	Mar	31	23
-2	Bulg	1982	Sep	26	3
-2	C-Eur	1991
-2	E-Eur	1997
-2	EU
Europe/Stockholm	6
-1:12:12	-	1879
-1:00:14	-	1900
-1	-	1916	May	14	23
-1	1	1916	Oct	1	1
-1	-	1980
-1	EU
Europe/Tallinn	13
-1:39	-	1880
-1:39	-	1918	Feb
-1	C-Eur	1919	Jul
-1:39	-	1921	May
-2	-	1940	Aug	6
-3	-	1941	Sep	15
-1	C-Eur	1944	Sep	22
-3	Russia	1989	Mar	26	2s
-2	1	1989	Sep	24	2s
-2	C-Eur	1998	Sep	22
-2	EU	1999	Oct	31	4
-2	-	2002	Feb	21
-2	EU
Europe/Tirane	4
-1:19:20	-	1914
-1	-	1940	Jun	16
-1	Albania	1984	Jul
-1	EU
Europe/Ulyanovsk	9
-3:13:36	-	1919	Jul	1	0u
-3	-	1930	Jun	21
-4	Russia	1989	Mar	26	2s
-3	Russia	1991	Mar	31	2s
-2	Russia	1992	Jan	19	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-	2016	Mar	27	2s
-4	-
Europe/Uzhgorod	11
-1:29:12	-	1890	Oct
-1	-	1940
-1	C-Eur	1944	Oct
-1	1	1944	Oct	26
-1	-	1945	Jun	29
-3	Russia	1990
-3	-	1990	Jul	1	2
-1	-	1991	Mar	31	3
-2	-	1992	Mar	20
-2	C-Eur	1996	May	13
-2	EU
Europe/Vaduz	3
-0:38:04	-	1894	Jun
-1	Swiss	1981
-1	EU
Europe/Vienna	8
-1:05:21	-	1893	Apr
-1	C-Eur	1920
-1	Austria	1940	Apr	1	2s
-1	C-Eur	1945	Apr	2	2s
-1	1	1945	Apr	12	2s
-1	-	1946
-1	Austria	1981
-1	EU
Europe/Vilnius	15
-1:41:16	-	1880
-1:24	-	1917
-1:35:36	-	1919	Oct	10
-1	-	1920	Jul	12
-2	-	1920	Oct	9
-1	-	1940	Aug	3
-3	-	1941	Jun	24
-1	C-Eur	1944	Aug
-3	Russia	1989	Mar	26	2s
-2	Russia	1991	Sep	29	2s
-2	C-Eur	1998
-2	-	1998	Mar	29	1u
-1	EU	1999	Oct	31	1u
-2	-	2003
-2	EU
Europe/Volgograd	11
-2:57:40	-	1920	Jan	3
-3	-	1930	Jun	21
-4	-	1961	Nov	11
-4	Russia	1988	Mar	27	2s
-3	Russia	1991	Mar	31	2s
-4	-	1992	Mar	29	2s
-3	Russia	2011	Mar	27	2s
-4	-	2014	Oct	26	2s
-3	-	2018	Oct	28	2s
-4	-	2020	Dec	27	2s
-3	-
Europe/Warsaw	9
-1:24	-	1880
-1:24	-	1915	Aug	5
-1	C-Eur	1918	Sep	16	3
-2	Poland	1922	Jun
-1	Poland	1940	Jun	23	2
-1	C-Eur	1944	Oct
-1	Poland	1977
-1	W-Eur	1988
-1	EU
Europe/Zagreb	6
-1:03:52	-	1884
-1	-	1941	Apr	18	23
-1	C-Eur	1945	May	8	2s
-1	1	1945	Sep	16	2s
-1	-	1982	Nov	27
-1	EU
Europe/Zaporozhye	9
-2:20:40	-	1880
-2:20	-	1924	May	2
-2	-	1930	Jun	21
-3	-	1941	Aug	25
-1	C-Eur	1943	Oct	25
-3	Russia	1991	Mar	31	2
-2	E-Eur	1992	Mar	20
-2	C-Eur	1996	May	13
-2	EU
Europe/Zurich	4
-0:34:08	-	1853	Jul	16
-0:29:46	-	1894	Jun
-1	Swiss	1981
-1	EU
Indian/Antananarivo	4
-3:10:04	-	1911	Jul
-3	-	1954	Feb	27	23s
-3	1	1954	May	29	23s
-3	-
Indian/Chagos	3
-4:49:40	-	1907
-5	-	1996
-6	-
Indian/Christmas	2
-7:02:52	-	1895	Feb
-7	-
Indian/Cocos	2
-6:27:40	-	1900
-6:30	-
Indian/Comoro	2
-2:53:04	-	1911	Jul
-3	-
Indian/Kerguelen	2
0	-	1950
-5	-
Indian/Mahe	2
-3:41:48	-	1907
-4	-
Indian/Maldives	3
-4:54	-	1880
-4:54	-	1960
-5	-
Indian/Mauritius	2
-3:50	-	1907
-4	Mauritius
Indian/Mayotte	2
-3:00:56	-	1911	Jul
-3	-
Indian/Reunion	2
-3:41:52	-	1911	Jun
-4	-
Pacific/Apia	5
-12:33:04	-	1892	Jul	5
11:26:56	-	1911
11:30	-	1950
11	WS	2011	Dec	29	24
-13	WS
Pacific/Auckland	3
-11:39:04	-	1868	Nov	2
-11:30	NZ	1946
-12	NZ
Pacific/Bougainville	6
-10:22:16	-	1880
-9:48:32	-	1895
-10	-	1942	Jul
-9	-	1945	Aug	21
-10	-	2014	Dec	28	2
-11	-
Pacific/Chatham	3
-12:13:48	-	1868	Nov	2
-12:15	-	1946
-12:45	Chatham
Pacific/Chuuk	7
13:52:52	-	1844	Dec	31
-10:07:08	-	1901
-10	-	1914	Oct
-9	-	1919	Feb
-10	-	1941	Apr
-9	-	1945	Aug
-10	-
Pacific/Easter	4
7:17:28	-	1890
7:17:28	-	1932	Sep
7	Chile	1982	Mar	14	3u
6	Chile
Pacific/Efate	2
-11:13:16	-	1912	Jan	13
-11	Vanuatu
Pacific/Enderbury	5
0	-	1860
11:24:20	-	1885
0	-	1938	Mar	6
12	-	1942	Feb	9
0	-
Pacific/Fakaofo	3
11:24:56	-	1901
11	-	2011	Dec	30
-13	-
Pacific/Fiji	2
-11:55:44	-	1915	Oct	26
-12	Fiji
Pacific/Funafuti	2
-11:56:52	-	1901
-12	-
Pacific/Galapagos	3
5:58:24	-	1931
5	-	1986
6	Ecuador
Pacific/Gambier	2
8:59:48	-	1912	Oct
9	-
Pacific/Guadalcanal	2
-10:39:48	-	1912	Oct
-11	-
Pacific/Guam	6
14:21	-	1844	Dec	31
-9:39	-	1901
-10	-	1941	Dec	10
-9	-	1944	Jul	31
-10	Guam	2000	Dec	23
-10	-
Pacific/Honolulu	5
10:31:26	-	1896	Jan	13	12
10:30	-	1933	Apr	30	2
10:30	1	1933	May	21	12
10:30	US	1947	Jun	8	2
10	-
Pacific/Kiritimati	4
10:29:20	-	1901
10:40	-	1979	Oct
10	-	1994	Dec	31
-14	-
Pacific/Kosrae	10
13:08:04	-	1844	Dec	31
-10:51:56	-	1901
-11	-	1914	Oct
-9	-	1919	Feb
-11	-	1937
-10	-	1941	Apr
-9	-	1945	Aug
-11	-	1969	Oct
-12	-	1999
-11	-
Pacific/Kwajalein	7
-11:09:20	-	1901
-11	-	1937
-10	-	1941	Apr
-9	-	1944	Feb	6
-11	-	1969	Oct
12	-	1993	Aug	20	24
-12	-
Pacific/Majuro	8
-11:24:48	-	1901
-11	-	1914	Oct
-9	-	1919	Feb
-11	-	1937
-10	-	1941	Apr
-9	-	1944	Jan	30
-11	-	1969	Oct
-12	-
Pacific/Marquesas	2
9:18	-	1912	Oct
9:30	-
Pacific/Midway	4
11:49:28	-	1901
11	-	1956	Jun	3
11	1	1956	Sep	2
11	-
Pacific/Nauru	5
-11:07:40	-	1921	Jan	15
-11:30	-	1942	Aug	29
-9	-	1945	Sep	8
-11:30	-	1979	Feb	10	2
-12	-
Pacific/Niue	3
11:19:40	-	1952	Oct	16
11:20	-	1964	Jul
11	-
Pacific/Norfolk	7
-11:11:52	-	1901
-11:12	-	1951
-11:30	-	1974	Oct	27	2s
-11:30	1	1975	Mar	2	2s
-11:30	-	2015	Oct	4	2s
-11	-	2019	Jul
-11	AN
Pacific/Noumea	2
-11:05:48	-	1912	Jan	13
-11	NC
Pacific/Pago_Pago	3
-12:37:12	-	1892	Jul	5
11:22:48	-	1911
11	-
Pacific/Palau	3
15:02:04	-	1844	Dec	31
-8:57:56	-	1901
-9	-
Pacific/Pitcairn	3
8:40:20	-	1901
8:30	-	1998	Apr	27
8	-
Pacific/Pohnpei	8
13:27:08	-	1844	Dec	31
-10:32:52	-	1901
-11	-	1914	Oct
-9	-	1919	Feb
-11	-	1937
-10	-	1941	Apr
-9	-	1945	Aug
-11	-
Pacific/Port_Moresby	3
-9:48:40	-	1880
-9:48:32	-	1895
-10	-
Pacific/Rarotonga	4
-13:20:56	-	1899	Dec	26
10:39:04	-	1952	Oct	16
10:30	-	1978	Nov	12
10	Cook
Pacific/Saipan	5
14:17	-	1844	Dec	31
-9:43	-	1901
-9	-	1944	Jul	9
-10	Guam	2000	Dec	23
-10	-
Pacific/Tahiti	2
9:58:16	-	1912	Oct
10	-
Pacific/Tarawa	2
-11:32:04	-	1901
-12	-
Pacific/Tongatapu	4
-12:19:12	-	1945	Sep	10
-12:20	-	1961
-13	-	1999
-13	Tonga
Pacific/Wake	2
-11:06:28	-	1901
-12	-
Pacific/Wallis	2
-12:15:20	-	1901
-12	-

; Part 3: Atlas time zone to change list time zone mapping
; Column 1: Time zone from atlas.as
; Column 2: Time zone change entry list to use from Part 2

-YY3 11
America/Kralendijk	America/Curacao
America/Lower_Princes	America/Curacao
America/Marigot	America/Port_of_Spain
America/St_Barthelemy	America/Port_of_Spain
Arctic/Longyearbyen	Europe/Oslo
Europe/Bratislava	Europe/Prague
Europe/Busingen	Europe/Zurich
Europe/Mariehamn	Europe/Helsinki
Europe/Podgorica	Europe/Belgrade
Europe/San_Marino	Europe/Rome
Europe/Vatican	Europe/Rome

; timezone.as
