/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 39;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 38,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 35,
  Feature_IsNotISA3_1Bit = 37,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 20,
  Feature_IsNotISAFutureBit = 18,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 30,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 31,
  Feature_NoP10VectorBit = 32,
  Feature_HasHTMBit = 33,
  Feature_IsPPC32Bit = 36,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 34,
  Feature_MMABit = 19,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_NotAIX,
  GIFBS_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_Msk2Imm = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_Msk4Imm,
  GIPFP_I64_Predicate_Msk8Imm,
  GIPFP_I64_Predicate_i32immNonAllOneNonZero,
  GIPFP_I64_Predicate_imm32SExt16,
  GIPFP_I64_Predicate_imm64SExt16,
  GIPFP_I64_Predicate_imm64ZExt32,
  GIPFP_I64_Predicate_immNonAllOneAnyExt8,
  GIPFP_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32SExt16: {
    
  // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
  // sign extended field.  Used by instructions like 'addi'.
  return (int32_t)Imm == (short)Imm;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm64SExt16: {
    
  // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
  // sign extended field.  Used by instructions like 'addi'.
  return (int64_t)Imm == (short)Imm;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm64ZExt32: {
    
  // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
  // zero extended field.
  return isUInt<32>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immNonAllOneAnyExt8: {
    
  return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 227, /*)*//*default:*//*Label 57*/ 40158,
    /*TargetOpcode::G_ADD*//*Label 0*/ 186,
    /*TargetOpcode::G_SUB*//*Label 1*/ 436,
    /*TargetOpcode::G_MUL*//*Label 2*/ 760,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 936,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 1064,
    /*TargetOpcode::G_SREM*//*Label 5*/ 1192,
    /*TargetOpcode::G_UREM*//*Label 6*/ 1324, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 1456,
    /*TargetOpcode::G_OR*//*Label 8*/ 2072,
    /*TargetOpcode::G_XOR*//*Label 9*/ 2688, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ 4991, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 11*/ 5383, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ 6958,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ 7068, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 14*/ 7178, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 15*/ 7196, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 16*/ 7303,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 17*/ 18995,
    /*TargetOpcode::G_ANYEXT*//*Label 18*/ 21406,
    /*TargetOpcode::G_TRUNC*//*Label 19*/ 24479,
    /*TargetOpcode::G_CONSTANT*//*Label 20*/ 24619, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 21*/ 24741, 0,
    /*TargetOpcode::G_ZEXT*//*Label 22*/ 27804, 0, 0,
    /*TargetOpcode::G_ASHR*//*Label 23*/ 30765, 0, 0, 0,
    /*TargetOpcode::G_ROTL*//*Label 24*/ 30860, 0,
    /*TargetOpcode::G_FCMP*//*Label 25*/ 30992,
    /*TargetOpcode::G_SELECT*//*Label 26*/ 32545, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 27*/ 32787,
    /*TargetOpcode::G_SMULH*//*Label 28*/ 32891, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 29*/ 32995,
    /*TargetOpcode::G_FSUB*//*Label 30*/ 33226,
    /*TargetOpcode::G_FMUL*//*Label 31*/ 33457,
    /*TargetOpcode::G_FMA*//*Label 32*/ 33670, 0,
    /*TargetOpcode::G_FDIV*//*Label 33*/ 34280, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 34*/ 34493,
    /*TargetOpcode::G_FPEXT*//*Label 35*/ 36771,
    /*TargetOpcode::G_FPTRUNC*//*Label 36*/ 36820,
    /*TargetOpcode::G_FPTOSI*//*Label 37*/ 36880,
    /*TargetOpcode::G_FPTOUI*//*Label 38*/ 36977,
    /*TargetOpcode::G_SITOFP*//*Label 39*/ 37074,
    /*TargetOpcode::G_UITOFP*//*Label 40*/ 37172,
    /*TargetOpcode::G_FABS*//*Label 41*/ 37270,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 42*/ 37442, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 43*/ 37670, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 44*/ 37683, 0,
    /*TargetOpcode::G_CTLZ*//*Label 45*/ 37817, 0,
    /*TargetOpcode::G_CTPOP*//*Label 46*/ 37947,
    /*TargetOpcode::G_BSWAP*//*Label 47*/ 38077, 0,
    /*TargetOpcode::G_FCEIL*//*Label 48*/ 38169, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 49*/ 38279,
    /*TargetOpcode::G_FFLOOR*//*Label 50*/ 38442, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 51*/ 38552,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 52*/ 38765,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 53*/ 38978,
    /*TargetOpcode::G_STRICT_FDIV*//*Label 54*/ 39191, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 55*/ 39404,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 56*/ 39995,
    // Label 0: @186
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 65*/ 435,
    /*GILLT_s32*//*Label 58*/ 199,
    /*GILLT_s64*//*Label 59*/ 257,
    /*GILLT_s128*//*Label 60*/ 315,
    /*GILLT_v2s64*//*Label 61*/ 339,
    /*GILLT_v4s32*//*Label 62*/ 363,
    /*GILLT_v8s16*//*Label 63*/ 387,
    /*GILLT_v16s8*//*Label 64*/ 411,
    // Label 58: @199
    GIM_Try, /*On fail goto*//*Label 66*/ 256,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 67*/ 246, // Rule ID 104 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$rA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$rA, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 104,
        GIR_Done,
      // Label 67: @246
      GIM_Try, /*On fail goto*//*Label 68*/ 255, // Rule ID 196 //
        // (add:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ADD4,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 68: @255
      GIM_Reject,
    // Label 66: @256
    GIM_Reject,
    // Label 59: @257
    GIM_Try, /*On fail goto*//*Label 69*/ 314,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 70*/ 304, // Rule ID 655 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm64SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$rA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$rA, (imm:{ *:[i64] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ADDI8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 655,
        GIR_Done,
      // Label 70: @304
      GIM_Try, /*On fail goto*//*Label 71*/ 313, // Rule ID 651 //
        // (add:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ADD8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 651,
        GIR_Done,
      // Label 71: @313
      GIM_Reject,
    // Label 69: @314
    GIM_Reject,
    // Label 60: @315
    GIM_Try, /*On fail goto*//*Label 72*/ 338, // Rule ID 466 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUQM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 466,
      GIR_Done,
    // Label 72: @338
    GIM_Reject,
    // Label 61: @339
    GIM_Try, /*On fail goto*//*Label 73*/ 362, // Rule ID 465 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUDM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 465,
      GIR_Done,
    // Label 73: @362
    GIM_Reject,
    // Label 62: @363
    GIM_Try, /*On fail goto*//*Label 74*/ 386, // Rule ID 299 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUWM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 299,
      GIR_Done,
    // Label 74: @386
    GIM_Reject,
    // Label 63: @387
    GIM_Try, /*On fail goto*//*Label 75*/ 410, // Rule ID 298 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUHM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 298,
      GIR_Done,
    // Label 75: @410
    GIM_Reject,
    // Label 64: @411
    GIM_Try, /*On fail goto*//*Label 76*/ 434, // Rule ID 297 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDUBM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 297,
      GIR_Done,
    // Label 76: @434
    GIM_Reject,
    // Label 65: @435
    GIM_Reject,
    // Label 1: @436
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 84*/ 759,
    /*GILLT_s32*//*Label 77*/ 449,
    /*GILLT_s64*//*Label 78*/ 509,
    /*GILLT_s128*//*Label 79*/ 569,
    /*GILLT_v2s64*//*Label 80*/ 593,
    /*GILLT_v4s32*//*Label 81*/ 652,
    /*GILLT_v8s16*//*Label 82*/ 711,
    /*GILLT_v16s8*//*Label 83*/ 735,
    // Label 77: @449
    GIM_Try, /*On fail goto*//*Label 85*/ 508,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 86*/ 485, // Rule ID 208 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$rA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$rA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NEG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 86: @485
      GIM_Try, /*On fail goto*//*Label 87*/ 507, // Rule ID 206 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$rB, i32:{ *:[i32] }:$rA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBF,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 87: @507
      GIM_Reject,
    // Label 85: @508
    GIM_Reject,
    // Label 78: @509
    GIM_Try, /*On fail goto*//*Label 88*/ 568,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 89*/ 545, // Rule ID 661 //
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$rA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$rA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NEG8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 661,
        GIR_Done,
      // Label 89: @545
      GIM_Try, /*On fail goto*//*Label 90*/ 567, // Rule ID 660 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$rB, i64:{ *:[i64] }:$rA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SUBF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 660,
        GIR_Done,
      // Label 90: @567
      GIM_Reject,
    // Label 88: @568
    GIM_Reject,
    // Label 79: @569
    GIM_Try, /*On fail goto*//*Label 91*/ 592, // Rule ID 471 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUQM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 471,
      GIR_Done,
    // Label 91: @592
    GIM_Reject,
    // Label 80: @593
    GIM_Try, /*On fail goto*//*Label 92*/ 651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 93*/ 639, // Rule ID 538 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$vB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNEGD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 93: @639
      GIM_Try, /*On fail goto*//*Label 94*/ 650, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUDM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 94: @650
      GIM_Reject,
    // Label 92: @651
    GIM_Reject,
    // Label 81: @652
    GIM_Try, /*On fail goto*//*Label 95*/ 710,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 96*/ 698, // Rule ID 537 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNEGW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 96: @698
      GIM_Try, /*On fail goto*//*Label 97*/ 709, // Rule ID 369 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUWM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 369,
        GIR_Done,
      // Label 97: @709
      GIM_Reject,
    // Label 95: @710
    GIM_Reject,
    // Label 82: @711
    GIM_Try, /*On fail goto*//*Label 98*/ 734, // Rule ID 368 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUHM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 368,
      GIR_Done,
    // Label 98: @734
    GIM_Reject,
    // Label 83: @735
    GIM_Try, /*On fail goto*//*Label 99*/ 758, // Rule ID 367 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBUBM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 367,
      GIR_Done,
    // Label 99: @758
    GIM_Reject,
    // Label 84: @759
    GIM_Reject,
    // Label 2: @760
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 104*/ 935,
    /*GILLT_s32*//*Label 100*/ 771,
    /*GILLT_s64*//*Label 101*/ 829, 0,
    /*GILLT_v2s64*//*Label 102*/ 887,
    /*GILLT_v4s32*//*Label 103*/ 911,
    // Label 100: @771
    GIM_Try, /*On fail goto*//*Label 105*/ 828,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 106*/ 818, // Rule ID 108 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$rA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$rA, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 108,
        GIR_Done,
      // Label 106: @818
      GIM_Try, /*On fail goto*//*Label 107*/ 827, // Rule ID 205 //
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULLW,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 107: @827
      GIM_Reject,
    // Label 105: @828
    GIM_Reject,
    // Label 101: @829
    GIM_Try, /*On fail goto*//*Label 108*/ 886,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 109*/ 876, // Rule ID 695 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm64SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$rA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$rA, (imm:{ *:[i64] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MULLI8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 109: @876
      GIM_Try, /*On fail goto*//*Label 110*/ 885, // Rule ID 694 //
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULLD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 110: @885
      GIM_Reject,
    // Label 108: @886
    GIM_Reject,
    // Label 102: @887
    GIM_Try, /*On fail goto*//*Label 111*/ 910, // Rule ID 1102 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULLD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1102,
      GIR_Done,
    // Label 111: @910
    GIM_Reject,
    // Label 103: @911
    GIM_Try, /*On fail goto*//*Label 112*/ 934, // Rule ID 457 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULUWM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 457,
      GIR_Done,
    // Label 112: @934
    GIM_Reject,
    // Label 104: @935
    GIM_Reject,
    // Label 3: @936
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 118*/ 1063,
    /*GILLT_s32*//*Label 113*/ 947,
    /*GILLT_s64*//*Label 114*/ 969,
    /*GILLT_s128*//*Label 115*/ 991,
    /*GILLT_v2s64*//*Label 116*/ 1015,
    /*GILLT_v4s32*//*Label 117*/ 1039,
    // Label 113: @947
    GIM_Try, /*On fail goto*//*Label 119*/ 968, // Rule ID 199 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 199,
      GIR_Done,
    // Label 119: @968
    GIM_Reject,
    // Label 114: @969
    GIM_Try, /*On fail goto*//*Label 120*/ 990, // Rule ID 686 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 686,
      GIR_Done,
    // Label 120: @990
    GIM_Reject,
    // Label 115: @991
    GIM_Try, /*On fail goto*//*Label 121*/ 1014, // Rule ID 1126 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1126,
      GIR_Done,
    // Label 121: @1014
    GIM_Reject,
    // Label 116: @1015
    GIM_Try, /*On fail goto*//*Label 122*/ 1038, // Rule ID 1113 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1113,
      GIR_Done,
    // Label 122: @1038
    GIM_Reject,
    // Label 117: @1039
    GIM_Try, /*On fail goto*//*Label 123*/ 1062, // Rule ID 1111 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1111,
      GIR_Done,
    // Label 123: @1062
    GIM_Reject,
    // Label 118: @1063
    GIM_Reject,
    // Label 4: @1064
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 129*/ 1191,
    /*GILLT_s32*//*Label 124*/ 1075,
    /*GILLT_s64*//*Label 125*/ 1097,
    /*GILLT_s128*//*Label 126*/ 1119,
    /*GILLT_v2s64*//*Label 127*/ 1143,
    /*GILLT_v4s32*//*Label 128*/ 1167,
    // Label 124: @1075
    GIM_Try, /*On fail goto*//*Label 130*/ 1096, // Rule ID 200 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVWU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 200,
      GIR_Done,
    // Label 130: @1096
    GIM_Reject,
    // Label 125: @1097
    GIM_Try, /*On fail goto*//*Label 131*/ 1118, // Rule ID 687 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::DIVDU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 687,
      GIR_Done,
    // Label 131: @1118
    GIM_Reject,
    // Label 126: @1119
    GIM_Try, /*On fail goto*//*Label 132*/ 1142, // Rule ID 1127 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1127,
      GIR_Done,
    // Label 132: @1142
    GIM_Reject,
    // Label 127: @1143
    GIM_Try, /*On fail goto*//*Label 133*/ 1166, // Rule ID 1114 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1114,
      GIR_Done,
    // Label 133: @1166
    GIM_Reject,
    // Label 128: @1167
    GIM_Try, /*On fail goto*//*Label 134*/ 1190, // Rule ID 1112 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VDIVUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1112,
      GIR_Done,
    // Label 134: @1190
    GIM_Reject,
    // Label 129: @1191
    GIM_Reject,
    // Label 5: @1192
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 140*/ 1323,
    /*GILLT_s32*//*Label 135*/ 1203,
    /*GILLT_s64*//*Label 136*/ 1227,
    /*GILLT_s128*//*Label 137*/ 1251,
    /*GILLT_v2s64*//*Label 138*/ 1275,
    /*GILLT_v4s32*//*Label 139*/ 1299,
    // Label 135: @1203
    GIM_Try, /*On fail goto*//*Label 141*/ 1226, // Rule ID 194 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 194,
      GIR_Done,
    // Label 141: @1226
    GIM_Reject,
    // Label 136: @1227
    GIM_Try, /*On fail goto*//*Label 142*/ 1250, // Rule ID 691 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 691,
      GIR_Done,
    // Label 142: @1250
    GIM_Reject,
    // Label 137: @1251
    GIM_Try, /*On fail goto*//*Label 143*/ 1274, // Rule ID 1136 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1136,
      GIR_Done,
    // Label 143: @1274
    GIM_Reject,
    // Label 138: @1275
    GIM_Try, /*On fail goto*//*Label 144*/ 1298, // Rule ID 1109 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1109,
      GIR_Done,
    // Label 144: @1298
    GIM_Reject,
    // Label 139: @1299
    GIM_Try, /*On fail goto*//*Label 145*/ 1322, // Rule ID 1107 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1107,
      GIR_Done,
    // Label 145: @1322
    GIM_Reject,
    // Label 140: @1323
    GIM_Reject,
    // Label 6: @1324
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 151*/ 1455,
    /*GILLT_s32*//*Label 146*/ 1335,
    /*GILLT_s64*//*Label 147*/ 1359,
    /*GILLT_s128*//*Label 148*/ 1383,
    /*GILLT_v2s64*//*Label 149*/ 1407,
    /*GILLT_v4s32*//*Label 150*/ 1431,
    // Label 146: @1335
    GIM_Try, /*On fail goto*//*Label 152*/ 1358, // Rule ID 195 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 195,
      GIR_Done,
    // Label 152: @1358
    GIM_Reject,
    // Label 147: @1359
    GIM_Try, /*On fail goto*//*Label 153*/ 1382, // Rule ID 692 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MODUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 153: @1382
    GIM_Reject,
    // Label 148: @1383
    GIM_Try, /*On fail goto*//*Label 154*/ 1406, // Rule ID 1137 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1137,
      GIR_Done,
    // Label 154: @1406
    GIM_Reject,
    // Label 149: @1407
    GIM_Try, /*On fail goto*//*Label 155*/ 1430, // Rule ID 1110 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1110,
      GIR_Done,
    // Label 155: @1430
    GIM_Reject,
    // Label 150: @1431
    GIM_Try, /*On fail goto*//*Label 156*/ 1454, // Rule ID 1108 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMODUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1108,
      GIR_Done,
    // Label 156: @1454
    GIM_Reject,
    // Label 151: @1455
    GIM_Reject,
    // Label 7: @1456
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 161*/ 2071,
    /*GILLT_s1*//*Label 157*/ 1468,
    /*GILLT_s32*//*Label 158*/ 1579,
    /*GILLT_s64*//*Label 159*/ 1690, 0, 0,
    /*GILLT_v4s32*//*Label 160*/ 1801,
    // Label 157: @1468
    GIM_Try, /*On fail goto*//*Label 162*/ 1578,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 163*/ 1525, // Rule ID 4854 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4854,
        GIR_Done,
      // Label 163: @1525
      GIM_Try, /*On fail goto*//*Label 164*/ 1568, // Rule ID 179 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 179,
        GIR_Done,
      // Label 164: @1568
      GIM_Try, /*On fail goto*//*Label 165*/ 1577, // Rule ID 172 //
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 165: @1577
      GIM_Reject,
    // Label 162: @1578
    GIM_Reject,
    // Label 158: @1579
    GIM_Try, /*On fail goto*//*Label 166*/ 1689,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 167*/ 1636, // Rule ID 4848 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$rB, -1:{ *:[i32] }), i32:{ *:[i32] }:$rS)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4848,
        GIR_Done,
      // Label 167: @1636
      GIM_Try, /*On fail goto*//*Label 168*/ 1679, // Rule ID 120 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$rS, (xor:{ *:[i32] } i32:{ *:[i32] }:$rB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 168: @1679
      GIM_Try, /*On fail goto*//*Label 169*/ 1688, // Rule ID 119 //
        // (and:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 169: @1688
      GIM_Reject,
    // Label 166: @1689
    GIM_Reject,
    // Label 159: @1690
    GIM_Try, /*On fail goto*//*Label 170*/ 1800,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 171*/ 1747, // Rule ID 4861 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$rB, -1:{ *:[i64] }), i64:{ *:[i64] }:$rS)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4861,
        GIR_Done,
      // Label 171: @1747
      GIM_Try, /*On fail goto*//*Label 172*/ 1790, // Rule ID 639 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$rS, (xor:{ *:[i64] } i64:{ *:[i64] }:$rB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 172: @1790
      GIM_Try, /*On fail goto*//*Label 173*/ 1799, // Rule ID 638 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::AND8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 638,
        GIR_Done,
      // Label 173: @1799
      GIM_Reject,
    // Label 170: @1800
    GIM_Reject,
    // Label 160: @1801
    GIM_Try, /*On fail goto*//*Label 174*/ 2070,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 175*/ 1868, // Rule ID 4869 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4869,
        GIR_Done,
      // Label 175: @1868
      GIM_Try, /*On fail goto*//*Label 176*/ 1925, // Rule ID 921 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 921,
        GIR_Done,
      // Label 176: @1925
      GIM_Try, /*On fail goto*//*Label 177*/ 1940, // Rule ID 920 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 920,
        GIR_Done,
      // Label 177: @1940
      GIM_Try, /*On fail goto*//*Label 178*/ 1997, // Rule ID 4857 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4857,
        GIR_Done,
      // Label 178: @1997
      GIM_Try, /*On fail goto*//*Label 179*/ 2054, // Rule ID 308 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VANDC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 308,
        GIR_Done,
      // Label 179: @2054
      GIM_Try, /*On fail goto*//*Label 180*/ 2069, // Rule ID 307 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VAND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 307,
        GIR_Done,
      // Label 180: @2069
      GIM_Reject,
    // Label 174: @2070
    GIM_Reject,
    // Label 161: @2071
    GIM_Reject,
    // Label 8: @2072
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 185*/ 2687,
    /*GILLT_s1*//*Label 181*/ 2084,
    /*GILLT_s32*//*Label 182*/ 2195,
    /*GILLT_s64*//*Label 183*/ 2306, 0, 0,
    /*GILLT_v4s32*//*Label 184*/ 2417,
    // Label 181: @2084
    GIM_Try, /*On fail goto*//*Label 186*/ 2194,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 187*/ 2141, // Rule ID 4855 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4855,
        GIR_Done,
      // Label 187: @2141
      GIM_Try, /*On fail goto*//*Label 188*/ 2184, // Rule ID 180 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 188: @2184
      GIM_Try, /*On fail goto*//*Label 189*/ 2193, // Rule ID 174 //
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CROR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 189: @2193
      GIM_Reject,
    // Label 186: @2194
    GIM_Reject,
    // Label 182: @2195
    GIM_Try, /*On fail goto*//*Label 190*/ 2305,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 191*/ 2252, // Rule ID 4849 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$rB, -1:{ *:[i32] }), i32:{ *:[i32] }:$rS)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4849,
        GIR_Done,
      // Label 191: @2252
      GIM_Try, /*On fail goto*//*Label 192*/ 2295, // Rule ID 123 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$rS, (xor:{ *:[i32] } i32:{ *:[i32] }:$rB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 123,
        GIR_Done,
      // Label 192: @2295
      GIM_Try, /*On fail goto*//*Label 193*/ 2304, // Rule ID 121 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 193: @2304
      GIM_Reject,
    // Label 190: @2305
    GIM_Reject,
    // Label 183: @2306
    GIM_Try, /*On fail goto*//*Label 194*/ 2416,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 195*/ 2363, // Rule ID 4862 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$rB, -1:{ *:[i64] }), i64:{ *:[i64] }:$rS)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4862,
        GIR_Done,
      // Label 195: @2363
      GIM_Try, /*On fail goto*//*Label 196*/ 2406, // Rule ID 642 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$rS, (xor:{ *:[i64] } i64:{ *:[i64] }:$rB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ORC8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 642,
        GIR_Done,
      // Label 196: @2406
      GIM_Try, /*On fail goto*//*Label 197*/ 2415, // Rule ID 640 //
        // (or:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::OR8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 640,
        GIR_Done,
      // Label 197: @2415
      GIM_Reject,
    // Label 194: @2416
    GIM_Reject,
    // Label 184: @2417
    GIM_Try, /*On fail goto*//*Label 198*/ 2686,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 199*/ 2484, // Rule ID 4872 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4872,
        GIR_Done,
      // Label 199: @2484
      GIM_Try, /*On fail goto*//*Label 200*/ 2541, // Rule ID 934 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 934,
        GIR_Done,
      // Label 200: @2541
      GIM_Try, /*On fail goto*//*Label 201*/ 2556, // Rule ID 923 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 923,
        GIR_Done,
      // Label 201: @2556
      GIM_Try, /*On fail goto*//*Label 202*/ 2613, // Rule ID 4860 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4860,
        GIR_Done,
      // Label 202: @2613
      GIM_Try, /*On fail goto*//*Label 203*/ 2670, // Rule ID 485 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }))  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VORC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 203: @2670
      GIM_Try, /*On fail goto*//*Label 204*/ 2685, // Rule ID 382 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 382,
        GIR_Done,
      // Label 204: @2685
      GIM_Reject,
    // Label 198: @2686
    GIM_Reject,
    // Label 185: @2687
    GIM_Reject,
    // Label 9: @2688
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 6, /*)*//*default:*//*Label 209*/ 4990,
    /*GILLT_s1*//*Label 205*/ 2700,
    /*GILLT_s32*//*Label 206*/ 3898,
    /*GILLT_s64*//*Label 207*/ 4138, 0, 0,
    /*GILLT_v4s32*//*Label 208*/ 4378,
    // Label 205: @2700
    GIM_Try, /*On fail goto*//*Label 210*/ 3897,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 211*/ 2786, // Rule ID 3955 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 3955,
        GIR_Done,
      // Label 211: @2786
      GIM_Try, /*On fail goto*//*Label 212*/ 2862, // Rule ID 3987 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 3987,
        GIR_Done,
      // Label 212: @2862
      GIM_Try, /*On fail goto*//*Label 213*/ 2938, // Rule ID 4019 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4019,
        GIR_Done,
      // Label 213: @2938
      GIM_Try, /*On fail goto*//*Label 214*/ 3014, // Rule ID 4051 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4051,
        GIR_Done,
      // Label 214: @3014
      GIM_Try, /*On fail goto*//*Label 215*/ 3090, // Rule ID 4067 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4067,
        GIR_Done,
      // Label 215: @3090
      GIM_Try, /*On fail goto*//*Label 216*/ 3166, // Rule ID 4099 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4099,
        GIR_Done,
      // Label 216: @3166
      GIM_Try, /*On fail goto*//*Label 217*/ 3242, // Rule ID 4131 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4131,
        GIR_Done,
      // Label 217: @3242
      GIM_Try, /*On fail goto*//*Label 218*/ 3318, // Rule ID 4163 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4163,
        GIR_Done,
      // Label 218: @3318
      GIM_Try, /*On fail goto*//*Label 219*/ 3394, // Rule ID 4193 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4193,
        GIR_Done,
      // Label 219: @3394
      GIM_Try, /*On fail goto*//*Label 220*/ 3470, // Rule ID 4225 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4225,
        GIR_Done,
      // Label 220: @3470
      GIM_Try, /*On fail goto*//*Label 221*/ 3546, // Rule ID 4257 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4257,
        GIR_Done,
      // Label 221: @3546
      GIM_Try, /*On fail goto*//*Label 222*/ 3622, // Rule ID 4289 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }), -1:{ *:[i1] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
        // GIR_Coverage, 4289,
        GIR_Done,
      // Label 222: @3622
      GIM_Try, /*On fail goto*//*Label 223*/ 3669, // Rule ID 173 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 223: @3669
      GIM_Try, /*On fail goto*//*Label 224*/ 3716, // Rule ID 176 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 176,
        GIR_Done,
      // Label 224: @3716
      GIM_Try, /*On fail goto*//*Label 225*/ 3763, // Rule ID 4852 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRB)  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4852,
        GIR_Done,
      // Label 225: @3763
      GIM_Try, /*On fail goto*//*Label 226*/ 3810, // Rule ID 177 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 226: @3810
      GIM_Try, /*On fail goto*//*Label 227*/ 3857, // Rule ID 4853 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }))  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CREQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4853,
        GIR_Done,
      // Label 227: @3857
      GIM_Try, /*On fail goto*//*Label 228*/ 3883, // Rule ID 178 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } i1:{ *:[i1] }:$CRA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // CRA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 178,
        GIR_Done,
      // Label 228: @3883
      GIM_Try, /*On fail goto*//*Label 229*/ 3896, // Rule ID 175 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRXOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CRXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 229: @3896
      GIM_Reject,
    // Label 210: @3897
    GIM_Reject,
    // Label 206: @3898
    GIM_Try, /*On fail goto*//*Label 230*/ 4137,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 231*/ 3955, // Rule ID 118 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB), -1:{ *:[i32] })  =>  (NAND:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 118,
        GIR_Done,
      // Label 231: @3955
      GIM_Try, /*On fail goto*//*Label 232*/ 3998, // Rule ID 122 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 232: @3998
      GIM_Try, /*On fail goto*//*Label 233*/ 4041, // Rule ID 4850 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$rS, -1:{ *:[i32] }), i32:{ *:[i32] }:$rB)  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4850,
        GIR_Done,
      // Label 233: @4041
      GIM_Try, /*On fail goto*//*Label 234*/ 4084, // Rule ID 124 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB), -1:{ *:[i32] })  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 124,
        GIR_Done,
      // Label 234: @4084
      GIM_Try, /*On fail goto*//*Label 235*/ 4127, // Rule ID 4851 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$rB, (xor:{ *:[i32] } i32:{ *:[i32] }:$rS, -1:{ *:[i32] }))  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4851,
        GIR_Done,
      // Label 235: @4127
      GIM_Try, /*On fail goto*//*Label 236*/ 4136, // Rule ID 125 //
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)  =>  (XOR:{ *:[i32] } i32:{ *:[i32] }:$rS, i32:{ *:[i32] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 236: @4136
      GIM_Reject,
    // Label 230: @4137
    GIM_Reject,
    // Label 207: @4138
    GIM_Try, /*On fail goto*//*Label 237*/ 4377,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 238*/ 4195, // Rule ID 637 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB), -1:{ *:[i64] })  =>  (NAND8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NAND8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 637,
        GIR_Done,
      // Label 238: @4195
      GIM_Try, /*On fail goto*//*Label 239*/ 4238, // Rule ID 641 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB), -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 239: @4238
      GIM_Try, /*On fail goto*//*Label 240*/ 4281, // Rule ID 4863 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$rS, -1:{ *:[i64] }), i64:{ *:[i64] }:$rB)  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4863,
        GIR_Done,
      // Label 240: @4281
      GIM_Try, /*On fail goto*//*Label 241*/ 4324, // Rule ID 643 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB), -1:{ *:[i64] })  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 643,
        GIR_Done,
      // Label 241: @4324
      GIM_Try, /*On fail goto*//*Label 242*/ 4367, // Rule ID 4864 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$rB, (xor:{ *:[i64] } i64:{ *:[i64] }:$rS, -1:{ *:[i64] }))  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EQV8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4864,
        GIR_Done,
      // Label 242: @4367
      GIM_Try, /*On fail goto*//*Label 243*/ 4376, // Rule ID 644 //
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (XOR8:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XOR8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 644,
        GIR_Done,
      // Label 243: @4376
      GIM_Reject,
    // Label 237: @4377
    GIM_Reject,
    // Label 208: @4378
    GIM_Try, /*On fail goto*//*Label 244*/ 4989,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 245*/ 4445, // Rule ID 932 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 245: @4445
      GIM_Try, /*On fail goto*//*Label 246*/ 4502, // Rule ID 922 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 246: @4502
      GIM_Try, /*On fail goto*//*Label 247*/ 4559, // Rule ID 4870 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XB)  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4870,
        GIR_Done,
      // Label 247: @4559
      GIM_Try, /*On fail goto*//*Label 248*/ 4616, // Rule ID 931 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 931,
        GIR_Done,
      // Label 248: @4616
      GIM_Try, /*On fail goto*//*Label 249*/ 4673, // Rule ID 4871 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }))  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4871,
        GIR_Done,
      // Label 249: @4673
      GIM_Try, /*On fail goto*//*Label 250*/ 4688, // Rule ID 924 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXLXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 924,
        GIR_Done,
      // Label 250: @4688
      GIM_Try, /*On fail goto*//*Label 251*/ 4745, // Rule ID 484 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] })  =>  (VNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 251: @4745
      GIM_Try, /*On fail goto*//*Label 252*/ 4802, // Rule ID 381 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 381,
        GIR_Done,
      // Label 252: @4802
      GIM_Try, /*On fail goto*//*Label 253*/ 4859, // Rule ID 4858 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vB)  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4858,
        GIR_Done,
      // Label 253: @4859
      GIM_Try, /*On fail goto*//*Label 254*/ 4916, // Rule ID 483 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] })  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 483,
        GIR_Done,
      // Label 254: @4916
      GIM_Try, /*On fail goto*//*Label 255*/ 4973, // Rule ID 4859 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEQV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4859,
        GIR_Done,
      // Label 255: @4973
      GIM_Try, /*On fail goto*//*Label 256*/ 4988, // Rule ID 383 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VXOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 256: @4988
      GIM_Reject,
    // Label 244: @4989
    GIM_Reject,
    // Label 209: @4990
    GIM_Reject,
    // Label 10: @4991
    GIM_Try, /*On fail goto*//*Label 257*/ 5243,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 258*/ 5054, // Rule ID 2001 //
        GIM_CheckFeatures, GIFBS_HasDirectMove_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExt5NonZero,
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A)  =>  (VSPLTISW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSPLTISW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2001,
        GIR_Done,
      // Label 258: @5054
      GIM_Try, /*On fail goto*//*Label 259*/ 5104, // Rule ID 3346 //
        GIM_CheckFeatures, GIFBS_PrefixInstrs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_i32immNonAllOneNonZero,
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A)  =>  (XXSPLTIW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTIW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3346,
        GIR_Done,
      // Label 259: @5104
      GIM_Try, /*On fail goto*//*Label 260*/ 5242, // Rule ID 1701 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FPTRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FPTRUNC,
        // MIs[2] A
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_FPTRUNC,
        // MIs[3] A
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/4, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_FPTRUNC,
        // MIs[4] A
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v4f32] } (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A))  =>  (XXSPLTW:{ *:[v4f32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (XSCVDPSP:{ *:[f64] } f64:{ *:[f64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCVDPSP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::VSRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, PPC::VSFRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSPLTW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1701,
        GIR_Done,
      // Label 260: @5242
      GIM_Reject,
    // Label 257: @5243
    GIM_Try, /*On fail goto*//*Label 261*/ 5382, // Rule ID 2236 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immNonAllOneAnyExt8,
      // MIs[1] Operand 1
      // No operand predicates
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXSPLTIB:{ *:[v4i32] } (imm:{ *:[i32] }):$A), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXSPLTIB,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 2236,
      GIR_Done,
    // Label 261: @5382
    GIM_Reject,
    // Label 11: @5383
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/3, 8, /*)*//*default:*//*Label 267*/ 6957,
    /*GILLT_s128*//*Label 262*/ 5394,
    /*GILLT_v2s64*//*Label 263*/ 5789,
    /*GILLT_v4s32*//*Label 264*/ 6048,
    /*GILLT_v8s16*//*Label 265*/ 6493,
    /*GILLT_v16s8*//*Label 266*/ 6752,
    // Label 262: @5394
    GIM_Try, /*On fail goto*//*Label 268*/ 5448, // Rule ID 1893 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v1i128] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1893,
      GIR_Done,
    // Label 268: @5448
    GIM_Try, /*On fail goto*//*Label 269*/ 5482, // Rule ID 1305 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1305,
      GIR_Done,
    // Label 269: @5482
    GIM_Try, /*On fail goto*//*Label 270*/ 5516, // Rule ID 1306 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1306,
      GIR_Done,
    // Label 270: @5516
    GIM_Try, /*On fail goto*//*Label 271*/ 5550, // Rule ID 1307 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1307,
      GIR_Done,
    // Label 271: @5550
    GIM_Try, /*On fail goto*//*Label 272*/ 5584, // Rule ID 1308 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1308,
      GIR_Done,
    // Label 272: @5584
    GIM_Try, /*On fail goto*//*Label 273*/ 5618, // Rule ID 1309 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1309,
      GIR_Done,
    // Label 273: @5618
    GIM_Try, /*On fail goto*//*Label 274*/ 5652, // Rule ID 1310 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1310,
      GIR_Done,
    // Label 274: @5652
    GIM_Try, /*On fail goto*//*Label 275*/ 5686, // Rule ID 1311 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1311,
      GIR_Done,
    // Label 275: @5686
    GIM_Try, /*On fail goto*//*Label 276*/ 5720, // Rule ID 1312 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1312,
      GIR_Done,
    // Label 276: @5720
    GIM_Try, /*On fail goto*//*Label 277*/ 5754, // Rule ID 1313 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1313,
      GIR_Done,
    // Label 277: @5754
    GIM_Try, /*On fail goto*//*Label 278*/ 5788, // Rule ID 1314 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v2f64] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1314,
      GIR_Done,
    // Label 278: @5788
    GIM_Reject,
    // Label 263: @5789
    GIM_Try, /*On fail goto*//*Label 279*/ 5843, // Rule ID 1894 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v2i64] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1894,
      GIR_Done,
    // Label 279: @5843
    GIM_Try, /*On fail goto*//*Label 280*/ 5877, // Rule ID 1300 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1300,
      GIR_Done,
    // Label 280: @5877
    GIM_Try, /*On fail goto*//*Label 281*/ 5911, // Rule ID 1301 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1301,
      GIR_Done,
    // Label 281: @5911
    GIM_Try, /*On fail goto*//*Label 282*/ 5945, // Rule ID 1302 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1302,
      GIR_Done,
    // Label 282: @5945
    GIM_Try, /*On fail goto*//*Label 283*/ 5979, // Rule ID 1303 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1303,
      GIR_Done,
    // Label 283: @5979
    GIM_Try, /*On fail goto*//*Label 284*/ 6013, // Rule ID 1304 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1304,
      GIR_Done,
    // Label 284: @6013
    GIM_Try, /*On fail goto*//*Label 285*/ 6047, // Rule ID 1319 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v2f64] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1319,
      GIR_Done,
    // Label 285: @6047
    GIM_Reject,
    // Label 264: @6048
    GIM_Try, /*On fail goto*//*Label 286*/ 6084, // Rule ID 933 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v4i32] } immAllOnesV:{ *:[v16i8] })  =>  (XXLEQVOnes:{ *:[v4i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXLEQVOnes,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 933,
      GIR_Done,
    // Label 286: @6084
    GIM_Try, /*On fail goto*//*Label 287*/ 6118, // Rule ID 1290 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1290,
      GIR_Done,
    // Label 287: @6118
    GIM_Try, /*On fail goto*//*Label 288*/ 6152, // Rule ID 1291 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1291,
      GIR_Done,
    // Label 288: @6152
    GIM_Try, /*On fail goto*//*Label 289*/ 6186, // Rule ID 1292 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1292,
      GIR_Done,
    // Label 289: @6186
    GIM_Try, /*On fail goto*//*Label 290*/ 6220, // Rule ID 1293 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1293,
      GIR_Done,
    // Label 290: @6220
    GIM_Try, /*On fail goto*//*Label 291*/ 6254, // Rule ID 1294 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1294,
      GIR_Done,
    // Label 291: @6254
    GIM_Try, /*On fail goto*//*Label 292*/ 6288, // Rule ID 1295 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1295,
      GIR_Done,
    // Label 292: @6288
    GIM_Try, /*On fail goto*//*Label 293*/ 6322, // Rule ID 1296 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1296,
      GIR_Done,
    // Label 293: @6322
    GIM_Try, /*On fail goto*//*Label 294*/ 6356, // Rule ID 1297 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1297,
      GIR_Done,
    // Label 294: @6356
    GIM_Try, /*On fail goto*//*Label 295*/ 6390, // Rule ID 1298 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1298,
      GIR_Done,
    // Label 295: @6390
    GIM_Try, /*On fail goto*//*Label 296*/ 6424, // Rule ID 1299 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1299,
      GIR_Done,
    // Label 296: @6424
    GIM_Try, /*On fail goto*//*Label 297*/ 6458, // Rule ID 1317 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1317,
      GIR_Done,
    // Label 297: @6458
    GIM_Try, /*On fail goto*//*Label 298*/ 6492, // Rule ID 1318 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1318,
      GIR_Done,
    // Label 298: @6492
    GIM_Reject,
    // Label 265: @6493
    GIM_Try, /*On fail goto*//*Label 299*/ 6547, // Rule ID 1895 //
      GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (bitconvert:{ *:[v8i16] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XXLEQVOnes,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VSRCRegClassID,
      // GIR_Coverage, 1895,
      GIR_Done,
    // Label 299: @6547
    GIM_Try, /*On fail goto*//*Label 300*/ 6581, // Rule ID 1285 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1285,
      GIR_Done,
    // Label 300: @6581
    GIM_Try, /*On fail goto*//*Label 301*/ 6615, // Rule ID 1286 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1286,
      GIR_Done,
    // Label 301: @6615
    GIM_Try, /*On fail goto*//*Label 302*/ 6649, // Rule ID 1287 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1287,
      GIR_Done,
    // Label 302: @6649
    GIM_Try, /*On fail goto*//*Label 303*/ 6683, // Rule ID 1288 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1288,
      GIR_Done,
    // Label 303: @6683
    GIM_Try, /*On fail goto*//*Label 304*/ 6717, // Rule ID 1289 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1289,
      GIR_Done,
    // Label 304: @6717
    GIM_Try, /*On fail goto*//*Label 305*/ 6751, // Rule ID 1316 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1316,
      GIR_Done,
    // Label 305: @6751
    GIM_Reject,
    // Label 266: @6752
    GIM_Try, /*On fail goto*//*Label 306*/ 6786, // Rule ID 1280 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1280,
      GIR_Done,
    // Label 306: @6786
    GIM_Try, /*On fail goto*//*Label 307*/ 6820, // Rule ID 1281 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1281,
      GIR_Done,
    // Label 307: @6820
    GIM_Try, /*On fail goto*//*Label 308*/ 6854, // Rule ID 1282 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1282,
      GIR_Done,
    // Label 308: @6854
    GIM_Try, /*On fail goto*//*Label 309*/ 6888, // Rule ID 1283 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1283,
      GIR_Done,
    // Label 309: @6888
    GIM_Try, /*On fail goto*//*Label 310*/ 6922, // Rule ID 1284 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1284,
      GIR_Done,
    // Label 310: @6922
    GIM_Try, /*On fail goto*//*Label 311*/ 6956, // Rule ID 1315 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/PPC::VRRCRegClassID,
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::VRRCRegClassID,
      // GIR_Coverage, 1315,
      GIR_Done,
    // Label 311: @6956
    GIM_Reject,
    // Label 267: @6957
    GIM_Reject,
    // Label 12: @6958
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 316*/ 7067,
    /*GILLT_s32*//*Label 312*/ 6969,
    /*GILLT_s64*//*Label 313*/ 6989, 0,
    /*GILLT_v2s64*//*Label 314*/ 7027,
    /*GILLT_v4s32*//*Label 315*/ 7047,
    // Label 312: @6969
    GIM_Try, /*On fail goto*//*Label 317*/ 6988, // Rule ID 147 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
      // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FRIZS:{ *:[f32] } f32:{ *:[f32] }:$frB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIZS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 147,
      GIR_Done,
    // Label 317: @6988
    GIM_Reject,
    // Label 313: @6989
    GIM_Try, /*On fail goto*//*Label 318*/ 7026,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 319*/ 7010, // Rule ID 903 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIZ:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPIZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 903,
        GIR_Done,
      // Label 319: @7010
      GIM_Try, /*On fail goto*//*Label 320*/ 7025, // Rule ID 145 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FRIZD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIZD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 320: @7025
      GIM_Reject,
    // Label 318: @7026
    GIM_Reject,
    // Label 314: @7027
    GIM_Try, /*On fail goto*//*Label 321*/ 7046, // Rule ID 911 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (ftrunc:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIZ:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 911,
      GIR_Done,
    // Label 321: @7046
    GIM_Reject,
    // Label 315: @7047
    GIM_Try, /*On fail goto*//*Label 322*/ 7066, // Rule ID 919 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 919,
      GIR_Done,
    // Label 322: @7066
    GIM_Reject,
    // Label 316: @7067
    GIM_Reject,
    // Label 13: @7068
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 327*/ 7177,
    /*GILLT_s32*//*Label 323*/ 7079,
    /*GILLT_s64*//*Label 324*/ 7099, 0,
    /*GILLT_v2s64*//*Label 325*/ 7137,
    /*GILLT_v4s32*//*Label 326*/ 7157,
    // Label 323: @7079
    GIM_Try, /*On fail goto*//*Label 328*/ 7098, // Rule ID 139 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
      // (fround:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FRINS:{ *:[f32] } f32:{ *:[f32] }:$frB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRINS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 139,
      GIR_Done,
    // Label 328: @7098
    GIM_Reject,
    // Label 324: @7099
    GIM_Try, /*On fail goto*//*Label 329*/ 7136,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 330*/ 7120, // Rule ID 897 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPI:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPI,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 897,
        GIR_Done,
      // Label 330: @7120
      GIM_Try, /*On fail goto*//*Label 331*/ 7135, // Rule ID 137 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FRIND:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 331: @7135
      GIM_Reject,
    // Label 329: @7136
    GIM_Reject,
    // Label 325: @7137
    GIM_Try, /*On fail goto*//*Label 332*/ 7156, // Rule ID 905 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fround:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPI:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 905,
      GIR_Done,
    // Label 332: @7156
    GIM_Reject,
    // Label 326: @7157
    GIM_Try, /*On fail goto*//*Label 333*/ 7176, // Rule ID 913 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fround:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPI:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 913,
      GIR_Done,
    // Label 333: @7176
    GIM_Reject,
    // Label 327: @7177
    GIM_Reject,
    // Label 14: @7178
    GIM_Try, /*On fail goto*//*Label 334*/ 7195, // Rule ID 631 //
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (MFTB8:{ *:[i64] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MFTB8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 631,
      GIR_Done,
    // Label 334: @7195
    GIM_Reject,
    // Label 15: @7196
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 337*/ 7258,
    /*GILLT_s32*//*Label 335*/ 7204,
    /*GILLT_s64*//*Label 336*/ 7231,
    // Label 335: @7204
    GIM_Try, /*On fail goto*//*Label 338*/ 7230, // Rule ID 1240 //
      GIM_CheckFeatures, GIFBS_HasSYNC,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1240,
      GIR_Done,
    // Label 338: @7230
    GIM_Reject,
    // Label 336: @7231
    GIM_Try, /*On fail goto*//*Label 339*/ 7257, // Rule ID 1239 //
      GIM_CheckFeatures, GIFBS_HasSYNC,
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1239,
      GIR_Done,
    // Label 339: @7257
    GIM_Reject,
    // Label 337: @7258
    GIM_Try, /*On fail goto*//*Label 340*/ 7302,
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      GIM_Try, /*On fail goto*//*Label 341*/ 7285, // Rule ID 1241 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1241,
        GIR_Done,
      // Label 341: @7285
      GIM_Try, /*On fail goto*//*Label 342*/ 7301, // Rule ID 1242 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1242,
        GIR_Done,
      // Label 342: @7301
      GIM_Reject,
    // Label 340: @7302
    GIM_Reject,
    // Label 16: @7303
    GIM_Try, /*On fail goto*//*Label 343*/ 7420,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 344*/ 7336, // Rule ID 1145 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxsetaccz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7588:{ *:[iPTR] })  =>  (XXSETACCZ:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSETACCZ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1145,
        GIR_Done,
      // Label 344: @7336
      GIM_Try, /*On fail goto*//*Label 345*/ 7364, // Rule ID 1146 //
        GIM_CheckFeatures, GIFBS_IsISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxsetaccz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::WACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7588:{ *:[iPTR] })  =>  (XXSETACCZW:{ *:[v512i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXSETACCZW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1146,
        GIR_Done,
      // Label 345: @7364
      GIM_Try, /*On fail goto*//*Label 346*/ 7390, // Rule ID 4837 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mfmsr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7520:{ *:[iPTR] })  =>  (MFMSR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFMSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4837,
        GIR_Done,
      // Label 346: @7390
      GIM_Try, /*On fail goto*//*Label 347*/ 7419, // Rule ID 4838 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mftbu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7522:{ *:[iPTR] })  =>  (MFTB:{ *:[i32] } 269:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/269,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4838,
        GIR_Done,
      // Label 347: @7419
      GIM_Reject,
    // Label 343: @7420
    GIM_Try, /*On fail goto*//*Label 348*/ 9950,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 349*/ 7461, // Rule ID 864 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7678:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSP:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 864,
        GIR_Done,
      // Label 349: @7461
      GIM_Try, /*On fail goto*//*Label 350*/ 7497, // Rule ID 867 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpsxws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7679:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPSXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 867,
        GIR_Done,
      // Label 350: @7497
      GIM_Try, /*On fail goto*//*Label 351*/ 7533, // Rule ID 870 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvdpuxws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7680:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPUXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVDPUXWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 870,
        GIR_Done,
      // Label 351: @7533
      GIM_Try, /*On fail goto*//*Label 352*/ 7569, // Rule ID 871 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7683:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPDP:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 871,
        GIR_Done,
      // Label 352: @7569
      GIM_Try, /*On fail goto*//*Label 353*/ 7605, // Rule ID 872 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspsxds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7685:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPSXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPSXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 872,
        GIR_Done,
      // Label 353: @7605
      GIM_Try, /*On fail goto*//*Label 354*/ 7641, // Rule ID 875 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvspuxds,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7686:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPUXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPUXDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 875,
        GIR_Done,
      // Label 354: @7641
      GIM_Try, /*On fail goto*//*Label 355*/ 7677, // Rule ID 880 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsxdsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7687:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVSXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSXDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 880,
        GIR_Done,
      // Label 355: @7677
      GIM_Try, /*On fail goto*//*Label 356*/ 7713, // Rule ID 885 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvuxdsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7689:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVUXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVUXDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 885,
        GIR_Done,
      // Label 356: @7713
      GIM_Try, /*On fail goto*//*Label 357*/ 7749, // Rule ID 888 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsxwdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7688:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVSXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSXWDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 888,
        GIR_Done,
      // Label 357: @7749
      GIM_Try, /*On fail goto*//*Label 358*/ 7785, // Rule ID 889 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvuxwdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7690:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVUXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVUXWDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 889,
        GIR_Done,
      // Label 358: @7785
      GIM_Try, /*On fail goto*//*Label 359*/ 7821, // Rule ID 997 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_sqrtf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7614:{ *:[iPTR] }, f128:{ *:[f128] }:$vB)  =>  (XSSQRTQPO:{ *:[f128] } f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSSQRTQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 359: @7821
      GIM_Try, /*On fail goto*//*Label 360*/ 7857, // Rule ID 1004 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_truncf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7641:{ *:[iPTR] }, f128:{ *:[f128] }:$vB)  =>  (XSCVQPDPO:{ *:[f64] } f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCVQPDPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1004,
        GIR_Done,
      // Label 360: @7857
      GIM_Try, /*On fail goto*//*Label 361*/ 7893, // Rule ID 1005 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcvsphp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7684:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPHP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCVSPHP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 361: @7893
      GIM_Try, /*On fail goto*//*Label 362*/ 7929, // Rule ID 1009 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxexpdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7712:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXEXPDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXEXPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1009,
        GIR_Done,
      // Label 362: @7929
      GIM_Try, /*On fail goto*//*Label 363*/ 7965, // Rule ID 1010 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxexpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7713:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXEXPSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXEXPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1010,
        GIR_Done,
      // Label 363: @7965
      GIM_Try, /*On fail goto*//*Label 364*/ 8001, // Rule ID 1011 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxsigdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7714:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXSIGDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXSIGDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1011,
        GIR_Done,
      // Label 364: @8001
      GIM_Try, /*On fail goto*//*Label 365*/ 8037, // Rule ID 1012 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvxsigsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7715:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXSIGSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVXSIGSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1012,
        GIR_Done,
      // Label 365: @8037
      GIM_Try, /*On fail goto*//*Label 366*/ 8081, // Rule ID 1075 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7145:{ *:[iPTR] }, (imm:{ *:[i64] }):$D)  =>  (MTVSRBMI:{ *:[v16i8] } (imm:{ *:[i64] }):$D)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRBMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1075,
        GIR_Done,
      // Label 366: @8081
      GIM_Try, /*On fail goto*//*Label 367*/ 8115, // Rule ID 73 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_popcntb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7603:{ *:[iPTR] }, i32:{ *:[i32] }:$rS)  =>  (POPCNTB:{ *:[i32] } i32:{ *:[i32] }:$rS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::POPCNTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 367: @8115
      GIM_Try, /*On fail goto*//*Label 368*/ 8151, // Rule ID 317 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexptefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7252:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VEXPTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPTEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 317,
        GIR_Done,
      // Label 368: @8151
      GIM_Try, /*On fail goto*//*Label 369*/ 8187, // Rule ID 318 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vlogefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7290:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VLOGEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VLOGEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 318,
        GIR_Done,
      // Label 369: @8187
      GIM_Try, /*On fail goto*//*Label 370*/ 8223, // Rule ID 359 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7358:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VREFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VREFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 370: @8223
      GIM_Try, /*On fail goto*//*Label 371*/ 8259, // Rule ID 360 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfim,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7359:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VRFIM:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 371: @8259
      GIM_Try, /*On fail goto*//*Label 372*/ 8295, // Rule ID 361 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfin,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7360:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VRFIN:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 372: @8295
      GIM_Try, /*On fail goto*//*Label 373*/ 8331, // Rule ID 362 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfip,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7361:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VRFIP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 373: @8331
      GIM_Try, /*On fail goto*//*Label 374*/ 8367, // Rule ID 363 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrfiz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7362:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VRFIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRFIZ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 374: @8367
      GIM_Try, /*On fail goto*//*Label 375*/ 8403, // Rule ID 364 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrsqrtefp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7373:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB)  =>  (VRSQRTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRSQRTEFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 375: @8403
      GIM_Try, /*On fail goto*//*Label 376*/ 8439, // Rule ID 415 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7415:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VUPKHPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 376: @8439
      GIM_Try, /*On fail goto*//*Label 377*/ 8475, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7416:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VUPKHSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 377: @8475
      GIM_Try, /*On fail goto*//*Label 378*/ 8511, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7417:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VUPKHSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 378: @8511
      GIM_Try, /*On fail goto*//*Label 379*/ 8547, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7419:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VUPKLPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 379: @8547
      GIM_Try, /*On fail goto*//*Label 380*/ 8583, // Rule ID 419 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7420:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VUPKLSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 380: @8583
      GIM_Try, /*On fail goto*//*Label 381*/ 8619, // Rule ID 420 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7421:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VUPKLSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 381: @8619
      GIM_Try, /*On fail goto*//*Label 382*/ 8655, // Rule ID 500 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupkhsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7418:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VUPKHSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKHSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 382: @8655
      GIM_Try, /*On fail goto*//*Label 383*/ 8691, // Rule ID 501 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vupklsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7422:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VUPKLSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VUPKLSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 383: @8691
      GIM_Try, /*On fail goto*//*Label 384*/ 8727, // Rule ID 502 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vgbbd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7272:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VGBBD:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VGBBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 384: @8727
      GIM_Try, /*On fail goto*//*Label 385*/ 8763, // Rule ID 510 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vsbox,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7127:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA)  =>  (VSBOX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSBOX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 385: @8763
      GIM_Try, /*On fail goto*//*Label 386*/ 8799, // Rule ID 526 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclzlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7182:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VCLZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLZLSBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 526,
        GIR_Done,
      // Label 386: @8799
      GIM_Try, /*On fail goto*//*Label 387*/ 8835, // Rule ID 527 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctzlsbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7240:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VCTZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTZLSBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 527,
        GIR_Done,
      // Label 387: @8835
      GIM_Try, /*On fail goto*//*Label 388*/ 8871, // Rule ID 532 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsb2w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7267:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VEXTSB2W:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSB2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 532,
        GIR_Done,
      // Label 388: @8871
      GIM_Try, /*On fail goto*//*Label 389*/ 8907, // Rule ID 533 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsh2w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7270:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VEXTSH2W:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSH2W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 533,
        GIR_Done,
      // Label 389: @8907
      GIM_Try, /*On fail goto*//*Label 390*/ 8943, // Rule ID 534 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsb2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7266:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VEXTSB2D:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSB2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 534,
        GIR_Done,
      // Label 390: @8943
      GIM_Try, /*On fail goto*//*Label 391*/ 8979, // Rule ID 535 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsh2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7269:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VEXTSH2D:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSH2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 535,
        GIR_Done,
      // Label 391: @8979
      GIM_Try, /*On fail goto*//*Label 392*/ 9015, // Rule ID 536 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsw2d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7271:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VEXTSW2D:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSW2D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 392: @9015
      GIM_Try, /*On fail goto*//*Label 393*/ 9051, // Rule ID 539 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7357:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VPRTYBW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 393: @9051
      GIM_Try, /*On fail goto*//*Label 394*/ 9087, // Rule ID 540 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7355:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vB)  =>  (VPRTYBD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 394: @9087
      GIM_Try, /*On fail goto*//*Label 395*/ 9123, // Rule ID 541 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vprtybq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7356:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vB)  =>  (VPRTYBQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPRTYBQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 541,
        GIR_Done,
      // Label 395: @9123
      GIM_Try, /*On fail goto*//*Label 396*/ 9157, // Rule ID 685 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_popcntb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7603:{ *:[iPTR] }, i64:{ *:[i64] }:$rS)  =>  (POPCNTB8:{ *:[i64] } i64:{ *:[i64] }:$rS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::POPCNTB8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 685,
        GIR_Done,
      // Label 396: @9157
      GIM_Try, /*On fail goto*//*Label 397*/ 9193, // Rule ID 1040 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstribr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7394:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VSTRIBR:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1040,
        GIR_Done,
      // Label 397: @9193
      GIM_Try, /*On fail goto*//*Label 398*/ 9229, // Rule ID 1041 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstribl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7392:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VSTRIBL:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1041,
        GIR_Done,
      // Label 398: @9229
      GIM_Try, /*On fail goto*//*Label 399*/ 9265, // Rule ID 1042 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstrihr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7398:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VSTRIHR:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1042,
        GIR_Done,
      // Label 399: @9265
      GIM_Try, /*On fail goto*//*Label 400*/ 9301, // Rule ID 1043 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vstrihl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7396:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VSTRIHL:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSTRIHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1043,
        GIR_Done,
      // Label 400: @9301
      GIM_Try, /*On fail goto*//*Label 401*/ 9337, // Rule ID 1060 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7261:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VEXTRACTBM:{ *:[i32] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 401: @9337
      GIM_Try, /*On fail goto*//*Label 402*/ 9373, // Rule ID 1061 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextracthm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7263:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VEXTRACTHM:{ *:[i32] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 402: @9373
      GIM_Try, /*On fail goto*//*Label 403*/ 9409, // Rule ID 1062 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7265:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VEXTRACTWM:{ *:[i32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1062,
        GIR_Done,
      // Label 403: @9409
      GIM_Try, /*On fail goto*//*Label 404*/ 9445, // Rule ID 1063 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7262:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vB)  =>  (VEXTRACTDM:{ *:[i32] } v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 404: @9445
      GIM_Try, /*On fail goto*//*Label 405*/ 9481, // Rule ID 1064 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextractqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7264:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vB)  =>  (VEXTRACTQM:{ *:[i32] } v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTRACTQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 405: @9481
      GIM_Try, /*On fail goto*//*Label 406*/ 9517, // Rule ID 1065 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7247:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB)  =>  (VEXPANDBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 406: @9517
      GIM_Try, /*On fail goto*//*Label 407*/ 9553, // Rule ID 1066 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7249:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB)  =>  (VEXPANDHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1066,
        GIR_Done,
      // Label 407: @9553
      GIM_Try, /*On fail goto*//*Label 408*/ 9589, // Rule ID 1067 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7251:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (VEXPANDWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1067,
        GIR_Done,
      // Label 408: @9589
      GIM_Try, /*On fail goto*//*Label 409*/ 9625, // Rule ID 1068 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpanddm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7248:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vB)  =>  (VEXPANDDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1068,
        GIR_Done,
      // Label 409: @9625
      GIM_Try, /*On fail goto*//*Label 410*/ 9661, // Rule ID 1069 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vexpandqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7250:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vB)  =>  (VEXPANDQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXPANDQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1069,
        GIR_Done,
      // Label 410: @9661
      GIM_Try, /*On fail goto*//*Label 411*/ 9697, // Rule ID 1070 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7145:{ *:[iPTR] }, i64:{ *:[i64] }:$rB)  =>  (MTVSRBM:{ *:[v16i8] } i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1070,
        GIR_Done,
      // Label 411: @9697
      GIM_Try, /*On fail goto*//*Label 412*/ 9733, // Rule ID 1071 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7147:{ *:[iPTR] }, i64:{ *:[i64] }:$rB)  =>  (MTVSRHM:{ *:[v8i16] } i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1071,
        GIR_Done,
      // Label 412: @9733
      GIM_Try, /*On fail goto*//*Label 413*/ 9769, // Rule ID 1072 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrwm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7149:{ *:[iPTR] }, i64:{ *:[i64] }:$rB)  =>  (MTVSRWM:{ *:[v4i32] } i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRWM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 413: @9769
      GIM_Try, /*On fail goto*//*Label 414*/ 9805, // Rule ID 1073 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7146:{ *:[iPTR] }, i64:{ *:[i64] }:$rB)  =>  (MTVSRDM:{ *:[v2i64] } i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 414: @9805
      GIM_Try, /*On fail goto*//*Label 415*/ 9841, // Rule ID 1074 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mtvsrqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7148:{ *:[iPTR] }, i64:{ *:[i64] }:$rB)  =>  (MTVSRQM:{ *:[v1i128] } i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSRQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 415: @9841
      GIM_Try, /*On fail goto*//*Label 416*/ 9877, // Rule ID 1138 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextsd2q,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7268:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vB)  =>  (VEXTSD2Q:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTSD2Q,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1138,
        GIR_Done,
      // Label 416: @9877
      GIM_Try, /*On fail goto*//*Label 417*/ 9913, // Rule ID 1143 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxmfacc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7586:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$AS)  =>  (XXMFACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$AS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXMFACC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // ASo
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // AS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1143,
        GIR_Done,
      // Label 417: @9913
      GIM_Try, /*On fail goto*//*Label 418*/ 9949, // Rule ID 1144 //
        GIM_CheckFeatures, GIFBS_IsNotISAFuture_MMA,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mma_xxmtacc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::ACCRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v512i1] } 7587:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi)  =>  (XXMTACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$ATi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXMTACC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // AT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ATi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1144,
        GIR_Done,
      // Label 418: @9949
      GIM_Reject,
    // Label 348: @9950
    GIM_Try, /*On fail goto*//*Label 419*/ 16529,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 420*/ 9998, // Rule ID 1013 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtstdcsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7711:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCSP:{ *:[v4i32] } (timm:{ *:[i32] }):$DCMX, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVTSTDCSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1013,
        GIR_Done,
      // Label 420: @9998
      GIM_Try, /*On fail goto*//*Label 421*/ 10041, // Rule ID 1014 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvtstdcdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7710:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCDP:{ *:[v2i64] } (timm:{ *:[i32] }):$DCMX, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVTSTDCDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // DCMX
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1014,
        GIR_Done,
      // Label 421: @10041
      GIM_Try, /*On fail goto*//*Label 422*/ 10093, // Rule ID 890 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xsmaxdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7663:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMAXDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMAXDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 890,
        GIR_Done,
      // Label 422: @10093
      GIM_Try, /*On fail goto*//*Label 423*/ 10145, // Rule ID 891 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xsmindp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSFRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSFRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 7664:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMINDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMINDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 891,
        GIR_Done,
      // Label 423: @10145
      GIM_Try, /*On fail goto*//*Label 424*/ 10197, // Rule ID 892 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmaxdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7695:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMAXDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMAXDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 424: @10197
      GIM_Try, /*On fail goto*//*Label 425*/ 10249, // Rule ID 893 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmindp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7697:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMINDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMINDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 425: @10249
      GIM_Try, /*On fail goto*//*Label 426*/ 10301, // Rule ID 894 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvmaxsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7696:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMAXSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMAXSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 426: @10301
      GIM_Try, /*On fail goto*//*Label 427*/ 10353, // Rule ID 895 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvminsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::VSRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7698:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMINSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMINSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 427: @10353
      GIM_Try, /*On fail goto*//*Label 428*/ 10397, // Rule ID 819 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpeqdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7665:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPEQDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPEQDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 819,
        GIR_Done,
      // Label 428: @10397
      GIM_Try, /*On fail goto*//*Label 429*/ 10441, // Rule ID 821 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpeqsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7667:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPEQSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPEQSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 821,
        GIR_Done,
      // Label 429: @10441
      GIM_Try, /*On fail goto*//*Label 430*/ 10485, // Rule ID 823 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgedp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7669:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGEDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGEDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 823,
        GIR_Done,
      // Label 430: @10485
      GIM_Try, /*On fail goto*//*Label 431*/ 10529, // Rule ID 825 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgesp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7671:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGESP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGESP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 825,
        GIR_Done,
      // Label 431: @10529
      GIM_Try, /*On fail goto*//*Label 432*/ 10573, // Rule ID 827 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgtdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7673:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGTDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGTDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 827,
        GIR_Done,
      // Label 432: @10573
      GIM_Try, /*On fail goto*//*Label 433*/ 10617, // Rule ID 829 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xvcmpgtsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7675:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGTSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCMPGTSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 829,
        GIR_Done,
      // Label 433: @10617
      GIM_Try, /*On fail goto*//*Label 434*/ 10661, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_addf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7116:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSADDQPO:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSADDQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 434: @10661
      GIM_Try, /*On fail goto*//*Label 435*/ 10705, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_mulf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7595:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSMULQPO:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMULQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 435: @10705
      GIM_Try, /*On fail goto*//*Label 436*/ 10749, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_subf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7623:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSSUBQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 436: @10749
      GIM_Try, /*On fail goto*//*Label 437*/ 10793, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7472:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSDIVQPO:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSDIVQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 437: @10793
      GIM_Try, /*On fail goto*//*Label 438*/ 10837, // Rule ID 1007 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xviexpdp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 7693:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)  =>  (XVIEXPDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVIEXPDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1007,
        GIR_Done,
      // Label 438: @10837
      GIM_Try, /*On fail goto*//*Label 439*/ 10881, // Rule ID 1008 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xviexpsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7694:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XVIEXPSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVIEXPSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1008,
        GIR_Done,
      // Label 439: @10881
      GIM_Try, /*On fail goto*//*Label 440*/ 10921, // Rule ID 313 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfsx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7176:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB, 0:{ *:[i32] })  =>  (VCFSX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFSX_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 313,
        GIR_Done,
      // Label 440: @10921
      GIM_Try, /*On fail goto*//*Label 441*/ 10961, // Rule ID 314 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctuxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7238:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB, 0:{ *:[i32] })  =>  (VCTUXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTUXS_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 314,
        GIR_Done,
      // Label 441: @10961
      GIM_Try, /*On fail goto*//*Label 442*/ 11001, // Rule ID 315 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfux,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7178:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB, 0:{ *:[i32] })  =>  (VCFUX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUX_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 315,
        GIR_Done,
      // Label 442: @11001
      GIM_Try, /*On fail goto*//*Label 443*/ 11041, // Rule ID 316 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctsxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7237:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB, 0:{ *:[i32] })  =>  (VCTSXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTSXS_0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 316,
        GIR_Done,
      // Label 443: @11041
      GIM_Try, /*On fail goto*//*Label 444*/ 11084, // Rule ID 309 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfsx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7176:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB, (timm:{ *:[i32] }):$UIMM)  =>  (VCFSX:{ *:[v4f32] } (timm:{ *:[i32] }):$UIMM, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFSX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // UIMM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 309,
        GIR_Done,
      // Label 444: @11084
      GIM_Try, /*On fail goto*//*Label 445*/ 11127, // Rule ID 310 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfux,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7178:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB, (timm:{ *:[i32] }):$UIMM)  =>  (VCFUX:{ *:[v4f32] } (timm:{ *:[i32] }):$UIMM, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // UIMM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 310,
        GIR_Done,
      // Label 445: @11127
      GIM_Try, /*On fail goto*//*Label 446*/ 11170, // Rule ID 311 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctsxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7237:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB, (timm:{ *:[i32] }):$UIMM)  =>  (VCTSXS:{ *:[v4i32] } (timm:{ *:[i32] }):$UIMM, v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTSXS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // UIMM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 446: @11170
      GIM_Try, /*On fail goto*//*Label 447*/ 11213, // Rule ID 312 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctuxs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7238:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vB, (timm:{ *:[i32] }):$UIMM)  =>  (VCTUXS:{ *:[v4i32] } (timm:{ *:[i32] }):$UIMM, v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTUXS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // UIMM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 312,
        GIR_Done,
      // Label 447: @11213
      GIM_Try, /*On fail goto*//*Label 448*/ 11256, // Rule ID 1076 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7233:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBB:{ *:[i64] } v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1076,
        GIR_Done,
      // Label 448: @11256
      GIM_Try, /*On fail goto*//*Label 449*/ 11299, // Rule ID 1077 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7235:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBH:{ *:[i64] } v8i16:{ *:[v8i16] }:$vB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 449: @11299
      GIM_Try, /*On fail goto*//*Label 450*/ 11342, // Rule ID 1078 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7236:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBW:{ *:[i64] } v4i32:{ *:[v4i32] }:$vB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 450: @11342
      GIM_Try, /*On fail goto*//*Label 451*/ 11385, // Rule ID 1079 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcntmbd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7234:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBD:{ *:[i64] } v2i64:{ *:[v2i64] }:$vB, (timm:{ *:[i32] }):$MP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCNTMBD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // MP
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 451: @11385
      GIM_Try, /*On fail goto*//*Label 452*/ 11428, // Rule ID 1093 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vgnb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] N
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 7273:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vB, (timm:{ *:[i32] }):$N)  =>  (VGNB:{ *:[i64] } v1i128:{ *:[v1i128] }:$vB, (timm:{ *:[i32] }):$N)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VGNB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // N
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 452: @11428
      GIM_Try, /*On fail goto*//*Label 453*/ 11480, // Rule ID 201 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divwe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7473:{ *:[iPTR] }, gprc:{ *:[i32] }:$rA, gprc:{ *:[i32] }:$rB)  =>  (DIVWE:{ *:[i32] } gprc:{ *:[i32] }:$rA, gprc:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVWE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 201,
        GIR_Done,
      // Label 453: @11480
      GIM_Try, /*On fail goto*//*Label 454*/ 11532, // Rule ID 202 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divweu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7474:{ *:[iPTR] }, gprc:{ *:[i32] }:$rA, gprc:{ *:[i32] }:$rB)  =>  (DIVWEU:{ *:[i32] } gprc:{ *:[i32] }:$rA, gprc:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVWEU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 454: @11532
      GIM_Try, /*On fail goto*//*Label 455*/ 11584, // Rule ID 682 //
        GIM_CheckFeatures, GIFBS_HasBPERMD,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_bpermd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7436:{ *:[iPTR] }, g8rc:{ *:[i64] }:$rS, g8rc:{ *:[i64] }:$rB)  =>  (BPERMD:{ *:[i64] } g8rc:{ *:[i64] }:$rS, g8rc:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::BPERMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 682,
        GIR_Done,
      // Label 455: @11584
      GIM_Try, /*On fail goto*//*Label 456*/ 11636, // Rule ID 688 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divde,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7470:{ *:[iPTR] }, g8rc:{ *:[i64] }:$rA, g8rc:{ *:[i64] }:$rB)  =>  (DIVDE:{ *:[i64] } g8rc:{ *:[i64] }:$rA, g8rc:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVDE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 688,
        GIR_Done,
      // Label 456: @11636
      GIM_Try, /*On fail goto*//*Label 457*/ 11688, // Rule ID 693 //
        GIM_CheckFeatures, GIFBS_HasExtDiv,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_divdeu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::G8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7471:{ *:[iPTR] }, g8rc:{ *:[i64] }:$rA, g8rc:{ *:[i64] }:$rB)  =>  (DIVDEU:{ *:[i64] } g8rc:{ *:[i64] }:$rA, g8rc:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DIVDEU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 693,
        GIR_Done,
      // Label 457: @11688
      GIM_Try, /*On fail goto*//*Label 458*/ 11732, // Rule ID 300 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddcuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7159:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VADDCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDCUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 300,
        GIR_Done,
      // Label 458: @11732
      GIM_Try, /*On fail goto*//*Label 459*/ 11776, // Rule ID 301 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddsbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7162:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VADDSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 301,
        GIR_Done,
      // Label 459: @11776
      GIM_Try, /*On fail goto*//*Label 460*/ 11820, // Rule ID 302 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7163:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 302,
        GIR_Done,
      // Label 460: @11820
      GIM_Try, /*On fail goto*//*Label 461*/ 11864, // Rule ID 303 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7164:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VADDSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 303,
        GIR_Done,
      // Label 461: @11864
      GIM_Try, /*On fail goto*//*Label 462*/ 11908, // Rule ID 304 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7165:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VADDUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 304,
        GIR_Done,
      // Label 462: @11908
      GIM_Try, /*On fail goto*//*Label 463*/ 11952, // Rule ID 305 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vadduhs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7166:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VADDUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 305,
        GIR_Done,
      // Label 463: @11952
      GIM_Try, /*On fail goto*//*Label 464*/ 11996, // Rule ID 306 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vadduws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7167:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VADDUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDUWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 306,
        GIR_Done,
      // Label 464: @11996
      GIM_Try, /*On fail goto*//*Label 465*/ 12040, // Rule ID 319 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7168:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VAVGSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 319,
        GIR_Done,
      // Label 465: @12040
      GIM_Try, /*On fail goto*//*Label 466*/ 12084, // Rule ID 320 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7169:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VAVGSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 320,
        GIR_Done,
      // Label 466: @12084
      GIM_Try, /*On fail goto*//*Label 467*/ 12128, // Rule ID 321 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7170:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VAVGSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 321,
        GIR_Done,
      // Label 467: @12128
      GIM_Try, /*On fail goto*//*Label 468*/ 12172, // Rule ID 322 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavgub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7171:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VAVGUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 322,
        GIR_Done,
      // Label 468: @12172
      GIM_Try, /*On fail goto*//*Label 469*/ 12216, // Rule ID 323 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavguh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7172:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VAVGUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 323,
        GIR_Done,
      // Label 469: @12216
      GIM_Try, /*On fail goto*//*Label 470*/ 12260, // Rule ID 324 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vavguw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7173:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VAVGUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VAVGUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 324,
        GIR_Done,
      // Label 470: @12260
      GIM_Try, /*On fail goto*//*Label 471*/ 12304, // Rule ID 325 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7292:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)  =>  (VMAXFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 325,
        GIR_Done,
      // Label 471: @12304
      GIM_Try, /*On fail goto*//*Label 472*/ 12348, // Rule ID 326 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7293:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMAXSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 472: @12348
      GIM_Try, /*On fail goto*//*Label 473*/ 12392, // Rule ID 327 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7295:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMAXSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 473: @12392
      GIM_Try, /*On fail goto*//*Label 474*/ 12436, // Rule ID 328 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7296:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMAXSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 474: @12436
      GIM_Try, /*On fail goto*//*Label 475*/ 12480, // Rule ID 329 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7297:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMAXUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 475: @12480
      GIM_Try, /*On fail goto*//*Label 476*/ 12524, // Rule ID 330 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7299:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMAXUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 330,
        GIR_Done,
      // Label 476: @12524
      GIM_Try, /*On fail goto*//*Label 477*/ 12568, // Rule ID 331 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7300:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMAXUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 331,
        GIR_Done,
      // Label 477: @12568
      GIM_Try, /*On fail goto*//*Label 478*/ 12612, // Rule ID 332 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminfp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 7303:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)  =>  (VMINFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 478: @12612
      GIM_Try, /*On fail goto*//*Label 479*/ 12656, // Rule ID 333 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7304:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMINSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 479: @12656
      GIM_Try, /*On fail goto*//*Label 480*/ 12700, // Rule ID 334 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7306:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMINSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 334,
        GIR_Done,
      // Label 480: @12700
      GIM_Try, /*On fail goto*//*Label 481*/ 12744, // Rule ID 335 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7307:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 481: @12744
      GIM_Try, /*On fail goto*//*Label 482*/ 12788, // Rule ID 336 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7308:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMINUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 336,
        GIR_Done,
      // Label 482: @12788
      GIM_Try, /*On fail goto*//*Label 483*/ 12832, // Rule ID 337 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7310:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMINUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 483: @12832
      GIM_Try, /*On fail goto*//*Label 484*/ 12876, // Rule ID 338 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7311:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMINUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 338,
        GIR_Done,
      // Label 484: @12876
      GIM_Try, /*On fail goto*//*Label 485*/ 12920, // Rule ID 351 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7321:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMULESB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 351,
        GIR_Done,
      // Label 485: @12920
      GIM_Try, /*On fail goto*//*Label 486*/ 12964, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7323:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMULESH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 486: @12964
      GIM_Try, /*On fail goto*//*Label 487*/ 13008, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7325:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMULEUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 487: @13008
      GIM_Try, /*On fail goto*//*Label 488*/ 13052, // Rule ID 354 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleuh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7327:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMULEUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 488: @13052
      GIM_Try, /*On fail goto*//*Label 489*/ 13096, // Rule ID 355 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7333:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMULOSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 489: @13096
      GIM_Try, /*On fail goto*//*Label 490*/ 13140, // Rule ID 356 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7335:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMULOSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 490: @13140
      GIM_Try, /*On fail goto*//*Label 491*/ 13184, // Rule ID 357 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuloub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7337:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VMULOUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 491: @13184
      GIM_Try, /*On fail goto*//*Label 492*/ 13228, // Rule ID 358 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulouh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7339:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMULOUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 492: @13228
      GIM_Try, /*On fail goto*//*Label 493*/ 13272, // Rule ID 365 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubcuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7401:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUBCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBCUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 493: @13272
      GIM_Try, /*On fail goto*//*Label 494*/ 13316, // Rule ID 370 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubsbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7404:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSUBSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 494: @13316
      GIM_Try, /*On fail goto*//*Label 495*/ 13360, // Rule ID 371 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7405:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSUBSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 371,
        GIR_Done,
      // Label 495: @13360
      GIM_Try, /*On fail goto*//*Label 496*/ 13404, // Rule ID 372 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7406:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUBSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 372,
        GIR_Done,
      // Label 496: @13404
      GIM_Try, /*On fail goto*//*Label 497*/ 13448, // Rule ID 373 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsububs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7407:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSUBUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 497: @13448
      GIM_Try, /*On fail goto*//*Label 498*/ 13492, // Rule ID 374 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubuhs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7408:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSUBUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 374,
        GIR_Done,
      // Label 498: @13492
      GIM_Try, /*On fail goto*//*Label 499*/ 13536, // Rule ID 375 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubuws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7409:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUBUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBUWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 375,
        GIR_Done,
      // Label 499: @13536
      GIM_Try, /*On fail goto*//*Label 500*/ 13580, // Rule ID 384 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7363:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 384,
        GIR_Done,
      // Label 500: @13580
      GIM_Try, /*On fail goto*//*Label 501*/ 13624, // Rule ID 385 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7367:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VRLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 385,
        GIR_Done,
      // Label 501: @13624
      GIM_Try, /*On fail goto*//*Label 502*/ 13668, // Rule ID 386 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7370:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VRLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 386,
        GIR_Done,
      // Label 502: @13668
      GIM_Try, /*On fail goto*//*Label 503*/ 13712, // Rule ID 387 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7375:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 387,
        GIR_Done,
      // Label 503: @13712
      GIM_Try, /*On fail goto*//*Label 504*/ 13756, // Rule ID 388 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslo,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7379:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSLO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 388,
        GIR_Done,
      // Label 504: @13756
      GIM_Try, /*On fail goto*//*Label 505*/ 13800, // Rule ID 389 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7376:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 389,
        GIR_Done,
      // Label 505: @13800
      GIM_Try, /*On fail goto*//*Label 506*/ 13844, // Rule ID 390 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7378:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 390,
        GIR_Done,
      // Label 506: @13844
      GIM_Try, /*On fail goto*//*Label 507*/ 13888, // Rule ID 391 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7381:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 391,
        GIR_Done,
      // Label 507: @13888
      GIM_Try, /*On fail goto*//*Label 508*/ 13932, // Rule ID 395 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7382:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 395,
        GIR_Done,
      // Label 508: @13932
      GIM_Try, /*On fail goto*//*Label 509*/ 13976, // Rule ID 396 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsro,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7389:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSRO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 396,
        GIR_Done,
      // Label 509: @13976
      GIM_Try, /*On fail goto*//*Label 510*/ 14020, // Rule ID 397 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrab,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7383:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSRAB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 397,
        GIR_Done,
      // Label 510: @14020
      GIM_Try, /*On fail goto*//*Label 511*/ 14064, // Rule ID 398 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrah,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7384:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSRAH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 398,
        GIR_Done,
      // Label 511: @14064
      GIM_Try, /*On fail goto*//*Label 512*/ 14108, // Rule ID 399 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsraw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7385:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSRAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 399,
        GIR_Done,
      // Label 512: @14108
      GIM_Try, /*On fail goto*//*Label 513*/ 14152, // Rule ID 400 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7386:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 400,
        GIR_Done,
      // Label 513: @14152
      GIM_Try, /*On fail goto*//*Label 514*/ 14196, // Rule ID 401 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7388:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VSRH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 401,
        GIR_Done,
      // Label 514: @14196
      GIM_Try, /*On fail goto*//*Label 515*/ 14240, // Rule ID 402 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7391:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSRW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 402,
        GIR_Done,
      // Label 515: @14240
      GIM_Try, /*On fail goto*//*Label 516*/ 14284, // Rule ID 406 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkpx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7345:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VPKPX:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKPX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 406,
        GIR_Done,
      // Label 516: @14284
      GIM_Try, /*On fail goto*//*Label 517*/ 14328, // Rule ID 453 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7324:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULESW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 453,
        GIR_Done,
      // Label 517: @14328
      GIM_Try, /*On fail goto*//*Label 518*/ 14372, // Rule ID 454 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7328:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULEUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 518: @14372
      GIM_Try, /*On fail goto*//*Label 519*/ 14416, // Rule ID 455 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7336:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULOSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 455,
        GIR_Done,
      // Label 519: @14416
      GIM_Try, /*On fail goto*//*Label 520*/ 14460, // Rule ID 456 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulouw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7340:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULOUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 520: @14460
      GIM_Try, /*On fail goto*//*Label 521*/ 14504, // Rule ID 458 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7294:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMAXSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 458,
        GIR_Done,
      // Label 521: @14504
      GIM_Try, /*On fail goto*//*Label 522*/ 14548, // Rule ID 459 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmaxud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7298:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMAXUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMAXUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 522: @14548
      GIM_Try, /*On fail goto*//*Label 523*/ 14592, // Rule ID 460 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7305:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 523: @14592
      GIM_Try, /*On fail goto*//*Label 524*/ 14636, // Rule ID 461 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vminud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7309:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMINUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMINUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 524: @14636
      GIM_Try, /*On fail goto*//*Label 525*/ 14680, // Rule ID 464 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrld,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7364:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VRLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 525: @14680
      GIM_Try, /*On fail goto*//*Label 526*/ 14724, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddcuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7158:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VADDCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDCUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 526: @14724
      GIM_Try, /*On fail goto*//*Label 527*/ 14768, // Rule ID 473 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubcuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7400:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VSUBCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBCUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 527: @14768
      GIM_Try, /*On fail goto*//*Label 528*/ 14812, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7123:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VPMSUMB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 528: @14812
      GIM_Try, /*On fail goto*//*Label 529*/ 14856, // Rule ID 493 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7125:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VPMSUMH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 529: @14856
      GIM_Try, /*On fail goto*//*Label 530*/ 14900, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7126:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VPMSUMW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 530: @14900
      GIM_Try, /*On fail goto*//*Label 531*/ 14944, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vpmsumd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7124:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPMSUMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPMSUMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 531: @14944
      GIM_Try, /*On fail goto*//*Label 532*/ 14988, // Rule ID 503 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vbpermq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7175:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VBPERMQ:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VBPERMQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 532: @14988
      GIM_Try, /*On fail goto*//*Label 533*/ 15032, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vcipher,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7117:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCIPHER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 533: @15032
      GIM_Try, /*On fail goto*//*Label 534*/ 15076, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vcipherlast,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7118:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCIPHERLAST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 534: @15076
      GIM_Try, /*On fail goto*//*Label 535*/ 15120, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vncipher,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7119:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VNCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNCIPHER,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 535: @15120
      GIM_Try, /*On fail goto*//*Label 536*/ 15164, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vncipherlast,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7120:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VNCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNCIPHERLAST,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 536: @15164
      GIM_Try, /*On fail goto*//*Label 537*/ 15208, // Rule ID 542 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vbpermd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7174:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VBPERMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VBPERMD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 542,
        GIR_Done,
      // Label 537: @15208
      GIM_Try, /*On fail goto*//*Label 538*/ 15252, // Rule ID 543 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlwnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7372:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VRLWNM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLWNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 543,
        GIR_Done,
      // Label 538: @15252
      GIM_Try, /*On fail goto*//*Label 539*/ 15296, // Rule ID 545 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrldnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7366:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VRLDNM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLDNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 539: @15296
      GIM_Try, /*On fail goto*//*Label 540*/ 15340, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vslv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7380:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSLV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 540: @15340
      GIM_Try, /*On fail goto*//*Label 541*/ 15384, // Rule ID 548 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7390:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VSRV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 548,
        GIR_Done,
      // Label 541: @15384
      GIM_Try, /*On fail goto*//*Label 542*/ 15428, // Rule ID 549 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsdub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7155:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VABSDUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 549,
        GIR_Done,
      // Label 542: @15428
      GIM_Try, /*On fail goto*//*Label 543*/ 15472, // Rule ID 550 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsduh,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7156:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VABSDUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 550,
        GIR_Done,
      // Label 543: @15472
      GIM_Try, /*On fail goto*//*Label 544*/ 15516, // Rule ID 551 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vabsduw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7157:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VABSDUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VABSDUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 551,
        GIR_Done,
      // Label 544: @15516
      GIM_Try, /*On fail goto*//*Label 545*/ 15560, // Rule ID 1088 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpdepd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7342:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPDEPD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPDEPD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 545: @15560
      GIM_Try, /*On fail goto*//*Label 546*/ 15604, // Rule ID 1089 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpextd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7344:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPEXTD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPEXTD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 546: @15604
      GIM_Try, /*On fail goto*//*Label 547*/ 15648, // Rule ID 1090 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_pdepd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7601:{ *:[iPTR] }, i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (PDEPD:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PDEPD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 547: @15648
      GIM_Try, /*On fail goto*//*Label 548*/ 15692, // Rule ID 1091 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_pextd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7602:{ *:[iPTR] }, i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (PEXTD:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PEXTD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 548: @15692
      GIM_Try, /*On fail goto*//*Label 549*/ 15736, // Rule ID 1092 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vcfuged,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7177:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VCFUGED:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCFUGED,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 549: @15736
      GIM_Try, /*On fail goto*//*Label 550*/ 15780, // Rule ID 1094 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cfuged,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7438:{ *:[iPTR] }, i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (CFUGED:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CFUGED,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1094,
        GIR_Done,
      // Label 550: @15780
      GIM_Try, /*On fail goto*//*Label 551*/ 15824, // Rule ID 1096 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7181:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VCLZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1096,
        GIR_Done,
      // Label 551: @15824
      GIM_Try, /*On fail goto*//*Label 552*/ 15868, // Rule ID 1097 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vctzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7239:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VCTZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCTZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1097,
        GIR_Done,
      // Label 552: @15868
      GIM_Try, /*On fail goto*//*Label 553*/ 15912, // Rule ID 1098 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cntlzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7443:{ *:[iPTR] }, i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (CNTLZDM:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CNTLZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1098,
        GIR_Done,
      // Label 553: @15912
      GIM_Try, /*On fail goto*//*Label 554*/ 15956, // Rule ID 1099 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_cnttzdm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7444:{ *:[iPTR] }, i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)  =>  (CNTTZDM:{ *:[i64] } i64:{ *:[i64] }:$rS, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CNTTZDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1099,
        GIR_Done,
      // Label 554: @15956
      GIM_Try, /*On fail goto*//*Label 555*/ 16000, // Rule ID 1100 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclrlb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7179:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, i32:{ *:[i32] }:$rB)  =>  (VCLRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLRLB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1100,
        GIR_Done,
      // Label 555: @16000
      GIM_Try, /*On fail goto*//*Label 556*/ 16044, // Rule ID 1101 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vclrrb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7180:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, i32:{ *:[i32] }:$rB)  =>  (VCLRRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VCLRRB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1101,
        GIR_Done,
      // Label 556: @16044
      GIM_Try, /*On fail goto*//*Label 557*/ 16088, // Rule ID 1115 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7243:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VDIVESW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1115,
        GIR_Done,
      // Label 557: @16088
      GIM_Try, /*On fail goto*//*Label 558*/ 16132, // Rule ID 1116 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveuw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7246:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VDIVEUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1116,
        GIR_Done,
      // Label 558: @16132
      GIM_Try, /*On fail goto*//*Label 559*/ 16176, // Rule ID 1117 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7241:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VDIVESD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1117,
        GIR_Done,
      // Label 559: @16176
      GIM_Try, /*On fail goto*//*Label 560*/ 16220, // Rule ID 1118 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7244:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VDIVEUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1118,
        GIR_Done,
      // Label 560: @16220
      GIM_Try, /*On fail goto*//*Label 561*/ 16264, // Rule ID 1121 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulesd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7322:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULESD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULESD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1121,
        GIR_Done,
      // Label 561: @16264
      GIM_Try, /*On fail goto*//*Label 562*/ 16308, // Rule ID 1122 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuleud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7326:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULEUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULEUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1122,
        GIR_Done,
      // Label 562: @16308
      GIM_Try, /*On fail goto*//*Label 563*/ 16352, // Rule ID 1123 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmulosd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7334:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULOSD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1123,
        GIR_Done,
      // Label 563: @16352
      GIM_Try, /*On fail goto*//*Label 564*/ 16396, // Rule ID 1124 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmuloud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7338:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULOUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMULOUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1124,
        GIR_Done,
      // Label 564: @16396
      GIM_Try, /*On fail goto*//*Label 565*/ 16440, // Rule ID 1128 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdivesq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7242:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VDIVESQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVESQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1128,
        GIR_Done,
      // Label 565: @16440
      GIM_Try, /*On fail goto*//*Label 566*/ 16484, // Rule ID 1129 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vdiveuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7245:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VDIVEUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VDIVEUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1129,
        GIR_Done,
      // Label 566: @16484
      GIM_Try, /*On fail goto*//*Label 567*/ 16528, // Rule ID 1139 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlqnm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7369:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VRLQNM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLQNM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1139,
        GIR_Done,
      // Label 567: @16528
      GIM_Reject,
    // Label 419: @16529
    GIM_Try, /*On fail goto*//*Label 568*/ 18932,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 569*/ 16599, // Rule ID 999 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[f128] } 7486:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$vTi))  =>  (XSMSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 569: @16599
      GIM_Try, /*On fail goto*//*Label 570*/ 16651, // Rule ID 998 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[f128] } 7486:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vTi)  =>  (XSMADDQPO:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMADDQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 570: @16651
      GIM_Try, /*On fail goto*//*Label 571*/ 16701, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vshasigmaw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7129:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSHASIGMAW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 571: @16701
      GIM_Try, /*On fail goto*//*Label 572*/ 16751, // Rule ID 505 //
        GIM_CheckFeatures, GIFBS_HasP8Crypto,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_crypto_vshasigmad,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7128:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSHASIGMAD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SIX
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 572: @16751
      GIM_Try, /*On fail goto*//*Label 573*/ 16802, // Rule ID 1038 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsldbi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] SH
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7377:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SH)  =>  (VSLDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SH)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSLDBI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SH
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1038,
        GIR_Done,
      // Label 573: @16802
      GIM_Try, /*On fail goto*//*Label 574*/ 16853, // Rule ID 1039 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsrdbi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] SH
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7387:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SH)  =>  (VSRDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SH)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSRDBI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // VRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // VRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // VRB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // SH
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1039,
        GIR_Done,
      // Label 574: @16853
      GIM_Try, /*On fail goto*//*Label 575*/ 16904, // Rule ID 1044 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIM
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7285:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rB, (timm:{ *:[i32] }):$UIM)  =>  (VINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vDi, (timm:{ *:[i32] }):$UIM, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // UIM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1044,
        GIR_Done,
      // Label 575: @16904
      GIM_Try, /*On fail goto*//*Label 576*/ 16955, // Rule ID 1045 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // MIs[0] UIM
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7278:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vDi, i64:{ *:[i64] }:$rB, (timm:{ *:[i32] }):$UIM)  =>  (VINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vDi, (timm:{ *:[i32] }):$UIM, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // UIM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1045,
        GIR_Done,
      // Label 576: @16955
      GIM_Try, /*On fail goto*//*Label 577*/ 17007, // Rule ID 292 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmladduhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7312:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)  =>  (VMLADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMLADDUHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 292,
        GIR_Done,
      // Label 577: @17007
      GIM_Try, /*On fail goto*//*Label 578*/ 17059, // Rule ID 293 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vperm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7343:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v16i8:{ *:[v16i8] }:$vC)  =>  (VPERM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v16i8:{ *:[v16i8] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPERM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 293,
        GIR_Done,
      // Label 578: @17059
      GIM_Try, /*On fail goto*//*Label 579*/ 17111, // Rule ID 294 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsel,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7374:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VSEL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSEL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 294,
        GIR_Done,
      // Label 579: @17111
      GIM_Try, /*On fail goto*//*Label 580*/ 17163, // Rule ID 345 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsummbm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7314:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMMBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMMBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 345,
        GIR_Done,
      // Label 580: @17163
      GIM_Try, /*On fail goto*//*Label 581*/ 17215, // Rule ID 346 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumshm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7315:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMSHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMSHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 346,
        GIR_Done,
      // Label 581: @17215
      GIM_Try, /*On fail goto*//*Label 582*/ 17267, // Rule ID 347 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumubm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7317:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMUBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUBM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 582: @17267
      GIM_Try, /*On fail goto*//*Label 583*/ 17319, // Rule ID 348 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumuhm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7319:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMUHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUHM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 583: @17319
      GIM_Try, /*On fail goto*//*Label 584*/ 17371, // Rule ID 467 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddeuqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7161:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VADDEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDEUQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 467,
        GIR_Done,
      // Label 584: @17371
      GIM_Try, /*On fail goto*//*Label 585*/ 17423, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vaddecuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7160:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VADDECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VADDECUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 585: @17423
      GIM_Try, /*On fail goto*//*Label 586*/ 17475, // Rule ID 472 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubeuqm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7403:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VSUBEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBEUQM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 472,
        GIR_Done,
      // Label 586: @17475
      GIM_Try, /*On fail goto*//*Label 587*/ 17527, // Rule ID 474 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsubecuq,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7402:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VSUBECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUBECUQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 474,
        GIR_Done,
      // Label 587: @17527
      GIM_Try, /*On fail goto*//*Label 588*/ 17579, // Rule ID 511 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumudm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7318:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VMSUMUDM:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUDM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 588: @17579
      GIM_Try, /*On fail goto*//*Label 589*/ 17631, // Rule ID 544 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlwmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7371:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vDi)  =>  (VRLWMI:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLWMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 589: @17631
      GIM_Try, /*On fail goto*//*Label 590*/ 17683, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasP9Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrldmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7365:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v2i64:{ *:[v2i64] }:$vDi)  =>  (VRLDMI:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v2i64:{ *:[v2i64] }:$vDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLDMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 590: @17683
      GIM_Try, /*On fail goto*//*Label 591*/ 17735, // Rule ID 1046 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7276:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, v16i8:{ *:[v16i8] }:$vB)  =>  (VINSBVLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1046,
        GIR_Done,
      // Label 591: @17735
      GIM_Try, /*On fail goto*//*Label 592*/ 17787, // Rule ID 1047 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7277:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, v16i8:{ *:[v16i8] }:$vB)  =>  (VINSBVRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, v16i8:{ *:[v16i8] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1047,
        GIR_Done,
      // Label 592: @17787
      GIM_Try, /*On fail goto*//*Label 593*/ 17839, // Rule ID 1048 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7283:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, v8i16:{ *:[v8i16] }:$vB)  =>  (VINSHVLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1048,
        GIR_Done,
      // Label 593: @17839
      GIM_Try, /*On fail goto*//*Label 594*/ 17891, // Rule ID 1049 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7284:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, v8i16:{ *:[v8i16] }:$vB)  =>  (VINSHVRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1049,
        GIR_Done,
      // Label 594: @17891
      GIM_Try, /*On fail goto*//*Label 595*/ 17943, // Rule ID 1050 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7288:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, v4i32:{ *:[v4i32] }:$vB)  =>  (VINSWVLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1050,
        GIR_Done,
      // Label 595: @17943
      GIM_Try, /*On fail goto*//*Label 596*/ 17995, // Rule ID 1051 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7289:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, v4i32:{ *:[v4i32] }:$vB)  =>  (VINSWVRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1051,
        GIR_Done,
      // Label 596: @17995
      GIM_Try, /*On fail goto*//*Label 597*/ 18047, // Rule ID 1052 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsblx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7274:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSBLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1052,
        GIR_Done,
      // Label 597: @18047
      GIM_Try, /*On fail goto*//*Label 598*/ 18099, // Rule ID 1053 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsbrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 7275:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSBRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSBRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1053,
        GIR_Done,
      // Label 598: @18099
      GIM_Try, /*On fail goto*//*Label 599*/ 18151, // Rule ID 1054 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7281:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSHLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1054,
        GIR_Done,
      // Label 599: @18151
      GIM_Try, /*On fail goto*//*Label 600*/ 18203, // Rule ID 1055 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinshrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 7282:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSHRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSHRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1055,
        GIR_Done,
      // Label 600: @18203
      GIM_Try, /*On fail goto*//*Label 601*/ 18255, // Rule ID 1056 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7286:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSWLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1056,
        GIR_Done,
      // Label 601: @18255
      GIM_Try, /*On fail goto*//*Label 602*/ 18307, // Rule ID 1057 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinswrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 7287:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (VINSWRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vDi, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSWRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1057,
        GIR_Done,
      // Label 602: @18307
      GIM_Try, /*On fail goto*//*Label 603*/ 18359, // Rule ID 1058 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsdlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7279:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vDi, i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (VINSDLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vDi, i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSDLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1058,
        GIR_Done,
      // Label 603: @18359
      GIM_Try, /*On fail goto*//*Label 604*/ 18411, // Rule ID 1059 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vinsdrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7280:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vDi, i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (VINSDRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vDi, i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VINSDRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vDi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1059,
        GIR_Done,
      // Label 604: @18411
      GIM_Try, /*On fail goto*//*Label 605*/ 18463, // Rule ID 1080 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextdubvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7255:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUBVLX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUBVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1080,
        GIR_Done,
      // Label 605: @18463
      GIM_Try, /*On fail goto*//*Label 606*/ 18515, // Rule ID 1081 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextdubvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7256:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUBVRX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUBVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1081,
        GIR_Done,
      // Label 606: @18515
      GIM_Try, /*On fail goto*//*Label 607*/ 18567, // Rule ID 1082 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduhvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7257:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUHVLX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUHVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1082,
        GIR_Done,
      // Label 607: @18567
      GIM_Try, /*On fail goto*//*Label 608*/ 18619, // Rule ID 1083 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduhvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7258:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUHVRX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUHVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1083,
        GIR_Done,
      // Label 608: @18619
      GIM_Try, /*On fail goto*//*Label 609*/ 18671, // Rule ID 1084 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduwvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7259:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUWVLX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUWVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1084,
        GIR_Done,
      // Label 609: @18671
      GIM_Try, /*On fail goto*//*Label 610*/ 18723, // Rule ID 1085 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextduwvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7260:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDUWVRX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDUWVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1085,
        GIR_Done,
      // Label 610: @18723
      GIM_Try, /*On fail goto*//*Label 611*/ 18775, // Rule ID 1086 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextddvlx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7253:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDDVLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDDVLX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1086,
        GIR_Done,
      // Label 611: @18775
      GIM_Try, /*On fail goto*//*Label 612*/ 18827, // Rule ID 1087 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vextddvrx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 7254:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, i32:{ *:[i32] }:$rC)  =>  (VEXTDDVRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, i32:{ *:[i32] }:$rC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VEXTDDVRX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1087,
        GIR_Done,
      // Label 612: @18827
      GIM_Try, /*On fail goto*//*Label 613*/ 18879, // Rule ID 1125 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumcud,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7313:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v1i128:{ *:[v1i128] }:$vC)  =>  (VMSUMCUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB, v1i128:{ *:[v1i128] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMCUD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1125,
        GIR_Done,
      // Label 613: @18879
      GIM_Try, /*On fail goto*//*Label 614*/ 18931, // Rule ID 1140 //
        GIM_CheckFeatures, GIFBS_IsISA3_1,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vrlqmi,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i128] } 7368:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vDi)  =>  (VRLQMI:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB, v1i128:{ *:[v1i128] }:$vDi)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VRLQMI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vDi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1140,
        GIR_Done,
      // Label 614: @18931
      GIM_Reject,
    // Label 568: @18932
    GIM_Try, /*On fail goto*//*Label 615*/ 18994, // Rule ID 1095 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_vsx_xxeval,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // MIs[0] IMM
      GIM_CheckIsImm, /*MI*/0, /*Op*/5,
      // (intrinsic_wo_chain:{ *:[v2i64] } 7720:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)  =>  (XXEVAL:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XXEVAL,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XB
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // XC
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/5, // IMM
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1095,
      GIR_Done,
    // Label 615: @18994
    GIM_Reject,
    // Label 17: @18995
    GIM_Try, /*On fail goto*//*Label 616*/ 19285,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 617*/ 19018, // Rule ID 103 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_eieio,
        // (intrinsic_void 7475:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 103,
        GIR_Done,
      // Label 617: @19018
      GIM_Try, /*On fail goto*//*Label 618*/ 19041, // Rule ID 1173 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_sync,
        // (intrinsic_void 7624:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1173,
        GIR_Done,
      // Label 618: @19041
      GIM_Try, /*On fail goto*//*Label 619*/ 19064, // Rule ID 1174 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_sync,
        // (intrinsic_void 7508:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1174,
        GIR_Done,
      // Label 619: @19064
      GIM_Try, /*On fail goto*//*Label 620*/ 19087, // Rule ID 1175 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_lwsync,
        // (intrinsic_void 7513:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1175,
        GIR_Done,
      // Label 620: @19087
      GIM_Try, /*On fail goto*//*Label 621*/ 19110, // Rule ID 1176 //
        GIM_CheckFeatures, GIFBS_HasSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_lwsync,
        // (intrinsic_void 7507:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SYNC,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1176,
        GIR_Done,
      // Label 621: @19110
      GIM_Try, /*On fail goto*//*Label 622*/ 19130, // Rule ID 1177 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_sync,
        // (intrinsic_void 7624:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1177,
        GIR_Done,
      // Label 622: @19130
      GIM_Try, /*On fail goto*//*Label 623*/ 19150, // Rule ID 1178 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_sync,
        // (intrinsic_void 7508:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1178,
        GIR_Done,
      // Label 623: @19150
      GIM_Try, /*On fail goto*//*Label 624*/ 19170, // Rule ID 1179 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_lwsync,
        // (intrinsic_void 7513:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1179,
        GIR_Done,
      // Label 624: @19170
      GIM_Try, /*On fail goto*//*Label 625*/ 19190, // Rule ID 1180 //
        GIM_CheckFeatures, GIFBS_HasOnlyMSYNC,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_lwsync,
        // (intrinsic_void 7507:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MSYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1180,
        GIR_Done,
      // Label 625: @19190
      GIM_Try, /*On fail goto*//*Label 626*/ 19208, // Rule ID 1181 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_eieio,
        // (intrinsic_void 7475:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1181,
        GIR_Done,
      // Label 626: @19208
      GIM_Try, /*On fail goto*//*Label 627*/ 19226, // Rule ID 1182 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_iospace_eieio,
        // (intrinsic_void 7506:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::PseudoEIEIO,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1182,
        GIR_Done,
      // Label 627: @19226
      GIM_Try, /*On fail goto*//*Label 628*/ 19246, // Rule ID 1259 //
        GIM_CheckFeatures, GIFBS_IsAIX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dssall,
        // (intrinsic_void 7131:{ *:[iPTR] })  =>  (NOP)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::NOP,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1259,
        GIR_Done,
      // Label 628: @19246
      GIM_Try, /*On fail goto*//*Label 629*/ 19266, // Rule ID 1260 //
        GIM_CheckFeatures, GIFBS_NotAIX,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dssall,
        // (intrinsic_void 7131:{ *:[iPTR] })  =>  (DSSALL)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSSALL,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1260,
        GIR_Done,
      // Label 629: @19266
      GIM_Try, /*On fail goto*//*Label 630*/ 19284, // Rule ID 4797 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_isync,
        // (intrinsic_void 7509:{ *:[iPTR] })  =>  (ISYNC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ISYNC,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4797,
        GIR_Done,
      // Label 630: @19284
      GIM_Reject,
    // Label 616: @19285
    GIM_Try, /*On fail goto*//*Label 631*/ 19804,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 632*/ 19327, // Rule ID 265 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dss,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7130:{ *:[iPTR] }, (imm:{ *:[i32] }):$STRM)  =>  (DSS (imm:{ *:[i32] }):$STRM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSS,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 265,
        GIR_Done,
      // Label 632: @19327
      GIM_Try, /*On fail goto*//*Label 633*/ 19350, // Rule ID 190 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsb0,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 7589:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB0 (timm:{ *:[i32] }):$FM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSB0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 190,
        GIR_Done,
      // Label 633: @19350
      GIM_Try, /*On fail goto*//*Label 634*/ 19373, // Rule ID 191 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsb1,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 7590:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB1 (timm:{ *:[i32] }):$FM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSB1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 191,
        GIR_Done,
      // Label 634: @19373
      GIM_Try, /*On fail goto*//*Label 635*/ 19401, // Rule ID 274 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_mfvscr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7143:{ *:[iPTR] })  =>  (MFVSCR:{ *:[v8i16] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFVSCR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 635: @19401
      GIM_Try, /*On fail goto*//*Label 636*/ 19427, // Rule ID 1208 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_readflm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 7604:{ *:[iPTR] })  =>  (MFFS:{ *:[f64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFFS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 636: @19427
      GIM_Try, /*On fail goto*//*Label 637*/ 19485, // Rule ID 1539 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darn32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 7452:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (DARN:{ *:[i64] } 0:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::DARN,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::GPRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::G8RCRegClassID,
        // GIR_Coverage, 1539,
        GIR_Done,
      // Label 637: @19485
      GIM_Try, /*On fail goto*//*Label 638*/ 19520, // Rule ID 1540 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7451:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DARN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1540,
        GIR_Done,
      // Label 638: @19520
      GIM_Try, /*On fail goto*//*Label 639*/ 19555, // Rule ID 1541 //
        GIM_CheckFeatures, GIFBS_IsISA3_0,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_darnraw,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7453:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 2:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DARN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1541,
        GIR_Done,
      // Label 639: @19555
      GIM_Try, /*On fail goto*//*Label 640*/ 19587, // Rule ID 2859 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_tcheck,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 7631:{ *:[iPTR] })  =>  (TCHECK_RET:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::TCHECK_RET,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // out
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2859,
        GIR_Done,
      // Label 640: @19587
      GIM_Try, /*On fail goto*//*Label 641*/ 19622, // Rule ID 2863 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_texasr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7500:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 130:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/130,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2863,
        GIR_Done,
      // Label 641: @19622
      GIM_Try, /*On fail goto*//*Label 642*/ 19657, // Rule ID 2864 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_texasru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7501:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 131:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/131,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2864,
        GIR_Done,
      // Label 642: @19657
      GIM_Try, /*On fail goto*//*Label 643*/ 19692, // Rule ID 2865 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_tfhar,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7502:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 128:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/128,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2865,
        GIR_Done,
      // Label 643: @19692
      GIM_Try, /*On fail goto*//*Label 644*/ 19727, // Rule ID 2866 //
        GIM_CheckFeatures, GIFBS_HasHTM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_get_tfiar,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (intrinsic_w_chain:{ *:[i64] } 7503:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 129:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MFSPR8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_AddImm, /*InsnID*/0, /*Imm*/129,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2866,
        GIR_Done,
      // Label 644: @19727
      GIM_Try, /*On fail goto*//*Label 645*/ 19753, // Rule ID 186 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::set_loop_iterations,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        // (intrinsic_void 269:{ *:[iPTR] }, i32:{ *:[i32] }:$rS)  =>  (MTCTRloop:{ *:[i32] } i32:{ *:[i32] }:$rS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTCTRloop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 186,
        GIR_Done,
      // Label 645: @19753
      GIM_Try, /*On fail goto*//*Label 646*/ 19777, // Rule ID 275 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_mtvscr,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
        // (intrinsic_void 7144:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vB)  =>  (MTVSCR v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTVSCR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 275,
        GIR_Done,
      // Label 646: @19777
      GIM_Try, /*On fail goto*//*Label 647*/ 19803, // Rule ID 629 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::set_loop_iterations,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 269:{ *:[iPTR] }, i64:{ *:[i64] }:$rS)  =>  (MTCTR8loop:{ *:[i64] } i64:{ *:[i64] }:$rS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTCTR8loop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 629,
        GIR_Done,
      // Label 647: @19803
      GIM_Reject,
    // Label 631: @19804
    GIM_Try, /*On fail goto*//*Label 648*/ 20096,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 649*/ 19839, // Rule ID 1151 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsfi,
        // MIs[0] BF
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] U
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 7592:{ *:[iPTR] }, (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)  =>  (MTFSFIb (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSFIb,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // BF
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // U
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1151,
        GIR_Done,
      // Label 649: @19839
      GIM_Try, /*On fail goto*//*Label 650*/ 19886, // Rule ID 12 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setrnd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[f64] } 7613:{ *:[iPTR] }, (imm:{ *:[i32] }):$RND)  =>  (SETRNDi:{ *:[f64] } (imm:{ *:[i32] }):$RND)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETRNDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // RND
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 12,
        GIR_Done,
      // Label 650: @19886
      GIM_Try, /*On fail goto*//*Label 651*/ 19933, // Rule ID 187 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::loop_decrement,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i1] } 178:{ *:[iPTR] }, (imm:{ *:[i32] }):$stride)  =>  (DecreaseCTRloop:{ *:[i1] }:{ *:[i32] } (imm:{ *:[i32] }):$stride)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DecreaseCTRloop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 187,
        GIR_Done,
      // Label 651: @19933
      GIM_Try, /*On fail goto*//*Label 652*/ 19980, // Rule ID 630 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::loop_decrement,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i1] } 178:{ *:[iPTR] }, (imm:{ *:[i64] }):$stride)  =>  (DecreaseCTR8loop:{ *:[i1] }:{ *:[i64] } (imm:{ *:[i64] }):$stride)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DecreaseCTR8loop,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 630,
        GIR_Done,
      // Label 652: @19980
      GIM_Try, /*On fail goto*//*Label 653*/ 20011, // Rule ID 192 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_mtfsf,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 7591:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$rT)  =>  (MTFSFb (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$rT)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::MTFSFb,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rT
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 192,
        GIR_Done,
      // Label 653: @20011
      GIM_Try, /*On fail goto*//*Label 654*/ 20053, // Rule ID 13 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setrnd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::GPRCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 7613:{ *:[iPTR] }, gprc:{ *:[i32] }:$in)  =>  (SETRND:{ *:[f64] } gprc:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETRND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // in
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 13,
        GIR_Done,
      // Label 654: @20053
      GIM_Try, /*On fail goto*//*Label 655*/ 20095, // Rule ID 14 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_setflm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/PPC::F8RCRegClassID,
        // (intrinsic_w_chain:{ *:[f64] } 7612:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FLM)  =>  (SETFLM:{ *:[f64] } f8rc:{ *:[f64] }:$FLM)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SETFLM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FLM
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 14,
        GIR_Done,
      // Label 655: @20095
      GIM_Reject,
    // Label 648: @20096
    GIM_Try, /*On fail goto*//*Label 656*/ 21142,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 657*/ 20154, // Rule ID 266 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7132:{ *:[iPTR] }, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DST,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 266,
        GIR_Done,
      // Label 657: @20154
      GIM_Try, /*On fail goto*//*Label 658*/ 20207, // Rule ID 267 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7135:{ *:[iPTR] }, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTT,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 267,
        GIR_Done,
      // Label 658: @20207
      GIM_Try, /*On fail goto*//*Label 659*/ 20260, // Rule ID 268 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7133:{ *:[iPTR] }, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTST,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 268,
        GIR_Done,
      // Label 659: @20260
      GIM_Try, /*On fail goto*//*Label 660*/ 20313, // Rule ID 269 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dststt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7134:{ *:[iPTR] }, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTSTT,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 269,
        GIR_Done,
      // Label 660: @20313
      GIM_Try, /*On fail goto*//*Label 661*/ 20366, // Rule ID 270 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7132:{ *:[iPTR] }, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DST64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 270,
        GIR_Done,
      // Label 661: @20366
      GIM_Try, /*On fail goto*//*Label 662*/ 20419, // Rule ID 271 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7135:{ *:[iPTR] }, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTT64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 271,
        GIR_Done,
      // Label 662: @20419
      GIM_Try, /*On fail goto*//*Label 663*/ 20472, // Rule ID 272 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dstst,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7133:{ *:[iPTR] }, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTST64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 272,
        GIR_Done,
      // Label 663: @20472
      GIM_Try, /*On fail goto*//*Label 664*/ 20525, // Rule ID 273 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::ppc_altivec_dststt,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] rA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 7134:{ *:[iPTR] }, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$rA, i32:{ *:[i32] }:$rB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::DSTSTT64,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rB
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 273,
        GIR_Done,
      // Label 664: @20525
      GIM_Try, /*On fail goto*//*Label 665*/ 20569, // Rule ID 376 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsumsws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7414:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUMSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUMSWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 376,
        GIR_Done,
      // Label 665: @20569
      GIM_Try, /*On fail goto*//*Label 666*/ 20613, // Rule ID 377 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum2sws,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7410:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUM2SWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM2SWS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 377,
        GIR_Done,
      // Label 666: @20613
      GIM_Try, /*On fail goto*//*Label 667*/ 20657, // Rule ID 378 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4sbs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7411:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUM4SBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4SBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 378,
        GIR_Done,
      // Label 667: @20657
      GIM_Try, /*On fail goto*//*Label 668*/ 20701, // Rule ID 379 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4shs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7412:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUM4SHS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4SHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 379,
        GIR_Done,
      // Label 668: @20701
      GIM_Try, /*On fail goto*//*Label 669*/ 20745, // Rule ID 380 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vsum4ubs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7413:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VSUM4UBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VSUM4UBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 380,
        GIR_Done,
      // Label 669: @20745
      GIM_Try, /*On fail goto*//*Label 670*/ 20789, // Rule ID 407 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkshss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7348:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VPKSHSS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSHSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 407,
        GIR_Done,
      // Label 670: @20789
      GIM_Try, /*On fail goto*//*Label 671*/ 20833, // Rule ID 408 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkshus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7349:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VPKSHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSHUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 408,
        GIR_Done,
      // Label 671: @20833
      GIM_Try, /*On fail goto*//*Label 672*/ 20877, // Rule ID 409 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkswss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7350:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VPKSWSS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSWSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 409,
        GIR_Done,
      // Label 672: @20877
      GIM_Try, /*On fail goto*//*Label 673*/ 20921, // Rule ID 410 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkswus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7351:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VPKSWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSWUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 410,
        GIR_Done,
      // Label 673: @20921
      GIM_Try, /*On fail goto*//*Label 674*/ 20965, // Rule ID 411 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkuhus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v16i8] } 7353:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VPKUHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKUHUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 411,
        GIR_Done,
      // Label 674: @20965
      GIM_Try, /*On fail goto*//*Label 675*/ 21009, // Rule ID 412 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkuwus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7354:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VPKUWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKUWUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 412,
        GIR_Done,
      // Label 675: @21009
      GIM_Try, /*On fail goto*//*Label 676*/ 21053, // Rule ID 496 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpksdss,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7346:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPKSDSS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSDSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 676: @21053
      GIM_Try, /*On fail goto*//*Label 677*/ 21097, // Rule ID 497 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpksdus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7347:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPKSDUS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKSDUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 677: @21097
      GIM_Try, /*On fail goto*//*Label 678*/ 21141, // Rule ID 498 //
        GIM_CheckFeatures, GIFBS_HasP8Altivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vpkudus,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7352:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VPKUDUS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VPKUDUS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 678: @21141
      GIM_Reject,
    // Label 656: @21142
    GIM_Try, /*On fail goto*//*Label 679*/ 21405,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 680*/ 21196, // Rule ID 754 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_addex,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // MIs[0] CY
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_w_chain:{ *:[i64] } 7115:{ *:[iPTR] }, i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB, (timm:{ *:[i32] }):$CY)  =>  (ADDEX8:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB, (timm:{ *:[i32] }):$CY)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ADDEX8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // CY
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 680: @21196
      GIM_Try, /*On fail goto*//*Label 681*/ 21248, // Rule ID 290 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmhaddshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7301:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)  =>  (VMHADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMHADDSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 290,
        GIR_Done,
      // Label 681: @21248
      GIM_Try, /*On fail goto*//*Label 682*/ 21300, // Rule ID 291 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmhraddshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v8i16] } 7302:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)  =>  (VMHRADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v8i16:{ *:[v8i16] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMHRADDSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 291,
        GIR_Done,
      // Label 682: @21300
      GIM_Try, /*On fail goto*//*Label 683*/ 21352, // Rule ID 349 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumshs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7316:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMSHS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMSHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 683: @21352
      GIM_Try, /*On fail goto*//*Label 684*/ 21404, // Rule ID 350 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::ppc_altivec_vmsumuhs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (intrinsic_w_chain:{ *:[v4i32] } 7320:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)  =>  (VMSUMUHS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB, v4i32:{ *:[v4i32] }:$vC)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VMSUMUHS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // vC
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 350,
        GIR_Done,
      // Label 684: @21404
      GIM_Reject,
    // Label 679: @21405
    GIM_Reject,
    // Label 18: @21406
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 687*/ 24478,
    /*GILLT_s32*//*Label 685*/ 21414,
    /*GILLT_s64*//*Label 686*/ 22946,
    // Label 685: @21414
    GIM_Try, /*On fail goto*//*Label 688*/ 22945,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 689*/ 21546, // Rule ID 3965 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3965,
        GIR_Done,
      // Label 689: @21546
      GIM_Try, /*On fail goto*//*Label 690*/ 21668, // Rule ID 3997 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3997,
        GIR_Done,
      // Label 690: @21668
      GIM_Try, /*On fail goto*//*Label 691*/ 21790, // Rule ID 4029 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4029,
        GIR_Done,
      // Label 691: @21790
      GIM_Try, /*On fail goto*//*Label 692*/ 21912, // Rule ID 4061 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4061,
        GIR_Done,
      // Label 692: @21912
      GIM_Try, /*On fail goto*//*Label 693*/ 22034, // Rule ID 4077 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4077,
        GIR_Done,
      // Label 693: @22034
      GIM_Try, /*On fail goto*//*Label 694*/ 22156, // Rule ID 4109 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4109,
        GIR_Done,
      // Label 694: @22156
      GIM_Try, /*On fail goto*//*Label 695*/ 22278, // Rule ID 4141 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4141,
        GIR_Done,
      // Label 695: @22278
      GIM_Try, /*On fail goto*//*Label 696*/ 22400, // Rule ID 4173 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4173,
        GIR_Done,
      // Label 696: @22400
      GIM_Try, /*On fail goto*//*Label 697*/ 22522, // Rule ID 4203 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4203,
        GIR_Done,
      // Label 697: @22522
      GIM_Try, /*On fail goto*//*Label 698*/ 22644, // Rule ID 4235 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4235,
        GIR_Done,
      // Label 698: @22644
      GIM_Try, /*On fail goto*//*Label 699*/ 22766, // Rule ID 4267 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4267,
        GIR_Done,
      // Label 699: @22766
      GIM_Try, /*On fail goto*//*Label 700*/ 22888, // Rule ID 4299 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4299,
        GIR_Done,
      // Label 700: @22888
      GIM_Try, /*On fail goto*//*Label 701*/ 22944, // Rule ID 3614 //
        // (anyext:{ *:[i32] } i1:{ *:[i1] }:$in)  =>  (SELECT_I4:{ *:[i32] } crbitrc:{ *:[i1] }:$in, (LI:{ *:[i32] } 1:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3614,
        GIR_Done,
      // Label 701: @22944
      GIM_Reject,
    // Label 688: @22945
    GIM_Reject,
    // Label 686: @22946
    GIM_Try, /*On fail goto*//*Label 702*/ 24477,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 703*/ 23078, // Rule ID 3967 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3967,
        GIR_Done,
      // Label 703: @23078
      GIM_Try, /*On fail goto*//*Label 704*/ 23200, // Rule ID 3999 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3999,
        GIR_Done,
      // Label 704: @23200
      GIM_Try, /*On fail goto*//*Label 705*/ 23322, // Rule ID 4031 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4031,
        GIR_Done,
      // Label 705: @23322
      GIM_Try, /*On fail goto*//*Label 706*/ 23444, // Rule ID 4063 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4063,
        GIR_Done,
      // Label 706: @23444
      GIM_Try, /*On fail goto*//*Label 707*/ 23566, // Rule ID 4079 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4079,
        GIR_Done,
      // Label 707: @23566
      GIM_Try, /*On fail goto*//*Label 708*/ 23688, // Rule ID 4111 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4111,
        GIR_Done,
      // Label 708: @23688
      GIM_Try, /*On fail goto*//*Label 709*/ 23810, // Rule ID 4143 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4143,
        GIR_Done,
      // Label 709: @23810
      GIM_Try, /*On fail goto*//*Label 710*/ 23932, // Rule ID 4175 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4175,
        GIR_Done,
      // Label 710: @23932
      GIM_Try, /*On fail goto*//*Label 711*/ 24054, // Rule ID 4205 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4205,
        GIR_Done,
      // Label 711: @24054
      GIM_Try, /*On fail goto*//*Label 712*/ 24176, // Rule ID 4237 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4237,
        GIR_Done,
      // Label 712: @24176
      GIM_Try, /*On fail goto*//*Label 713*/ 24298, // Rule ID 4269 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4269,
        GIR_Done,
      // Label 713: @24298
      GIM_Try, /*On fail goto*//*Label 714*/ 24420, // Rule ID 4301 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (anyext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4301,
        GIR_Done,
      // Label 714: @24420
      GIM_Try, /*On fail goto*//*Label 715*/ 24476, // Rule ID 3615 //
        // (anyext:{ *:[i64] } i1:{ *:[i1] }:$in)  =>  (SELECT_I8:{ *:[i64] } crbitrc:{ *:[i1] }:$in, (LI8:{ *:[i64] } 1:{ *:[i64] }), (LI8:{ *:[i64] } 0:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3615,
        GIR_Done,
      // Label 715: @24476
      GIM_Reject,
    // Label 702: @24477
    GIM_Reject,
    // Label 687: @24478
    GIM_Reject,
    // Label 19: @24479
    GIM_Try, /*On fail goto*//*Label 716*/ 24618,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/1, 3, /*)*//*default:*//*Label 719*/ 24581,
      /*GILLT_s32*//*Label 717*/ 24493,
      /*GILLT_s64*//*Label 718*/ 24537,
      // Label 717: @24493
      GIM_Try, /*On fail goto*//*Label 720*/ 24536, // Rule ID 1147 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (trunc:{ *:[i1] } (xor:{ *:[i32] } i32:{ *:[i32] }:$in, -1:{ *:[i32] }))  =>  (ANDI_rec_1_EQ_BIT:{ *:[i1] } i32:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDI_rec_1_EQ_BIT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1147,
        GIR_Done,
      // Label 720: @24536
      GIM_Reject,
      // Label 718: @24537
      GIM_Try, /*On fail goto*//*Label 721*/ 24580, // Rule ID 1149 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (trunc:{ *:[i1] } (xor:{ *:[i64] } i64:{ *:[i64] }:$in, -1:{ *:[i64] }))  =>  (ANDI_rec_1_EQ_BIT8:{ *:[i1] } i64:{ *:[i64] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::ANDI_rec_1_EQ_BIT8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1149,
        GIR_Done,
      // Label 721: @24580
      GIM_Reject,
      // Label 719: @24581
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/1, 3, /*)*//*default:*//*Label 724*/ 24617,
      /*GILLT_s32*//*Label 722*/ 24589,
      /*GILLT_s64*//*Label 723*/ 24603,
      // Label 722: @24589
      GIM_Try, /*On fail goto*//*Label 725*/ 24602, // Rule ID 1148 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        // (trunc:{ *:[i1] } i32:{ *:[i32] }:$in)  =>  (ANDI_rec_1_GT_BIT:{ *:[i1] } i32:{ *:[i32] }:$in)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ANDI_rec_1_GT_BIT,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1148,
        GIR_Done,
      // Label 725: @24602
      GIM_Reject,
      // Label 723: @24603
      GIM_Try, /*On fail goto*//*Label 726*/ 24616, // Rule ID 1150 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
        // (trunc:{ *:[i1] } i64:{ *:[i64] }:$in)  =>  (ANDI_rec_1_GT_BIT8:{ *:[i1] } i64:{ *:[i64] }:$in)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::ANDI_rec_1_GT_BIT8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1150,
        GIR_Done,
      // Label 726: @24616
      GIM_Reject,
      // Label 724: @24617
      GIM_Reject,
    // Label 716: @24618
    GIM_Reject,
    // Label 20: @24619
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 3, /*)*//*default:*//*Label 730*/ 24740,
    /*GILLT_s1*//*Label 727*/ 24628,
    /*GILLT_s32*//*Label 728*/ 24690,
    /*GILLT_s64*//*Label 729*/ 24715,
    // Label 727: @24628
    GIM_Try, /*On fail goto*//*Label 731*/ 24689,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 732*/ 24652, // Rule ID 181 //
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, 1,
        // 1:{ *:[i1] }  =>  (CRSET:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRSET,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 732: @24652
      GIM_Try, /*On fail goto*//*Label 733*/ 24670, // Rule ID 182 //
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, 0,
        // 0:{ *:[i1] }  =>  (CRUNSET:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRUNSET,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 182,
        GIR_Done,
      // Label 733: @24670
      GIM_Try, /*On fail goto*//*Label 734*/ 24688, // Rule ID 3609 //
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, -1,
        // -1:{ *:[i1] }  =>  (CRSET:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRSET,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3609,
        GIR_Done,
      // Label 734: @24688
      GIM_Reject,
    // Label 731: @24689
    GIM_Reject,
    // Label 728: @24690
    GIM_Try, /*On fail goto*//*Label 735*/ 24714, // Rule ID 110 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIPFP_I64_Predicate_imm32SExt16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm  =>  (LI:{ *:[i32] } (imm:{ *:[i32] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::LI,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 110,
      GIR_Done,
    // Label 735: @24714
    GIM_Reject,
    // Label 729: @24715
    GIM_Try, /*On fail goto*//*Label 736*/ 24739, // Rule ID 635 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIPFP_I64_Predicate_imm64SExt16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm  =>  (LI8:{ *:[i64] } (imm:{ *:[i64] }):$imm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::LI8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rD
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 635,
      GIR_Done,
    // Label 736: @24739
    GIM_Reject,
    // Label 730: @24740
    GIM_Reject,
    // Label 21: @24741
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 739*/ 27803,
    /*GILLT_s32*//*Label 737*/ 24749,
    /*GILLT_s64*//*Label 738*/ 26225,
    // Label 737: @24749
    GIM_Try, /*On fail goto*//*Label 740*/ 26224,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 741*/ 24881, // Rule ID 3959 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3959,
        GIR_Done,
      // Label 741: @24881
      GIM_Try, /*On fail goto*//*Label 742*/ 25003, // Rule ID 3991 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3991,
        GIR_Done,
      // Label 742: @25003
      GIM_Try, /*On fail goto*//*Label 743*/ 25125, // Rule ID 4023 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4023,
        GIR_Done,
      // Label 743: @25125
      GIM_Try, /*On fail goto*//*Label 744*/ 25247, // Rule ID 4055 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4055,
        GIR_Done,
      // Label 744: @25247
      GIM_Try, /*On fail goto*//*Label 745*/ 25369, // Rule ID 4071 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4071,
        GIR_Done,
      // Label 745: @25369
      GIM_Try, /*On fail goto*//*Label 746*/ 25491, // Rule ID 4103 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4103,
        GIR_Done,
      // Label 746: @25491
      GIM_Try, /*On fail goto*//*Label 747*/ 25613, // Rule ID 4135 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4135,
        GIR_Done,
      // Label 747: @25613
      GIM_Try, /*On fail goto*//*Label 748*/ 25735, // Rule ID 4167 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4167,
        GIR_Done,
      // Label 748: @25735
      GIM_Try, /*On fail goto*//*Label 749*/ 25857, // Rule ID 4197 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4197,
        GIR_Done,
      // Label 749: @25857
      GIM_Try, /*On fail goto*//*Label 750*/ 25979, // Rule ID 4229 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4229,
        GIR_Done,
      // Label 750: @25979
      GIM_Try, /*On fail goto*//*Label 751*/ 26101, // Rule ID 4261 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4261,
        GIR_Done,
      // Label 751: @26101
      GIM_Try, /*On fail goto*//*Label 752*/ 26223, // Rule ID 4293 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } -1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4293,
        GIR_Done,
      // Label 752: @26223
      GIM_Reject,
    // Label 740: @26224
    GIM_Reject,
    // Label 738: @26225
    GIM_Try, /*On fail goto*//*Label 753*/ 26355, // Rule ID 3963 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3963,
      GIR_Done,
    // Label 753: @26355
    GIM_Try, /*On fail goto*//*Label 754*/ 26485, // Rule ID 3995 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3995,
      GIR_Done,
    // Label 754: @26485
    GIM_Try, /*On fail goto*//*Label 755*/ 26615, // Rule ID 4027 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4027,
      GIR_Done,
    // Label 755: @26615
    GIM_Try, /*On fail goto*//*Label 756*/ 26745, // Rule ID 4059 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4059,
      GIR_Done,
    // Label 756: @26745
    GIM_Try, /*On fail goto*//*Label 757*/ 26875, // Rule ID 4075 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4075,
      GIR_Done,
    // Label 757: @26875
    GIM_Try, /*On fail goto*//*Label 758*/ 27005, // Rule ID 4107 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4107,
      GIR_Done,
    // Label 758: @27005
    GIM_Try, /*On fail goto*//*Label 759*/ 27135, // Rule ID 4139 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4139,
      GIR_Done,
    // Label 759: @27135
    GIM_Try, /*On fail goto*//*Label 760*/ 27265, // Rule ID 4171 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4171,
      GIR_Done,
    // Label 760: @27265
    GIM_Try, /*On fail goto*//*Label 761*/ 27395, // Rule ID 4201 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4201,
      GIR_Done,
    // Label 761: @27395
    GIM_Try, /*On fail goto*//*Label 762*/ 27525, // Rule ID 4233 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4233,
      GIR_Done,
    // Label 762: @27525
    GIM_Try, /*On fail goto*//*Label 763*/ 27655, // Rule ID 4265 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4265,
      GIR_Done,
    // Label 763: @27655
    GIM_Try, /*On fail goto*//*Label 764*/ 27785, // Rule ID 4297 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
      // MIs[1] Operand 1
      GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } -1:{ *:[i64] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/4, /*Imm*/-1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/3, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4297,
      GIR_Done,
    // Label 764: @27785
    GIM_Try, /*On fail goto*//*Label 765*/ 27802, // Rule ID 676 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (sext:{ *:[i64] } i32:{ *:[i32] }:$rS)  =>  (EXTSW_32_64:{ *:[i64] } i32:{ *:[i32] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EXTSW_32_64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 676,
      GIR_Done,
    // Label 765: @27802
    GIM_Reject,
    // Label 739: @27803
    GIM_Reject,
    // Label 22: @27804
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 768*/ 30764,
    /*GILLT_s32*//*Label 766*/ 27812,
    /*GILLT_s64*//*Label 767*/ 29288,
    // Label 766: @27812
    GIM_Try, /*On fail goto*//*Label 769*/ 29287,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 770*/ 27944, // Rule ID 3957 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3957,
        GIR_Done,
      // Label 770: @27944
      GIM_Try, /*On fail goto*//*Label 771*/ 28066, // Rule ID 3989 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3989,
        GIR_Done,
      // Label 771: @28066
      GIM_Try, /*On fail goto*//*Label 772*/ 28188, // Rule ID 4021 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4021,
        GIR_Done,
      // Label 772: @28188
      GIM_Try, /*On fail goto*//*Label 773*/ 28310, // Rule ID 4053 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4053,
        GIR_Done,
      // Label 773: @28310
      GIM_Try, /*On fail goto*//*Label 774*/ 28432, // Rule ID 4069 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4069,
        GIR_Done,
      // Label 774: @28432
      GIM_Try, /*On fail goto*//*Label 775*/ 28554, // Rule ID 4101 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4101,
        GIR_Done,
      // Label 775: @28554
      GIM_Try, /*On fail goto*//*Label 776*/ 28676, // Rule ID 4133 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4133,
        GIR_Done,
      // Label 776: @28676
      GIM_Try, /*On fail goto*//*Label 777*/ 28798, // Rule ID 4165 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4165,
        GIR_Done,
      // Label 777: @28798
      GIM_Try, /*On fail goto*//*Label 778*/ 28920, // Rule ID 4195 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4195,
        GIR_Done,
      // Label 778: @28920
      GIM_Try, /*On fail goto*//*Label 779*/ 29042, // Rule ID 4227 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4227,
        GIR_Done,
      // Label 779: @29042
      GIM_Try, /*On fail goto*//*Label 780*/ 29164, // Rule ID 4259 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4259,
        GIR_Done,
      // Label 780: @29164
      GIM_Try, /*On fail goto*//*Label 781*/ 29286, // Rule ID 4291 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i32] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I4:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI:{ *:[i32] } 0:{ *:[i32] }), (LI:{ *:[i32] } 1:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4291,
        GIR_Done,
      // Label 781: @29286
      GIM_Reject,
    // Label 769: @29287
    GIM_Reject,
    // Label 767: @29288
    GIM_Try, /*On fail goto*//*Label 782*/ 30763,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_Try, /*On fail goto*//*Label 783*/ 29420, // Rule ID 3961 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3961,
        GIR_Done,
      // Label 783: @29420
      GIM_Try, /*On fail goto*//*Label 784*/ 29542, // Rule ID 3993 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3993,
        GIR_Done,
      // Label 784: @29542
      GIM_Try, /*On fail goto*//*Label 785*/ 29664, // Rule ID 4025 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4025,
        GIR_Done,
      // Label 785: @29664
      GIM_Try, /*On fail goto*//*Label 786*/ 29786, // Rule ID 4057 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4057,
        GIR_Done,
      // Label 786: @29786
      GIM_Try, /*On fail goto*//*Label 787*/ 29908, // Rule ID 4073 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4073,
        GIR_Done,
      // Label 787: @29908
      GIM_Try, /*On fail goto*//*Label 788*/ 30030, // Rule ID 4105 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4105,
        GIR_Done,
      // Label 788: @30030
      GIM_Try, /*On fail goto*//*Label 789*/ 30152, // Rule ID 4137 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4137,
        GIR_Done,
      // Label 789: @30152
      GIM_Try, /*On fail goto*//*Label 790*/ 30274, // Rule ID 4169 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4169,
        GIR_Done,
      // Label 790: @30274
      GIM_Try, /*On fail goto*//*Label 791*/ 30396, // Rule ID 4199 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4199,
        GIR_Done,
      // Label 791: @30396
      GIM_Try, /*On fail goto*//*Label 792*/ 30518, // Rule ID 4231 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4231,
        GIR_Done,
      // Label 792: @30518
      GIM_Try, /*On fail goto*//*Label 793*/ 30640, // Rule ID 4263 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4263,
        GIR_Done,
      // Label 793: @30640
      GIM_Try, /*On fail goto*//*Label 794*/ 30762, // Rule ID 4295 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FCMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] }))  =>  (SELECT_I8:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }), (LI8:{ *:[i64] } 0:{ *:[i64] }), (LI8:{ *:[i64] } 1:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // s1
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/3, // s2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/4, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/PPC::LI8,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4295,
        GIR_Done,
      // Label 794: @30762
      GIM_Reject,
    // Label 782: @30763
    GIM_Reject,
    // Label 768: @30764
    GIM_Reject,
    // Label 23: @30765
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 797*/ 30859,
    /*GILLT_s32*//*Label 795*/ 30773,
    /*GILLT_s64*//*Label 796*/ 30816,
    // Label 795: @30773
    GIM_Try, /*On fail goto*//*Label 798*/ 30815, // Rule ID 129 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      // MIs[1] Operand 1
      // No operand predicates
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sra:{ *:[i32] } i32:{ *:[i32] }:$rS, (imm:{ *:[i32] }):$SH)  =>  (SRAWI:{ *:[i32] }:{ *:[i32] } i32:{ *:[i32] }:$rS, (imm:{ *:[i32] }):$SH)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SRAWI,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SH
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 129,
      GIR_Done,
    // Label 798: @30815
    GIM_Reject,
    // Label 796: @30816
    GIM_Try, /*On fail goto*//*Label 799*/ 30858, // Rule ID 677 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
      // MIs[1] Operand 1
      // No operand predicates
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (sra:{ *:[i64] } i64:{ *:[i64] }:$rS, (imm:{ *:[i32] }):$SH)  =>  (SRADI:{ *:[i64] }:{ *:[i32] } i64:{ *:[i64] }:$rS, (imm:{ *:[i32] }):$SH)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::SRADI,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rS
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SH
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 677,
      GIR_Done,
    // Label 799: @30858
    GIM_Reject,
    // Label 797: @30859
    GIM_Reject,
    // Label 24: @30860
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/3, 8, /*)*//*default:*//*Label 805*/ 30991,
    /*GILLT_s128*//*Label 800*/ 30871,
    /*GILLT_v2s64*//*Label 801*/ 30895,
    /*GILLT_v4s32*//*Label 802*/ 30919,
    /*GILLT_v8s16*//*Label 803*/ 30943,
    /*GILLT_v16s8*//*Label 804*/ 30967,
    // Label 800: @30871
    GIM_Try, /*On fail goto*//*Label 806*/ 30894, // Rule ID 3328 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (rotl:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)  =>  (VRLQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$vA, v1i128:{ *:[v1i128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRLQ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3328,
      GIR_Done,
    // Label 806: @30894
    GIM_Reject,
    // Label 801: @30895
    GIM_Try, /*On fail goto*//*Label 807*/ 30918, // Rule ID 1409 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (rotl:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VRLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRLD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1409,
      GIR_Done,
    // Label 807: @30918
    GIM_Reject,
    // Label 802: @30919
    GIM_Try, /*On fail goto*//*Label 808*/ 30942, // Rule ID 1263 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (rotl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VRLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRLW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1263,
      GIR_Done,
    // Label 808: @30942
    GIM_Reject,
    // Label 803: @30943
    GIM_Try, /*On fail goto*//*Label 809*/ 30966, // Rule ID 1262 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (rotl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VRLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRLH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1262,
      GIR_Done,
    // Label 809: @30966
    GIM_Reject,
    // Label 804: @30967
    GIM_Try, /*On fail goto*//*Label 810*/ 30990, // Rule ID 1261 //
      GIM_CheckFeatures, GIFBS_HasAltivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (rotl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)  =>  (VRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VRLB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1261,
      GIR_Done,
    // Label 810: @30990
    GIM_Reject,
    // Label 805: @30991
    GIM_Reject,
    // Label 25: @30992
    GIM_Try, /*On fail goto*//*Label 811*/ 32544,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s1,
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/1, 4, /*)*//*default:*//*Label 815*/ 32543,
      /*GILLT_s32*//*Label 812*/ 31007,
      /*GILLT_s64*//*Label 813*/ 31519,
      /*GILLT_s128*//*Label 814*/ 32031,
      // Label 812: @31007
      GIM_Try, /*On fail goto*//*Label 816*/ 31518,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_Try, /*On fail goto*//*Label 817*/ 31068, // Rule ID 3939 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OLT,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETOLT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 3939,
          GIR_Done,
        // Label 817: @31068
        GIM_Try, /*On fail goto*//*Label 818*/ 31123, // Rule ID 3943 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OGT,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETOGT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 3943,
          GIR_Done,
        // Label 818: @31123
        GIM_Try, /*On fail goto*//*Label 819*/ 31178, // Rule ID 3947 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OEQ,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETOEQ:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 3947,
          GIR_Done,
        // Label 819: @31178
        GIM_Try, /*On fail goto*//*Label 820*/ 31233, // Rule ID 3951 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNO,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUO:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 3951,
          GIR_Done,
        // Label 820: @31233
        GIM_Try, /*On fail goto*//*Label 821*/ 31304, // Rule ID 3953 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUGE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_lt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3953,
          GIR_Done,
        // Label 821: @31304
        GIM_Try, /*On fail goto*//*Label 822*/ 31375, // Rule ID 3985 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETULE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_gt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3985,
          GIR_Done,
        // Label 822: @31375
        GIM_Try, /*On fail goto*//*Label 823*/ 31446, // Rule ID 4017 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETUNE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_eq:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4017,
          GIR_Done,
        // Label 823: @31446
        GIM_Try, /*On fail goto*//*Label 824*/ 31517, // Rule ID 4049 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
          // (setcc:{ *:[i1] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2, SETO:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUS:{ *:[i32] } f32:{ *:[f32] }:$s1, f32:{ *:[f32] }:$s2), sub_un:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUS,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4049,
          GIR_Done,
        // Label 824: @31517
        GIM_Reject,
      // Label 816: @31518
      GIM_Reject,
      // Label 813: @31519
      GIM_Try, /*On fail goto*//*Label 825*/ 32030,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_Try, /*On fail goto*//*Label 826*/ 31596, // Rule ID 4065 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUGE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4065,
          GIR_Done,
        // Label 826: @31596
        GIM_Try, /*On fail goto*//*Label 827*/ 31667, // Rule ID 4097 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETULE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4097,
          GIR_Done,
        // Label 827: @31667
        GIM_Try, /*On fail goto*//*Label 828*/ 31738, // Rule ID 4129 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUNE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4129,
          GIR_Done,
        // Label 828: @31738
        GIM_Try, /*On fail goto*//*Label 829*/ 31809, // Rule ID 4161 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETO:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4161,
          GIR_Done,
        // Label 829: @31809
        GIM_Try, /*On fail goto*//*Label 830*/ 31864, // Rule ID 4177 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OLT,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETOLT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_lt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4177,
          GIR_Done,
        // Label 830: @31864
        GIM_Try, /*On fail goto*//*Label 831*/ 31919, // Rule ID 4181 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OGT,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETOGT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_gt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4181,
          GIR_Done,
        // Label 831: @31919
        GIM_Try, /*On fail goto*//*Label 832*/ 31974, // Rule ID 4185 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OEQ,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETOEQ:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_eq:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4185,
          GIR_Done,
        // Label 832: @31974
        GIM_Try, /*On fail goto*//*Label 833*/ 32029, // Rule ID 4189 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNO,
          // (setcc:{ *:[i1] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2, SETUO:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (FCMPUD:{ *:[i32] } f64:{ *:[f64] }:$s1, f64:{ *:[f64] }:$s2), sub_un:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::FCMPUD,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4189,
          GIR_Done,
        // Label 833: @32029
        GIM_Reject,
      // Label 825: @32030
      GIM_Reject,
      // Label 814: @32031
      GIM_Try, /*On fail goto*//*Label 834*/ 32542,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
        GIM_Try, /*On fail goto*//*Label 835*/ 32108, // Rule ID 4191 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UGE,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUGE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4191,
          GIR_Done,
        // Label 835: @32108
        GIM_Try, /*On fail goto*//*Label 836*/ 32179, // Rule ID 4223 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ULE,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETULE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4223,
          GIR_Done,
        // Label 836: @32179
        GIM_Try, /*On fail goto*//*Label 837*/ 32250, // Rule ID 4255 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNE,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUNE:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4255,
          GIR_Done,
        // Label 837: @32250
        GIM_Try, /*On fail goto*//*Label 838*/ 32321, // Rule ID 4287 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRBITRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_ORD,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETO:{ *:[Other] })  =>  (CRNOT:{ *:[i1] } (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, PPC::sub_un,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, PPC::CRRCRegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::CRNOT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // CRD
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4287,
          GIR_Done,
        // Label 838: @32321
        GIM_Try, /*On fail goto*//*Label 839*/ 32376, // Rule ID 4303 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OLT,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETOLT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_lt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_lt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4303,
          GIR_Done,
        // Label 839: @32376
        GIM_Try, /*On fail goto*//*Label 840*/ 32431, // Rule ID 4307 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OGT,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETOGT:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_gt:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_gt,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4307,
          GIR_Done,
        // Label 840: @32431
        GIM_Try, /*On fail goto*//*Label 841*/ 32486, // Rule ID 4311 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_OEQ,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETOEQ:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_eq:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_eq,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4311,
          GIR_Done,
        // Label 841: @32486
        GIM_Try, /*On fail goto*//*Label 842*/ 32541, // Rule ID 4315 //
          GIM_CheckFeatures, GIFBS_HasFPU,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::CRRCRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::FCMP_UNO,
          // (setcc:{ *:[i1] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2, SETUO:{ *:[Other] })  =>  (EXTRACT_SUBREG:{ *:[i1] } (XSCMPUQP:{ *:[i32] } f128:{ *:[f128] }:$s1, f128:{ *:[f128] }:$s2), sub_un:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/PPC::XSCMPUQP,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // s1
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // s2
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, PPC::sub_un,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, PPC::CRBITRCRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, PPC::CRRCRegClassID,
          // GIR_Coverage, 4315,
          GIR_Done,
        // Label 842: @32541
        GIM_Reject,
      // Label 834: @32542
      GIM_Reject,
      // Label 815: @32543
      GIM_Reject,
    // Label 811: @32544
    GIM_Reject,
    // Label 26: @32545
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 848*/ 32786,
    /*GILLT_s32*//*Label 843*/ 32556,
    /*GILLT_s64*//*Label 844*/ 32630,
    /*GILLT_s128*//*Label 845*/ 32704,
    /*GILLT_v2s64*//*Label 846*/ 32732,
    /*GILLT_v4s32*//*Label 847*/ 32760,
    // Label 843: @32556
    GIM_Try, /*On fail goto*//*Label 849*/ 32629,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 850*/ 32585, // Rule ID 1035 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (select:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)  =>  (SELECT_VSSRC:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_VSSRC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1035,
        GIR_Done,
      // Label 850: @32585
      GIM_Try, /*On fail goto*//*Label 851*/ 32598, // Rule ID 5 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (select:{ *:[i32] } i1:{ *:[i1] }:$cond, i32:{ *:[i32] }:$T, i32:{ *:[i32] }:$F)  =>  (SELECT_I4:{ *:[i32] } i1:{ *:[i1] }:$cond, i32:{ *:[i32] }:$T, i32:{ *:[i32] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_I4,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5,
        GIR_Done,
      // Label 851: @32598
      GIM_Try, /*On fail goto*//*Label 852*/ 32613, // Rule ID 7 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (select:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)  =>  (SELECT_F4:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_F4,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7,
        GIR_Done,
      // Label 852: @32613
      GIM_Try, /*On fail goto*//*Label 853*/ 32628, // Rule ID 602 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (select:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)  =>  (SELECT_SPE4:{ *:[f32] } i1:{ *:[i1] }:$cond, f32:{ *:[f32] }:$T, f32:{ *:[f32] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_SPE4,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 602,
        GIR_Done,
      // Label 853: @32628
      GIM_Reject,
    // Label 849: @32629
    GIM_Reject,
    // Label 844: @32630
    GIM_Try, /*On fail goto*//*Label 854*/ 32703,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 855*/ 32659, // Rule ID 1034 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (select:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)  =>  (SELECT_VSFRC:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_VSFRC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1034,
        GIR_Done,
      // Label 855: @32659
      GIM_Try, /*On fail goto*//*Label 856*/ 32672, // Rule ID 6 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
        // (select:{ *:[i64] } i1:{ *:[i1] }:$cond, i64:{ *:[i64] }:$T, i64:{ *:[i64] }:$F)  =>  (SELECT_I8:{ *:[i64] } i1:{ *:[i1] }:$cond, i64:{ *:[i64] }:$T, i64:{ *:[i64] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_I8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6,
        GIR_Done,
      // Label 856: @32672
      GIM_Try, /*On fail goto*//*Label 857*/ 32687, // Rule ID 8 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (select:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)  =>  (SELECT_F8:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_F8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8,
        GIR_Done,
      // Label 857: @32687
      GIM_Try, /*On fail goto*//*Label 858*/ 32702, // Rule ID 603 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (select:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)  =>  (SELECT_SPE:{ *:[f64] } i1:{ *:[i1] }:$cond, f64:{ *:[f64] }:$T, f64:{ *:[f64] }:$F)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_SPE,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 603,
        GIR_Done,
      // Label 858: @32702
      GIM_Reject,
    // Label 854: @32703
    GIM_Reject,
    // Label 845: @32704
    GIM_Try, /*On fail goto*//*Label 859*/ 32731, // Rule ID 9 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (select:{ *:[f128] } i1:{ *:[i1] }:$cond, f128:{ *:[f128] }:$T, f128:{ *:[f128] }:$F)  =>  (SELECT_F16:{ *:[f128] } i1:{ *:[i1] }:$cond, f128:{ *:[f128] }:$T, f128:{ *:[f128] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_F16,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 9,
      GIR_Done,
    // Label 859: @32731
    GIM_Reject,
    // Label 846: @32732
    GIM_Try, /*On fail goto*//*Label 860*/ 32759, // Rule ID 1033 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (select:{ *:[v2f64] } i1:{ *:[i1] }:$cond, v2f64:{ *:[v2f64] }:$T, v2f64:{ *:[v2f64] }:$F)  =>  (SELECT_VSRC:{ *:[v2f64] } i1:{ *:[i1] }:$cond, v2f64:{ *:[v2f64] }:$T, v2f64:{ *:[v2f64] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_VSRC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1033,
      GIR_Done,
    // Label 860: @32759
    GIM_Reject,
    // Label 847: @32760
    GIM_Try, /*On fail goto*//*Label 861*/ 32785, // Rule ID 10 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (select:{ *:[v4i32] } i1:{ *:[i1] }:$cond, v4i32:{ *:[v4i32] }:$T, v4i32:{ *:[v4i32] }:$F)  =>  (SELECT_VRRC:{ *:[v4i32] } i1:{ *:[i1] }:$cond, v4i32:{ *:[v4i32] }:$T, v4i32:{ *:[v4i32] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::SELECT_VRRC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 10,
      GIR_Done,
    // Label 861: @32785
    GIM_Reject,
    // Label 848: @32786
    GIM_Reject,
    // Label 27: @32787
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 866*/ 32890,
    /*GILLT_s32*//*Label 862*/ 32798,
    /*GILLT_s64*//*Label 863*/ 32820, 0,
    /*GILLT_v2s64*//*Label 864*/ 32842,
    /*GILLT_v4s32*//*Label 865*/ 32866,
    // Label 862: @32798
    GIM_Try, /*On fail goto*//*Label 867*/ 32819, // Rule ID 204 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (mulhu:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (MULHWU:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULHWU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 204,
      GIR_Done,
    // Label 867: @32819
    GIM_Reject,
    // Label 863: @32820
    GIM_Try, /*On fail goto*//*Label 868*/ 32841, // Rule ID 669 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (mulhu:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MULHDU:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULHDU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 669,
      GIR_Done,
    // Label 868: @32841
    GIM_Reject,
    // Label 864: @32842
    GIM_Try, /*On fail goto*//*Label 869*/ 32865, // Rule ID 1106 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mulhu:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULHUD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1106,
      GIR_Done,
    // Label 869: @32865
    GIM_Reject,
    // Label 865: @32866
    GIM_Try, /*On fail goto*//*Label 870*/ 32889, // Rule ID 1104 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mulhu:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULHUW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1104,
      GIR_Done,
    // Label 870: @32889
    GIM_Reject,
    // Label 866: @32890
    GIM_Reject,
    // Label 28: @32891
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 875*/ 32994,
    /*GILLT_s32*//*Label 871*/ 32902,
    /*GILLT_s64*//*Label 872*/ 32924, 0,
    /*GILLT_v2s64*//*Label 873*/ 32946,
    /*GILLT_v4s32*//*Label 874*/ 32970,
    // Label 871: @32902
    GIM_Try, /*On fail goto*//*Label 876*/ 32923, // Rule ID 203 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (mulhs:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)  =>  (MULHW:{ *:[i32] } i32:{ *:[i32] }:$rA, i32:{ *:[i32] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULHW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 203,
      GIR_Done,
    // Label 876: @32923
    GIM_Reject,
    // Label 872: @32924
    GIM_Try, /*On fail goto*//*Label 877*/ 32945, // Rule ID 668 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (mulhs:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MULHD:{ *:[i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::MULHD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 668,
      GIR_Done,
    // Label 877: @32945
    GIM_Reject,
    // Label 873: @32946
    GIM_Try, /*On fail goto*//*Label 878*/ 32969, // Rule ID 1105 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mulhs:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULHSD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1105,
      GIR_Done,
    // Label 878: @32969
    GIM_Reject,
    // Label 874: @32970
    GIM_Try, /*On fail goto*//*Label 879*/ 32993, // Rule ID 1103 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (mulhs:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMULHSW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1103,
      GIR_Done,
    // Label 879: @32993
    GIM_Reject,
    // Label 875: @32994
    GIM_Reject,
    // Label 29: @32995
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 885*/ 33225,
    /*GILLT_s32*//*Label 880*/ 33006,
    /*GILLT_s64*//*Label 881*/ 33066,
    /*GILLT_s128*//*Label 882*/ 33129,
    /*GILLT_v2s64*//*Label 883*/ 33153,
    /*GILLT_v4s32*//*Label 884*/ 33180,
    // Label 880: @33006
    GIM_Try, /*On fail goto*//*Label 886*/ 33065,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 887*/ 33031, // Rule ID 941 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fadd:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSADDSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 887: @33031
      GIM_Try, /*On fail goto*//*Label 888*/ 33049, // Rule ID 236 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fadd:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FADDS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FADDS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 236,
        GIR_Done,
      // Label 888: @33049
      GIM_Try, /*On fail goto*//*Label 889*/ 33064, // Rule ID 575 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fadd:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSADD:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 575,
        GIR_Done,
      // Label 889: @33064
      GIM_Reject,
    // Label 886: @33065
    GIM_Reject,
    // Label 881: @33066
    GIM_Try, /*On fail goto*//*Label 890*/ 33128,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 891*/ 33094, // Rule ID 758 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fadd:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSADDDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 891: @33094
      GIM_Try, /*On fail goto*//*Label 892*/ 33112, // Rule ID 234 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fadd:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FADD:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FADD,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 234,
        GIR_Done,
      // Label 892: @33112
      GIM_Try, /*On fail goto*//*Label 893*/ 33127, // Rule ID 554 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fadd:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDADD:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 554,
        GIR_Done,
      // Label 893: @33127
      GIM_Reject,
    // Label 890: @33128
    GIM_Reject,
    // Label 882: @33129
    GIM_Try, /*On fail goto*//*Label 894*/ 33152, // Rule ID 976 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fadd:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSADDQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 976,
      GIR_Done,
    // Label 894: @33152
    GIM_Reject,
    // Label 883: @33153
    GIM_Try, /*On fail goto*//*Label 895*/ 33179, // Rule ID 762 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fadd:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVADDDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVADDDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 762,
      GIR_Done,
    // Label 895: @33179
    GIM_Reject,
    // Label 884: @33180
    GIM_Try, /*On fail goto*//*Label 896*/ 33224,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 897*/ 33208, // Rule ID 764 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (fadd:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVADDSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVADDSP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 764,
        GIR_Done,
      // Label 897: @33208
      GIM_Try, /*On fail goto*//*Label 898*/ 33223, // Rule ID 296 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (fadd:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)  =>  (VADDFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VADDFP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 296,
        GIR_Done,
      // Label 898: @33223
      GIM_Reject,
    // Label 896: @33224
    GIM_Reject,
    // Label 885: @33225
    GIM_Reject,
    // Label 30: @33226
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 904*/ 33456,
    /*GILLT_s32*//*Label 899*/ 33237,
    /*GILLT_s64*//*Label 900*/ 33297,
    /*GILLT_s128*//*Label 901*/ 33360,
    /*GILLT_v2s64*//*Label 902*/ 33384,
    /*GILLT_v4s32*//*Label 903*/ 33411,
    // Label 899: @33237
    GIM_Try, /*On fail goto*//*Label 905*/ 33296,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 906*/ 33262, // Rule ID 945 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fsub:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSSUBSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 906: @33262
      GIM_Try, /*On fail goto*//*Label 907*/ 33280, // Rule ID 248 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fsub:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FSUBS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSUBS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 248,
        GIR_Done,
      // Label 907: @33280
      GIM_Try, /*On fail goto*//*Label 908*/ 33295, // Rule ID 593 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fsub:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSSUB:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSSUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 593,
        GIR_Done,
      // Label 908: @33295
      GIM_Reject,
    // Label 905: @33296
    GIM_Reject,
    // Label 900: @33297
    GIM_Try, /*On fail goto*//*Label 909*/ 33359,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 910*/ 33325, // Rule ID 770 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fsub:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSSUBDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 770,
        GIR_Done,
      // Label 910: @33325
      GIM_Try, /*On fail goto*//*Label 911*/ 33343, // Rule ID 246 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fsub:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FSUB:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSUB,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 246,
        GIR_Done,
      // Label 911: @33343
      GIM_Try, /*On fail goto*//*Label 912*/ 33358, // Rule ID 572 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fsub:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDSUB:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDSUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 572,
        GIR_Done,
      // Label 912: @33358
      GIM_Reject,
    // Label 909: @33359
    GIM_Reject,
    // Label 901: @33360
    GIM_Try, /*On fail goto*//*Label 913*/ 33383, // Rule ID 980 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fsub:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSSUBQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 980,
      GIR_Done,
    // Label 913: @33383
    GIM_Reject,
    // Label 902: @33384
    GIM_Try, /*On fail goto*//*Label 914*/ 33410, // Rule ID 772 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fsub:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVSUBDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSUBDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 772,
      GIR_Done,
    // Label 914: @33410
    GIM_Reject,
    // Label 903: @33411
    GIM_Try, /*On fail goto*//*Label 915*/ 33455,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 916*/ 33439, // Rule ID 774 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (fsub:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVSUBSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSUBSP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 916: @33439
      GIM_Try, /*On fail goto*//*Label 917*/ 33454, // Rule ID 366 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (fsub:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)  =>  (VSUBFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VSUBFP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 917: @33454
      GIM_Reject,
    // Label 915: @33455
    GIM_Reject,
    // Label 904: @33456
    GIM_Reject,
    // Label 31: @33457
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 923*/ 33669,
    /*GILLT_s32*//*Label 918*/ 33468,
    /*GILLT_s64*//*Label 919*/ 33528,
    /*GILLT_s128*//*Label 920*/ 33591,
    /*GILLT_v2s64*//*Label 921*/ 33615,
    /*GILLT_v4s32*//*Label 922*/ 33642,
    // Label 918: @33468
    GIM_Try, /*On fail goto*//*Label 924*/ 33527,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 925*/ 33493, // Rule ID 943 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fmul:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSMULSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 925: @33493
      GIM_Try, /*On fail goto*//*Label 926*/ 33511, // Rule ID 244 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fmul:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC)  =>  (FMULS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMULS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 244,
        GIR_Done,
      // Label 926: @33511
      GIM_Try, /*On fail goto*//*Label 927*/ 33526, // Rule ID 589 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fmul:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSMUL:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSMUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 589,
        GIR_Done,
      // Label 927: @33526
      GIM_Reject,
    // Label 924: @33527
    GIM_Reject,
    // Label 919: @33528
    GIM_Try, /*On fail goto*//*Label 928*/ 33590,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 929*/ 33556, // Rule ID 760 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fmul:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSMULDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 760,
        GIR_Done,
      // Label 929: @33556
      GIM_Try, /*On fail goto*//*Label 930*/ 33574, // Rule ID 242 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fmul:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC)  =>  (FMUL:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMUL,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 242,
        GIR_Done,
      // Label 930: @33574
      GIM_Try, /*On fail goto*//*Label 931*/ 33589, // Rule ID 568 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fmul:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDMUL:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDMUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 568,
        GIR_Done,
      // Label 931: @33589
      GIM_Reject,
    // Label 928: @33590
    GIM_Reject,
    // Label 920: @33591
    GIM_Try, /*On fail goto*//*Label 932*/ 33614, // Rule ID 978 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fmul:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSMULQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 978,
      GIR_Done,
    // Label 932: @33614
    GIM_Reject,
    // Label 921: @33615
    GIM_Try, /*On fail goto*//*Label 933*/ 33641, // Rule ID 766 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fmul:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVMULDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVMULDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 766,
      GIR_Done,
    // Label 933: @33641
    GIM_Reject,
    // Label 922: @33642
    GIM_Try, /*On fail goto*//*Label 934*/ 33668, // Rule ID 768 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fmul:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVMULSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVMULSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 768,
      GIR_Done,
    // Label 934: @33668
    GIM_Reject,
    // Label 923: @33669
    GIM_Reject,
    // Label 32: @33670
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 940*/ 34279,
    /*GILLT_s32*//*Label 935*/ 33681,
    /*GILLT_s64*//*Label 936*/ 33837,
    /*GILLT_s128*//*Label 937*/ 33993,
    /*GILLT_v2s64*//*Label 938*/ 34082,
    /*GILLT_v4s32*//*Label 939*/ 34171,
    // Label 935: @33681
    GIM_Try, /*On fail goto*//*Label 941*/ 33836,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 942*/ 33740, // Rule ID 957 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, (fneg:{ *:[f32] } f32:{ *:[f32] }:$XTi))  =>  (XSMSUBASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 957,
        GIR_Done,
      // Label 942: @33740
      GIM_Try, /*On fail goto*//*Label 943*/ 33772, // Rule ID 955 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, f32:{ *:[f32] }:$XTi)  =>  (XSMADDASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMADDASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 955,
        GIR_Done,
      // Label 943: @33772
      GIM_Try, /*On fail goto*//*Label 944*/ 33817, // Rule ID 222 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, (fneg:{ *:[f32] } f32:{ *:[f32] }:$FRB))  =>  (FMSUBS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FMSUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 222,
        GIR_Done,
      // Label 944: @33817
      GIM_Try, /*On fail goto*//*Label 945*/ 33835, // Rule ID 218 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)  =>  (FMADDS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMADDS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 218,
        GIR_Done,
      // Label 945: @33835
      GIM_Reject,
    // Label 941: @33836
    GIM_Reject,
    // Label 936: @33837
    GIM_Try, /*On fail goto*//*Label 946*/ 33992,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 947*/ 33896, // Rule ID 778 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, (fneg:{ *:[f64] } f64:{ *:[f64] }:$XTi))  =>  (XSMSUBADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 778,
        GIR_Done,
      // Label 947: @33896
      GIM_Try, /*On fail goto*//*Label 948*/ 33928, // Rule ID 776 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, f64:{ *:[f64] }:$XTi)  =>  (XSMADDADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 776,
        GIR_Done,
      // Label 948: @33928
      GIM_Try, /*On fail goto*//*Label 949*/ 33973, // Rule ID 220 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, (fneg:{ *:[f64] } f64:{ *:[f64] }:$FRB))  =>  (FMSUB:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FMSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 220,
        GIR_Done,
      // Label 949: @33973
      GIM_Try, /*On fail goto*//*Label 950*/ 33991, // Rule ID 216 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)  =>  (FMADD:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMADD,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 216,
        GIR_Done,
      // Label 950: @33991
      GIM_Reject,
    // Label 946: @33992
    GIM_Reject,
    // Label 937: @33993
    GIM_Try, /*On fail goto*//*Label 951*/ 34081,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 952*/ 34052, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$vTi))  =>  (XSMSUBQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMSUBQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 952: @34052
      GIM_Try, /*On fail goto*//*Label 953*/ 34080, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        // (fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vTi)  =>  (XSMADDQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSMADDQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 953: @34080
      GIM_Reject,
    // Label 951: @34081
    GIM_Reject,
    // Label 938: @34082
    GIM_Try, /*On fail goto*//*Label 954*/ 34170,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 955*/ 34141, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, (fneg:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi))  =>  (XVMSUBADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 955: @34141
      GIM_Try, /*On fail goto*//*Label 956*/ 34169, // Rule ID 784 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        // (fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, v2f64:{ *:[v2f64] }:$XTi)  =>  (XVMADDADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 784,
        GIR_Done,
      // Label 956: @34169
      GIM_Reject,
    // Label 954: @34170
    GIM_Reject,
    // Label 939: @34171
    GIM_Try, /*On fail goto*//*Label 957*/ 34278,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 958*/ 34230, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB, (fneg:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi))  =>  (XVMSUBASP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 958: @34230
      GIM_Try, /*On fail goto*//*Label 959*/ 34262, // Rule ID 786 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB, v4f32:{ *:[v4f32] }:$XTi)  =>  (XVMADDASP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVMADDASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 959: @34262
      GIM_Try, /*On fail goto*//*Label 960*/ 34277, // Rule ID 288 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        // (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vC, v4f32:{ *:[v4f32] }:$vB)  =>  (VMADDFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vC, v4f32:{ *:[v4f32] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VMADDFP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 288,
        GIR_Done,
      // Label 960: @34277
      GIM_Reject,
    // Label 957: @34278
    GIM_Reject,
    // Label 940: @34279
    GIM_Reject,
    // Label 33: @34280
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 966*/ 34492,
    /*GILLT_s32*//*Label 961*/ 34291,
    /*GILLT_s64*//*Label 962*/ 34351,
    /*GILLT_s128*//*Label 963*/ 34414,
    /*GILLT_v2s64*//*Label 964*/ 34438,
    /*GILLT_v4s32*//*Label 965*/ 34465,
    // Label 961: @34291
    GIM_Try, /*On fail goto*//*Label 967*/ 34350,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 968*/ 34316, // Rule ID 947 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fdiv:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSDIVSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSDIVSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 947,
        GIR_Done,
      // Label 968: @34316
      GIM_Try, /*On fail goto*//*Label 969*/ 34334, // Rule ID 240 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fdiv:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FDIVS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FDIVS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 240,
        GIR_Done,
      // Label 969: @34334
      GIM_Try, /*On fail goto*//*Label 970*/ 34349, // Rule ID 587 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fdiv:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSDIV:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSDIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 587,
        GIR_Done,
      // Label 970: @34349
      GIM_Reject,
    // Label 967: @34350
    GIM_Reject,
    // Label 962: @34351
    GIM_Try, /*On fail goto*//*Label 971*/ 34413,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 972*/ 34379, // Rule ID 799 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fdiv:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSDIVDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSDIVDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 799,
        GIR_Done,
      // Label 972: @34379
      GIM_Try, /*On fail goto*//*Label 973*/ 34397, // Rule ID 238 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fdiv:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FDIV:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FDIV,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 238,
        GIR_Done,
      // Label 973: @34397
      GIM_Try, /*On fail goto*//*Label 974*/ 34412, // Rule ID 566 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fdiv:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDDIV:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDDIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 566,
        GIR_Done,
      // Label 974: @34412
      GIM_Reject,
    // Label 971: @34413
    GIM_Reject,
    // Label 963: @34414
    GIM_Try, /*On fail goto*//*Label 975*/ 34437, // Rule ID 982 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fdiv:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSDIVQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSDIVQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 982,
      GIR_Done,
    // Label 975: @34437
    GIM_Reject,
    // Label 964: @34438
    GIM_Try, /*On fail goto*//*Label 976*/ 34464, // Rule ID 808 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fdiv:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVDIVDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVDIVDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 808,
      GIR_Done,
    // Label 976: @34464
    GIM_Reject,
    // Label 965: @34465
    GIM_Try, /*On fail goto*//*Label 977*/ 34491, // Rule ID 810 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fdiv:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVDIVSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVDIVSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 810,
      GIR_Done,
    // Label 977: @34491
    GIM_Reject,
    // Label 966: @34492
    GIM_Reject,
    // Label 34: @34493
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 983*/ 36770,
    /*GILLT_s32*//*Label 978*/ 34504,
    /*GILLT_s64*//*Label 979*/ 35129,
    /*GILLT_s128*//*Label 980*/ 35772,
    /*GILLT_v2s64*//*Label 981*/ 36175,
    /*GILLT_v4s32*//*Label 982*/ 36456,
    // Label 978: @34504
    GIM_Try, /*On fail goto*//*Label 984*/ 35128,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 985*/ 34576, // Rule ID 961 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, (fneg:{ *:[f32] } f32:{ *:[f32] }:$XTi)))  =>  (XSNMSUBASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 961,
        GIR_Done,
      // Label 985: @34576
      GIM_Try, /*On fail goto*//*Label 986*/ 34642, // Rule ID 960 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (strict_fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, (fneg:{ *:[f32] } f32:{ *:[f32] }:$XTi)))  =>  (XSNMSUBASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 960,
        GIR_Done,
      // Label 986: @34642
      GIM_Try, /*On fail goto*//*Label 987*/ 34695, // Rule ID 959 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, f32:{ *:[f32] }:$XTi))  =>  (XSNMADDASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 987: @34695
      GIM_Try, /*On fail goto*//*Label 988*/ 34748, // Rule ID 958 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (strict_fma:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB, f32:{ *:[f32] }:$XTi))  =>  (XSNMADDASP:{ *:[f32] } f32:{ *:[f32] }:$XTi, f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 958,
        GIR_Done,
      // Label 988: @34748
      GIM_Try, /*On fail goto*//*Label 989*/ 34785, // Rule ID 833 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fabs:{ *:[f32] } f32:{ *:[f32] }:$XB))  =>  (XSNABSDPs:{ *:[f32] } f32:{ *:[f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNABSDPs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 833,
        GIR_Done,
      // Label 989: @34785
      GIM_Try, /*On fail goto*//*Label 990*/ 34851, // Rule ID 230 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, (fneg:{ *:[f32] } f32:{ *:[f32] }:$FRB)))  =>  (FNMSUBS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMSUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 230,
        GIR_Done,
      // Label 990: @34851
      GIM_Try, /*On fail goto*//*Label 991*/ 34917, // Rule ID 229 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (strict_fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, (fneg:{ *:[f32] } f32:{ *:[f32] }:$FRB)))  =>  (FNMSUBS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMSUBS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 229,
        GIR_Done,
      // Label 991: @34917
      GIM_Try, /*On fail goto*//*Label 992*/ 34970, // Rule ID 226 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB))  =>  (FNMADDS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 226,
        GIR_Done,
      // Label 992: @34970
      GIM_Try, /*On fail goto*//*Label 993*/ 35023, // Rule ID 225 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (strict_fma:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB))  =>  (FNMADDS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC, f32:{ *:[f32] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADDS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 225,
        GIR_Done,
      // Label 993: @35023
      GIM_Try, /*On fail goto*//*Label 994*/ 35060, // Rule ID 162 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fabs:{ *:[f32] } f32:{ *:[f32] }:$frB))  =>  (FNABSS:{ *:[f32] } f32:{ *:[f32] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNABSS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // frD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // frB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 162,
        GIR_Done,
      // Label 994: @35060
      GIM_Try, /*On fail goto*//*Label 995*/ 35097, // Rule ID 590 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f32] } (fabs:{ *:[f32] } f32:{ *:[f32] }:$RA))  =>  (EFSNABS:{ *:[f32] } f32:{ *:[f32] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EFSNABS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 590,
        GIR_Done,
      // Label 995: @35097
      GIM_Try, /*On fail goto*//*Label 996*/ 35112, // Rule ID 164 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fneg:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FNEGS:{ *:[f32] } f32:{ *:[f32] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FNEGS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 164,
        GIR_Done,
      // Label 996: @35112
      GIM_Try, /*On fail goto*//*Label 997*/ 35127, // Rule ID 591 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fneg:{ *:[f32] } f32:{ *:[f32] }:$RA)  =>  (EFSNEG:{ *:[f32] } f32:{ *:[f32] }:$RA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSNEG,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 591,
        GIR_Done,
      // Label 997: @35127
      GIM_Reject,
    // Label 984: @35128
    GIM_Reject,
    // Label 979: @35129
    GIM_Try, /*On fail goto*//*Label 998*/ 35771,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 999*/ 35201, // Rule ID 782 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, (fneg:{ *:[f64] } f64:{ *:[f64] }:$XTi)))  =>  (XSNMSUBADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 782,
        GIR_Done,
      // Label 999: @35201
      GIM_Try, /*On fail goto*//*Label 1000*/ 35267, // Rule ID 781 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (strict_fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, (fneg:{ *:[f64] } f64:{ *:[f64] }:$XTi)))  =>  (XSNMSUBADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 781,
        GIR_Done,
      // Label 1000: @35267
      GIM_Try, /*On fail goto*//*Label 1001*/ 35320, // Rule ID 780 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, f64:{ *:[f64] }:$XTi))  =>  (XSNMADDADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 780,
        GIR_Done,
      // Label 1001: @35320
      GIM_Try, /*On fail goto*//*Label 1002*/ 35373, // Rule ID 779 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (strict_fma:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB, f64:{ *:[f64] }:$XTi))  =>  (XSNMADDADP:{ *:[f64] } f64:{ *:[f64] }:$XTi, f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 779,
        GIR_Done,
      // Label 1002: @35373
      GIM_Try, /*On fail goto*//*Label 1003*/ 35410, // Rule ID 832 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fabs:{ *:[f64] } f64:{ *:[f64] }:$XB))  =>  (XSNABSDP:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNABSDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 832,
        GIR_Done,
      // Label 1003: @35410
      GIM_Try, /*On fail goto*//*Label 1004*/ 35428, // Rule ID 834 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fneg:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSNEGDP:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSNEGDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 834,
        GIR_Done,
      // Label 1004: @35428
      GIM_Try, /*On fail goto*//*Label 1005*/ 35494, // Rule ID 228 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, (fneg:{ *:[f64] } f64:{ *:[f64] }:$FRB)))  =>  (FNMSUB:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 228,
        GIR_Done,
      // Label 1005: @35494
      GIM_Try, /*On fail goto*//*Label 1006*/ 35560, // Rule ID 227 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (strict_fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, (fneg:{ *:[f64] } f64:{ *:[f64] }:$FRB)))  =>  (FNMSUB:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 227,
        GIR_Done,
      // Label 1006: @35560
      GIM_Try, /*On fail goto*//*Label 1007*/ 35613, // Rule ID 224 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB))  =>  (FNMADD:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 224,
        GIR_Done,
      // Label 1007: @35613
      GIM_Try, /*On fail goto*//*Label 1008*/ 35666, // Rule ID 223 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (strict_fma:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB))  =>  (FNMADD:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC, f64:{ *:[f64] }:$FRB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNMADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // FRT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // FRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // FRC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // FRB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 223,
        GIR_Done,
      // Label 1008: @35666
      GIM_Try, /*On fail goto*//*Label 1009*/ 35703, // Rule ID 163 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fabs:{ *:[f64] } f64:{ *:[f64] }:$frB))  =>  (FNABSD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FNABSD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // frD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // frB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 163,
        GIR_Done,
      // Label 1009: @35703
      GIM_Try, /*On fail goto*//*Label 1010*/ 35740, // Rule ID 569 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f64] } (fabs:{ *:[f64] } f64:{ *:[f64] }:$RA))  =>  (EFDNABS:{ *:[f64] } f64:{ *:[f64] }:$RA)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::EFDNABS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // RT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RA
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 569,
        GIR_Done,
      // Label 1010: @35740
      GIM_Try, /*On fail goto*//*Label 1011*/ 35755, // Rule ID 165 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fneg:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FNEGD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FNEGD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 1011: @35755
      GIM_Try, /*On fail goto*//*Label 1012*/ 35770, // Rule ID 570 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fneg:{ *:[f64] } f64:{ *:[f64] }:$RA)  =>  (EFDNEG:{ *:[f64] } f64:{ *:[f64] }:$RA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDNEG,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 570,
        GIR_Done,
      // Label 1012: @35770
      GIM_Reject,
    // Label 998: @35771
    GIM_Reject,
    // Label 980: @35772
    GIM_Try, /*On fail goto*//*Label 1013*/ 36174,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 1014*/ 35851, // Rule ID 1001 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/4, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f128] } (intrinsic_wo_chain:{ *:[f128] } 7486:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$vTi)))  =>  (XSNMSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1001,
        GIR_Done,
      // Label 1014: @35851
      GIM_Try, /*On fail goto*//*Label 1015*/ 35907, // Rule ID 1000 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::ppc_fmaf128_round_to_odd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/4, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f128] } (intrinsic_wo_chain:{ *:[f128] } 7486:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vTi))  =>  (XSNMADDQPO:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDQPO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/4, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 1015: @35907
      GIM_Try, /*On fail goto*//*Label 1016*/ 35969, // Rule ID 992 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f128] } (fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$vTi)))  =>  (XSNMSUBQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 1016: @35969
      GIM_Try, /*On fail goto*//*Label 1017*/ 36031, // Rule ID 991 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f128] } (strict_fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$vTi)))  =>  (XSNMSUBQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMSUBQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 1017: @36031
      GIM_Try, /*On fail goto*//*Label 1018*/ 36080, // Rule ID 990 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f128] } (fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vTi))  =>  (XSNMADDQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 1018: @36080
      GIM_Try, /*On fail goto*//*Label 1019*/ 36129, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s128,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f128] } (strict_fma:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vTi))  =>  (XSNMADDQP:{ *:[f128] } f128:{ *:[f128] }:$vTi, f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNMADDQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // vTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 1019: @36129
      GIM_Try, /*On fail goto*//*Label 1020*/ 36162, // Rule ID 973 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[f128] } (fabs:{ *:[f128] } f128:{ *:[f128] }:$vB))  =>  (XSNABSQP:{ *:[f128] } f128:{ *:[f128] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSNABSQP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 973,
        GIR_Done,
      // Label 1020: @36162
      GIM_Try, /*On fail goto*//*Label 1021*/ 36173, // Rule ID 974 //
        GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
        // (fneg:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSNEGQP:{ *:[f128] } f128:{ *:[f128] }:$vB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSNEGQP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 974,
        GIR_Done,
      // Label 1021: @36173
      GIM_Reject,
    // Label 1013: @36174
    GIM_Reject,
    // Label 981: @36175
    GIM_Try, /*On fail goto*//*Label 1022*/ 36455,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      GIM_Try, /*On fail goto*//*Label 1023*/ 36247, // Rule ID 795 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[v2f64] } (fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, (fneg:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi)))  =>  (XVNMSUBADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 795,
        GIR_Done,
      // Label 1023: @36247
      GIM_Try, /*On fail goto*//*Label 1024*/ 36309, // Rule ID 794 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[v2f64] } (strict_fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, (fneg:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi)))  =>  (XVNMSUBADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMSUBADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 1024: @36309
      GIM_Try, /*On fail goto*//*Label 1025*/ 36358, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v2f64] } (fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, v2f64:{ *:[v2f64] }:$XTi))  =>  (XVNMADDADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 1025: @36358
      GIM_Try, /*On fail goto*//*Label 1026*/ 36407, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v2f64] } (strict_fma:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB, v2f64:{ *:[v2f64] }:$XTi))  =>  (XVNMADDADP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XTi, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMADDADP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 1026: @36407
      GIM_Try, /*On fail goto*//*Label 1027*/ 36440, // Rule ID 840 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v2f64] } (fabs:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB))  =>  (XVNABSDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNABSDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 840,
        GIR_Done,
      // Label 1027: @36440
      GIM_Try, /*On fail goto*//*Label 1028*/ 36454, // Rule ID 842 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        // (fneg:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVNEGDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVNEGDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 842,
        GIR_Done,
      // Label 1028: @36454
      GIM_Reject,
    // Label 1022: @36455
    GIM_Reject,
    // Label 982: @36456
    GIM_Try, /*On fail goto*//*Label 1029*/ 36769,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 1030*/ 36528, // Rule ID 797 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[v4f32] } (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB, (fneg:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi)))  =>  (XVNMSUBASP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 797,
        GIR_Done,
      // Label 1030: @36528
      GIM_Try, /*On fail goto*//*Label 1031*/ 36594, // Rule ID 796 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_STRICT_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[v4f32] } (strict_fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB, (fneg:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi)))  =>  (XVNMSUBASP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMSUBASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 796,
        GIR_Done,
      // Label 1031: @36594
      GIM_Try, /*On fail goto*//*Label 1032*/ 36647, // Rule ID 793 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v4f32] } (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB, v4f32:{ *:[v4f32] }:$XTi))  =>  (XVNMADDASP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XTi, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNMADDASP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // XTi
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 1032: @36647
      GIM_Try, /*On fail goto*//*Label 1033*/ 36684, // Rule ID 841 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FABS,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fneg:{ *:[v4f32] } (fabs:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB))  =>  (XVNABSSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVNABSSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 841,
        GIR_Done,
      // Label 1033: @36684
      GIM_Try, /*On fail goto*//*Label 1034*/ 36702, // Rule ID 843 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
        // (fneg:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVNEGSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVNEGSP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 843,
        GIR_Done,
      // Label 1034: @36702
      GIM_Try, /*On fail goto*//*Label 1035*/ 36768, // Rule ID 289 //
        GIM_CheckFeatures, GIFBS_HasAltivec,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMA,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FNEG,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[v4f32] } (fma:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vC, (fneg:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vB)))  =>  (VNMSUBFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA, v4f32:{ *:[v4f32] }:$vC, v4f32:{ *:[v4f32] }:$vB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::VNMSUBFP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 289,
        GIR_Done,
      // Label 1035: @36768
      GIM_Reject,
    // Label 1029: @36769
    GIM_Reject,
    // Label 983: @36770
    GIM_Reject,
    // Label 35: @36771
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/2, 4, /*)*//*default:*//*Label 1038*/ 36819,
    /*GILLT_s64*//*Label 1036*/ 36779,
    /*GILLT_s128*//*Label 1037*/ 36799,
    // Label 1036: @36779
    GIM_Try, /*On fail goto*//*Label 1039*/ 36798, // Rule ID 556 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
      // (fpextend:{ *:[f64] } f32:{ *:[f32] }:$RB)  =>  (EFDCFS:{ *:[f64] } f32:{ *:[f32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDCFS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 556,
      GIR_Done,
    // Label 1039: @36798
    GIM_Reject,
    // Label 1037: @36799
    GIM_Try, /*On fail goto*//*Label 1040*/ 36818, // Rule ID 1003 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fpextend:{ *:[f128] } f64:{ *:[f64] }:$vB)  =>  (XSCVDPQP:{ *:[f128] } f64:{ *:[f64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSCVDPQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1003,
      GIR_Done,
    // Label 1040: @36818
    GIM_Reject,
    // Label 1038: @36819
    GIM_Reject,
    // Label 36: @36820
    GIM_Try, /*On fail goto*//*Label 1041*/ 36879,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1042*/ 36845, // Rule ID 950 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fpround:{ *:[f32] } f64:{ *:[f64] }:$XB)  =>  (XSRSP:{ *:[f32] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 950,
        GIR_Done,
      // Label 1042: @36845
      GIM_Try, /*On fail goto*//*Label 1043*/ 36863, // Rule ID 155 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fpround:{ *:[f32] } f64:{ *:[f64] }:$frB)  =>  (FRSP:{ *:[f32] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRSP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 155,
        GIR_Done,
      // Label 1043: @36863
      GIM_Try, /*On fail goto*//*Label 1044*/ 36878, // Rule ID 577 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fpround:{ *:[f32] } f64:{ *:[f64] }:$RB)  =>  (EFSCFD:{ *:[f32] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSCFD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 577,
        GIR_Done,
      // Label 1044: @36878
      GIM_Reject,
    // Label 1041: @36879
    GIM_Reject,
    // Label 37: @36880
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1048*/ 36976,
    /*GILLT_s32*//*Label 1045*/ 36891, 0, 0,
    /*GILLT_v2s64*//*Label 1046*/ 36930,
    /*GILLT_v4s32*//*Label 1047*/ 36953,
    // Label 1045: @36891
    GIM_Try, /*On fail goto*//*Label 1049*/ 36910, // Rule ID 562 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (fp_to_sint:{ *:[i32] } f64:{ *:[f64] }:$RB)  =>  (EFDCTSIZ:{ *:[i32] } f64:{ *:[f64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDCTSIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 562,
      GIR_Done,
    // Label 1049: @36910
    GIM_Try, /*On fail goto*//*Label 1050*/ 36929, // Rule ID 583 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (fp_to_sint:{ *:[i32] } f32:{ *:[f32] }:$RB)  =>  (EFSCTSIZ:{ *:[i32] } f32:{ *:[f32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSCTSIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 583,
      GIR_Done,
    // Label 1050: @36929
    GIM_Reject,
    // Label 1046: @36930
    GIM_Try, /*On fail goto*//*Label 1051*/ 36952, // Rule ID 866 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fp_to_sint:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSXDS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVDPSXDS,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 866,
      GIR_Done,
    // Label 1051: @36952
    GIM_Reject,
    // Label 1047: @36953
    GIM_Try, /*On fail goto*//*Label 1052*/ 36975, // Rule ID 874 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fp_to_sint:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPSXWS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVSPSXWS,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 874,
      GIR_Done,
    // Label 1052: @36975
    GIM_Reject,
    // Label 1048: @36976
    GIM_Reject,
    // Label 38: @36977
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1056*/ 37073,
    /*GILLT_s32*//*Label 1053*/ 36988, 0, 0,
    /*GILLT_v2s64*//*Label 1054*/ 37027,
    /*GILLT_v4s32*//*Label 1055*/ 37050,
    // Label 1053: @36988
    GIM_Try, /*On fail goto*//*Label 1057*/ 37007, // Rule ID 564 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (fp_to_uint:{ *:[i32] } f64:{ *:[f64] }:$RB)  =>  (EFDCTUIZ:{ *:[i32] } f64:{ *:[f64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDCTUIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 564,
      GIR_Done,
    // Label 1057: @37007
    GIM_Try, /*On fail goto*//*Label 1058*/ 37026, // Rule ID 585 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (fp_to_uint:{ *:[i32] } f32:{ *:[f32] }:$RB)  =>  (EFSCTUIZ:{ *:[i32] } f32:{ *:[f32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSCTUIZ,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 585,
      GIR_Done,
    // Label 1058: @37026
    GIM_Reject,
    // Label 1054: @37027
    GIM_Try, /*On fail goto*//*Label 1059*/ 37049, // Rule ID 869 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fp_to_uint:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPUXDS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVDPUXDS,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 869,
      GIR_Done,
    // Label 1059: @37049
    GIM_Reject,
    // Label 1055: @37050
    GIM_Try, /*On fail goto*//*Label 1060*/ 37072, // Rule ID 877 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fp_to_uint:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPUXWS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVSPUXWS,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 877,
      GIR_Done,
    // Label 1060: @37072
    GIM_Reject,
    // Label 1056: @37073
    GIM_Reject,
    // Label 39: @37074
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1065*/ 37171,
    /*GILLT_s32*//*Label 1061*/ 37085,
    /*GILLT_s64*//*Label 1062*/ 37105, 0,
    /*GILLT_v2s64*//*Label 1063*/ 37125,
    /*GILLT_v4s32*//*Label 1064*/ 37148,
    // Label 1061: @37085
    GIM_Try, /*On fail goto*//*Label 1066*/ 37104, // Rule ID 579 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (sint_to_fp:{ *:[f32] } i32:{ *:[i32] }:$RB)  =>  (EFSCFSI:{ *:[f32] } i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSCFSI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 579,
      GIR_Done,
    // Label 1066: @37104
    GIM_Reject,
    // Label 1062: @37105
    GIM_Try, /*On fail goto*//*Label 1067*/ 37124, // Rule ID 558 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
      // (sint_to_fp:{ *:[f64] } i32:{ *:[i32] }:$RB)  =>  (EFDCFSI:{ *:[f64] } i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDCFSI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 558,
      GIR_Done,
    // Label 1067: @37124
    GIM_Reject,
    // Label 1063: @37125
    GIM_Try, /*On fail goto*//*Label 1068*/ 37147, // Rule ID 879 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (sint_to_fp:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVSXDDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVSXDDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 879,
      GIR_Done,
    // Label 1068: @37147
    GIM_Reject,
    // Label 1064: @37148
    GIM_Try, /*On fail goto*//*Label 1069*/ 37170, // Rule ID 882 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (sint_to_fp:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVSXWSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVSXWSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 882,
      GIR_Done,
    // Label 1069: @37170
    GIM_Reject,
    // Label 1065: @37171
    GIM_Reject,
    // Label 40: @37172
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1074*/ 37269,
    /*GILLT_s32*//*Label 1070*/ 37183,
    /*GILLT_s64*//*Label 1071*/ 37203, 0,
    /*GILLT_v2s64*//*Label 1072*/ 37223,
    /*GILLT_v4s32*//*Label 1073*/ 37246,
    // Label 1070: @37183
    GIM_Try, /*On fail goto*//*Label 1075*/ 37202, // Rule ID 581 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (uint_to_fp:{ *:[f32] } i32:{ *:[i32] }:$RB)  =>  (EFSCFUI:{ *:[f32] } i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSCFUI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 581,
      GIR_Done,
    // Label 1075: @37202
    GIM_Reject,
    // Label 1071: @37203
    GIM_Try, /*On fail goto*//*Label 1076*/ 37222, // Rule ID 560 //
      GIM_CheckFeatures, GIFBS_HasSPE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
      // (uint_to_fp:{ *:[f64] } i32:{ *:[i32] }:$RB)  =>  (EFDCFUI:{ *:[f64] } i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDCFUI,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 560,
      GIR_Done,
    // Label 1076: @37222
    GIM_Reject,
    // Label 1072: @37223
    GIM_Try, /*On fail goto*//*Label 1077*/ 37245, // Rule ID 884 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (uint_to_fp:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVUXDDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVUXDDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 884,
      GIR_Done,
    // Label 1077: @37245
    GIM_Reject,
    // Label 1073: @37246
    GIM_Try, /*On fail goto*//*Label 1078*/ 37268, // Rule ID 887 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (uint_to_fp:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVUXWSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVCVUXWSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 887,
      GIR_Done,
    // Label 1078: @37268
    GIM_Reject,
    // Label 1074: @37269
    GIM_Reject,
    // Label 41: @37270
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1084*/ 37441,
    /*GILLT_s32*//*Label 1079*/ 37281,
    /*GILLT_s64*//*Label 1080*/ 37319,
    /*GILLT_s128*//*Label 1081*/ 37375,
    /*GILLT_v2s64*//*Label 1082*/ 37395,
    /*GILLT_v4s32*//*Label 1083*/ 37418,
    // Label 1079: @37281
    GIM_Try, /*On fail goto*//*Label 1085*/ 37318,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1086*/ 37302, // Rule ID 160 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fabs:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FABSS:{ *:[f32] } f32:{ *:[f32] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FABSS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 160,
        GIR_Done,
      // Label 1086: @37302
      GIM_Try, /*On fail goto*//*Label 1087*/ 37317, // Rule ID 573 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (fabs:{ *:[f32] } f32:{ *:[f32] }:$RA)  =>  (EFSABS:{ *:[f32] } f32:{ *:[f32] }:$RA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSABS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 573,
        GIR_Done,
      // Label 1087: @37317
      GIM_Reject,
    // Label 1085: @37318
    GIM_Reject,
    // Label 1080: @37319
    GIM_Try, /*On fail goto*//*Label 1088*/ 37374,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1089*/ 37343, // Rule ID 831 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fabs:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSABSDP:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSABSDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 831,
        GIR_Done,
      // Label 1089: @37343
      GIM_Try, /*On fail goto*//*Label 1090*/ 37358, // Rule ID 161 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fabs:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FABSD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FABSD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 161,
        GIR_Done,
      // Label 1090: @37358
      GIM_Try, /*On fail goto*//*Label 1091*/ 37373, // Rule ID 552 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (fabs:{ *:[f64] } f64:{ *:[f64] }:$RA)  =>  (EFDABS:{ *:[f64] } f64:{ *:[f64] }:$RA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDABS,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 552,
        GIR_Done,
      // Label 1091: @37373
      GIM_Reject,
    // Label 1088: @37374
    GIM_Reject,
    // Label 1081: @37375
    GIM_Try, /*On fail goto*//*Label 1092*/ 37394, // Rule ID 972 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fabs:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSABSQP:{ *:[f128] } f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSABSQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 972,
      GIR_Done,
    // Label 1092: @37394
    GIM_Reject,
    // Label 1082: @37395
    GIM_Try, /*On fail goto*//*Label 1093*/ 37417, // Rule ID 836 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fabs:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVABSDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVABSDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 836,
      GIR_Done,
    // Label 1093: @37417
    GIM_Reject,
    // Label 1083: @37418
    GIM_Try, /*On fail goto*//*Label 1094*/ 37440, // Rule ID 837 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fabs:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVABSSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVABSSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 837,
      GIR_Done,
    // Label 1094: @37440
    GIM_Reject,
    // Label 1084: @37441
    GIM_Reject,
    // Label 42: @37442
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1100*/ 37669,
    /*GILLT_s32*//*Label 1095*/ 37453,
    /*GILLT_s64*//*Label 1096*/ 37490,
    /*GILLT_s128*//*Label 1097*/ 37558,
    /*GILLT_v2s64*//*Label 1098*/ 37595,
    /*GILLT_v4s32*//*Label 1099*/ 37632,
    // Label 1095: @37453
    GIM_Try, /*On fail goto*//*Label 1101*/ 37489, // Rule ID 166 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
      // (fcopysign:{ *:[f32] } f32:{ *:[f32] }:$frB, f32:{ *:[f32] }:$frA)  =>  (FCPSGNS:{ *:[f32] } f32:{ *:[f32] }:$frA, f32:{ *:[f32] }:$frB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FCPSGNS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // frD
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // frB
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 166,
      GIR_Done,
    // Label 1101: @37489
    GIM_Reject,
    // Label 1096: @37490
    GIM_Try, /*On fail goto*//*Label 1102*/ 37557,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1103*/ 37528, // Rule ID 835 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fcopysign:{ *:[f64] } f64:{ *:[f64] }:$XB, f64:{ *:[f64] }:$XA)  =>  (XSCPSGNDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCPSGNDP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 835,
        GIR_Done,
      // Label 1103: @37528
      GIM_Try, /*On fail goto*//*Label 1104*/ 37556, // Rule ID 167 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fcopysign:{ *:[f64] } f64:{ *:[f64] }:$frB, f64:{ *:[f64] }:$frA)  =>  (FCPSGND:{ *:[f64] } f64:{ *:[f64] }:$frA, f64:{ *:[f64] }:$frB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::FCPSGND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // frD
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // frA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // frB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 1104: @37556
      GIM_Reject,
    // Label 1102: @37557
    GIM_Reject,
    // Label 1097: @37558
    GIM_Try, /*On fail goto*//*Label 1105*/ 37594, // Rule ID 971 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fcopysign:{ *:[f128] } f128:{ *:[f128] }:$vB, f128:{ *:[f128] }:$vA)  =>  (XSCPSGNQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XSCPSGNQP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vT
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // vA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // vB
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 971,
      GIR_Done,
    // Label 1105: @37594
    GIM_Reject,
    // Label 1098: @37595
    GIM_Try, /*On fail goto*//*Label 1106*/ 37631, // Rule ID 838 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fcopysign:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB, v2f64:{ *:[v2f64] }:$XA)  =>  (XVCPSGNDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCPSGNDP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 838,
      GIR_Done,
    // Label 1106: @37631
    GIM_Reject,
    // Label 1099: @37632
    GIM_Try, /*On fail goto*//*Label 1107*/ 37668, // Rule ID 839 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fcopysign:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB, v4f32:{ *:[v4f32] }:$XA)  =>  (XVCPSGNSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/PPC::XVCPSGNSP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // XT
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // XA
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // XB
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 839,
      GIR_Done,
    // Label 1107: @37668
    GIM_Reject,
    // Label 1100: @37669
    GIM_Reject,
    // Label 43: @37670
    GIM_Try, /*On fail goto*//*Label 1108*/ 37682, // Rule ID 15 //
      // MIs[0] dst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
      // (br (bb:{ *:[Other] }):$dst)  =>  (B (bb:{ *:[Other] }):$dst)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 15,
      GIR_Done,
    // Label 1108: @37682
    GIM_Reject,
    // Label 44: @37683
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 1115*/ 37816,
    /*GILLT_s32*//*Label 1109*/ 37696,
    /*GILLT_s64*//*Label 1110*/ 37716, 0,
    /*GILLT_v2s64*//*Label 1111*/ 37736,
    /*GILLT_v4s32*//*Label 1112*/ 37756,
    /*GILLT_v8s16*//*Label 1113*/ 37776,
    /*GILLT_v16s8*//*Label 1114*/ 37796,
    // Label 1109: @37696
    GIM_Try, /*On fail goto*//*Label 1116*/ 37715, // Rule ID 131 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (cttz:{ *:[i32] } i32:{ *:[i32] }:$rS)  =>  (CNTTZW:{ *:[i32] } i32:{ *:[i32] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CNTTZW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 131,
      GIR_Done,
    // Label 1116: @37715
    GIM_Reject,
    // Label 1110: @37716
    GIM_Try, /*On fail goto*//*Label 1117*/ 37735, // Rule ID 680 //
      GIM_CheckFeatures, GIFBS_IsISA3_0,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (cttz:{ *:[i64] } i64:{ *:[i64] }:$rS)  =>  (CNTTZD:{ *:[i64] } i64:{ *:[i64] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CNTTZD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 680,
      GIR_Done,
    // Label 1117: @37735
    GIM_Reject,
    // Label 1111: @37736
    GIM_Try, /*On fail goto*//*Label 1118*/ 37755, // Rule ID 531 //
      GIM_CheckFeatures, GIFBS_HasP9Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (cttz:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)  =>  (VCTZD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCTZD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 531,
      GIR_Done,
    // Label 1118: @37755
    GIM_Reject,
    // Label 1112: @37756
    GIM_Try, /*On fail goto*//*Label 1119*/ 37775, // Rule ID 530 //
      GIM_CheckFeatures, GIFBS_HasP9Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (cttz:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)  =>  (VCTZW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCTZW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 530,
      GIR_Done,
    // Label 1119: @37775
    GIM_Reject,
    // Label 1113: @37776
    GIM_Try, /*On fail goto*//*Label 1120*/ 37795, // Rule ID 529 //
      GIM_CheckFeatures, GIFBS_HasP9Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (cttz:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)  =>  (VCTZH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCTZH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 529,
      GIR_Done,
    // Label 1120: @37795
    GIM_Reject,
    // Label 1114: @37796
    GIM_Try, /*On fail goto*//*Label 1121*/ 37815, // Rule ID 528 //
      GIM_CheckFeatures, GIFBS_HasP9Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (cttz:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)  =>  (VCTZB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCTZB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 528,
      GIR_Done,
    // Label 1121: @37815
    GIM_Reject,
    // Label 1115: @37816
    GIM_Reject,
    // Label 45: @37817
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 1128*/ 37946,
    /*GILLT_s32*//*Label 1122*/ 37830,
    /*GILLT_s64*//*Label 1123*/ 37848, 0,
    /*GILLT_v2s64*//*Label 1124*/ 37866,
    /*GILLT_v4s32*//*Label 1125*/ 37886,
    /*GILLT_v8s16*//*Label 1126*/ 37906,
    /*GILLT_v16s8*//*Label 1127*/ 37926,
    // Label 1122: @37830
    GIM_Try, /*On fail goto*//*Label 1129*/ 37847, // Rule ID 130 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (ctlz:{ *:[i32] } i32:{ *:[i32] }:$rS)  =>  (CNTLZW:{ *:[i32] } i32:{ *:[i32] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CNTLZW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 130,
      GIR_Done,
    // Label 1129: @37847
    GIM_Reject,
    // Label 1123: @37848
    GIM_Try, /*On fail goto*//*Label 1130*/ 37865, // Rule ID 679 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (ctlz:{ *:[i64] } i64:{ *:[i64] }:$rS)  =>  (CNTLZD:{ *:[i64] } i64:{ *:[i64] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::CNTLZD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 679,
      GIR_Done,
    // Label 1130: @37865
    GIM_Reject,
    // Label 1124: @37866
    GIM_Try, /*On fail goto*//*Label 1131*/ 37885, // Rule ID 478 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctlz:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)  =>  (VCLZD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCLZD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 478,
      GIR_Done,
    // Label 1131: @37885
    GIM_Reject,
    // Label 1125: @37886
    GIM_Try, /*On fail goto*//*Label 1132*/ 37905, // Rule ID 477 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctlz:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)  =>  (VCLZW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCLZW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 477,
      GIR_Done,
    // Label 1132: @37905
    GIM_Reject,
    // Label 1126: @37906
    GIM_Try, /*On fail goto*//*Label 1133*/ 37925, // Rule ID 476 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctlz:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)  =>  (VCLZH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCLZH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 476,
      GIR_Done,
    // Label 1133: @37925
    GIM_Reject,
    // Label 1127: @37926
    GIM_Try, /*On fail goto*//*Label 1134*/ 37945, // Rule ID 475 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctlz:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)  =>  (VCLZB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VCLZB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 475,
      GIR_Done,
    // Label 1134: @37945
    GIM_Reject,
    // Label 1128: @37946
    GIM_Reject,
    // Label 46: @37947
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 8, /*)*//*default:*//*Label 1141*/ 38076,
    /*GILLT_s32*//*Label 1135*/ 37960,
    /*GILLT_s64*//*Label 1136*/ 37978, 0,
    /*GILLT_v2s64*//*Label 1137*/ 37996,
    /*GILLT_v4s32*//*Label 1138*/ 38016,
    /*GILLT_v8s16*//*Label 1139*/ 38036,
    /*GILLT_v16s8*//*Label 1140*/ 38056,
    // Label 1135: @37960
    GIM_Try, /*On fail goto*//*Label 1142*/ 37977, // Rule ID 684 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (ctpop:{ *:[i32] } i32:{ *:[i32] }:$rS)  =>  (POPCNTW:{ *:[i32] } i32:{ *:[i32] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::POPCNTW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 684,
      GIR_Done,
    // Label 1142: @37977
    GIM_Reject,
    // Label 1136: @37978
    GIM_Try, /*On fail goto*//*Label 1143*/ 37995, // Rule ID 681 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (ctpop:{ *:[i64] } i64:{ *:[i64] }:$rS)  =>  (POPCNTD:{ *:[i64] } i64:{ *:[i64] }:$rS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::POPCNTD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 681,
      GIR_Done,
    // Label 1143: @37995
    GIM_Reject,
    // Label 1137: @37996
    GIM_Try, /*On fail goto*//*Label 1144*/ 38015, // Rule ID 482 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctpop:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)  =>  (VPOPCNTD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VPOPCNTD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 482,
      GIR_Done,
    // Label 1144: @38015
    GIM_Reject,
    // Label 1138: @38016
    GIM_Try, /*On fail goto*//*Label 1145*/ 38035, // Rule ID 481 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctpop:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)  =>  (VPOPCNTW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VPOPCNTW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 481,
      GIR_Done,
    // Label 1145: @38035
    GIM_Reject,
    // Label 1139: @38036
    GIM_Try, /*On fail goto*//*Label 1146*/ 38055, // Rule ID 480 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctpop:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)  =>  (VPOPCNTH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VPOPCNTH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 480,
      GIR_Done,
    // Label 1146: @38055
    GIM_Reject,
    // Label 1140: @38056
    GIM_Try, /*On fail goto*//*Label 1147*/ 38075, // Rule ID 479 //
      GIM_CheckFeatures, GIFBS_HasP8Altivec,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (ctpop:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)  =>  (VPOPCNTB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::VPOPCNTB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 479,
      GIR_Done,
    // Label 1147: @38075
    GIM_Reject,
    // Label 1141: @38076
    GIM_Reject,
    // Label 47: @38077
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1152*/ 38168,
    /*GILLT_s32*//*Label 1148*/ 38088,
    /*GILLT_s64*//*Label 1149*/ 38108, 0,
    /*GILLT_v2s64*//*Label 1150*/ 38128,
    /*GILLT_v4s32*//*Label 1151*/ 38148,
    // Label 1148: @38088
    GIM_Try, /*On fail goto*//*Label 1153*/ 38107, // Rule ID 1119 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
      // (bswap:{ *:[i32] } i32:{ *:[i32] }:$RS)  =>  (BRW:{ *:[i32] } i32:{ *:[i32] }:$RS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::BRW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1119,
      GIR_Done,
    // Label 1153: @38107
    GIM_Reject,
    // Label 1149: @38108
    GIM_Try, /*On fail goto*//*Label 1154*/ 38127, // Rule ID 1120 //
      GIM_CheckFeatures, GIFBS_IsISA3_1,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::G8RCRegClassID,
      // (bswap:{ *:[i64] } i64:{ *:[i64] }:$RS)  =>  (BRD:{ *:[i64] } i64:{ *:[i64] }:$RS)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::BRD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1120,
      GIR_Done,
    // Label 1154: @38127
    GIM_Reject,
    // Label 1150: @38128
    GIM_Try, /*On fail goto*//*Label 1155*/ 38147, // Rule ID 1018 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bswap:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XB)  =>  (XXBRD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXBRD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1018,
      GIR_Done,
    // Label 1155: @38147
    GIM_Reject,
    // Label 1151: @38148
    GIM_Try, /*On fail goto*//*Label 1156*/ 38167, // Rule ID 1017 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (bswap:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB)  =>  (XXBRW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XXBRW,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1017,
      GIR_Done,
    // Label 1156: @38167
    GIM_Reject,
    // Label 1152: @38168
    GIM_Reject,
    // Label 48: @38169
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1161*/ 38278,
    /*GILLT_s32*//*Label 1157*/ 38180,
    /*GILLT_s64*//*Label 1158*/ 38200, 0,
    /*GILLT_v2s64*//*Label 1159*/ 38238,
    /*GILLT_v4s32*//*Label 1160*/ 38258,
    // Label 1157: @38180
    GIM_Try, /*On fail goto*//*Label 1162*/ 38199, // Rule ID 143 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
      // (fceil:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FRIPS:{ *:[f32] } f32:{ *:[f32] }:$frB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIPS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 143,
      GIR_Done,
    // Label 1162: @38199
    GIM_Reject,
    // Label 1158: @38200
    GIM_Try, /*On fail goto*//*Label 1163*/ 38237,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1164*/ 38221, // Rule ID 901 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fceil:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIP:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPIP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 901,
        GIR_Done,
      // Label 1164: @38221
      GIM_Try, /*On fail goto*//*Label 1165*/ 38236, // Rule ID 141 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fceil:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FRIPD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIPD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 141,
        GIR_Done,
      // Label 1165: @38236
      GIM_Reject,
    // Label 1163: @38237
    GIM_Reject,
    // Label 1159: @38238
    GIM_Try, /*On fail goto*//*Label 1166*/ 38257, // Rule ID 909 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fceil:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPIP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 909,
      GIR_Done,
    // Label 1166: @38257
    GIM_Reject,
    // Label 1160: @38258
    GIM_Try, /*On fail goto*//*Label 1167*/ 38277, // Rule ID 917 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fceil:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPIP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 917,
      GIR_Done,
    // Label 1167: @38277
    GIM_Reject,
    // Label 1161: @38278
    GIM_Reject,
    // Label 49: @38279
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1173*/ 38441,
    /*GILLT_s32*//*Label 1168*/ 38290,
    /*GILLT_s64*//*Label 1169*/ 38331,
    /*GILLT_s128*//*Label 1170*/ 38375,
    /*GILLT_v2s64*//*Label 1171*/ 38395,
    /*GILLT_v4s32*//*Label 1172*/ 38418,
    // Label 1168: @38290
    GIM_Try, /*On fail goto*//*Label 1174*/ 38330,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1175*/ 38311, // Rule ID 952 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (fsqrt:{ *:[f32] } f32:{ *:[f32] }:$XB)  =>  (XSSQRTSP:{ *:[f32] } f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSQRTSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 952,
        GIR_Done,
      // Label 1175: @38311
      GIM_Try, /*On fail goto*//*Label 1176*/ 38329, // Rule ID 159 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (fsqrt:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FSQRTS:{ *:[f32] } f32:{ *:[f32] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSQRTS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 159,
        GIR_Done,
      // Label 1176: @38329
      GIM_Reject,
    // Label 1174: @38330
    GIM_Reject,
    // Label 1169: @38331
    GIM_Try, /*On fail goto*//*Label 1177*/ 38374,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1178*/ 38355, // Rule ID 801 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (fsqrt:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSSQRTDP:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSQRTDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 801,
        GIR_Done,
      // Label 1178: @38355
      GIM_Try, /*On fail goto*//*Label 1179*/ 38373, // Rule ID 157 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (fsqrt:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FSQRT:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSQRT,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 157,
        GIR_Done,
      // Label 1179: @38373
      GIM_Reject,
    // Label 1177: @38374
    GIM_Reject,
    // Label 1170: @38375
    GIM_Try, /*On fail goto*//*Label 1180*/ 38394, // Rule ID 984 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (fsqrt:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSSQRTQP:{ *:[f128] } f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSQRTQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 984,
      GIR_Done,
    // Label 1180: @38394
    GIM_Reject,
    // Label 1171: @38395
    GIM_Try, /*On fail goto*//*Label 1181*/ 38417, // Rule ID 812 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fsqrt:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVSQRTDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSQRTDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 812,
      GIR_Done,
    // Label 1181: @38417
    GIM_Reject,
    // Label 1172: @38418
    GIM_Try, /*On fail goto*//*Label 1182*/ 38440, // Rule ID 814 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (fsqrt:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVSQRTSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSQRTSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 814,
      GIR_Done,
    // Label 1182: @38440
    GIM_Reject,
    // Label 1173: @38441
    GIM_Reject,
    // Label 50: @38442
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1187*/ 38551,
    /*GILLT_s32*//*Label 1183*/ 38453,
    /*GILLT_s64*//*Label 1184*/ 38473, 0,
    /*GILLT_v2s64*//*Label 1185*/ 38511,
    /*GILLT_v4s32*//*Label 1186*/ 38531,
    // Label 1183: @38453
    GIM_Try, /*On fail goto*//*Label 1188*/ 38472, // Rule ID 151 //
      GIM_CheckFeatures, GIFBS_HasFPU,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
      // (ffloor:{ *:[f32] } f32:{ *:[f32] }:$frB)  =>  (FRIMS:{ *:[f32] } f32:{ *:[f32] }:$frB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIMS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 151,
      GIR_Done,
    // Label 1188: @38472
    GIM_Reject,
    // Label 1184: @38473
    GIM_Try, /*On fail goto*//*Label 1189*/ 38510,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1190*/ 38494, // Rule ID 899 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (ffloor:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIM:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSRDPIM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 899,
        GIR_Done,
      // Label 1190: @38494
      GIM_Try, /*On fail goto*//*Label 1191*/ 38509, // Rule ID 149 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (ffloor:{ *:[f64] } f64:{ *:[f64] }:$frB)  =>  (FRIMD:{ *:[f64] } f64:{ *:[f64] }:$frB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FRIMD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 1191: @38509
      GIM_Reject,
    // Label 1189: @38510
    GIM_Reject,
    // Label 1185: @38511
    GIM_Try, /*On fail goto*//*Label 1192*/ 38530, // Rule ID 907 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (ffloor:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIM:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRDPIM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 1192: @38530
    GIM_Reject,
    // Label 1186: @38531
    GIM_Try, /*On fail goto*//*Label 1193*/ 38550, // Rule ID 915 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (ffloor:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIM:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVRSPIM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 915,
      GIR_Done,
    // Label 1193: @38550
    GIM_Reject,
    // Label 1187: @38551
    GIM_Reject,
    // Label 51: @38552
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1199*/ 38764,
    /*GILLT_s32*//*Label 1194*/ 38563,
    /*GILLT_s64*//*Label 1195*/ 38623,
    /*GILLT_s128*//*Label 1196*/ 38686,
    /*GILLT_v2s64*//*Label 1197*/ 38710,
    /*GILLT_v4s32*//*Label 1198*/ 38737,
    // Label 1194: @38563
    GIM_Try, /*On fail goto*//*Label 1200*/ 38622,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1201*/ 38588, // Rule ID 940 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (strict_fadd:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSADDSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 940,
        GIR_Done,
      // Label 1201: @38588
      GIM_Try, /*On fail goto*//*Label 1202*/ 38606, // Rule ID 235 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (strict_fadd:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FADDS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FADDS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 235,
        GIR_Done,
      // Label 1202: @38606
      GIM_Try, /*On fail goto*//*Label 1203*/ 38621, // Rule ID 574 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (strict_fadd:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSADD:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 574,
        GIR_Done,
      // Label 1203: @38621
      GIM_Reject,
    // Label 1200: @38622
    GIM_Reject,
    // Label 1195: @38623
    GIM_Try, /*On fail goto*//*Label 1204*/ 38685,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1205*/ 38651, // Rule ID 757 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (strict_fadd:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSADDDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 1205: @38651
      GIM_Try, /*On fail goto*//*Label 1206*/ 38669, // Rule ID 233 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (strict_fadd:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FADD:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FADD,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 233,
        GIR_Done,
      // Label 1206: @38669
      GIM_Try, /*On fail goto*//*Label 1207*/ 38684, // Rule ID 553 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (strict_fadd:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDADD:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 553,
        GIR_Done,
      // Label 1207: @38684
      GIM_Reject,
    // Label 1204: @38685
    GIM_Reject,
    // Label 1196: @38686
    GIM_Try, /*On fail goto*//*Label 1208*/ 38709, // Rule ID 975 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (strict_fadd:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSADDQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSADDQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 975,
      GIR_Done,
    // Label 1208: @38709
    GIM_Reject,
    // Label 1197: @38710
    GIM_Try, /*On fail goto*//*Label 1209*/ 38736, // Rule ID 761 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fadd:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVADDDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVADDDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 761,
      GIR_Done,
    // Label 1209: @38736
    GIM_Reject,
    // Label 1198: @38737
    GIM_Try, /*On fail goto*//*Label 1210*/ 38763, // Rule ID 763 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fadd:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVADDSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVADDSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 763,
      GIR_Done,
    // Label 1210: @38763
    GIM_Reject,
    // Label 1199: @38764
    GIM_Reject,
    // Label 52: @38765
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1216*/ 38977,
    /*GILLT_s32*//*Label 1211*/ 38776,
    /*GILLT_s64*//*Label 1212*/ 38836,
    /*GILLT_s128*//*Label 1213*/ 38899,
    /*GILLT_v2s64*//*Label 1214*/ 38923,
    /*GILLT_v4s32*//*Label 1215*/ 38950,
    // Label 1211: @38776
    GIM_Try, /*On fail goto*//*Label 1217*/ 38835,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1218*/ 38801, // Rule ID 944 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (strict_fsub:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSSUBSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 1218: @38801
      GIM_Try, /*On fail goto*//*Label 1219*/ 38819, // Rule ID 247 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (strict_fsub:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FSUBS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSUBS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 247,
        GIR_Done,
      // Label 1219: @38819
      GIM_Try, /*On fail goto*//*Label 1220*/ 38834, // Rule ID 592 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (strict_fsub:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSSUB:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSSUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 592,
        GIR_Done,
      // Label 1220: @38834
      GIM_Reject,
    // Label 1217: @38835
    GIM_Reject,
    // Label 1212: @38836
    GIM_Try, /*On fail goto*//*Label 1221*/ 38898,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1222*/ 38864, // Rule ID 769 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (strict_fsub:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSSUBDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 1222: @38864
      GIM_Try, /*On fail goto*//*Label 1223*/ 38882, // Rule ID 245 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (strict_fsub:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FSUB:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FSUB,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 245,
        GIR_Done,
      // Label 1223: @38882
      GIM_Try, /*On fail goto*//*Label 1224*/ 38897, // Rule ID 571 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (strict_fsub:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDSUB:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDSUB,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 571,
        GIR_Done,
      // Label 1224: @38897
      GIM_Reject,
    // Label 1221: @38898
    GIM_Reject,
    // Label 1213: @38899
    GIM_Try, /*On fail goto*//*Label 1225*/ 38922, // Rule ID 979 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (strict_fsub:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSSUBQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSSUBQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 979,
      GIR_Done,
    // Label 1225: @38922
    GIM_Reject,
    // Label 1214: @38923
    GIM_Try, /*On fail goto*//*Label 1226*/ 38949, // Rule ID 771 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fsub:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVSUBDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSUBDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 771,
      GIR_Done,
    // Label 1226: @38949
    GIM_Reject,
    // Label 1215: @38950
    GIM_Try, /*On fail goto*//*Label 1227*/ 38976, // Rule ID 773 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fsub:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVSUBSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVSUBSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 773,
      GIR_Done,
    // Label 1227: @38976
    GIM_Reject,
    // Label 1216: @38977
    GIM_Reject,
    // Label 53: @38978
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1233*/ 39190,
    /*GILLT_s32*//*Label 1228*/ 38989,
    /*GILLT_s64*//*Label 1229*/ 39049,
    /*GILLT_s128*//*Label 1230*/ 39112,
    /*GILLT_v2s64*//*Label 1231*/ 39136,
    /*GILLT_v4s32*//*Label 1232*/ 39163,
    // Label 1228: @38989
    GIM_Try, /*On fail goto*//*Label 1234*/ 39048,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1235*/ 39014, // Rule ID 942 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (strict_fmul:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSMULSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 1235: @39014
      GIM_Try, /*On fail goto*//*Label 1236*/ 39032, // Rule ID 243 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (strict_fmul:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC)  =>  (FMULS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRC)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMULS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 243,
        GIR_Done,
      // Label 1236: @39032
      GIM_Try, /*On fail goto*//*Label 1237*/ 39047, // Rule ID 588 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (strict_fmul:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSMUL:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSMUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 588,
        GIR_Done,
      // Label 1237: @39047
      GIM_Reject,
    // Label 1234: @39048
    GIM_Reject,
    // Label 1229: @39049
    GIM_Try, /*On fail goto*//*Label 1238*/ 39111,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1239*/ 39077, // Rule ID 759 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (strict_fmul:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSMULDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 759,
        GIR_Done,
      // Label 1239: @39077
      GIM_Try, /*On fail goto*//*Label 1240*/ 39095, // Rule ID 241 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (strict_fmul:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC)  =>  (FMUL:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRC)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FMUL,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 241,
        GIR_Done,
      // Label 1240: @39095
      GIM_Try, /*On fail goto*//*Label 1241*/ 39110, // Rule ID 567 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (strict_fmul:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDMUL:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDMUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 567,
        GIR_Done,
      // Label 1241: @39110
      GIM_Reject,
    // Label 1238: @39111
    GIM_Reject,
    // Label 1230: @39112
    GIM_Try, /*On fail goto*//*Label 1242*/ 39135, // Rule ID 977 //
      GIM_CheckFeatures, GIFBS_HasP9Vector_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s128,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s128,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VRRCRegClassID,
      // (strict_fmul:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)  =>  (XSMULQP:{ *:[f128] } f128:{ *:[f128] }:$vA, f128:{ *:[f128] }:$vB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSMULQP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 977,
      GIR_Done,
    // Label 1242: @39135
    GIM_Reject,
    // Label 1231: @39136
    GIM_Try, /*On fail goto*//*Label 1243*/ 39162, // Rule ID 765 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fmul:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVMULDP:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVMULDP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 765,
      GIR_Done,
    // Label 1243: @39162
    GIM_Reject,
    // Label 1232: @39163
    GIM_Try, /*On fail goto*//*Label 1244*/ 39189, // Rule ID 767 //
      GIM_CheckFeatures, GIFBS_HasVSX,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSRCRegClassID,
      // (strict_fmul:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVMULSP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XVMULSP,
      GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 767,
      GIR_Done,
    // Label 1244: @39189
    GIM_Reject,
    // Label 1233: @39190
    GIM_Reject,
    // Label 54: @39191
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 6, /*)*//*default:*//*Label 1250*/ 39403,
    /*GILLT_s32*//*Label 1245*/ 39202,
    /*GILLT_s64*//*Label 1246*/ 39262,
    /*GILLT_s128*//*Label 1247*/ 39325,
    /*GILLT_v2s64*//*Label 1248*/ 39349,
    /*GILLT_v4s32*//*Label 1249*/ 39376,
    // Label 1245: @39202
    GIM_Try, /*On fail goto*//*Label 1251*/ 39261,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1252*/ 39227, // Rule ID 946 //
        GIM_CheckFeatures, GIFBS_HasP8Vector_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSSRCRegClassID,
        // (strict_fdiv:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)  =>  (XSDIVSP:{ *:[f32] } f32:{ *:[f32] }:$XA, f32:{ *:[f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSDIVSP,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 946,
        GIR_Done,
      // Label 1252: @39227
      GIM_Try, /*On fail goto*//*Label 1253*/ 39245, // Rule ID 239 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F4RCRegClassID,
        // (strict_fdiv:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)  =>  (FDIVS:{ *:[f32] } f32:{ *:[f32] }:$FRA, f32:{ *:[f32] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FDIVS,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 239,
        GIR_Done,
      // Label 1253: @39245
      GIM_Try, /*On fail goto*//*Label 1254*/ 39260, // Rule ID 586 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::GPRCRegClassID,
        // (strict_fdiv:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)  =>  (EFSDIV:{ *:[f32] } f32:{ *:[f32] }:$RA, f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFSDIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 586,
        GIR_Done,
      // Label 1254: @39260
      GIM_Reject,
    // Label 1251: @39261
    GIM_Reject,
    // Label 1246: @39262
    GIM_Try, /*On fail goto*//*Label 1255*/ 39324,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1256*/ 39290, // Rule ID 798 //
        GIM_CheckFeatures, GIFBS_HasVSX,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::VSFRCRegClassID,
        // (strict_fdiv:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)  =>  (XSDIVDP:{ *:[f64] } f64:{ *:[f64] }:$XA, f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::XSDIVDP,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 798,
        GIR_Done,
      // Label 1256: @39290
      GIM_Try, /*On fail goto*//*Label 1257*/ 39308, // Rule ID 237 //
        GIM_CheckFeatures, GIFBS_HasFPU,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::F8RCRegClassID,
        // (strict_fdiv:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)  =>  (FDIV:{ *:[f64] } f64:{ *:[f64] }:$FRA, f64:{ *:[f64] }:$FRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::FDIV,
        GIR_AddImplicitUse, /*InsnID*/0, PPC::RM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 237,
        GIR_Done,
      // Label 1257: @39308
      GIM_Try, /*On fail goto*//*Label 1258*/ 39323, // Rule ID 565 //
        GIM_CheckFeatures, GIFBS_HasSPE,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/PPC::SPERCRegClassID,
        // (strict_fdiv:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)  =>  (EFDDIV:{ *:[f64] } f64:{ *:[f64] }:$RA, f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/PPC::EFDDIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 565,
        GIR_Done,
      // Label 12