# based on the files generated by CMake's write_basic_package_version_file

# SDL CMake version configuration file:
# This file is meant to be placed in Resources/CMake of a SDL3 framework for macOS,
# or in the CMake directory of a SDL3 framework for iOS / tvOS / visionOS.

cmake_minimum_required(VERSION 3.12...4.0)

# Find SDL_version.h
set(_sdl_version_h_path "")
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/../../Headers/SDL_version.h")
    set(_sdl_version_h_path "${CMAKE_CURRENT_LIST_DIR}/../../Headers/SDL_version.h")
elseif(EXISTS "${CMAKE_CURRENT_LIST_DIR}/../Headers/SDL_version.h")
    set(_sdl_version_h_path "${CMAKE_CURRENT_LIST_DIR}/../Headers/SDL_version.h")
endif()

if(NOT _sdl_version_h_path)
    message(AUTHOR_WARNING "Could not find SDL_version.h. This script is meant to be placed in the Resources/CMake directory or the CMake directory of SDL3.framework.")
    set(PACKAGE_VERSION_UNSUITABLE TRUE)
    return()
endif()

file(READ "${_sdl_version_h_path}" _sdl_version_h)
string(REGEX MATCH "#define[ \t]+SDL_MAJOR_VERSION[ \t]+([0-9]+)" _sdl_major_re "${_sdl_version_h}")
set(_sdl_major "${CMAKE_MATCH_1}")
string(REGEX MATCH "#define[ \t]+SDL_MINOR_VERSION[ \t]+([0-9]+)" _sdl_minor_re "${_sdl_version_h}")
set(_sdl_minor "${CMAKE_MATCH_1}")
string(REGEX MATCH "#define[ \t]+SDL_MICRO_VERSION[ \t]+([0-9]+)" _sdl_micro_re "${_sdl_version_h}")
set(_sdl_micro "${CMAKE_MATCH_1}")
if(_sdl_major_re AND _sdl_minor_re AND _sdl_micro_re)
    set(PACKAGE_VERSION "${_sdl_major}.${_sdl_minor}.${_sdl_micro}")
else()
    message(AUTHOR_WARNING "Could not extract version from SDL_version.h.")
    set(PACKAGE_VERSION_UNSUITABLE TRUE)
    return()
endif()

unset(_sdl_version_h)
unset(_sdl_version_h_path)
unset(_sdl_major_re)
unset(_sdl_major)
unset(_sdl_minor_re)
unset(_sdl_minor)
unset(_sdl_micro_re)
unset(_sdl_micro)

if(PACKAGE_FIND_VERSION_RANGE)
    # Package version must be in the requested version range
    if ((PACKAGE_FIND_VERSION_RANGE_MIN STREQUAL "INCLUDE" AND PACKAGE_VERSION VERSION_LESS PACKAGE_FIND_VERSION_MIN)
        OR ((PACKAGE_FIND_VERSION_RANGE_MAX STREQUAL "INCLUDE" AND PACKAGE_VERSION VERSION_GREATER PACKAGE_FIND_VERSION_MAX)
        OR (PACKAGE_FIND_VERSION_RANGE_MAX STREQUAL "EXCLUDE" AND PACKAGE_VERSION VERSION_GREATER_EQUAL PACKAGE_FIND_VERSION_MAX)))
        set(PACKAGE_VERSION_COMPATIBLE FALSE)
    else()
        set(PACKAGE_VERSION_COMPATIBLE TRUE)
    endif()
else()
    if(PACKAGE_VERSION VERSION_LESS PACKAGE_FIND_VERSION)
        set(PACKAGE_VERSION_COMPATIBLE FALSE)
    else()
        set(PACKAGE_VERSION_COMPATIBLE TRUE)
        if(PACKAGE_FIND_VERSION STREQUAL PACKAGE_VERSION)
            set(PACKAGE_VERSION_EXACT TRUE)
        endif()
    endif()
endif()

# The SDL3.xcframework only contains 64-bit archives
if(NOT "${CMAKE_SIZEOF_VOID_P}" EQUAL "8")
    set(PACKAGE_VERSION_UNSUITABLE TRUE)
endif()
