/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JO\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u0002H\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013JO\u0010\u0014\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0010\u001a\u0002H\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010\"\u001a\u00020#J \u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010\"\u001a\u00020#J\"\u00103\u001a\u00020\u00182\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002072\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u00108\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "reportExposure", "", "E", "Lcom/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;", "element", "elementVisibility", "restrictingDescriptor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "reportExposureForDeprecation", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "checkTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkSupertypes", "checkParameterBounds", "frontend"})
@SourceDebugExtension(value={"SMAP\nExposedVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedVisibilityChecker.kt\norg/jetbrains/kotlin/resolve/ExposedVisibilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1872#2,3:225\n1872#2,3:228\n1872#2,3:231\n*S KotlinDebug\n*F\n+ 1 ExposedVisibilityChecker.kt\norg/jetbrains/kotlin/resolve/ExposedVisibilityChecker\n*L\n124#1:225,3\n187#1:228,3\n209#1:231,3\n*E\n"})
public final class ExposedVisibilityChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @Nullable
    private final BindingTrace trace;

    public ExposedVisibilityChecker(@NotNull LanguageVersionSettings languageVersionSettings, @Nullable BindingTrace trace) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(LanguageVersionSettings languageVersionSettings, BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bindingTrace = null;
        }
        this(languageVersionSettings, bindingTrace);
    }

    private final <E extends PsiElement> void reportExposure(DiagnosticFactory3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.PrivateInFileEffectiveVisibility) && Intrinsics.areEqual(elementVisibility, EffectiveVisibility.PrivateInFile.INSTANCE)) {
            trace.report(Errors.EXPOSED_FROM_PRIVATE_IN_FILE.on(element, elementVisibility, restrictingDescriptor, restrictingVisibility));
        } else {
            trace.report(diagnostic.on(element, elementVisibility, restrictingDescriptor, restrictingVisibility));
        }
    }

    private final <E extends PsiElement> void reportExposureForDeprecation(DiagnosticFactoryForDeprecation3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        trace.report(diagnostic.on(this.languageVersionSettings, element, elementVisibility, restrictingDescriptor, restrictingVisibility));
    }

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        boolean result2 = this.checkSupertypes(klass, classDescriptor);
        result2 &= this.checkParameterBounds(klass, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return result2;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, constructor2, constructorDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull DescriptorVisibility visibility) {
        Intrinsics.checkNotNullParameter(modifierListOwner, "modifierListOwner");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        return modifierListOwner instanceof KtFunction && descriptor instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor, visibility) : (modifierListOwner instanceof KtProperty && descriptor instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor, visibility) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        SimpleType expandedType = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType)) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(expandedType, typeAliasVisibility);
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_TYPEALIAS_EXPANDED_TYPE");
            PsiElement psiElement = typeAlias.getNameIdentifier();
            if (psiElement == null) {
                psiElement = typeAlias;
            }
            this.reportExposure(diagnosticFactory3, psiElement, typeAliasVisibility, restricting);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DescriptorVisibility visibility) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        EffectiveVisibility functionVisibility = null;
        functionVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(functionDescriptor, visibility, false, 2, null);
        if (functionDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
            if (DescriptorUtilKt.isSealed(classDescriptor) && KtPsiUtilKt.visibilityModifier(function2) == null) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean result2 = false;
        result2 = true;
        if (!(function2 instanceof KtConstructor)) {
            DescriptorWithRelation restricting;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            DescriptorWithRelation descriptorWithRelation = restricting = kotlinType != null ? EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_FUNCTION_RETURN_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_FUNCTION_RETURN_TYPE");
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                this.reportExposure(diagnosticFactory3, psiElement, functionVisibility, restricting);
                result2 = false;
            }
        }
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= function2.getValueParameters().size()) continue;
            KtParameter valueParameter2 = function2.getValueParameters().get(i);
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility);
            if (restricting != null) {
                DiagnosticFactory3<KtParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PARAMETER_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_PARAMETER_TYPE");
                Intrinsics.checkNotNull(valueParameter2);
                this.reportExposure(diagnosticFactory3, (PsiElement)valueParameter2, functionVisibility, restricting);
                result2 = false;
                continue;
            }
            if (!(functionDescriptor instanceof ClassConstructorDescriptor) || !valueParameter2.hasValOrVar()) continue;
            BindingTrace bindingTrace = this.trace;
            PropertyDescriptor propertyDescriptor = bindingTrace != null ? (PropertyDescriptor)bindingTrace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor) : null;
            Substitutable<CallableDescriptor> substitutable = propertyDescriptor;
            if (substitutable == null) {
                ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)functionDescriptor).getConstructedClass();
                substitutable = classDescriptor;
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
            }
            EffectiveVisibility propertyOrClassVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(substitutable, null, false, 3, null);
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            DescriptorWithRelation restrictingByProperty = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType2, propertyOrClassVisibility);
            if (restrictingByProperty == null) continue;
            DiagnosticFactoryForDeprecation3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactoryForDeprecation3 = Errors.EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactoryForDeprecation3, "EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR");
            PsiElement psiElement = valueParameter2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = valueParameter2;
            }
            PsiElement psiElement2 = psiElement;
            Intrinsics.checkNotNull(psiElement2);
            this.reportExposureForDeprecation(diagnosticFactoryForDeprecation3, psiElement2, propertyOrClassVisibility, restrictingByProperty);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor, visibility);
    }

    public static /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            descriptorVisibility = functionDescriptor.getVisibility();
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, descriptorVisibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull DescriptorVisibility visibility) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(propertyDescriptor, visibility, false, 2, null);
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PROPERTY_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_PROPERTY_TYPE");
            PsiElement psiElement = property.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property;
            }
            this.reportExposure(diagnosticFactory3, psiElement, propertyVisibility, restricting);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property.getReceiverTypeReference(), propertyDescriptor, visibility);
    }

    public static /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            descriptorVisibility = propertyDescriptor.getVisibility();
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, descriptorVisibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor, DescriptorVisibility visibility) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(memberDescriptor, visibility, false, 2, null);
        KotlinType kotlinType = receiverParameterDescriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, memberVisibility);
        if (restricting != null) {
            DiagnosticFactory3<KtTypeReference, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_RECEIVER_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_RECEIVER_TYPE");
            this.reportExposure(diagnosticFactory3, (PsiElement)typeReference, memberVisibility, restricting);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        boolean isInterface = classDescriptor.getKind() == ClassKind.INTERFACE;
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        boolean result2 = false;
        result2 = true;
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, "getSupertypes(...)");
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ClassDescriptor superDescriptor;
            boolean superIsInterface;
            void superType;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= delegationList.size()) {
                return result2;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) continue;
            boolean bl2 = superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE;
            if (superIsInterface != isInterface) continue;
            Intrinsics.checkNotNull(superType);
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)superType, classVisibility);
            if (restricting == null) continue;
            DiagnosticFactory3<KtSuperTypeListEntry, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = isInterface ? Errors.EXPOSED_SUPER_INTERFACE : Errors.EXPOSED_SUPER_CLASS;
            Intrinsics.checkNotNull(diagnosticFactory3);
            this.reportExposure(diagnosticFactory3, (PsiElement)delegationList.get(i), classVisibility, restricting);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        List<KtTypeParameter> list = klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        List<KtTypeParameter> typeParameterList = list;
        boolean result2 = false;
        result2 = true;
        List<TypeParameterDescriptor> list2 = classDescriptor.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getDeclaredTypeParameters(...)");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= typeParameterList.size()) {
                return result2;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                Intrinsics.checkNotNull(upperBound);
                DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                DiagnosticFactory3<KtTypeParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPE_PARAMETER_BOUND;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_TYPE_PARAMETER_BOUND");
                KtTypeParameter ktTypeParameter = typeParameterList.get(i);
                Intrinsics.checkNotNullExpressionValue(ktTypeParameter, "get(...)");
                this.reportExposure(diagnosticFactory3, (PsiElement)ktTypeParameter, classVisibility, restricting);
                result2 = false;
                continue block0;
            }
        }
        return result2;
    }
}

