/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.JsConstructExpressionVisitor;
import org.jetbrains.kotlin.js.backend.JsFirstExpressionVisitor;
import org.jetbrains.kotlin.js.backend.JsPrecedenceVisitor;
import org.jetbrains.kotlin.js.backend.JsRequiresSemiVisitor;
import org.jetbrains.kotlin.js.backend.NoOpSourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsComment;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExport;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsOperator;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.JsYield;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.util.TextOutput;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CLASS = "class".toCharArray();
    private static final char[] CHARS_CONSTRUCTOR = "constructor".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_YIELD = "yield".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_EXTENDS = "extends".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_STATIC = "static".toCharArray();
    private static final char[] CHARS_GET = "get".toCharArray();
    private static final char[] CHARS_SET = "set".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_SUPER = "super".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    @NotNull
    private final SourceLocationConsumer sourceLocationConsumer;
    @NotNull
    private final List<Object> sourceInfoStack;
    protected boolean insideComments;
    protected boolean needSemi;
    private boolean lineBreakAfterBlock;
    private Set<JsBlock> globalBlocks;
    @NotNull
    protected final TextOutput p;

    public static CharSequence javaScriptString(String value2) {
        return JsToStringGenerationVisitor.javaScriptString(value2, false);
    }

    public static CharSequence javaScriptString(CharSequence chars, boolean forceDoubleQuote) {
        int n = chars.length();
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i = 0; i < n; ++i) {
            switch (chars.charAt(i)) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuilder result2 = new StringBuilder(n + 16);
        char quoteChar = quoteCount < aposCount || forceDoubleQuote ? (char)'\"' : '\'';
        result2.append(quoteChar);
        for (int i = 0; i < n; ++i) {
            int hexSize;
            char c = chars.charAt(i);
            if (' ' <= c && c <= '~' && c != quoteChar && c != '\\') {
                result2.append(c);
                continue;
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result2.append('\\');
                result2.append((char)escape);
                continue;
            }
            if (c < '\u0100') {
                result2.append("\\x");
                hexSize = 2;
            } else {
                result2.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                result2.append(HEX_DIGITS[digit]);
            }
        }
        result2.append(quoteChar);
        JsToStringGenerationVisitor.escapeClosingTags(result2);
        return result2;
    }

    private static void escapeClosingTags(StringBuilder str) {
        if (str == null) {
            return;
        }
        int index = 0;
        while ((index = str.indexOf("</", index)) != -1) {
            str.insert(index + 1, '\\');
        }
    }

    public JsToStringGenerationVisitor(@NotNull TextOutput out, @NotNull SourceLocationConsumer sourceLocationConsumer) {
        if (out == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(0);
        }
        if (sourceLocationConsumer == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(1);
        }
        this.sourceInfoStack = new ArrayList<Object>();
        this.insideComments = false;
        this.needSemi = true;
        this.lineBreakAfterBlock = true;
        this.globalBlocks = new ObjectOpenHashSet<JsBlock>();
        this.p = out;
        this.sourceLocationConsumer = sourceLocationConsumer;
    }

    public JsToStringGenerationVisitor(@NotNull TextOutput out) {
        if (out == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(2);
        }
        this(out, NoOpSourceLocationConsumer.INSTANCE);
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(3);
        }
        this.printCommentsBeforeNode(x);
        this.pushSourceInfo(x.getSource());
        this.printPair(x, x.getArrayExpression());
        this.leftSquare();
        this.accept(x.getIndexExpression());
        this.rightSquare();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(4);
        }
        this.printCommentsBeforeNode(x);
        this.pushSourceInfo(x.getSource());
        this.leftSquare();
        this.printExpressions(x.getExpressions());
        this.rightSquare();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    private void printExpressions(List<JsExpression> expressions) {
        boolean notFirst = false;
        for (JsExpression expression2 : expressions) {
            notFirst = this.sepCommaOptSpace(notFirst) && !(expression2 instanceof JsDocComment);
            boolean isEnclosed = this.parenPushIfCommaExpression(expression2);
            this.accept(expression2);
            if (!isEnclosed) continue;
            this.rightParen();
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation binaryOperation) {
        boolean isParenOpened;
        if (binaryOperation == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(5);
        }
        this.printCommentsBeforeNode(binaryOperation);
        this.pushSourceInfo(binaryOperation.getSource());
        JsBinaryOperator operator = binaryOperation.getOperator();
        JsExpression arg1 = binaryOperation.getArg1();
        boolean isExpressionEnclosed = this.parenPush(binaryOperation, arg1, !operator.isLeftAssociative());
        this.accept(arg1);
        if (operator.isKeyword()) {
            this._parenPopOrSpace(binaryOperation, arg1, !operator.isLeftAssociative());
        } else if (operator != JsBinaryOperator.COMMA) {
            if (isExpressionEnclosed) {
                this.rightParen();
            }
            this.spaceOpt();
        }
        this.p.print(operator.getSymbol());
        JsExpression arg2 = binaryOperation.getArg2();
        if (operator == JsBinaryOperator.COMMA) {
            isParenOpened = false;
            this.spaceOpt();
        } else if (arg2 instanceof JsBinaryOperation && ((JsBinaryOperation)arg2).getOperator() == JsBinaryOperator.AND) {
            this.spaceOpt();
            this.leftParen();
            isParenOpened = true;
        } else if (JsToStringGenerationVisitor.spaceCalc(operator, arg2)) {
            isParenOpened = this._parenPushOrSpace(binaryOperation, arg2, operator.isLeftAssociative());
        } else {
            this.spaceOpt();
            isParenOpened = this.parenPush(binaryOperation, arg2, operator.isLeftAssociative());
        }
        this.accept(arg2);
        if (isParenOpened) {
            this.rightParen();
        }
        this.printCommentsAfterNode(binaryOperation);
        this.popSourceInfo();
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(6);
        }
        this.printJsBlock(x, true, null);
    }

    @Override
    public void visitBoolean(@NotNull JsBooleanLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(7);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        if (x.getValue()) {
            this.p.print(CHARS_TRUE);
        } else {
            this.p.print(CHARS_FALSE);
        }
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitBreak(@NotNull JsBreak x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(8);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_BREAK);
        this.continueOrBreakLabel(x);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitContinue(@NotNull JsContinue x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(9);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_CONTINUE);
        this.continueOrBreakLabel(x);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitYield(@NotNull JsYield x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(10);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_YIELD);
        JsExpression expression2 = x.getExpression();
        if (expression2 != null) {
            this.space();
            this.accept(x.getExpression());
        }
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    private void continueOrBreakLabel(JsContinue x) {
        JsNameRef label = x.getLabel();
        if (label != null) {
            this.space();
            this.p.print(label.getIdent());
        }
    }

    @Override
    public void visitCase(@NotNull JsCase x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(11);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_CASE);
        this.space();
        this.accept(x.getCaseExpression());
        this._colon();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        this.newlineOpt();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printSwitchMemberStatements(x);
        this.sourceLocationConsumer.popSourceInfo();
    }

    private void printSwitchMemberStatements(JsSwitchMember x) {
        this.p.indentIn();
        for (JsStatement stmt : x.getStatements()) {
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this.semi();
            }
            this.newlineOpt();
        }
        this.p.indentOut();
        this.needSemi = false;
    }

    @Override
    public void visitCatch(@NotNull JsCatch x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(12);
        }
        this.printCommentsBeforeNode(x);
        this.pushSourceInfo(x.getSource());
        this.spaceOpt();
        this.p.print(CHARS_CATCH);
        this.spaceOpt();
        this.leftParen();
        this.nameDef(x.getParameter().getName());
        JsExpression catchCond = x.getCondition();
        if (catchCond != null) {
            this.space();
            this._if();
            this.space();
            this.accept(catchCond);
        }
        this.rightParen();
        this.spaceOpt();
        this.popSourceInfo();
        this.printCommentsAfterNode(x);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(x.getBody());
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(13);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.printPair(x, x.getTestExpression(), true);
        this.spaceOpt();
        this.p.print('?');
        this.spaceOpt();
        this.printPair(x, x.getThenExpression());
        this.spaceOpt();
        this._colon();
        this.spaceOpt();
        this.printPair(x, x.getElseExpression());
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    private void printPair(JsExpression parent2, JsExpression expression2, boolean wrongAssoc) {
        boolean isNeedParen = JsToStringGenerationVisitor.parenCalc(parent2, expression2, wrongAssoc);
        if (isNeedParen) {
            this.leftParen();
        }
        this.accept(expression2);
        if (isNeedParen) {
            this.rightParen();
        }
    }

    private void printPair(JsExpression parent2, JsExpression expression2) {
        this.printPair(parent2, expression2, false);
    }

    @Override
    public void visitDebugger(@NotNull JsDebugger x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(14);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_DEBUGGER);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitDefault(@NotNull JsDefault x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(15);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_DEFAULT);
        this._colon();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        this.newlineOpt();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printSwitchMemberStatements(x);
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(16);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        JsStatement body2 = JsToStringGenerationVisitor.materialize(x.getBody());
        this.nestedPush(body2);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(body2);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body2);
    }

    @Override
    public void visitDoWhile(@NotNull JsDoWhile x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(17);
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_DO);
        JsStatement body2 = JsToStringGenerationVisitor.materialize(x.getBody());
        this.nestedPush(body2);
        this.accept(body2);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body2);
        this.pushSourceInfo(x.getCondition().getSource());
        if (this.needSemi) {
            this.semi();
            this.newlineOpt();
        } else {
            this.spaceOpt();
            this.needSemi = true;
        }
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitEmpty(@NotNull JsEmpty x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(18);
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Object source;
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(19);
        }
        if ((source = x.getSource()) == null && !(x.getExpression() instanceof JsFunction)) {
            source = x.getExpression().getSource();
        }
        this.pushSourceInfo(source);
        this.printCommentsBeforeNode(x);
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x);
        if (surroundWithParentheses) {
            this.leftParen();
        }
        this.accept(x.getExpression());
        if (surroundWithParentheses) {
            this.rightParen();
        }
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(20);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this._for();
        this.spaceOpt();
        this.leftParen();
        if (x.getInitExpression() != null) {
            this.accept(x.getInitExpression());
        } else if (x.getInitVars() != null) {
            this.accept(x.getInitVars());
        }
        this.semi();
        if (x.getCondition() != null) {
            this.spaceOpt();
            this.accept(x.getCondition());
        }
        this.semi();
        if (x.getIncrementExpression() != null) {
            this.spaceOpt();
            this.accept(x.getIncrementExpression());
        }
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        JsStatement body2 = JsToStringGenerationVisitor.materialize(x.getBody());
        this.nestedPush(body2);
        if (body2 != null) {
            this.sourceLocationConsumer.pushSourceInfo(null);
            this.accept(body2);
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.nestedPop(body2);
    }

    @Override
    public void visitForIn(@NotNull JsForIn x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(21);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this._for();
        this.spaceOpt();
        this.leftParen();
        if (x.getIterVarName() != null) {
            this.var();
            this.space();
            this.nameDef(x.getIterVarName());
            if (x.getIterExpression() != null) {
                this.spaceOpt();
                this.assignment();
                this.spaceOpt();
                this.accept(x.getIterExpression());
            }
        } else {
            this.accept(x.getIterExpression());
        }
        this.space();
        this.p.print(CHARS_IN);
        this.space();
        this.accept(x.getObjectExpression());
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        JsStatement body2 = JsToStringGenerationVisitor.materialize(x.getBody());
        this.nestedPush(body2);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(body2);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body2);
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(22);
        }
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_FUNCTION);
        this.space();
        this.printFunction(x);
        this.printCommentsAfterNode(x);
    }

    private void printFunction(@NotNull JsFunction x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(23);
        }
        if (x.isStatic()) {
            this.p.print(CHARS_STATIC);
            this.space();
        }
        if (x.isGetter()) {
            this.p.print(CHARS_GET);
            this.space();
        } else if (x.isSetter()) {
            this.p.print(CHARS_SET);
            this.space();
        }
        if (x.isGenerator()) {
            this.p.print('*');
        }
        if (x.getName() != null) {
            this.nameOf(x);
        }
        this.pushSourceInfo(x.getSource());
        this.leftParen();
        boolean notFirst = false;
        this.sourceLocationConsumer.pushSourceInfo(null);
        for (JsParameter param : x.getParameters()) {
            notFirst = this.sepCommaOptSpace(notFirst);
            this.accept(param);
        }
        this.sourceLocationConsumer.popSourceInfo();
        this.rightParen();
        this.space();
        this.lineBreakAfterBlock = false;
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printJsBlock(x.getBody(), true, x.getBody().getSource());
        this.sourceLocationConsumer.popSourceInfo();
        this.popSourceInfo();
        this.needSemi = true;
    }

    @Override
    public void visitClass(@NotNull JsClass x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(24);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_CLASS);
        this.space();
        if (x.getName() != null) {
            this.nameOf(x);
        }
        if (x.getBaseClass() != null) {
            this.space();
            this.p.print(CHARS_EXTENDS);
            this.space();
            this.accept(x.getBaseClass());
        }
        this.space();
        if (x.getConstructor() == null && x.getMembers().isEmpty()) {
            this.p.print("{}");
            this.newline();
        } else {
            this.blockOpen();
            if (x.getConstructor() != null) {
                this.p.print(CHARS_CONSTRUCTOR);
                x.getConstructor().setName(null);
                this.printFunction(x.getConstructor());
                this.newline();
            }
            for (JsFunction m : x.getMembers()) {
                this.printFunction(m);
                this.newline();
            }
            this.blockClose();
        }
        this.needSemi = false;
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(25);
        }
        this.printCommentsBeforeNode(x);
        this.pushSourceInfo(x.getSource());
        this._if();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getIfExpression());
        this.rightParen();
        this.popSourceInfo();
        this.printCommentsAfterNode(x);
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStatement = x.getElseStatement();
        if (elseStatement != null && JsToStringGenerationVisitor.isIfWithoutElse(thenStmt)) {
            thenStmt = new JsBlock(thenStmt);
        }
        this.nestedPush(thenStmt);
        if (thenStmt instanceof JsBlock && elseStatement != null) {
            this.lineBreakAfterBlock = false;
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(JsToStringGenerationVisitor.materialize(thenStmt));
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(thenStmt);
        if (elseStatement != null) {
            if (this.needSemi) {
                this.semi();
                this.newlineOpt();
            } else {
                this.spaceOpt();
                this.needSemi = true;
            }
            this.p.print(CHARS_ELSE);
            boolean elseIf = elseStatement instanceof JsIf;
            if (!elseIf) {
                this.nestedPush(elseStatement);
            } else {
                this.space();
            }
            this.sourceLocationConsumer.pushSourceInfo(null);
            this.accept(JsToStringGenerationVisitor.materialize(elseStatement));
            this.sourceLocationConsumer.popSourceInfo();
            if (!elseIf) {
                this.nestedPop(elseStatement);
            }
        }
    }

    private static boolean isIfWithoutElse(@NotNull JsStatement statement) {
        if (statement == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(26);
        }
        while (statement instanceof JsIf) {
            JsIf ifStatement = (JsIf)statement;
            if (ifStatement.getElseStatement() == null) {
                return true;
            }
            statement = ifStatement.getElseStatement();
        }
        return false;
    }

    private static JsStatement materialize(JsStatement statement) {
        return statement instanceof JsCompositeBlock ? new JsBlock(statement) : statement;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(27);
        }
        this.pushSourceInfo(invocation.getSource());
        this.printCommentsBeforeNode(invocation);
        this.printPair(invocation, invocation.getQualifier());
        this.leftParen();
        this.printExpressions(invocation.getArguments());
        this.rightParen();
        this.printCommentsAfterNode(invocation);
        this.popSourceInfo();
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(28);
        }
        this.nameOf(x);
        this._colon();
        this.spaceOpt();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(x.getStatement());
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(29);
        }
        this.visitNameRef(nameRef, true);
    }

    public void visitNameRef(@NotNull JsNameRef nameRef, boolean withQualifier) {
        if (nameRef == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(30);
        }
        this.printCommentsBeforeNode(nameRef);
        this.p.maybeIndent();
        JsExpression qualifier = nameRef.getQualifier();
        if (qualifier != null && withQualifier) {
            boolean enclose = qualifier instanceof JsLiteral.JsValueLiteral ? qualifier instanceof JsNumberLiteral : JsToStringGenerationVisitor.parenCalc(nameRef, qualifier, false);
            if (enclose) {
                this.leftParen();
            }
            this.accept(qualifier);
            if (enclose) {
                this.rightParen();
            }
            this.p.print('.');
        }
        this.pushSourceInfo(nameRef.getSource());
        this.p.print(nameRef.getIdent());
        this.popSourceInfo();
        this.printCommentsAfterNode(nameRef);
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(31);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_NEW);
        this.space();
        JsExpression constructorExpression = x.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(constructorExpression);
        if (needsParens) {
            this.leftParen();
        }
        this.accept(constructorExpression);
        if (needsParens) {
            this.rightParen();
        }
        this.leftParen();
        this.printExpressions(x.getArguments());
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(32);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_NULL);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitInt(@NotNull JsIntLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(33);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(x.value);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitDouble(@NotNull JsDoubleLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(34);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(x.value);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral objectLiteral) {
        if (objectLiteral == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(35);
        }
        this.pushSourceInfo(objectLiteral.getSource());
        this.printCommentsBeforeNode(objectLiteral);
        this.p.print('{');
        if (objectLiteral.isMultiline()) {
            this.p.indentIn();
        }
        boolean notFirst = false;
        for (JsPropertyInitializer item : objectLiteral.getPropertyInitializers()) {
            JsStringLiteral stringLiteral;
            String value2;
            if (notFirst) {
                this.p.print(',');
            }
            if (objectLiteral.isMultiline()) {
                this.newlineOpt();
            } else if (notFirst) {
                this.spaceOpt();
            }
            notFirst = true;
            this.pushSourceInfo(item.getSource());
            JsExpression labelExpr = item.getLabelExpr();
            if (labelExpr instanceof JsStringLiteral && IdentifierPolicyKt.isValidES5Identifier(value2 = (stringLiteral = (JsStringLiteral)labelExpr).getValue())) {
                labelExpr = (JsExpression)new JsNameRef(value2).withMetadataFrom(stringLiteral);
            }
            if (labelExpr instanceof JsNameRef) {
                this.visitNameRef((JsNameRef)labelExpr, false);
            } else {
                this.accept(labelExpr);
            }
            this._colon();
            this.space();
            JsExpression valueExpr = item.getValueExpr();
            boolean wasEnclosed = this.parenPushIfCommaExpression(valueExpr);
            this.accept(valueExpr);
            if (wasEnclosed) {
                this.rightParen();
            }
            this.popSourceInfo();
        }
        if (objectLiteral.isMultiline()) {
            this.p.indentOut();
            this.newlineOpt();
        }
        this.p.print('}');
        this.printCommentsAfterNode(objectLiteral);
        this.popSourceInfo();
    }

    @Override
    public void visitParameter(@NotNull JsParameter x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(36);
        }
        this.pushSourceInfo(x.getSource());
        this.nameOf(x);
        this.popSourceInfo();
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(37);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        JsUnaryOperator op = x.getOperator();
        JsExpression arg = x.getArg();
        this.printPair(x, arg);
        this.p.print(op.getSymbol());
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(38);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        JsUnaryOperator op = x.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x.getArg();
        if (JsToStringGenerationVisitor.spaceCalc(op, arg)) {
            this.space();
        }
        this.printPair(x, arg);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitProgram(@NotNull JsProgram x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(39);
        }
        x.acceptChildren(this);
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(40);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.slash();
        this.p.print(x.getPattern());
        this.slash();
        String flags = x.getFlags();
        if (flags != null) {
            this.p.print(flags);
        }
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(41);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_RETURN);
        JsExpression expr = x.getExpression();
        if (expr != null) {
            this.space();
            this.accept(expr);
        }
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(42);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(JsToStringGenerationVisitor.javaScriptString(x.getValue()));
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visit(@NotNull JsSwitch x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(43);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_SWITCH);
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getExpression());
        this.rightParen();
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.spaceOpt();
        this.blockOpen();
        this.acceptList(x.getCases());
        this.blockClose();
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitThis(@NotNull JsThisRef x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(44);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_THIS);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitSuper(@NotNull JsSuperRef x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(45);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_SUPER);
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitThrow(@NotNull JsThrow x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(46);
        }
        this.pushSourceInfo(x.getSource());
        this.printCommentsBeforeNode(x);
        this.p.print(CHARS_THROW);
        this.space();
        this.accept(x.getExpression());
        this.printCommentsAfterNode(x);
        this.popSourceInfo();
    }

    @Override
    public void visitTry(@NotNull JsTry x) {
        if (x == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(47);
        }
        this.printCommentsBeforeNode(x);
        this.pushSourceInfo(x.getSource());
        this.p.print(CHARS_TRY);
        this.spaceOpt();
        this.lineBreakAfterBlock = false;
        this.popSourceInfo();
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatches());
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this.p.print(CHARS_FINALLY);
            this.spaceOpt();
            this.accept(finallyBlock);
        }
        this.printCommentsAfterNode(x);
    }

    @Override
    public void visit(@NotNull JsVars.JsVar var) {
        if (var == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(48);
        }
        this.pushSourceInfo(var.getSource());
        this.printCommentsBeforeNode(var);
        this.nameOf(var);
        JsExpression initExpr = var.getInitExpression();
        if (initExpr != null) {
            this.spaceOpt();
            this.assignment();
            this.spaceOpt();
            boolean isEnclosed = this.parenPushIfCommaExpression(initExpr);
            this.accept(initExpr);
            if (isEnclosed) {
                this.rightParen();
            }
        }
        this.printCommentsAfterNode(var);
        this.popSourceInfo();
    }

    @Override
    public void visitVars(@NotNull JsVars vars) {
        if (vars == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(49);
        }
        this.pushSourceInfo(vars.getSource());
        this.printCommentsBeforeNode(vars);
        this.var();
        this.space();
        boolean sep = false;
        for (JsVars.JsVar var : vars) {
            if (sep) {
                if (vars.isMultiline()) {
                    this.newlineOpt();
                }
                this.p.print(',');
                this.spaceOpt();
            } else {
                sep = true;
            }
            this.accept(var);
        }
        this.printCommentsAfterNode(vars);
        this.popSourceInfo();
    }

    @Override
    public void visitSingleLineComment(@NotNull JsSingleLineComment comment) {
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(50);
        }
        if (this.needSemi && this.insideComments) {
            this.semi();
            this.space();
        }
        this.p.print("//");
        this.p.print(comment.getText());
        this.newline();
        this.needSemi = false;
    }

    @Override
    public void visitMultiLineComment(@NotNull JsMultiLineComment comment) {
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(51);
        }
        List<String> lines = StringsKt.lines(comment.getText());
        this.p.print("/*");
        this.p.print(lines.get(0).trim());
        for (int i = 1; i < lines.size(); ++i) {
            this.newline();
            this.p.print(lines.get(i).trim());
        }
        this.p.print("*/");
    }

    @Override
    public void visitDocComment(@NotNull JsDocComment comment) {
        boolean asSingleLine;
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(52);
        }
        boolean bl = asSingleLine = comment.getTags().size() == 1;
        if (!asSingleLine) {
            this.newlineOpt();
        }
        this.p.print("/**");
        if (asSingleLine) {
            this.space();
        } else {
            this.newline();
        }
        boolean notFirst = false;
        for (Map.Entry<String, Object> entry : comment.getTags().entrySet()) {
            if (notFirst) {
                this.newline();
                this.p.print(' ');
                this.p.print('*');
            } else {
                notFirst = true;
            }
            this.p.print('@');
            this.p.print(entry.getKey());
            Object value2 = entry.getValue();
            if (value2 != null) {
                this.space();
                if (value2 instanceof CharSequence) {
                    this.p.print((CharSequence)value2);
                } else {
                    this.visitNameRef((JsNameRef)value2);
                }
            }
            if (asSingleLine) continue;
            this.newline();
        }
        if (asSingleLine) {
            this.space();
        } else {
            this.newlineOpt();
        }
        this.p.print('*');
        this.p.print('/');
        if (asSingleLine) {
            this.spaceOpt();
        }
    }

    private void newlineOpt() {
        if (!this.p.isCompact()) {
            this.newline();
        }
    }

    @Override
    public void visitExport(@NotNull JsExport export) {
        if (export == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(53);
        }
        this.p.print("export");
        this.space();
        JsExport.Subject subject = export.getSubject();
        if (subject instanceof JsExport.Subject.All) {
            this.p.print("*");
        } else if (subject instanceof JsExport.Subject.Elements) {
            this.blockOpen();
            List<JsExport.Element> elements = ((JsExport.Subject.Elements)subject).getElements();
            for (JsExport.Element element : elements) {
                this.visitNameRef(element.getName());
                JsName alias = element.getAlias();
                if (alias != null) {
                    this.p.print(" as ");
                    this.nameDef(alias);
                }
                this.p.print(',');
                this.p.newline();
            }
            this.p.indentOut();
            this.p.print('}');
        }
        if (export.getFromModule() != null) {
            this.p.print(" from ");
            this.p.print(JsToStringGenerationVisitor.javaScriptString(export.getFromModule()));
        }
        this.needSemi = true;
    }

    @Override
    public void visitImport(@NotNull JsImport jsImport) {
        if (jsImport == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(54);
        }
        JsImport.Target target = jsImport.getTarget();
        this.p.print("import ");
        if (target instanceof JsImport.Target.Default) {
            this.visitNameRef(((JsImport.Target.Default)target).getName());
        } else if (target instanceof JsImport.Target.All) {
            this.p.print("* as ");
            this.visitNameRef(((JsImport.Target.All)target).getAlias());
        } else if (target instanceof JsImport.Target.Elements) {
            List<JsImport.Element> elements = ((JsImport.Target.Elements)target).getElements();
            this.p.print("{");
            boolean isMultiline = elements.size() > 1;
            this.p.indentIn();
            if (isMultiline) {
                this.newlineOpt();
            } else {
                this.space();
            }
            for (JsImport.Element element : elements) {
                this.nameDef(element.getName());
                JsNameRef alias = element.getAlias();
                if (alias != null) {
                    this.p.print(" as ");
                    this.visitNameRef(alias);
                }
                if (isMultiline) {
                    this.p.print(',');
                    this.newlineOpt();
                    continue;
                }
                this.space();
            }
            this.p.indentOut();
            this.p.print("}");
        }
        if (target != JsImport.Target.Effect.INSTANCE) {
            this.p.print(" from ");
        }
        this.p.print(JsToStringGenerationVisitor.javaScriptString(jsImport.getModule()));
    }

    private void newline() {
        this.p.newline();
        this.sourceLocationConsumer.newLine();
    }

    private void pushSourceInfo(Object location) {
        this.p.maybeIndent();
        this.sourceInfoStack.add(location);
        if (location != null) {
            this.sourceLocationConsumer.pushSourceInfo(location);
        }
    }

    private void printCommentsBeforeNode(JsNode x) {
        this.printComments(x.getCommentsBeforeNode(), false);
    }

    private void printCommentsAfterNode(JsNode x) {
        this.printComments(x.getCommentsAfterNode(), true);
    }

    private void printComments(List<JsComment> comments, boolean isAfterNode) {
        if (comments == null) {
            return;
        }
        boolean previousNeedSemi = this.needSemi;
        this.needSemi = isAfterNode;
        this.insideComments = true;
        for (JsComment comment : comments) {
            comment.accept(this);
        }
        this.insideComments = false;
        if (!isAfterNode) {
            this.needSemi = previousNeedSemi;
        }
    }

    private void popSourceInfo() {
        if (!this.sourceInfoStack.isEmpty() && this.sourceInfoStack.remove(this.sourceInfoStack.size() - 1) != null) {
            this.sourceLocationConsumer.popSourceInfo();
        }
    }

    private void printJsBlock(JsBlock x, boolean finalNewline, @Nullable Object defaultClosingBraceLocation) {
        boolean needBraces;
        if (!this.lineBreakAfterBlock) {
            finalNewline = false;
            this.lineBreakAfterBlock = true;
        }
        this.printCommentsBeforeNode(x);
        boolean bl = needBraces = !x.isTransparent();
        if (needBraces) {
            this.sourceLocationConsumer.pushSourceInfo(x.getSource());
            this.blockOpen();
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        Iterator<JsStatement> iterator2 = x.getStatements().iterator();
        while (iterator2.hasNext()) {
            boolean lastStatement;
            boolean isGlobal = x.isTransparent() || this.globalBlocks.contains(x);
            JsStatement statement = iterator2.next();
            if (statement instanceof JsEmpty) continue;
            this.needSemi = true;
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && statement instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)statement);
            }
            this.accept(statement);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(statement);
            }
            if (!this.needSemi) continue;
            boolean functionStmt = statement instanceof JsExpressionStatement && ((JsExpressionStatement)statement).getExpression() instanceof JsFunction;
            boolean bl2 = lastStatement = !iterator2.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(statement);
            if (functionStmt) {
                if (lastStatement) {
                    this.newlineOpt();
                    continue;
                }
                this.newline();
                continue;
            }
            if (lastStatement) {
                this.p.printOpt(';');
            } else {
                this.semi();
            }
            this.newlineOpt();
        }
        if (needBraces) {
            this.p.indentOut();
            this.sourceLocationConsumer.popSourceInfo();
            Object closingBraceLocation = x.getClosingBraceSource();
            if (closingBraceLocation == null) {
                closingBraceLocation = defaultClosingBraceLocation;
            }
            if (closingBraceLocation != null) {
                this.pushSourceInfo(closingBraceLocation);
            }
            this.p.print('}');
            if (closingBraceLocation != null) {
                this.popSourceInfo();
            }
            if (finalNewline) {
                this.newlineOpt();
            }
        } else {
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.needSemi = false;
        this.printCommentsAfterNode(x);
    }

    private void assignment() {
        this.p.print('=');
    }

    private void blockClose() {
        this.p.indentOut();
        this.p.print('}');
        this.newlineOpt();
    }

    private void blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this.newlineOpt();
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void leftParen() {
        this.p.print('(');
    }

    private void leftSquare() {
        this.p.print('[');
    }

    private void nameDef(JsName name2) {
        this.p.print(name2.getIdent());
    }

    private void nameOf(HasName hasName) {
        this.nameDef(hasName.getName());
    }

    private boolean nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean nestedPush(JsStatement statement) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            this.newlineOpt();
            this.p.indentIn();
        } else {
            this.spaceOpt();
        }
        return push;
    }

    private static boolean parenCalc(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent2);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean _parenPopOrSpace(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPop = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPop) {
            this.rightParen();
        } else {
            this.space();
        }
        return doPop;
    }

    private boolean parenPush(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean parenPushIfCommaExpression(JsExpression x) {
        boolean doPush;
        boolean bl = doPush = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        } else {
            this.space();
        }
        return doPush;
    }

    private void rightParen() {
        this.p.print(')');
    }

    private void rightSquare() {
        this.p.print(']');
    }

    private void semi() {
        this.p.print(';');
    }

    private boolean sepCommaOptSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this.spaceOpt();
        }
        return true;
    }

    private void slash() {
        this.p.print('/');
    }

    private void space() {
        this.p.print(' ');
    }

    private static boolean spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            return binary.getOperator().getPrecedence() > op.getPrecedence() && JsToStringGenerationVisitor.spaceCalc(op, binary.getArg1());
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && (op2 == JsUnaryOperator.DEC || op2 == JsUnaryOperator.NEG) || op == JsBinaryOperator.ADD && op2 == JsUnaryOperator.INC;
        }
        if (arg instanceof JsNumberLiteral && (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG)) {
            if (arg instanceof JsIntLiteral) {
                return ((JsIntLiteral)arg).value < 0;
            }
            assert (arg instanceof JsDoubleLiteral);
            return ((JsDoubleLiteral)arg).value < 0.0;
        }
        return false;
    }

    private void spaceOpt() {
        this.p.printOpt(' ');
    }

    private void var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLocationConsumer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryOperation";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "export";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsImport";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/backend/JsToStringGenerationVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArray";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBoolean";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBreak";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitContinue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitYield";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCatch";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditional";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDebugger";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDefault";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEmpty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpressionStatement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForIn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunction";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "printFunction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClass";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIf";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfWithoutElse";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvocation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLabel";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameRef";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNew";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNull";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDouble";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectLiteral";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParameter";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixOperation";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixOperation";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "visitProgram";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRegExp";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturn";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "visitString";
                break;
            }
            case 43: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThis";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuper";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThrow";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTry";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVars";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSingleLineComment";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMultiLineComment";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocComment";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExport";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "visitImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

