/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/SignatureSerializer;", "", "<init>", "()V", "methodDesc", "", "method", "Ljava/lang/reflect/Method;", "constructorDesc", "constructor", "Ljava/lang/reflect/Constructor;", "fieldDesc", "field", "Ljava/lang/reflect/Field;", "descriptors.runtime"})
final class SignatureSerializer {
    @NotNull
    public static final SignatureSerializer INSTANCE = new SignatureSerializer();

    private SignatureSerializer() {
    }

    @NotNull
    public final String methodDesc(@NotNull Method method) {
        Intrinsics.checkNotNullParameter(method, "method");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Iterator<Class<?>> iterator2 = ArrayIteratorKt.iterator(method.getParameterTypes());
        while (iterator2.hasNext()) {
            Class<?> parameterType = iterator2.next();
            Intrinsics.checkNotNull(parameterType);
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, "getReturnType(...)");
        sb.append(ReflectClassUtilKt.getDesc(clazz));
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String constructorDesc(@NotNull Constructor<?> constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Iterator<Class<?>> iterator2 = ArrayIteratorKt.iterator(constructor2.getParameterTypes());
        while (iterator2.hasNext()) {
            Class<?> parameterType = iterator2.next();
            Intrinsics.checkNotNull(parameterType);
            sb.append(ReflectClassUtilKt.getDesc(parameterType));
        }
        sb.append(")V");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String fieldDesc(@NotNull Field field) {
        Intrinsics.checkNotNullParameter(field, "field");
        Class<?> clazz = field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, "getType(...)");
        return ReflectClassUtilKt.getDesc(clazz);
    }
}

