/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H$\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer;", "T", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "definedMetadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;)V", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "metadataVersion", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "analyzeAndSerialize", "", "analyze", "()Ljava/lang/Object;", "serialize", "analysisResult", "destDir", "Ljava/io/File;", "(Ljava/lang/Object;Ljava/io/File;)V", "cli"})
public abstract class AbstractMetadataSerializer<T> {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final KotlinCoreEnvironment environment;
    @NotNull
    private final BuiltInsBinaryVersion metadataVersion;

    public AbstractMetadataSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment, @Nullable BuiltInsBinaryVersion definedMetadataVersion) {
        BinaryVersion binaryVersion;
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(environment, "environment");
        this.configuration = configuration2;
        this.environment = environment;
        BuiltInsBinaryVersion builtInsBinaryVersion = definedMetadataVersion;
        if (builtInsBinaryVersion == null && (builtInsBinaryVersion = (binaryVersion = this.configuration.get(CommonConfigurationKeys.METADATA_VERSION)) instanceof BuiltInsBinaryVersion ? (BuiltInsBinaryVersion)binaryVersion : null) == null) {
            builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        }
        this.metadataVersion = builtInsBinaryVersion;
    }

    public /* synthetic */ AbstractMetadataSerializer(CompilerConfiguration compilerConfiguration, KotlinCoreEnvironment kotlinCoreEnvironment, BuiltInsBinaryVersion builtInsBinaryVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            builtInsBinaryVersion = null;
        }
        this(compilerConfiguration, kotlinCoreEnvironment, builtInsBinaryVersion);
    }

    @NotNull
    public final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final KotlinCoreEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    protected final BuiltInsBinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    public final void analyzeAndSerialize() {
        File destDir = CommonAnalysisKt.getDestDir(this.environment);
        if (destDir == null) {
            CompilerConfiguration configuration2 = this.environment.getConfiguration();
            MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Intrinsics.checkNotNullExpressionValue(messageCollector, "getNotNull(...)");
            MessageCollector messageCollector2 = messageCollector;
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify destination via -d", null, 4, null);
            return;
        }
        T t = this.analyze();
        if (t == null) {
            return;
        }
        T analysisResult2 = t;
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this.environment.getConfiguration().getNotNull(CLIConfigurationKeys.PERF_MANAGER);
        Intrinsics.checkNotNullExpressionValue(commonCompilerPerformanceManager, "getNotNull(...)");
        CommonCompilerPerformanceManager performanceManager2 = commonCompilerPerformanceManager;
        performanceManager2.notifyGenerationStarted();
        this.serialize(analysisResult2, destDir);
        performanceManager2.notifyGenerationFinished();
    }

    @Nullable
    protected abstract T analyze();

    protected abstract void serialize(T var1, @NotNull File var2);
}

