/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLocalResolver {
    private final LighterAST myTree;

    public FileLocalResolver(@NotNull LighterAST tree) {
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    @NotNull
    public LighterAST getLightTree() {
        LighterAST lighterAST = this.myTree;
        if (lighterAST == null) {
            FileLocalResolver.$$$reportNull$$$0(1);
        }
        return lighterAST;
    }

    @NotNull
    public LightResolveResult resolveLocally(@NotNull LighterASTNode ref) {
        String refName;
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(2);
        }
        if ((refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, ref)) == null) {
            LightResolveResult lightResolveResult = LightResolveResult.UNKNOWN;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(3);
            }
            return lightResolveResult;
        }
        if (!this.canResolveToLocalVariable(this.myTree, ref)) {
            LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
            if (lightResolveResult == null) {
                FileLocalResolver.$$$reportNull$$$0(4);
            }
            return lightResolveResult;
        }
        boolean passedClass = false;
        LighterASTNode lastParent = ref;
        while (true) {
            ProgressManager.checkCanceled();
            LighterASTNode scope2 = this.myTree.getParent(lastParent);
            if (scope2 == null) {
                LightResolveResult lightResolveResult = LightResolveResult.NON_LOCAL;
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(5);
                }
                return lightResolveResult;
            }
            for (LighterASTNode var : this.getDeclarations(scope2, lastParent)) {
                if (!refName.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, var))) continue;
                if (passedClass) {
                    IElementType type2 = var.getTokenType();
                    LightResolveResult lightResolveResult = type2 == JavaElementType.FIELD || type2 == JavaElementType.RECORD_COMPONENT ? LightResolveResult.NON_LOCAL : LightResolveResult.UNKNOWN;
                    if (lightResolveResult == null) {
                        FileLocalResolver.$$$reportNull$$$0(6);
                    }
                    return lightResolveResult;
                }
                LightResolveResult lightResolveResult = LightResolveResult.resolved(var);
                if (lightResolveResult == null) {
                    FileLocalResolver.$$$reportNull$$$0(7);
                }
                return lightResolveResult;
            }
            lastParent = scope2;
            passedClass |= scope2.getTokenType() == JavaElementType.CLASS || scope2.getTokenType() == JavaElementType.ANONYMOUS_CLASS;
        }
    }

    private boolean canResolveToLocalVariable(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        LighterASTNode parent2;
        if (tree == null) {
            FileLocalResolver.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(9);
        }
        return (parent2 = tree.getParent(ref)) != null && parent2.getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && !this.hasQualifier(ref);
    }

    private boolean hasQualifier(@NotNull LighterASTNode ref) {
        if (ref == null) {
            FileLocalResolver.$$$reportNull$$$0(10);
        }
        return LightTreeUtil.firstChildOfType(this.myTree, ref, ElementType.EXPRESSION_BIT_SET) != null;
    }

    @NotNull
    private Iterable<LighterASTNode> getDeclarations(LighterASTNode scope2, @Nullable LighterASTNode lastParent) {
        IElementType type2 = scope2.getTokenType();
        if (type2 == JavaElementType.CODE_BLOCK) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope2, JavaElementType.DECLARATION_STATEMENT), lastParent));
        }
        if (type2 == JavaElementType.DECLARATION_STATEMENT) {
            return FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope2, JavaElementType.LOCAL_VARIABLE), lastParent);
        }
        if (type2 == JavaElementType.FOR_STATEMENT) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope2, ElementType.JAVA_STATEMENT_BIT_SET), lastParent));
        }
        if (type2 == JavaElementType.FOREACH_STATEMENT || type2 == JavaElementType.CATCH_SECTION) {
            JBIterable<LighterASTNode> jBIterable = JBIterable.of(LightTreeUtil.firstChildOfType(this.myTree, scope2, JavaElementType.PARAMETER));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.TRY_STATEMENT) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope2, JavaElementType.RESOURCE_LIST), lastParent));
        }
        if (type2 == JavaElementType.RESOURCE_LIST) {
            return FileLocalResolver.before(LightTreeUtil.getChildrenOfType(this.myTree, scope2, JavaElementType.RESOURCE_VARIABLE), lastParent);
        }
        if (type2 == JavaElementType.CLASS) {
            List<LighterASTNode> fields2 = LightTreeUtil.getChildrenOfType(this.myTree, scope2, JavaElementType.FIELD);
            LighterASTNode recordHeader = LightTreeUtil.firstChildOfType(this.myTree, scope2, JavaElementType.RECORD_HEADER);
            if (recordHeader == null) {
                List<LighterASTNode> list = fields2;
                if (list == null) {
                    FileLocalResolver.$$$reportNull$$$0(12);
                }
                return list;
            }
            JBIterable<List<LighterASTNode>> jBIterable = JBIterable.from(fields2).append((LighterASTNode)((Object)LightTreeUtil.getChildrenOfType(this.myTree, recordHeader, JavaElementType.RECORD_COMPONENT)));
            if (jBIterable == null) {
                FileLocalResolver.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.METHOD) {
            LighterASTNode paramList = LightTreeUtil.firstChildOfType(this.myTree, scope2, JavaElementType.PARAMETER_LIST);
            List<LighterASTNode> list = paramList == null ? ContainerUtil.emptyList() : LightTreeUtil.getChildrenOfType(this.myTree, paramList, JavaElementType.PARAMETER);
            if (list == null) {
                FileLocalResolver.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<LighterASTNode> list = Collections.emptyList();
        if (list == null) {
            FileLocalResolver.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private JBIterable<LighterASTNode> walkChildrenScopes(JBIterable<LighterASTNode> children) {
        JBIterable<LighterASTNode> jBIterable = children.flatMap(child -> this.getDeclarations((LighterASTNode)child, null));
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<LighterASTNode> before(List<LighterASTNode> children, @Nullable LighterASTNode lastParent) {
        JBIterable<LighterASTNode> jBIterable = JBIterable.from(children).filter(node -> lastParent == null || node.getStartOffset() < lastParent.getStartOffset());
        if (jBIterable == null) {
            FileLocalResolver.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var) {
        if (var == null) {
            FileLocalResolver.$$$reportNull$$$0(18);
        }
        return this.getShortClassTypeName(var, 0);
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var, int arrayDepth) {
        if (var == null) {
            FileLocalResolver.$$$reportNull$$$0(19);
        }
        LighterASTNode typeNode = LightTreeUtil.firstChildOfType(this.myTree, var, JavaElementType.TYPE);
        while (arrayDepth > 0) {
            LighterASTNode bracket = LightTreeUtil.firstChildOfType(this.myTree, typeNode, JavaTokenType.LBRACKET);
            if (bracket == null) {
                return null;
            }
            typeNode = LightTreeUtil.firstChildOfType(this.myTree, typeNode, JavaElementType.TYPE);
            --arrayDepth;
        }
        LighterASTNode typeRef = LightTreeUtil.firstChildOfType(this.myTree, typeNode, JavaElementType.JAVA_CODE_REFERENCE);
        String refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, typeRef);
        if (refName == null) {
            return null;
        }
        if (LightTreeUtil.firstChildOfType(this.myTree, typeRef, JavaElementType.JAVA_CODE_REFERENCE) != null) {
            return refName;
        }
        if (this.isTypeParameter(refName, var)) {
            return null;
        }
        return refName;
    }

    private boolean isTypeParameter(String name2, LighterASTNode place) {
        LighterASTNode scope2 = place;
        while (scope2 != null) {
            if (scope2.getTokenType() == JavaElementType.CLASS || scope2.getTokenType() == JavaElementType.METHOD) {
                if (this.hasOwnTypeParameter(name2, scope2)) {
                    return true;
                }
                if (this.isStatic(scope2)) break;
            }
            scope2 = this.myTree.getParent(scope2);
        }
        return false;
    }

    private boolean hasOwnTypeParameter(String name2, LighterASTNode member) {
        LighterASTNode typeParams = LightTreeUtil.firstChildOfType(this.myTree, member, JavaElementType.TYPE_PARAMETER_LIST);
        if (typeParams != null) {
            for (LighterASTNode param : LightTreeUtil.getChildrenOfType(this.myTree, typeParams, JavaElementType.TYPE_PARAMETER)) {
                if (!name2.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, param))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStatic(LighterASTNode scope2) {
        LighterASTNode modList = LightTreeUtil.firstChildOfType(this.myTree, scope2, JavaElementType.MODIFIER_LIST);
        return modList != null && LightTreeUtil.firstChildOfType(this.myTree, modList, JavaTokenType.STATIC_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/FileLocalResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "walkChildrenScopes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "before";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canResolveToLocalVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassTypeName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LightResolveResult {
        public static final LightResolveResult UNKNOWN = new LightResolveResult();
        public static final LightResolveResult NON_LOCAL = new LightResolveResult();

        @NotNull
        static LightResolveResult resolved(final @NotNull LighterASTNode target) {
            if (target == null) {
                LightResolveResult.$$$reportNull$$$0(0);
            }
            return new LightResolveResult(){

                @Override
                public LighterASTNode getTarget() {
                    return target;
                }
            };
        }

        @Nullable
        public LighterASTNode getTarget() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/source/FileLocalResolver$LightResolveResult", "resolved"));
        }
    }
}

