/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r*\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015*\b\u0012\u0004\u0012\u00020\u00160\u0012\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "checkCompatibilityFlag", "", "checkCycle", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "configFile", "", "visitedFiles", "", "pluginPathToUserString", "file", "Ljava/nio/file/Path;", "toPluginDescriptors", "", "Lcom/intellij/openapi/extensions/PluginId;", "toPluginSet", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "intellij.platform.core.impl"})
public final class IdeaPluginDescriptorImplKt {
    private static final boolean checkCompatibilityFlag = Intrinsics.areEqual(System.getProperty("idea.plugin.check.compatibility", "true"), "false") ^ true;

    private static final Logger getLOG() {
        Logger logger = PluginManagerCore.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "PluginManagerCore.getLogger()");
        return logger;
    }

    @NotNull
    public static final String pluginPathToUserString(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return StringsKt.replace$default(((Object)file2).toString(), System.getProperty("user.home") + File.separatorChar, "" + '~' + File.separatorChar, false, 4, null);
    }

    private static final void checkCycle(IdeaPluginDescriptorImpl descriptor, String configFile, List<String> visitedFiles) {
        int n = visitedFiles.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual(configFile, visitedFiles.get(i))) continue;
            List<String> cycle = visitedFiles.subList(i, visitedFiles.size());
            throw (Throwable)new RuntimeException("Plugin " + descriptor + " optional descriptors form a cycle: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)cycle));
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return IdeaPluginDescriptorImplKt.getLOG();
    }

    public static final /* synthetic */ void access$checkCycle(IdeaPluginDescriptorImpl descriptor, String configFile, List visitedFiles) {
        IdeaPluginDescriptorImplKt.checkCycle(descriptor, configFile, visitedFiles);
    }

    public static final /* synthetic */ boolean access$getCheckCompatibilityFlag$p() {
        return checkCompatibilityFlag;
    }
}

