/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.nio.BaseBufferReadbackStrategy;
import com.terracottatech.frs.io.nio.ChannelOpener;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedReadbackStrategy
extends BaseBufferReadbackStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReadbackStrategy.class);
    private final NavigableMap<Long, BaseBufferReadbackStrategy.Marker> boundaries = new ConcurrentSkipListMap<Long, BaseBufferReadbackStrategy.Marker>();
    private final ReentrantReadWriteLock block;
    private long offset = 0L;
    private long length = 0L;

    public BufferedReadbackStrategy(Direction dir, FileChannel channel, BufferSource source, ChannelOpener opener) throws IOException {
        super(dir, channel, source, opener);
        this.length = channel.position();
        boolean sealed = this.createIndex(dir == Direction.RANDOM);
        this.block = !sealed ? new ReentrantReadWriteLock() : null;
        this.offset = this.boundaries.isEmpty() ? 0L : (dir == Direction.REVERSE ? (Long)this.boundaries.lastKey() : (dir == Direction.FORWARD ? (Long)this.boundaries.firstKey() : Long.MIN_VALUE));
    }

    public BufferedReadbackStrategy(Direction dir, FileChannel channel, BufferSource source) throws IOException {
        this(dir, channel, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createIndex(boolean full) throws IOException {
        ByteBuffer buffer;
        long[] jumps = null;
        long lastKey = Long.MIN_VALUE;
        long capacity = this.getChannel().size();
        if (capacity > 8192L) {
            ByteBuffer grab;
            int stretch;
            int jump;
            int num;
            buffer = this.allocate(8);
            try {
                this.readDirect(capacity - 8L, buffer);
                num = buffer.getInt();
                jump = buffer.getInt();
            }
            finally {
                this.free(buffer);
            }
            if (num >= 0 && SegmentHeaders.JUMP_LIST.validate(jump) && (long)(stretch = num * 4 + 8 + 4) < capacity && (grab = this.allocate(stretch)) != null) {
                try {
                    this.readDirect(capacity - (long)stretch, grab);
                    jumps = this.readJumpList(grab);
                }
                finally {
                    this.free(grab);
                }
            }
        }
        if (jumps == null) {
            return this.updateIndex();
        }
        buffer = this.allocate(16);
        try {
            long first = this.getChannel().position();
            if (full || jumps.length == 0) {
                long last = first;
                buffer.mark();
                for (void var15_20 : jumps) {
                    this.readDirect((long)(var15_20 - 20L), buffer);
                    long clen = buffer.getLong();
                    long marker = buffer.getLong();
                    if (last != var15_20 - 20L - clen - 12L) {
                        throw new AssertionError((Object)"bad start position");
                    }
                    this.boundaries.put(marker, new BaseBufferReadbackStrategy.Marker(last, marker));
                    last = var15_20;
                    buffer.reset();
                }
                if (!this.boundaries.isEmpty()) {
                    lastKey = (Long)this.boundaries.lastKey();
                }
            } else {
                this.readDirect((long)(jumps[jumps.length - 1] - 20L), buffer);
                long clen = buffer.getLong();
                lastKey = buffer.getLong();
                long start = first;
                long marker = 0L;
                for (int x = 0; x < jumps.length; ++x) {
                    this.boundaries.put(marker, new BaseBufferReadbackStrategy.Marker(start, marker++, jumps[x] - start - 20L));
                    start = jumps[x];
                }
            }
        }
        finally {
            this.free(buffer);
        }
        this.length = this.getChannel().size();
        this.seal(true, lastKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateIndex() throws IOException {
        FileChannel channel = this.getChannel();
        if (this.length + 4L > this.getChannel().size()) {
            return this.isConsistent();
        }
        channel.position(this.length);
        long start = channel.position();
        ByteBuffer buffer = this.allocate(32);
        int b = buffer.position();
        int e = buffer.limit();
        int chunkStart = 0;
        try {
            try {
                this.readFully(4, buffer);
            }
            catch (IOException ioe) {
                LOGGER.warn("bad length " + this.length + " " + channel.position() + " " + channel.size());
                throw ioe;
            }
            chunkStart = buffer.getInt();
            while (SegmentHeaders.CHUNK_START.validate(chunkStart)) {
                try {
                    this.readFully(8, buffer);
                    long len = buffer.getLong();
                    channel.position(channel.position() + len);
                    this.readFully(20, buffer);
                    if (len != buffer.getLong()) {
                        throw new IOException("chunk corruption - head and tail lengths do not match");
                    }
                    long marker = buffer.getLong();
                    this.boundaries.put(marker, new BaseBufferReadbackStrategy.Marker(start, marker));
                    if (!SegmentHeaders.FILE_CHUNK.validate(buffer.getInt())) {
                        throw new IOException("chunk corruption - file chunk magic is missing");
                    }
                    start = this.getChannel().position();
                    buffer.position(b).limit(e);
                    if (channel.position() < channel.size()) {
                        this.readFully(4, buffer);
                        chunkStart = buffer.getInt();
                        continue;
                    }
                    break;
                }
                catch (IOException ioe) {
                    this.length = start;
                    break;
                }
            }
        }
        finally {
            this.free(buffer);
        }
        this.length = start;
        long lastKey = this.boundaries.isEmpty() ? Long.MIN_VALUE : (Long)this.boundaries.lastKey();
        this.seal(SegmentHeaders.CLOSE_FILE.validate(chunkStart), lastKey);
        return this.isConsistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk iterate(Direction dir) throws IOException {
        BaseBufferReadbackStrategy.VirtualChunk virtualChunk;
        block6: {
            Map.Entry<Long, BaseBufferReadbackStrategy.Marker> e;
            Long key;
            block4: {
                Chunk chunk;
                block5: {
                    key = null;
                    try {
                        Map.Entry<Long, BaseBufferReadbackStrategy.Marker> entry = e = dir == Direction.FORWARD ? this.boundaries.ceilingEntry(this.offset) : this.boundaries.floorEntry(this.offset);
                        if (e != null) break block4;
                        chunk = null;
                        if (key == null) break block5;
                        this.offset = dir == Direction.FORWARD ? key + 1L : key - 1L;
                    }
                    catch (Throwable throwable) {
                        if (key != null) {
                            this.offset = dir == Direction.FORWARD ? key + 1L : key - 1L;
                        }
                        throw throwable;
                    }
                }
                return chunk;
            }
            key = e.getKey();
            virtualChunk = e.getValue().getChunk();
            if (key == null) break block6;
            this.offset = dir == Direction.FORWARD ? key + 1L : key - 1L;
        }
        return virtualChunk;
    }

    @Override
    public boolean hasMore(Direction dir) throws IOException {
        try {
            return dir == Direction.FORWARD ? this.getMaximumMarker() >= this.offset : (Long)this.boundaries.firstKey() <= this.offset;
        }
        catch (NoSuchElementException no) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk scan(long marker) throws IOException {
        Lock lock = null;
        try {
            Map.Entry<Long, BaseBufferReadbackStrategy.Marker> m;
            if (!this.isConsistent()) {
                lock = this.block.readLock();
                lock.lock();
                while (marker > this.getMaximumMarker() && !this.isConsistent()) {
                    lock.unlock();
                    ReentrantReadWriteLock.WriteLock writer = this.block.writeLock();
                    try {
                        writer.lock();
                        this.updateIndex();
                    }
                    finally {
                        writer.unlock();
                        lock.lock();
                    }
                }
            }
            if ((m = this.boundaries.ceilingEntry(marker)) == null) {
                Chunk chunk = null;
                return chunk;
            }
            BaseBufferReadbackStrategy.VirtualChunk virtualChunk = m.getValue().getChunk();
            return virtualChunk;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }
}

